/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.dataobject;

import android.content.ContentValues;
import android.content.Context;
import android.text.TextUtils;
import android.text.format.Time;
import com.amazon.identity.auth.device.dataobject.AbstractDataObject;
import com.amazon.identity.auth.device.datastore.AuthorizationTokenDataSource;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.token.AbstractToken;
import com.amazon.identity.auth.device.token.Token;
import com.amazon.identity.auth.device.utils.MAPLog;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class AuthorizationToken
extends AbstractDataObject
implements Token {
    private static final int PRE_EXPIRATION_PERIOD = 300;
    private static final String LOG_TAG = AuthorizationToken.class.getName();
    public static final String[] ALL_COLUMNS = new String[]{"Id", "AppId", "Token", "CreationTime", "ExpirationTime", "MiscData", "type", "directedId"};
    protected String mAppFamilyId;
    protected String mTokenValue;
    protected Date mCreationTime;
    protected Date mExpirationTime;
    protected byte[] mMiscData;
    protected AUTHZ_TOKEN_TYPE mType;
    private String mDirectedId;

    public AuthorizationToken(String appId, String directedId, String tokenValue, Date creationTime, Date expirationTime, byte[] miscData, AUTHZ_TOKEN_TYPE type) {
        this.mAppFamilyId = appId;
        this.mTokenValue = tokenValue;
        this.mCreationTime = DatabaseHelper.truncateFractionalSeconds(creationTime);
        this.mExpirationTime = DatabaseHelper.truncateFractionalSeconds(expirationTime);
        this.mMiscData = miscData;
        this.mType = type;
        this.mDirectedId = directedId;
    }

    public AuthorizationToken() {
    }

    public long getId() {
        return this.getRowId();
    }

    public String getAppFamilyId() {
        return this.mAppFamilyId;
    }

    public String getTokenValue() {
        return this.mTokenValue;
    }

    public Date getCreationTime() {
        return this.mCreationTime;
    }

    public Date getExpirationTime() {
        return this.mExpirationTime;
    }

    public byte[] getMiscData() {
        return this.mMiscData;
    }

    public void setId(long id) {
        this.setRowId(id);
    }

    public void setAppFamilyId(String appId) {
        this.mAppFamilyId = appId;
    }

    public void setTokenValue(String tokenValue) {
        this.mTokenValue = tokenValue;
    }

    @Override
    public String getType() {
        return this.mType.toString();
    }

    public AUTHZ_TOKEN_TYPE getTypeAsEnum() {
        return this.mType;
    }

    @Override
    public String getDirectedId() {
        return this.mDirectedId;
    }

    public void setDirectedId(String mDirectedId) {
        this.mDirectedId = mDirectedId;
    }

    public void setCreationTime(Date creationTime) {
        this.mCreationTime = DatabaseHelper.truncateFractionalSeconds(creationTime);
    }

    public void setExpirationTime(Date expirationTime) {
        this.mExpirationTime = DatabaseHelper.truncateFractionalSeconds(expirationTime);
    }

    public void setMiscData(byte[] miscData) {
        this.mMiscData = miscData;
    }

    public boolean isRemainingLifeAcceptable() {
        long currentLifeRemaining = this.mExpirationTime.getTime() - Calendar.getInstance().getTimeInMillis();
        return currentLifeRemaining >= AbstractToken.secsToMillis(300L);
    }

    @Override
    public ContentValues getValuesForInsert() {
        ContentValues to_return = new ContentValues();
        to_return.put(ALL_COLUMNS[COL_INDEX.APP_ID.colId], this.mAppFamilyId);
        to_return.put(ALL_COLUMNS[COL_INDEX.TOKEN.colId], this.mTokenValue);
        to_return.put(ALL_COLUMNS[COL_INDEX.CREATION_TIME.colId], DatabaseHelper.ISO8601.format(this.mCreationTime));
        to_return.put(ALL_COLUMNS[COL_INDEX.EXPIRATION_TIME.colId], DatabaseHelper.ISO8601.format(this.mExpirationTime));
        to_return.put(ALL_COLUMNS[COL_INDEX.MISC_DATA.colId], this.mMiscData);
        to_return.put(ALL_COLUMNS[COL_INDEX.TYPE.colId], Integer.valueOf(this.mType.ordinal()));
        to_return.put(ALL_COLUMNS[COL_INDEX.DIRECTED_ID.colId], this.mDirectedId);
        return to_return;
    }

    public AuthorizationTokenDataSource getDataSource(Context context) {
        return AuthorizationTokenDataSource.getInstance(context);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof AuthorizationToken) {
            try {
                AuthorizationToken token = (AuthorizationToken)obj;
                return TextUtils.equals((CharSequence)this.mAppFamilyId, (CharSequence)token.getAppFamilyId()) && TextUtils.equals((CharSequence)this.mTokenValue, (CharSequence)token.getTokenValue()) && this.areObjectsEqual(this.mCreationTime, token.getCreationTime()) && this.areObjectsEqual(this.mExpirationTime, token.getExpirationTime()) && TextUtils.equals((CharSequence)this.getType(), (CharSequence)token.getType()) && TextUtils.equals((CharSequence)this.mDirectedId, (CharSequence)token.getDirectedId());
            }
            catch (NullPointerException e) {
                MAPLog.e(LOG_TAG, "" + e.toString());
                return false;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.mTokenValue;
    }

    public String toLogString() {
        return "{ rowid=" + this.getId() + ", appId=" + this.mAppFamilyId + ", token=" + this.mTokenValue + ", creationTime=" + DatabaseHelper.ISO8601.format(this.mCreationTime) + ", expirationTime=" + DatabaseHelper.ISO8601.format(this.mExpirationTime) + ", type=" + this.mType.toString() + ", directedId=<obscured> }";
    }

    @Override
    public Time getLocalTimestamp() {
        Time time = new Time();
        time.set(this.mCreationTime.getTime());
        return time;
    }

    @Override
    public Map<String, String> getData() {
        HashMap<String, String> results = new HashMap<String, String>();
        String str = null;
        try {
            str = new String(this.mMiscData, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            MAPLog.i(LOG_TAG, "unable to parse misc data");
        }
        if (str != null) {
            String[] data = str.split(",");
            int length = data.length;
            if (length % 2 == 0) {
                for (int i = 0; i < length; i += 2) {
                    results.put(data[i], data[i + 1]);
                }
            } else {
                MAPLog.i(LOG_TAG, "unable to parse misc data, key/value pairs do not match");
            }
        }
        return results;
    }

    public static enum AUTHZ_TOKEN_TYPE {
        ACCESS("com.amazon.identity.token.accessToken"),
        REFRESH("com.amazon.identity.token.refreshToken");

        private final String mType;

        private AUTHZ_TOKEN_TYPE(String type) {
            this.mType = type;
        }

        public String toString() {
            return this.mType;
        }
    }

    public static enum COL_INDEX {
        ID(0),
        APP_ID(1),
        TOKEN(2),
        CREATION_TIME(3),
        EXPIRATION_TIME(4),
        MISC_DATA(5),
        TYPE(6),
        DIRECTED_ID(7);

        public final int colId;

        private COL_INDEX(int colId) {
            this.colId = colId;
        }
    }
}

