/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.AmazonAuthorizationServiceInterface;
import com.amazon.identity.auth.device.authorization.ThirdPartyServiceHelper;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AuthorizationToken;
import com.amazon.identity.auth.device.dataobject.RequestedScope;
import com.amazon.identity.auth.device.datastore.AuthorizationTokenDataSource;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.datastore.ProfileDataSource;
import com.amazon.identity.auth.device.datastore.RequestedScopeDataSource;
import com.amazon.identity.auth.device.endpoint.ServerCommunication;
import com.amazon.identity.auth.device.token.AccessAtzToken;
import com.amazon.identity.auth.device.token.RefreshAtzToken;
import com.amazon.identity.auth.device.utils.MAPLog;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public final class TokenVendor {
    private static final String LOG_TAG = TokenVendor.class.getName();
    private ServerCommunication mServerCommunication = new ServerCommunication();

    public void setServerCommunication(ServerCommunication serverCommunication) {
        this.mServerCommunication = serverCommunication;
    }

    public String vendToken(String clientId, String directedId, String appId, String[] scopes, String packageName, Context context) throws IOException, AuthError {
        MAPLog.pii(LOG_TAG, "Vending out token: appId=" + appId + ", scopes=" + Arrays.toString(scopes), "directedId=" + directedId);
        assert (scopes != null && scopes.length > 0);
        RequestedScope[] requestedScopes = this.getRequestedScopes(directedId, appId, scopes, context);
        AccessAtzToken commonAccessToken = TokenVendor.getCommonAccessToken(requestedScopes, context);
        RefreshAtzToken commonRefreshToken = TokenVendor.getCommonRefreshToken(requestedScopes, context);
        if (commonAccessToken != null && commonAccessToken.isRemainingLifeAcceptable()) {
            MAPLog.i(LOG_TAG, "Common token still has acceptable life, returning it back to caller");
            return commonAccessToken.getTokenValue();
        }
        return this.updateExistingToken(commonRefreshToken, directedId, clientId, appId, scopes, commonAccessToken, packageName, context);
    }

    public RequestedScope[] getRequestedScopes(String directedId, String appId, String[] scopes, Context context) {
        RequestedScope[] requestedScopes = new RequestedScope[scopes.length];
        for (int i = 0; i < requestedScopes.length; ++i) {
            RequestedScope rs = RequestedScopeDataSource.getInstance(context).findByPrimaryKey(scopes[i], appId, directedId);
            if (rs != null) {
                requestedScopes[i] = rs;
                continue;
            }
            MAPLog.w(LOG_TAG, "RequestedScope shouldn't be null!!!! - " + rs + ", but continuing anyway...");
            requestedScopes[i] = new RequestedScope(scopes[i], appId, directedId);
        }
        return requestedScopes;
    }

    public List<RequestedScope> getCachedScopes(String directedId, String appId, Context context) {
        List<RequestedScope> cachedScopes = RequestedScopeDataSource.getInstance(context).findAllRows();
        return cachedScopes;
    }

    public String vendNewToken(String directedId, String clientId, String appId, String[] scopes, Context context) throws IOException, AuthError {
        assert (scopes != null && scopes.length > 0);
        MAPLog.i(LOG_TAG, "Vending new token");
        AuthorizationTokenDataSource atzTokenDataSource = AuthorizationTokenDataSource.getInstance(context);
        RequestedScope[] requestedScopes = this.getRequestedScopes(directedId, appId, scopes, context);
        RefreshAtzToken commonRefreshToken = TokenVendor.getCommonRefreshToken(requestedScopes, context);
        if (commonRefreshToken != null) {
            AuthorizationToken[] newTokens = this.mServerCommunication.getAuthorizationTokens(commonRefreshToken, directedId, appId, scopes, clientId, context);
            if (newTokens[1] != null) {
                newTokens[1].setRowId(commonRefreshToken.getRowId());
                this.updateExistingRefreshToken(newTokens[1], commonRefreshToken, context);
                commonRefreshToken = (RefreshAtzToken)newTokens[1];
            }
            if (newTokens[0] != null) {
                TokenVendor.insertNewToken(context, atzTokenDataSource, requestedScopes, commonRefreshToken, newTokens[0]);
                return newTokens[0].getTokenValue();
            }
            MAPLog.e(LOG_TAG, "Token returned from Exchange was null. Clearing authorization state");
            DatabaseHelper.clearAuthorizationState(context);
        }
        return null;
    }

    private static void insertNewToken(Context context, AuthorizationTokenDataSource atzTokenDataSource, RequestedScope[] requestedScopes, RefreshAtzToken commonRefreshToken, AuthorizationToken newToken) throws IOException {
        if (newToken.insert(context) == -1L) {
            throw new IOException("Inserting token " + newToken + " failed unexpectedly!");
        }
        MAPLog.i(LOG_TAG, "Inserted new token: rowid=" + newToken.getRowId());
        for (RequestedScope rs : requestedScopes) {
            if (rs.getRowId() == -1L) {
                rs.setAuthorizationAccessTokenId(newToken.getRowId());
                rs.setAuthorizationRefreshTokenId(commonRefreshToken.getRowId());
                MAPLog.i(LOG_TAG, "Inserting " + rs + " : rowid=" + rs.insert(context));
                continue;
            }
            AuthorizationToken oldAccessToken = (AuthorizationToken)atzTokenDataSource.findByRowId(rs.getAuthorizationAccessTokenId());
            if (oldAccessToken != null) {
                MAPLog.pii(LOG_TAG, "Deleting old access token.", "accessAtzToken=" + oldAccessToken + " : " + oldAccessToken.delete(context));
            }
            rs.setAuthorizationAccessTokenId(newToken.getRowId());
            MAPLog.i(LOG_TAG, "Updating " + rs + " : " + rs.update(context));
            AuthorizationToken oldRefreshToken = (AuthorizationToken)atzTokenDataSource.findByRowId(rs.getAuthorizationRefreshTokenId());
            if (oldRefreshToken != null) {
                MAPLog.pii(LOG_TAG, "Deleting old refresh token.", "refreshAtzToken=" + oldRefreshToken + " : " + oldRefreshToken.delete(context));
            }
            rs.setAuthorizationAccessTokenId(newToken.getRowId());
            MAPLog.i(LOG_TAG, "Updating " + rs + " : " + rs.update(context));
        }
    }

    public Bundle vendNewTokensFromCode(String code, String clientId, String appId, String redirectUri, String[] scopes, Context context) throws IOException, AuthError {
        assert (scopes != null && scopes.length > 0);
        MAPLog.i(LOG_TAG, "Vending new tokens from Code");
        AuthorizationToken[] tokens = this.mServerCommunication.getTokensFromCode(code, clientId, redirectUri, appId, scopes, context);
        if (tokens == null) {
            AuthError authError = new AuthError("No tokens returned", AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
            return new Bundle(AuthError.getErrorBundle(authError));
        }
        AccessAtzToken accessAtzToken = (AccessAtzToken)tokens[0];
        if (accessAtzToken == null) {
            AuthError authError = new AuthError("Access Atz token was null form ServerCommunication", AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
            return new Bundle(AuthError.getErrorBundle(authError));
        }
        if (accessAtzToken.insert(context) == -1L) {
            AuthError authError = new AuthError("Unable to insert access atz token into db", AuthError.ERROR_TYPE.ERROR_DATA_STORAGE);
            return new Bundle(AuthError.getErrorBundle(authError));
        }
        RefreshAtzToken refreshAtzToken = (RefreshAtzToken)tokens[1];
        if (refreshAtzToken == null) {
            AuthError authError = new AuthError("access token was null form ServerCommunication", AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
            return new Bundle(AuthError.getErrorBundle(authError));
        }
        if (refreshAtzToken.insert(context) == -1L) {
            AuthError authError = new AuthError("Unable to insert refresh token into db", AuthError.ERROR_TYPE.ERROR_DATA_STORAGE);
            return new Bundle(AuthError.getErrorBundle(authError));
        }
        this.updateRequestedScopes(appId, scopes, context, accessAtzToken, refreshAtzToken);
        Bundle results = new Bundle();
        results.putString(AuthzConstants.BUNDLE_KEY.AUTHORIZE.val, "authorized");
        return results;
    }

    private void updateRequestedScopes(String appId, String[] scopes, Context context, AccessAtzToken accessAtzToken, RefreshAtzToken refeshAtzToken) {
        RequestedScope[] requestedScopes;
        for (RequestedScope rs : requestedScopes = this.getRequestedScopes(null, appId, scopes, context)) {
            if (rs.getRowId() == -1L) {
                rs.setAuthorizationAccessTokenId(accessAtzToken.getRowId());
                rs.setAuthorizationRefreshTokenId(refeshAtzToken.getRowId());
                MAPLog.i(LOG_TAG, "Inserting " + rs + " : rowid=" + rs.insert(context));
                continue;
            }
            AuthorizationToken oldAccessToken = (AuthorizationToken)accessAtzToken.getDataSource(context).findByRowId(rs.getAuthorizationAccessTokenId());
            if (oldAccessToken != null) {
                MAPLog.pii(LOG_TAG, "Deleting old access token.", "accessAtzToken=" + oldAccessToken + " : " + oldAccessToken.delete(context));
            }
            rs.setAuthorizationAccessTokenId(accessAtzToken.getRowId());
            AuthorizationToken oldRefreshToken = (AuthorizationToken)refeshAtzToken.getDataSource(context).findByRowId(rs.getAuthorizationRefreshTokenId());
            if (oldRefreshToken != null) {
                MAPLog.pii(LOG_TAG, "Deleting old refresh token ", "refreshAtzToken=" + oldRefreshToken + " : " + oldRefreshToken.delete(context));
            }
            rs.setAuthorizationRefreshTokenId(refeshAtzToken.getRowId());
            MAPLog.i(LOG_TAG, "Updating " + rs + " : " + rs.update(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String updateExistingToken(RefreshAtzToken refreshAtzToken, String directedId, String clientId, String appId, String[] scopes, AccessAtzToken accessAtzToken, String packageName, Context context) throws IOException, AuthError {
        MAPLog.pii(LOG_TAG, "Updating existing token", "token=" + accessAtzToken);
        AuthorizationToken newAccessToken = null;
        try {
            if (refreshAtzToken != null) {
                AuthorizationToken[] newTokens = this.mServerCommunication.getAuthorizationTokens(refreshAtzToken, directedId, appId, scopes, clientId, context);
                newAccessToken = newTokens[0];
                if (newTokens[1] != null) {
                    MAPLog.pii(LOG_TAG, "Refresh token", "token=" + refreshAtzToken);
                    this.updateExistingRefreshToken(newTokens[1], refreshAtzToken, context);
                    refreshAtzToken = (RefreshAtzToken)newTokens[1];
                }
                if (newAccessToken != null) {
                    MAPLog.pii(LOG_TAG, "Refreshed token", "token=" + accessAtzToken);
                    boolean updateScopes = false;
                    if (accessAtzToken != null) {
                        newAccessToken.setRowId(accessAtzToken.getRowId());
                    } else {
                        updateScopes = true;
                    }
                    ProfileDataSource.getInstance(context).deleteAllRows();
                    if (!newAccessToken.insertOrUpdate(context)) throw new IOException("Updating token failed unexpectedly!");
                    if (updateScopes) {
                        this.updateRequestedScopes(appId, scopes, context, (AccessAtzToken)newAccessToken, refreshAtzToken);
                    }
                    MAPLog.i(LOG_TAG, "Update success!");
                }
            } else {
                AmazonAuthorizationServiceInterface service = ThirdPartyServiceHelper.getRemoteAndroidService(context);
                if (service != null) {
                    DatabaseHelper.clearAuthorizationState(context);
                    newAccessToken = TokenVendor.getTokenFromService(context, refreshAtzToken, directedId, clientId, appId, scopes, packageName, service);
                }
            }
        }
        finally {
            ThirdPartyServiceHelper.unbind(context);
        }
        if (newAccessToken == null) return null;
        return newAccessToken.getTokenValue();
    }

    private static AuthorizationToken getTokenFromService(Context context, RefreshAtzToken refreshAtzToken, String directedId, String clientId, String appId, String[] scopes, String packageName, AmazonAuthorizationServiceInterface service) throws AuthError {
        AccessAtzToken newToken = null;
        try {
            Bundle result = service.getToken(null, packageName, scopes);
            if (result != null) {
                result.setClassLoader(context.getClassLoader());
                String tokenFromService = result.getString("accessAtzToken");
                if (!TextUtils.isEmpty((CharSequence)tokenFromService)) {
                    Long expiresIn = result.getLong("accessAtzToken.expiries_in");
                    newToken = new AccessAtzToken(appId, directedId, tokenFromService, new Date(), expiresIn, null);
                } else {
                    AuthError authError = (AuthError)result.getParcelable("AUTH_ERROR_EXECEPTION");
                    if (authError != null && AuthError.ERROR_TYPE.ERROR_INVALID_TOKEN == authError.getType()) {
                        MAPLog.e(LOG_TAG, "Invalid token given to the service. Cleaning up local state");
                    } else {
                        if (authError != null) {
                            MAPLog.i(LOG_TAG, "AuthError from service " + authError.getMessage());
                            ThirdPartyServiceHelper.clearCachedService(context);
                            throw authError;
                        }
                        MAPLog.i(LOG_TAG, "No results from service");
                    }
                }
            }
        }
        catch (RemoteException e) {
            ThirdPartyServiceHelper.clearCachedService(context);
            MAPLog.i(LOG_TAG, "RemoteException on getToken. " + e.getMessage());
        }
        return newToken;
    }

    private static AccessAtzToken getCommonAccessToken(RequestedScope[] requestedScopes, Context context) {
        MAPLog.i(LOG_TAG, "Try finding a common access token for requested scopes");
        assert (requestedScopes != null && requestedScopes.length > 0);
        AuthorizationTokenDataSource atzDataSource = AuthorizationTokenDataSource.getInstance(context);
        AccessAtzToken to_return = (AccessAtzToken)atzDataSource.findById(requestedScopes[0].getAuthorizationAccessTokenId());
        if (to_return == null) {
            return null;
        }
        for (int i = 1; i < requestedScopes.length; ++i) {
            AuthorizationToken tmp = atzDataSource.findById(requestedScopes[i].getAuthorizationAccessTokenId());
            if (tmp != null && tmp.getRowId() == to_return.getRowId()) continue;
            MAPLog.i(LOG_TAG, "Common access token not found!");
            return null;
        }
        MAPLog.pii(LOG_TAG, "Common access token found.", "accessAtzToken=" + to_return);
        return to_return;
    }

    private static RefreshAtzToken getCommonRefreshToken(RequestedScope[] requestedScopes, Context context) {
        MAPLog.i(LOG_TAG, "Try finding a common refresh token for requested scopes");
        assert (requestedScopes != null && requestedScopes.length > 0);
        AuthorizationTokenDataSource atzDataSource = AuthorizationTokenDataSource.getInstance(context);
        RefreshAtzToken to_return = (RefreshAtzToken)atzDataSource.findById(requestedScopes[0].getAuthorizationRefreshTokenId());
        if (to_return == null) {
            return null;
        }
        for (int i = 1; i < requestedScopes.length; ++i) {
            AuthorizationToken tmp = atzDataSource.findById(requestedScopes[i].getAuthorizationRefreshTokenId());
            if (tmp != null && tmp.getRowId() == to_return.getRowId()) continue;
            MAPLog.i(LOG_TAG, "Common refresh token not found!");
            return null;
        }
        MAPLog.pii(LOG_TAG, "Common refresh token found.", "refreshAtzToken=" + to_return);
        return to_return;
    }

    public void insertTokens(Context context, AccessAtzToken accessAtzToken, RefreshAtzToken refreshAtzToken, String directedId, String appId, String[] scopes) throws AuthError {
        long accessTokenRowId = accessAtzToken.insert(context);
        if (accessTokenRowId == -1L) {
            throw new AuthError("Unable to insert access atz token into db", AuthError.ERROR_TYPE.ERROR_DATA_STORAGE);
        }
        accessAtzToken.setId(accessTokenRowId);
        long refreshTokenRowId = refreshAtzToken.insert(context);
        if (refreshTokenRowId == -1L) {
            throw new AuthError("Unable to insert refresh token into db", AuthError.ERROR_TYPE.ERROR_DATA_STORAGE);
        }
        refreshAtzToken.setId(refreshTokenRowId);
        this.updateRequestedScopes(appId, scopes, context, accessAtzToken, refreshAtzToken);
    }

    public void updateExistingRefreshToken(AuthorizationToken newToken, AuthorizationToken existingToken, Context context) throws IOException {
        newToken.setRowId(existingToken.getRowId());
        if (!newToken.update(context)) {
            throw new IOException("Updating token failed unexpectedly!");
        }
    }
}

