/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.token;

import android.text.TextUtils;
import android.text.format.Time;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.token.AbstractToken;
import com.amazon.identity.auth.device.utils.MAPLog;
import java.util.Map;

public class AccessToken
extends AbstractToken {
    private static final String LOG_TAG = AccessToken.class.getName();
    private static final String KEY_EXPIRES_IN = "expires_in";
    public static final long NEVER_EXPIRE = 0L;
    public static final long ALWAYS_EXPIRE = -1L;
    protected static final long PRE_EXPIRATION_PERIOD = 300L;
    private long _expiresIn = 0L;
    private Time _expirationTime;

    public AccessToken(String token, String directedId) {
        this(token, directedId, 0L);
    }

    public AccessToken(String token, String directedId, long expiresIn) {
        super(token);
        MAPLog.pii(LOG_TAG, "Creating Token " + this.getType() + "expiresIn=" + expiresIn, "directedId=" + directedId);
        if (!TextUtils.isEmpty((CharSequence)directedId)) {
            this.tokenData.put("directedid", directedId);
        }
        this.initExpirationData(expiresIn);
    }

    public AccessToken(Map<String, String> tokenData) throws AuthError {
        super(tokenData);
        long expiresIn;
        if (!tokenData.containsKey("directedid")) {
            MAPLog.i(LOG_TAG, "No DirectedId available for AccessToken");
            throw new AuthError("No DirectedId available for AccessToken", null, AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
        }
        String expiresInStr = tokenData.get(KEY_EXPIRES_IN);
        if (null == expiresInStr) {
            MAPLog.w(LOG_TAG, "expires_in not found in token data when creating AccessToken, token will not expire locally");
            expiresIn = 0L;
            tokenData.put(KEY_EXPIRES_IN, String.valueOf(0L));
        } else {
            try {
                expiresIn = Long.parseLong(expiresInStr);
            }
            catch (NumberFormatException e) {
                MAPLog.e(LOG_TAG, "Unable to parse expires_in from token data when creating AccessToken, token will not expire locally");
                expiresIn = 0L;
                tokenData.put(KEY_EXPIRES_IN, String.valueOf(0L));
            }
        }
        MAPLog.pii(LOG_TAG, "Creating Token " + this.getType() + " from data expires=" + expiresIn, "directedId=" + this.getDirectedId());
        this.setExpirationTime(expiresIn);
    }

    protected void setExpirationTime(long expiresIn) {
        this._expiresIn = expiresIn;
        if (expiresIn == 0L) {
            this._expirationTime = null;
        } else if (expiresIn <= -1L) {
            this._expiresIn = -1L;
            this._expirationTime = null;
        } else {
            this._expirationTime = new Time();
            long expireAt = this.getLocalTimestamp().toMillis(false) + AccessToken.secsToMillis(expiresIn) - AccessToken.secsToMillis(this.getPreExpirationPeriod());
            this._expirationTime.set(expireAt);
        }
        MAPLog.i(LOG_TAG, "Expiration Time:" + this._expirationTime);
    }

    public boolean hasExpired() {
        if (0L == this.getExpiresIn()) {
            return false;
        }
        if (-1L == this.getExpiresIn()) {
            return true;
        }
        Time currentTime = this.getCurrentTime();
        return Time.compare((Time)currentTime, (Time)this._expirationTime) >= 0;
    }

    public boolean neverExpire() {
        return 0L == this.getExpiresIn();
    }

    private void initExpirationData(long expiresIn) {
        this.setExpirationTime(expiresIn);
        this.tokenData.put(KEY_EXPIRES_IN, String.valueOf(expiresIn));
    }

    protected Time getCurrentTime() {
        Time currentTime = new Time();
        currentTime.setToNow();
        return currentTime;
    }

    protected long getPreExpirationPeriod() {
        return 300L;
    }

    @Override
    public String getType() {
        return "com.amazon.identity.token.accessToken";
    }

    @Override
    public String toString() {
        return this.getToken();
    }

    public long getExpiresIn() {
        return this._expiresIn;
    }
}

