/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2;

import com.dropbox.client2.DropboxAPI;
import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.exception.DropboxIOException;
import com.dropbox.client2.exception.DropboxParseException;
import com.dropbox.client2.exception.DropboxProxyChangeException;
import com.dropbox.client2.exception.DropboxSSLException;
import com.dropbox.client2.exception.DropboxServerException;
import com.dropbox.client2.exception.DropboxUnlinkedException;
import com.dropbox.client2.session.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTUtility {
    private static final DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy kk:mm:ss ZZZZZ", Locale.US);

    private RESTUtility() {
    }

    public static Object request(RequestMethod method, String host, String path, int apiVersion, String[] params, Session session) throws DropboxException {
        HttpResponse resp = RESTUtility.streamRequest((RequestMethod)method, (String)host, (String)path, (int)apiVersion, (String[])params, (Session)session).response;
        return RESTUtility.parseAsJSON(resp);
    }

    public static DropboxAPI.RequestAndResponse streamRequest(RequestMethod method, String host, String path, int apiVersion, String[] params, Session session) throws DropboxException {
        HttpGet req;
        if (method == RequestMethod.GET) {
            String target = RESTUtility.buildURL(host, apiVersion, path, params);
            req = new HttpGet(target);
        } else {
            String target = RESTUtility.buildURL(host, apiVersion, path, null);
            HttpPost post = new HttpPost(target);
            if (params != null && params.length >= 2) {
                if (params.length % 2 != 0) {
                    throw new IllegalArgumentException("Params must have an even number of elements.");
                }
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                for (int i = 0; i < params.length; i += 2) {
                    if (params[i + 1] == null) continue;
                    nvps.add(new BasicNameValuePair(params[i], params[i + 1]));
                }
                try {
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new DropboxException(e);
                }
            }
            req = post;
        }
        session.sign((HttpRequest)req);
        HttpResponse resp = RESTUtility.execute(session, (HttpUriRequest)req);
        return new DropboxAPI.RequestAndResponse((HttpUriRequest)req, resp);
    }

    public static Object parseAsJSON(HttpResponse response) throws DropboxException {
        Object result = null;
        BufferedReader bin = null;
        try {
            HttpEntity ent = response.getEntity();
            if (ent != null) {
                InputStreamReader in = new InputStreamReader(ent.getContent());
                bin = new BufferedReader(in, 16384);
                bin.mark(16384);
                JSONParser parser = new JSONParser();
                result = parser.parse((Reader)bin);
            }
        }
        catch (IOException e) {
            throw new DropboxIOException(e);
        }
        catch (ParseException e) {
            if (DropboxServerException.isValidWithNullBody(response)) {
                throw new DropboxServerException(response);
            }
            throw new DropboxParseException(bin);
        }
        catch (OutOfMemoryError e) {
            throw new DropboxException(e);
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException e) {}
            }
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            if (statusCode == 401) {
                throw new DropboxUnlinkedException();
            }
            throw new DropboxServerException(response, result);
        }
        return result;
    }

    public static Map<String, String> parseAsQueryString(HttpResponse response) throws DropboxException {
        Scanner scanner;
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new DropboxParseException("Bad response from Dropbox.");
        }
        try {
            scanner = new Scanner(entity.getContent()).useDelimiter("&");
        }
        catch (IOException e) {
            throw new DropboxIOException(e);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        while (scanner.hasNext()) {
            String nameValue = scanner.next();
            String[] parts = nameValue.split("=");
            if (parts.length != 2) {
                throw new DropboxParseException("Bad query string from Dropbox.");
            }
            result.put(parts[0], parts[1]);
        }
        return result;
    }

    public static HttpResponse execute(Session session, HttpUriRequest req) throws DropboxException {
        return RESTUtility.execute(session, req, -1);
    }

    public static HttpResponse execute(Session session, HttpUriRequest req, int socketTimeoutOverrideMs) throws DropboxException {
        HttpClient client = RESTUtility.updatedHttpClient(session);
        session.setRequestTimeout(req);
        if (socketTimeoutOverrideMs >= 0) {
            HttpParams reqParams = req.getParams();
            HttpConnectionParams.setSoTimeout((HttpParams)reqParams, (int)socketTimeoutOverrideMs);
        }
        boolean repeatable = RESTUtility.isRequestRepeatable((HttpRequest)req);
        try {
            HttpResponse response = null;
            for (int retries = 0; retries < 5; ++retries) {
                try {
                    response = client.execute(req);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                if (response != null) break;
                RESTUtility.updateClientProxy(client, session);
                if (repeatable) continue;
                throw new DropboxProxyChangeException();
            }
            if (response == null) {
                throw new DropboxIOException("Apache HTTPClient encountered an error. No response, try again.");
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200 && statusCode != 206) {
                RESTUtility.parseAsJSON(response);
            }
            return response;
        }
        catch (SSLException e) {
            throw new DropboxSSLException(e);
        }
        catch (IOException e) {
            throw new DropboxIOException(e);
        }
        catch (OutOfMemoryError e) {
            throw new DropboxException(e);
        }
    }

    private static boolean isRequestRepeatable(HttpRequest req) {
        HttpEntityEnclosingRequest ereq;
        HttpEntity entity;
        return !(req instanceof HttpEntityEnclosingRequest) || (entity = (ereq = (HttpEntityEnclosingRequest)req).getEntity()) == null || entity.isRepeatable();
    }

    public static String buildURL(String host, int apiVersion, String target, String[] params) {
        if (!target.startsWith("/")) {
            target = "/" + target;
        }
        try {
            target = URLEncoder.encode("/" + apiVersion + target, "UTF-8");
            target = target.replace("%2F", "/");
            if (params != null && params.length > 0) {
                target = target + "?" + RESTUtility.urlencode(params);
            }
            target = target.replace("+", "%20").replace("*", "%2A");
        }
        catch (UnsupportedEncodingException uce) {
            return null;
        }
        return "https://" + host + ":443" + target;
    }

    public static Date parseDate(String date) {
        try {
            return dateFormat.parse(date);
        }
        catch (java.text.ParseException e) {
            return null;
        }
    }

    private static synchronized HttpClient updatedHttpClient(Session session) {
        HttpClient client = session.getHttpClient();
        RESTUtility.updateClientProxy(client, session);
        return client;
    }

    private static void updateClientProxy(HttpClient client, Session session) {
        Session.ProxyInfo proxyInfo = session.getProxyInfo();
        if (proxyInfo != null && proxyInfo.host != null && !proxyInfo.host.equals("")) {
            HttpHost proxy = proxyInfo.port < 0 ? new HttpHost(proxyInfo.host) : new HttpHost(proxyInfo.host, proxyInfo.port);
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        } else {
            client.getParams().removeParameter("http.route.default-proxy");
        }
    }

    private static String urlencode(String[] params) {
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("Params must have an even number of elements.");
        }
        String result = "";
        try {
            boolean firstTime = true;
            for (int i = 0; i < params.length; i += 2) {
                if (params[i + 1] == null) continue;
                if (firstTime) {
                    firstTime = false;
                } else {
                    result = result + "&";
                }
                result = result + URLEncoder.encode(params[i], "UTF-8") + "=" + URLEncoder.encode(params[i + 1], "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestMethod {
        GET,
        POST;

    }
}

