/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class SecureSSLSocketFactory
extends org.apache.http.conn.ssl.SSLSocketFactory {
    private static final String[] sAllowedCipherSuites = new String[]{"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "ECDHE-RSA-AES256-GCM-SHA384", "ECDHE-RSA-AES256-SHA384", "ECDHE-RSA-AES256-SHA", "ECDHE-RSA-AES128-GCM-SHA256", "ECDHE-RSA-AES128-SHA256", "ECDHE-RSA-AES128-SHA", "ECDHE-RSA-RC4-SHA", "DHE-RSA-AES256-GCM-SHA384", "DHE-RSA-AES256-SHA256", "DHE-RSA-AES256-SHA", "DHE-RSA-AES128-GCM-SHA256", "DHE-RSA-AES128-SHA256", "DHE-RSA-AES128-SHA", "AES256-GCM-SHA384", "AES256-SHA256", "AES256-SHA", "AES128-GCM-SHA256", "AES128-SHA256", "AES128-SHA"};
    private final SSLSocketFactory mSSLSocketFactory;
    private static final byte[] sRootKeyStoreBytes = SecureSSLSocketFactory.GetRootKeyStoreBytes();

    public SecureSSLSocketFactory() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        super((KeyStore)null);
        KeyStore keyStore = this.loadKeyStore();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
        tmf.init(keyStore);
        TrustManager[] trustManagers = tmf.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustManagers, null);
        this.mSSLSocketFactory = sslContext.getSocketFactory();
    }

    public Socket createSocket() throws IOException {
        Socket socket = this.mSSLSocketFactory.createSocket();
        this.setSSLParameters((SSLSocket)socket);
        return socket;
    }

    public Socket connectSocket(Socket socket, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
        SSLSocket sslSocket = (SSLSocket)(socket != null ? socket : this.createSocket());
        this.setSSLParameters(sslSocket);
        if (localAddress != null || localPort > 0) {
            if (localPort < 0) {
                localPort = 0;
            }
            sslSocket.bind(new InetSocketAddress(localAddress, localPort));
        }
        int connTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        int soTimeout = HttpConnectionParams.getSoTimeout((HttpParams)params);
        InetSocketAddress remoteAddress = new InetSocketAddress(host, port);
        sslSocket.connect(remoteAddress, connTimeout);
        sslSocket.setSoTimeout(soTimeout);
        try {
            org.apache.http.conn.ssl.SSLSocketFactory.STRICT_HOSTNAME_VERIFIER.verify(host, sslSocket);
        }
        catch (IOException iox) {
            try {
                sslSocket.close();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw iox;
        }
        return sslSocket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        if (port == -1) {
            port = 443;
        }
        SSLSocket sslSocket = (SSLSocket)this.mSSLSocketFactory.createSocket(socket, host, port, autoClose);
        this.setSSLParameters(sslSocket);
        try {
            org.apache.http.conn.ssl.SSLSocketFactory.STRICT_HOSTNAME_VERIFIER.verify(host, sslSocket);
        }
        catch (IOException iox) {
            try {
                sslSocket.close();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw iox;
        }
        return sslSocket;
    }

    public void setHostnameVerifier(X509HostnameVerifier hostnameVerifier) {
        throw new IllegalArgumentException("Only strict hostname verification (default) is supported!");
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return org.apache.http.conn.ssl.SSLSocketFactory.STRICT_HOSTNAME_VERIFIER;
    }

    private void setSSLParameters(SSLSocket socket) throws SSLException {
        List<String> protocols = Arrays.asList(socket.getSupportedProtocols());
        if (protocols.contains("TLSv1.2")) {
            socket.setEnabledProtocols(new String[]{"TLSv1.2"});
        } else if (protocols.contains("TLSv1.0")) {
            socket.setEnabledProtocols(new String[]{"TLSv1.0"});
        } else if (protocols.contains("TLSv1")) {
            socket.setEnabledProtocols(new String[]{"TLSv1"});
        } else {
            throw new SSLException("Minimal TLS version 1 support required!");
        }
        String[] supportedCipherSuites = socket.getSupportedCipherSuites();
        ArrayList<String> allowedCipherSuitesList = new ArrayList<String>(Arrays.asList(sAllowedCipherSuites));
        List<String> supportedCipherSuitesList = Arrays.asList(supportedCipherSuites);
        allowedCipherSuitesList.retainAll(supportedCipherSuitesList);
        String[] enabledCipherSuites = allowedCipherSuitesList.toArray(new String[allowedCipherSuitesList.size()]);
        socket.setEnabledCipherSuites(enabledCipherSuites);
    }

    private KeyStore loadKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(sRootKeyStoreBytes);
        KeyStore trustStore = KeyStore.getInstance("BKS");
        trustStore.load(is, null);
        ((InputStream)is).close();
        return trustStore;
    }

    private static final byte[] GetRootKeyStoreBytes() {
        byte[][] chunks = new byte[][]{SecureSSLSocketFactory.GetRootKeyStoreBytes1(), SecureSSLSocketFactory.GetRootKeyStoreBytes2(), SecureSSLSocketFactory.GetRootKeyStoreBytes3()};
        int totalLength = 0;
        for (byte[] chunk : chunks) {
            totalLength += chunk.length;
        }
        byte[] data = new byte[totalLength];
        int i = 0;
        byte[][] arr$ = chunks;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte[] chunk;
            byte[] arr$2 = chunk = arr$[i$];
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                byte b;
                data[i] = b = arr$2[i$2];
                ++i;
            }
        }
        return data;
    }

    /*
     * Opcode count of 26752 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static final byte[] GetRootKeyStoreBytes1() {
        return new byte[]{0, 0, 0, 1, 0, 0, 0, 20, 33, 34, 91, -83, 92, 92, 33, 98, -11, -121, -60, -128, -107, 17, -80, 2, -75, -16, -74, -68, 0, 0, 7, -47, 1, 0, 23, 68, 105, 103, 105, 67, 101, 114, 116, 32, 71, 108, 111, 98, 97, 108, 32, 82, 111, 111, 116, 32, 67, 65, 0, 0, 1, 66, 22, -99, -12, 75, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 3, -77, 48, -126, 3, -81, 48, -126, 2, -105, -96, 3, 2, 1, 2, 2, 16, 8, 59, -32, 86, -112, 66, 70, -79, -95, 117, 106, -55, 89, -111, -57, 74, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, 97, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 21, 48, 19, 6, 3, 85, 4, 10, 19, 12, 68, 105, 103, 105, 67, 101, 114, 116, 32, 73, 110, 99, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 119, 119, 119, 46, 100, 105, 103, 105, 99, 101, 114, 116, 46, 99, 111, 109, 49, 32, 48, 30, 6, 3, 85, 4, 3, 19, 23, 68, 105, 103, 105, 67, 101, 114, 116, 32, 71, 108, 111, 98, 97, 108, 32, 82, 111, 111, 116, 32, 67, 65, 48, 30, 23, 13, 48, 54, 49, 49, 49, 48, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 49, 49, 49, 49, 48, 48, 48, 48, 48, 48, 48, 90, 48, 97, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 21, 48, 19, 6, 3, 85, 4, 10, 19, 12, 68, 105, 103, 105, 67, 101, 114, 116, 32, 73, 110, 99, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 119, 119, 119, 46, 100, 105, 103, 105, 99, 101, 114, 116, 46, 99, 111, 109, 49, 32, 48, 30, 6, 3, 85, 4, 3, 19, 23, 68, 105, 103, 105, 67, 101, 114, 116, 32, 71, 108, 111, 98, 97, 108, 32, 82, 111, 111, 116, 32, 67, 65, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -30, 59, -31, 17, 114, -34, -88, -92, -45, -93, 87, -86, 80, -94, -113, 11, 119, -112, -55, -94, -91, -18, 18, -50, -106, 91, 1, 9, 32, -52, 1, -109, -89, 78, 48, -73, 83, -9, 67, -60, 105, 0, 87, -99, -30, -115, 34, -35, -121, 6, 64, 0, -127, 9, -50, -50, 27, -125, -65, -33, -51, 59, 113, 70, -30, -42, 102, -57, 5, -77, 118, 39, 22, -113, 123, -98, 30, -107, 125, -18, -73, 72, -93, 8, -38, -42, -81, 122, 12, 57, 6, 101, 127, 74, 93, 31, -68, 23, -8, -85, -66, -18, 40, -41, 116, 127, 122, 120, -103, 89, -123, 104, 110, 92, 35, 50, 75, -65, 78, -64, -24, 90, 109, -29, 112, -65, 119, 16, -65, -4, 1, -10, -123, -39, -88, 68, 16, 88, 50, -87, 117, 24, -43, -47, -94, -66, 71, -30, 39, 106, -12, -102, 51, -8, 73, 8, 96, -117, -44, 95, -76, 58, -124, -65, -95, -86, 74, 76, 125, 62, -49, 79, 95, 108, 118, 94, -96, 75, 55, -111, -98, -36, 34, -26, 109, -50, 20, 26, -114, 106, -53, -2, -51, -77, 20, 100, 23, -57, 91, 41, -98, 50, -65, -14, -18, -6, -45, 11, 66, -44, -85, -73, 65, 50, -38, 12, -44, -17, -8, -127, -43, -69, -115, 88, 63, -75, 27, -24, 73, 40, -94, 112, -38, 49, 4, -35, -9, -78, 22, -14, 76, 10, 78, 7, -88, -19, 74, 61, 94, -75, 127, -93, -112, -61, -81, 39, 2, 3, 1, 0, 1, -93, 99, 48, 97, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, -122, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 3, -34, 80, 53, 86, -47, 76, -69, 102, -16, -93, -30, 27, 27, -61, -105, -78, 61, -47, 85, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 3, -34, 80, 53, 86, -47, 76, -69, 102, -16, -93, -30, 27, 27, -61, -105, -78, 61, -47, 85, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, -53, -100, 55, -86, 72, 19, 18, 10, -6, -35, 68, -100, 79, 82, -80, -12, -33, -82, 4, -11, 121, 121, 8, -93, 36, 24, -4, 75, 43, -124, -64, 45, -71, -43, -57, -2, -12, -63, 31, 88, -53, -72, 109, -100, 122, 116, -25, -104, 41, -85, 17, -75, -29, 112, -96, -95, -51, 76, -120, -103, -109, -116, -111, 112, -30, -85, 15, 28, -66, -109, -87, -1, 99, -43, -28, 7, 96, -45, -93, -65, -99, 91, 9, -15, -43, -114, -29, 83, -12, -114, 99, -6, 63, -89, -37, -76, 102, -33, 98, 102, -42, -47, 110, 65, -115, -14, 45, -75, -22, 119, 74, -97, -99, 88, -30, 43, 89, -64, 64, 35, -19, 45, 40, -126, 69, 62, 121, 84, -110, 38, -104, -32, -128, 72, -88, 55, -17, -16, -42, 121, 96, 22, -34, -84, -24, 14, -51, 110, -84, 68, 23, 56, 47, 73, -38, -31, 69, 62, 42, -71, 54, 83, -49, 58, 80, 6, -9, 46, -24, -60, 87, 73, 108, 97, 33, 24, -43, 4, -83, 120, 60, 44, 58, -128, 107, -89, -21, -81, 21, 20, -23, -40, -119, -63, -71, 56, 108, -30, -111, 108, -118, -1, 100, -71, 119, 37, 87, 48, -64, 27, 36, -93, -31, -36, -23, -33, 71, 124, -75, -76, 36, 8, 5, 48, -20, 45, -67, 11, -65, 69, -65, 80, -71, -87, -13, -21, -104, 1, 18, -83, -56, -120, -58, -104, 52, 95, -115, 10, 60, -58, -23, -43, -107, -107, 109, -34, 1, 0, 45, 71, 101, 111, 84, 114, 117, 115, 116, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 0, 0, 1, 66, 22, -98, 105, 127, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 4, 2, 48, -126, 3, -2, 48, -126, 2, -26, -96, 3, 2, 1, 2, 2, 16, 21, -84, 110, -108, 25, -78, 121, 75, 65, -10, 39, -87, -61, 24, 15, 31, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 11, 5, 0, 48, -127, -104, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 71, 101, 111, 84, 114, 117, 115, 116, 32, 73, 110, 99, 46, 49, 57, 48, 55, 6, 3, 85, 4, 11, 19, 48, 40, 99, 41, 32, 50, 48, 48, 56, 32, 71, 101, 111, 84, 114, 117, 115, 116, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 54, 48, 52, 6, 3, 85, 4, 3, 19, 45, 71, 101, 111, 84, 114, 117, 115, 116, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, 30, 23, 13, 48, 56, 48, 52, 48, 50, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 55, 49, 50, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -104, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 71, 101, 111, 84, 114, 117, 115, 116, 32, 73, 110, 99, 46, 49, 57, 48, 55, 6, 3, 85, 4, 11, 19, 48, 40, 99, 41, 32, 50, 48, 48, 56, 32, 71, 101, 111, 84, 114, 117, 115, 116, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 54, 48, 52, 6, 3, 85, 4, 3, 19, 45, 71, 101, 111, 84, 114, 117, 115, 116, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -36, -30, 94, 98, 88, 29, 51, 87, 57, 50, 51, -6, -21, -53, -121, -116, -89, -44, 74, -35, 6, -120, -22, 100, -114, 49, -104, -91, 56, -112, 30, -104, -49, 46, 99, 43, -16, 70, -68, 68, -78, -119, -95, -64, 40, 12, 73, 112, 33, -107, -97, 100, -64, -90, -109, 18, 2, 101, 38, -122, -58, -91, -119, -16, -6, -41, -124, -96, 112, -81, 79, 26, -105, 63, 6, 68, -43, -55, -21, 114, 16, 125, -28, 49, 40, -5, 28, 97, -26, 40, 7, 68, 115, -110, 34, 105, -89, 3, -120, 108, -99, 99, -56, 82, -38, -104, 39, -25, 8, 76, 112, 62, -76, -55, 18, -63, -59, 103, -125, 93, 51, -13, 3, 17, -20, 106, -48, 83, -30, -47, -70, 54, 96, -108, -128, -69, 97, 99, 108, 91, 23, 126, -33, 64, -108, 30, -85, 13, -62, 33, 40, 112, -120, -1, -42, 38, 108, 108, 96, 4, 37, 78, 85, 126, 125, -17, -65, -108, 72, -34, -73, 29, -35, 112, -115, 5, 95, -120, -91, -101, -14, -62, -18, -22, -47, 64, 65, 109, 98, 56, 29, 86, 6, -59, 3, 71, 81, 32, 25, -4, 123, 16, 11, 14, 98, -82, 118, 85, -65, 95, 119, -66, 62, 73, 1, 83, 61, -104, 37, 3, 118, 36, 90, 29, -76, -37, -119, -22, 121, -27, -74, -77, 59, 63, -70, 76, 40, 65, 127, 6, -84, 106, -114, -63, -48, -10, 5, 29, 125, -26, 66, -122, -29, -91, -43, 71, 2, 3, 1, 0, 1, -93, 66, 48, 64, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -60, 121, -54, -114, -95, 78, 3, 29, 28, -36, 107, -37, 49, 91, -108, 62, 63, 48, 127, 45, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 11, 5, 0, 3, -126, 1, 1, 0, 45, -59, 19, -49, 86, -128, 123, 122, 120, -67, -97, -82, 44, -103, -25, -17, -38, -33, -108, 94, 9, 105, -89, -25, 110, 104, -116, -67, 114, -66, 71, -87, 14, -105, 18, -72, 74, -15, 100, -45, 57, -33, 37, 52, -44, -63, -51, 78, -127, -16, 15, 4, -60, 36, -77, 52, -106, -58, -90, -86, 48, -33, 104, 97, 115, -41, -7, -114, -123, -119, -17, 14, 94, -107, 40, 74, 42, 39, -113, 16, -114, 46, 124, -122, -60, 2, -98, -38, 12, 119, 101, 14, 68, 13, -110, -3, -3, -77, 22, 54, -6, 17, 13, 29, -116, 14, 7, -119, 106, 41, 86, -9, 114, -12, -35, 21, -100, 119, 53, 102, 87, -85, 19, 83, -40, -114, -63, 64, -59, -41, 19, 22, 90, 114, -57, -73, 105, 1, -60, 122, -79, -125, 1, 104, 125, -115, 65, -95, -108, 24, -63, 37, 92, -4, -16, -2, -125, 2, -121, 124, 13, 13, -49, 46, 8, 92, 74, 64, 13, 62, -20, -127, 97, -26, 36, -37, -54, -32, 14, 45, 7, -78, 62, 86, -36, -115, -11, 65, -123, 7, 72, -101, 12, 11, -53, 73, 63, 125, -20, -73, -3, -53, -115, 103, -119, 26, -85, -19, -69, 30, -93, 0, 8, 8, 23, 42, -126, 92, 49, 93, 70, -118, 45, 15, -122, -101, 116, -39, 69, -5, -44, 64, -79, 122, -86, 104, 45, -122, -78, -103, 34, -31, -63, 43, -57, -100, -8, -13, 95, -88, -126, 18, -21, 25, 17, 45, 1, 0, 45, 71, 101, 111, 84, 114, 117, 115, 116, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 0, 0, 1, 66, 22, -98, 96, 113, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 2, -78, 48, -126, 2, -82, 48, -126, 2, 53, -96, 3, 2, 1, 2, 2, 16, 60, -78, -12, 72, 10, 0, -30, -2, -21, 36, 59, 94, 96, 62, -61, 107, 48, 10, 6, 8, 42, -122, 72, -50, 61, 4, 3, 3, 48, -127, -104, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 71, 101, 111, 84, 114, 117, 115, 116, 32, 73, 110, 99, 46, 49, 57, 48, 55, 6, 3, 85, 4, 11, 19, 48, 40, 99, 41, 32, 50, 48, 48, 55, 32, 71, 101, 111, 84, 114, 117, 115, 116, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 54, 48, 52, 6, 3, 85, 4, 3, 19, 45, 71, 101, 111, 84, 114, 117, 115, 116, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 48, 30, 23, 13, 48, 55, 49, 49, 48, 53, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 56, 48, 49, 49, 56, 50, 51, 53, 57, 53, 57, 90, 48, -127, -104, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 71, 101, 111, 84, 114, 117, 115, 116, 32, 73, 110, 99, 46, 49, 57, 48, 55, 6, 3, 85, 4, 11, 19, 48, 40, 99, 41, 32, 50, 48, 48, 55, 32, 71, 101, 111, 84, 114, 117, 115, 116, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 54, 48, 52, 6, 3, 85, 4, 3, 19, 45, 71, 101, 111, 84, 114, 117, 115, 116, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 48, 118, 48, 16, 6, 7, 42, -122, 72, -50, 61, 2, 1, 6, 5, 43, -127, 4, 0, 34, 3, 98, 0, 4, 21, -79, -24, -3, 3, 21, 67, -27, -84, -21, -121, 55, 17, 98, -17, -46, -125, 54, 82, 125, 69, 87, 11, 74, -115, 123, 84, 59, 58, 110, 95, 21, 2, -64, 80, -90, -49, 37, 47, 125, -54, 72, -72, -57, 80, 99, 28, 42, 33, 8, 124, -102, 54, -40, 11, -2, -47, 38, -59, 88, 49, 48, 40, 37, -13, 93, 93, -93, -72, -74, -91, -76, -110, -19, 108, 44, -97, -21, -35, 67, -119, -94, 60, 75, 72, -111, 29, 80, -20, 38, -33, -42, 96, 46, -67, 33, -93, 66, 48, 64, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 21, 95, 53, 87, 81, 85, -5, 37, -78, -83, 3, 105, -4, 1, -93, -6, -66, 17, 85, -43, 48, 10, 6, 8, 42, -122, 72, -50, 61, 4, 3, 3, 3, 103, 0, 48, 100, 2, 48, 100, -106, 89, -90, -24, 9, -34, -117, -70, -6, 90, -120, -120, -16, 31, -111, -45, 70, -88, -14, 74, 76, 2, 99, -5, 108, 95, 56, -37, 46, 65, -109, -87, 14, -26, -99, -36, 49, 28, -78, -96, -89, 24, 28, 121, -31, -57, 54, 2, 48, 58, 86, -81, -102, 116, 108, -10, -5, -125, -32, 51, -45, 8, 95, -95, -100, -62, 91, -97, 70, -42, -74, -53, -111, 6, 99, -94, 6, -25, 51, -84, 62, -88, -127, 18, -48, -53, -70, -48, -110, 11, -74, -98, -106, -86, 4, 15, -118, 1, 0, 42, 69, 110, 116, 114, 117, 115, 116, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 69, 67, 49, 0, 0, 1, 66, 22, -98, 47, -30, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 2, -3, 48, -126, 2, -7, 48, -126, 2, -128, -96, 3, 2, 1, 2, 2, 13, 0, -90, -117, 121, 41, 0, 0, 0, 0, 80, -48, -111, -7, 48, 10, 6, 8, 42, -122, 72, -50, 61, 4, 3, 3, 48, -127, -65, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 69, 110, 116, 114, 117, 115, 116, 44, 32, 73, 110, 99, 46, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 83, 101, 101, 32, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 108, 101, 103, 97, 108, 45, 116, 101, 114, 109, 115, 49, 57, 48, 55, 6, 3, 85, 4, 11, 19, 48, 40, 99, 41, 32, 50, 48, 49, 50, 32, 69, 110, 116, 114, 117, 115, 116, 44, 32, 73, 110, 99, 46, 32, 45, 32, 102, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 69, 67, 49, 48, 30, 23, 13, 49, 50, 49, 50, 49, 56, 49, 53, 50, 53, 51, 54, 90, 23, 13, 51, 55, 49, 50, 49, 56, 49, 53, 53, 53, 51, 54, 90, 48, -127, -65, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 69, 110, 116, 114, 117, 115, 116, 44, 32, 73, 110, 99, 46, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 83, 101, 101, 32, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 108, 101, 103, 97, 108, 45, 116, 101, 114, 109, 115, 49, 57, 48, 55, 6, 3, 85, 4, 11, 19, 48, 40, 99, 41, 32, 50, 48, 49, 50, 32, 69, 110, 116, 114, 117, 115, 116, 44, 32, 73, 110, 99, 46, 32, 45, 32, 102, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 69, 67, 49, 48, 118, 48, 16, 6, 7, 42, -122, 72, -50, 61, 2, 1, 6, 5, 43, -127, 4, 0, 34, 3, 98, 0, 4, -124, 19, -55, -48, -70, 109, 65, 123, -30, 108, -48, -21, 85, 95, 102, 2, 26, 36, -12, 91, -119, 105, 71, -29, -72, -62, 125, -15, -14, 2, -59, -97, -96, -10, 91, -43, -117, 6, 25, -122, 79, 83, 16, 109, 7, 36, 39, -95, -96, -8, -43, 71, 25, 97, 76, 125, -54, -109, 39, -22, 116, 12, -17, 111, -106, 9, -2, 99, -20, 112, 93, 54, -83, 103, 119, -82, -55, -99, 124, 85, 68, 58, -94, 99, 81, 31, -11, -29, 98, -44, -87, 71, 7, 62, -52, 32, -93, 66, 48, 64, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -73, 99, -25, 26, -35, -115, -23, 8, -90, 85, -125, -92, -32, 106, 80, 65, 101, 17, 66, 73, 48, 10, 6, 8, 42, -122, 72, -50, 61, 4, 3, 3, 3, 103, 0, 48, 100, 2, 48, 97, 121, -40, -27, 66, 71, -33, 28, -82, 83, -103, 23, -74, 111, 28, 125, -31, -65, 17, -108, -47, 3, -120, 117, -28, -115, -119, -92, -118, 119, 70, -34, 109, 97, -17, 2, -11, -5, -75, -33, -52, -2, 78, -1, -2, -87, -26, -89, 2, 48, 91, -103, -41, -123, 55, 6, -75, 123, 8, -3, -21, 39, -117, 74, -108, -7, -31, -6, -89, -114, 38, 8, -24, 124, -110, 104, 109, 115, -40, 111, 38, -84, 33, 2, -72, -103, -73, 38, 65, 91, 37, 96, -82, -48, 72, 26, -18, 6, 1, 0, 40, 71, 101, 111, 84, 114, 117, 115, 116, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 0, 0, 1, 66, 22, -98, 114, -104, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 3, -128, 48, -126, 3, 124, 48, -126, 2, 100, -96, 3, 2, 1, 2, 2, 16, 24, -84, -75, 106, -3, 105, -74, 21, 58, 99, 108, -81, -38, -6, -60, -95, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, 88, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 71, 101, 111, 84, 114, 117, 115, 116, 32, 73, 110, 99, 46, 49, 49, 48, 47, 6, 3, 85, 4, 3, 19, 40, 71, 101, 111, 84, 114, 117, 115, 116, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 48, 54, 49, 49, 50, 55, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 54, 48, 55, 49, 54, 50, 51, 53, 57, 53, 57, 90, 48, 88, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 71, 101, 111, 84, 114, 117, 115, 116, 32, 73, 110, 99, 46, 49, 49, 48, 47, 6, 3, 85, 4, 3, 19, 40, 71, 101, 111, 84, 114, 117, 115, 116, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -66, -72, 21, 123, -1, -44, 124, 125, 103, -83, -125, 100, 123, -56, 66, 83, 45, -33, -10, -124, 8, 32, 97, -42, 1, 89, 106, -100, 68, 17, -81, -17, 118, -3, -107, 126, -50, 97, 48, -69, 122, -125, 95, 2, -67, 1, 102, -54, -18, 21, -115, 111, -95, 48, -100, -67, -95, -123, -98, -108, 58, -13, 86, -120, 0, 49, -49, -40, -18, 106, -106, 2, -39, -19, 3, -116, -5, 117, 109, -25, -22, -72, 85, 22, 5, 22, -102, -12, -32, 94, -79, -120, -64, 100, -123, 92, 21, 77, -120, -57, -73, -70, -32, 117, -23, -83, 5, 61, -99, -57, -119, 72, -32, -69, 40, -56, 3, -31, 48, -109, 100, 94, 82, -64, 89, 112, 34, 53, 87, -120, -118, -15, -107, 10, -125, -41, -68, 49, 115, 1, 52, -19, -17, 70, 113, -32, 107, 2, -88, 53, 114, 107, -105, -101, 102, -32, -53, 28, 121, 95, -40, 26, 4, 104, 30, 71, 2, -26, -99, 96, -30, 54, -105, 1, -33, -50, 53, -110, -33, -66, 103, -57, 109, 119, 89, 59, -113, -99, -42, -112, 21, -108, -68, 66, 52, 16, -63, 57, -7, -79, 39, 62, 126, -42, -118, 117, -59, -78, -81, -106, -45, -94, -34, -101, -28, -104, -66, 125, -31, -23, -127, -83, -74, 111, -4, -41, 14, -38, -32, 52, -80, 13, 26, 119, -25, -29, 8, -104, -17, 88, -6, -100, -124, -73, 54, -81, -62, -33, -84, -46, -12, 16, 6, 112, 113, 53, 2, 3, 1, 0, 1, -93, 66, 48, 64, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 44, -43, 80, 65, -105, 21, -117, -16, -113, 54, 97, 91, 74, -5, 107, -39, -103, -55, 51, -110, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, 90, 112, 127, 44, -35, -73, 52, 79, -11, -122, 81, -87, 38, -66, 75, -72, -86, -15, 113, 13, -36, 97, -57, -96, -22, 52, 30, 122, 119, 15, 4, 53, -24, 39, -113, 108, -112, -65, -111, 22, 36, 70, 62, 74, 78, -50, 43, 22, -43, 11, 82, 29, -4, 31, 103, -94, 2, 69, 49, 79, -50, -13, -6, 3, -89, 121, -99, 83, 106, -39, -38, 99, 58, -8, -128, -41, -45, -103, -31, -91, -31, -66, -44, 85, 113, -104, 53, 58, -66, -109, -22, -82, -83, 66, -78, -112, 111, -32, -4, 33, 77, 53, 99, 51, -119, 73, -42, -101, 78, -54, -57, -25, 78, 9, 0, -9, -38, -57, -17, -103, 98, -103, 119, -74, -107, 34, 94, -118, -96, -85, -12, -72, 120, -104, -54, 56, 25, -103, -55, 114, -98, 120, -51, 75, -84, -81, 25, -96, 115, 18, 45, -4, -62, 65, -70, -127, -111, -38, 22, 90, 49, -73, -7, -76, 113, -128, 18, 72, -103, 114, 115, 90, 89, 83, -63, 99, 82, 51, -19, -89, -55, -46, 57, 2, 112, -6, -32, -79, 66, 102, 41, -86, -101, 81, -19, 48, 84, 34, 20, 95, -39, -85, 29, -63, -28, -108, -16, -8, -11, 43, -9, -22, -54, 120, 70, -42, -72, -111, -3, -90, 13, 43, 26, 20, 1, 62, -128, -16, 66, -96, -107, 7, 94, 109, -51, -52, 75, -92, 69, -115, -85, 18, -24, -77, -34, 90, -27, -96, 124, -24, 15, 34, 29, 90, -23, 89, 1, 0, 27, 68, 105, 103, 105, 67, 101, 114, 116, 32, 65, 115, 115, 117, 114, 101, 100, 32, 73, 68, 32, 82, 111, 111, 116, 32, 67, 65, 0, 0, 1, 66, 22, -99, -25, 67, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 3, -69, 48, -126, 3, -73, 48, -126, 2, -97, -96, 3, 2, 1, 2, 2, 16, 12, -25, -32, -27, 23, -40, 70, -2, -113, -27, 96, -4, 27, -16, 48, 57, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, 101, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 21, 48, 19, 6, 3, 85, 4, 10, 19, 12, 68, 105, 103, 105, 67, 101, 114, 116, 32, 73, 110, 99, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 119, 119, 119, 46, 100, 105, 103, 105, 99, 101, 114, 116, 46, 99, 111, 109, 49, 36, 48, 34, 6, 3, 85, 4, 3, 19, 27, 68, 105, 103, 105, 67, 101, 114, 116, 32, 65, 115, 115, 117, 114, 101, 100, 32, 73, 68, 32, 82, 111, 111, 116, 32, 67, 65, 48, 30, 23, 13, 48, 54, 49, 49, 49, 48, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 49, 49, 49, 49, 48, 48, 48, 48, 48, 48, 48, 90, 48, 101, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 21, 48, 19, 6, 3, 85, 4, 10, 19, 12, 68, 105, 103, 105, 67, 101, 114, 116, 32, 73, 110, 99, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 119, 119, 119, 46, 100, 105, 103, 105, 99, 101, 114, 116, 46, 99, 111, 109, 49, 36, 48, 34, 6, 3, 85, 4, 3, 19, 27, 68, 105, 103, 105, 67, 101, 114, 116, 32, 65, 115, 115, 117, 114, 101, 100, 32, 73, 68, 32, 82, 111, 111, 116, 32, 67, 65, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -83, 14, 21, -50, -28, 67, -128, 92, -79, -121, -13, -73, 96, -7, 113, 18, -91, -82, -36, 38, -108, -120, -86, -12, -50, -11, 32, 57, 40, 88, 96, 12, -8, -128, -38, -87, 21, -107, 50, 97, 60, -75, -79, 40, -124, -118, -118, -36, -97, 10, 12, -125, 23, 122, -113, -112, -84, -118, -25, 121, 83, 92, 49, -124, 42, -10, 15, -104, 50, 54, 118, -52, -34, -35, 60, -88, -94, -17, 106, -5, 33, -14, 82, 97, -33, -97, 32, -41, 31, -30, -79, -39, -2, 24, 100, -46, 18, 91, 95, -7, 88, 24, 53, -68, 71, -51, -95, 54, -7, 107, 127, -44, -80, 56, 62, -63, 27, -61, -116, 51, -39, -40, 47, 24, -2, 40, 15, -77, -89, -125, -42, -61, 110, 68, -64, 97, 53, -106, 22, -2, 89, -100, -117, 118, 109, -41, -15, -94, 75, 13, 43, -1, 11, 114, -38, -98, 96, -48, -114, -112, 53, -58, 120, 85, -121, 32, -95, -49, -27, 109, 10, -56, 73, 124, 49, -104, 51, 108, 34, -23, -121, -48, 50, 90, -94, -70, 19, -126, 17, -19, 57, 23, -99, -103, 58, 114, -95, -26, -6, -92, -39, -43, 23, 49, 117, -82, -123, 125, 34, -82, 63, 1, 70, -122, -10, 40, 121, -56, -79, -38, -28, 87, 23, -60, 126, 28, 14, -80, -76, -110, -90, 86, -77, -67, -78, -105, -19, -86, -89, -16, -73, -59, -88, 63, -107, 22, -48, -1, -95, -106, -21, 8, 95, 24, 119, 79, 2, 3, 1, 0, 1, -93, 99, 48, 97, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, -122, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 69, -21, -94, -81, -12, -110, -53, -126, 49, 45, 81, -117, -89, -89, 33, -99, -13, 109, -56, 15, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 69, -21, -94, -81, -12, -110, -53, -126, 49, 45, 81, -117, -89, -89, 33, -99, -13, 109, -56, 15, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, -94, 14, -68, -33, -30, -19, -16, -29, 114, 115, 122, 100, -108, -65, -9, 114, 102, -40, 50, -28, 66, 117, 98, -82, -121, -21, -14, -43, -39, -34, 86, -77, -97, -52, -50, 20, 40, -71, 13, -105, 96, 92, 18, 76, 88, -28, -45, 61, -125, 73, 69, 88, -105, 53, 105, 26, -88, 71, -22, 86, -58, 121, -85, 18, -40, 103, -127, -124, -33, 127, 9, 60, -108, -26, -72, 38, 44, 32, -67, 61, -77, 40, -119, -9, 95, -1, 34, -30, -105, -124, 31, -23, 101, -17, -121, -32, -33, -63, 103, 73, -77, 93, -21, -78, 9, 42, -21, 38, -19, 120, -66, 125, 63, 43, -13, -73, 38, 53, 109, 95, -119, 1, -74, 73, 91, -97, 1, 5, -101, -85, 61, 37, -63, -52, -74, 127, -62, -15, 111, -122, -58, -6, 100, 104, -21, -127, 45, -108, -21, 66, -73, -6, -116, 30, -35, 98, -15, -66, 80, 103, -73, 108, -67, -13, -15, 31, 107, 12, 54, 7, 22, 127, 55, 124, -87, 91, 109, 122, -15, 18, 70, 96, -125, -41, 39, 4, -66, 75, -50, -105, -66, -61, 103, 42, 104, 17, -33, -128, -25, 12, 51, 102, -65, 19, 13, 20, 110, -13, 127, 31, 99, 16, 30, -6, -115, 27, 37, 109, 108, -113, -91, -73, 97, 1, -79, -46, -93, 38, -95, 16, 113, -99, -83, -30, -61, -7, -61, -103, 81, -73, 43, 7, 8, -50, 46, -26, 80, -78, -89, -6, 10, 69, 47, -94, -16, -14, 1, 0, 22, 84, 104, 97, 119, 116, 101, 32, 80, 114, 105, 109, 97, 114, 121, 32, 82, 111, 111, 116, 32, 67, 65, 0, 0, 1, 66, 22, -98, -50, 23, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 4, 36, 48, -126, 4, 32, 48, -126, 3, 8, -96, 3, 2, 1, 2, 2, 16, 52, 78, -43, 87, 32, -43, -19, -20, 73, -12, 47, -50, 55, -37, 43, 109, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -87, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 21, 48, 19, 6, 3, 85, 4, 10, 19, 12, 116, 104, 97, 119, 116, 101, 44, 32, 73, 110, 99, 46, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 56, 48, 54, 6, 3, 85, 4, 11, 19, 47, 40, 99, 41, 32, 50, 48, 48, 54, 32, 116, 104, 97, 119, 116, 101, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 3, 19, 22, 116, 104, 97, 119, 116, 101, 32, 80, 114, 105, 109, 97, 114, 121, 32, 82, 111, 111, 116, 32, 67, 65, 48, 30, 23, 13, 48, 54, 49, 49, 49, 55, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 54, 48, 55, 49, 54, 50, 51, 53, 57, 53, 57, 90, 48, -127, -87, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 21, 48, 19, 6, 3, 85, 4, 10, 19, 12, 116, 104, 97, 119, 116, 101, 44, 32, 73, 110, 99, 46, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 56, 48, 54, 6, 3, 85, 4, 11, 19, 47, 40, 99, 41, 32, 50, 48, 48, 54, 32, 116, 104, 97, 119, 116, 101, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 3, 19, 22, 116, 104, 97, 119, 116, 101, 32, 80, 114, 105, 109, 97, 114, 121, 32, 82, 111, 111, 116, 32, 67, 65, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -84, -96, -16, -5, -128, 89, -44, -100, -57, -92, -49, -99, -95, 89, 115, 9, 16, 69, 12, 13, 44, 110, 104, -15, 108, 91, 72, 104, 73, 89, 55, -4, 11, 51, 25, -62, 119, 127, -52, 16, 45, -107, 52, 28, -26, -21, 77, 9, -89, 28, -46, -72, -55, -105, 54, 2, -73, -119, -44, 36, 95, 6, -64, -52, 68, -108, -108, -115, 2, 98, 111, -21, 90, -35, 17, -115, 40, -102, 92, -124, -112, 16, 122, 13, -67, 116, 102, 47, 106, 56, -96, -30, -43, 84, 68, -21, 29, 7, -97, 7, -70, 111, -18, -23, -3, 78, 11, 41, -11, 62, -124, -96, 1, -15, -100, -85, -8, 28, 126, -119, -92, -24, -95, -40, 113, 101, 13, -93, 81, 123, -18, -68, -46, 34, 96, 13, -71, 91, -99, -33, -70, -4, 81, 91, 11, -81, -104, -78, -23, 46, -23, 4, -24, 98, -121, -34, 43, -56, -41, 78, -63, 76, 100, 30, -35, -49, -121, 88, -70, 74, 79, -54, 104, 7, 29, 28, -99, 74, -58, -43, 47, -111, -52, 124, 113, 114, 28, -59, -64, 103, -21, 50, -3, -55, -110, 92, -108, -38, -123, -64, -101, -65, 83, 125, 43, 9, -12, -116, -99, -111, 31, -105, 106, 82, -53, -34, 9, 54, -92, 119, -40, 123, -121, 80, 68, -43, 62, 110, 41, 105, -5, 57, 73, 38, 30, 9, -91, -128, 123, 64, 45, -21, -24, 39, -123, -55, -2, 97, -3, 126, -26, 124, -105, 29, -43, -99, 2, 3, 1, 0, 1, -93, 66, 48, 64, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 123, 91, 69, -49, -81, -50, -53, 122, -3, 49, -110, 26, 106, -74, -13, 70, -21, 87, 72, 80, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, 121, 17, -64, 75, -77, -111, -74, -4, -16, -23, 103, -44, 13, 110, 69, -66, 85, -24, -109, -46, -50, 3, 63, -19, -38, 37, -80, 29, 87, -53, 30, 58, 118, -96, 76, -20, 80, 118, -24, 100, 114, 12, -92, -87, -15, -72, -117, -42, -42, -121, -124, -69, 50, -27, 65, 17, -64, 119, -39, -77, 96, -99, -21, 27, -43, -47, 110, 68, 68, -87, -90, 1, -20, 85, 98, 29, 119, -72, 92, -114, 72, 73, 124, -100, 59, 87, 17, -84, -83, 115, 55, -114, 47, 120, 92, -112, 104, 71, -39, 96, 96, -26, -4, 7, 61, 34, 32, 23, -60, -9, 22, -23, -60, -40, 114, -7, -56, 115, 124, -33, 22, 47, 21, -87, 62, -3, 106, 39, -74, -95, -21, 90, -70, -104, 31, -43, -29, 77, 100, 10, -99, 19, -56, 97, -70, -11};
    }

    /*
     * Opcode count of 14360 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static final byte[] GetRootKeyStoreBytes2() {
        return new byte[]{57, 28, -121, -70, -72, -67, 123, 34, 127, -10, -2, -84, 64, 121, -27, -84, 16, 111, 61, -113, 27, 121, 118, -117, -60, 55, -77, 33, 24, -124, -27, 54, 0, -21, 99, 32, -103, -71, -23, -2, 51, 4, -69, 65, -56, -63, 2, -7, 68, 99, 32, -98, -127, -50, 66, -45, -42, 63, 44, 118, -45, 99, -100, 89, -35, -113, -90, -31, 14, -96, 46, 65, -9, 46, -107, 71, -49, -68, -3, 51, -13, -10, 11, 97, 126, 126, -111, 43, -127, 71, -62, 39, 48, -18, -89, 16, 93, 55, -113, 92, 57, 43, -28, 4, -16, 123, -115, 86, -116, 104, 1, 0, 42, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 40, 50, 48, 52, 56, 41, 0, 0, 1, 66, 22, -98, 78, 121, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 4, 46, 48, -126, 4, 42, 48, -126, 3, 18, -96, 3, 2, 1, 2, 2, 4, 56, 99, -34, -8, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -76, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 64, 48, 62, 6, 3, 85, 4, 11, 20, 55, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 95, 50, 48, 52, 56, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 40, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 41, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 40, 50, 48, 52, 56, 41, 48, 30, 23, 13, 57, 57, 49, 50, 50, 52, 49, 55, 53, 48, 53, 49, 90, 23, 13, 50, 57, 48, 55, 50, 52, 49, 52, 49, 53, 49, 50, 90, 48, -127, -76, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 64, 48, 62, 6, 3, 85, 4, 11, 20, 55, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 95, 50, 48, 52, 56, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 40, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 41, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 40, 50, 48, 52, 56, 41, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -83, 77, 75, -87, 18, -122, -78, -22, -93, 32, 7, 21, 22, 100, 42, 43, 75, -47, -65, 11, 74, 77, -114, -19, -128, 118, -91, 103, -73, 120, 64, -64, 115, 66, -56, 104, -64, -37, 83, 43, -35, 94, -72, 118, -104, 53, -109, -117, 26, -99, 124, 19, 58, 14, 31, 91, -73, 30, -49, -27, 36, 20, 30, -79, -127, -87, -115, 125, -72, -52, 107, 75, 3, -15, 2, 12, -36, -85, -91, 64, 36, 0, 127, 116, -108, -95, -99, 8, 41, -77, -120, 11, -11, -121, 119, -99, 85, -51, -28, -61, 126, -41, 106, 100, -85, -123, 20, -122, -107, 91, -105, 50, 80, 111, 61, -56, -70, 102, 12, -29, -4, -67, -72, 73, -63, 118, -119, 73, 25, -3, -64, -88, -67, -119, -93, 103, 47, -58, -97, -68, 113, 25, 96, -72, 45, -23, 44, -55, -112, 118, 102, 123, -108, -30, -81, 120, -42, 101, 83, 93, 60, -42, -100, -78, -49, 41, 3, -7, 47, -92, 80, -78, -44, 72, -50, 5, 50, 85, -118, -3, -78, 100, 76, 14, -28, -104, 7, 117, -37, 127, -33, -71, 8, 85, 96, -123, 48, 41, -7, 123, 72, -92, 105, -122, -29, 53, 63, 30, -122, 93, 122, 122, 21, -67, -17, 0, -114, 21, 34, 84, 23, 0, -112, 38, -109, -68, 14, 73, 104, -111, -65, -8, 71, -45, -99, -107, 66, -63, 14, 77, -33, 111, 38, -49, -61, 24, 33, 98, 102, 67, 112, -42, -43, -64, 7, -31, 2, 3, 1, 0, 1, -93, 66, 48, 64, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 85, -28, -127, -47, 17, -128, -66, -40, -119, -71, 8, -93, 49, -7, -95, 36, 9, 22, -71, 112, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, 59, -101, -113, 86, -101, 48, -25, 83, -103, 124, 122, 121, -89, 77, -105, -41, 25, -107, -112, -5, 6, 31, -54, 51, 124, 70, 99, -113, -106, 102, 36, -6, 64, 27, 33, 39, -54, -26, 114, 115, -14, 79, -2, 49, -103, -3, -56, 12, 76, 104, 83, -58, -128, -126, 19, -104, -6, -74, -83, -38, 93, 61, -15, -50, 110, -10, 21, 17, -108, -126, 12, -18, 63, -107, -81, 17, -85, 15, -41, 47, -34, 31, 3, -113, 87, 44, 30, -55, -69, -102, 26, 68, -107, -21, 24, 79, -90, 31, -51, 125, 87, 16, 47, -101, 4, 9, 90, -124, -75, 110, -40, 29, 58, -31, -42, -98, -47, 108, 121, 94, 121, 28, 20, -59, -29, -48, 76, -109, 59, 101, 60, -19, -33, 61, -66, -90, -27, -107, 26, -61, -75, 25, -61, -67, 94, 91, -69, -1, 35, -17, 104, 25, -53, 18, -109, 39, 92, 3, 45, 111, 48, -48, 30, -74, 26, -84, -34, 90, -9, -47, -86, -88, 39, -90, -2, 121, -127, -60, 121, -103, 51, 87, -70, 18, -80, -87, -32, 66, 108, -109, -54, 86, -34, -2, 109, -124, 11, 8, -117, 126, -115, -22, -41, -104, 33, -58, -13, -25, 60, 121, 47, 94, -100, -47, 76, 21, -115, -31, -20, 34, 55, -52, -102, 67, 11, -105, -36, -128, -112, -115, -77, 103, -101, 111, 72, 8, 21, 86, -49, -65, -15, 43, 124, 94, -102, 118, -23, 89, -112, -59, 124, -125, 53, 17, 101, 81, 1, 0, 34, 68, 105, 103, 105, 67, 101, 114, 116, 32, 72, 105, 103, 104, 32, 65, 115, 115, 117, 114, 97, 110, 99, 101, 32, 69, 86, 32, 82, 111, 111, 116, 32, 67, 65, 0, 0, 1, 66, 22, -99, -3, -123, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 3, -55, 48, -126, 3, -59, 48, -126, 2, -83, -96, 3, 2, 1, 2, 2, 16, 2, -84, 92, 38, 106, 11, 64, -101, -113, 11, 121, -14, -82, 70, 37, 119, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, 108, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 21, 48, 19, 6, 3, 85, 4, 10, 19, 12, 68, 105, 103, 105, 67, 101, 114, 116, 32, 73, 110, 99, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 119, 119, 119, 46, 100, 105, 103, 105, 99, 101, 114, 116, 46, 99, 111, 109, 49, 43, 48, 41, 6, 3, 85, 4, 3, 19, 34, 68, 105, 103, 105, 67, 101, 114, 116, 32, 72, 105, 103, 104, 32, 65, 115, 115, 117, 114, 97, 110, 99, 101, 32, 69, 86, 32, 82, 111, 111, 116, 32, 67, 65, 48, 30, 23, 13, 48, 54, 49, 49, 49, 48, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 49, 49, 49, 49, 48, 48, 48, 48, 48, 48, 48, 90, 48, 108, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 21, 48, 19, 6, 3, 85, 4, 10, 19, 12, 68, 105, 103, 105, 67, 101, 114, 116, 32, 73, 110, 99, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 119, 119, 119, 46, 100, 105, 103, 105, 99, 101, 114, 116, 46, 99, 111, 109, 49, 43, 48, 41, 6, 3, 85, 4, 3, 19, 34, 68, 105, 103, 105, 67, 101, 114, 116, 32, 72, 105, 103, 104, 32, 65, 115, 115, 117, 114, 97, 110, 99, 101, 32, 69, 86, 32, 82, 111, 111, 116, 32, 67, 65, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -58, -52, -27, 115, -26, -5, -44, -69, -27, 45, 45, 50, -90, -33, -27, -127, 63, -55, -51, 37, 73, -74, 113, 42, -61, -43, -108, 52, 103, -94, 10, 28, -80, 95, 105, -90, 64, -79, -60, -73, -78, -113, -48, -104, -92, -87, 65, 89, 58, -45, -36, -108, -42, 60, -37, 116, 56, -92, 74, -52, 77, 37, -126, -9, 74, -91, 83, 18, 56, -18, -13, 73, 109, 113, -111, 126, 99, -74, -85, -90, 95, -61, -92, -124, -8, 79, 98, 81, -66, -8, -59, -20, -37, 56, -110, -29, 6, -27, 8, -111, 12, -60, 40, 65, 85, -5, -53, 90, -119, 21, 126, 113, -24, 53, -65, 77, 114, 9, 61, -66, 58, 56, 80, 91, 119, 49, 27, -115, -77, -57, 36, 69, -102, -89, -84, 109, 0, 20, 90, 4, -73, -70, 19, -21, 81, 10, -104, 65, 65, 34, 78, 101, 97, -121, -127, 65, 80, -90, 121, 92, -119, -34, 25, 74, 87, -43, 46, -26, 93, 28, 83, 44, 126, -104, -51, 26, 6, 22, -92, 104, 115, -48, 52, 4, 19, 92, -95, 113, -45, 90, 124, 85, -37, 94, 100, -31, 55, -121, 48, 86, 4, -27, 17, -76, 41, -128, 18, -15, 121, 57, -120, -94, 2, 17, 124, 39, 102, -73, -120, -73, 120, -14, -54, 10, -88, 56, -85, 10, 100, -62, -65, 102, 93, -107, -124, -63, -95, 37, 30, -121, 93, 26, 80, 11, 32, 18, -52, 65, -69, 110, 11, 81, 56, -72, 75, -53, 2, 3, 1, 0, 1, -93, 99, 48, 97, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, -122, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -79, 62, -61, 105, 3, -8, -65, 71, 1, -44, -104, 38, 26, 8, 2, -17, 99, 100, 43, -61, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, -79, 62, -61, 105, 3, -8, -65, 71, 1, -44, -104, 38, 26, 8, 2, -17, 99, 100, 43, -61, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, 28, 26, 6, -105, -36, -41, -100, -97, 60, -120, 102, 6, 8, 87, 33, -37, 33, 71, -8, 42, 103, -86, -65, 24, 50, 118, 64, 16, 87, -63, -118, -13, 122, -39, 17, 101, -114, 53, -6, -98, -4, 69, -75, -98, -39, 76, 49, 75, -72, -111, -24, 67, 44, -114, -77, 120, -50, -37, -29, 83, 121, 113, -42, -27, 33, -108, 1, -38, 85, -121, -102, 36, 100, -10, -118, 102, -52, -34, -100, 55, -51, -88, 52, -79, 105, -101, 35, -56, -98, 120, 34, 43, 112, 67, -29, 85, 71, 49, 97, 25, -17, 88, -59, -123, 47, 78, 48, -10, -96, 49, 22, 35, -56, -25, -30, 101, 22, 51, -53, -65, 26, 27, -96, 61, -8, -54, 94, -117, 49, -117, 96, 8, -119, 45, 12, 6, 92, 82, -73, -60, -7, 10, -104, -47, 21, 95, -97, 18, -66, 124, 54, 99, 56, -67, 68, -92, 127, -28, 38, 43, 10, -60, -105, 105, 13, -23, -116, -30, -64, 16, 87, -72, -56, 118, 18, -111, 85, -14, 72, 105, -40, -68, 42, 2, 91, 15, 68, -44, 32, 49, -37, -12, -70, 112, 38, 93, -112, 96, -98, -68, 75, 23, 9, 47, -76, -53, 30, 67, 104, -55, 7, 39, -63, -46, 92, -9, -22, 33, -71, 104, 18, -100, 60, -100, -65, -98, -4, -128, 92, -101, 99, -51, -20, 71, -86, 37, 39, 103, -96, 55, -13, 0, -126, 125, 84, -41, -87, -8, -23, 46, 19, -93, 119, -24, 31, 74, 1, 0, 61, 71, 111, 32, 68, 97, 100, 100, 121, 32, 83, 101, 99, 117, 114, 101, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 115, 101, 114, 105, 97, 108, 78, 117, 109, 98, 101, 114, 61, 48, 55, 57, 54, 57, 50, 56, 55, 0, 0, 1, 66, 22, -98, -96, -8, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 4, -30, 48, -126, 4, -34, 48, -126, 3, -58, -96, 3, 2, 1, 2, 2, 2, 3, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, 99, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 33, 48, 31, 6, 3, 85, 4, 10, 19, 24, 84, 104, 101, 32, 71, 111, 32, 68, 97, 100, 100, 121, 32, 71, 114, 111, 117, 112, 44, 32, 73, 110, 99, 46, 49, 49, 48, 47, 6, 3, 85, 4, 11, 19, 40, 71, 111, 32, 68, 97, 100, 100, 121, 32, 67, 108, 97, 115, 115, 32, 50, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 48, 54, 49, 49, 49, 54, 48, 49, 53, 52, 51, 55, 90, 23, 13, 50, 54, 49, 49, 49, 54, 48, 49, 53, 52, 51, 55, 90, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 16, 48, 14, 6, 3, 85, 4, 8, 19, 7, 65, 114, 105, 122, 111, 110, 97, 49, 19, 48, 17, 6, 3, 85, 4, 7, 19, 10, 83, 99, 111, 116, 116, 115, 100, 97, 108, 101, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 71, 111, 68, 97, 100, 100, 121, 46, 99, 111, 109, 44, 32, 73, 110, 99, 46, 49, 51, 48, 49, 6, 3, 85, 4, 11, 19, 42, 104, 116, 116, 112, 58, 47, 47, 99, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 115, 46, 103, 111, 100, 97, 100, 100, 121, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 49, 48, 48, 46, 6, 3, 85, 4, 3, 19, 39, 71, 111, 32, 68, 97, 100, 100, 121, 32, 83, 101, 99, 117, 114, 101, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 49, 17, 48, 15, 6, 3, 85, 4, 5, 19, 8, 48, 55, 57, 54, 57, 50, 56, 55, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -60, 45, -43, 21, -116, -100, 38, 76, -20, 50, 53, -21, 95, -72, 89, 1, 90, -90, 97, -127, 89, 59, 112, 99, -85, -29, -36, 61, -57, 42, -72, -55, 51, -45, 121, -28, 58, -19, 60, 48, 35, -124, -114, -77, 48, 20, -74, -78, -121, -61, 61, -107, 84, 4, -98, -33, -103, -35, 11, 37, 30, 33, -34, 101, 41, 126, 53, -88, -87, 84, -21, -10, -9, 50, 57, -44, 38, 85, -107, -83, -17, -5, -2, 88, -122, -41, -98, -12, 0, -115, -116, 42, 12, -67, 66, 4, -50, -89, 63, 4, -10, -18, -128, -14, -86, -17, 82, -95, 105, 102, -38, -66, 26, -83, 93, -38, 44, 102, -22, 26, 107, -69, -27, 26, 81, 74, 0, 47, 72, -57, -104, 117, -40, -71, 41, -56, -18, -8, 102, 109, 10, -100, -77, -13, -4, 120, 124, -94, -8, -93, -14, -75, -61, -13, -71, 122, -111, -63, -89, -26, 37, 46, -100, -88, -19, 18, 101, 110, 106, -10, 18, 68, 83, 112, 48, -107, -61, -100, 43, 88, 43, 61, 8, 116, 74, -14, -66, 81, -80, -65, -121, -48, 76, 39, 88, 107, -75, 53, -59, -99, -81, 23, 49, -8, 11, -113, -18, -83, -127, 54, 5, -119, 8, -104, -49, 58, -81, 37, -121, -64, 73, -22, -89, -3, 103, -9, 69, -114, -105, -52, 20, 57, -30, 54, -123, -75, 126, 26, 55, -3, 22, -10, 113, 17, -102, 116, 48, 22, -2, 19, -108, -93, 63, -124, 13, 79, 2, 3, 1, 0, 1, -93, -126, 1, 50, 48, -126, 1, 46, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -3, -84, 97, 50, -109, 108, 69, -42, -30, -18, -123, 95, -102, -70, -25, 118, -103, 104, -52, -25, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, -46, -60, -80, -46, -111, -44, 76, 17, 113, -77, 97, -53, 61, -95, -2, -35, -88, 106, -44, -29, 48, 18, 6, 3, 85, 29, 19, 1, 1, -1, 4, 8, 48, 6, 1, 1, -1, 2, 1, 0, 48, 51, 6, 8, 43, 6, 1, 5, 5, 7, 1, 1, 4, 39, 48, 37, 48, 35, 6, 8, 43, 6, 1, 5, 5, 7, 48, 1, -122, 23, 104, 116, 116, 112, 58, 47, 47, 111, 99, 115, 112, 46, 103, 111, 100, 97, 100, 100, 121, 46, 99, 111, 109, 48, 70, 6, 3, 85, 29, 31, 4, 63, 48, 61, 48, 59, -96, 57, -96, 55, -122, 53, 104, 116, 116, 112, 58, 47, 47, 99, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 115, 46, 103, 111, 100, 97, 100, 100, 121, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 103, 100, 114, 111, 111, 116, 46, 99, 114, 108, 48, 75, 6, 3, 85, 29, 32, 4, 68, 48, 66, 48, 64, 6, 4, 85, 29, 32, 0, 48, 56, 48, 54, 6, 8, 43, 6, 1, 5, 5, 7, 2, 1, 22, 42, 104, 116, 116, 112, 58, 47, 47, 99, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 115, 46, 103, 111, 100, 97, 100, 100, 121, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, -46, -122, -64, -20, -67, -7, -95, -74, 103, -18, 102, 11, -94, 6, 58, 4, 80, -114, 21, 114, -84, 74, 116, -107, 83, -53, 55, -53, 68, 73, -17, 7, -112, 107, 51, -39, -106, -16, -108, 86, -91, 19, 48, 5, 60, -123, 50, 33, 123, -55, -57, 10, -88, 36, -92, -112, -34, 70, -45, 37, 35, 20, 3, 103, -62, 16, -42, 111, 15, 93, 123, 122, -52, -97, -59, 88, 42, -63, -60, -98, 33, -88, 90, -13, -84, -92, 70, -13, -98, -28, 99, -53, 47, -112, -92, 41, 41, 1, -39, 114, 44, 41, -33, 55, 1, 39, -68, 79, -18, 104, -45, 33, -113, -64, -77, -28, -11, 9, -19, -46, 16, -86, 83, -76, -66, -16, -52, 89, 11, -42, 59, -106, 28, -107, 36, 73, -33, -50, -20, -3, -89, 72, -111, 20, 69, 14, 58, 54, 111, -38, 69, -77, 69, -94, 65, -55, -44, -41, 68, 78, 62, -71, 116, 118, -43, -94, 19, 85, 44, -58, -121, -93, -75, -103, -84, 6, -124, -121, 127, 117, 6, -4, -65, 20, 76, 14, -52, 110, -60, -33, 61, -73, 18, 113, -12, -24, -15, 81, 64, 34, 40, 73, -32, 29, 75, -121, -88, 52, -52, 6, -94, -35, 18, 90, -47, -122, 54, 100, 3, 53, 111, 111, 119, 110, -21, -14, -123, 80, -104, 94, -85};
    }

    /*
     * Opcode count of 32628 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static final byte[] GetRootKeyStoreBytes3() {
        return new byte[]{3, 83, -83, -111, 35, 99, 31, 22, -100, -51, -71, -78, 5, 99, 58, -31, -12, 104, 27, 23, 5, 53, -107, 83, -18, 1, 0, 40, 71, 111, 32, 68, 97, 100, 100, 121, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 0, 0, 1, 66, 22, -98, -98, 3, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 3, -55, 48, -126, 3, -59, 48, -126, 2, -83, -96, 3, 2, 1, 2, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 11, 5, 0, 48, -127, -125, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 16, 48, 14, 6, 3, 85, 4, 8, 19, 7, 65, 114, 105, 122, 111, 110, 97, 49, 19, 48, 17, 6, 3, 85, 4, 7, 19, 10, 83, 99, 111, 116, 116, 115, 100, 97, 108, 101, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 71, 111, 68, 97, 100, 100, 121, 46, 99, 111, 109, 44, 32, 73, 110, 99, 46, 49, 49, 48, 47, 6, 3, 85, 4, 3, 19, 40, 71, 111, 32, 68, 97, 100, 100, 121, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 48, 30, 23, 13, 48, 57, 48, 57, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 55, 49, 50, 51, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -125, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 16, 48, 14, 6, 3, 85, 4, 8, 19, 7, 65, 114, 105, 122, 111, 110, 97, 49, 19, 48, 17, 6, 3, 85, 4, 7, 19, 10, 83, 99, 111, 116, 116, 115, 100, 97, 108, 101, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 71, 111, 68, 97, 100, 100, 121, 46, 99, 111, 109, 44, 32, 73, 110, 99, 46, 49, 49, 48, 47, 6, 3, 85, 4, 3, 19, 40, 71, 111, 32, 68, 97, 100, 100, 121, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -65, 113, 98, 8, -15, -6, 89, 52, -9, 27, -55, 24, -93, -9, -128, 73, 88, -23, 34, -125, 19, -90, -59, 32, 67, 1, 59, -124, -15, -26, -123, 73, -97, 39, -22, -10, -124, 27, 78, -96, -76, -37, 112, -104, -57, 50, 1, -79, 5, 62, 7, 78, -18, -12, -6, 79, 47, 89, 48, 34, -25, -85, 25, 86, 107, -30, -128, 7, -4, -13, 22, 117, -128, 57, 81, 123, -27, -7, 53, -74, 116, 78, -87, -115, -126, 19, -28, -74, 63, -87, 3, -125, -6, -94, -66, -118, 21, 106, 127, -34, 11, -61, -74, 25, 20, 5, -54, -22, -61, -88, 4, -108, 59, 70, 124, 50, 13, -13, 0, 102, 34, -56, -115, 105, 109, 54, -116, 17, 24, -73, -45, -78, 28, 96, -76, 56, -6, 2, -116, -50, -45, -35, 70, 7, -34, 10, 62, -21, 93, 124, -56, 124, -5, -80, 43, 83, -92, -110, 98, 105, 81, 37, 5, 97, 26, 68, -127, -116, 44, -87, 67, -106, 35, -33, -84, 58, -127, -102, 14, 41, -59, 28, -87, -23, 93, 30, -74, -98, -98, 48, 10, 57, -50, -15, -120, -128, -5, 75, 93, -52, 50, -20, -123, 98, 67, 37, 52, 2, 86, 39, 1, -111, -76, 59, 112, 42, 63, 110, -79, -24, -100, -120, 1, 125, -97, -44, -7, -37, 83, 109, 96, -99, -65, 44, -25, 88, -85, -72, 95, 70, -4, -50, -60, 27, 3, 60, 9, -21, 73, 49, 92, 105, 70, -77, -32, 71, 2, 3, 1, 0, 1, -93, 66, 48, 64, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 58, -102, -123, 7, 16, 103, 40, -74, -17, -10, -67, 5, 65, 110, 32, -63, -108, -38, 15, -34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 11, 5, 0, 3, -126, 1, 1, 0, -103, -37, 93, 121, -43, -7, -105, 89, 103, 3, 97, -15, 126, 59, 6, 49, 117, 45, -95, 32, -114, 79, 101, -121, -76, -9, -90, -100, -68, -40, -23, 47, -48, -37, 90, -18, -49, 116, -116, 115, -76, 56, 66, -38, 5, 123, -8, 2, 117, -72, -3, -91, -79, -41, -82, -10, -41, -34, 19, -53, 83, 16, 126, -118, 70, -47, -105, -6, -73, 46, 43, 17, -85, -112, -80, 39, -128, -7, -24, -97, 90, -23, 55, -97, -85, -28, -33, 108, -77, -123, 23, -99, 61, -39, 36, 79, 121, -111, 53, -42, 95, 4, -21, -128, -125, -85, -102, 2, 45, -75, 16, -12, -40, -112, -57, 4, 115, 64, -19, 114, 37, -96, -87, -97, -20, -98, -85, 104, 18, -103, 87, -58, -113, 18, 58, 9, -92, -67, 68, -3, 6, 21, 55, -63, -101, -28, 50, -93, -19, 56, -24, -40, 100, -13, 44, 126, 20, -4, 2, -22, -97, -51, -1, 7, 104, 23, -37, 34, -112, 56, 45, 122, -115, -47, 84, -15, 105, -29, 95, 51, -54, 122, 61, 123, 10, -29, -54, 127, 95, 57, -27, -30, 117, -70, -59, 118, 24, 51, -50, 44, -16, 47, 76, -83, -9, -79, -25, -50, 79, -88, -60, -101, 74, 84, 6, -59, 127, 125, -43, 8, 15, -30, 28, -2, 126, 23, -72, -84, 94, -10, -44, 22, -78, 67, 9, 12, 77, -10, -89, 107, -76, -103, -124, 101, -54, 122, -120, -30, -30, 68, -66, 92, -9, -22, 28, -11, 1, 0, 27, 84, 104, 97, 119, 116, 101, 32, 80, 114, 105, 109, 97, 114, 121, 32, 82, 111, 111, 116, 32, 67, 65, 32, 45, 32, 71, 51, 0, 0, 1, 66, 22, -98, -59, 76, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 4, 46, 48, -126, 4, 42, 48, -126, 3, 18, -96, 3, 2, 1, 2, 2, 16, 96, 1, -105, -73, 70, -89, -22, -76, -76, -102, -42, 75, 47, -9, -112, -5, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 11, 5, 0, 48, -127, -82, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 21, 48, 19, 6, 3, 85, 4, 10, 19, 12, 116, 104, 97, 119, 116, 101, 44, 32, 73, 110, 99, 46, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 56, 48, 54, 6, 3, 85, 4, 11, 19, 47, 40, 99, 41, 32, 50, 48, 48, 56, 32, 116, 104, 97, 119, 116, 101, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 36, 48, 34, 6, 3, 85, 4, 3, 19, 27, 116, 104, 97, 119, 116, 101, 32, 80, 114, 105, 109, 97, 114, 121, 32, 82, 111, 111, 116, 32, 67, 65, 32, 45, 32, 71, 51, 48, 30, 23, 13, 48, 56, 48, 52, 48, 50, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 55, 49, 50, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -82, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 21, 48, 19, 6, 3, 85, 4, 10, 19, 12, 116, 104, 97, 119, 116, 101, 44, 32, 73, 110, 99, 46, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 56, 48, 54, 6, 3, 85, 4, 11, 19, 47, 40, 99, 41, 32, 50, 48, 48, 56, 32, 116, 104, 97, 119, 116, 101, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 36, 48, 34, 6, 3, 85, 4, 3, 19, 27, 116, 104, 97, 119, 116, 101, 32, 80, 114, 105, 109, 97, 114, 121, 32, 82, 111, 111, 116, 32, 67, 65, 32, 45, 32, 71, 51, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -78, -65, 39, 44, -5, -37, -40, 91, -35, 120, 123, 27, -98, 119, 102, -127, -53, 62, -68, 124, -82, -13, -90, 39, -102, 52, -93, 104, 49, 113, 56, 51, 98, -28, -13, 113, 102, 121, -79, -87, 101, -93, -91, -117, -43, -113, 96, 45, 63, 66, -52, -86, 107, 50, -64, 35, -53, 44, 65, -35, -28, -33, -4, 97, -100, -30, 115, -78, 34, -107, 17, 67, 24, 95, -60, -74, 31, 87, 108, 10, 5, 88, 34, -56, 54, 76, 58, 124, -91, -47, -49, -122, -81, -120, -89, 68, 2, 19, 116, 113, 115, 10, 66, 89, 2, -8, 27, 20, 107, 66, -33, 111, 95, -70, 107, -126, -94, -99, 91, -25, 74, -67, 30, 1, 114, -37, 75, 116, -24, 59, 127, 127, 125, 31, 4, -76, 38, -101, -32, -76, 90, -84, 71, 61, 85, -72, -41, -80, 38, 82, 40, 1, 49, 64, 102, -40, -39, 36, -67, -10, 42, -40, -20, 33, 73, 92, -101, -10, 122, -23, 127, 85, 53, 126, -106, 107, -115, -109, -109, 39, -53, -110, -69, -22, -84, 64, -64, -97, -62, -8, -128, -49, 93, -12, 90, -36, -50, 116, -122, -90, 62, 108, 11, 83, -54, -67, -110, -50, 25, 6, 114, -26, 12, 92, 56, 105, -57, 4, -42, -68, 108, -50, 91, -10, -9, 104, -100, -36, 37, 21, 72, -120, -95, -23, -87, -8, -104, -100, -32, -13, -43, 49, 40, 97, 17, 108, 103, -106, -115, 57, -103, -53, -62, 69, 36, 57, 2, 3, 1, 0, 1, -93, 66, 48, 64, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -83, 108, -86, -108, 96, -100, -19, -28, -1, -6, 62, 10, 116, 43, 99, 3, -9, -74, 89, -65, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 11, 5, 0, 3, -126, 1, 1, 0, 26, 64, -40, -107, 101, -84, 9, -110, -119, -58, 57, -12, 16, -27, -87, 14, 102, 83, 93, 120, -34, -6, 36, -111, -69, -25, 68, 81, -33, -58, 22, 52, 10, -17, 106, 68, 81, -22, 43, 7, -118, 3, 122, -61, -21, 63, 10, 44, 82, 22, -96, 43, 67, -71, 37, -112, 63, 112, -87, 51, 37, 109, 69, 26, 40, 59, 39, -49, -86, -61, 41, 66, 27, -33, 59, 76, -64, 51, 52, 91, 65, -120, -65, 107, 43, 101, -81, 40, -17, -78, -11, -61, -86, 102, -50, 123, 86, -18, -73, -56, -53, 103, -63, -55, -100, 26, 24, -72, -60, -61, 73, 3, -15, 96, 14, 80, -51, 70, -59, -13, 119, 121, -9, -74, 21, -32, 56, -37, -57, 47, 40, -96, 12, 63, 119, 38, 116, -39, 37, 18, -38, 49, -38, 26, 30, -36, 41, 65, -111, 34, 60, 105, -89, -69, 2, -14, -74, 92, 39, 3, -119, -12, 6, -22, -101, -28, 114, -126, -29, -95, 9, -63, -23, 0, 25, -45, 62, -44, 112, 107, -70, 113, -90, -86, 88, -82, -12, -69, -23, 108, -74, -17, -121, -52, -101, -69, -1, 57, -26, 86, 97, -45, 10, -89, -60, 92, 76, 96, 123, 5, 119, 38, 122, -65, -40, 7, 82, 44, 98, -9, 112, 99, -39, 57, -68, 111, 28, -62, 121, -36, 118, 41, -81, -50, -59, 44, 100, 4, 94, -120, 54, 110, 49, -44, 64, 26, 98, 52, 54, 63, 53, 1, -82, -84, 99, -96, 1, 0, 27, 84, 104, 97, 119, 116, 101, 32, 80, 114, 105, 109, 97, 114, 121, 32, 82, 111, 111, 116, 32, 67, 65, 32, 45, 32, 71, 50, 0, 0, 1, 66, 22, -98, -69, -117, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 2, -116, 48, -126, 2, -120, 48, -126, 2, 13, -96, 3, 2, 1, 2, 2, 16, 53, -4, 38, 92, -39, -124, 79, -55, 61, 38, 61, 87, -101, -82, -41, 86, 48, 10, 6, 8, 42, -122, 72, -50, 61, 4, 3, 3, 48, -127, -124, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 21, 48, 19, 6, 3, 85, 4, 10, 19, 12, 116, 104, 97, 119, 116, 101, 44, 32, 73, 110, 99, 46, 49, 56, 48, 54, 6, 3, 85, 4, 11, 19, 47, 40, 99, 41, 32, 50, 48, 48, 55, 32, 116, 104, 97, 119, 116, 101, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 36, 48, 34, 6, 3, 85, 4, 3, 19, 27, 116, 104, 97, 119, 116, 101, 32, 80, 114, 105, 109, 97, 114, 121, 32, 82, 111, 111, 116, 32, 67, 65, 32, 45, 32, 71, 50, 48, 30, 23, 13, 48, 55, 49, 49, 48, 53, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 56, 48, 49, 49, 56, 50, 51, 53, 57, 53, 57, 90, 48, -127, -124, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 21, 48, 19, 6, 3, 85, 4, 10, 19, 12, 116, 104, 97, 119, 116, 101, 44, 32, 73, 110, 99, 46, 49, 56, 48, 54, 6, 3, 85, 4, 11, 19, 47, 40, 99, 41, 32, 50, 48, 48, 55, 32, 116, 104, 97, 119, 116, 101, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 36, 48, 34, 6, 3, 85, 4, 3, 19, 27, 116, 104, 97, 119, 116, 101, 32, 80, 114, 105, 109, 97, 114, 121, 32, 82, 111, 111, 116, 32, 67, 65, 32, 45, 32, 71, 50, 48, 118, 48, 16, 6, 7, 42, -122, 72, -50, 61, 2, 1, 6, 5, 43, -127, 4, 0, 34, 3, 98, 0, 4, -94, -43, -100, -126, 123, -107, -99, -15, 82, 120, -121, -2, -118, 22, -65, 5, -26, -33, -93, 2, 79, 13, 7, -58, 0, 81, -70, 12, 2, 82, 45, 34, -92, 66, 57, -60, -2, -113, -22, -55, -63, -66, -44, 77, -1, -97, 122, -98, -30, -79, 124, -102, -83, -89, -122, 9, 115, -121, -47, -25, -102, -29, 122, -91, -86, 110, -5, -70, -77, 112, -64, 103, -120, -94, 53, -44, -93, -102, -79, -3, -83, -62, -17, 49, -6, -88, -71, -13, -5, 8, -58, -111, -47, -5, 41, -107, -93, 66, 48, 64, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -102, -40, 0, 48, 0, -25, 107, 127, -123, 24, -18, -117, -74, -50, -118, 12, -8, 17, -31, -69, 48, 10, 6, 8, 42, -122, 72, -50, 61, 4, 3, 3, 3, 105, 0, 48, 102, 2, 49, 0, -35, -8, -32, 87, 71, 91, -89, -26, 10, -61, -67, -11, -128, -118, -105, 53, 13, 27, -119, 60, 84, -122, 119, 40, -54, -95, -12, 121, -34, -75, -26, 56, -80, -16, 101, 112, -116, 127, 2, 84, -62, -65, -1, -40, -95, 62, -39, -49, 2, 49, 0, -60, -115, -108, -4, -36, 83, -46, -36, -99, 120, 22, 31, 21, 51, 35, 83, 82, -29, 90, 49, 93, -99, -54, -82, -67, 19, 41, 68, 13, 39, 91, -88, -25, 104, -100, 18, -9, 88, 63, 46, 114, 2, 87, -93, -113, -95, 20, 46, 1, 0, 40, 71, 111, 32, 68, 97, 100, 100, 121, 32, 67, 108, 97, 115, 115, 32, 50, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 0, 0, 1, 66, 22, -98, 123, -1, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 4, 4, 48, -126, 4, 0, 48, -126, 2, -24, -96, 3, 2, 1, 2, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, 99, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 33, 48, 31, 6, 3, 85, 4, 10, 19, 24, 84, 104, 101, 32, 71, 111, 32, 68, 97, 100, 100, 121, 32, 71, 114, 111, 117, 112, 44, 32, 73, 110, 99, 46, 49, 49, 48, 47, 6, 3, 85, 4, 11, 19, 40, 71, 111, 32, 68, 97, 100, 100, 121, 32, 67, 108, 97, 115, 115, 32, 50, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 48, 52, 48, 54, 50, 57, 49, 55, 48, 54, 50, 48, 90, 23, 13, 51, 52, 48, 54, 50, 57, 49, 55, 48, 54, 50, 48, 90, 48, 99, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 33, 48, 31, 6, 3, 85, 4, 10, 19, 24, 84, 104, 101, 32, 71, 111, 32, 68, 97, 100, 100, 121, 32, 71, 114, 111, 117, 112, 44, 32, 73, 110, 99, 46, 49, 49, 48, 47, 6, 3, 85, 4, 11, 19, 40, 71, 111, 32, 68, 97, 100, 100, 121, 32, 67, 108, 97, 115, 115, 32, 50, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -126, 1, 32, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 13, 0, 48, -126, 1, 8, 2, -126, 1, 1, 0, -34, -99, -41, -22, 87, 24, 73, -95, 91, -21, -41, 95, 72, -122, -22, -66, -35, -1, -28, -17, 103, 28, -12, 101, 104, -77, 87, 113, -96, 94, 119, -69, -19, -101, 73, -23, 112, -128, 61, 86, 24, 99, 8, 111, -38, -14, -52, -48, 63, 127, 2, 84, 34, 84, 16, -40, -78, -127, -44, -64, 117, 61, 75, 127, -57, 119, -61, 62, 120, -85, 26, 3, -75, 32, 107, 47, 106, 43, -79, -59, -120, 126, -60, -69, 30, -80, -63, -40, 69, 39, 111, -86, 55, 88, -9, -121, 38, -41, -40, 45, -10, -87, 23, -73, 31, 114, 54, 78, -90, 23, 63, 101, -104, -110, -37, 42, 110, 93, -94, -2, -120, -32, 11, -34, 127, -27, -115, 21, -31, -21, -53, 58, -43, -30, 18, -94, 19, 45, -40, -114, -81, 95, 18, 61, -96, 8, 5, 8, -74, 92, -91, 101, 56, 4, 69, -103, 30, -93, 96, 96, 116, -59, 65, -91, 114, 98, 27, 98, -59, 31, 111, 95, 26, 66, -66, 2, 81, 101, -88, -82, 35, 24, 106, -4, 120, 3, -87, 77, 127, -128, -61, -6, -85, 90, -4, -95, 64, -92, -54, 25, 22, -2, -78, -56, -17, 94, 115, 13, -18, 119, -67, -102, -10, 121, -104, -68, -79, 7, 103, -94, 21, 13, -35, -96, 88, -58, 68, 123, 10, 62, 98, 40, 95, -70, 65, 7, 83, 88, -49, 17, 126, 56, 116, -59, -8, -1, -75, 105, -112, -113, -124, 116, -22, -105, 27, -81, 2, 1, 3, -93, -127, -64, 48, -127, -67, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -46, -60, -80, -46, -111, -44, 76, 17, 113, -77, 97, -53, 61, -95, -2, -35, -88, 106, -44, -29, 48, -127, -115, 6, 3, 85, 29, 35, 4, -127, -123, 48, -127, -126, -128, 20, -46, -60, -80, -46, -111, -44, 76, 17, 113, -77, 97, -53, 61, -95, -2, -35, -88, 106, -44, -29, -95, 103, -92, 101, 48, 99, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 33, 48, 31, 6, 3, 85, 4, 10, 19, 24, 84, 104, 101, 32, 71, 111, 32, 68, 97, 100, 100, 121, 32, 71, 114, 111, 117, 112, 44, 32, 73, 110, 99, 46, 49, 49, 48, 47, 6, 3, 85, 4, 11, 19, 40, 71, 111, 32, 68, 97, 100, 100, 121, 32, 67, 108, 97, 115, 115, 32, 50, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, -126, 1, 0, 48, 12, 6, 3, 85, 29, 19, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, 50, 75, -13, -78, -54, 62, -111, -4, 18, -58, -95, 7, -116, -114, 119, -96, 51, 6, 20, 92, -112, 30, 24, -9, 8, -90, 61, 10, 25, -7, -121, -128, 17, 110, 105, -28, -106, 23, 48, -1, 52, -111, 99, 114, 56, -18, -52, 28, 1, -93, 29, -108, 40, -92, 49, -10, 122, -60, 84, -41, -10, -27, 49, 88, 3, -94, -52, -50, 98, -37, -108, 69, 115, -75, -65, 69, -55, 36, -75, -43, -126, 2, -83, 35, 121, 105, -115, -72, -74, 77, -50, -49, 76, -54, 51, 35, -24, 28, -120, -86, -99, -117, 65, 110, 22, -55, 32, -27, -119, -98, -51, 59, -38, 112, -9, 126, -103, 38, 32, 20, 84, 37, -85, 110, 115, -123, -26, -101, 33, -99, 10, 108, -126, 14, -88, -8, -62, 12, -6, 16, 30, 108, -106, -17, -121, 13, -60, 15, 97, -117, -83, -18, -125, 43, -107, -8, -114, -110, -124, 114, 57, -21, 32, -22, -125, -19, -125, -51, -105, 110, 8, -68, -21, 78, 38, -74, 115, 43, -28, -45, -10, 76, -2, 38, 113, -30, 97, 17, 116, 74, -1, 87, 26, -121, 15, 117, 72, 46, -49, 81, 105, 23, -96, 2, 18, 97, -107, -43, -47, 64, -78, 16, 76, -18, -60, -84, 16, 67, -90, -91, -98, 10, -43, -107, 98, -102, 13, -49, -120, -126, -59, 50, 12, -28, 43, -97, 69, -26, 13, -97, 40, -100, -79, -71, 42, 90, 87, -83, 55, 15, -81, 29, 127, -37, -67, -97, 1, 0, 24, 84, 104, 97, 119, 116, 101, 32, 80, 114, 101, 109, 105, 117, 109, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 0, 0, 1, 66, 22, -98, -78, 58, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 3, 43, 48, -126, 3, 39, 48, -126, 2, -112, -96, 3, 2, 1, 2, 2, 1, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -50, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 32, 99, 99, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 33, 48, 31, 6, 3, 85, 4, 3, 19, 24, 84, 104, 97, 119, 116, 101, 32, 80, 114, 101, 109, 105, 117, 109, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 49, 40, 48, 38, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 25, 112, 114, 101, 109, 105, 117, 109, 45, 115, 101, 114, 118, 101, 114, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, 30, 23, 13, 57, 54, 48, 56, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 48, 49, 50, 51, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -50, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 32, 99, 99, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 33, 48, 31, 6, 3, 85, 4, 3, 19, 24, 84, 104, 97, 119, 116, 101, 32, 80, 114, 101, 109, 105, 117, 109, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 49, 40, 48, 38, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 25, 112, 114, 101, 109, 105, 117, 109, 45, 115, 101, 114, 118, 101, 114, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -46, 54, 54, 106, -117, -41, -62, 91, -98, -38, -127, 65, 98, -113, 56, -18, 73, 4, 85, -42, -48, -17, 28, 27, -107, 22, 71, -17, 24, 72, 53, 58, 82, -12, 43, 106, 6, -113, 59, 47, -22, 86, -29, -81, -122, -115, -98, 23, -9, -98, -76, 101, 117, 2, 77, -17, -53, 9, -94, 33, 81, -40, -101, -48, 103, -48, -70, 13, -110, 6, 20, 115, -44, -109, -53, -105, 42, 0, -100, 92, 78, 12, -68, -6, 21, 82, -4, -14, 68, 110, -38, 17, 74, 110, 8, -97, 47, 45, -29, -7, -86, 58, -122, 115, -74, 70, 83, 88, -56, -119, 5, -67, -125, 17, -72, 115, 63, -86, 7, -115, -12, 66, 77, -25, 64, -99, 28, 55, 2, 3, 1, 0, 1, -93, 19, 48, 17, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, 38, 72, 44, 22, -62, 88, -6, -24, 22, 116, 12, -86, -86, 95, 84, 63, -14, -41, -55, 120, 96, 94, 94, 110, 55, 99, 34, 119, 54, 126, -78, 23, -60, 52, -71, -11, 8, -123, -4, -55, 1, 56, -1, 77, -66, -14, 22, 66, 67, -25, -69, 90, 70, -5, -63, -58, 17, 31, -15, 74, -80, 40, 70, -55, -61, -60, 66, 125, -68, -6, -85, 89, 110, -43, -73, 81, -120, 17, -29, -92, -123, 25, 107, -126, 76, -92, 12, 18, -83, -23, -92, -82, 63, -15, -61, 73, 101, -102, -116, -59, -56, 62, 37, -73, -108, -103, -69, -110, 50, 113, 7, -16, -122, 94, -19, 80, 39, -90, 13, -90, 35, -7, -69, -53, -90, 7, 20, 66, 1, 0, 41, 69, 110, 116, 114, 117, 115, 116, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 0, 0, 1, 66, 22, -98, 57, 29, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 4, 66, 48, -126, 4, 62, 48, -126, 3, 38, -96, 3, 2, 1, 2, 2, 4, 74, 83, -116, 40, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 11, 5, 0, 48, -127, -66, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 69, 110, 116, 114, 117, 115, 116, 44, 32, 73, 110, 99, 46, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 83, 101, 101, 32, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 108, 101, 103, 97, 108, 45, 116, 101, 114, 109, 115, 49, 57, 48, 55, 6, 3, 85, 4, 11, 19, 48, 40, 99, 41, 32, 50, 48, 48, 57, 32, 69, 110, 116, 114, 117, 115, 116, 44, 32, 73, 110, 99, 46, 32, 45, 32, 102, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 50, 48, 48, 6, 3, 85, 4, 3, 19, 41, 69, 110, 116, 114, 117, 115, 116, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 48, 30, 23, 13, 48, 57, 48, 55, 48, 55, 49, 55, 50, 53, 53, 52, 90, 23, 13, 51, 48, 49, 50, 48, 55, 49, 55, 53, 53, 53, 52, 90, 48, -127, -66, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 69, 110, 116, 114, 117, 115, 116, 44, 32, 73, 110, 99, 46, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 83, 101, 101, 32, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 108, 101, 103, 97, 108, 45, 116, 101, 114, 109, 115, 49, 57, 48, 55, 6, 3, 85, 4, 11, 19, 48, 40, 99, 41, 32, 50, 48, 48, 57, 32, 69, 110, 116, 114, 117, 115, 116, 44, 32, 73, 110, 99, 46, 32, 45, 32, 102, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 50, 48, 48, 6, 3, 85, 4, 3, 19, 41, 69, 110, 116, 114, 117, 115, 116, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -70, -124, -74, 114, -37, -98, 12, 107, -30, -103, -23, 48, 1, -89, 118, -22, 50, -72, -107, 65, 26, -55, -38, 97, 78, 88, 114, -49, -2, -10, -126, 121, -65, 115, 97, 6, 10, -91, 39, -40, -77, 95, -45, 69, 78, 28, 114, -42, 78, 50, -14, 114, -118, 15, -9, -125, 25, -48, 106, -128, -128, 0, 69, 30, -80, -57, -25, -102, -65, 18, 87, 39, 28, -93, 104, 47, 10, -121, -67, 106, 107, 14, 94, 101, -13, 28, 119, -43, -44, -123, -115, 112, 33, -76, -77, 50, -25, -117, -94, -43, -122, 57, 2, -79, -72, -46, 71, -50, -28, -55, 73, -60, 59, -89, -34, -5, 84, 125, 87, -66, -16, -24, 110, -62, 121, -78, 58, 11, 85, -30, 80, -104, 22, 50, 19, 92, 47, 120, 86, -63, -62, -108, -77, -14, 90, -28, 39, -102, -97, 36, -41, -58, -20, -48, -101, 37, -126, -29, -52, -62, -60, 69, -59, -116, -105, 122, 6, 107, 42, 17, -97, -87, 10, 110, 72, 59, 111, -37, -44, 17, 25, 66, -9, -113, 7, -65, -11, 83, 95, -100, 62, -12, 23, 44, -26, 105, -84, 78, 50, 76, 98, 119, -22, -73, -24, -27, -69, 52, -68, 25, -117, -82, -100, 81, -25, -73, 126, -75, 83, -79, 51, 34, -27, 109, -49, 112, 60, 26, -6, -30, -101, 103, -74, -125, -12, -115, -91, -81, 98, 76, 77, -32, 88, -84, 100, 52, 18, 3, -8, -74, -115, -108, 99, 36, -92, 113, 2, 3, 1, 0, 1, -93, 66, 48, 64, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 106, 114, 38, 122, -48, 30, -17, 125, -25, 59, 105, 81, -44, 108, -115, -97, -112, 18, 102, -85, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 11, 5, 0, 3, -126, 1, 1, 0, 121, -97, 29, -106, -58, -74, 121, 63, 34, -115, -121, -45, -121, 3, 4, 96, 106, 107, -102, 46, 89, -119, 115, 17, -84, 67, -47, -11, 19, -1, -115, 57, 43, -64, -14, -67, 79, 112, -116, -87, 47, -22, 23, -60, 11, 84, -98, -44, 27, -106, -104, 51, 60, -88, -83, 98, -94, 0, 118, -85, 89, 105, 110, 6, 29, 126, -60, -71, 68, -115, -104, -81, 18, -44, 97, -37, 10, 25, 70, 71, -13, -21, -9, 99, -63, 64, 5, 64, -91, -46, -73, -12, -75, -102, 54, -65, -87, -120, 118, -120, 4, 85, 4, 43, -100, -121, 127, 26, 55, 60, 126, 45, -91, 26, -40, -44, -119, 94, -54, -67, -84, 61, 108, -40, 109, -81, -43, -13, 118, 15, -51, 59, -120, 56, 34, -99, 108, -109, -102, -60, 61, -65, -126, 27, 101, 63, -90, 15, 93, -86, -4, -27, -78, 21, -54, -75, -83, -58, -68, 61, -48, -124, -24, -22, 6, 114, -80, 77, 57, 50, 120, -65, 62, 17, -100, 11, -92, -99, -102, 33, -13, -16, -101, 11, 48, 120, -37, -63, -36, -121, 67, -2, -68, 99, -102, -54, -59, -62, 28, -55, -57, -115, -1, 59, 18, 88, 8, -26, -74, 61, -20, 122, 44, 78, -5, -125, -106, -50, 12, 60, 105, -121, 84, 115, -92, 115, -62, -109, -1, 81, 16, -84, 21, 84, 1, -40, -4, 5, -79, -119, -95, 127, 116, -125, -102, 73, -41, -36, 78, 123, -118, 72, 111, -117, 69, -10, 1, 0, 18, 71, 101, 111, 84, 114, 117, 115, 116, 32, 71, 108, 111, 98, 97, 108, 32, 67, 65, 0, 0, 1, 66, 22, -98, 87, -100, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 3, 88, 48, -126, 3, 84, 48, -126, 2, 60, -96, 3, 2, 1, 2, 2, 3, 2, 52, 86, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, 66, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 71, 101, 111, 84, 114, 117, 115, 116, 32, 73, 110, 99, 46, 49, 27, 48, 25, 6, 3, 85, 4, 3, 19, 18, 71, 101, 111, 84, 114, 117, 115, 116, 32, 71, 108, 111, 98, 97, 108, 32, 67, 65, 48, 30, 23, 13, 48, 50, 48, 53, 50, 49, 48, 52, 48, 48, 48, 48, 90, 23, 13, 50, 50, 48, 53, 50, 49, 48, 52, 48, 48, 48, 48, 90, 48, 66, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 71, 101, 111, 84, 114, 117, 115, 116, 32, 73, 110, 99, 46, 49, 27, 48, 25, 6, 3, 85, 4, 3, 19, 18, 71, 101, 111, 84, 114, 117, 115, 116, 32, 71, 108, 111, 98, 97, 108, 32, 67, 65, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -38, -52, 24, 99, 48, -3, -12, 23, 35, 26, 86, 126, 91, -33, 60, 108, 56, -28, 113, -73, 120, -111, -44, -68, -95, -40, 76, -8, -88, 67, -74, 3, -23, 77, 33, 7, 8, -120, -38, 88, 47, 102, 57, 41, -67, 5, 120, -117, -99, 56, -24, 5, -73, 106, 126, 113, -92, -26, -60, 96, -90, -80, -17, -128, -28, -119, 40, 15, -98, 37, -42, -19, -125, -13, -83, -90, -111, -57, -104, -55, 66, 24, 53, 20, -99, -83, -104, 70, -110, 46, 79, -54, -15, -121, 67, -63, 22, -107, 87, 45, 80, -17, -119, 45, -128, 122, 87, -83, -14, -18, 95, 107, -46, 0, -115, -71, 20, -8, 20, 21, 53, -39, -64, 70, -93, 123, 114, -56, -111, -65, -55, 85, 43, -51, -48, -105, 62, -100, 38, 100, -52, -33, -50, -125, 25, 113, -54, 78, -26, -44, -43, 123, -87, 25, -51, 85, -34, -56, -20, -46, 94, 56, 83, -27, 92, 79, -116, 45, -2, 80, 35, 54, -4, 102, -26, -53, -114, -92, 57, 25, 0, -73, -107, 2, 57, -111, 11, 14, -2, 56, 46, -47, 29, 5, -102, -10, 77, 62, 111, 15, 7, 29, -81, 44, 30, -113, 96, 57, -30, -6, 54, 83, 19, 57, -44, 94, 38, 43, -37, 61, -88, 20, -67, 50, -21, 24, 3, 40, 82, 4, 113, -27, -85, 51, 61, -31, 56, -69, 7, 54, -124, 98, -100, 121, -22, 22, 48, -12, 95, -64, 43, -24, 113, 107, -28, -7, 2, 3, 1, 0, 1, -93, 83, 48, 81, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -64, 122, -104, 104, -115, -119, -5, -85, 5, 100, 12, 17, 125, -86, 125, 101, -72, -54, -52, 78, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, -64, 122, -104, 104, -115, -119, -5, -85, 5, 100, 12, 17, 125, -86, 125, 101, -72, -54, -52, 78, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, 53, -29, 41, 106, -27, 47, 93, 84, -114, 41, 80, -108, -97, -103, 26, 20, -28, -113, 120, 42, 98, -108, -94, 39, 103, -98, -48, -49, 26, 94, 71, -23, -63, -78, -92, -49, -35, 65, 26, 5, 78, -101, 75, -18, 74, 111, 85, 82, -77, 36, -95, 55, 10, -21, 100, 118, 42, 46, 44, -13, -3, 59, 117, -112, -65, -6, 113, -40, -57, 61, 55, -46, -75, 5, -107, 98, -71, -90, -34, -119, 61, 54, 123, 56, 119, 72, -105, -84, -90, 32, -113, 46, -90, -55, 12, -62, -78, -103, 69, 0, -57, -50, 17, 81, 34, 34, -32, -91, -22, -74, 21, 72, 9, 100, -22, 94, 79, 116, -9, 5, 62, -57, -118, 82, 12, -37, 21, -76, -67, 109, -101, -27, -58, -79, 84, 104, -87, -29, 105, -112, -74, -102, -91, 15, -72, -71, 63, 32, 125, -82, 74, -75, -72, -100, -28, 29, -74, -85, -26, -108, -91, -63, -57, -125, -83, -37, -11, 39, -121, 14, 4, 108, -43, -1, -35, -96, 93, -19, -121, 82, -73, 43, 21, 2, -82, 57, -90, 106, 116, -23, -38, -60, -25, -68, 77, 52, 30, -87, 92, 77, 51, 95, -110, 9, 47, -120, 102, 93, 119, -105, -57, 29, 118, 19, -87, -43, -27, -15, 22, 9, 17, 53, -43, -84, -37, 36, 113, 112, 44, -104, 86, 11, -39, 23, -76, -47, -29, 81, 43, 94, 117, -24, -43, -48, -36, 79, 52, -19, -62, 5, 102, -128, -95, -53, -26, 51, 1, 0, 36, 69, 110, 116, 114, 117, 115, 116, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 0, 0, 1, 66, 22, -98, 68, -17, 0, 0, 0, 0, 0, 5, 88, 46, 53, 48, 57, 0, 0, 4, -107, 48, -126, 4, -111, 48, -126, 3, 121, -96, 3, 2, 1, 2, 2, 4, 69, 107, 80, 84, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -80, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 69, 110, 116, 114, 117, 115, 116, 44, 32, 73, 110, 99, 46, 49, 57, 48, 55, 6, 3, 85, 4, 11, 19, 48, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 32, 105, 115, 32, 105, 110, 99, 111, 114, 112, 111, 114, 97, 116, 101, 100, 32, 98, 121, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 40, 99, 41, 32, 50, 48, 48, 54, 32, 69, 110, 116, 114, 117, 115, 116, 44, 32, 73, 110, 99, 46, 49, 45, 48, 43, 6, 3, 85, 4, 3, 19, 36, 69, 110, 116, 114, 117, 115, 116, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 48, 54, 49, 49, 50, 55, 50, 48, 50, 51, 52, 50, 90, 23, 13, 50, 54, 49, 49, 50, 55, 50, 48, 53, 51, 52, 50, 90, 48, -127, -80, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 69, 110, 116, 114, 117, 115, 116, 44, 32, 73, 110, 99, 46, 49, 57, 48, 55, 6, 3, 85, 4, 11, 19, 48, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 32, 105, 115, 32, 105, 110, 99, 111, 114, 112, 111, 114, 97, 116, 101, 100, 32, 98, 121, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 40, 99, 41, 32, 50, 48, 48, 54, 32, 69, 110, 116, 114, 117, 115, 116, 44, 32, 73, 110, 99, 46, 49, 45, 48, 43, 6, 3, 85, 4, 3, 19, 36, 69, 110, 116, 114, 117, 115, 116, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -74, -107, -74, 67, 66, -6, -58, 109, 42, 111, 72, -33, -108, 76, 57, 87, 5, -18, -61, 121, 17, 65, 104, 54, -19, -20, -2, -102, 1, -113, -95, 56, 40, -4, -9, 16, 70, 102, 46, 77, 30, 26, -79, 26, 78, -58, -47, -64, -107, -120, -80, -55, -1, 49, -117, 51, 3, -37, -73, -125, 123, 62, 32, -124, 94, -19, -78, 86, 40, -89, -8, -32, -71, 64, 113, 55, -59, -53, 71, 14, -105, 42, 104, -64, 34, -107, 98, 21, -37, 71, -39, -11, -48, 43, -1, -126, 75, -55, -83, 62, -34, 76, -37, -112, -128, 80, 63, 9, -118, -124, 0, -20, 48, 10, 61, 24, -51, -5, -3, 42, 89, -102, 35, -107, 23, 44, 69, -98, 31, 110, 67, 121, 109, 12, 92, -104, -2, 72, -89, -59, 35, 71, 92, 94, -3, 110, -25, 30, -76, -10, 104, 69, -47, -122, -125, 91, -94, -118, -115, -79, -29, 41, -128, -2, 37, 113, -120, -83, -66, -68, -113, -84, 82, -106, 75, -86, 81, -115, -28, 19, 49, 25, -24, 78, 77, -97, -37, -84, -77, 106, -43, -68, 57, 84, 113, -54, 122, 122, 127, -112, -35, 125, 29, -128, -39, -127, -69, 89, 38, -62, 17, -2, -26, -109, -30, -9, -128, -28, 101, -5, 52, 55, 14, 41, -128, 112, 77, -81, 56, -122, 46, -98, 127, 87, -81, -98, 23, -82, -21, 28, -53, 40, 33, 95, -74, 28, -40, -25, -94, 4, 34, -7, -45, -38, -40, -53, 2, 3, 1, 0, 1, -93, -127, -80, 48, -127, -83, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 43, 6, 3, 85, 29, 16, 4, 36, 48, 34, -128, 15, 50, 48, 48, 54, 49, 49, 50, 55, 50, 48, 50, 51, 52, 50, 90, -127, 15, 50, 48, 50, 54, 49, 49, 50, 55, 50, 48, 53, 51, 52, 50, 90, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 104, -112, -28, 103, -92, -90, 83, -128, -57, -122, 102, -92, -15, -9, 75, 67, -5, -124, -67, 109, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 104, -112, -28, 103, -92, -90, 83, -128, -57, -122, 102, -92, -15, -9, 75, 67, -5, -124, -67, 109, 48, 29, 6, 9, 42, -122, 72, -122, -10, 125, 7, 65, 0, 4, 16, 48, 14, 27, 8, 86, 55, 46, 49, 58, 52, 46, 48, 3, 2, 4, -112, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, -109, -44, 48, -80, -41, 3, 32, 42, -48, -7, 99, -24, -111, 12, 5, 32, -87, 95, 25, -54, 123, 114, 78, -44, -79, -37, -48, -106, -5, 84, 90, 25, 44, 12, 8, -9, -78, -68, -123, -88, -99, 127, 109, 59, 82, -77, 42, -37, -25, -44, -124, -116, 99, -10, 15, -53, 38, 1, -111, 80, 108, -12, 95, 20, -30, -109, 116, -64, 19, -98, 48, 58, 80, -29, -76, 96, -59, 28, -16, 34, 68, -115, 113, 71, -84, -56, 26, -55, -23, -101, -102, 0, 96, 19, -1, 112, 126, 95, 17, 77, 73, 27, -77, 21, 82, 123, -55, 84, -38, -65, -99, -107, -81, 107, -102, -40, -98, -23, -15, -28, 67, -115, -30, 17, 68, 58, -65, -81, -67, -125, 66, 115, 82, -117, -86, -69, -89, 41, -49, -11, 100, 28, 10, 77, -47, -68, -86, -84, -97, 42, -48, -1, 127, 127, -38, 125, -22, -79, -19, 48, 37, -63, -124, -38, 52, -46, 91, 120, -125, 86, -20, -100, 54, -61, 38, -30, 17, -10, 103, 73, 29, -110, -85, -116, -5, -21, -1, 122, -18, -123, 74, -89, 80, -128, -16, -89, 92, 74, -108, 46, 95, 5, -103, 60, 82, 65, -32, -51, -76, 99, -49, 1, 67, -70, -100, -125, -36, -113, 96, 59, -13, 90, -76, -76, 123, -82, -38, 11, -112, 56, 117, -17, -127, 29, 102, -46, -9, 87, 112, 54, -77, -65, -4, 40, -81, 113, 37, -123, 91, 19, -2, 30, 127, 90, -76, 60, 0, -107, -97, 49, -26, 34, -75, -8, 46, 64, -40, 74, 127, 97, 30, -100, -71, 85, 27, -84, -69};
    }
}

