/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.dropbox.client2.android.AuthActivity;
import com.dropbox.client2.session.AbstractSession;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.Session;
import java.util.Arrays;

public class AndroidAuthSession
extends AbstractSession {
    public AndroidAuthSession(AppKeyPair appKeyPair, Session.AccessType type) {
        super(appKeyPair, type);
    }

    public AndroidAuthSession(AppKeyPair appKeyPair, Session.AccessType type, AccessTokenPair accessTokenPair) {
        super(appKeyPair, type, accessTokenPair);
    }

    public AndroidAuthSession(AppKeyPair appKeyPair) {
        super(appKeyPair);
    }

    public AndroidAuthSession(AppKeyPair appKeyPair, AccessTokenPair accessTokenPair) {
        super(appKeyPair, accessTokenPair);
    }

    public AndroidAuthSession(AppKeyPair appKeyPair, String oauth2AccessToken) {
        super(appKeyPair, oauth2AccessToken);
    }

    public void startOAuth2Authentication(Context context) {
        this.startOAuth2Authentication(context, null);
    }

    public void startOAuth2Authentication(Context context, String[] alreadyAuthedUids) {
        this.startOAuth2Authentication(context, null, alreadyAuthedUids);
    }

    public void startOAuth2Authentication(Context context, String desiredUid, String[] alreadyAuthedUids) {
        AppKeyPair appKeyPair = this.getAppKeyPair();
        if (!AuthActivity.checkAppBeforeAuth(context, appKeyPair.key, true)) {
            return;
        }
        if (alreadyAuthedUids != null && Arrays.asList(alreadyAuthedUids).contains(desiredUid)) {
            throw new IllegalArgumentException("desiredUid cannot be present in alreadyAuthedUids");
        }
        AuthActivity.setAuthParams(appKeyPair.key, null, desiredUid, alreadyAuthedUids);
        Intent intent = new Intent(context, AuthActivity.class);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    public void startAuthentication(Context context) {
        AppKeyPair appKeyPair = this.getAppKeyPair();
        if (!AuthActivity.checkAppBeforeAuth(context, appKeyPair.key, true)) {
            return;
        }
        AuthActivity.setAuthParams(appKeyPair.key, appKeyPair.secret, null, null);
        Intent intent = new Intent(context, AuthActivity.class);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    public boolean authenticationSuccessful() {
        Intent data = AuthActivity.result;
        if (data == null) {
            return false;
        }
        String token = data.getStringExtra("ACCESS_TOKEN");
        String secret = data.getStringExtra("ACCESS_SECRET");
        String uid = data.getStringExtra("UID");
        return token != null && !token.equals("") && secret != null && !secret.equals("") && uid != null && !uid.equals("");
    }

    public String finishAuthentication() throws IllegalStateException {
        Intent data = AuthActivity.result;
        if (data == null) {
            throw new IllegalStateException();
        }
        String token = data.getStringExtra("ACCESS_TOKEN");
        if (token == null || token.length() == 0) {
            throw new IllegalArgumentException("Invalid result intent passed in. Missing access token.");
        }
        String secret = data.getStringExtra("ACCESS_SECRET");
        if (secret == null || secret.length() == 0) {
            throw new IllegalArgumentException("Invalid result intent passed in. Missing access secret.");
        }
        String uid = data.getStringExtra("UID");
        if (uid == null || uid.length() == 0) {
            throw new IllegalArgumentException("Invalid result intent passed in. Missing uid.");
        }
        if (token.equals("oauth2:")) {
            this.setOAuth2AccessToken(secret);
        } else {
            this.setAccessTokenPair(new AccessTokenPair(token, secret));
        }
        return uid;
    }

    public void unlink() {
        super.unlink();
        AuthActivity.result = null;
    }
}

