/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.session;

import java.io.Serializable;

public abstract class TokenPair
implements Serializable {
    private static final long serialVersionUID = -42727403799660313L;
    public final String key;
    public final String secret;

    public TokenPair(String key, String secret) {
        if (key == null) {
            throw new IllegalArgumentException("'key' must be non-null");
        }
        if (key.contains("|")) {
            throw new IllegalArgumentException("'key' must not contain a \"|\" character: \"" + key + "\"");
        }
        if (secret == null) {
            throw new IllegalArgumentException("'secret' must be non-null");
        }
        this.key = key;
        this.secret = secret;
    }

    public int hashCode() {
        return this.key.hashCode() ^ this.secret.hashCode() << 1;
    }

    public boolean equals(Object o) {
        return o instanceof TokenPair && this.equals((TokenPair)o);
    }

    public boolean equals(TokenPair o) {
        return this.key.equals(o.key) && this.secret.equals(o.secret);
    }

    public String toString() {
        return "{key=\"" + this.key + "\", secret=\"" + this.secret.charAt(0) + "...\"}";
    }
}

