/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.google.analytics.tracking.android.Clock;
import com.google.analytics.tracking.android.ExceptionParser;
import com.google.analytics.tracking.android.ExceptionReporter;
import com.google.analytics.tracking.android.GAServiceManager;
import com.google.analytics.tracking.android.GoogleAnalytics;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.ParameterLoader;
import com.google.analytics.tracking.android.ParameterLoaderImpl;
import com.google.analytics.tracking.android.ServiceManager;
import com.google.analytics.tracking.android.Tracker;
import com.google.analytics.tracking.android.Transaction;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class EasyTracker {
    private static EasyTracker sInstance;
    static final int NUM_MILLISECONDS_TO_WAIT_FOR_OPEN_ACTIVITY = 1000;
    private boolean mIsEnabled = false;
    private String mTrackingId;
    private String mAppName;
    private String mAppVersion;
    private int mDispatchPeriod = 1800;
    private boolean mDebug;
    private Double mSampleRate;
    private boolean mIsAnonymizeIpEnabled;
    private boolean mIsReportUncaughtExceptionsEnabled;
    private Thread.UncaughtExceptionHandler mExceptionHandler;
    private boolean mIsAutoActivityTracking = false;
    private int mActivitiesActive = 0;
    private long mSessionTimeout;
    private long mLastOnStopTime;
    private Context mContext;
    private final Map<String, String> mActivityNameMap = new HashMap<String, String>();
    private Tracker mTracker = null;
    private ParameterLoader mParameterFetcher;
    private GoogleAnalytics mAnalyticsInstance;
    private ServiceManager mServiceManager;
    private Clock mClock = new Clock(){

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    };
    private Timer mTimer;
    private TimerTask mTimerTask;
    private boolean mIsInForeground = false;

    private EasyTracker() {
    }

    public static EasyTracker getInstance() {
        if (sInstance == null) {
            sInstance = new EasyTracker();
        }
        return sInstance;
    }

    public static Tracker getTracker() {
        if (EasyTracker.getInstance().mContext == null) {
            throw new IllegalStateException("You must call EasyTracker.getInstance().setContext(context) or startActivity(activity) before calling getTracker()");
        }
        return EasyTracker.getInstance().mTracker;
    }

    boolean checkForNewSession() {
        return this.mSessionTimeout == 0L || this.mSessionTimeout > 0L && this.mClock.currentTimeMillis() > this.mLastOnStopTime + this.mSessionTimeout;
    }

    private void loadParameters() {
        this.mTrackingId = this.mParameterFetcher.getString("ga_trackingId");
        if (TextUtils.isEmpty((CharSequence)this.mTrackingId)) {
            this.mTrackingId = this.mParameterFetcher.getString("ga_api_key");
            if (TextUtils.isEmpty((CharSequence)this.mTrackingId)) {
                Log.e("EasyTracker requested, but missing required ga_trackingId");
                this.mTracker = new NoopTracker();
                return;
            }
        }
        this.mIsEnabled = true;
        this.mAppName = this.mParameterFetcher.getString("ga_appName");
        this.mAppVersion = this.mParameterFetcher.getString("ga_appVersion");
        this.mDebug = this.mParameterFetcher.getBoolean("ga_debug");
        this.mSampleRate = this.mParameterFetcher.getDoubleFromString("ga_sampleFrequency");
        if (this.mSampleRate == null) {
            this.mSampleRate = new Double(this.mParameterFetcher.getInt("ga_sampleRate", 100));
        }
        this.mDispatchPeriod = this.mParameterFetcher.getInt("ga_dispatchPeriod", 1800);
        this.mSessionTimeout = this.mParameterFetcher.getInt("ga_sessionTimeout", 30) * 1000;
        this.mIsAutoActivityTracking = this.mParameterFetcher.getBoolean("ga_autoActivityTracking") || this.mParameterFetcher.getBoolean("ga_auto_activity_tracking");
        this.mIsAnonymizeIpEnabled = this.mParameterFetcher.getBoolean("ga_anonymizeIp");
        this.mIsReportUncaughtExceptionsEnabled = this.mParameterFetcher.getBoolean("ga_reportUncaughtExceptions");
        this.mTracker = this.mAnalyticsInstance.getTracker(this.mTrackingId);
        if (!TextUtils.isEmpty((CharSequence)this.mAppName)) {
            Log.i("setting appName to " + this.mAppName);
            this.mTracker.setAppName(this.mAppName);
        }
        if (this.mAppVersion != null) {
            this.mTracker.setAppVersion(this.mAppVersion);
        }
        this.mTracker.setAnonymizeIp(this.mIsAnonymizeIpEnabled);
        this.mTracker.setSampleRate(this.mSampleRate);
        this.mAnalyticsInstance.setDebug(this.mDebug);
        this.mServiceManager.setDispatchPeriod(this.mDispatchPeriod);
        if (this.mIsReportUncaughtExceptionsEnabled) {
            Thread.UncaughtExceptionHandler newHandler = this.mExceptionHandler;
            if (newHandler == null) {
                ExceptionReporter reporter = new ExceptionReporter(this.mTracker, this.mServiceManager, Thread.getDefaultUncaughtExceptionHandler(), this.mContext);
                newHandler = reporter;
            }
            Thread.setDefaultUncaughtExceptionHandler(newHandler);
        }
    }

    @VisibleForTesting
    void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.mExceptionHandler = handler;
    }

    public void setContext(Context ctx) {
        if (ctx == null) {
            Log.e("Context cannot be null");
        } else {
            GAServiceManager sm = GAServiceManager.getInstance();
            this.setContext(ctx, new ParameterLoaderImpl(ctx.getApplicationContext()), GoogleAnalytics.getInstance(ctx.getApplicationContext()), sm);
        }
    }

    @VisibleForTesting
    void setContext(Context ctx, ParameterLoader parameterLoader, GoogleAnalytics ga, ServiceManager serviceManager) {
        if (ctx == null) {
            Log.e("Context cannot be null");
        }
        if (this.mContext == null) {
            this.mContext = ctx.getApplicationContext();
            this.mAnalyticsInstance = ga;
            this.mServiceManager = serviceManager;
            this.mParameterFetcher = parameterLoader;
            this.loadParameters();
        }
    }

    public void activityStart(Activity activity) {
        this.setContext((Context)activity);
        if (!this.mIsEnabled) {
            return;
        }
        this.clearExistingTimer();
        if (!this.mIsInForeground && this.mActivitiesActive == 0 && this.checkForNewSession()) {
            this.mTracker.setStartSession(true);
            if (!this.mIsAutoActivityTracking) {
                // empty if block
            }
        }
        this.mIsInForeground = true;
        ++this.mActivitiesActive;
        if (this.mIsAutoActivityTracking) {
            this.mTracker.sendView(this.getActivityName(activity));
        }
    }

    public void activityStop(Activity activity) {
        this.setContext((Context)activity);
        if (!this.mIsEnabled) {
            return;
        }
        --this.mActivitiesActive;
        this.mActivitiesActive = Math.max(0, this.mActivitiesActive);
        this.mLastOnStopTime = this.mClock.currentTimeMillis();
        if (this.mActivitiesActive == 0) {
            this.clearExistingTimer();
            this.mTimerTask = new NotInForegroundTimerTask();
            this.mTimer = new Timer("waitForActivityStart");
            this.mTimer.schedule(this.mTimerTask, 1000L);
        }
    }

    public void dispatch() {
        if (this.mIsEnabled) {
            this.mServiceManager.dispatch();
        }
    }

    private synchronized void clearExistingTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    private String getActivityName(Activity activity) {
        String canonicalName = activity.getClass().getCanonicalName();
        if (this.mActivityNameMap.containsKey(canonicalName)) {
            return this.mActivityNameMap.get(canonicalName);
        }
        String name = this.mParameterFetcher.getString(canonicalName);
        if (name == null) {
            name = canonicalName;
        }
        this.mActivityNameMap.put(canonicalName, name);
        return name;
    }

    @VisibleForTesting
    static void clearTracker() {
        sInstance = null;
    }

    @VisibleForTesting
    void setClock(Clock clock) {
        this.mClock = clock;
    }

    @VisibleForTesting
    int getActivitiesActive() {
        return this.mActivitiesActive;
    }

    private class NotInForegroundTimerTask
    extends TimerTask {
        private NotInForegroundTimerTask() {
        }

        @Override
        public void run() {
            EasyTracker.this.mIsInForeground = false;
        }
    }

    class NoopTracker
    extends Tracker {
        private String mAppId;
        private String mAppInstallerId;
        private double mSampleRate = 100.0;
        private boolean mIsAnonymizeIp;
        private boolean mIsUseSecure;
        private ExceptionParser mExceptionParser;

        NoopTracker() {
        }

        @Override
        public void setStartSession(boolean startSession) {
        }

        @Override
        public void setAppName(String appName) {
        }

        @Override
        public void setAppVersion(String appVersion) {
        }

        @Override
        public void setAppScreen(String appScreen) {
        }

        @Override
        public void sendView() {
        }

        @Override
        public void sendView(String appScreen) {
        }

        @Override
        public void sendEvent(String category, String action, String label, Long value) {
        }

        @Override
        public void sendTransaction(Transaction transaction) {
        }

        @Override
        public void sendException(String description, boolean fatal) {
        }

        @Override
        public void sendException(String threadName, Throwable exception, boolean fatal) {
        }

        @Override
        public void sendTiming(String category, long intervalInMilliseconds, String name, String label) {
        }

        @Override
        public void sendSocial(String network, String action, String target) {
        }

        @Override
        public void close() {
        }

        @Override
        public void send(String hitType, Map<String, String> params) {
        }

        @Override
        public String get(String key) {
            return "";
        }

        @Override
        public void set(String key, String value) {
        }

        @Override
        public String getTrackingId() {
            return "";
        }

        @Override
        public void setAnonymizeIp(boolean anonymizeIp) {
            this.mIsAnonymizeIp = anonymizeIp;
        }

        @Override
        public boolean isAnonymizeIpEnabled() {
            return this.mIsAnonymizeIp;
        }

        @Override
        public void setSampleRate(double sampleRate) {
            this.mSampleRate = sampleRate;
        }

        @Override
        public double getSampleRate() {
            return this.mSampleRate;
        }

        @Override
        public void setUseSecure(boolean useSecure) {
            this.mIsUseSecure = useSecure;
        }

        @Override
        public boolean isUseSecure() {
            return this.mIsUseSecure;
        }

        @Override
        public void setReferrer(String referrer) {
        }

        @Override
        public void setCampaign(String campaign) {
        }

        @Override
        public void setAppId(String appId) {
            this.mAppId = appId;
        }

        @Override
        public String getAppId() {
            return this.mAppId;
        }

        @Override
        public void setAppInstallerId(String appInstallerId) {
            this.mAppInstallerId = appInstallerId;
        }

        @Override
        public String getAppInstallerId() {
            return this.mAppInstallerId;
        }

        @Override
        public void setExceptionParser(ExceptionParser exceptionParser) {
            this.mExceptionParser = exceptionParser;
        }

        @Override
        public ExceptionParser getExceptionParser() {
            return this.mExceptionParser;
        }

        @Override
        public Map<String, String> constructEvent(String category, String action, String label, Long value) {
            return new HashMap<String, String>();
        }

        @Override
        public Map<String, String> constructTransaction(Transaction trans) {
            return new HashMap<String, String>();
        }

        @Override
        public Map<String, String> constructException(String exceptionDescription, boolean fatal) {
            return new HashMap<String, String>();
        }

        @Override
        public Map<String, String> constructRawException(String threadName, Throwable exception, boolean fatal) {
            return new HashMap<String, String>();
        }

        @Override
        public Map<String, String> constructTiming(String category, long intervalInMilliseconds, String name, String label) {
            return new HashMap<String, String>();
        }

        @Override
        public Map<String, String> constructSocial(String network, String action, String target) {
            return new HashMap<String, String>();
        }

        @Override
        public void setCustomDimension(int slot, String value) {
        }

        @Override
        public void setCustomMetric(int slot, Long value) {
        }

        @Override
        public void setCustomDimensionsAndMetrics(Map<Integer, String> dimensions, Map<Integer, Long> metrics) {
        }
    }
}

