/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import com.google.analytics.tracking.android.AnalyticsStore;
import com.google.analytics.tracking.android.Dispatcher;
import com.google.analytics.tracking.android.Hit;
import com.google.analytics.tracking.android.HitBuilder;
import com.google.analytics.tracking.android.HttpClientFactory;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;

class SimpleNetworkDispatcher
implements Dispatcher {
    private static final String USER_AGENT_TEMPLATE = "%s/%s (Linux; U; Android %s; %s; %s Build/%s)";
    private final String userAgent;
    private final HttpClientFactory httpClientFactory;
    private final Context ctx;

    SimpleNetworkDispatcher(AnalyticsStore store, HttpClientFactory httpClientFactory, Context ctx) {
        this(httpClientFactory, ctx);
    }

    SimpleNetworkDispatcher(HttpClientFactory httpClientFactory, Context ctx) {
        this.ctx = ctx.getApplicationContext();
        this.userAgent = this.createUserAgentString("GoogleAnalytics", "2.0", Build.VERSION.RELEASE, Utils.getLanguage(Locale.getDefault()), Build.MODEL, Build.ID);
        this.httpClientFactory = httpClientFactory;
    }

    @Override
    public boolean okToDispatch() {
        ConnectivityManager cm = (ConnectivityManager)this.ctx.getSystemService("connectivity");
        NetworkInfo network = cm.getActiveNetworkInfo();
        if (network == null || !network.isConnected()) {
            Log.vDebug("...no network connectivity");
            return false;
        }
        return true;
    }

    @Override
    public int dispatchHits(List<Hit> hits) {
        int hitsDispatched = 0;
        int maxHits = Math.min(hits.size(), 40);
        for (int i = 0; i < maxHits; ++i) {
            HttpClient client = this.httpClientFactory.newInstance();
            Hit hit = hits.get(i);
            URL url = this.getUrl(hit);
            if (url == null) {
                if (Log.isDebugEnabled()) {
                    Log.w("No destination: discarding hit: " + hit.getHitParams());
                } else {
                    Log.w("No destination: discarding hit.");
                }
                ++hitsDispatched;
                continue;
            }
            HttpHost targetHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
            String path = url.getPath();
            String params = TextUtils.isEmpty((CharSequence)hit.getHitParams()) ? "" : HitBuilder.postProcessHit(hit, System.currentTimeMillis());
            HttpEntityEnclosingRequest request = this.buildRequest(params, path);
            if (request == null) {
                ++hitsDispatched;
                continue;
            }
            request.addHeader("Host", targetHost.toHostString());
            this.logDebugInformation(Log.isDebugEnabled(), request);
            if (params.length() > 8192) {
                Log.w("Hit too long (> 8192 bytes)--not sent");
            } else {
                try {
                    HttpResponse response = client.execute(targetHost, (HttpRequest)request);
                    if (response.getStatusLine().getStatusCode() != 200) {
                        Log.w("Bad response: " + response.getStatusLine().getStatusCode());
                        return hitsDispatched;
                    }
                }
                catch (ClientProtocolException e) {
                    Log.w("ClientProtocolException sending hit; discarding hit...");
                }
                catch (IOException e) {
                    Log.w("Exception sending hit: " + e.getClass().getSimpleName());
                    Log.w(e.getMessage());
                    return hitsDispatched;
                }
            }
            ++hitsDispatched;
        }
        return hitsDispatched;
    }

    private HttpEntityEnclosingRequest buildRequest(String params, String path) {
        BasicHttpEntityEnclosingRequest request;
        if (TextUtils.isEmpty((CharSequence)params)) {
            Log.w("Empty hit, discarding.");
            return null;
        }
        String full = path + "?" + params;
        if (full.length() < 2036) {
            request = new BasicHttpEntityEnclosingRequest("GET", full);
        } else {
            request = new BasicHttpEntityEnclosingRequest("POST", path);
            try {
                request.setEntity((HttpEntity)new StringEntity(params));
            }
            catch (UnsupportedEncodingException e) {
                Log.w("Encoding error, discarding hit");
                return null;
            }
        }
        request.addHeader("User-Agent", this.userAgent);
        return request;
    }

    private void logDebugInformation(boolean debug, HttpEntityEnclosingRequest request) {
        if (debug) {
            StringBuffer httpHeaders = new StringBuffer();
            for (Header header : request.getAllHeaders()) {
                httpHeaders.append(header.toString()).append("\n");
            }
            httpHeaders.append(request.getRequestLine().toString()).append("\n");
            if (request.getEntity() != null) {
                try {
                    int avail;
                    InputStream is = request.getEntity().getContent();
                    if (is != null && (avail = is.available()) > 0) {
                        byte[] b = new byte[avail];
                        is.read(b);
                        httpHeaders.append("POST:\n");
                        httpHeaders.append(new String(b)).append("\n");
                    }
                }
                catch (IOException e) {
                    Log.w("Error Writing hit to log...");
                }
            }
            Log.i(httpHeaders.toString());
        }
    }

    String createUserAgentString(String product, String version, String release, String language, String model, String id) {
        return String.format(USER_AGENT_TEMPLATE, product, version, release, language, model, id);
    }

    private URL getUrl(Hit hit) {
        if (TextUtils.isEmpty((CharSequence)hit.getHitUrl())) {
            return null;
        }
        try {
            return new URL(hit.getHitUrl());
        }
        catch (MalformedURLException e) {
            try {
                return new URL("http://www.google-analytics.com/collect");
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }
}

