/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode.ui;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.lifecycle.LifecycleOwner;
import io.scanbot.common.Result;
import io.scanbot.common.ReturnBlockScope;
import io.scanbot.sdk.barcode.BarcodeCounterFrameHandler;
import io.scanbot.sdk.barcode.BarcodeItem;
import io.scanbot.sdk.barcode.BarcodeItemKt;
import io.scanbot.sdk.barcode.BarcodeScanner;
import io.scanbot.sdk.barcode.BarcodeScannerConfiguration;
import io.scanbot.sdk.barcode.BarcodeScannerResult;
import io.scanbot.sdk.barcode.R;
import io.scanbot.sdk.barcode.ScanbotSdkBarcodeScanner;
import io.scanbot.sdk.barcode.databinding.ScanbotSdkBarcodeScanCountViewBinding;
import io.scanbot.sdk.barcode.ui.BarcodePolygonsStaticView;
import io.scanbot.sdk.barcode.ui.BarcodeScanAndCountView;
import io.scanbot.sdk.barcode.ui.CaptureMode;
import io.scanbot.sdk.barcode.ui.IBarcodeCounterView;
import io.scanbot.sdk.barcode.ui.IBarcodeScanCountSelectionOverlayController;
import io.scanbot.sdk.barcode.ui.IBarcodeScanCountViewCallback;
import io.scanbot.sdk.barcode.ui.IBarcodeScanCountViewCameraConfiguration;
import io.scanbot.sdk.barcode.ui.IBarcodeScanCountViewController;
import io.scanbot.sdk.barcode.ui.dtk;
import io.scanbot.sdk.barcode.ui.dtz;
import io.scanbot.sdk.camera.BasePictureCallback;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.CaptureCallback;
import io.scanbot.sdk.camera.CaptureInfo;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.PictureCallback;
import io.scanbot.sdk.camera.ZoomRange;
import io.scanbot.sdk.image.ImageInfo;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.ui.camera.ScanbotCameraXView;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001?B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010,\u001a\u00020-H\u0016J\u001a\u0010.\u001a\u00020-2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010/\u001a\u0004\u0018\u00010\nH\u0016J\b\u00100\u001a\u00020-H\u0014J\b\u00101\u001a\u00020-H\u0014J\b\u00102\u001a\u00020\u0012H\u0002J$\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a05H\u0002J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0019H\u0002J\u0018\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001aH\u0002J\u0010\u0010=\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020\u001aH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006@"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodeScanAndCountView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/barcode/ui/IBarcodeCounterView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "barcodeScannerViewInterface", "Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountViewCallback;", "frameHandler", "Lio/scanbot/sdk/barcode/BarcodeCounterFrameHandler;", "scanState", "Lio/scanbot/sdk/barcode/ui/BarcodeScanAndCountView$ScanState;", "binding", "Lio/scanbot/sdk/barcode/databinding/ScanbotSdkBarcodeScanCountViewBinding;", "snapExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "barcodeScanner", "Lio/scanbot/sdk/barcode/BarcodeScanner;", "captureMode", "Lio/scanbot/sdk/barcode/ui/CaptureMode;", "value", "", "Lio/scanbot/sdk/barcode/BarcodeItem;", "", "countedBarcodes", "getCountedBarcodes", "()Ljava/util/Map;", "resultHandler", "Lio/scanbot/sdk/barcode/BarcodeCounterFrameHandler$ResultHandler;", "viewController", "Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountViewController;", "getViewController", "()Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountViewController;", "cameraConfiguration", "Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountViewCameraConfiguration;", "getCameraConfiguration", "()Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountViewCameraConfiguration;", "counterOverlayController", "Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountSelectionOverlayController;", "getCounterOverlayController", "()Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountSelectionOverlayController;", "initCamera", "", "initScanningBehavior", "callback", "onAttachedToWindow", "onDetachedFromWindow", "createSingleThreadPoolExecutor", "appendBarcodeItem", "barcodeItem", "", "getBarcodeItemUUID", "", "it", "processPictureTaken", "image", "Lio/scanbot/sdk/image/ImageRef;", "imageOrientation", "dpToPx", "dp", "ScanState", "sdk-barcode_release"})
@SourceDebugExtension(value={"SMAP\nBarcodeScanAndCountView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeScanAndCountView.kt\nio/scanbot/sdk/barcode/ui/BarcodeScanAndCountView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 SourceFile\nio/scanbot/common/ResultKt\n*L\n1#1,390:1\n1#2:391\n1#2:409\n1#2:428\n295#3,2:392\n2756#3:408\n2756#3:427\n103#4,11:394\n167#4,3:405\n170#4,7:410\n187#4,10:417\n*S KotlinDebug\n*F\n+ 1 BarcodeScanAndCountView.kt\nio/scanbot/sdk/barcode/ui/BarcodeScanAndCountView\n*L\n71#1:409\n371#1:428\n324#1:392,2\n71#1:408\n371#1:427\n355#1:394,11\n69#1:405,3\n69#1:410,7\n78#1:417,10\n*E\n"})
public final class BarcodeScanAndCountView
extends FrameLayout
implements IBarcodeCounterView {
    @Nullable
    private IBarcodeScanCountViewCallback barcodeScannerViewInterface;
    private BarcodeCounterFrameHandler frameHandler;
    @NotNull
    private ScanState scanState;
    @NotNull
    private ScanbotSdkBarcodeScanCountViewBinding binding;
    @NotNull
    private ThreadPoolExecutor snapExecutor;
    private BarcodeScanner barcodeScanner;
    @NotNull
    private CaptureMode captureMode;
    @NotNull
    private Map<BarcodeItem, Integer> countedBarcodes;
    @NotNull
    private final BarcodeCounterFrameHandler.ResultHandler resultHandler;
    @NotNull
    private final IBarcodeScanCountViewController viewController;
    @NotNull
    private final IBarcodeScanCountViewCameraConfiguration cameraConfiguration;
    @NotNull
    private final IBarcodeScanCountSelectionOverlayController counterOverlayController;

    /*
     * WARNING - void declaration
     */
    public BarcodeScanAndCountView(@NotNull Context context, @Nullable AttributeSet attrs) {
        void var2_2;
        void var1_1;
        BarcodeScanAndCountView barcodeScanAndCountView = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"context");
        super((Context)v1, (AttributeSet)var2_2);
        this.scanState = ScanState.IDLE;
        ScanbotSdkBarcodeScanCountViewBinding scanbotSdkBarcodeScanCountViewBinding = ScanbotSdkBarcodeScanCountViewBinding.inflate(LayoutInflater.from((Context)var1_1), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)scanbotSdkBarcodeScanCountViewBinding, (String)"inflate(...)");
        barcodeScanAndCountView.binding = scanbotSdkBarcodeScanCountViewBinding;
        barcodeScanAndCountView.snapExecutor = barcodeScanAndCountView.createSingleThreadPoolExecutor();
        barcodeScanAndCountView.captureMode = CaptureMode.FRAME;
        barcodeScanAndCountView.countedBarcodes = MapsKt.emptyMap();
        barcodeScanAndCountView.resultHandler = (arg_0, arg_1) -> BarcodeScanAndCountView.resultHandler$lambda$4(barcodeScanAndCountView, arg_0, arg_1);
        barcodeScanAndCountView.viewController = new IBarcodeScanCountViewController(this){
            final /* synthetic */ BarcodeScanAndCountView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            private static final void scanAndCount$lambda$0(BarcodeScanAndCountView this$0) {
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this$0).scanbotCameraView.freezePreview();
            }

            public void scanAndCount() {
                if (BarcodeScanAndCountView.access$getScanState$p(this.this$0) == ScanState.IDLE) {
                    Object object = BarcodeScanAndCountView.access$getBarcodeScannerViewInterface$p(this.this$0);
                    if (object != null) {
                        object.onScanAndCountStarted();
                    }
                    if (BarcodeScanAndCountView.access$getCaptureMode$p(this.this$0) == CaptureMode.FRAME) {
                        if (BarcodeScanAndCountView.access$getFrameHandler$p(this.this$0) != null) {
                            object = BarcodeScanAndCountView.access$getFrameHandler$p(this.this$0);
                            if (object == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
                                object = null;
                            }
                            ((BarcodeCounterFrameHandler)((Object)object)).performSingleShotScan();
                        }
                        BarcodeScanAndCountView barcodeScanAndCountView = this.this$0;
                        barcodeScanAndCountView.post(() -> viewController.1.scanAndCount$lambda$0(barcodeScanAndCountView));
                    } else {
                        BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.takePicture(false);
                    }
                    BarcodeScanAndCountView.access$setScanState$p(this.this$0, ScanState.SCANNING);
                    return;
                }
            }

            public void clearCountedBarcodes() {
                viewController.1 v0 = this;
                BarcodeScanAndCountView.access$setCountedBarcodes$p(v0.this$0, MapsKt.emptyMap());
                v0.continueScanning();
            }

            public void continueScanning() {
                if (BarcodeScanAndCountView.access$getScanState$p(this.this$0) == ScanState.RESULT) {
                    viewController.1 v0 = this;
                    BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)v0.this$0).barcodesPolygonView.clearBarcodes();
                    BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)v0.this$0).scanbotCameraView.unfreezePreview();
                    BarcodeScanAndCountView.access$setScanState$p(v0.this$0, ScanState.IDLE);
                    return;
                }
            }

            /*
             * WARNING - void declaration
             */
            public void setCaptureMode(CaptureMode mode) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"mode");
                BarcodeScanAndCountView.access$setCaptureMode$p(this.this$0, (CaptureMode)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setLifecycleOwner(LifecycleOwner lifecycleOwner) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"lifecycleOwner");
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setLifecycleOwner((LifecycleOwner)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void takePicture(boolean acquireFocus) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.takePicture((boolean)var1_1);
            }

            public void startPreview() {
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.startPreview();
            }

            public void stopPreview() {
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.stopPreview();
            }

            public void restartPreview() {
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.restartPreview();
            }

            public void continuousFocus() {
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.continuousFocus();
            }

            /*
             * WARNING - void declaration
             */
            public void useFlash(boolean flash) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.useFlash((boolean)var1_1);
            }
        };
        barcodeScanAndCountView.cameraConfiguration = new IBarcodeScanCountViewCameraConfiguration(this){
            final /* synthetic */ BarcodeScanAndCountView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public long getDelayAfterFocusCompleteMs() {
                return BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.getDelayAfterFocusCompleteMs();
            }

            /*
             * WARNING - void declaration
             */
            public void setDelayAfterFocusCompleteMs(long value) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setDelayAfterFocusCompleteMs((long)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setCameraPreviewMode(CameraPreviewMode cameraPreviewMode) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"cameraPreviewMode");
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setPreviewMode((CameraPreviewMode)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setCameraOrientationMode(CameraOrientationMode cameraOrientationMode) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
                int n = cameraConfiguration.WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()];
                if (n != 1) {
                    if (n == 2) {
                        BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.lockToLandscape(true);
                        return;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.lockToPortrait(true);
            }

            /*
             * WARNING - void declaration
             */
            public void setPhysicalZoomRatio(float zoomRatio) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setPhysicalZoom((float)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setPhysicalZoomRange(ZoomRange zoomRange) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"zoomRange");
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setPhysicalZoomRange((ZoomRange)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setCameraModule(CameraModule cameraModule) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"cameraModule");
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setCameraModule((CameraModule)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setShutterSound(boolean enabled) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setShutterSound((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setForceMaxSnappingSize(boolean enabled) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setForceMaxSnappingSize((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setForceMaxSnappingQuality(boolean enabled) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setForceMaxSnappingQuality((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void lockMinFocusDistance(boolean lock) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.lockMinFocusDistance((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setAutoFocusOnTouch(boolean enabled) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setAutoFocusOnTouch((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setAnalyzerFpsLimit(float fps) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setAnalyzerFpsLimit((float)var1_1);
            }
        };
        barcodeScanAndCountView.counterOverlayController = new IBarcodeScanCountSelectionOverlayController(this){
            final /* synthetic */ BarcodeScanAndCountView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public void setBarcodeItemViewFactory(BarcodePolygonsStaticView.BarcodeItemViewFactory barcodeItemViewFactory2) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).barcodesPolygonView.setBarcodeItemViewFactory((BarcodePolygonsStaticView.BarcodeItemViewFactory)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setBarcodeItemViewBinder(BarcodePolygonsStaticView.BarcodeItemViewBinder binder) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).barcodesPolygonView.setBarcodeItemViewBinder((BarcodePolygonsStaticView.BarcodeItemViewBinder)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setBarcodeItemViewPositionHandler(BarcodePolygonsStaticView.BarcodeItemViewPositionHandler positionHandler) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).barcodesPolygonView.setBarcodeItemViewPositionHandler((BarcodePolygonsStaticView.BarcodeItemViewPositionHandler)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setBarcodeAcceptedDelegate(BarcodePolygonsStaticView.BarcodeAcceptanceDelegate delegate) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).barcodesPolygonView.setBarcodeAcceptanceDelegate((BarcodePolygonsStaticView.BarcodeAcceptanceDelegate)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setBarcodeAppearanceDelegate(BarcodePolygonsStaticView.BarcodeAppearanceDelegate delegate) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).barcodesPolygonView.setBarcodeAppearanceDelegate((BarcodePolygonsStaticView.BarcodeAppearanceDelegate)var1_1);
            }
        };
    }

    public /* synthetic */ BarcodeScanAndCountView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    private final ThreadPoolExecutor createSingleThreadPoolExecutor() {
        ThreadPoolExecutor.DiscardPolicy discardPolicy;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        Object object = TimeUnit.MILLISECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor.DiscardPolicy discardPolicy2 = discardPolicy;
        discardPolicy = new ThreadPoolExecutor.DiscardPolicy();
        return new ThreadPoolExecutor(1, 1, 0L, (TimeUnit)((Object)object), linkedBlockingQueue2, discardPolicy2);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendBarcodeItem(BarcodeItem barcodeItem, Map<BarcodeItem, Integer> countedBarcodes) {
        void var2_2;
        Object var5_5;
        Integer n;
        BarcodeScanAndCountView barcodeScanAndCountView;
        block2: {
            String string = barcodeScanAndCountView.getBarcodeItemUUID((BarcodeItem)n);
            for (Object t : countedBarcodes.keySet()) {
                var5_5 = t;
                if (!Intrinsics.areEqual((Object)barcodeScanAndCountView.getBarcodeItemUUID((BarcodeItem)t), (Object)string)) continue;
                break block2;
            }
            var5_5 = null;
        }
        barcodeScanAndCountView = var5_5;
        if (barcodeScanAndCountView != null) {
            n = (Integer)var2_2.get(barcodeScanAndCountView);
            var2_2.put(barcodeScanAndCountView, (n != null ? n : 0) + 1);
            return;
        }
        var2_2.put(n, 1);
    }

    /*
     * WARNING - void declaration
     */
    private final String getBarcodeItemUUID(BarcodeItem it) {
        void var1_1;
        return it.getFormat().name() + BarcodeItemKt.getTextWithExtension((BarcodeItem)var1_1);
    }

    private final void processPictureTaken(ImageRef image, int imageOrientation) {
        block14: {
            BarcodeScanAndCountView barcodeScanAndCountView = this_;
            barcodeScanAndCountView.post(() -> BarcodeScanAndCountView.processPictureTaken$lambda$10(barcodeScanAndCountView));
            Object object = barcodeScanAndCountView.barcodeScanner;
            if (object != null) {
                ImageInfo imageInfo;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"barcodeScanner");
                    object = null;
                }
                object = object.run((ImageRef)imageInfo);
                ImageRef imageRef = ImageRef.CREATOR.fromEncodedBuffer$default((ImageRef.CREATOR)ImageRef.CREATOR, (byte[])new byte[0], null, (int)2, null);
                ImageInfo imageInfo2 = (ImageInfo)imageInfo.info().getOrNull();
                int n = imageInfo2 != null ? imageInfo2.getWidth() : 0;
                imageInfo = (ImageInfo)imageInfo.info().getOrNull();
                int n2 = imageInfo != null ? imageInfo.getHeight() : 0;
                ImageRef imageRef2 = imageRef;
                imageRef = CameraModule.BACK;
                FrameHandler.Frame frame = new FrameHandler.Frame(imageRef2, n, n2, 0, null, null, 0, 0, (CameraModule)imageRef, false);
                if (object instanceof Result.Success) {
                    Throwable throwable2;
                    Result.Success success;
                    BarcodeScanAndCountView barcodeScanAndCountView2 = this_;
                    new ReturnBlockScope();
                    BarcodeScannerResult barcodeScannerResult = (BarcodeScannerResult)((Result.Success)object).getData();
                    object = barcodeScannerResult.getBarcodes();
                    BarcodeScanAndCountView barcodeScanAndCountView3 = this_;
                    BarcodeScanAndCountView barcodeScanAndCountView4 = barcodeScanAndCountView3;
                    BarcodeCounterFrameHandler.ResultHandler resultHandler = barcodeScanAndCountView3.binding.barcodesPolygonView.getBarcodesResultHandler();
                    resultHandler.handle((Result)new Result.Success((Object)new BarcodeScannerResult((List)object, barcodeScannerResult.getSuccess())), frame);
                    barcodeScanAndCountView2.post(() -> BarcodeScanAndCountView.processPictureTaken$lambda$14$lambda$13((List)object, barcodeScanAndCountView4));
                    BarcodeScanAndCountView this_ = success;
                    try {
                        try {
                            success = new Result.Success((Object)Unit.INSTANCE);
                            new Result.Success((Object)this_);
                            return;
                        }
                        catch (Throwable throwable2) {
                        }
                    }
                    catch (Result.Failure failure) {
                        break block14;
                    }
                    String string = throwable2.getMessage();
                    if (string == null) {
                        string = "Unknown error";
                    }
                    this_ = new Result.UnknownError(string);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int dpToPx(int dp) {
        void var1_2;
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"getResources(...)");
        float f = (float)var1_2;
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        return MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)displayMetrics));
    }

    /*
     * WARNING - void declaration
     */
    private static final void resultHandler$lambda$4$lambda$2$lambda$1(BarcodeScanAndCountView this$0, BarcodeScannerResult $result) {
        IBarcodeScanCountViewCallback iBarcodeScanCountViewCallback = this$0.barcodeScannerViewInterface;
        if (iBarcodeScanCountViewCallback != null) {
            void var1_1;
            iBarcodeScanCountViewCallback.onScanAndCountFinished(var1_1.getBarcodes());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean resultHandler$lambda$4(BarcodeScanAndCountView this$0, Result result, FrameHandler.Frame frame) {
        BarcodeScanAndCountView barcodeScanAndCountView;
        Object object;
        block17: {
            String string;
            Intrinsics.checkNotNullParameter((Object)object, (String)"result");
            Intrinsics.checkNotNullParameter((Object)string, (String)"frame");
            if (result instanceof Result.Success) {
                new ReturnBlockScope();
                string = (BarcodeScannerResult)((Result.Success)object).getData();
                Map map = MapsKt.toMutableMap(barcodeScanAndCountView.countedBarcodes);
                Iterator iterator = string.getBarcodes().iterator();
                while (iterator.hasNext()) {
                    barcodeScanAndCountView.appendBarcodeItem((BarcodeItem)iterator.next(), map);
                }
                BarcodeScanAndCountView barcodeScanAndCountView2 = barcodeScanAndCountView;
                BarcodeScanAndCountView barcodeScanAndCountView3 = barcodeScanAndCountView2;
                barcodeScanAndCountView.countedBarcodes = MapsKt.toMap((Map)map);
                barcodeScanAndCountView2.post(() -> BarcodeScanAndCountView.resultHandler$lambda$4$lambda$2$lambda$1(barcodeScanAndCountView2, (BarcodeScannerResult)string));
                try {
                    barcodeScanAndCountView3.scanState = ScanState.RESULT;
                    break block17;
                }
                catch (Throwable throwable) {
                }
                catch (Result.Failure failure) {
                    break block17;
                }
                string = throwable.getMessage();
                if (string == null) {
                    string = "Unknown error";
                }
                object = new Result.UnknownError(string);
            }
        }
        if (!(object instanceof Result.Failure)) return false;
        if (object instanceof Result.OperationCanceledError) return false;
        try {
            Object object2;
            new ReturnBlockScope();
            object = (Result.Failure)((Object)object);
            if (object instanceof Result.InvalidLicenseError) {
                object2 = BuildersKt.runBlocking$default(null, (Function2)new dtk(barcodeScanAndCountView, null), (int)1, null);
                return false;
            }
            object2 = BuildersKt.runBlocking$default(null, (Function2)new dtz(barcodeScanAndCountView, (Result.Failure)((Object)object), null), (int)1, null);
            return false;
        }
        catch (Throwable throwable) {
        }
        catch (Result.Failure failure) {
            return false;
        }
        object = throwable.getMessage();
        if (object == null) {
            object = "Unknown error";
        }
        barcodeScanAndCountView = new Result.UnknownError((String)object);
        return false;
    }

    private static final void initCamera$lambda$5(BarcodeScanAndCountView this$0) {
        BarcodeScanAndCountView barcodeScanAndCountView;
        IBarcodeScanCountViewCallback iBarcodeScanCountViewCallback = this$0.barcodeScannerViewInterface;
        if (iBarcodeScanCountViewCallback != null) {
            iBarcodeScanCountViewCallback.onCameraOpen();
        }
        BarcodeScanAndCountView barcodeScanAndCountView2 = barcodeScanAndCountView;
        barcodeScanAndCountView2.binding.scanbotCameraView.setCaptureCallback(new CaptureCallback(barcodeScanAndCountView){
            final /* synthetic */ BarcodeScanAndCountView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public void onImageCaptured() {
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.stopPreview();
            }
        });
        barcodeScanAndCountView2.binding.scanbotCameraView.setShutterSound(false);
        barcodeScanAndCountView2.binding.scanbotCameraView.continuousFocus();
    }

    private static final void processPictureTaken$lambda$10(BarcodeScanAndCountView this$0) {
        this$0.binding.scanbotCameraView.freezePreview();
    }

    /*
     * WARNING - void declaration
     */
    private static final void processPictureTaken$lambda$14$lambda$13(List $items, BarcodeScanAndCountView this$0) {
        void var1_1;
        Object object = MapsKt.toMutableMap(var1_1.countedBarcodes);
        Iterator iterator = $items.iterator();
        while (iterator.hasNext()) {
            super.appendBarcodeItem((BarcodeItem)iterator.next(), (Map<BarcodeItem, Integer>)object);
        }
        var1_1.countedBarcodes = MapsKt.toMap((Map)object);
        object = var1_1.barcodeScannerViewInterface;
        if (object != null) {
            List list;
            object.onScanAndCountFinished(list);
        }
        var1_1.scanState = ScanState.RESULT;
    }

    public static final /* synthetic */ BarcodeScanner access$getBarcodeScanner$p(BarcodeScanAndCountView $this) {
        return $this.barcodeScanner;
    }

    public static final /* synthetic */ ThreadPoolExecutor access$getSnapExecutor$p(BarcodeScanAndCountView $this) {
        return $this.snapExecutor;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$processPictureTaken(BarcodeScanAndCountView $this, ImageRef image, int imageOrientation) {
        void var2_2;
        void var1_1;
        $this.processPictureTaken((ImageRef)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int access$dpToPx(BarcodeScanAndCountView $this, int dp) {
        void var1_1;
        return $this.dpToPx((int)var1_1);
    }

    public static final /* synthetic */ IBarcodeScanCountViewCallback access$getBarcodeScannerViewInterface$p(BarcodeScanAndCountView $this) {
        return $this.barcodeScannerViewInterface;
    }

    public static final /* synthetic */ ScanbotSdkBarcodeScanCountViewBinding access$getBinding$p(BarcodeScanAndCountView $this) {
        return $this.binding;
    }

    public static final /* synthetic */ ScanState access$getScanState$p(BarcodeScanAndCountView $this) {
        return $this.scanState;
    }

    public static final /* synthetic */ CaptureMode access$getCaptureMode$p(BarcodeScanAndCountView $this) {
        return $this.captureMode;
    }

    public static final /* synthetic */ BarcodeCounterFrameHandler access$getFrameHandler$p(BarcodeScanAndCountView $this) {
        return $this.frameHandler;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setScanState$p(BarcodeScanAndCountView $this, ScanState scanState) {
        void var1_1;
        $this.scanState = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setCountedBarcodes$p(BarcodeScanAndCountView $this, Map map) {
        void var1_1;
        $this.countedBarcodes = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setCaptureMode$p(BarcodeScanAndCountView $this, CaptureMode captureMode) {
        void var1_1;
        $this.captureMode = var1_1;
    }

    @NotNull
    public final Map<BarcodeItem, Integer> getCountedBarcodes() {
        return this.countedBarcodes;
    }

    @Override
    @NotNull
    public IBarcodeScanCountViewController getViewController() {
        return this.viewController;
    }

    @Override
    @NotNull
    public IBarcodeScanCountViewCameraConfiguration getCameraConfiguration() {
        return this.cameraConfiguration;
    }

    @Override
    @NotNull
    public IBarcodeScanCountSelectionOverlayController getCounterOverlayController() {
        return this.counterOverlayController;
    }

    @Override
    public void initCamera() {
        BarcodeScanAndCountView barcodeScanAndCountView = this;
        barcodeScanAndCountView.binding.scanbotCameraView.setPreviewMode(CameraPreviewMode.FILL_IN);
        barcodeScanAndCountView.binding.scanbotCameraView.setCameraOpenCallback(() -> BarcodeScanAndCountView.initCamera$lambda$5(this));
        barcodeScanAndCountView.binding.scanbotCameraView.addPictureCallback((BasePictureCallback)new PictureCallback(this){
            final /* synthetic */ BarcodeScanAndCountView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            private static final void onPictureTaken$lambda$0(BarcodeScanAndCountView this$0, ImageRef $image, CaptureInfo $captureInfo) {
                void var2_2;
                void var1_1;
                BarcodeScanAndCountView.access$processPictureTaken(this$0, (ImageRef)var1_1, var2_2.getImageOrientation());
            }

            /*
             * WARNING - void declaration
             */
            public void onPictureTaken(ImageRef image, CaptureInfo captureInfo) {
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"image");
                Intrinsics.checkNotNullParameter((Object)var2_2, (String)"captureInfo");
                if (BarcodeScanAndCountView.access$getBarcodeScanner$p(this.this$0) != null) {
                    BarcodeScanAndCountView.access$getSnapExecutor$p(this.this$0).execute(() -> initCamera.2.onPictureTaken$lambda$0(this.this$0, (ImageRef)var1_1, (CaptureInfo)var2_2));
                    return;
                }
            }
        });
        barcodeScanAndCountView.binding.barcodesPolygonView.setBarcodeItemViewFactory(new BarcodePolygonsStaticView.BarcodeItemViewFactory(this){
            final /* synthetic */ BarcodeScanAndCountView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public View createView() {
                ImageView imageView = new ImageView(barcodeScanAndCountView.this$0.getContext());
                BarcodeScanAndCountView barcodeScanAndCountView = barcodeScanAndCountView.this$0;
                imageView.setImageResource(R.drawable.ic_scanbot_checkmark);
                BarcodeScanAndCountView barcodeScanAndCountView2 = barcodeScanAndCountView;
                int n = BarcodeScanAndCountView.access$dpToPx(barcodeScanAndCountView2, 36);
                imageView.setLayoutParams(new ViewGroup.LayoutParams(n, BarcodeScanAndCountView.access$dpToPx(barcodeScanAndCountView2, 36)));
                return imageView;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initScanningBehavior(@NotNull BarcodeScanner barcodeScanner, @Nullable IBarcodeScanCountViewCallback callback) {
        BarcodeCounterFrameHandler barcodeCounterFrameHandler;
        Intrinsics.checkNotNullParameter((Object)barcodeScanner, (String)"barcodeScanner");
        BarcodeScannerConfiguration barcodeScannerConfiguration = barcodeCounterFrameHandler.copyCurrentConfiguration();
        barcodeScannerConfiguration.setOptimizedForOverlays(true);
        ScanbotSdkBarcodeScanner scanbotSdkBarcodeScanner = (ScanbotSdkBarcodeScanner)ScanbotSdkBarcodeScanner.Companion.create(barcodeScannerConfiguration).getOrNull();
        if (scanbotSdkBarcodeScanner != null) {
            void var2_2;
            this.barcodeScanner = scanbotSdkBarcodeScanner;
            ScanbotCameraXView scanbotCameraXView = this.binding.scanbotCameraView;
            Intrinsics.checkNotNullExpressionValue((Object)scanbotCameraXView, (String)"scanbotCameraView");
            this.frameHandler = barcodeCounterFrameHandler = BarcodeCounterFrameHandler.Companion.attach((IScanbotCameraView)scanbotCameraXView, (BarcodeScanner)barcodeCounterFrameHandler);
            if (barcodeCounterFrameHandler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
                barcodeCounterFrameHandler = null;
            }
            barcodeCounterFrameHandler.setEnabled(false);
            barcodeCounterFrameHandler = this.frameHandler;
            if (barcodeCounterFrameHandler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
                barcodeCounterFrameHandler = null;
            }
            barcodeCounterFrameHandler.setViewHandler(this.binding.barcodesPolygonView.getBarcodesResultHandler());
            this.binding.barcodesPolygonView.setBarcodeAcceptanceDelegate(new BarcodePolygonsStaticView.BarcodeAcceptanceDelegate(){

                public boolean shouldAccept(BarcodeItem barcodeItem) {
                    Intrinsics.checkNotNullParameter((Object)barcodeItem, (String)"barcodeItem");
                    return true;
                }
            });
            this.barcodeScannerViewInterface = var2_2;
            if (var2_2 != null) {
                barcodeCounterFrameHandler = this.frameHandler;
                if (barcodeCounterFrameHandler == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
                    barcodeCounterFrameHandler = null;
                }
                barcodeCounterFrameHandler.addResultHandler(this.resultHandler);
                return;
            }
            barcodeCounterFrameHandler = this.frameHandler;
            if (barcodeCounterFrameHandler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
                barcodeCounterFrameHandler = null;
            }
            barcodeCounterFrameHandler.removeResultHandler(this.resultHandler);
            return;
        }
    }

    public void onAttachedToWindow() {
        BarcodeScanAndCountView barcodeScanAndCountView = this;
        super.onAttachedToWindow();
        if (barcodeScanAndCountView.snapExecutor.isShutdown()) {
            this.snapExecutor = this.createSingleThreadPoolExecutor();
            return;
        }
    }

    public void onDetachedFromWindow() {
        BarcodeScanAndCountView barcodeScanAndCountView = this;
        super.onDetachedFromWindow();
        barcodeScanAndCountView.snapExecutor.shutdown();
    }

    @Metadata(mv={2, 1, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001j\u0002\b\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodeScanAndCountView$ScanState;", "", "IDLE", "SCANNING", "RESULT", "sdk-barcode_release"}, xi=48)
    public static final class ScanState
    extends Enum<ScanState> {
        public static final /* enum */ ScanState IDLE;
        public static final /* enum */ ScanState SCANNING;
        public static final /* enum */ ScanState RESULT;
        public static final /* synthetic */ ScanState[] dtg;
        public static final /* synthetic */ EnumEntries dtv;

        public static ScanState[] values() {
            return (ScanState[])dtg.clone();
        }

        public static ScanState valueOf(String value) {
            String string;
            return Enum.valueOf(ScanState.class, string);
        }

        @NotNull
        public static EnumEntries<ScanState> getEntries() {
            return dtv;
        }

        static {
            ScanState scanState;
            ScanState scanState2;
            ScanState scanState3;
            ScanState scanState4 = scanState3;
            IDLE = new ScanState();
            ScanState scanState5 = scanState2;
            SCANNING = new ScanState();
            ScanState scanState6 = scanState;
            RESULT = new ScanState();
            dtg = new ScanState[]{scanState4, scanState5, scanState6};
            dtv = EnumEntriesKt.enumEntries((Enum[])dtg);
        }
    }
}

