/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.util.CursorUtil;
import io.scanbot.sdk.util.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/scanbot/sdk/util/FileChooserUtils;", "", "()V", "CACHE_DIR", "", "CONTENT_SCHEME", "DOWNLOADS_AUTHORITY", "EXTERNALSTORAGE_AUTHORITY", "FILE_SCHEME", "MEDIA_AUTHORITY", "PUBLIC_DOWNLOADS_LINK", "getDataColumn", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getFilesFromContentUri", "Ljava/io/File;", "imageFileUri", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "getPath", "isDownloadsDocument", "", "isExternalStorageDocument", "isMediaDocument", "saveStreamToFile", "", "fileOutputStream", "Ljava/io/OutputStream;", "inputSteam", "Ljava/io/InputStream;", "sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nFileChooserUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileChooserUtils.kt\nio/scanbot/sdk/util/FileChooserUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,183:1\n37#2,2:184\n37#2,2:186\n1#3:188\n36#4:189\n*S KotlinDebug\n*F\n+ 1 FileChooserUtils.kt\nio/scanbot/sdk/util/FileChooserUtils\n*L\n47#1:184,2\n63#1:186,2\n84#1:189\n*E\n"})
public final class FileChooserUtils {
    @NotNull
    public static final FileChooserUtils INSTANCE = new FileChooserUtils();
    @NotNull
    private static final String CONTENT_SCHEME = "content";
    @NotNull
    private static final String FILE_SCHEME = "file";
    @NotNull
    private static final String EXTERNALSTORAGE_AUTHORITY = "com.android.externalstorage.documents";
    @NotNull
    private static final String DOWNLOADS_AUTHORITY = "com.android.providers.downloads.documents";
    @NotNull
    private static final String MEDIA_AUTHORITY = "com.android.providers.media.documents";
    @NotNull
    private static final String PUBLIC_DOWNLOADS_LINK = "content://downloads/public_downloads";
    @NotNull
    private static final String CACHE_DIR = "scanbotCacheDir";

    private FileChooserUtils() {
    }

    @JvmStatic
    @Nullable
    public static final String getPath(@NotNull Context context, @NotNull Uri uri, @NotNull FileIOProcessor fileIOProcessor) {
        String string;
        String[] stringArray;
        Object object;
        block15: {
            block14: {
                Uri uri2;
                block13: {
                    Intrinsics.checkNotNullParameter((Object)object, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)stringArray, (String)"uri");
                    Intrinsics.checkNotNullParameter((Object)uri2, (String)"fileIOProcessor");
                    if (!DocumentsContract.isDocumentUri((Context)context, (Uri)stringArray)) break block13;
                    if (FileChooserUtils.isExternalStorageDocument((Uri)stringArray)) {
                        String string2 = DocumentsContract.getDocumentId((Uri)stringArray);
                        Intrinsics.checkNotNull((Object)string2);
                        object = StringsKt.split$default((CharSequence)string2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).toArray(new String[0]);
                        if (StringsKt.equals((String)"primary", (String)object[0], (boolean)true)) {
                            return Environment.getExternalStorageDirectory().toString() + "/" + (String)object[1];
                        }
                    } else {
                        if (FileChooserUtils.isDownloadsDocument((Uri)stringArray)) {
                            Long l = Long.valueOf(DocumentsContract.getDocumentId((Uri)stringArray));
                            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"valueOf(...)");
                            Uri uri3 = ContentUris.withAppendedId((Uri)Uri.parse((String)PUBLIC_DOWNLOADS_LINK), (long)l);
                            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"withAppendedId(...)");
                            return FileChooserUtils.getDataColumn((Context)object, uri3, null, null);
                        }
                        if (FileChooserUtils.isMediaDocument((Uri)stringArray)) {
                            String string3 = DocumentsContract.getDocumentId((Uri)stringArray);
                            Intrinsics.checkNotNull((Object)string3);
                            stringArray = StringsKt.split$default((CharSequence)string3, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).toArray(new String[0]);
                            uri2 = null;
                            if (Intrinsics.areEqual((Object)"image", (Object)stringArray[0])) {
                                uri2 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                            }
                            Object object2 = object;
                            object = stringArray[1];
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = object;
                            return FileChooserUtils.getDataColumn((Context)object2, uri2, "_id=?", stringArray);
                        }
                    }
                    break block14;
                }
                if (StringsKt.equals((String)CONTENT_SCHEME, (String)stringArray.getScheme(), (boolean)true)) {
                    return (object = INSTANCE.getFilesFromContentUri((Context)object, (Uri)stringArray, (FileIOProcessor)uri2)) != null ? ((File)object).getPath() : null;
                }
                if (StringsKt.equals((String)FILE_SCHEME, (String)stringArray.getScheme(), (boolean)true) || (object = stringArray.getScheme()) == null || object.length() == 0) break block15;
            }
            return null;
        }
        object = stringArray.getPath();
        if (object != null) {
            Uri uri4 = Uri.fromFile((File)new File((String)object));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri4, (String)"Uri.fromFile(this)");
            string = uri4.getPath();
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final File getFilesFromContentUri(Context context, Uri imageFileUri, FileIOProcessor fileIOProcessor) {
        File file;
        if (StringsKt.equals$default((String)imageFileUri.getScheme(), (String)CONTENT_SCHEME, (boolean)false, (int)2, null)) {
            OutputStream outputStream;
            InputStream inputStream = outputStream.getContentResolver().openInputStream((Uri)file);
            if (inputStream != null) {
                void var3_3;
                File file2;
                file = file2;
                new File(FileUtils.getExternalCacheDirOrShowError((Context)outputStream, CACHE_DIR), UUID.randomUUID().toString() + ".jpg").createNewFile();
                outputStream = var3_3.openFileOutputStream(file);
                if (outputStream != null) {
                    this.saveStreamToFile(outputStream, inputStream);
                    return file;
                }
                throw new IOException("Can't create output stream for temporary image file " + file.getPath());
            }
            throw new IOException("Can't get input stream from content uri " + file.getPath());
        }
        throw new IOException("Can't get input stream from non content uri format please check schema: " + file.getPath());
    }

    /*
     * WARNING - void declaration
     */
    private final void saveStreamToFile(OutputStream fileOutputStream, InputStream inputSteam) {
        FileChooserUtils fileChooserUtils;
        OutputStream outputStream = fileOutputStream;
        FileChooserUtils fileChooserUtils2 = null;
        try {
            void var2_3;
            outputStream.write(ByteStreamsKt.readBytes((InputStream)var2_3));
            fileChooserUtils = fileChooserUtils2;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var1_2;
                CloseableKt.closeFinally((Closeable)var1_2, (Throwable)throwable);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally((Closeable)outputStream, (Throwable)((Object)fileChooserUtils));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String getDataColumn(@Nullable Context context, @Nullable Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        Object object;
        void var1_1;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_data";
        if (context == null) {
            object = var1_1 != null ? var1_1.getPath() : null;
            if (object == null) {
                object = "";
            }
            return object;
        }
        if (var1_1 != null) {
            void var3_4;
            void var2_3;
            if ((object = object.getContentResolver()) == null) {
                object = var1_1.getPath();
                if (object == null) {
                    object = "";
                } else {
                    Intrinsics.checkNotNull((Object)object);
                }
                return object;
            }
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2);
            object = object2.query((Uri)var1_1, stringArray2, (String)var2_3, (String[])var3_4, null);
            if (object != null) {
                Object object3 = object;
                int n = object3.getColumnIndexOrThrow("_data");
                object3.moveToFirst();
                String string = object3.getString(n);
                CursorUtil.closeQuietly((Cursor)object);
                Intrinsics.checkNotNull((Object)string);
                return string;
            }
        }
        if ((object = var1_1 != null ? var1_1.getPath() : null) == null) {
            object = "";
        }
        return object;
    }

    @JvmStatic
    public static final boolean isExternalStorageDocument(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)EXTERNALSTORAGE_AUTHORITY, (Object)uri2.getAuthority());
    }

    @JvmStatic
    public static final boolean isDownloadsDocument(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)DOWNLOADS_AUTHORITY, (Object)uri2.getAuthority());
    }

    @JvmStatic
    public static final boolean isMediaDocument(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)MEDIA_AUTHORITY, (Object)uri2.getAuthority());
    }
}

