/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.content.Context;
import android.os.Environment;
import io.scanbot.sdk.exceptions.files.FileAccessException;
import java.io.File;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\u0015\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\u0017\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0007J\u001c\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0007J\b\u0010\u001b\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/scanbot/sdk/util/FileUtils;", "", "<init>", "()V", "FILE_NAME_EXCEPTIONS_REGULAR_EXPRESSION", "", "MAX_FILE_NAME_LENGTH", "", "FILE_NAME_ANTIPATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "SCANBOT_SDK_FILES_DIR", "isFileNameSafe", "", "name", "", "getExternalFilesDirOrShowError", "Ljava/io/File;", "context", "Landroid/content/Context;", "directoryName", "getExternalStorageDirOrShowError", "getAppFilesDirOrShowError", "ensureDirExists", "directoryPath", "getFilesDirOrShowError", "parentDirPath", "fail", "sdk-base_release"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    @NotNull
    private static final String FILE_NAME_EXCEPTIONS_REGULAR_EXPRESSION = "[\\\\|?*<\\\">+\\[\\]/':]";
    private static final int MAX_FILE_NAME_LENGTH = 250;
    private static final Pattern FILE_NAME_ANTIPATTERN = Pattern.compile("[\\\\|?*<\\\">+\\[\\]/':]", 2);
    @NotNull
    public static final String SCANBOT_SDK_FILES_DIR = "scanbot-sdk";

    private FileUtils() {
    }

    @JvmStatic
    public static final boolean isFileNameSafe(@NotNull CharSequence name) {
        CharSequence charSequence;
        CharSequence charSequence2 = name;
        Intrinsics.checkNotNullParameter((Object)charSequence2, (String)"name");
        if (!StringsKt.isBlank((CharSequence)charSequence2) && charSequence.length() <= 250) {
            return FILE_NAME_ANTIPATTERN.matcher(charSequence).find() ^ true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final File getExternalFilesDirOrShowError(@NotNull Context context, @Nullable String directoryName) {
        void var1_1;
        File file;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = null;
        try {
            object = context2.getExternalFilesDir(null);
        }
        catch (NullPointerException nullPointerException) {}
        if (object == null) {
            return INSTANCE.fail();
        }
        File file2 = file;
        if (!new File((File)object, (String)var1_1).exists() && !file2.mkdirs()) {
            file2 = INSTANCE.fail();
        }
        return file2;
    }

    @JvmStatic
    @NotNull
    public static final File getExternalStorageDirOrShowError(@Nullable String directoryName) {
        String string;
        File file;
        File file2 = Environment.getExternalStorageDirectory();
        if (file2 == null) {
            return INSTANCE.fail();
        }
        File file3 = file;
        if (!new File(file2, string).exists() && !file3.mkdirs()) {
            return INSTANCE.fail();
        }
        return file3;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final File getAppFilesDirOrShowError(@NotNull Context context, @Nullable String directoryName) {
        void var1_1;
        File file;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = null;
        try {
            object = context2.getFilesDir();
        }
        catch (NullPointerException nullPointerException) {}
        if (object == null) {
            return INSTANCE.fail();
        }
        File file2 = file;
        if (!new File((File)object, (String)var1_1).exists() && !file2.mkdirs()) {
            file2 = INSTANCE.fail();
        }
        return file2;
    }

    @JvmStatic
    public static final boolean ensureDirExists(@Nullable String directoryPath) {
        String string;
        if (directoryPath != null && string.length() != 0) {
            File file;
            File file2 = file;
            return new File(string).exists() || file2.mkdirs();
            {
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final File getFilesDirOrShowError(@Nullable String parentDirPath, @Nullable String directoryName) {
        void var1_1;
        File file;
        File file2;
        File file3;
        File file4 = file3;
        file3 = new File((String)((Object)file2));
        file2 = file;
        if (!new File(file4, (String)var1_1).exists() && !file2.mkdirs()) {
            return INSTANCE.fail();
        }
        return file2;
    }

    private final File fail() {
        throw new FileAccessException("can't get external directory");
    }
}

