/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.commonsware.cwac.camera.CameraHost$RecordingHint;
import com.commonsware.cwac.camera.rla;
import com.commonsware.cwac.camera.rld;
import com.commonsware.cwac.camera.rlg;
import com.commonsware.cwac.camera.rlh;
import com.commonsware.cwac.camera.rlhi;
import com.commonsware.cwac.camera.rlj;
import com.commonsware.cwac.camera.rlk;
import com.commonsware.cwac.camera.rll;
import com.commonsware.cwac.camera.rllg;
import com.commonsware.cwac.camera.rllw;
import com.commonsware.cwac.camera.rln;
import com.commonsware.cwac.camera.rlo;
import com.commonsware.cwac.camera.rlp;
import com.commonsware.cwac.camera.rlq;
import com.commonsware.cwac.camera.rlqq;
import com.commonsware.cwac.camera.rls;
import com.commonsware.cwac.camera.rlsp;
import com.commonsware.cwac.camera.rlst;
import com.commonsware.cwac.camera.rltx;
import com.commonsware.cwac.camera.rlu;
import com.commonsware.cwac.camera.rlx;
import com.commonsware.cwac.camera.rlz;
import java.io.IOException;

public abstract class rlpk
extends ViewGroup
implements Camera.AutoFocusCallback {
    public static final int[] rls;
    public static final Handler rln;
    protected rlsp previewStrategy;
    public Camera.Size rld;
    public Camera rle = null;
    protected boolean inPreview = false;
    public rld rlq = null;
    public final rll rlk = null;
    public int rlx = -1;
    public int rlf = -1;
    public int rlb = -1;
    public MediaRecorder rlg = null;
    public Camera.Parameters rlj = null;
    public boolean rlz = false;
    public boolean rlw = false;
    public rln rlo;
    public int rlv;
    public WindowManager rlc;
    public boolean rli = false;
    public boolean rlu = false;

    public rlpk(Context context) {
        super(context);
        rll rll2;
        rll rll3 = rll2;
        rll2 = new rll(this, context);
        this.rlk = rll3;
    }

    /*
     * WARNING - void declaration
     */
    private void setCameraPictureOrientation(Camera.Parameters params) {
        void var1_1;
        Camera.CameraInfo cameraInfo;
        rlpk rlpk2 = this;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)rlpk2.rlb, (Camera.CameraInfo)cameraInfo2);
        if (rlpk2.rli && !this.rlu) {
            rlpk rlpk3 = this;
            rlpk3.rlf = rlpk3.rld(rlpk3.rlc.getDefaultDisplay().getOrientation());
        } else {
            this.rlf = cameraInfo2.facing == 1 ? (360 - this.rlx) % 360 : this.rlx;
        }
        if (this.rlf % 90 != 0) {
            this.rlf = 0;
        }
        var1_1.setRotation(this.rlf);
    }

    static {
        HandlerThread handlerThread;
        rls = new int[]{0, 90, 180, 270};
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread("CWAC_CAMERA", 10).start();
        rln = new Handler(handlerThread2.getLooper());
    }

    public rld getCameraHost() {
        return this.rlq;
    }

    public void setCameraHost(rld host) {
        rlhi rlhi2;
        rlsp rlsp2;
        this.rlq = rlsp2;
        if (((rllg)host.getDeviceProfile()).rle) {
            rlqq rlqq2;
            rlsp2 = rlqq2;
            rlqq2 = new rlqq(this);
            this.previewStrategy = rlsp2;
            return;
        }
        rlsp2 = rlhi2;
        rlhi2 = new rlhi(this);
        this.previewStrategy = rlsp2;
    }

    public synchronized Camera.Parameters getCameraParameters() {
        Camera camera = this.rle;
        if (camera != null && this.rlj == null) {
            try {
                this.rlj = camera.getParameters();
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getCameraParameters(). Could not work with camera parameters.");
            }
        }
        return this.rlj;
    }

    /*
     * WARNING - void declaration
     */
    public void setCameraParameters(Camera.Parameters parameters) {
        void var1_1;
        rln.post((Runnable)new rlo(this, (Camera.Parameters)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPreviewSize(Camera.Size newPreviewSize) {
        void var1_1;
        rln.post((Runnable)new rlu(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPictureSize(Camera.Size newPictureSize) {
        void var1_1;
        rln.post((Runnable)new rls(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCameraParametersSync(Camera.Parameters parameters) {
        try {
            void var1_1;
            Camera camera = this.rle;
            if (camera != null && var1_1 != null) {
                camera.setParameters((Camera.Parameters)var1_1);
            }
            this.rlj = var1_1;
            return;
        }
        catch (RuntimeException runtimeException) {}
        Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraParametersSync(). Could not set camera parameters.");
    }

    /*
     * WARNING - void declaration
     */
    public void onCameraOpen(Camera object) {
        block11: {
            void var2_4;
            try {
                this.previewStrategy.rld();
                break block11;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getCameraHost().handleException((Exception)var2_4);
        }
        this.rlc = (WindowManager)this.getContext().getSystemService("window");
        if (this.rli && !this.rlu) {
            this.rlk.enable();
        }
        this.rld();
        if (Build.VERSION.SDK_INT >= 14 && this.getCameraHost() instanceof Camera.FaceDetectionListener) {
            object.setFaceDetectionListener((Camera.FaceDetectionListener)this.getCameraHost());
        }
        if (this.rlo == null) {
            rln rln2;
            object = rln2;
            rln2 = new rln(this, this.getContext());
            this.rlo = object;
        }
        if (this.rlo.canDetectOrientation()) {
            this.rlo.enable();
        }
        if (this.rli) {
            this.rld();
            if (!this.rlu) {
                this.rlk.enable();
            } else {
                object = this.getCameraParameters();
                if (object != null) {
                    this.setCameraPictureOrientation((Camera.Parameters)object);
                    this.setCameraParametersSync((Camera.Parameters)object);
                }
            }
        }
    }

    public void onResume() {
        this.rlk.rld = -1;
        ViewGroup viewGroup = (ViewGroup)this.previewStrategy.rle().getParent();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        rlpk rlpk2 = this;
        rlpk2.addView(rlpk2.previewStrategy.rle());
        rln.post((Runnable)new rla(this));
    }

    public void onPause() {
        rln.post((Runnable)new rlg((rlpk)((Object)object)));
        if (object.previewStrategy.rle() != null) {
            rlpk rlpk2 = object;
            rlpk2.removeView(rlpk2.previewStrategy.rle());
        }
        rlpk rlpk3 = object;
        rlpk3.rlk.disable();
        Object object = rlpk3.rlo;
        if (object != null) {
            object.disable();
            return;
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        n2 = View.resolveSize((int)this.getSuggestedMinimumWidth(), (int)n2);
        n = View.resolveSize((int)this.getSuggestedMinimumHeight(), (int)n);
        this.setMeasuredDimension(n2, n);
        if (n2 > 0 && n > 0) {
            rln.post((Runnable)new rlp(this, n2, n));
            return;
        }
    }

    public Camera.Size getPreviewSize() {
        return this.rld;
    }

    /*
     * WARNING - void declaration
     */
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getChildCount() > 0) {
            int n;
            void var3_11;
            int n2;
            void var2_10;
            void var4_12;
            View view = this.getChildAt(0);
            var2_10 = var4_12 - var2_10;
            var3_11 = n2 - var3_11;
            Camera.Size size = this.rld;
            if (size != null && size.height > 0 && size.width > 0) {
                if (this.getDisplayOrientation() != 90 && this.getDisplayOrientation() != 270) {
                    Camera.Size size2 = this.rld;
                    n = size2.width;
                    n2 = size2.height;
                } else {
                    Camera.Size size3 = this.rld;
                    n = size3.height;
                    n2 = size3.width;
                }
            } else {
                n2 = var3_11;
                n = var2_10;
            }
            if (n != 0 && n2 != 0) {
                void var6_16 = var2_10 * n2;
                void var7_17 = var3_11 * n;
                boolean bl = var6_16 > var7_17;
                boolean n3 = this.getCameraHost().useFullBleedPreview();
                if (bl && !n3 || !bl && n3) {
                    void v2 = var2_10;
                    void var0_2 = var7_17 / n2;
                    void var1_8 = (v2 - var0_2) / 2;
                    void var0_3 = (v2 + var0_2) / 2;
                    view.layout((int)var1_8, 0, (int)var0_3, (int)var3_11);
                    return;
                }
                void v3 = var3_11;
                void var0_4 = var6_16 / n;
                void var1_9 = (v3 - var0_4) / 2;
                void var0_5 = (v3 + var0_4) / 2;
                view.layout(0, (int)var1_9, (int)var2_10, (int)var0_5);
                return;
            }
        }
    }

    public int getDisplayOrientation() {
        return this.rlx;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToLandscape(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(6);
        }
        rlpk rlpk2 = this;
        rlpk2.rli = true;
        rlpk2.rlu = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToPortrait(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(7);
        }
        rlpk rlpk2 = this;
        rlpk2.rli = true;
        rlpk2.rlu = var1_1;
    }

    public void unlockOrientation() {
        this.rli = false;
        this.rlu = false;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(-1);
        }
        rlpk rlpk2 = this;
        rlpk2.rlk.disable();
        rlpk2.post(new rlh(this));
    }

    public void restartPreview() {
        if (!this.inPreview) {
            this.startPreview();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void takePicture(boolean needBitmap, boolean needByteArray) {
        void var2_2;
        void var1_1;
        rllw rllw2;
        rllw rllw3 = rllw2;
        rllw3(this.getCameraHost());
        rllw3.rle = var1_1;
        rllw2.rlq = var2_2;
        this.takePicture(rllw2);
    }

    public abstract void takePicture(rllw var1);

    public boolean isRecording() {
        return this.rlg != null;
    }

    public void record() {
        if (Build.VERSION.SDK_INT >= 11) {
            MediaRecorder mediaRecorder;
            int n = this.rlx;
            if (n != 0 && n != 180) {
                throw new UnsupportedOperationException("Video recording supported only in landscape");
            }
            Camera.Parameters parameters = this.rle.getParameters();
            this.setCameraPictureOrientation(parameters);
            this.rle.setParameters(parameters);
            this.stopPreview();
            this.rle.unlock();
            parameters = mediaRecorder;
            try {
                this.rlg = parameters;
                new MediaRecorder().setCamera(this.rle);
                this.getCameraHost().configureRecorderAudio(this.rlb, this.rlg);
                this.rlg.setVideoSource(1);
                this.getCameraHost().configureRecorderProfile(this.rlb, this.rlg);
                this.getCameraHost().configureRecorderOutput(this.rlb, this.rlg);
                this.rlg.setOrientationHint(this.rlf);
                this.previewStrategy.rld(this.rlg);
                this.rlg.prepare();
                this.rlg.start();
                return;
            }
            catch (IOException iOException) {
                this.rlg.release();
                this.rlg = null;
                throw iOException;
            }
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public void stopRecording() {
        if (Build.VERSION.SDK_INT >= 11) {
            rlpk rlpk2 = this;
            MediaRecorder mediaRecorder = rlpk2.rlg;
            this.rlg = null;
            mediaRecorder.stop();
            mediaRecorder.release();
            rlpk2.rle.reconnect();
            return;
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public boolean isAutoFocusAvailable() {
        return this.inPreview;
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        this.rlw = false;
        if (this.getCameraHost() instanceof Camera.AutoFocusCallback) {
            this.getCameraHost().onAutoFocus(bl, camera);
            return;
        }
    }

    public String getFlashMode() {
        return this.rlj.getFlashMode();
    }

    /*
     * WARNING - void declaration
     */
    public void setFlashMode(String mode) {
        void var1_1;
        rln.post((Runnable)new rlq(this, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public rlst zoomTo(int level) {
        if (this_.rle != null) {
            void var1_1;
            Camera.Parameters parameters = this_.getCameraParameters();
            if (var1_1 >= 0 && var1_1 <= parameters.getMaxZoom()) {
                return new rlst(this_.rle, (int)var1_1);
            }
            Object this_ = (int)var1_1;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this_;
            throw new IllegalArgumentException(String.format("Invalid zoom level: %d", objectArray2));
        }
        throw new IllegalStateException("Yes, we have no camera, we have no camera today");
    }

    @TargetApi(value=14)
    public void startFaceDetection() {
        if (Build.VERSION.SDK_INT >= 14 && this.rle != null && !this.rlz && this.getCameraParameters().getMaxNumDetectedFaces() > 0) {
            this.rle.startFaceDetection();
            this.rlz = true;
            return;
        }
    }

    public void stopFaceDetection() {
        Camera camera;
        if (Build.VERSION.SDK_INT >= 14 && (camera = this.rle) != null && this.rlz) {
            camera.stopFaceDetection();
            this.rlz = false;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallback(Camera.PreviewCallback callback) {
        void var1_1;
        rln.post((Runnable)new rlk(this, (Camera.PreviewCallback)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBuffer(byte[] buffer) {
        void var1_1;
        rln.post((Runnable)new rlx(this, (byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallbackSync(Camera.PreviewCallback callback) {
        Camera camera = this.rle;
        if (camera != null) {
            try {
                void var1_1;
                camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)var1_1);
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setPreviewCallbackWithBuffer(). Could not set preview callback.", (Throwable)runtimeException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBufferSync(byte[] buffer) {
        void var1_1;
        rlpk this_ = this_.rle;
        if (this_ != null && var1_1 != null) {
            this_.addCallbackBuffer((byte[])var1_1);
            return;
        }
    }

    public boolean doesZoomReallyWork() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        rlpk rlpk2 = rltx2;
        cameraInfo2();
        Camera.getCameraInfo((int)rlpk2.getCameraHost().getCameraId(), (Camera.CameraInfo)cameraInfo2);
        rltx rltx2 = rlpk2.getCameraHost().getDeviceProfile();
        boolean bl = cameraInfo.facing == 1;
        return rltx2.rld(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void initPreview(int width, int height) {
        void var2_2;
        void var1_1;
        this.initPreview((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=14)
    public void initPreview(int w, int h, boolean firstRun) {
        void var2_2;
        void var1_1;
        rln.post((Runnable)new rlj(this, (int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initPreviewSync(int w, int h) {
        block7: {
            rlz rlz2;
            block8: {
                block6: {
                    Camera.Parameters parameters;
                    block5: {
                        if (this.rle == null) break block7;
                        try {
                            boolean bl;
                            rlpk rlpk2 = this;
                            parameters = rlpk2.getCameraParameters();
                            if (rlpk2.rld == null) {
                                void var2_3;
                                this.rld = this.getCameraHost().getPreviewSize(this.getDisplayOrientation(), bl ? 1 : 0, (int)var2_3, parameters);
                            }
                            Camera.Size size = this.rld;
                            bl = size.width;
                            parameters.setPreviewSize(bl ? 1 : 0, size.height);
                            if (Build.VERSION.SDK_INT < 14) break block5;
                            bl = this.getCameraHost().getRecordingHint() != CameraHost$RecordingHint.STILL_ONLY;
                            parameters.setRecordingHint(bl);
                        }
                        catch (Exception exception) {
                            break block6;
                        }
                    }
                    rlpk rlpk3 = this;
                    rlpk3.setCameraParametersSync(rlpk3.getCameraHost().adjustPreviewParameters(parameters));
                    break block8;
                }
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"initPreview(). Could not work with camera parameters.");
            }
            rlpk rlpk4 = this;
            rlz rlz3 = rlz2;
            rlz2 = new rlz(this);
            rlpk4.post(rlz3);
            rlpk4.startPreviewSync();
        }
    }

    public abstract void startPreview();

    public void startPreviewSync() {
        block3: {
            Camera camera = this.rle;
            if (camera == null) break block3;
            try {
                camera.startPreview();
                this.inPreview = true;
                this.getCameraHost().autoFocusAvailable();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"startPreviewSync(). Could not start preview.");
            }
        }
    }

    public abstract void stopPreview();

    public final void rle() {
        block3: {
            if (this.rle == null) break block3;
            try {
                rlpk rlpk2 = this;
                rlpk2.inPreview = false;
                rlpk2.getCameraHost().autoFocusUnavailable();
                rlpk2.rle.setPreviewCallback(null);
                rlpk2.rle.stopPreview();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"stopPreviewSync(). Could not stop preview.");
            }
        }
    }

    public final void rld() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Display display = this.rlc.getDefaultDisplay();
        int n = display.getRotation();
        int n2 = 0;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Camera.getCameraInfo((int)this.rlb, (Camera.CameraInfo)cameraInfo2);
        display.getMetrics(displayMetrics);
        switch (n) {
            default: {
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        this.rlx = cameraInfo2.facing == 1 ? (360 - (cameraInfo2.orientation + n2) % 360) % 360 : (cameraInfo2.orientation - n2 + 360) % 360;
        if (this.rle != null) {
            boolean bl = this.inPreview;
            if (bl) {
                this.rle();
            }
            try {
                this.rle.setDisplayOrientation(this.rlx);
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraDisplayOrientation(). Could not set camera display orientation.");
            }
            if (bl) {
                this.startPreviewSync();
            }
        }
    }

    public final int rld(int n) {
        Camera.CameraInfo cameraInfo;
        rlpk rlpk2 = rlpk3;
        rlpk rlpk3 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)rlpk2.rlb, (Camera.CameraInfo)rlpk3);
        n = (n + 45) / 90 * 90;
        if (((Camera.CameraInfo)rlpk3).facing == 1) {
            return (((Camera.CameraInfo)rlpk3).orientation - n + 360) % 360;
        }
        return (((Camera.CameraInfo)rlpk3).orientation + n) % 360;
    }
}

