/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.commonsware.cwac.camera.CameraHost$RecordingHint;
import com.commonsware.cwac.camera.yza;
import com.commonsware.cwac.camera.yzau;
import com.commonsware.cwac.camera.yzc;
import com.commonsware.cwac.camera.yzcf;
import com.commonsware.cwac.camera.yzdy;
import com.commonsware.cwac.camera.yze;
import com.commonsware.cwac.camera.yzg;
import com.commonsware.cwac.camera.yzi;
import com.commonsware.cwac.camera.yzj;
import com.commonsware.cwac.camera.yzk;
import com.commonsware.cwac.camera.yzm;
import com.commonsware.cwac.camera.yzn;
import com.commonsware.cwac.camera.yzp;
import com.commonsware.cwac.camera.yzph;
import com.commonsware.cwac.camera.yzr;
import com.commonsware.cwac.camera.yzry;
import com.commonsware.cwac.camera.yzsc;
import com.commonsware.cwac.camera.yzt;
import com.commonsware.cwac.camera.yztz;
import com.commonsware.cwac.camera.yzv;
import com.commonsware.cwac.camera.yzw;
import com.commonsware.cwac.camera.yzy;
import java.io.IOException;

public abstract class yzkj
extends ViewGroup
implements Camera.AutoFocusCallback {
    public static final int[] yzy;
    public static final Handler yza;
    protected yzdy previewStrategy;
    public Camera.Size yzt;
    public Camera yzs = null;
    protected boolean inPreview = false;
    public yzt yzv = null;
    public final yzw yzp = null;
    public int yzc = -1;
    public int yzu = -1;
    public int yzq = -1;
    public MediaRecorder yzg = null;
    public Camera.Parameters yzn = null;
    public boolean yzm = false;
    public boolean yzd = false;
    public yza yzr;
    public int yzf;
    public WindowManager yzx;
    public boolean yzl = false;
    public boolean yzj = false;

    public yzkj(Context context) {
        super(context);
        yzw yzw2;
        yzw yzw3 = yzw2;
        yzw2 = new yzw(this, context);
        this.yzp = yzw3;
    }

    /*
     * WARNING - void declaration
     */
    private void setCameraPictureOrientation(Camera.Parameters params) {
        void var1_1;
        Camera.CameraInfo cameraInfo;
        yzkj yzkj2 = this;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)yzkj2.yzq, (Camera.CameraInfo)cameraInfo2);
        if (yzkj2.yzl && !this.yzj) {
            yzkj yzkj3 = this;
            yzkj3.yzu = yzkj3.yzt(yzkj3.yzx.getDefaultDisplay().getOrientation());
        } else {
            this.yzu = cameraInfo2.facing == 1 ? (360 - this.yzc) % 360 : this.yzc;
        }
        if (this.yzu % 90 != 0) {
            this.yzu = 0;
        }
        var1_1.setRotation(this.yzu);
    }

    static {
        HandlerThread handlerThread;
        yzy = new int[]{0, 90, 180, 270};
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread("CWAC_CAMERA", 10).start();
        yza = new Handler(handlerThread2.getLooper());
    }

    public yzt getCameraHost() {
        return this.yzv;
    }

    public void setCameraHost(yzt host) {
        yzph yzph2;
        yzdy yzdy2;
        this.yzv = yzdy2;
        if (((yzsc)host.getDeviceProfile()).yzs) {
            yzcf yzcf2;
            yzdy2 = yzcf2;
            yzcf2 = new yzcf(this);
            this.previewStrategy = yzdy2;
            return;
        }
        yzdy2 = yzph2;
        yzph2 = new yzph(this);
        this.previewStrategy = yzdy2;
    }

    public synchronized Camera.Parameters getCameraParameters() {
        Camera camera = this.yzs;
        if (camera != null && this.yzn == null) {
            try {
                this.yzn = camera.getParameters();
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getCameraParameters(). Could not work with camera parameters.");
            }
        }
        return this.yzn;
    }

    /*
     * WARNING - void declaration
     */
    public void setCameraParameters(Camera.Parameters parameters) {
        void var1_1;
        yza.post((Runnable)new yzr(this, (Camera.Parameters)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPreviewSize(Camera.Size newPreviewSize) {
        void var1_1;
        yza.post((Runnable)new yzj(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPictureSize(Camera.Size newPictureSize) {
        void var1_1;
        yza.post((Runnable)new yzy(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCameraParametersSync(Camera.Parameters parameters) {
        try {
            void var1_1;
            Camera camera = this.yzs;
            if (camera != null && var1_1 != null) {
                camera.setParameters((Camera.Parameters)var1_1);
            }
            this.yzn = var1_1;
            return;
        }
        catch (RuntimeException runtimeException) {}
        Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraParametersSync(). Could not set camera parameters.");
    }

    /*
     * WARNING - void declaration
     */
    public void onCameraOpen(Camera object) {
        block11: {
            void var2_4;
            try {
                this.previewStrategy.yzt();
                break block11;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getCameraHost().handleException((Exception)var2_4);
        }
        this.yzx = (WindowManager)this.getContext().getSystemService("window");
        if (this.yzl && !this.yzj) {
            this.yzp.enable();
        }
        this.yzt();
        if (Build.VERSION.SDK_INT >= 14 && this.getCameraHost() instanceof Camera.FaceDetectionListener) {
            object.setFaceDetectionListener((Camera.FaceDetectionListener)this.getCameraHost());
        }
        if (this.yzr == null) {
            yza yza2;
            object = yza2;
            yza2 = new yza(this, this.getContext());
            this.yzr = object;
        }
        if (this.yzr.canDetectOrientation()) {
            this.yzr.enable();
        }
        if (this.yzl) {
            this.yzt();
            if (!this.yzj) {
                this.yzp.enable();
            } else {
                object = this.getCameraParameters();
                if (object != null) {
                    this.setCameraPictureOrientation((Camera.Parameters)object);
                    this.setCameraParametersSync((Camera.Parameters)object);
                }
            }
        }
    }

    public void onResume() {
        this.yzp.yzt = -1;
        ViewGroup viewGroup = (ViewGroup)this.previewStrategy.yzs().getParent();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        yzkj yzkj2 = this;
        yzkj2.addView(yzkj2.previewStrategy.yzs());
        yza.post((Runnable)new yzi(this));
    }

    public void onPause() {
        yza.post((Runnable)new yzg((yzkj)((Object)object)));
        if (object.previewStrategy.yzs() != null) {
            yzkj yzkj2 = object;
            yzkj2.removeView(yzkj2.previewStrategy.yzs());
        }
        yzkj yzkj3 = object;
        yzkj3.yzp.disable();
        Object object = yzkj3.yzr;
        if (object != null) {
            object.disable();
            return;
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        n2 = View.resolveSize((int)this.getSuggestedMinimumWidth(), (int)n2);
        n = View.resolveSize((int)this.getSuggestedMinimumHeight(), (int)n);
        this.setMeasuredDimension(n2, n);
        if (n2 > 0 && n > 0) {
            yza.post((Runnable)new yzk(this, n2, n));
            return;
        }
    }

    public Camera.Size getPreviewSize() {
        return this.yzt;
    }

    /*
     * WARNING - void declaration
     */
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getChildCount() > 0) {
            int n;
            void var3_11;
            int n2;
            void var2_10;
            void var4_12;
            View view = this.getChildAt(0);
            var2_10 = var4_12 - var2_10;
            var3_11 = n2 - var3_11;
            Camera.Size size = this.yzt;
            if (size != null && size.height > 0 && size.width > 0) {
                if (this.getDisplayOrientation() != 90 && this.getDisplayOrientation() != 270) {
                    Camera.Size size2 = this.yzt;
                    n = size2.width;
                    n2 = size2.height;
                } else {
                    Camera.Size size3 = this.yzt;
                    n = size3.height;
                    n2 = size3.width;
                }
            } else {
                n2 = var3_11;
                n = var2_10;
            }
            if (n != 0 && n2 != 0) {
                void var6_16 = var2_10 * n2;
                void var7_17 = var3_11 * n;
                boolean bl = var6_16 > var7_17;
                boolean n3 = this.getCameraHost().useFullBleedPreview();
                if (bl && !n3 || !bl && n3) {
                    void v2 = var2_10;
                    void var0_2 = var7_17 / n2;
                    void var1_8 = (v2 - var0_2) / 2;
                    void var0_3 = (v2 + var0_2) / 2;
                    view.layout((int)var1_8, 0, (int)var0_3, (int)var3_11);
                    return;
                }
                void v3 = var3_11;
                void var0_4 = var6_16 / n;
                void var1_9 = (v3 - var0_4) / 2;
                void var0_5 = (v3 + var0_4) / 2;
                view.layout(0, (int)var1_9, (int)var2_10, (int)var0_5);
                return;
            }
        }
    }

    public int getDisplayOrientation() {
        return this.yzc;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToLandscape(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(6);
        }
        yzkj yzkj2 = this;
        yzkj2.yzl = true;
        yzkj2.yzj = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToPortrait(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(7);
        }
        yzkj yzkj2 = this;
        yzkj2.yzl = true;
        yzkj2.yzj = var1_1;
    }

    public void unlockOrientation() {
        this.yzl = false;
        this.yzj = false;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(-1);
        }
        yzkj yzkj2 = this;
        yzkj2.yzp.disable();
        yzkj2.post(new yze(this));
    }

    public void restartPreview() {
        if (!this.inPreview) {
            this.startPreview();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void takePicture(boolean needBitmap, boolean needByteArray) {
        void var2_2;
        void var1_1;
        yztz yztz2;
        yztz yztz3 = yztz2;
        yztz3(this.getCameraHost());
        yztz3.yzs = var1_1;
        yztz2.yzv = var2_2;
        this.takePicture(yztz2);
    }

    public abstract void takePicture(yztz var1);

    public boolean isRecording() {
        return this.yzg != null;
    }

    public void record() {
        if (Build.VERSION.SDK_INT >= 11) {
            MediaRecorder mediaRecorder;
            int n = this.yzc;
            if (n != 0 && n != 180) {
                throw new UnsupportedOperationException("Video recording supported only in landscape");
            }
            Camera.Parameters parameters = this.yzs.getParameters();
            this.setCameraPictureOrientation(parameters);
            this.yzs.setParameters(parameters);
            this.stopPreview();
            this.yzs.unlock();
            parameters = mediaRecorder;
            try {
                this.yzg = parameters;
                new MediaRecorder().setCamera(this.yzs);
                this.getCameraHost().configureRecorderAudio(this.yzq, this.yzg);
                this.yzg.setVideoSource(1);
                this.getCameraHost().configureRecorderProfile(this.yzq, this.yzg);
                this.getCameraHost().configureRecorderOutput(this.yzq, this.yzg);
                this.yzg.setOrientationHint(this.yzu);
                this.previewStrategy.yzt(this.yzg);
                this.yzg.prepare();
                this.yzg.start();
                return;
            }
            catch (IOException iOException) {
                this.yzg.release();
                this.yzg = null;
                throw iOException;
            }
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public void stopRecording() {
        if (Build.VERSION.SDK_INT >= 11) {
            yzkj yzkj2 = this;
            MediaRecorder mediaRecorder = yzkj2.yzg;
            this.yzg = null;
            mediaRecorder.stop();
            mediaRecorder.release();
            yzkj2.yzs.reconnect();
            return;
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public boolean isAutoFocusAvailable() {
        return this.inPreview;
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        this.yzd = false;
        if (this.getCameraHost() instanceof Camera.AutoFocusCallback) {
            this.getCameraHost().onAutoFocus(bl, camera);
            return;
        }
    }

    public String getFlashMode() {
        return this.yzn.getFlashMode();
    }

    /*
     * WARNING - void declaration
     */
    public void setFlashMode(String mode) {
        void var1_1;
        yza.post((Runnable)new yzv(this, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public yzau zoomTo(int level) {
        if (this_.yzs != null) {
            void var1_1;
            Camera.Parameters parameters = this_.getCameraParameters();
            if (var1_1 >= 0 && var1_1 <= parameters.getMaxZoom()) {
                return new yzau(this_.yzs, (int)var1_1);
            }
            Object this_ = (int)var1_1;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this_;
            throw new IllegalArgumentException(String.format("Invalid zoom level: %d", objectArray2));
        }
        throw new IllegalStateException("Yes, we have no camera, we have no camera today");
    }

    @TargetApi(value=14)
    public void startFaceDetection() {
        if (Build.VERSION.SDK_INT >= 14 && this.yzs != null && !this.yzm && this.getCameraParameters().getMaxNumDetectedFaces() > 0) {
            this.yzs.startFaceDetection();
            this.yzm = true;
            return;
        }
    }

    public void stopFaceDetection() {
        Camera camera;
        if (Build.VERSION.SDK_INT >= 14 && (camera = this.yzs) != null && this.yzm) {
            camera.stopFaceDetection();
            this.yzm = false;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallback(Camera.PreviewCallback callback) {
        void var1_1;
        yza.post((Runnable)new yzp(this, (Camera.PreviewCallback)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBuffer(byte[] buffer) {
        void var1_1;
        yza.post((Runnable)new yzc(this, (byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallbackSync(Camera.PreviewCallback callback) {
        Camera camera = this.yzs;
        if (camera != null) {
            try {
                void var1_1;
                camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)var1_1);
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setPreviewCallbackWithBuffer(). Could not set preview callback.", (Throwable)runtimeException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBufferSync(byte[] buffer) {
        void var1_1;
        yzkj this_ = this_.yzs;
        if (this_ != null && var1_1 != null) {
            this_.addCallbackBuffer((byte[])var1_1);
            return;
        }
    }

    public boolean doesZoomReallyWork() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        yzkj yzkj2 = yzry2;
        cameraInfo2();
        Camera.getCameraInfo((int)yzkj2.getCameraHost().getCameraId(), (Camera.CameraInfo)cameraInfo2);
        yzry yzry2 = yzkj2.getCameraHost().getDeviceProfile();
        boolean bl = cameraInfo.facing == 1;
        return yzry2.yzt(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void initPreview(int width, int height) {
        void var2_2;
        void var1_1;
        this.initPreview((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=14)
    public void initPreview(int w, int h, boolean firstRun) {
        void var2_2;
        void var1_1;
        yza.post((Runnable)new yzn(this, (int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initPreviewSync(int w, int h) {
        block7: {
            yzm yzm2;
            block8: {
                block6: {
                    Camera.Parameters parameters;
                    block5: {
                        if (this.yzs == null) break block7;
                        try {
                            boolean bl;
                            yzkj yzkj2 = this;
                            parameters = yzkj2.getCameraParameters();
                            if (yzkj2.yzt == null) {
                                void var2_3;
                                this.yzt = this.getCameraHost().getPreviewSize(this.getDisplayOrientation(), bl ? 1 : 0, (int)var2_3, parameters);
                            }
                            Camera.Size size = this.yzt;
                            bl = size.width;
                            parameters.setPreviewSize(bl ? 1 : 0, size.height);
                            if (Build.VERSION.SDK_INT < 14) break block5;
                            bl = this.getCameraHost().getRecordingHint() != CameraHost$RecordingHint.STILL_ONLY;
                            parameters.setRecordingHint(bl);
                        }
                        catch (Exception exception) {
                            break block6;
                        }
                    }
                    yzkj yzkj3 = this;
                    yzkj3.setCameraParametersSync(yzkj3.getCameraHost().adjustPreviewParameters(parameters));
                    break block8;
                }
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"initPreview(). Could not work with camera parameters.");
            }
            yzkj yzkj4 = this;
            yzm yzm3 = yzm2;
            yzm2 = new yzm(this);
            yzkj4.post(yzm3);
            yzkj4.startPreviewSync();
        }
    }

    public abstract void startPreview();

    public void startPreviewSync() {
        block3: {
            Camera camera = this.yzs;
            if (camera == null) break block3;
            try {
                camera.startPreview();
                this.inPreview = true;
                this.getCameraHost().autoFocusAvailable();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"startPreviewSync(). Could not start preview.");
            }
        }
    }

    public abstract void stopPreview();

    public final void yzs() {
        block3: {
            if (this.yzs == null) break block3;
            try {
                yzkj yzkj2 = this;
                yzkj2.inPreview = false;
                yzkj2.getCameraHost().autoFocusUnavailable();
                yzkj2.yzs.setPreviewCallback(null);
                yzkj2.yzs.stopPreview();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"stopPreviewSync(). Could not stop preview.");
            }
        }
    }

    public final void yzt() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Display display = this.yzx.getDefaultDisplay();
        int n = display.getRotation();
        int n2 = 0;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Camera.getCameraInfo((int)this.yzq, (Camera.CameraInfo)cameraInfo2);
        display.getMetrics(displayMetrics);
        switch (n) {
            default: {
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        this.yzc = cameraInfo2.facing == 1 ? (360 - (cameraInfo2.orientation + n2) % 360) % 360 : (cameraInfo2.orientation - n2 + 360) % 360;
        if (this.yzs != null) {
            boolean bl = this.inPreview;
            if (bl) {
                this.yzs();
            }
            try {
                this.yzs.setDisplayOrientation(this.yzc);
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraDisplayOrientation(). Could not set camera display orientation.");
            }
            if (bl) {
                this.startPreviewSync();
            }
        }
    }

    public final int yzt(int n) {
        Camera.CameraInfo cameraInfo;
        yzkj yzkj2 = yzkj3;
        yzkj yzkj3 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)yzkj2.yzq, (Camera.CameraInfo)yzkj3);
        n = (n + 45) / 90 * 90;
        if (((Camera.CameraInfo)yzkj3).facing == 1) {
            return (((Camera.CameraInfo)yzkj3).orientation - n + 360) % 360;
        }
        return (((Camera.CameraInfo)yzkj3).orientation + n) % 360;
    }
}

