/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.commonsware.cwac.camera.CameraHost$RecordingHint;
import com.commonsware.cwac.camera.lmc;
import com.commonsware.cwac.camera.lme;
import com.commonsware.cwac.camera.lmeu;
import com.commonsware.cwac.camera.lmg;
import com.commonsware.cwac.camera.lmh;
import com.commonsware.cwac.camera.lmi;
import com.commonsware.cwac.camera.lmk;
import com.commonsware.cwac.camera.lml;
import com.commonsware.cwac.camera.lmlg;
import com.commonsware.cwac.camera.lmn;
import com.commonsware.cwac.camera.lmo;
import com.commonsware.cwac.camera.lmoy;
import com.commonsware.cwac.camera.lmq;
import com.commonsware.cwac.camera.lmr;
import com.commonsware.cwac.camera.lmsg;
import com.commonsware.cwac.camera.lmt;
import com.commonsware.cwac.camera.lmtf;
import com.commonsware.cwac.camera.lmu;
import com.commonsware.cwac.camera.lmum;
import com.commonsware.cwac.camera.lmw;
import com.commonsware.cwac.camera.lmwc;
import com.commonsware.cwac.camera.lmz;
import java.io.IOException;

public abstract class lmes
extends ViewGroup
implements Camera.AutoFocusCallback {
    public static final int[] lmn;
    public static final Handler lmg;
    protected lmum previewStrategy;
    public Camera.Size lmh;
    public Camera lmd = null;
    protected boolean inPreview = false;
    public lmh lmu = null;
    public final lmw lme = null;
    public int lmt = -1;
    public int lmb = -1;
    public int lmj = -1;
    public MediaRecorder lmk = null;
    public Camera.Parameters lmr = null;
    public boolean lmo = false;
    public boolean lmf = false;
    public lmg lmq;
    public int lma;
    public WindowManager lmv;
    public boolean lmy = false;
    public boolean lmc = false;

    public lmes(Context context) {
        super(context);
        lmw lmw2;
        lmw lmw3 = lmw2;
        lmw2 = new lmw(this, context);
        this.lme = lmw3;
    }

    /*
     * WARNING - void declaration
     */
    private void setCameraPictureOrientation(Camera.Parameters params) {
        void var1_1;
        Camera.CameraInfo cameraInfo;
        lmes lmes2 = this;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)lmes2.lmj, (Camera.CameraInfo)cameraInfo2);
        if (lmes2.lmy && !this.lmc) {
            lmes lmes3 = this;
            lmes3.lmb = lmes3.lmh(lmes3.lmv.getDefaultDisplay().getOrientation());
        } else {
            this.lmb = cameraInfo2.facing == 1 ? (360 - this.lmt) % 360 : this.lmt;
        }
        if (this.lmb % 90 != 0) {
            this.lmb = 0;
        }
        var1_1.setRotation(this.lmb);
    }

    static {
        HandlerThread handlerThread;
        lmn = new int[]{0, 90, 180, 270};
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread("CWAC_CAMERA", 10).start();
        lmg = new Handler(handlerThread2.getLooper());
    }

    public lmh getCameraHost() {
        return this.lmu;
    }

    public void setCameraHost(lmh host) {
        lmlg lmlg2;
        lmum lmum2;
        this.lmu = lmum2;
        if (((lmtf)host.getDeviceProfile()).lmd) {
            lmwc lmwc2;
            lmum2 = lmwc2;
            lmwc2 = new lmwc(this);
            this.previewStrategy = lmum2;
            return;
        }
        lmum2 = lmlg2;
        lmlg2 = new lmlg(this);
        this.previewStrategy = lmum2;
    }

    public synchronized Camera.Parameters getCameraParameters() {
        Camera camera = this.lmd;
        if (camera != null && this.lmr == null) {
            try {
                this.lmr = camera.getParameters();
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getCameraParameters(). Could not work with camera parameters.");
            }
        }
        return this.lmr;
    }

    /*
     * WARNING - void declaration
     */
    public void setCameraParameters(Camera.Parameters parameters) {
        void var1_1;
        lmg.post((Runnable)new lmq(this, (Camera.Parameters)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPreviewSize(Camera.Size newPreviewSize) {
        void var1_1;
        lmg.post((Runnable)new lmc(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPictureSize(Camera.Size newPictureSize) {
        void var1_1;
        lmg.post((Runnable)new lmn(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCameraParametersSync(Camera.Parameters parameters) {
        try {
            void var1_1;
            Camera camera = this.lmd;
            if (camera != null && var1_1 != null) {
                camera.setParameters((Camera.Parameters)var1_1);
            }
            this.lmr = var1_1;
            return;
        }
        catch (RuntimeException runtimeException) {}
        Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraParametersSync(). Could not set camera parameters.");
    }

    /*
     * WARNING - void declaration
     */
    public void onCameraOpen(Camera object) {
        block11: {
            void var2_4;
            try {
                this.previewStrategy.lmh();
                break block11;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getCameraHost().handleException((Exception)var2_4);
        }
        this.lmv = (WindowManager)this.getContext().getSystemService("window");
        if (this.lmy && !this.lmc) {
            this.lme.enable();
        }
        this.lmh();
        if (Build.VERSION.SDK_INT >= 14 && this.getCameraHost() instanceof Camera.FaceDetectionListener) {
            object.setFaceDetectionListener((Camera.FaceDetectionListener)this.getCameraHost());
        }
        if (this.lmq == null) {
            lmg lmg2;
            object = lmg2;
            lmg2 = new lmg(this, this.getContext());
            this.lmq = object;
        }
        if (this.lmq.canDetectOrientation()) {
            this.lmq.enable();
        }
        if (this.lmy) {
            this.lmh();
            if (!this.lmc) {
                this.lme.enable();
            } else {
                object = this.getCameraParameters();
                if (object != null) {
                    this.setCameraPictureOrientation((Camera.Parameters)object);
                    this.setCameraParametersSync((Camera.Parameters)object);
                }
            }
        }
    }

    public void onResume() {
        this.lme.lmh = -1;
        ViewGroup viewGroup = (ViewGroup)this.previewStrategy.lmd().getParent();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        lmes lmes2 = this;
        lmes2.addView(lmes2.previewStrategy.lmd());
        lmg.post((Runnable)new lmz(this));
    }

    public void onPause() {
        lmg.post((Runnable)new lmk((lmes)((Object)object)));
        if (object.previewStrategy.lmd() != null) {
            lmes lmes2 = object;
            lmes2.removeView(lmes2.previewStrategy.lmd());
        }
        lmes lmes3 = object;
        lmes3.lme.disable();
        Object object = lmes3.lmq;
        if (object != null) {
            object.disable();
            return;
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        n2 = View.resolveSize((int)this.getSuggestedMinimumWidth(), (int)n2);
        n = View.resolveSize((int)this.getSuggestedMinimumHeight(), (int)n);
        this.setMeasuredDimension(n2, n);
        if (n2 > 0 && n > 0) {
            lmg.post((Runnable)new lml(this, n2, n));
            return;
        }
    }

    public Camera.Size getPreviewSize() {
        return this.lmh;
    }

    /*
     * WARNING - void declaration
     */
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getChildCount() > 0) {
            int n;
            void var3_11;
            int n2;
            void var2_10;
            void var4_12;
            View view = this.getChildAt(0);
            var2_10 = var4_12 - var2_10;
            var3_11 = n2 - var3_11;
            Camera.Size size = this.lmh;
            if (size != null && size.height > 0 && size.width > 0) {
                if (this.getDisplayOrientation() != 90 && this.getDisplayOrientation() != 270) {
                    Camera.Size size2 = this.lmh;
                    n = size2.width;
                    n2 = size2.height;
                } else {
                    Camera.Size size3 = this.lmh;
                    n = size3.height;
                    n2 = size3.width;
                }
            } else {
                n2 = var3_11;
                n = var2_10;
            }
            if (n != 0 && n2 != 0) {
                void var6_16 = var2_10 * n2;
                void var7_17 = var3_11 * n;
                boolean bl = var6_16 > var7_17;
                boolean n3 = this.getCameraHost().useFullBleedPreview();
                if (bl && !n3 || !bl && n3) {
                    void v2 = var2_10;
                    void var0_2 = var7_17 / n2;
                    void var1_8 = (v2 - var0_2) / 2;
                    void var0_3 = (v2 + var0_2) / 2;
                    view.layout((int)var1_8, 0, (int)var0_3, (int)var3_11);
                    return;
                }
                void v3 = var3_11;
                void var0_4 = var6_16 / n;
                void var1_9 = (v3 - var0_4) / 2;
                void var0_5 = (v3 + var0_4) / 2;
                view.layout(0, (int)var1_9, (int)var2_10, (int)var0_5);
                return;
            }
        }
    }

    public int getDisplayOrientation() {
        return this.lmt;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToLandscape(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(6);
        }
        lmes lmes2 = this;
        lmes2.lmy = true;
        lmes2.lmc = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToPortrait(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(7);
        }
        lmes lmes2 = this;
        lmes2.lmy = true;
        lmes2.lmc = var1_1;
    }

    public void unlockOrientation() {
        this.lmy = false;
        this.lmc = false;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(-1);
        }
        lmes lmes2 = this;
        lmes2.lme.disable();
        lmes2.post(new lmi(this));
    }

    public void restartPreview() {
        if (!this.inPreview) {
            this.startPreview();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void takePicture(boolean needBitmap, boolean needByteArray) {
        void var2_2;
        void var1_1;
        lmsg lmsg2;
        lmsg lmsg3 = lmsg2;
        lmsg3(this.getCameraHost());
        lmsg3.lmd = var1_1;
        lmsg2.lmu = var2_2;
        this.takePicture(lmsg2);
    }

    public abstract void takePicture(lmsg var1);

    public boolean isRecording() {
        return this.lmk != null;
    }

    public void record() {
        if (Build.VERSION.SDK_INT >= 11) {
            MediaRecorder mediaRecorder;
            int n = this.lmt;
            if (n != 0 && n != 180) {
                throw new UnsupportedOperationException("Video recording supported only in landscape");
            }
            Camera.Parameters parameters = this.lmd.getParameters();
            this.setCameraPictureOrientation(parameters);
            this.lmd.setParameters(parameters);
            this.stopPreview();
            this.lmd.unlock();
            parameters = mediaRecorder;
            try {
                this.lmk = parameters;
                new MediaRecorder().setCamera(this.lmd);
                this.getCameraHost().configureRecorderAudio(this.lmj, this.lmk);
                this.lmk.setVideoSource(1);
                this.getCameraHost().configureRecorderProfile(this.lmj, this.lmk);
                this.getCameraHost().configureRecorderOutput(this.lmj, this.lmk);
                this.lmk.setOrientationHint(this.lmb);
                this.previewStrategy.lmh(this.lmk);
                this.lmk.prepare();
                this.lmk.start();
                return;
            }
            catch (IOException iOException) {
                this.lmk.release();
                this.lmk = null;
                throw iOException;
            }
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public void stopRecording() {
        if (Build.VERSION.SDK_INT >= 11) {
            lmes lmes2 = this;
            MediaRecorder mediaRecorder = lmes2.lmk;
            this.lmk = null;
            mediaRecorder.stop();
            mediaRecorder.release();
            lmes2.lmd.reconnect();
            return;
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public boolean isAutoFocusAvailable() {
        return this.inPreview;
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        this.lmf = false;
        if (this.getCameraHost() instanceof Camera.AutoFocusCallback) {
            this.getCameraHost().onAutoFocus(bl, camera);
            return;
        }
    }

    public String getFlashMode() {
        return this.lmr.getFlashMode();
    }

    /*
     * WARNING - void declaration
     */
    public void setFlashMode(String mode) {
        void var1_1;
        lmg.post((Runnable)new lmu(this, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public lmoy zoomTo(int level) {
        if (this_.lmd != null) {
            void var1_1;
            Camera.Parameters parameters = this_.getCameraParameters();
            if (var1_1 >= 0 && var1_1 <= parameters.getMaxZoom()) {
                return new lmoy(this_.lmd, (int)var1_1);
            }
            Object this_ = (int)var1_1;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this_;
            throw new IllegalArgumentException(String.format("Invalid zoom level: %d", objectArray2));
        }
        throw new IllegalStateException("Yes, we have no camera, we have no camera today");
    }

    @TargetApi(value=14)
    public void startFaceDetection() {
        if (Build.VERSION.SDK_INT >= 14 && this.lmd != null && !this.lmo && this.getCameraParameters().getMaxNumDetectedFaces() > 0) {
            this.lmd.startFaceDetection();
            this.lmo = true;
            return;
        }
    }

    public void stopFaceDetection() {
        Camera camera;
        if (Build.VERSION.SDK_INT >= 14 && (camera = this.lmd) != null && this.lmo) {
            camera.stopFaceDetection();
            this.lmo = false;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallback(Camera.PreviewCallback callback) {
        void var1_1;
        lmg.post((Runnable)new lme(this, (Camera.PreviewCallback)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBuffer(byte[] buffer) {
        void var1_1;
        lmg.post((Runnable)new lmt(this, (byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallbackSync(Camera.PreviewCallback callback) {
        Camera camera = this.lmd;
        if (camera != null) {
            try {
                void var1_1;
                camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)var1_1);
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setPreviewCallbackWithBuffer(). Could not set preview callback.", (Throwable)runtimeException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBufferSync(byte[] buffer) {
        void var1_1;
        lmes this_ = this_.lmd;
        if (this_ != null && var1_1 != null) {
            this_.addCallbackBuffer((byte[])var1_1);
            return;
        }
    }

    public boolean doesZoomReallyWork() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        lmes lmes2 = lmeu2;
        cameraInfo2();
        Camera.getCameraInfo((int)lmes2.getCameraHost().getCameraId(), (Camera.CameraInfo)cameraInfo2);
        lmeu lmeu2 = lmes2.getCameraHost().getDeviceProfile();
        boolean bl = cameraInfo.facing == 1;
        return lmeu2.lmh(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void initPreview(int width, int height) {
        void var2_2;
        void var1_1;
        this.initPreview((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=14)
    public void initPreview(int w, int h, boolean firstRun) {
        void var2_2;
        void var1_1;
        lmg.post((Runnable)new lmr(this, (int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initPreviewSync(int w, int h) {
        block7: {
            lmo lmo2;
            block8: {
                block6: {
                    Camera.Parameters parameters;
                    block5: {
                        if (this.lmd == null) break block7;
                        try {
                            boolean bl;
                            lmes lmes2 = this;
                            parameters = lmes2.getCameraParameters();
                            if (lmes2.lmh == null) {
                                void var2_3;
                                this.lmh = this.getCameraHost().getPreviewSize(this.getDisplayOrientation(), bl ? 1 : 0, (int)var2_3, parameters);
                            }
                            Camera.Size size = this.lmh;
                            bl = size.width;
                            parameters.setPreviewSize(bl ? 1 : 0, size.height);
                            if (Build.VERSION.SDK_INT < 14) break block5;
                            bl = this.getCameraHost().getRecordingHint() != CameraHost$RecordingHint.STILL_ONLY;
                            parameters.setRecordingHint(bl);
                        }
                        catch (Exception exception) {
                            break block6;
                        }
                    }
                    lmes lmes3 = this;
                    lmes3.setCameraParametersSync(lmes3.getCameraHost().adjustPreviewParameters(parameters));
                    break block8;
                }
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"initPreview(). Could not work with camera parameters.");
            }
            lmes lmes4 = this;
            lmo lmo3 = lmo2;
            lmo2 = new lmo(this);
            lmes4.post(lmo3);
            lmes4.startPreviewSync();
        }
    }

    public abstract void startPreview();

    public void startPreviewSync() {
        block3: {
            Camera camera = this.lmd;
            if (camera == null) break block3;
            try {
                camera.startPreview();
                this.inPreview = true;
                this.getCameraHost().autoFocusAvailable();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"startPreviewSync(). Could not start preview.");
            }
        }
    }

    public abstract void stopPreview();

    public final void lmd() {
        block3: {
            if (this.lmd == null) break block3;
            try {
                lmes lmes2 = this;
                lmes2.inPreview = false;
                lmes2.getCameraHost().autoFocusUnavailable();
                lmes2.lmd.setPreviewCallback(null);
                lmes2.lmd.stopPreview();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"stopPreviewSync(). Could not stop preview.");
            }
        }
    }

    public final void lmh() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Display display = this.lmv.getDefaultDisplay();
        int n = display.getRotation();
        int n2 = 0;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Camera.getCameraInfo((int)this.lmj, (Camera.CameraInfo)cameraInfo2);
        display.getMetrics(displayMetrics);
        switch (n) {
            default: {
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        this.lmt = cameraInfo2.facing == 1 ? (360 - (cameraInfo2.orientation + n2) % 360) % 360 : (cameraInfo2.orientation - n2 + 360) % 360;
        if (this.lmd != null) {
            boolean bl = this.inPreview;
            if (bl) {
                this.lmd();
            }
            try {
                this.lmd.setDisplayOrientation(this.lmt);
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraDisplayOrientation(). Could not set camera display orientation.");
            }
            if (bl) {
                this.startPreviewSync();
            }
        }
    }

    public final int lmh(int n) {
        Camera.CameraInfo cameraInfo;
        lmes lmes2 = lmes3;
        lmes lmes3 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)lmes2.lmj, (Camera.CameraInfo)lmes3);
        n = (n + 45) / 90 * 90;
        if (((Camera.CameraInfo)lmes3).facing == 1) {
            return (((Camera.CameraInfo)lmes3).orientation - n + 360) % 360;
        }
        return (((Camera.CameraInfo)lmes3).orientation + n) % 360;
    }
}

