/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.barcode.configuration;

import android.content.Context;
import android.util.DisplayMetrics;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.scanbot.sdk.barcode.BarcodeDocumentFormat;
import io.scanbot.sdk.barcode.BarcodeFormat;
import io.scanbot.sdk.barcode.BarcodeScannerEngineMode;
import io.scanbot.sdk.barcode.IBarcodeFilter;
import io.scanbot.sdk.barcode.MsiPlesseyChecksumAlgorithm;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.ZoomRange;
import io.scanbot.sdk.common.AspectRatio;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.configuration.json.CommonExtensionsKt;
import io.scanbot.sdk.ui.configuration.json.GsonHelper;
import io.scanbot.sdk.ui.configuration.json.JsonBarcodeDocumentFormat;
import io.scanbot.sdk.ui.configuration.json.JsonBarcodeFormat;
import io.scanbot.sdk.ui.configuration.json.JsonColorKt;
import io.scanbot.sdk.ui.configuration.json.JsonMSIPlesseyChecksumAlgorithm;
import io.scanbot.sdk.ui.view.barcode.SelectionOverlayConfiguration;
import io.scanbot.sdk.ui.view.barcode.configuration.BarcodeScannerAdditionalConfiguration;
import io.scanbot.sdk.ui.view.barcode.configuration.json.BarcodeJsonExtensionsKt;
import io.scanbot.sdk.ui.view.barcode.configuration.json.BarcodeScannerJsonConfiguration;
import io.scanbot.sdk.ui.view.barcode.configuration.json.BarcodeScannerNativeConfiguration;
import io.scanbot.sdk.ui.view.barcode.dialog.BarcodeConfirmationDialogConfiguration;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.util.JsonConfigUtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 e2\u00020\u0001:\u0001eB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\r2\b\b\u0001\u0010\u001e\u001a\u00020\u0012J\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\r2\b\b\u0001\u0010)\u001a\u00020\u0012J\u000e\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\r2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020\r2\u0006\u00104\u001a\u000202J\u000e\u00105\u001a\u00020\r2\u0006\u00106\u001a\u00020,J\u000e\u00107\u001a\u00020\r2\u0006\u00108\u001a\u00020,J\u000e\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020;J\u001e\u0010<\u001a\u00020\r2\u0016\u0010=\u001a\u0012\u0012\u0004\u0012\u00020?0>j\b\u0012\u0004\u0012\u00020?`@J\u000e\u0010A\u001a\u00020\r2\u0006\u0010B\u001a\u00020CJ\u0010\u0010D\u001a\u00020\r2\b\b\u0001\u0010E\u001a\u00020\u0012J\u000e\u0010F\u001a\u00020\r2\u0006\u0010G\u001a\u00020\u0012J\u000e\u0010H\u001a\u00020\r2\u0006\u0010I\u001a\u00020,J\u0010\u0010J\u001a\u00020\r2\b\b\u0001\u0010K\u001a\u00020\u0012J\u000e\u0010L\u001a\u00020\r2\u0006\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u00020\r2\u0006\u00104\u001a\u000202J\u000e\u0010P\u001a\u00020\r2\u0006\u0010Q\u001a\u00020NJ\u000e\u0010R\u001a\u00020\r2\u0006\u0010S\u001a\u00020TJ\u000e\u0010U\u001a\u00020\r2\u0006\u0010.\u001a\u00020VJ\u000e\u0010W\u001a\u00020\r2\u0006\u0010X\u001a\u00020NJ\u0010\u0010Y\u001a\u00020\r2\b\b\u0001\u0010Z\u001a\u00020\u0012J\u0010\u0010[\u001a\u00020\r2\b\b\u0001\u0010\\\u001a\u00020\u0012J\u0010\u0010]\u001a\u00020\r2\b\b\u0001\u0010^\u001a\u00020\u0012J\u000e\u0010_\u001a\u00020\r2\u0006\u0010`\u001a\u00020NJ\u000e\u0010a\u001a\u00020\r2\u0006\u0010b\u001a\u00020NJ\u000e\u0010c\u001a\u00020\r2\u0006\u0010d\u001a\u00020NR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006f"}, d2={"Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration;", "", "()V", "params", "Lio/scanbot/sdk/ui/view/barcode/configuration/json/BarcodeScannerJsonConfiguration;", "nativeParams", "Lio/scanbot/sdk/ui/view/barcode/configuration/json/BarcodeScannerNativeConfiguration;", "(Lio/scanbot/sdk/ui/view/barcode/configuration/json/BarcodeScannerJsonConfiguration;Lio/scanbot/sdk/ui/view/barcode/configuration/json/BarcodeScannerNativeConfiguration;)V", "getNativeParams", "()Lio/scanbot/sdk/ui/view/barcode/configuration/json/BarcodeScannerNativeConfiguration;", "getParams", "()Lio/scanbot/sdk/ui/view/barcode/configuration/json/BarcodeScannerJsonConfiguration;", "setAdditionalScanningParameters", "", "additionalConfiguration", "Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerAdditionalConfiguration;", "setAutoCancelTimeout", "seconds", "", "setBarcodeFilter", "barcodeFilter", "Lio/scanbot/sdk/barcode/IBarcodeFilter;", "setBarcodeFormatsFilter", "barcodeFormat", "", "Lio/scanbot/sdk/barcode/BarcodeFormat;", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraOverlayColor", "cameraOverlayColor", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setCameraZoomRange", "zoomRange", "Lio/scanbot/sdk/camera/ZoomRange;", "setCameraZoomRatio", "zoomFactor", "", "setCancelButtonIcon", "cancelButtonIcon", "setCancelButtonTitle", "cancelButtonTitle", "", "setConfirmationDialogConfiguration", "configuration", "Lio/scanbot/sdk/ui/view/barcode/dialog/BarcodeConfirmationDialogConfiguration;", "setDelayAfterFocusCompleteMs", "delay", "", "setDelayAfterScanMs", "milliseconds", "setEnableCameraButtonTitle", "enableCameraButtonTitle", "setEnableCameraExplanationText", "enableCameraExplanationText", "setEngineMode", "engineMode", "Lio/scanbot/sdk/barcode/BarcodeScannerEngineMode;", "setExtractedDocumentFormats", "documentFormats", "Ljava/util/ArrayList;", "Lio/scanbot/sdk/barcode/BarcodeDocumentFormat;", "Lkotlin/collections/ArrayList;", "setFinderAspectRatio", "finderAspectRatio", "Lio/scanbot/sdk/common/AspectRatio;", "setFinderLineColor", "finderLineColor", "setFinderLineWidth", "finderLineWidth", "setFinderTextHint", "finderTextHint", "setFinderTextHintColor", "finderTextHintColor", "setFlashEnabled", "flashEnabled", "", "setInitialScanDelayMs", "setMinFocusDistanceLock", "lock", "setOrientationLockMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setSelectionOverlayConfiguration", "Lio/scanbot/sdk/ui/view/barcode/SelectionOverlayConfiguration;", "setSuccessBeepEnabled", "successBeepEnabled", "setTopBarBackgroundColor", "topBarBackgroundColor", "setTopBarButtonsColor", "topBarButtonsColor", "setTopBarButtonsInactiveColor", "topBarButtonsInactiveColor", "setTouchToFocusEnabled", "enabled", "setUseButtonsAllCaps", "allCaps", "setViewFinderEnabled", "viewFinderEnabled", "Companion", "rtu-ui-barcode_release"})
@SourceDebugExtension(value={"SMAP\nBarcodeScannerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeScannerConfiguration.kt\nio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration\n+ 2 JsonConfigUtils.kt\nio/scanbot/sdk/util/JsonConfigUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ThemeUtils.kt\nio/scanbot/sdk/ui/utils/ThemeUtilsKt\n*L\n1#1,285:1\n20#2,16:286\n1603#3,9:302\n1855#3:311\n1856#3:313\n1612#3:314\n1603#3,9:315\n1855#3:324\n1856#3:326\n1612#3:327\n1549#3:330\n1620#3,3:331\n1#4:312\n1#4:325\n1#4:334\n32#5,2:328\n*S KotlinDebug\n*F\n+ 1 BarcodeScannerConfiguration.kt\nio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration\n*L\n35#1:286,16\n72#1:302,9\n72#1:311\n72#1:313\n72#1:314\n89#1:315,9\n89#1:324\n89#1:326\n89#1:327\n244#1:330\n244#1:331,3\n72#1:312\n89#1:325\n141#1:328,2\n*E\n"})
public final class BarcodeScannerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BarcodeScannerJsonConfiguration params;
    @NotNull
    private final BarcodeScannerNativeConfiguration nativeParams;
    @NotNull
    private static final String ASSET_FILE_JSON = "BarcodeScreen.json";

    private BarcodeScannerConfiguration(BarcodeScannerJsonConfiguration params, BarcodeScannerNativeConfiguration nativeParams) {
        this.params = params;
        this.nativeParams = nativeParams;
    }

    /* synthetic */ BarcodeScannerConfiguration(BarcodeScannerJsonConfiguration barcodeScannerJsonConfiguration, BarcodeScannerNativeConfiguration barcodeScannerNativeConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            barcodeScannerNativeConfiguration = new BarcodeScannerNativeConfiguration(null, null, null, null, null, 31, null);
        }
        this(barcodeScannerJsonConfiguration, barcodeScannerNativeConfiguration);
    }

    @NotNull
    public final BarcodeScannerJsonConfiguration getParams() {
        return this.params;
    }

    @NotNull
    public final BarcodeScannerNativeConfiguration getNativeParams() {
        return this.nativeParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public BarcodeScannerConfiguration() {
        Object object;
        void assetFileJson$iv;
        void context$iv;
        Context context = SapSingleton.INSTANCE.getContext();
        String string2 = ASSET_FILE_JSON;
        Gson gson = GsonHelper.INSTANCE.prepareGson();
        Object var4_4 = null;
        BarcodeScannerConfiguration barcodeScannerConfiguration = this;
        boolean $i$f$getJsonConfig = false;
        BufferedReader reader$iv = JsonConfigUtilsKt.getJsonReader((Context)context$iv, (String)assetFileJson$iv);
        Closeable closeable = reader$iv;
        Throwable throwable = null;
        try {
            void gson$iv;
            BufferedReader reader$iv2 = (BufferedReader)closeable;
            boolean bl = false;
            String text$iv = TextStreamsKt.readText((Reader)reader$iv2);
            Object object2 = gson$iv.fromJson(text$iv, new TypeToken<Map<String, Object>>(){}.getType());
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromJson(...)");
            Map defaultJson$iv = (Map)object2;
            String fullJson$iv = gson$iv.toJson((Object)defaultJson$iv);
            object = gson$iv.fromJson(fullJson$iv, BarcodeScannerJsonConfiguration.class);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object jsonConfig$iv = object;
        barcodeScannerConfiguration((BarcodeScannerJsonConfiguration)jsonConfig$iv, null, 2, null);
    }

    public final void setDelayAfterFocusCompleteMs(long delay) {
        this.nativeParams.setDelayAfterFocusCompleteMs(delay);
    }

    public final void setDelayAfterScanMs(long milliseconds) {
        this.params.setDelayAfterScan((double)milliseconds / (double)1000);
    }

    public final void setConfirmationDialogConfiguration(@NotNull BarcodeConfirmationDialogConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.params.setConfirmationDialogConfiguration(BarcodeJsonExtensionsKt.toJsonV1(configuration));
    }

    public final void setBarcodeFilter(@NotNull IBarcodeFilter barcodeFilter) {
        Intrinsics.checkNotNullParameter((Object)barcodeFilter, (String)"barcodeFilter");
        this.nativeParams.setBarcodeFilter(barcodeFilter.getClass());
    }

    /*
     * WARNING - void declaration
     */
    public final void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> barcodeFormat) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(barcodeFormat, (String)"barcodeFormat");
        Iterable iterable = barcodeFormat;
        BarcodeScannerJsonConfiguration barcodeScannerJsonConfiguration = this.params;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JsonBarcodeFormat it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            BarcodeFormat it = (BarcodeFormat)element$iv$iv;
            boolean bl2 = false;
            if (BarcodeJsonExtensionsKt.toJsonV1(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        barcodeScannerJsonConfiguration.setBarcodeFormats((List)destination$iv$iv);
    }

    public final void setEngineMode(@NotNull BarcodeScannerEngineMode engineMode) {
        Intrinsics.checkNotNullParameter((Object)engineMode, (String)"engineMode");
        this.params.setEngineMode(BarcodeJsonExtensionsKt.toJsonV1(engineMode));
    }

    /*
     * WARNING - void declaration
     */
    public final void setExtractedDocumentFormats(@NotNull ArrayList<BarcodeDocumentFormat> documentFormats) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(documentFormats, (String)"documentFormats");
        Iterable iterable = documentFormats;
        BarcodeScannerJsonConfiguration barcodeScannerJsonConfiguration = this.params;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JsonBarcodeDocumentFormat it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            BarcodeDocumentFormat it = (BarcodeDocumentFormat)element$iv$iv;
            boolean bl2 = false;
            if (BarcodeJsonExtensionsKt.toJsonV1(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        barcodeScannerJsonConfiguration.setAcceptedDocumentFormats((List)destination$iv$iv);
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        this.params.setFlashEnabled(flashEnabled);
    }

    public final void setOrientationLockMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        this.params.setOrientationLockMode(CommonExtensionsKt.toJson((CameraOrientationMode)cameraOrientationMode));
    }

    public final void setSuccessBeepEnabled(boolean successBeepEnabled) {
        this.params.setSuccessBeepEnabled(successBeepEnabled);
    }

    public final void setTopBarBackgroundColor(@ColorInt int topBarBackgroundColor) {
        this.params.setTopBarBackgroundColor(JsonColorKt.toJsonColor((int)topBarBackgroundColor));
    }

    public final void setTopBarButtonsColor(@ColorInt int topBarButtonsColor) {
        this.params.setTopBarButtonsColor(JsonColorKt.toJsonColor((int)topBarButtonsColor));
    }

    public final void setTopBarButtonsInactiveColor(@ColorInt int topBarButtonsInactiveColor) {
        this.params.setFlashButtonInactiveColor(JsonColorKt.toJsonColor((int)topBarButtonsInactiveColor));
    }

    public final void setCameraOverlayColor(@ColorInt int cameraOverlayColor) {
        this.params.setCameraOverlayColor(JsonColorKt.toJsonColor((int)cameraOverlayColor));
    }

    public final void setViewFinderEnabled(boolean viewFinderEnabled) {
        this.params.setViewFinderEnabled(viewFinderEnabled);
    }

    public final void setFinderAspectRatio(@NotNull AspectRatio finderAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)finderAspectRatio, (String)"finderAspectRatio");
        this.params.setFinderAspectRatio(CommonExtensionsKt.toJsonV1((AspectRatio)finderAspectRatio));
    }

    public final void setFinderLineWidth(int finderLineWidth) {
        Double d;
        Context context = SapSingleton.INSTANCE.getContext();
        if (context != null) {
            Context $this$pxToDp$iv = context;
            boolean $i$f$pxToDp = false;
            DisplayMetrics displayMetrics$iv = $this$pxToDp$iv.getResources().getDisplayMetrics();
            d = MathKt.roundToInt((float)((float)finderLineWidth / (displayMetrics$iv.xdpi / (float)160)));
        } else {
            d = null;
        }
        this.params.setFinderLineWidth(d);
    }

    public final void setFinderLineColor(@ColorInt int finderLineColor) {
        this.params.setFinderLineColor(JsonColorKt.toJsonColor((int)finderLineColor));
    }

    public final void setFinderTextHintColor(@ColorInt int finderTextHintColor) {
        this.params.setFinderTextHintColor(JsonColorKt.toJsonColor((int)finderTextHintColor));
    }

    public final void setUseButtonsAllCaps(boolean allCaps) {
        this.params.setUseButtonsAllCaps(allCaps);
    }

    public final void setAutoCancelTimeout(int seconds) {
        this.params.setAutoCancelTimeout(seconds);
    }

    public final void setCameraZoomRatio(float zoomFactor) {
        this.nativeParams.setCameraZoomRatio(Float.valueOf(zoomFactor));
    }

    public final void setCameraZoomRange(@NotNull ZoomRange zoomRange) {
        Intrinsics.checkNotNullParameter((Object)zoomRange, (String)"zoomRange");
        this.params.setCameraZoomRange(CommonExtensionsKt.toJson((ZoomRange)zoomRange));
    }

    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.params.setCameraModule(CommonExtensionsKt.toJson((CameraModule)cameraModule));
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.params.setCameraPreviewMode(CommonExtensionsKt.toJson((CameraPreviewMode)cameraPreviewMode));
    }

    public final void setMinFocusDistanceLock(boolean lock) {
        this.params.setMinFocusDistanceLock(lock);
    }

    public final void setCancelButtonTitle(@NotNull String cancelButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)cancelButtonTitle, (String)"cancelButtonTitle");
        this.params.setCancelButtonTitle(cancelButtonTitle);
    }

    public final void setCancelButtonIcon(@DrawableRes int cancelButtonIcon) {
        this.nativeParams.setCancelButtonIcon(cancelButtonIcon);
    }

    public final void setFinderTextHint(@NotNull String finderTextHint) {
        Intrinsics.checkNotNullParameter((Object)finderTextHint, (String)"finderTextHint");
        this.params.setFinderTextHint(finderTextHint);
    }

    public final void setEnableCameraExplanationText(@NotNull String enableCameraExplanationText) {
        Intrinsics.checkNotNullParameter((Object)enableCameraExplanationText, (String)"enableCameraExplanationText");
        this.params.setEnableCameraExplanationText(enableCameraExplanationText);
    }

    public final void setEnableCameraButtonTitle(@NotNull String enableCameraButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)enableCameraButtonTitle, (String)"enableCameraButtonTitle");
        this.params.setEnableCameraButtonTitle(enableCameraButtonTitle);
    }

    /*
     * WARNING - void declaration
     */
    public final void setAdditionalScanningParameters(@NotNull BarcodeScannerAdditionalConfiguration additionalConfiguration) {
        void it;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)additionalConfiguration, (String)"additionalConfiguration");
        this.params.setMinimumTextLength(additionalConfiguration.getMinimumTextLength());
        this.params.setMaximumTextLength(additionalConfiguration.getMaximumTextLength());
        this.params.setMinimum1DBarcodesQuietZone(additionalConfiguration.getMinimum1DQuietZoneSize());
        this.params.setGs1HandlingMode(BarcodeJsonExtensionsKt.toJsonV1(additionalConfiguration.getGs1HandlingMode()));
        Iterable iterable = additionalConfiguration.getMsiPlesseyChecksumAlgorithms();
        Object object = this.nativeParams;
        boolean $i$f$map22 = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            MsiPlesseyChecksumAlgorithm msiPlesseyChecksumAlgorithm = (MsiPlesseyChecksumAlgorithm)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2);
        }
        ((BarcodeScannerNativeConfiguration)object).setMsiPlesseyChecksumAlgorithms(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        List<MsiPlesseyChecksumAlgorithm> $i$f$map22 = additionalConfiguration.getMsiPlesseyChecksumAlgorithms();
        object = this.params;
        boolean bl = false;
        MsiPlesseyChecksumAlgorithm msiPlesseyChecksumAlgorithm = (MsiPlesseyChecksumAlgorithm)CollectionsKt.firstOrNull((List)it);
        ((BarcodeScannerJsonConfiguration)object).setMsiPlesseyChecksumAlgorithm((JsonMSIPlesseyChecksumAlgorithm)(msiPlesseyChecksumAlgorithm != null ? BarcodeJsonExtensionsKt.toJsonV1(msiPlesseyChecksumAlgorithm) : null));
        this.params.setStripCheckDigits(additionalConfiguration.getStripCheckDigits());
        this.params.setLowPowerMode(additionalConfiguration.getLowPowerMode());
    }

    public final void setSelectionOverlayConfiguration(@NotNull SelectionOverlayConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.params.setOverlayConfiguration(BarcodeJsonExtensionsKt.toJsonV1(configuration));
    }

    public final void setInitialScanDelayMs(long milliseconds) {
        this.params.setInitialScanningDelay((double)milliseconds / (double)1000);
    }

    public final void setTouchToFocusEnabled(boolean enabled) {
        this.params.setTouchToFocusEnabled(enabled);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration$Companion;", "", "()V", "ASSET_FILE_JSON", "", "fromJson", "Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration;", "input", "rtu-ui-barcode_release"})
    @SourceDebugExtension(value={"SMAP\nBarcodeScannerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeScannerConfiguration.kt\nio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration$Companion\n+ 2 JsonConfigUtils.kt\nio/scanbot/sdk/util/JsonConfigUtilsKt\n*L\n1#1,285:1\n20#2,16:286\n*S KotlinDebug\n*F\n+ 1 BarcodeScannerConfiguration.kt\nio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration$Companion\n*L\n279#1:286,16\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final BarcodeScannerConfiguration fromJson(@NotNull String input) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Gson gson = GsonHelper.INSTANCE.prepareGson();
            Context context = SapSingleton.INSTANCE.getContext();
            String assetFileJson$iv = BarcodeScannerConfiguration.ASSET_FILE_JSON;
            boolean $i$f$getJsonConfig = false;
            BufferedReader reader$iv = JsonConfigUtilsKt.getJsonReader((Context)context, (String)assetFileJson$iv);
            Closeable closeable = reader$iv;
            Throwable throwable = null;
            try {
                BufferedReader reader$iv2 = (BufferedReader)closeable;
                boolean bl = false;
                String text$iv = TextStreamsKt.readText((Reader)reader$iv2);
                Object object2 = gson.fromJson(text$iv, new TypeToken<Map<String, Object>>(){}.getType());
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromJson(...)");
                Map defaultJson$iv = (Map)object2;
                Object object3 = gson.fromJson(input, new TypeToken<Map<String, ? extends Object>>(){}.getType());
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fromJson(...)");
                Map partialJson$iv = (Map)object3;
                JsonConfigUtilsKt.updateParameters((Map)partialJson$iv, (Map)defaultJson$iv);
                String fullJson$iv = gson.toJson((Object)defaultJson$iv);
                object = gson.fromJson(fullJson$iv, BarcodeScannerJsonConfiguration.class);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object jsonConfig$iv = object;
            BarcodeScannerJsonConfiguration jsonConfig = (BarcodeScannerJsonConfiguration)jsonConfig$iv;
            return new BarcodeScannerConfiguration(jsonConfig, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

