/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.barcode.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import io.scanbot.sdk.barcode.BarcodeScannerResult;
import io.scanbot.sdk.ui.barcode.R;
import io.scanbot.sdk.ui.view.barcode.dialog.BarcodeConfirmationDialog;
import io.scanbot.sdk.ui.view.barcode.dialog.BarcodeConfirmationDialogConfiguration;
import io.scanbot.sdk.ui.view.barcode.dialog.BarcodeConfirmationDialogInterface;
import io.scanbot.sdk.ui.view.barcode.dialog.BarcodeDialogFormat;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\f\u0010\r\u001a\u00020\u0006*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/ui/view/barcode/dialog/BarcodeConfirmationDialog;", "Landroidx/fragment/app/DialogFragment;", "()V", "confirmed", "", "onCancel", "", "dialog", "Landroid/content/DialogInterface;", "onCreateDialog", "Landroid/app/Dialog;", "savedInstanceState", "Landroid/os/Bundle;", "addRipple", "Landroid/view/View;", "Companion", "rtu-ui-barcode_release"})
@SourceDebugExtension(value={"SMAP\nBarcodeConfirmationDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeConfirmationDialog.kt\nio/scanbot/sdk/ui/view/barcode/dialog/BarcodeConfirmationDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class BarcodeConfirmationDialog
extends DialogFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean confirmed;
    @NotNull
    private static final String CONFIGURATION = "CONFIGURATION";
    @NotNull
    private static final String BARCODE_RESULT = "BARCODE_RESULT";

    @NotNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.scanbot_sdk_dialog_barcode_normal, null, false);
        Bundle bundle = this.getArguments();
        BarcodeScannerResult barcodeScannerResult = bundle != null ? (BarcodeScannerResult)bundle.getParcelable(BARCODE_RESULT) : null;
        Intrinsics.checkNotNull((Object)barcodeScannerResult);
        BarcodeScannerResult scanningResult = barcodeScannerResult;
        Bundle bundle2 = this.getArguments();
        BarcodeConfirmationDialogConfiguration barcodeConfirmationDialogConfiguration = bundle2 != null ? (BarcodeConfirmationDialogConfiguration)bundle2.getParcelable(CONFIGURATION) : null;
        Intrinsics.checkNotNull((Object)barcodeConfirmationDialogConfiguration);
        BarcodeConfirmationDialogConfiguration config = barcodeConfirmationDialogConfiguration;
        String resultText2 = switch (WhenMappings.$EnumSwitchMapping$0[config.getDialogTextFormat().ordinal()]) {
            case 1 -> CollectionsKt.joinToString$default((Iterable)scanningResult.getBarcodes(), (CharSequence)"\n\n", null, null, (int)0, null, (Function1)onCreateDialog.resultText.1.INSTANCE, (int)30, null);
            case 2 -> CollectionsKt.joinToString$default((Iterable)scanningResult.getBarcodes(), (CharSequence)"\n\n", null, null, (int)0, null, (Function1)onCreateDialog.resultText.2.INSTANCE, (int)30, null);
            default -> throw new NoWhenBranchMatchedException();
        };
        ((TextView)view.findViewById(R.id.scanbot_sdk_view_barcode_text)).setText((CharSequence)resultText2);
        Button retryButton = (Button)view.findViewById(R.id.scanbot_sdk_view_barcode_retry_button);
        retryButton.setText((CharSequence)config.getRetryButtonTitle());
        retryButton.setOnClickListener(arg_0 -> BarcodeConfirmationDialog.onCreateDialog$lambda$0(this, arg_0));
        Button confirmButton = (Button)view.findViewById(R.id.scanbot_sdk_view_barcode_confirm_button);
        confirmButton.setText((CharSequence)config.getConfirmButtonTitle());
        confirmButton.setOnClickListener(arg_0 -> BarcodeConfirmationDialog.onCreateDialog$lambda$1(this, scanningResult, arg_0));
        Integer n = config.getButtonsAccentColor();
        if (n != null) {
            int buttonsAccentColor = ((Number)n).intValue();
            boolean bl = false;
            if (config.isConfirmButtonFilled()) {
                confirmButton.setBackgroundTintList(ColorStateList.valueOf((int)buttonsAccentColor));
                Integer n2 = config.getFilledConfirmButtonTextColor();
                if (n2 != null) {
                    int it = ((Number)n2).intValue();
                    boolean bl2 = false;
                    confirmButton.setTextColor(it);
                }
            } else {
                Intrinsics.checkNotNull((Object)confirmButton);
                this.addRipple((View)confirmButton);
                confirmButton.setTextColor(buttonsAccentColor);
            }
            retryButton.setTextColor(buttonsAccentColor);
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(view.getContext());
        String string2 = config.getTitle();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String string3 = it;
            Object[] objectArray = new Object[]{scanningResult.getBarcodes().size()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            builder.setTitle((CharSequence)string4);
        }
        String string5 = config.getMessage();
        if (string5 != null) {
            String it = string5;
            boolean bl = false;
            builder.setMessage((CharSequence)it);
        }
        AlertDialog alertDialog = builder.setView(view).create();
        Intrinsics.checkNotNullExpressionValue((Object)alertDialog, (String)"create(...)");
        return (Dialog)alertDialog;
    }

    private final void addRipple(View $this$addRipple) {
        TypedValue $this$addRipple_u24lambda_u246 = new TypedValue();
        boolean bl = false;
        $this$addRipple.getContext().getTheme().resolveAttribute(16843534, $this$addRipple_u24lambda_u246, true);
        $this$addRipple.setBackgroundResource($this$addRipple_u24lambda_u246.resourceId);
    }

    public void onCancel(@NotNull DialogInterface dialog) {
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        super.onCancel(dialog);
        if (!this.confirmed) {
            FragmentActivity fragmentActivity = this.getActivity();
            Intrinsics.checkNotNull((Object)fragmentActivity, (String)"null cannot be cast to non-null type io.scanbot.sdk.ui.view.barcode.dialog.BarcodeConfirmationDialogInterface");
            ((BarcodeConfirmationDialogInterface)fragmentActivity).onBarcodeRejected();
        }
    }

    private static final void onCreateDialog$lambda$0(BarcodeConfirmationDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        FragmentActivity fragmentActivity = this$0.getActivity();
        Intrinsics.checkNotNull((Object)fragmentActivity, (String)"null cannot be cast to non-null type io.scanbot.sdk.ui.view.barcode.dialog.BarcodeConfirmationDialogInterface");
        ((BarcodeConfirmationDialogInterface)fragmentActivity).onBarcodeRejected();
        this$0.dismissAllowingStateLoss();
    }

    private static final void onCreateDialog$lambda$1(BarcodeConfirmationDialog this$0, BarcodeScannerResult $scanningResult, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$scanningResult, (String)"$scanningResult");
        this$0.confirmed = true;
        FragmentActivity fragmentActivity = this$0.getActivity();
        Intrinsics.checkNotNull((Object)fragmentActivity, (String)"null cannot be cast to non-null type io.scanbot.sdk.ui.view.barcode.dialog.BarcodeConfirmationDialogInterface");
        ((BarcodeConfirmationDialogInterface)fragmentActivity).onBarcodeConfirmed($scanningResult);
        this$0.dismissAllowingStateLoss();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/scanbot/sdk/ui/view/barcode/dialog/BarcodeConfirmationDialog$Companion;", "", "()V", "BARCODE_RESULT", "", "CONFIGURATION", "newInstance", "Lio/scanbot/sdk/ui/view/barcode/dialog/BarcodeConfirmationDialog;", "configuration", "Lio/scanbot/sdk/ui/view/barcode/dialog/BarcodeConfirmationDialogConfiguration;", "result", "Lio/scanbot/sdk/barcode/BarcodeScannerResult;", "newInstance$rtu_ui_barcode_release", "rtu-ui-barcode_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BarcodeConfirmationDialog newInstance$rtu_ui_barcode_release(@NotNull BarcodeConfirmationDialogConfiguration configuration, @NotNull BarcodeScannerResult result) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Bundle args = new Bundle();
            args.putParcelable(BarcodeConfirmationDialog.CONFIGURATION, (Parcelable)configuration);
            args.putParcelable(BarcodeConfirmationDialog.BARCODE_RESULT, (Parcelable)result);
            BarcodeConfirmationDialog fragment = new BarcodeConfirmationDialog();
            fragment.setArguments(args);
            return fragment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BarcodeDialogFormat.values().length];
            try {
                nArray[BarcodeDialogFormat.CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeDialogFormat.TYPE_AND_CODE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

