/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.barcode;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import androidx.activity.result.contract.ActivityResultContract;
import io.scanbot.sap.SdkLicenseInfo;
import io.scanbot.sap.Status;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode_scanner.ScanbotBarcodeScannerSDKInitializer;
import io.scanbot.sdk.pdf.PdfImagesExtractor;
import io.scanbot.sdk.ui.barcode_scanner.view.barcode.BarcodeScannerActivity;
import io.scanbot.sdk.ui.barcode_scanner.view.barcode.batch.BatchBarcodeScannerActivity;
import io.scanbot.sdk.ui.view.barcode.InternalBarcodeScannerActivity;
import io.scanbot.sdk.ui.view.barcode.batch.InternalBatchBarcodeScannerActivity;
import io.scanbot.sdk.ui.view.barcode.batch.configuration.BatchBarcodeScannerConfiguration;
import io.scanbot.sdk.ui.view.barcode.configuration.BarcodeScannerConfiguration;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.barcode.SBBWrapper;
import io.scanbot.sdk_wrapper.barcode.SBWrapperOperations;
import io.scanbot.sdk_wrapper.barcode.extensions.SBBWrapperScanbotBarcodeScannerSDKInitializerExtensionKt;
import io.scanbot.sdk_wrapper.exceptions.SBWrapperExceptions;
import io.scanbot.sdk_wrapper.interfaces.SBWrapperResultDelegate;
import io.scanbot.sdk_wrapper.utils.SBWrapperSDKChecks;
import io.scanbot.sdk_wrapper.utils.SBWrapperStorageUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001f\u0010 J+\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u000b\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u000eJ)\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J)\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0014J#\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u001b\u0010\u0019\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ!\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lio/scanbot/sdk_wrapper/barcode/SBBWrapperOperations;", "", "Landroid/app/Application;", "application", "Lorg/json/JSONObject;", "configurationAsJSON", "Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;", "resultDelegate", "", "initializeSdk", "(Landroid/app/Application;Lorg/json/JSONObject;Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;)Lkotlin/Unit;", "getLicenseInfo", "(Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;)V", "detectBarcodesOnImage", "(Lorg/json/JSONObject;Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;)V", "argsAsJSON", "extractImagesFromPDF", "Landroid/app/Activity;", "activity", "startBarcodeScanner", "(Landroid/app/Activity;Lorg/json/JSONObject;Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;)V", "closeBarcodeScanner", "(Landroid/app/Activity;Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;)Lkotlin/Unit;", "startBatchBarcodeScanner", "closeBatchBarcodeScanner", "cleanup", "(Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;)Lkotlin/Unit;", "Lio/scanbot/sap/SdkLicenseInfo;", "licenseInfo", "a", "(Lio/scanbot/sap/SdkLicenseInfo;Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;)V", "<init>", "()V", "barcode-sdk-wrapper_release"})
public final class SBBWrapperOperations {
    @NotNull
    public static final SBBWrapperOperations INSTANCE = new SBBWrapperOperations();

    private SBBWrapperOperations() {
    }

    @JvmStatic
    @Nullable
    public static final Unit initializeSdk(final @NotNull Application application, final @NotNull JSONObject jSONObject, final @Nullable SBWrapperResultDelegate sBWrapperResultDelegate) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"configurationAsJSON");
        Function0 function02 = function0;
        function0 = new Function0(){

            public final void a() {
                File file;
                SBWrapper sBWrapper = SBWrapper.INSTANCE;
                sBWrapper.setLoggerTag$barcode_sdk_wrapper_release("ScanbotBarcodeSDKWrapper");
                sBWrapper.setApplication$barcode_sdk_wrapper_release(application);
                LoggerProvider.getLogger().i(sBWrapper.getLoggerTag$barcode_sdk_wrapper_release(), "Initializing Scanbot Barcode SDK ...");
                ScanbotBarcodeScannerSDKInitializer scanbotBarcodeScannerSDKInitializer = new ScanbotBarcodeScannerSDKInitializer();
                String string = jSONObject.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                sBWrapper = SBBWrapperScanbotBarcodeScannerSDKInitializerExtensionKt.fromJson(scanbotBarcodeScannerSDKInitializer, string).initialize(application);
                File file2 = SBBWrapper.INSTANCE.getBarcodeScannerSDKBarcodeFileStorage().getBarcodeImagesDirectory();
                SBWrapperStorageUtils sBWrapperStorageUtils = SBWrapperStorageUtils.INSTANCE;
                File file3 = file2.getParentFile();
                if (file3 != null) {
                    Intrinsics.checkNotNull((Object)file3);
                    file2 = file3;
                }
                File file4 = file;
                file4(file2, "sbw_storage");
                sBWrapperStorageUtils.setBaseDirectory(file4);
                SBWrapperSDKChecks.INSTANCE.setInitialized(true);
                INSTANCE.a((SdkLicenseInfo)sBWrapper, sBWrapperResultDelegate);
            }
        };
        return (Unit)SBWrapperSDKChecks.INSTANCE.sdkFunction(null, sBWrapperResultDelegate, false, false, function02);
    }

    @JvmStatic
    public static final void getLicenseInfo(@Nullable SBWrapperResultDelegate sBWrapperResultDelegate) {
        SBWrapperOperations.INSTANCE.getLicenseInfo$barcode_sdk_wrapper_release(SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo(), sBWrapperResultDelegate);
    }

    @JvmStatic
    public static final void detectBarcodesOnImage(@NotNull JSONObject jSONObject, @Nullable SBWrapperResultDelegate sBWrapperResultDelegate) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"configurationAsJSON");
        SBBWrapper sBBWrapper = SBBWrapper.INSTANCE;
        SdkLicenseInfo sdkLicenseInfo = sBBWrapper.getBarcodeScannerSDKLicenseInfo();
        ScanbotBarcodeDetector scanbotBarcodeDetector = sBBWrapper.getBarcodeScannerSDKBarcodeDetector();
        SBWrapperOperations.INSTANCE.detectBarcodesOnImage$barcode_sdk_wrapper_release(sdkLicenseInfo, jSONObject, sBWrapperResultDelegate, scanbotBarcodeDetector);
    }

    @JvmStatic
    public static final void extractImagesFromPDF(@NotNull JSONObject jSONObject, @Nullable SBWrapperResultDelegate sBWrapperResultDelegate) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"argsAsJSON");
        SBBWrapper sBBWrapper = SBBWrapper.INSTANCE;
        SdkLicenseInfo sdkLicenseInfo = sBBWrapper.getBarcodeScannerSDKLicenseInfo();
        PdfImagesExtractor pdfImagesExtractor = sBBWrapper.getBarcodeScannerSDKPdfImagesExtractor();
        SBWrapperOperations.INSTANCE.extractImagesFromPDF$barcode_sdk_wrapper_release(sdkLicenseInfo, jSONObject, sBWrapperResultDelegate, pdfImagesExtractor);
    }

    @JvmStatic
    public static final void startBarcodeScanner(@NotNull Activity activity, @NotNull JSONObject jSONObject, @Nullable SBWrapperResultDelegate sBWrapperResultDelegate) {
        BarcodeScannerActivity.ResultContract resultContract;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"configurationAsJSON");
        Activity activity2 = activity;
        activity = SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo();
        BarcodeScannerActivity.ResultContract resultContract2 = resultContract;
        resultContract = new BarcodeScannerActivity.ResultContract();
        SBWrapperOperations.INSTANCE.startBarcodeScanner$barcode_sdk_wrapper_release(activity2, (SdkLicenseInfo)activity, jSONObject, sBWrapperResultDelegate, (ActivityResultContract<BarcodeScannerConfiguration, InternalBarcodeScannerActivity.InternalResult>)resultContract2);
    }

    @JvmStatic
    @Nullable
    public static final Unit closeBarcodeScanner(final @NotNull Activity activity, final @Nullable SBWrapperResultDelegate sBWrapperResultDelegate) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Function0 function02 = function0;
        function0 = new Function0(){

            public final void a() {
                BarcodeScannerActivity.Companion.forceClose((Context)activity);
                SBWrapperOperations.INSTANCE.setBarcodeScanner$barcode_sdk_wrapper_release(null);
                SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release$default(SBWrapperResultDelegate.Companion, sBWrapperResultDelegate, null, null, 4, null);
            }
        };
        return (Unit)SBWrapperSDKChecks.sdkFunction$default(SBWrapperSDKChecks.INSTANCE, SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo(), sBWrapperResultDelegate, false, false, function02, 12, null);
    }

    @JvmStatic
    public static final void startBatchBarcodeScanner(@NotNull Activity activity, @NotNull JSONObject jSONObject, @Nullable SBWrapperResultDelegate sBWrapperResultDelegate) {
        BatchBarcodeScannerActivity.ResultContract resultContract;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"configurationAsJSON");
        Activity activity2 = activity;
        activity = SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo();
        BatchBarcodeScannerActivity.ResultContract resultContract2 = resultContract;
        resultContract = new BatchBarcodeScannerActivity.ResultContract();
        SBWrapperOperations.INSTANCE.startBatchBarcodeScanner$barcode_sdk_wrapper_release(activity2, (SdkLicenseInfo)activity, jSONObject, sBWrapperResultDelegate, (ActivityResultContract<BatchBarcodeScannerConfiguration, InternalBatchBarcodeScannerActivity.InternalResult>)resultContract2);
    }

    @JvmStatic
    @Nullable
    public static final Unit closeBatchBarcodeScanner(final @NotNull Activity activity, final @Nullable SBWrapperResultDelegate sBWrapperResultDelegate) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Function0 function02 = function0;
        function0 = new Function0(){

            public final void a() {
                BatchBarcodeScannerActivity.Companion.forceClose$default((BatchBarcodeScannerActivity.Companion)BatchBarcodeScannerActivity.Companion, (Context)activity, (boolean)false, (int)2, null);
                SBWrapperOperations.INSTANCE.setBatchBarcodeScanner$barcode_sdk_wrapper_release(null);
                SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release$default(SBWrapperResultDelegate.Companion, sBWrapperResultDelegate, null, null, 4, null);
            }
        };
        return (Unit)SBWrapperSDKChecks.sdkFunction$default(SBWrapperSDKChecks.INSTANCE, SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo(), sBWrapperResultDelegate, false, false, function02, 12, null);
    }

    @JvmStatic
    @Nullable
    public static final Unit cleanup(final @Nullable SBWrapperResultDelegate sBWrapperResultDelegate) {
        Function0 function0;
        Function0 function02 = function0;
        function0 = new Function0(){

            private static final void a(SBWrapperResultDelegate object) {
                try {
                    SBBWrapper.INSTANCE.getBarcodeScannerSDKBarcodeFileStorage().cleanupBarcodeImagesDirectory();
                    SBWrapperStorageUtils.INSTANCE.cleanupWrapperStorage();
                    SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release$default(SBWrapperResultDelegate.Companion, (SBWrapperResultDelegate)object, "Cleanup successfully done.", null, 4, null);
                }
                catch (Exception exception) {
                    SBWrapperExceptions.SBWrapperUnexpectedError sBWrapperUnexpectedError;
                    SBWrapperResultDelegate sBWrapperResultDelegate2 = object;
                    object = sBWrapperUnexpectedError;
                    sBWrapperUnexpectedError = new SBWrapperExceptions.SBWrapperUnexpectedError(exception.getMessage());
                    SBWrapperResultDelegate.Companion.sendFailureOnMainThread$barcode_sdk_wrapper_release(sBWrapperResultDelegate2, (Exception)object);
                }
            }

            public final void a() {
                SBWrapper sBWrapper = SBWrapper.INSTANCE;
                LoggerProvider.getLogger().i(sBWrapper.getLoggerTag$barcode_sdk_wrapper_release(), "Cleaning storage folder ...");
                sBWrapper.getThreadPool$barcode_sdk_wrapper_release().execute(() -> a.a(sBWrapperResultDelegate));
            }
        };
        return (Unit)SBWrapperSDKChecks.sdkFunction$default(SBWrapperSDKChecks.INSTANCE, SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo(), sBWrapperResultDelegate, false, false, function02, 12, null);
    }

    private final void a(SdkLicenseInfo object, SBWrapperResultDelegate sBWrapperResultDelegate) {
        LoggerProvider.getLogger().i(SBWrapper.INSTANCE.getLoggerTag$barcode_sdk_wrapper_release(), "Checking license ...");
        Object object2 = "Scanbot Barcode SDK initialized";
        if (object.isValid()) {
            if (object.getStatus() == Status.StatusTrial) {
                object2 = (String)object2 + " in trial mode. You can now test all features for 60 seconds.";
            }
        } else {
            if ((object = object.getLicenseStatusMessage()) == null) {
                object = "";
            }
            object2 = (String)object2 + " with invalid license key. " + (String)object;
        }
        SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release$default(SBWrapperResultDelegate.Companion, sBWrapperResultDelegate, object2, null, 4, null);
    }
}

