/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.extensions;

import android.app.Application;
import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import androidx.core.net.UriKt;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.exceptions.SBWrapperError;
import io.scanbot.sdk_wrapper.utils.SBStorageUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0002H\u0000\u00a8\u0006\u000b"}, d2={"contentToFile", "Ljava/io/File;", "Landroid/net/Uri;", "contentResolver", "Landroid/content/ContentResolver;", "toBitmap", "Landroid/graphics/Bitmap;", "toImageRef", "Lio/scanbot/sdk/image/ImageRef;", "withHash", "", "barcode-sdk-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBUriExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBUriExtension.kt\nio/scanbot/sdk_wrapper/extensions/SBUriExtensionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class SBUriExtensionKt {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static final File contentToFile(@NotNull Uri object, @NotNull ContentResolver object2) {
        Throwable throwable522222;
        Throwable throwable2222222;
        InputStream inputStream;
        block16: {
            FileOutputStream fileOutputStream;
            File file;
            Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)object2, (String)"contentResolver");
            if (!Intrinsics.areEqual((Object)object.getScheme(), (Object)"content")) {
                throw new SBWrapperError.InvalidUri(object.toString(), "Uri lacks 'content' scheme");
            }
            inputStream = object2.openInputStream((Uri)object);
            if (inputStream == null) {
                throw new SBWrapperError.InvalidUri(object.toString(), "Input stream cannot be opened");
            }
            Throwable throwable3 = null;
            object = MimeTypeMap.getSingleton().getExtensionFromMimeType(object2.getType((Uri)object));
            object2 = file;
            file = new File(SBStorageUtils.INSTANCE.getTmpFilesDirectory$barcode_sdk_wrapper_release(), UUID.randomUUID() + "." + (String)object);
            object = fileOutputStream;
            fileOutputStream = new FileOutputStream((File)object2);
            Throwable throwable4 = null;
            try {
                int n;
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) > 0) {
                    ((FileOutputStream)object).write(byArray, 0, n);
                }
            }
            catch (Throwable throwable2222222) {
                break block16;
            }
            Object object3 = object;
            ((OutputStream)object3).flush();
            CloseableKt.closeFinally((Closeable)object3, throwable4);
            {
                catch (Throwable throwable522222) {}
            }
            CloseableKt.closeFinally((Closeable)inputStream, throwable3);
            return object2;
        }
        try {
            throw throwable2222222;
        }
        catch (Throwable throwable6) {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2222222);
            throw throwable6;
        }
        try {
            throw throwable522222;
        }
        catch (Throwable throwable7) {
            CloseableKt.closeFinally((Closeable)inputStream, (Throwable)throwable522222);
            throw throwable7;
        }
    }

    public static /* synthetic */ File contentToFile$default(Uri uri, ContentResolver contentResolver, int n, Object object) {
        if ((n & 1) != 0) {
            Application application = SBWrapper.INSTANCE.getApplication$barcode_sdk_wrapper_release();
            Intrinsics.checkNotNull((Object)application);
            contentResolver = application.getContentResolver();
        }
        return SBUriExtensionKt.contentToFile(uri, contentResolver);
    }

    @NotNull
    public static final Bitmap toBitmap(@NotNull Uri uri) {
        Bitmap bitmap;
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"<this>");
        uri = SBUriExtensionKt.toImageRef$default(uri2, null, 1, null);
        Throwable throwable = null;
        try {
            bitmap = (Bitmap)uri.toBitmap().getOrThrow();
        }
        catch (Throwable throwable2) {
            try {
                throw throwable2;
            }
            catch (Throwable throwable3) {
                AutoCloseableKt.closeFinally((AutoCloseable)uri, (Throwable)throwable2);
                throw throwable3;
            }
        }
        AutoCloseableKt.closeFinally((AutoCloseable)uri, throwable);
        return bitmap;
    }

    @NotNull
    public static final ImageRef toImageRef(@NotNull Uri object, @NotNull ContentResolver object2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"contentResolver");
        if (Intrinsics.areEqual((Object)object.getScheme(), (Object)"file")) {
            object2 = object.getPath();
            if (object2 != null && (object2 = ImageRef.CREATOR.fromPath$default((ImageRef.CREATOR)ImageRef.CREATOR, (String)object2, null, (int)2, null)) != null) {
                return object2;
            }
            object = object.toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toString(...)");
            throw new SBWrapperError.InvalidPath((String)object);
        }
        if ((object2 = object2.openInputStream(object)) != null) {
            ImageRef imageRef;
            Throwable throwable = null;
            try {
                imageRef = ImageRef.CREATOR.fromInputStream$default((ImageRef.CREATOR)ImageRef.CREATOR, (InputStream)object2, null, (int)2, null);
            }
            catch (Throwable throwable2) {
                try {
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable2);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)object2, throwable);
            if (imageRef != null) {
                return imageRef;
            }
        }
        throw new SBWrapperError.InvalidUri(object.toString(), "Input stream cannot be opened");
    }

    public static /* synthetic */ ImageRef toImageRef$default(Uri uri, ContentResolver contentResolver, int n, Object object) {
        if ((n & 1) != 0) {
            Application application = SBWrapper.INSTANCE.getApplication$barcode_sdk_wrapper_release();
            Intrinsics.checkNotNull((Object)application);
            contentResolver = application.getContentResolver();
        }
        return SBUriExtensionKt.toImageRef(uri, contentResolver);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static final String withHash(@NotNull Uri uri) {
        Throwable throwable3;
        Throwable throwable2222;
        Object object;
        Object object2;
        File file;
        block21: {
            byte[] byArray;
            Object object3;
            Uri uri2;
            RandomAccessFile randomAccessFile;
            Uri uri3 = uri;
            Intrinsics.checkNotNullParameter((Object)uri3, (String)"<this>");
            file = UriKt.toFile((Uri)uri3);
            object2 = MessageDigest.getInstance("MD5");
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getInstance(...)");
            object = ByteBuffer.allocate(8);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"allocate(...)");
            long l = file.length();
            Object object4 = object2;
            Object object5 = object;
            Object object6 = object5;
            ((ByteBuffer)object5).putLong(l);
            ((MessageDigest)object4).update(((ByteBuffer)object6).array());
            object = randomAccessFile;
            randomAccessFile = new RandomAccessFile(file, "r");
            file = null;
            try {
                byte[] byArray2 = new byte[32768];
                long l2 = 32768;
                if (l > l2) {
                    ((RandomAccessFile)object).seek((l - l2) / (long)2);
                }
                uri2 = uri;
                object3 = object2;
                byArray = byArray2;
                ((RandomAccessFile)object).read(byArray2);
            }
            catch (Throwable throwable2222) {}
            ((MessageDigest)object3).update(byArray);
            int n = 1;
            String string = new BigInteger(n, ((MessageDigest)object2).digest()).toString(16);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            string = uri2.buildUpon().appendQueryParameter("minihash", string).build().toString();
            Object object7 = object;
            File file2 = file;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            break block21;
            CloseableKt.closeFinally((Closeable)object7, (Throwable)((Object)file2));
            return string;
            {
                catch (Throwable throwable3) {}
            }
        }
        try {
            throw throwable2222;
        }
        catch (Throwable throwable4) {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2222);
            throw throwable4;
        }
        file = LoggerProvider.getLogger();
        object2 = SBWrapper.INSTANCE.getLoggerTag$barcode_sdk_wrapper_release();
        object = throwable3.getMessage();
        if (object == null) {
            object = "Error while hashing the URI";
        }
        file.e((String)object2, (String)object);
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

