/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.barcode.operations.setup;

import android.app.Application;
import android.net.Uri;
import androidx.core.net.UriKt;
import io.scanbot.sdk.barcode_scanner.ScanbotBarcodeScannerSDKInitializer;
import io.scanbot.sdk.licensing.LicenseInfo;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.barcode.SBBWrapper;
import io.scanbot.sdk_wrapper.barcode.operations.setup.SBBSdkConfiguration;
import io.scanbot.sdk_wrapper.barcode.operations.setup.SBBSdkInitializerExtensionKt;
import io.scanbot.sdk_wrapper.enums.SBSDKType;
import io.scanbot.sdk_wrapper.extensions.SBJSONExtensionKt;
import io.scanbot.sdk_wrapper.interfaces.SBResultDelegate;
import io.scanbot.sdk_wrapper.utils.SBStorageUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u000e"}, d2={"Lio/scanbot/sdk_wrapper/barcode/operations/setup/SBBSetupOperations;", "", "<init>", "()V", "initializeSdk", "", "application", "Landroid/app/Application;", "configurationAsJSON", "Lorg/json/JSONObject;", "resultDelegate", "Lio/scanbot/sdk_wrapper/interfaces/SBResultDelegate;", "(Landroid/app/Application;Lorg/json/JSONObject;Lio/scanbot/sdk_wrapper/interfaces/SBResultDelegate;)Lkotlin/Unit;", "cleanup", "barcode-sdk-wrapper_release"})
public final class SBBSetupOperations {
    @NotNull
    public static final SBBSetupOperations INSTANCE = new SBBSetupOperations();

    private SBBSetupOperations() {
    }

    @JvmStatic
    @Nullable
    public static final Unit initializeSdk(@NotNull Application application, @NotNull JSONObject jSONObject, @NotNull SBResultDelegate sBResultDelegate) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"configurationAsJSON");
        Intrinsics.checkNotNullParameter((Object)sBResultDelegate, (String)"resultDelegate");
        application = () -> SBBSetupOperations.a(application, jSONObject, sBResultDelegate);
        return (Unit)SBWrapper.INSTANCE.runFunction$barcode_sdk_wrapper_release((LicenseInfo)null, sBResultDelegate, false, false, application);
    }

    @JvmStatic
    public static final void cleanup(@NotNull SBResultDelegate sBResultDelegate) {
        Intrinsics.checkNotNullParameter((Object)sBResultDelegate, (String)"resultDelegate");
        LicenseInfo licenseInfo = SBBWrapper.INSTANCE.getLicenseInfoOrReject$barcode_sdk_wrapper_release(sBResultDelegate);
        if (licenseInfo == null) {
            return;
        }
        LicenseInfo licenseInfo2 = licenseInfo;
        licenseInfo = () -> SBBSetupOperations.a(sBResultDelegate);
        SBWrapper.runFunction$barcode_sdk_wrapper_release$default(SBWrapper.INSTANCE, licenseInfo2, sBResultDelegate, false, false, (Function0)licenseInfo, 12, null);
    }

    private static final Unit a(Application application, JSONObject object, SBResultDelegate sBResultDelegate) {
        JSONObject jSONObject = object;
        object = SBWrapper.INSTANCE;
        ((SBWrapper)object).setApplication$barcode_sdk_wrapper_release(application);
        ((SBWrapper)object).setSdkType$barcode_sdk_wrapper_release(SBSDKType.BS);
        ((SBWrapper)object).setLoggerTag$barcode_sdk_wrapper_release("ScanbotBarcodeSDKWrapper");
        SBBSdkConfiguration sBBSdkConfiguration = SBJSONExtensionKt.deserialize(jSONObject, SBBSdkConfiguration.class);
        LicenseInfo licenseInfo = SBBSdkInitializerExtensionKt.fromWrapperConfig(new ScanbotBarcodeScannerSDKInitializer(), sBBSdkConfiguration).initialize(application);
        if (sBBSdkConfiguration.getStorageBaseDirectory() != null) {
            SBStorageUtils sBStorageUtils = SBStorageUtils.INSTANCE;
            Uri uri = sBBSdkConfiguration.getStorageBaseDirectoryUri();
            Intrinsics.checkNotNull((Object)uri);
            sBStorageUtils.setBaseNativeStorageDirectory$barcode_sdk_wrapper_release(UriKt.toFile((Uri)uri));
            Uri uri2 = sBBSdkConfiguration.getStorageBaseDirectoryUri();
            Intrinsics.checkNotNull((Object)uri2);
            Uri uri3 = uri2.buildUpon().appendPath("scanbot_sdk_wrapper").build();
            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"build(...)");
            sBStorageUtils.setBaseWrapperDirectory$barcode_sdk_wrapper_release(UriKt.toFile((Uri)uri3));
        } else {
            SBStorageUtils sBStorageUtils = SBStorageUtils.INSTANCE;
            sBStorageUtils.setBaseNativeStorageDirectory$barcode_sdk_wrapper_release(new File(application.getFilesDir(), "scanbot-sdk"));
            sBStorageUtils.setBaseWrapperDirectory$barcode_sdk_wrapper_release(new File(application.getFilesDir(), "scanbot_sdk_wrapper"));
        }
        LoggerProvider.getLogger().i(((SBWrapper)object).getLoggerTag$barcode_sdk_wrapper_release(), "Wrapper v8.0.1.0");
        ((SBWrapper)object).setWrapperInitializationAndSendResult$barcode_sdk_wrapper_release(licenseInfo, sBResultDelegate);
        return Unit.INSTANCE;
    }

    private static final void b(SBResultDelegate sBResultDelegate) {
        try {
            SBBWrapper.INSTANCE.getBarcodeFileStorage$barcode_sdk_wrapper_release().cleanupBarcodeImagesDirectory();
            SBStorageUtils.INSTANCE.cleanupWrapperStorage$barcode_sdk_wrapper_release();
            SBResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release(sBResultDelegate);
            return;
        }
        catch (Throwable throwable) {
            SBResultDelegate.Companion.sendFailureOnMainThread$barcode_sdk_wrapper_release(sBResultDelegate, throwable);
            return;
        }
    }

    private static final Unit a(SBResultDelegate sBResultDelegate) {
        SBWrapper sBWrapper = SBWrapper.INSTANCE;
        LoggerProvider.getLogger().i(sBWrapper.getLoggerTag$barcode_sdk_wrapper_release(), "Cleaning storage folder ...");
        sBWrapper.getThreadPool$barcode_sdk_wrapper_release().execute(() -> SBBSetupOperations.b(sBResultDelegate));
        return Unit.INSTANCE;
    }
}

