/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.graphics.Rect;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.barcode.BarcodeItem;
import io.scanbot.sdk.barcode.BarcodeScanner;
import io.scanbot.sdk.barcode.BarcodeScannerResult;
import io.scanbot.sdk.barcode.IBarcodeFilter;
import io.scanbot.sdk.barcode.SuccessFrameDebouncer;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 /2\u00020\u0001:\u0003-./B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u001eH\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\nJ\u000e\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\nJ\u000e\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010\u0014J\u001e\u0010*\u001a\u00020\u00162\u0014\u0010 \u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0012\u0004\u0012\u00020,0+H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u00060"}, d2={"Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler;", "Lio/scanbot/sdk/camera/FrameHandler;", "barcodeScanner", "Lio/scanbot/sdk/barcode/BarcodeScanner;", "<init>", "(Lio/scanbot/sdk/barcode/BarcodeScanner;)V", "getBarcodeScanner$sdk_barcode_release", "()Lio/scanbot/sdk/barcode/BarcodeScanner;", "handlers", "Ljava/util/LinkedHashSet;", "Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler$ResultHandler;", "sapManager", "Lio/scanbot/sap/SapManager;", "getSapManager$sdk_barcode_release", "()Lio/scanbot/sap/SapManager;", "logger", "Lio/scanbot/sdk/util/log/Logger;", "successFrameDebouncer", "Lio/scanbot/sdk/barcode/SuccessFrameDebouncer;", "barcodeFilter", "Lio/scanbot/sdk/barcode/IBarcodeFilter;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "handleFrame", "previewFrame", "Lio/scanbot/sdk/camera/FrameHandler$Frame;", "launchFrameScanning", "Lio/scanbot/sdk/barcode/BarcodeScannerResult;", "applyFilter", "result", "addResultHandler", "", "handler", "removeResultHandler", "setScanningInterval", "scanningIntervalInMs", "", "setBarcodeFilter", "filter", "notifyHandlers", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/SdkLicenseError;", "ResultHandler", "BarcodeScannerResultHandler", "Companion", "sdk-barcode_release"})
@SourceDebugExtension(value={"SMAP\nBarcodeScannerFrameHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeScannerFrameHandler.kt\nio/scanbot/sdk/barcode/BarcodeScannerFrameHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n774#2:173\n865#2,2:174\n*S KotlinDebug\n*F\n+ 1 BarcodeScannerFrameHandler.kt\nio/scanbot/sdk/barcode/BarcodeScannerFrameHandler\n*L\n84#1:173\n84#1:174,2\n*E\n"})
public class BarcodeScannerFrameHandler
extends FrameHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int DEFAULT_BARCODE_SCANNING_INTERVAL_IN_MS = 10000;
    @NotNull
    private final BarcodeScanner barcodeScanner;
    @NotNull
    private final LinkedHashSet<ResultHandler> handlers;
    @NotNull
    private final SapManager sapManager;
    @NotNull
    private final Logger logger;
    @NotNull
    private final SuccessFrameDebouncer successFrameDebouncer;
    @Nullable
    private IBarcodeFilter barcodeFilter;
    private boolean isEnabled;

    /*
     * WARNING - void declaration
     */
    public BarcodeScannerFrameHandler(@NotNull BarcodeScanner barcodeScanner) {
        void var1_1;
        BarcodeScannerFrameHandler barcodeScannerFrameHandler = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"barcodeScanner");
        barcodeScannerFrameHandler.barcodeScanner = var1_1;
        barcodeScannerFrameHandler.handlers = new LinkedHashSet();
        barcodeScannerFrameHandler.sapManager = SapSingleton.getInstance();
        barcodeScannerFrameHandler.logger = LoggerProvider.getLogger();
        barcodeScannerFrameHandler.successFrameDebouncer = new SuccessFrameDebouncer(10000L);
        barcodeScannerFrameHandler.isEnabled = true;
    }

    private final BarcodeScannerResult launchFrameScanning(FrameHandler.Frame previewFrame) {
        BarcodeScannerResult barcodeScannerResult;
        if (previewFrame.getFinderRect() == null) {
            void v0 = var1_1;
            this = v0.getFrame();
            int n = v0.getWidth();
            int n2 = v0.getHeight();
            int n3 = v0.getFrameOrientation();
            barcodeScannerResult = this.barcodeScanner.scanFromNv21((byte[])this, n, n2, n3);
        } else {
            void v2 = var1_1;
            this = v2.getFrame();
            int n = v2.getWidth();
            int n4 = v2.getHeight();
            int n5 = v2.getFrameOrientation();
            Rect rect = v2.getFinderRect();
            barcodeScannerResult = this.barcodeScanner.scanFromNv21((byte[])this, n, n4, n5, rect);
        }
        return barcodeScannerResult;
    }

    private final BarcodeScannerResult applyFilter(BarcodeScannerResult result) {
        BarcodeScannerResult barcodeScannerResult;
        if (result != null && !barcodeScannerResult.getBarcodes().isEmpty()) {
            IBarcodeFilter iBarcodeFilter = ((BarcodeScannerFrameHandler)((Object)iBarcodeFilter)).barcodeFilter;
            if (iBarcodeFilter != null) {
                BarcodeScannerResult barcodeScannerResult2;
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                for (Object t : barcodeScannerResult.getBarcodes()) {
                    if (!iBarcodeFilter.acceptsBarcode((BarcodeItem)t)) continue;
                    arrayList2.add(t);
                }
                boolean bl = barcodeScannerResult.getSuccess();
                barcodeScannerResult = barcodeScannerResult2;
                barcodeScannerResult2 = new BarcodeScannerResult(arrayList2, bl);
            }
            return barcodeScannerResult;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean notifyHandlers(FrameHandlerResult<BarcodeScannerResult, SdkLicenseError> result) {
        void var1_1;
        BarcodeScannerFrameHandler barcodeScannerFrameHandler = this;
        return barcodeScannerFrameHandler.processResult(() -> BarcodeScannerFrameHandler.notifyHandlers$lambda$5(barcodeScannerFrameHandler, (FrameHandlerResult)var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean notifyHandlers$lambda$5(BarcodeScannerFrameHandler this$0, FrameHandlerResult $result) {
        BarcodeScannerFrameHandler barcodeScannerFrameHandler = this$0;
        boolean bl = false;
        LinkedHashSet<ResultHandler> linkedHashSet = barcodeScannerFrameHandler.handlers;
        synchronized (linkedHashSet) {
            Throwable throwable2;
            block5: {
                Iterator iterator;
                try {
                    iterator = ((AbstractCollection)barcodeScannerFrameHandler.handlers).iterator();
                }
                catch (Throwable throwable2) {
                    break block5;
                }
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                while (iterator.hasNext()) {
                    void var1_2;
                    Object e2 = iterator.next();
                    Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
                    bl |= ((ResultHandler)e2).handle((FrameHandlerResult)var1_2);
                }
                return bl;
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final BarcodeScannerFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull BarcodeScanner barcodeScanner) {
        void var1_1;
        IScanbotCameraView iScanbotCameraView;
        return Companion.attach(iScanbotCameraView, (BarcodeScanner)var1_1);
    }

    @NotNull
    public final BarcodeScanner getBarcodeScanner$sdk_barcode_release() {
        return this.barcodeScanner;
    }

    @NotNull
    public final SapManager getSapManager$sdk_barcode_release() {
        return this.sapManager;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnabled(boolean bl) {
        void var1_1;
        this.isEnabled = var1_1;
    }

    public synchronized boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
        BarcodeScannerResult barcodeScannerResult;
        BarcodeScannerFrameHandler barcodeScannerFrameHandler = this;
        Intrinsics.checkNotNullParameter((Object)barcodeScannerResult, (String)"previewFrame");
        barcodeScannerFrameHandler.logger.logMethod();
        if (barcodeScannerFrameHandler.successFrameDebouncer.shouldSkip()) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            this.notifyHandlers((FrameHandlerResult<BarcodeScannerResult, SdkLicenseError>)new FrameHandlerResult.Failure((Object)new SdkLicenseError(this.sapManager.getLicenseStatus().getLicenseStatusMessage())));
            return false;
        }
        BarcodeScannerFrameHandler barcodeScannerFrameHandler2 = this;
        if ((barcodeScannerResult = barcodeScannerFrameHandler2.applyFilter(barcodeScannerFrameHandler2.launchFrameScanning((FrameHandler.Frame)barcodeScannerResult))) != null && !barcodeScannerResult.getBarcodes().isEmpty()) {
            this.successFrameDebouncer.activate();
        }
        return this.notifyHandlers((FrameHandlerResult<BarcodeScannerResult, SdkLicenseError>)new FrameHandlerResult.Success((Object)barcodeScannerResult));
    }

    /*
     * WARNING - void declaration
     */
    public final void addResultHandler(@NotNull ResultHandler handler) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            ((AbstractCollection)this.handlers).add((ResultHandler)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeResultHandler(@NotNull ResultHandler handler) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            ((AbstractCollection)this.handlers).remove(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setScanningInterval(long scanningIntervalInMs) {
        void var1_1;
        BarcodeScannerFrameHandler barcodeScannerFrameHandler = this;
        barcodeScannerFrameHandler.successFrameDebouncer.setInterval((long)var1_1);
        barcodeScannerFrameHandler.successFrameDebouncer.reset();
    }

    /*
     * WARNING - void declaration
     */
    public final void setBarcodeFilter(@Nullable IBarcodeFilter filter) {
        void var1_1;
        this.barcodeFilter = var1_1;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler$BarcodeScannerResultHandler;", "Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler$ResultHandler;", "<init>", "()V", "sdk-barcode_release"})
    public static abstract class BarcodeScannerResultHandler
    implements ResultHandler {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler$Companion;", "", "<init>", "()V", "DEFAULT_BARCODE_SCANNING_INTERVAL_IN_MS", "", "attach", "Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "barcodeScanner", "Lio/scanbot/sdk/barcode/BarcodeScanner;", "sdk-barcode_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final BarcodeScannerFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull BarcodeScanner barcodeScanner) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"cameraView");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"barcodeScanner");
            Object object = (BarcodeScannerFrameHandler)cameraView.getAttachedFrameHandler(BarcodeScannerFrameHandler.class);
            if (object == null) {
                BarcodeScannerFrameHandler barcodeScannerFrameHandler;
                object = barcodeScannerFrameHandler;
                barcodeScannerFrameHandler = new BarcodeScannerFrameHandler((BarcodeScanner)var2_2);
            }
            var1_1.addFrameHandler((FrameHandler)object);
            return object;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler$ResultHandler;", "Lio/scanbot/sdk/camera/BaseResultHandler;", "Lio/scanbot/sdk/barcode/BarcodeScannerResult;", "Lio/scanbot/sdk/SdkLicenseError;", "sdk-barcode_release"})
    public static interface ResultHandler
    extends BaseResultHandler<BarcodeScannerResult, SdkLicenseError> {
    }
}

