/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.graphics.Rect;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.barcode.BarcodeItem;
import io.scanbot.sdk.barcode.BarcodeScanner;
import io.scanbot.sdk.barcode.BarcodeScannerResult;
import io.scanbot.sdk.barcode.IBarcodeFilter;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 02\u00020\u0001:\u0003/01B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bJ\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010!H\u0002J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020%H\u0002J\u001e\u0010'\u001a\u00020\u000e2\u0014\u0010\"\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0004\u0012\u00020)0(H\u0002J\u0006\u0010*\u001a\u00020\u001eJ\u000e\u0010+\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bJ\u0006\u0010,\u001a\u00020\u001eJ\u0010\u0010-\u001a\u00020\u001e2\b\u0010.\u001a\u0004\u0018\u00010\u0006R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00062"}, d2={"Lio/scanbot/sdk/barcode/BarcodeCounterFrameHandler;", "Lio/scanbot/sdk/camera/FrameHandler;", "barcodeScanner", "Lio/scanbot/sdk/barcode/BarcodeScanner;", "(Lio/scanbot/sdk/barcode/BarcodeScanner;)V", "barcodeFilter", "Lio/scanbot/sdk/barcode/IBarcodeFilter;", "getBarcodeScanner$sdk_barcode_release", "()Lio/scanbot/sdk/barcode/BarcodeScanner;", "handlers", "Ljava/util/LinkedHashSet;", "Lio/scanbot/sdk/barcode/BarcodeCounterFrameHandler$ResultHandler;", "Lkotlin/collections/LinkedHashSet;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "sapManager", "Lio/scanbot/sap/SapManager;", "getSapManager$sdk_barcode_release", "()Lio/scanbot/sap/SapManager;", "viewHandler", "getViewHandler", "()Lio/scanbot/sdk/barcode/BarcodeCounterFrameHandler$ResultHandler;", "setViewHandler", "(Lio/scanbot/sdk/barcode/BarcodeCounterFrameHandler$ResultHandler;)V", "addResultHandler", "", "handler", "applyFilter", "Lio/scanbot/sdk/barcode/BarcodeScannerResult;", "result", "handleFrame", "previewFrame", "Lio/scanbot/sdk/camera/FrameHandler$Frame;", "launchFrameScanning", "notifyHandlers", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/SdkLicenseError;", "performSingleShotScan", "removeResultHandler", "resetViewState", "setBarcodeFilter", "filter", "BarcodeCounterResultHandler", "Companion", "ResultHandler", "sdk-barcode_release"})
@SourceDebugExtension(value={"SMAP\nBarcodeCounterFrameHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeCounterFrameHandler.kt\nio/scanbot/sdk/barcode/BarcodeCounterFrameHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n766#2:171\n857#2,2:172\n*S KotlinDebug\n*F\n+ 1 BarcodeCounterFrameHandler.kt\nio/scanbot/sdk/barcode/BarcodeCounterFrameHandler\n*L\n78#1:171\n78#1:172,2\n*E\n"})
public class BarcodeCounterFrameHandler
extends FrameHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BarcodeScanner barcodeScanner;
    @Nullable
    private ResultHandler viewHandler;
    @NotNull
    private final LinkedHashSet<ResultHandler> handlers;
    @NotNull
    private final SapManager sapManager;
    @NotNull
    private final Logger logger;
    @Nullable
    private IBarcodeFilter barcodeFilter;
    private boolean isEnabled;

    /*
     * WARNING - void declaration
     */
    public BarcodeCounterFrameHandler(@NotNull BarcodeScanner barcodeScanner) {
        void var1_1;
        BarcodeCounterFrameHandler barcodeCounterFrameHandler = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"barcodeScanner");
        barcodeCounterFrameHandler.barcodeScanner = var1_1;
        barcodeCounterFrameHandler.handlers = new LinkedHashSet();
        barcodeCounterFrameHandler.sapManager = SapSingleton.getInstance();
        barcodeCounterFrameHandler.logger = LoggerProvider.getLogger();
    }

    private final BarcodeScannerResult launchFrameScanning(FrameHandler.Frame previewFrame) {
        BarcodeScannerResult barcodeScannerResult;
        if (previewFrame.getFinderRect() == null) {
            void v0 = var1_1;
            this = v0.getFrame();
            int n = v0.getWidth();
            int n2 = v0.getHeight();
            int n3 = v0.getFrameOrientation();
            barcodeScannerResult = this.barcodeScanner.scanFromNv21((byte[])this, n, n2, n3, null);
        } else {
            void v2 = var1_1;
            this = v2.getFrame();
            int n = v2.getWidth();
            int n4 = v2.getHeight();
            int n5 = v2.getFrameOrientation();
            Rect rect = v2.getFinderRect();
            barcodeScannerResult = this.barcodeScanner.scanFromNv21((byte[])this, n, n4, n5, rect);
        }
        return barcodeScannerResult;
    }

    private final BarcodeScannerResult applyFilter(BarcodeScannerResult result) {
        BarcodeScannerResult barcodeScannerResult;
        if (result != null && !barcodeScannerResult.getBarcodes().isEmpty()) {
            IBarcodeFilter iBarcodeFilter = ((BarcodeCounterFrameHandler)((Object)iBarcodeFilter)).barcodeFilter;
            if (iBarcodeFilter != null) {
                BarcodeScannerResult barcodeScannerResult2;
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                for (Object t : barcodeScannerResult.getBarcodes()) {
                    if (!iBarcodeFilter.acceptsBarcode((BarcodeItem)t)) continue;
                    arrayList2.add(t);
                }
                boolean bl = barcodeScannerResult.getSuccess();
                barcodeScannerResult = barcodeScannerResult2;
                barcodeScannerResult2 = new BarcodeScannerResult(arrayList2, bl);
            }
            return barcodeScannerResult;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean notifyHandlers(FrameHandlerResult<BarcodeScannerResult, SdkLicenseError> result) {
        BarcodeCounterFrameHandler barcodeCounterFrameHandler = this_;
        boolean bl = false;
        LinkedHashSet<ResultHandler> linkedHashSet = barcodeCounterFrameHandler.handlers;
        synchronized (linkedHashSet) {
            Throwable throwable2;
            block7: {
                boolean bl2;
                void var1_1;
                block6: {
                    ResultHandler resultHandler = barcodeCounterFrameHandler.viewHandler;
                    if (resultHandler == null) break block6;
                    resultHandler.handle((FrameHandlerResult)var1_1);
                }
                try {
                    Iterator this_ = ((AbstractCollection)((BarcodeCounterFrameHandler)((Object)this_)).handlers).iterator();
                    while (this_.hasNext()) {
                        bl |= ((ResultHandler)this_.next()).handle((FrameHandlerResult)var1_1);
                    }
                    bl2 = bl;
                    LinkedHashSet<ResultHandler> linkedHashSet2 = linkedHashSet;
                }
                catch (Throwable throwable2) {}
                break block7;
                // ** MonitorExit[v2] (shouldn't be in output)
                return bl2;
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final BarcodeCounterFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull BarcodeScanner barcodeScanner) {
        void var1_1;
        IScanbotCameraView iScanbotCameraView;
        return Companion.attach(iScanbotCameraView, (BarcodeScanner)var1_1);
    }

    @NotNull
    public final BarcodeScanner getBarcodeScanner$sdk_barcode_release() {
        return this.barcodeScanner;
    }

    @Nullable
    public final ResultHandler getViewHandler() {
        return this.viewHandler;
    }

    /*
     * WARNING - void declaration
     */
    public final void setViewHandler(@Nullable ResultHandler resultHandler) {
        void var1_1;
        this.viewHandler = var1_1;
    }

    @NotNull
    public final SapManager getSapManager$sdk_barcode_release() {
        return this.sapManager;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnabled(boolean bl) {
        void var1_1;
        this.isEnabled = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
        void var1_1;
        BarcodeCounterFrameHandler barcodeCounterFrameHandler = this_;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"previewFrame");
        barcodeCounterFrameHandler.logger.logMethod();
        barcodeCounterFrameHandler.setEnabled(false);
        if (!barcodeCounterFrameHandler.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            this_.notifyHandlers((FrameHandlerResult<BarcodeScannerResult, SdkLicenseError>)new FrameHandlerResult.Failure((Object)new SdkLicenseError(this_.sapManager.getLicenseStatus().getLicenseStatusMessage())));
            return false;
        }
        BarcodeCounterFrameHandler barcodeCounterFrameHandler2 = this_;
        BarcodeCounterFrameHandler this_ = barcodeCounterFrameHandler2.applyFilter(barcodeCounterFrameHandler2.launchFrameScanning((FrameHandler.Frame)var1_1));
        return barcodeCounterFrameHandler2.notifyHandlers((FrameHandlerResult<BarcodeScannerResult, SdkLicenseError>)new FrameHandlerResult.Success((Object)this_, FrameHandler.Frame.copy$default((FrameHandler.Frame)var1_1, (byte[])new byte[0], (int)0, (int)0, (int)0, null, null, (int)0, (int)0, null, (boolean)false, (int)1022, null)));
    }

    public final void resetViewState() {
        Object this_ = this_.viewHandler;
        if (this_ != null) {
            FrameHandler.Frame frame;
            Object object = this_;
            this_ = frame;
            frame = new FrameHandler.Frame();
            object.handle((FrameHandlerResult)new FrameHandlerResult.Success((Object)new BarcodeScannerResult(CollectionsKt.emptyList(), false), (FrameHandler.Frame)this_));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addResultHandler(@NotNull ResultHandler handler) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            ((AbstractCollection)this.handlers).add((ResultHandler)var1_1);
            return;
        }
    }

    public final void performSingleShotScan() {
        this.setEnabled(true);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeResultHandler(@NotNull ResultHandler handler) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            ((AbstractCollection)this.handlers).remove(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setBarcodeFilter(@Nullable IBarcodeFilter filter) {
        void var1_1;
        this.barcodeFilter = var1_1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/scanbot/sdk/barcode/BarcodeCounterFrameHandler$BarcodeCounterResultHandler;", "Lio/scanbot/sdk/barcode/BarcodeCounterFrameHandler$ResultHandler;", "()V", "sdk-barcode_release"})
    public static abstract class BarcodeCounterResultHandler
    implements ResultHandler {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/barcode/BarcodeCounterFrameHandler$Companion;", "", "()V", "attach", "Lio/scanbot/sdk/barcode/BarcodeCounterFrameHandler;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "barcodeScanner", "Lio/scanbot/sdk/barcode/BarcodeScanner;", "sdk-barcode_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final BarcodeCounterFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull BarcodeScanner barcodeScanner) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"cameraView");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"barcodeScanner");
            Object object = (BarcodeCounterFrameHandler)cameraView.getAttachedFrameHandler(BarcodeCounterFrameHandler.class);
            if (object == null) {
                BarcodeCounterFrameHandler barcodeCounterFrameHandler;
                object = barcodeCounterFrameHandler;
                barcodeCounterFrameHandler = new BarcodeCounterFrameHandler((BarcodeScanner)var2_2);
            }
            var1_1.addFrameHandler((FrameHandler)object);
            return object;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/barcode/BarcodeCounterFrameHandler$ResultHandler;", "Lio/scanbot/sdk/camera/BaseResultHandler;", "Lio/scanbot/sdk/barcode/BarcodeScannerResult;", "Lio/scanbot/sdk/SdkLicenseError;", "sdk-barcode_release"})
    public static interface ResultHandler
    extends BaseResultHandler<BarcodeScannerResult, SdkLicenseError> {
    }
}

