/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.util.CursorUtil;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J;\u0010\u0012\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/scanbot/sdk/util/FileChooserUtils;", "", "<init>", "()V", "CONTENT_SCHEME", "", "FILE_SCHEME", "EXTERNALSTORAGE_AUTHORITY", "DOWNLOADS_AUTHORITY", "MEDIA_AUTHORITY", "PUBLIC_DOWNLOADS_LINK", "getPath", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "getDataColumn", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "isExternalStorageDocument", "", "isDownloadsDocument", "isMediaDocument", "TAG", "sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nFileChooserUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileChooserUtils.kt\nio/scanbot/sdk/util/FileChooserUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,155:1\n37#2:156\n36#2,3:157\n37#2:160\n36#2,3:161\n1#3:164\n36#4:165\n*S KotlinDebug\n*F\n+ 1 FileChooserUtils.kt\nio/scanbot/sdk/util/FileChooserUtils\n*L\n45#1:156\n45#1:157,3\n61#1:160\n61#1:161,3\n83#1:165\n*E\n"})
public final class FileChooserUtils {
    @NotNull
    public static final FileChooserUtils INSTANCE = new FileChooserUtils();
    @NotNull
    private static final String CONTENT_SCHEME = "content";
    @NotNull
    private static final String FILE_SCHEME = "file";
    @NotNull
    private static final String EXTERNALSTORAGE_AUTHORITY = "com.android.externalstorage.documents";
    @NotNull
    private static final String DOWNLOADS_AUTHORITY = "com.android.providers.downloads.documents";
    @NotNull
    private static final String MEDIA_AUTHORITY = "com.android.providers.media.documents";
    @NotNull
    private static final String PUBLIC_DOWNLOADS_LINK = "content://downloads/public_downloads";
    @NotNull
    private static final String TAG = "FileChooserUtils";

    private FileChooserUtils() {
    }

    @JvmStatic
    @Nullable
    public static final String getPath(@NotNull Context context, @NotNull Uri uri, @NotNull FileIOProcessor fileIOProcessor) {
        String[] stringArray;
        Object object;
        block14: {
            block13: {
                block12: {
                    Uri uri2;
                    Intrinsics.checkNotNullParameter((Object)object, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)stringArray, (String)"uri");
                    Intrinsics.checkNotNullParameter((Object)uri2, (String)"fileIOProcessor");
                    if (!DocumentsContract.isDocumentUri((Context)context, (Uri)stringArray)) break block12;
                    if (FileChooserUtils.isExternalStorageDocument((Uri)stringArray)) {
                        String string = DocumentsContract.getDocumentId((Uri)stringArray);
                        Intrinsics.checkNotNull((Object)string);
                        object = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).toArray(new String[0]);
                        if (StringsKt.equals((String)"primary", (String)object[0], (boolean)true)) {
                            return Environment.getExternalStorageDirectory() + "/" + (String)object[1];
                        }
                    } else {
                        if (FileChooserUtils.isDownloadsDocument((Uri)stringArray)) {
                            Long l = Long.valueOf(DocumentsContract.getDocumentId((Uri)stringArray));
                            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"valueOf(...)");
                            Uri uri3 = ContentUris.withAppendedId((Uri)Uri.parse((String)PUBLIC_DOWNLOADS_LINK), (long)l);
                            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"withAppendedId(...)");
                            return FileChooserUtils.getDataColumn((Context)object, uri3, null, null);
                        }
                        if (FileChooserUtils.isMediaDocument((Uri)stringArray)) {
                            String string = DocumentsContract.getDocumentId((Uri)stringArray);
                            Intrinsics.checkNotNull((Object)string);
                            stringArray = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).toArray(new String[0]);
                            uri2 = null;
                            if (Intrinsics.areEqual((Object)"image", (Object)stringArray[0])) {
                                uri2 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                            }
                            Object object2 = object;
                            object = stringArray[1];
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = object;
                            return FileChooserUtils.getDataColumn((Context)object2, uri2, "_id=?", stringArray);
                        }
                    }
                    break block13;
                }
                if (StringsKt.equals((String)CONTENT_SCHEME, (String)stringArray.getScheme(), (boolean)true)) {
                    LoggerProvider.getLogger().w(TAG, "Getting path from content uri is not supported anymore due to security reasons.");
                    return null;
                }
                if (StringsKt.equals((String)FILE_SCHEME, (String)stringArray.getScheme(), (boolean)true) || (object = stringArray.getScheme()) == null || object.length() == 0) break block14;
            }
            return null;
        }
        object = stringArray.getPath();
        if (object != null) {
            Uri uri4 = Uri.fromFile((File)new File((String)object));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri4, (String)"Uri.fromFile(this)");
            return uri4.getPath();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String getDataColumn(@Nullable Context context, @Nullable Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        Object object;
        void var1_1;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_data";
        if (context == null) {
            if (var1_1 != null && (object = var1_1.getPath()) != null) {
                return object;
            }
            return "";
        }
        if (var1_1 != null) {
            void var3_4;
            void var2_3;
            if ((object = object.getContentResolver()) == null) {
                object = var1_1.getPath();
                if (object == null) {
                    return "";
                }
                return object;
            }
            if ((object = object.query((Uri)var1_1, stringArray2, (String)var2_3, (String[])var3_4, null)) != null) {
                Object object2 = object;
                int n = object2.getColumnIndexOrThrow("_data");
                object2.moveToFirst();
                String string = object2.getString(n);
                CursorUtil.closeQuietly((Cursor)object);
                Intrinsics.checkNotNull((Object)string);
                return string;
            }
        }
        if (var1_1 != null && (object = var1_1.getPath()) != null) {
            return object;
        }
        return "";
    }

    @JvmStatic
    public static final boolean isExternalStorageDocument(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)EXTERNALSTORAGE_AUTHORITY, (Object)uri2.getAuthority());
    }

    @JvmStatic
    public static final boolean isDownloadsDocument(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)DOWNLOADS_AUTHORITY, (Object)uri2.getAuthority());
    }

    @JvmStatic
    public static final boolean isMediaDocument(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)MEDIA_AUTHORITY, (Object)uri2.getAuthority());
    }
}

