/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.fileio;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import io.scanbot.sdk.exceptions.crypto.SourceFileDoesNotExistException;
import io.scanbot.sdk.image.EncodeImageOptions;
import io.scanbot.sdk.image.EncryptionMode;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.image.SaveImageOptions;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020!2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010'\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010(\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0017H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lio/scanbot/sdk/persistence/fileio/DefaultFileIOProcessor;", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "useEncryption", "", "getUseEncryption", "()Z", "logger", "Lio/scanbot/sdk/util/log/Logger;", "writeImage", "", "bitmap", "Landroid/graphics/Bitmap;", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "", "destination", "Ljava/io/File;", "image", "Lio/scanbot/sdk/image/ImageRef;", "encodeImageOptions", "Lio/scanbot/sdk/image/EncodeImageOptions;", "readImage", "source", "options", "Landroid/graphics/BitmapFactory$Options;", "sourceUri", "Landroid/net/Uri;", "read", "", "write", "byteArray", "copyRaw", "copy", "move", "openFileOutputStream", "Ljava/io/OutputStream;", "destinationFile", "openFileInputStream", "Ljava/io/InputStream;", "sourceFile", "sdk-base_release"})
public final class DefaultFileIOProcessor
implements FileIOProcessor {
    @NotNull
    private final Context context;
    private final boolean useEncryption;
    @NotNull
    private final Logger logger;

    /*
     * WARNING - void declaration
     */
    public DefaultFileIOProcessor(@NotNull Context context) {
        void var1_1;
        DefaultFileIOProcessor defaultFileIOProcessor = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        defaultFileIOProcessor.context = var1_1;
        defaultFileIOProcessor.logger = LoggerProvider.getLogger();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    public boolean getUseEncryption() {
        return this.useEncryption;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeImage(@NotNull Bitmap bitmap, @NotNull Bitmap.CompressFormat compressFormat, int quality, @NotNull File destination) {
        FileOutputStream fileOutputStream;
        void var4_4;
        void var2_2;
        Throwable throwable;
        File file = destination;
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"compressFormat");
        Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
        if (file.exists()) {
            var4_4.delete();
        }
        FileOutputStream fileOutputStream2 = fileOutputStream;
        void v2 = throwable;
        fileOutputStream2((File)var4_4);
        throwable = null;
        try {
            void var3_3;
            v2.compress((Bitmap.CompressFormat)var2_2, (int)var3_3, (OutputStream)fileOutputStream2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            try {
                throw throwable2;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)fileOutputStream2, (Throwable)throwable);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally((Closeable)fileOutputStream, (Throwable)throwable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeImage(@NotNull ImageRef image, @NotNull EncodeImageOptions encodeImageOptions, @NotNull File destination) {
        SaveImageOptions saveImageOptions;
        void var3_3;
        void var2_2;
        SaveImageOptions saveImageOptions2;
        File file = destination;
        Intrinsics.checkNotNullParameter((Object)saveImageOptions2, (String)"image");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"encodeImageOptions");
        Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
        if (file.exists()) {
            var3_3.delete();
        }
        void v1 = saveImageOptions2;
        String string = var3_3.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        saveImageOptions2 = saveImageOptions;
        saveImageOptions = new SaveImageOptions(0, EncryptionMode.AUTO, null, 5, null);
        v1.saveImage(string, saveImageOptions2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Bitmap readImage(@NotNull File source, @Nullable BitmapFactory.Options options) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"source");
        Uri uri = Uri.fromFile((File)v0);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(...)");
        return this.readImage(uri, (BitmapFactory.Options)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Bitmap readImage(@NotNull Uri sourceUri, @Nullable BitmapFactory.Options options) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sourceUri, (String)"sourceUri");
        if (new File(var1_1.getPath()).exists()) {
            void var2_2;
            return BitmapFactory.decodeFile((String)var1_1.getPath(), (BitmapFactory.Options)var2_2);
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public byte[] read(@NotNull File source) {
        File file = source;
        Intrinsics.checkNotNullParameter((Object)file, (String)"source");
        if (file.exists()) {
            void var1_1;
            return FilesKt.readBytes((File)var1_1);
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull byte[] byteArray, @NotNull File destination) {
        void var2_2;
        void var1_1;
        File file = destination;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
        if (file.exists()) {
            var2_2.delete();
        }
        FilesKt.writeBytes((File)var2_2, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void copyRaw(@NotNull File source, @NotNull File destination) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"destination");
        if (source.exists()) {
            FilesKt.copyTo$default((File)var1_1, (File)var2_2, (boolean)true, (int)0, (int)4, null);
            return;
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void copy(@NotNull File source, @NotNull File destination) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"destination");
        this.copyRaw((File)var1_1, (File)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void move(@NotNull File source, @NotNull File destination) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"destination");
        this.copy((File)var1_1, (File)var2_2);
        source.delete();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OutputStream openFileOutputStream(@NotNull File destinationFile) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        return new FileOutputStream((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InputStream openFileInputStream(@NotNull File sourceFile) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return new FileInputStream((File)var1_1);
    }
}

