/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Build;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.DynamicRangeResolver;
import androidx.camera.camera2.internal.GuaranteedConfigurationsUtil;
import androidx.camera.camera2.internal.StreamUseCaseUtil;
import androidx.camera.camera2.internal.SupportedSurfaceCombination;
import androidx.camera.camera2.internal.VideoStabilizationUtil;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.compat.workaround.ExtraSupportedSurfaceCombinationsContainer;
import androidx.camera.camera2.internal.compat.workaround.ResolutionCorrector;
import androidx.camera.camera2.internal.compat.workaround.TargetAspectRatio;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraMode;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceCombination;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.AspectRatioUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@OptIn(markerClass={ExperimentalCamera2Interop.class})
@RequiresApi(value=21)
@SuppressLint(value={"RestrictedApi"})
public final class a {
    public static final String z = "SupportedSurfaceCombination";
    public final List<SurfaceCombination> a;
    public final List<SurfaceCombination> b;
    public final List<SurfaceCombination> c;
    public final List<SurfaceCombination> d;
    public final Map<SupportedSurfaceCombination.FeatureSettings, List<SurfaceCombination>> e;
    public final List<SurfaceCombination> f;
    public final List<SurfaceCombination> g;
    public final List<SurfaceCombination> h;
    public final String i;
    public final CamcorderProfileHelper j;
    public final CameraCharacteristicsCompat k;
    public final ExtraSupportedSurfaceCombinationsContainer l;
    public final int m;
    public boolean n;
    public boolean o;
    public boolean p;
    public boolean q;
    public boolean r;
    public boolean s;
    @VisibleForTesting
    public SurfaceSizeDefinition t;
    public List<Integer> u;
    @NonNull
    public final DisplayInfoManager v;
    public final TargetAspectRatio w;
    public final ResolutionCorrector x;
    public final DynamicRangeResolver y;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public a(@NonNull Context context, @NonNull String cameraId, @NonNull CameraManagerCompat cameraManagerCompat, @NonNull CamcorderProfileHelper camcorderProfileHelper) throws CameraUnavailableException {
        DynamicRangeResolver dynamicRangeResolver;
        int n2;
        void var1_1;
        ExtraSupportedSurfaceCombinationsContainer extraSupportedSurfaceCombinationsContainer;
        void var4_5;
        ResolutionCorrector resolutionCorrector;
        TargetAspectRatio targetAspectRatio;
        TargetAspectRatio targetAspectRatio2;
        TargetAspectRatio targetAspectRatio3;
        TargetAspectRatio targetAspectRatio4;
        TargetAspectRatio targetAspectRatio5;
        HashMap hashMap;
        ArrayList<SurfaceCombination> arrayList;
        ArrayList<SurfaceCombination> arrayList2;
        ArrayList<SurfaceCombination> arrayList3;
        ArrayList<SurfaceCombination> arrayList4;
        Object object;
        void v0 = object;
        object = arrayList4;
        arrayList4 = new ArrayList<SurfaceCombination>();
        this.a = object;
        object = arrayList3;
        arrayList3 = new ArrayList<SurfaceCombination>();
        this.b = object;
        object = arrayList2;
        arrayList2 = new ArrayList<SurfaceCombination>();
        this.c = object;
        object = arrayList;
        arrayList = new ArrayList<SurfaceCombination>();
        this.d = object;
        object = hashMap;
        hashMap = new HashMap();
        this.e = object;
        object = targetAspectRatio5;
        targetAspectRatio5 = new ArrayList();
        this.f = object;
        object = targetAspectRatio4;
        targetAspectRatio4 = new ArrayList();
        this.g = object;
        object = targetAspectRatio3;
        targetAspectRatio3 = new ArrayList();
        this.h = object;
        this.n = false;
        this.o = false;
        this.p = false;
        this.q = false;
        this.r = false;
        this.s = false;
        object = targetAspectRatio2;
        targetAspectRatio2 = new ArrayList();
        this.u = object;
        object = targetAspectRatio;
        targetAspectRatio = new TargetAspectRatio();
        this.w = object;
        object = resolutionCorrector;
        resolutionCorrector = new ResolutionCorrector();
        this.x = object;
        object = (String)Preconditions.checkNotNull((Object)v0);
        this.i = object;
        this.j = (CamcorderProfileHelper)Preconditions.checkNotNull((Object)var4_5);
        Object object2 = extraSupportedSurfaceCombinationsContainer;
        extraSupportedSurfaceCombinationsContainer = new ExtraSupportedSurfaceCombinationsContainer();
        this.l = object2;
        object2 = DisplayInfoManager.getInstance((Context)var1_1);
        this.v = object2;
        try {
            object = cameraManagerCompat.getCameraCharacteristicsCompat((String)object);
        }
        catch (CameraAccessExceptionCompat cameraAccessExceptionCompat) {
            throw CameraUnavailableExceptionHelper.createFrom((CameraAccessExceptionCompat)cameraAccessExceptionCompat);
        }
        {
            this.k = object;
            object2 = (Integer)object.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            n2 = object2 != null ? (Integer)object2 : 2;
        }
        this.m = n2;
        int[] nArray = (int[])object.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        object = nArray;
        if (nArray != null) {
            for (TargetAspectRatio targetAspectRatio6 : object) {
                if (targetAspectRatio6 == 3) {
                    this.n = true;
                    continue;
                }
                if (targetAspectRatio6 == 6) {
                    this.o = true;
                    continue;
                }
                if (Build.VERSION.SDK_INT < 31 || targetAspectRatio6 != 16) continue;
                this.r = true;
            }
        }
        object = dynamicRangeResolver;
        dynamicRangeResolver = new DynamicRangeResolver(this.k);
        this.y = object;
        this.f();
        if (this.r) {
            this.i();
        }
        if (this.p = var1_1.getPackageManager().hasSystemFeature("android.hardware.camera.concurrent")) {
            this.c();
        }
        if (object.is10BitDynamicRangeSupported()) {
            this.b();
        }
        if (this.q = StreamUseCaseUtil.isStreamUseCaseSupported((CameraCharacteristicsCompat)this.k)) {
            this.e();
        }
        if (this.s = VideoStabilizationUtil.isPreviewStabilizationSupported((CameraCharacteristicsCompat)this.k)) {
            this.d();
        }
        this.g();
        this.a();
    }

    /*
     * WARNING - void declaration
     */
    public final List<SurfaceCombination> a(@NonNull SupportedSurfaceCombination.FeatureSettings featureSettings) {
        ArrayList<SurfaceCombination> arrayList;
        void var1_1;
        if (this.e.containsKey(var1_1)) {
            return this.e.get(var1_1);
        }
        List<SurfaceCombination> list = arrayList;
        arrayList = new ArrayList<SurfaceCombination>();
        if (var1_1.isUltraHdrOn()) {
            if (this.g.isEmpty()) {
                this.g.addAll(GuaranteedConfigurationsUtil.getUltraHdrSupportedCombinationList());
            }
            if (var1_1.getCameraMode() == 0) {
                ((ArrayList)list).addAll(this.g);
            }
        } else if (var1_1.getRequiredMaxBitDepth() == 8) {
            int n2 = var1_1.getCameraMode();
            if (n2 != 1) {
                if (n2 != 2) {
                    List<SurfaceCombination> list2 = var1_1.isPreviewStabilizationOn() ? this.d : this.a;
                    ((ArrayList)list).addAll(list2);
                } else {
                    ((ArrayList)list).addAll(this.b);
                    ((ArrayList)list).addAll(this.a);
                }
            } else {
                list = this.c;
            }
        } else if (var1_1.getRequiredMaxBitDepth() == 10 && var1_1.getCameraMode() == 0) {
            ((ArrayList)list).addAll(this.f);
        }
        this.e.put((SupportedSurfaceCombination.FeatureSettings)var1_1, list);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static int a(CameraCharacteristicsCompat characteristics, int imageFormat, Size size) {
        int n2 = 0;
        try {
            void var2_2;
            void var1_1;
            CameraCharacteristicsCompat cameraCharacteristicsCompat;
            n2 = (int)(1.0E9 / (double)((StreamConfigurationMap)cameraCharacteristicsCompat.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputMinFrameDuration((int)var1_1, (Size)var2_2));
        }
        catch (Exception exception) {}
        return n2;
    }

    public static int a(Range<Integer> range) {
        Range<Integer> range2;
        return (Integer)range.getUpper() - (Integer)range2.getLower() + 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int a(Range<Integer> firstRange, Range<Integer> secondRange) {
        Range<Integer> range;
        void var1_1;
        Preconditions.checkState((!firstRange.contains((Comparable)((Integer)var1_1.getUpper())) && !range.contains((Comparable)((Integer)var1_1.getLower())) ? 1 : 0) != 0, (String)"Ranges must not intersect");
        if ((Integer)range.getLower() > (Integer)var1_1.getUpper()) {
            return (Integer)range.getLower() - (Integer)var1_1.getUpper();
        }
        return (Integer)var1_1.getLower() - (Integer)range.getUpper();
    }

    /*
     * WARNING - void declaration
     */
    public static Range<Integer> a(Range<Integer> targetFps, Range<Integer> storedRange, Range<Integer> newRange) {
        double d2;
        void var2_2;
        Range<Integer> range;
        void var1_1;
        double d3 = androidx.camera.camera2.internal.a.a((Range<Integer>)var1_1.intersect(range));
        double d4 = androidx.camera.camera2.internal.a.a((Range<Integer>)newRange.intersect(range));
        double d5 = d3;
        double d6 = d4 / (double)androidx.camera.camera2.internal.a.a((Range<Integer>)var2_2);
        double d7 = d5 / (double)androidx.camera.camera2.internal.a.a((Range<Integer>)var1_1);
        if (d2 > d5) {
            if (d6 >= 0.5 || d6 >= d7) {
                return var2_2;
            }
        } else if (d4 == d3) {
            if (d6 > d7) {
                return var2_2;
            }
            if (d6 == d7 && (Integer)var2_2.getLower() > (Integer)var1_1.getLower()) {
                return var2_2;
            }
        } else if (d7 < 0.5 && d6 > d7) {
            return var2_2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Range<Integer> a(@Nullable Range<Integer> targetFrameRate, int maxFps) {
        block11: {
            void var2_3;
            Range range;
            Range<Integer> range2;
            void var1_1;
            if (targetFrameRate == null || var1_1.equals((Object)(range2 = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED))) break block11;
            Range[] rangeArray = (Range[])rangeArray.k.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            if (rangeArray == null) {
                return range2;
            }
            Range range3 = range;
            range = new Range((Comparable)Integer.valueOf(Math.min((Integer)var1_1.getLower(), (int)var2_3)), (Comparable)Integer.valueOf(Math.min((Integer)var1_1.getUpper(), (int)var2_3)));
            int n2 = 0;
            for (Range range4 : rangeArray) {
                block9: {
                    block10: {
                        if (var2_3 < (Integer)range4.getLower()) continue;
                        if (range2.equals((Object)StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
                            range2 = range4;
                        }
                        if (range4.equals((Object)range3)) {
                            range2 = range4;
                            break;
                        }
                        int n3 = androidx.camera.camera2.internal.a.a((Range<Integer>)range4.intersect(range3));
                        if (n2 == 0) {
                            n2 = n3;
                            break block9;
                        }
                        if (n3 < n2) break block10;
                        Range range5 = range3;
                        Range range6 = range5;
                        range2 = androidx.camera.camera2.internal.a.a((Range<Integer>)range5, range2, (Range<Integer>)range4);
                        try {
                            n2 = androidx.camera.camera2.internal.a.a((Range<Integer>)range6.intersect(range2));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (n2 != 0 || androidx.camera.camera2.internal.a.a((Range<Integer>)range4, (Range<Integer>)range3) >= androidx.camera.camera2.internal.a.a(range2, (Range<Integer>)range3) && (androidx.camera.camera2.internal.a.a((Range<Integer>)range4, (Range<Integer>)range3) != androidx.camera.camera2.internal.a.a(range2, (Range<Integer>)range3) || (Integer)range4.getLower() <= (Integer)range2.getUpper() && androidx.camera.camera2.internal.a.a((Range<Integer>)range4) >= androidx.camera.camera2.internal.a.a(range2))) continue;
                        }
                    }
                    range4 = range2;
                }
                range2 = range4;
            }
            return range2;
        }
        return StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
    }

    /*
     * WARNING - void declaration
     */
    public final Range<Integer> b(Range<Integer> newTargetFramerate, Range<Integer> storedTargetFramerate) {
        Range range;
        if (storedTargetFramerate != null) {
            void var2_2;
            if (range != null) {
                try {
                    range = var2_2.intersect(range);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            range = var2_2;
        }
        return range;
    }

    /*
     * WARNING - void declaration
     */
    public final int a(int currentMaxFps, int imageFormat, Size size) {
        void var3_3;
        void var2_2;
        return Math.min(currentMaxFps, androidx.camera.camera2.internal.a.a(this.k, (int)var2_2, (Size)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean a(@NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap) {
        void var1_1;
        Iterator iterator = attachedSurfaces.iterator();
        while (iterator.hasNext()) {
            if (((AttachedSurfaceInfo)iterator.next()).getImageFormat() != 4101) continue;
            return true;
        }
        iterator = var1_1.keySet().iterator();
        while (iterator.hasNext()) {
            if (((UseCaseConfig)iterator.next()).getInputFormat() != 4101) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final SupportedSurfaceCombination.FeatureSettings a(int cameraMode, @NonNull Map<UseCaseConfig<?>, DynamicRange> resolvedDynamicRanges, boolean isPreviewStabilizationOn, boolean isUltraHdrOn) {
        void var3_8;
        void var1_1;
        Object object;
        void var4_9;
        void var2_4;
        int n2 = androidx.camera.camera2.internal.a.a(var2_4);
        if (cameraMode != 0 && var4_9 != false) {
            object = ((a)object).i;
            String string = CameraMode.toLabelString((int)var1_1);
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            objectArray[1] = string;
            throw new IllegalArgumentException(String.format("Camera device id is %s. Ultra HDR is not currently supported in %s camera mode.", objectArray2));
        }
        if (var1_1 != false && n2 == 10) {
            object = ((a)object).i;
            String string = CameraMode.toLabelString((int)var1_1);
            Object[] objectArray = new Object[2];
            Object[] objectArray3 = objectArray;
            objectArray[0] = object;
            objectArray[1] = string;
            throw new IllegalArgumentException(String.format("Camera device id is %s. 10 bit dynamic range is not currently supported in %s camera mode.", objectArray3));
        }
        return SupportedSurfaceCombination.FeatureSettings.of((int)var1_1, (int)n2, (boolean)var3_8, (boolean)var4_9);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean a(@NonNull SupportedSurfaceCombination.FeatureSettings featureSettings, @NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap) {
        void var1_1;
        void var3_3;
        CompareSizesByArea compareSizesByArea;
        ArrayList<SurfaceConfig> arrayList;
        ArrayList<SurfaceConfig> arrayList2 = arrayList;
        arrayList = new ArrayList<SurfaceConfig>();
        CompareSizesByArea compareSizesByArea2 = attachedSurfaces.iterator();
        while (compareSizesByArea2.hasNext()) {
            arrayList2.add(compareSizesByArea2.next().getSurfaceConfig());
        }
        compareSizesByArea2 = compareSizesByArea;
        compareSizesByArea = new CompareSizesByArea();
        for (UseCaseConfig useCaseConfig : var3_3.keySet()) {
            List list = (List)var3_3.get(useCaseConfig);
            boolean bl = list != null && !list.isEmpty();
            UseCaseConfig useCaseConfig2 = useCaseConfig;
            Preconditions.checkArgument((boolean)bl, (Object)("No available output size is found for " + useCaseConfig + "."));
            useCaseConfig = (Size)Collections.min(list, compareSizesByArea2);
            int n2 = useCaseConfig2.getInputFormat();
            arrayList2.add(SurfaceConfig.transformSurfaceConfig((int)var1_1.getCameraMode(), (int)n2, (Size)useCaseConfig, (SurfaceSizeDefinition)this.b(n2)));
        }
        return this.a((SupportedSurfaceCombination.FeatureSettings)var1_1, arrayList2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Range<Integer> a(@NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull List<UseCaseConfig<?>> newUseCaseConfigs, @NonNull List<Integer> useCasesPriorityOrder) {
        Iterator iterator;
        Range<Integer> range = null;
        Iterator<AttachedSurfaceInfo> iterator2 = attachedSurfaces.iterator();
        while (iterator2.hasNext()) {
            range = this.b((Range<Integer>)iterator2.next().getTargetFrameRate(), range);
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            range = this.b((Range<Integer>)((UseCaseConfig)var2_2.get((Integer)iterator.next())).getTargetFrameRate(null), range);
        }
        return range;
    }

    public final int b(@NonNull List<AttachedSurfaceInfo> attachedSurfaces) {
        int n2 = Integer.MAX_VALUE;
        Iterator<AttachedSurfaceInfo> iterator = attachedSurfaces.iterator();
        while (iterator.hasNext()) {
            int n3 = n2;
            AttachedSurfaceInfo attachedSurfaceInfo = iterator.next();
            n2 = attachedSurfaceInfo.getImageFormat();
            Size size = attachedSurfaceInfo.getSize();
            n2 = Math.min(n3, androidx.camera.camera2.internal.a.a(this.k, n2, size));
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Map<UseCaseConfig<?>, List<Size>> a(@NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap, @NonNull SupportedSurfaceCombination.FeatureSettings featureSettings, @Nullable Range<Integer> targetFpsRange) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        for (UseCaseConfig<?> useCaseConfig : newUseCaseConfigsSupportedSizeMap.keySet()) {
            void var1_1;
            HashMap<SurfaceConfig.ConfigSize, Set> hashMap3;
            ArrayList<Size> arrayList;
            ArrayList<Size> arrayList2 = arrayList;
            arrayList = new ArrayList<Size>();
            HashMap<SurfaceConfig.ConfigSize, Set> hashMap4 = hashMap3;
            hashMap3 = new HashMap<SurfaceConfig.ConfigSize, Set>();
            for (Size size : (List)var1_1.get(useCaseConfig)) {
                Set set;
                void var3_3;
                void var2_2;
                int n2 = useCaseConfig.getInputFormat();
                SurfaceConfig.ConfigSize configSize = SurfaceConfig.transformSurfaceConfig((int)var2_2.getCameraMode(), (int)n2, (Size)size, (SurfaceSizeDefinition)this.b(n2)).getConfigSize();
                int n3 = Integer.MAX_VALUE;
                if (var3_3 != null) {
                    n3 = androidx.camera.camera2.internal.a.a(this.k, n2, size);
                }
                if ((set = (Set)hashMap4.get(configSize)) == null) {
                    HashSet hashSet;
                    set = hashSet;
                    hashSet = new HashSet();
                    hashMap4.put(configSize, set);
                }
                if (set.contains(n3)) continue;
                arrayList2.add(size);
                set.add(n3);
            }
            hashMap2.put(useCaseConfig, arrayList2);
        }
        return hashMap2;
    }

    /*
     * WARNING - void declaration
     */
    public final Pair<List<SurfaceConfig>, Integer> a(int cameraMode, List<AttachedSurfaceInfo> attachedSurfaces, List<Size> possibleSizeList, List<UseCaseConfig<?>> newUseCaseConfigs, List<Integer> useCasesPriorityOrder, int currentConfigFramerateCeiling, @Nullable Map<Integer, AttachedSurfaceInfo> surfaceConfigIndexAttachedSurfaceInfoMap, @Nullable Map<Integer, UseCaseConfig<?>> surfaceConfigIndexUseCaseConfigMap) {
        int n2;
        void var3_3;
        ArrayList<SurfaceConfig> arrayList;
        ArrayList<SurfaceConfig> arrayList2 = arrayList;
        arrayList = new ArrayList<SurfaceConfig>();
        for (AttachedSurfaceInfo attachedSurfaceInfo : attachedSurfaces) {
            void var7_7;
            arrayList2.add(attachedSurfaceInfo.getSurfaceConfig());
            if (var7_7 == null) continue;
            var7_7.put(arrayList2.size() - 1, attachedSurfaceInfo);
        }
        for (int i2 = 0; i2 < var3_3.size(); ++i2) {
            void var8_9;
            void var1_1;
            void var5_5;
            void var4_4;
            AttachedSurfaceInfo attachedSurfaceInfo;
            Size size = (Size)var3_3.get(i2);
            attachedSurfaceInfo = (UseCaseConfig)var4_4.get((Integer)var5_5.get(i2));
            int n3 = attachedSurfaceInfo.getInputFormat();
            SurfaceSizeDefinition surfaceSizeDefinition = this.b(n3);
            arrayList2.add(SurfaceConfig.transformSurfaceConfig((int)var1_1, (int)n3, (Size)size, (SurfaceSizeDefinition)surfaceSizeDefinition));
            if (var8_9 != null) {
                var8_9.put(arrayList2.size() - 1, attachedSurfaceInfo);
            }
            void v1 = n2;
            n2 = attachedSurfaceInfo.getInputFormat();
            n2 = Math.min((int)v1, androidx.camera.camera2.internal.a.a(this.k, n2, size));
        }
        return new Pair(arrayList2, (Object)n2);
    }

    public static int a(@NonNull Map<UseCaseConfig<?>, DynamicRange> resolvedDynamicRanges) {
        Iterator<DynamicRange> iterator = resolvedDynamicRanges.values().iterator();
        while (iterator.hasNext()) {
            if (((DynamicRange)iterator.next()).getBitDepth() != 10) continue;
            return 10;
        }
        return 8;
    }

    public static List<Integer> c(List<UseCaseConfig<?>> newUseCaseConfigs) {
        ArrayList arrayList;
        ArrayList<Integer> arrayList2;
        ArrayList<Integer> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<Integer>();
        Object object = arrayList;
        arrayList = new ArrayList();
        Iterator<UseCaseConfig<?>> iterator = newUseCaseConfigs.iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next().getSurfaceOccupancyPriority(0);
            if (((ArrayList)object).contains(n2)) continue;
            ((ArrayList)object).add(n2);
        }
        ArrayList arrayList4 = object;
        Collections.sort(arrayList4);
        Collections.reverse(arrayList4);
        object = arrayList4.iterator();
        while (object.hasNext()) {
            List<UseCaseConfig<?>> list;
            int n3 = (Integer)object.next();
            for (UseCaseConfig<?> useCaseConfig : list) {
                if (n3 != useCaseConfig.getSurfaceOccupancyPriority(0)) continue;
                arrayList3.add(list.indexOf(useCaseConfig));
            }
        }
        return arrayList3;
    }

    /*
     * WARNING - void declaration
     */
    public final List<List<Size>> a(List<List<Size>> supportedOutputSizesList) {
        int n2 = 1;
        Object object = supportedOutputSizesList.iterator();
        while (object.hasNext()) {
            n2 = object.next().size() * n2;
        }
        if (n2 != 0) {
            void var1_2;
            int n3;
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
            for (n3 = 0; n3 < n2; ++n3) {
                ArrayList arrayList2;
                ArrayList arrayList3 = arrayList2;
                arrayList2 = new ArrayList();
                ((ArrayList)object).add(arrayList3);
            }
            n3 = n2 / ((List)var1_2.get(0)).size();
            int n4 = n2;
            for (int i2 = 0; i2 < var1_2.size(); ++i2) {
                List list = (List)var1_2.get(i2);
                for (int i3 = 0; i3 < n2; ++i3) {
                    ((List)((ArrayList)object).get(i3)).add((Size)list.get(i3 % n4 / n3));
                }
                if (i2 < var1_2.size() - 1) {
                    n4 = n3 / ((List)var1_2.get(i2 + 1)).size();
                } else {
                    int n5 = n4;
                    n4 = n3;
                    n3 = n5;
                }
                int n6 = n3;
                n3 = n4;
                n4 = n6;
            }
            return object;
        }
        throw new IllegalArgumentException("Failed to find supported resolutions.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Size a(StreamConfigurationMap map, int imageFormat, boolean highResolutionIncluded) {
        block6: {
            this = null;
            if (imageFormat != 34) ** GOTO lbl-1000
            try {
                v0 = var1_1.getOutputSizes(SurfaceTexture.class);
            }
            catch (Throwable v1) {
                break block6;
            }
lbl8:
            // 2 sources

            while (true) {
                this = v0;
                break block6;
                break;
            }
lbl-1000:
            // 1 sources

            {
                v0 = var1_1.getOutputSizes((int)var2_2);
                ** continue;
            }
        }
        if (this == null) return null;
        if (((Size[])this).length == 0) {
            return null;
        }
        v2 = this;
        this = v3;
        v3 = new CompareSizesByArea();
        var4_4 = (Size)Collections.max(Arrays.asList(v2), this);
        var5_5 = SizeUtil.RESOLUTION_ZERO;
        if (Build.VERSION.SDK_INT >= 23 && var3_3 != false && (var1_1 = androidx.camera.camera2.internal.a$a.a((StreamConfigurationMap)var1_1, (int)var2_2)) != null && var1_1.length > 0) {
            var5_5 = Collections.max(Arrays.asList(var1_1), this);
        }
        return Collections.max(Arrays.asList(new Size[]{var4_4, var5_5}), this);
    }

    public final void f() {
        a a2 = this;
        a a3 = this;
        boolean bl = a3.n;
        a2.a.addAll(GuaranteedConfigurationsUtil.generateSupportedCombinationList((int)this.m, (boolean)bl, (boolean)a3.o));
        a2.a.addAll(this.l.get(this.i));
    }

    public final void i() {
        this.b.addAll(GuaranteedConfigurationsUtil.getUltraHighResolutionSupportedCombinationList());
    }

    public final void c() {
        this.c.addAll(GuaranteedConfigurationsUtil.getConcurrentSupportedCombinationList());
    }

    public final void b() {
        this.f.addAll(GuaranteedConfigurationsUtil.get10BitSupportedCombinationList());
    }

    public final void h() {
        this.g.addAll(GuaranteedConfigurationsUtil.getUltraHdrSupportedCombinationList());
    }

    public final void e() {
        if (Build.VERSION.SDK_INT >= 33) {
            this.h.addAll(GuaranteedConfigurationsUtil.getStreamUseCaseSupportedCombinationList());
        }
    }

    public final void d() {
        if (Build.VERSION.SDK_INT >= 33) {
            this.d.addAll(GuaranteedConfigurationsUtil.getPreviewStabilizationSupportedCombinationList());
        }
    }

    public final void a() {
    }

    public final void g() {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap hashMap3;
        Size size;
        a a2 = this_;
        a this_ = size;
        size = new Size(1280, 720);
        Size size2 = a2.k();
        HashMap hashMap4 = hashMap3;
        hashMap3 = new HashMap();
        HashMap hashMap5 = hashMap2;
        hashMap2 = new HashMap();
        HashMap hashMap6 = hashMap;
        hashMap = new HashMap();
        a2.t = SurfaceSizeDefinition.create((Size)SizeUtil.RESOLUTION_VGA, new HashMap(), (Size)this_, hashMap4, (Size)size2, hashMap5, hashMap6);
    }

    /*
     * WARNING - void declaration
     */
    public final void a(@NonNull Map<Integer, Size> sizeMap, @NonNull Size targetSize, int format) {
        void var1_1;
        Size size;
        void var3_3;
        if (!this_.p) {
            return;
        }
        a a2 = this_;
        a this_ = a2.a(a2.k.getStreamConfigurationMapCompat().toStreamConfigurationMap(), (int)var3_3, false);
        Integer n2 = (int)var3_3;
        if (this_ != null) {
            size = Collections.min(Arrays.asList(size, this_), new CompareSizesByArea());
        }
        var1_1.put(n2, size);
    }

    /*
     * WARNING - void declaration
     */
    public final void a(@NonNull Map<Integer, Size> sizeMap, int format) {
        void var2_2;
        a a2 = this_;
        a this_ = a2.a(a2.k.getStreamConfigurationMapCompat().toStreamConfigurationMap(), (int)var2_2, true);
        if (this_ != null) {
            void var1_1;
            var1_1.put((int)var2_2, this_);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void b(@NonNull Map<Integer, Size> sizeMap, int format) {
        if (Build.VERSION.SDK_INT >= 31 && ((a)((Object)n2)).r) {
            void var1_1;
            void var2_2;
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)((a)((Object)n2)).k.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP_MAXIMUM_RESOLUTION);
            if (streamConfigurationMap == null) {
                return;
            }
            a a2 = n2;
            Integer n2 = (int)var2_2;
            var1_1.put(n2, a2.a(streamConfigurationMap, (int)var2_2, true));
            return;
        }
    }

    public final void o() {
        a a2 = this_;
        a2.v.refresh();
        if (a2.t == null) {
            ((a)((Object)this_)).g();
        } else {
            Size size;
            a a3 = this_;
            Size size2 = size;
            size = new Size(1280, 720);
            Size size3 = size2;
            a a4 = this_;
            Map this_ = a4.t.getS1440pSizeMap();
            size2 = a4.t.getRecordSize();
            Map map = a4.t.getMaximumSizeMap();
            Map map2 = a4.t.getUltraMaximumSizeMap();
            a3.t = SurfaceSizeDefinition.create((Size)a3.t.getAnalysisSize(), (Map)((a)((Object)this_)).t.getS720pSizeMap(), (Size)size3, (Map)this_, (Size)size2, (Map)map, (Map)map2);
        }
    }

    @NonNull
    public final Size k() {
        try {
            a a2 = this;
            Size size = a2.a(Integer.parseInt(a2.i));
            if (size != null) {
                return size;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if ((this = this.l()) != null) {
            return this;
        }
        return SizeUtil.RESOLUTION_480P;
    }

    @Nullable
    public final Size l() {
        CompareSizesByArea compareSizesByArea;
        Size[] this_ = null;
        try {
            this_ = this_.k.getStreamConfigurationMapCompat().toStreamConfigurationMap().getOutputSizes(MediaRecorder.class);
        }
        catch (Throwable throwable) {}
        if (this_ == null) {
            return null;
        }
        CompareSizesByArea compareSizesByArea2 = compareSizesByArea;
        compareSizesByArea = new CompareSizesByArea(true);
        Arrays.sort(this_, compareSizesByArea2);
        for (Size size : this_) {
            Size size2 = SizeUtil.RESOLUTION_1080P;
            if (size.getWidth() > size2.getWidth() || size.getHeight() > size2.getHeight()) continue;
            return size;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Size a(int cameraId) {
        int n2 = 8;
        int[] nArray = new int[8];
        int[] nArray2 = nArray;
        nArray[0] = 1;
        nArray[1] = 13;
        nArray[2] = 10;
        nArray[3] = 8;
        nArray[4] = 12;
        nArray[5] = 6;
        nArray[6] = 5;
        nArray[7] = 4;
        for (int i2 = 0; i2 < n2; ++i2) {
            CamcorderProfile camcorderProfile;
            void var1_2;
            int n3 = nArray2[i2];
            if (!this.j.hasProfile((int)var1_2, n3) || (camcorderProfile = this.j.get((int)var1_2, n3)) == null) continue;
            CamcorderProfile camcorderProfile2 = camcorderProfile;
            int n4 = camcorderProfile2.videoFrameWidth;
            return new Size(n4, camcorderProfile2.videoFrameHeight);
        }
        return null;
    }

    public String j() {
        return this.i;
    }

    public boolean n() {
        return this.n;
    }

    public boolean m() {
        return this.o;
    }

    /*
     * WARNING - void declaration
     */
    public boolean a(@NonNull SupportedSurfaceCombination.FeatureSettings featureSettings, List<SurfaceConfig> surfaceConfigList) {
        void var2_3;
        Iterator<SurfaceCombination> iterator;
        boolean bl = false;
        iterator = this.a((SupportedSurfaceCombination.FeatureSettings)iterator).iterator();
        while (iterator.hasNext() && !(bl = iterator.next().getOrderedSupportedSurfaceConfigList((List)var2_3) != null)) {
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public List<SurfaceConfig> b(@NonNull SupportedSurfaceCombination.FeatureSettings featureSettings, List<SurfaceConfig> surfaceConfigList) {
        if (!StreamUseCaseUtil.shouldUseStreamUseCase((SupportedSurfaceCombination.FeatureSettings)featureSettings)) {
            return null;
        }
        Iterator<SurfaceCombination> iterator = ((a)((Object)iterator)).h.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            List list = ((SurfaceCombination)iterator.next()).getOrderedSupportedSurfaceConfigList((List)var2_2);
            if (list == null) continue;
            return list;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public SurfaceConfig b(int cameraMode, int imageFormat, Size size) {
        void var3_3;
        void var2_2;
        return SurfaceConfig.transformSurfaceConfig((int)cameraMode, (int)var2_2, (Size)var3_3, (SurfaceSizeDefinition)this.b((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Pair<Map<UseCaseConfig<?>, StreamSpec>, Map<AttachedSurfaceInfo, StreamSpec>> a(int cameraMode, @NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap, boolean isPreviewStabilizationOn, boolean hasVideoCapture) {
        void var4_8;
        void var1_1;
        void var2_4;
        Object object;
        ArrayList arrayList;
        this.o();
        ArrayList arrayList2 = arrayList;
        List<Integer> list = androidx.camera.camera2.internal.a.c(new ArrayList(object.keySet()));
        Map map = this.y.resolveAndValidateDynamicRanges((List)var2_4, arrayList2, list);
        boolean bl = androidx.camera.camera2.internal.a.a(attachedSurfaces, object);
        UseCaseConfig<?> useCaseConfig3 = this.a((int)var1_1, map, (boolean)var4_8, bl);
        bl = this.a((SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, (List<AttachedSurfaceInfo>)var2_4, (Map<UseCaseConfig<?>, List<Size>>)object);
        if (bl) {
            HashMap hashMap;
            HashMap hashMap2;
            HashMap hashMap3;
            HashMap hashMap4;
            Object object2;
            ArrayList<List<Size>> arrayList3;
            Range<Integer> range = this.a((List<AttachedSurfaceInfo>)var2_4, arrayList2, list);
            object = this.a((Map<UseCaseConfig<?>, List<Size>>)object, (SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, range);
            Cloneable cloneable = arrayList3;
            arrayList3 = new ArrayList<List<Size>>();
            Object object3 = list.iterator();
            while (object3.hasNext()) {
                UseCaseConfig<?> useCaseConfig2 = arrayList2.get(object3.next());
                object2 = (List)object.get(useCaseConfig2);
                int n2 = useCaseConfig2.getInputFormat();
                cloneable.add(this.a((List<Size>)object2, n2));
            }
            object = this.a((List<List<Size>>)((Object)cloneable));
            cloneable = hashMap4;
            hashMap4 = new HashMap();
            object3 = hashMap3;
            hashMap3 = new HashMap();
            object2 = hashMap2;
            hashMap2 = new HashMap();
            HashMap hashMap5 = hashMap;
            hashMap = new HashMap();
            List list2 = null;
            int n3 = Integer.MAX_VALUE;
            List list3 = null;
            int n4 = Integer.MAX_VALUE;
            boolean bl2 = StreamUseCaseUtil.containsZslUseCase((List)var2_4, arrayList2);
            List<SurfaceConfig> list4 = null;
            int n5 = this.b((List<AttachedSurfaceInfo>)var2_4);
            if (this.q && !bl2) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    list4 = (List<SurfaceConfig>)iterator.next();
                    list4 = (List)this.a((int)var1_1, (List<AttachedSurfaceInfo>)var2_4, (List<Size>)list4, arrayList2, list, (int)n5, (Map<Integer, AttachedSurfaceInfo>)object2, hashMap5).first;
                    if ((list4 = this.b((SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, list4)) != null && !StreamUseCaseUtil.areCaptureTypesEligible((Map)object2, hashMap5, list4)) {
                        list4 = null;
                    }
                    if (list4 != null) {
                        if (StreamUseCaseUtil.areStreamUseCasesAvailableForSurfaceConfigs((CameraCharacteristicsCompat)this.k, list4)) break;
                        list4 = null;
                    }
                    ((HashMap)object2).clear();
                    hashMap5.clear();
                }
                if (list4 == null && !bl) {
                    throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.i + ".  May be attempting to bind too many use cases. Existing surfaces: " + var2_4 + " New configs: " + arrayList2);
                }
            }
            boolean bl3 = false;
            bl = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                List list5 = (List)iterator.next();
                Pair<List<SurfaceConfig>, Integer> pair = this.a((int)var1_1, (List<AttachedSurfaceInfo>)var2_4, list5, arrayList2, list, n5, null, null);
                List list6 = (List)pair.first;
                int n6 = (Integer)pair.second;
                boolean bl4 = true;
                if (range != null && n5 > n6 && n6 < (Integer)range.getLower()) {
                    bl4 = false;
                }
                if (!bl3 && this.a((SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, list6)) {
                    if (n3 == Integer.MAX_VALUE || n3 < n6) {
                        list2 = list5;
                        n3 = n6;
                    }
                    if (bl4) {
                        bl3 = true;
                        if (bl) {
                            n3 = n6;
                            list2 = list5;
                            break;
                        }
                        list2 = list5;
                        n3 = n6;
                    }
                }
                if (list4 == null || bl || this.b((SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, list6) == null) continue;
                if (n4 == Integer.MAX_VALUE || n4 < n6) {
                    list3 = list5;
                    n4 = n6;
                }
                if (!bl4) continue;
                bl = true;
                if (bl3) {
                    list3 = list5;
                    n4 = n6;
                    break;
                }
                list3 = list5;
                n4 = n6;
            }
            if (list2 != null) {
                block23: {
                    Range<Integer> range2 = null;
                    if (range != null) {
                        range2 = this.a(range, n3);
                    }
                    for (UseCaseConfig<?> useCaseConfig3 : arrayList2) {
                        void var5_10;
                        StreamSpec.Builder builder = StreamSpec.builder((Size)((Size)list2.get(list.indexOf(arrayList2.indexOf(useCaseConfig3))))).setDynamicRange((DynamicRange)Preconditions.checkNotNull((Object)((DynamicRange)map.get(useCaseConfig3)))).setImplementationOptions((Config)StreamUseCaseUtil.getStreamSpecImplementationOptions(useCaseConfig3)).setZslDisabled((boolean)var5_10);
                        if (range2 != null) {
                            builder.setExpectedFrameRateRange(range2);
                        }
                        ((HashMap)object3).put(useCaseConfig3, builder.build());
                    }
                    if (list4 != null && n3 == n4 && list2.size() == list3.size()) {
                        for (int i2 = 0; i2 < list2.size(); ++i2) {
                            if (((Size)list2.get(i2)).equals(list3.get(i2))) {
                                continue;
                            }
                            break block23;
                        }
                        if (!StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithInteropOverride((CameraCharacteristicsCompat)this.k, (List)var2_4, (Map)object3, cloneable)) {
                            StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithSupportedSurfaceConfigs((Map)object3, cloneable, (Map)object2, hashMap5, list4);
                        }
                    }
                }
                return new Pair(object3, cloneable);
            }
            throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.i + " and Hardware level: " + this.m + ". May be the specified resolution is too large and not supported. Existing surfaces: " + var2_4 + " New configs: " + arrayList2);
        }
        throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.i + ".  May be attempting to bind too many use cases. Existing surfaces: " + var2_4 + " New configs: " + arrayList2);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NonNull
    public List<Size> a(@NonNull List<Size> sizeList, int imageFormat) {
        void var2_2;
        Object object;
        Object object2;
        a a2 = this;
        String string = a2.i;
        int n2 = this.w.get(string, a2.k);
        string = null;
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                string = null;
                break;
            }
            case 2: {
                Rational rational;
                string = this.b(256).getMaximumSize(256);
                object2 = rational;
                String string2 = string;
                int n3 = string2.getWidth();
                rational = new Rational(n3, string2.getHeight());
                string = object2;
                break;
            }
            case 1: {
                string = AspectRatioUtil.ASPECT_RATIO_16_9;
                break;
            }
            case 0: {
                string = AspectRatioUtil.ASPECT_RATIO_4_3;
            }
        }
        if (string != null) {
            ArrayList arrayList;
            ArrayList arrayList2;
            void v4 = object;
            object = arrayList2;
            arrayList2 = new ArrayList();
            object2 = arrayList;
            arrayList = new ArrayList();
            for (Size size : v4) {
                if (AspectRatioUtil.hasMatchingAspectRatio((Size)size, (Rational)string)) {
                    ((ArrayList)object).add(size);
                    continue;
                }
                ((ArrayList)object2).add(size);
            }
            ((ArrayList)object2).addAll(0, object);
            object = object2;
        }
        return this.x.insertOrPrioritize(SurfaceConfig.getConfigType((int)var2_2), object);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NonNull
    public SurfaceSizeDefinition b(int format) {
        void var1_1;
        if (!this.u.contains((int)var1_1)) {
            a a2 = this;
            a2.a(a2.t.getS720pSizeMap(), SizeUtil.RESOLUTION_720P, (int)var1_1);
            a2.a(a2.t.getS1440pSizeMap(), SizeUtil.RESOLUTION_1440P, (int)var1_1);
            a2.a(a2.t.getMaximumSizeMap(), (int)var1_1);
            a2.b(a2.t.getUltraMaximumSizeMap(), (int)var1_1);
            a2.u.add((int)var1_1);
        }
        return this.t;
    }

    @RequiresApi(value=23)
    public static class a {
        /*
         * WARNING - void declaration
         */
        public static Size[] a(StreamConfigurationMap streamConfigurationMap, int format) {
            void var1_1;
            return streamConfigurationMap.getHighResolutionOutputSizes((int)var1_1);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface b {
    }
}

