/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Build;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.DynamicRangeResolver;
import androidx.camera.camera2.internal.GuaranteedConfigurationsUtil;
import androidx.camera.camera2.internal.StreamUseCaseUtil;
import androidx.camera.camera2.internal.SupportedSurfaceCombination;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.compat.workaround.ExtraSupportedSurfaceCombinationsContainer;
import androidx.camera.camera2.internal.compat.workaround.ResolutionCorrector;
import androidx.camera.camera2.internal.compat.workaround.TargetAspectRatio;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraMode;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceCombination;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.AspectRatioUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@OptIn(markerClass={ExperimentalCamera2Interop.class})
@RequiresApi(value=21)
@SuppressLint(value={"RestrictedApi"})
public final class a {
    public static final String w = "SupportedSurfaceCombination";
    public final List<SurfaceCombination> a;
    public final List<SurfaceCombination> b;
    public final List<SurfaceCombination> c;
    public final Map<SupportedSurfaceCombination.FeatureSettings, List<SurfaceCombination>> d;
    public final List<SurfaceCombination> e;
    public final List<SurfaceCombination> f;
    public final String g;
    public final CamcorderProfileHelper h;
    public final CameraCharacteristicsCompat i;
    public final ExtraSupportedSurfaceCombinationsContainer j;
    public final int k;
    public boolean l;
    public boolean m;
    public boolean n;
    public boolean o;
    public boolean p;
    @VisibleForTesting
    public SurfaceSizeDefinition q;
    public List<Integer> r;
    @NonNull
    public final DisplayInfoManager s;
    public final TargetAspectRatio t;
    public final ResolutionCorrector u;
    public final DynamicRangeResolver v;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public a(@NonNull Context context, @NonNull String cameraId, @NonNull CameraManagerCompat cameraManagerCompat, @NonNull CamcorderProfileHelper camcorderProfileHelper) throws CameraUnavailableException {
        DynamicRangeResolver dynamicRangeResolver;
        int n2;
        void var1_1;
        ExtraSupportedSurfaceCombinationsContainer extraSupportedSurfaceCombinationsContainer;
        void var4_5;
        ResolutionCorrector resolutionCorrector;
        TargetAspectRatio targetAspectRatio;
        TargetAspectRatio targetAspectRatio2;
        TargetAspectRatio targetAspectRatio3;
        TargetAspectRatio targetAspectRatio4;
        HashMap hashMap;
        ArrayList<SurfaceCombination> arrayList;
        ArrayList<SurfaceCombination> arrayList2;
        ArrayList<SurfaceCombination> arrayList3;
        Object object;
        void v0 = object;
        object = arrayList3;
        arrayList3 = new ArrayList<SurfaceCombination>();
        this.a = object;
        object = arrayList2;
        arrayList2 = new ArrayList<SurfaceCombination>();
        this.b = object;
        object = arrayList;
        arrayList = new ArrayList<SurfaceCombination>();
        this.c = object;
        object = hashMap;
        hashMap = new HashMap();
        this.d = object;
        object = targetAspectRatio4;
        targetAspectRatio4 = new ArrayList();
        this.e = object;
        object = targetAspectRatio3;
        targetAspectRatio3 = new ArrayList();
        this.f = object;
        this.l = false;
        this.m = false;
        this.n = false;
        this.o = false;
        this.p = false;
        object = targetAspectRatio2;
        targetAspectRatio2 = new ArrayList();
        this.r = object;
        object = targetAspectRatio;
        targetAspectRatio = new TargetAspectRatio();
        this.t = object;
        object = resolutionCorrector;
        resolutionCorrector = new ResolutionCorrector();
        this.u = object;
        object = (String)Preconditions.checkNotNull((Object)v0);
        this.g = object;
        this.h = (CamcorderProfileHelper)Preconditions.checkNotNull((Object)var4_5);
        Object object2 = extraSupportedSurfaceCombinationsContainer;
        extraSupportedSurfaceCombinationsContainer = new ExtraSupportedSurfaceCombinationsContainer();
        this.j = object2;
        object2 = DisplayInfoManager.getInstance((Context)var1_1);
        this.s = object2;
        try {
            object = cameraManagerCompat.getCameraCharacteristicsCompat((String)object);
        }
        catch (CameraAccessExceptionCompat cameraAccessExceptionCompat) {
            throw CameraUnavailableExceptionHelper.createFrom((CameraAccessExceptionCompat)cameraAccessExceptionCompat);
        }
        {
            this.i = object;
            object2 = (Integer)object.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            n2 = object2 != null ? (Integer)object2 : 2;
        }
        this.k = n2;
        int[] nArray = (int[])object.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        object = nArray;
        if (nArray != null) {
            for (TargetAspectRatio targetAspectRatio5 : object) {
                if (targetAspectRatio5 == 3) {
                    this.l = true;
                    continue;
                }
                if (targetAspectRatio5 == 6) {
                    this.m = true;
                    continue;
                }
                if (Build.VERSION.SDK_INT < 31 || targetAspectRatio5 != 16) continue;
                this.p = true;
            }
        }
        object = dynamicRangeResolver;
        dynamicRangeResolver = new DynamicRangeResolver(this.i);
        this.v = object;
        this.e();
        if (this.p) {
            this.g();
        }
        if (this.n = var1_1.getPackageManager().hasSystemFeature("android.hardware.camera.concurrent")) {
            this.c();
        }
        if (object.is10BitDynamicRangeSupported()) {
            this.b();
        }
        if (this.o = StreamUseCaseUtil.isStreamUseCaseSupported((CameraCharacteristicsCompat)this.i)) {
            this.d();
        }
        this.f();
        this.a();
    }

    /*
     * WARNING - void declaration
     */
    public final List<SurfaceCombination> a(@NonNull SupportedSurfaceCombination.FeatureSettings featureSettings) {
        ArrayList<SurfaceCombination> arrayList;
        void var1_1;
        if (this.d.containsKey(var1_1)) {
            return this.d.get(var1_1);
        }
        List<SurfaceCombination> list = arrayList;
        arrayList = new ArrayList<SurfaceCombination>();
        if (var1_1.getRequiredMaxBitDepth() == 8) {
            int n2 = var1_1.getCameraMode();
            if (n2 != 1) {
                if (n2 != 2) {
                    ((ArrayList)list).addAll(this.a);
                } else {
                    ((ArrayList)list).addAll(this.b);
                    ((ArrayList)list).addAll(this.a);
                }
            } else {
                list = this.c;
            }
        } else if (var1_1.getRequiredMaxBitDepth() == 10 && var1_1.getCameraMode() == 0) {
            ((ArrayList)list).addAll(this.e);
        }
        this.d.put((SupportedSurfaceCombination.FeatureSettings)var1_1, list);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static int a(CameraCharacteristicsCompat characteristics, int imageFormat, Size size) {
        int n2 = 0;
        try {
            void var2_2;
            void var1_1;
            CameraCharacteristicsCompat cameraCharacteristicsCompat;
            n2 = (int)(1.0E9 / (double)((StreamConfigurationMap)cameraCharacteristicsCompat.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputMinFrameDuration((int)var1_1, (Size)var2_2));
        }
        catch (Exception exception) {}
        return n2;
    }

    public static int a(Range<Integer> range) {
        Range<Integer> range2;
        return (Integer)range.getUpper() - (Integer)range2.getLower() + 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int a(Range<Integer> firstRange, Range<Integer> secondRange) {
        Range<Integer> range;
        void var1_1;
        Preconditions.checkState((!firstRange.contains((Comparable)((Integer)var1_1.getUpper())) && !range.contains((Comparable)((Integer)var1_1.getLower())) ? 1 : 0) != 0, (String)"Ranges must not intersect");
        if ((Integer)range.getLower() > (Integer)var1_1.getUpper()) {
            return (Integer)range.getLower() - (Integer)var1_1.getUpper();
        }
        return (Integer)var1_1.getLower() - (Integer)range.getUpper();
    }

    /*
     * WARNING - void declaration
     */
    public static Range<Integer> a(Range<Integer> targetFps, Range<Integer> storedRange, Range<Integer> newRange) {
        double d2;
        void var2_2;
        Range<Integer> range;
        void var1_1;
        double d3 = androidx.camera.camera2.internal.a.a((Range<Integer>)var1_1.intersect(range));
        double d4 = androidx.camera.camera2.internal.a.a((Range<Integer>)newRange.intersect(range));
        double d5 = d3;
        double d6 = d4 / (double)androidx.camera.camera2.internal.a.a((Range<Integer>)var2_2);
        double d7 = d5 / (double)androidx.camera.camera2.internal.a.a((Range<Integer>)var1_1);
        if (d2 > d5) {
            if (d6 >= 0.5 || d6 >= d7) {
                return var2_2;
            }
        } else if (d4 == d3) {
            if (d6 > d7) {
                return var2_2;
            }
            if (d6 == d7 && (Integer)var2_2.getLower() > (Integer)var1_1.getLower()) {
                return var2_2;
            }
        } else if (d7 < 0.5 && d6 > d7) {
            return var2_2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Range<Integer> a(Range<Integer> targetFrameRate, int maxFps) {
        void var2_2;
        Range<Integer> range;
        Range range2;
        if (targetFrameRate == null) {
            return StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
        }
        Range[] rangeArray = (Range[])rangeArray.i.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        if (rangeArray == null) {
            return StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
        }
        Range range3 = range2;
        range2 = new Range((Comparable)Integer.valueOf(Math.min((Integer)range.getLower(), (int)var2_2)), (Comparable)Integer.valueOf(Math.min((Integer)range.getUpper(), (int)var2_2)));
        range = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
        int n2 = 0;
        for (Range range4 : rangeArray) {
            block10: {
                block11: {
                    if (var2_2 < (Integer)range4.getLower()) continue;
                    if (range.equals((Object)StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
                        range = range4;
                    }
                    if (range4.equals((Object)range3)) {
                        range = range4;
                        break;
                    }
                    int n3 = androidx.camera.camera2.internal.a.a((Range<Integer>)range4.intersect(range3));
                    if (n2 == 0) {
                        n2 = n3;
                        break block10;
                    }
                    if (n3 < n2) break block11;
                    Range range5 = range3;
                    Range range6 = range5;
                    range = androidx.camera.camera2.internal.a.a((Range<Integer>)range5, range, (Range<Integer>)range4);
                    try {
                        n2 = androidx.camera.camera2.internal.a.a((Range<Integer>)range6.intersect(range));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (n2 != 0 || androidx.camera.camera2.internal.a.a((Range<Integer>)range4, (Range<Integer>)range3) >= androidx.camera.camera2.internal.a.a(range, (Range<Integer>)range3) && (androidx.camera.camera2.internal.a.a((Range<Integer>)range4, (Range<Integer>)range3) != androidx.camera.camera2.internal.a.a(range, (Range<Integer>)range3) || (Integer)range4.getLower() <= (Integer)range.getUpper() && androidx.camera.camera2.internal.a.a((Range<Integer>)range4) >= androidx.camera.camera2.internal.a.a(range))) continue;
                    }
                }
                range4 = range;
            }
            range = range4;
        }
        return range;
    }

    /*
     * WARNING - void declaration
     */
    public final Range<Integer> b(Range<Integer> newTargetFramerate, Range<Integer> storedTargetFramerate) {
        Range range;
        if (storedTargetFramerate != null) {
            void var2_2;
            if (range != null) {
                try {
                    range = var2_2.intersect(range);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            range = var2_2;
        }
        return range;
    }

    /*
     * WARNING - void declaration
     */
    public final int a(int currentMaxFps, int imageFormat, Size size) {
        void var3_3;
        void var2_2;
        return Math.min(currentMaxFps, androidx.camera.camera2.internal.a.a(this.i, (int)var2_2, (Size)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final SupportedSurfaceCombination.FeatureSettings a(int cameraMode, @NonNull Map<UseCaseConfig<?>, DynamicRange> resolvedDynamicRanges) {
        void var1_1;
        void var2_3;
        int n2 = androidx.camera.camera2.internal.a.a(var2_3);
        if (cameraMode != 0 && n2 == 10) {
            String string = ((a)((Object)string)).g;
            String string2 = CameraMode.toLabelString((int)var1_1);
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = string2;
            throw new IllegalArgumentException(String.format("Camera device id is %s. 10 bit dynamic range is not currently supported in %s camera mode.", objectArray2));
        }
        return SupportedSurfaceCombination.FeatureSettings.of((int)var1_1, (int)n2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean a(@NonNull SupportedSurfaceCombination.FeatureSettings featureSettings, @NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap) {
        void var1_1;
        void var3_3;
        CompareSizesByArea compareSizesByArea;
        ArrayList<SurfaceConfig> arrayList;
        ArrayList<SurfaceConfig> arrayList2 = arrayList;
        arrayList = new ArrayList<SurfaceConfig>();
        CompareSizesByArea compareSizesByArea2 = attachedSurfaces.iterator();
        while (compareSizesByArea2.hasNext()) {
            arrayList2.add(compareSizesByArea2.next().getSurfaceConfig());
        }
        compareSizesByArea2 = compareSizesByArea;
        compareSizesByArea = new CompareSizesByArea();
        for (UseCaseConfig useCaseConfig : var3_3.keySet()) {
            List list = (List)var3_3.get(useCaseConfig);
            boolean bl = list != null && !list.isEmpty();
            UseCaseConfig useCaseConfig2 = useCaseConfig;
            Preconditions.checkArgument((boolean)bl, (Object)("No available output size is found for " + useCaseConfig + "."));
            useCaseConfig = (Size)Collections.min(list, compareSizesByArea2);
            int n2 = useCaseConfig2.getInputFormat();
            arrayList2.add(SurfaceConfig.transformSurfaceConfig((int)var1_1.getCameraMode(), (int)n2, (Size)useCaseConfig, (SurfaceSizeDefinition)this.b(n2)));
        }
        return this.a((SupportedSurfaceCombination.FeatureSettings)var1_1, arrayList2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Range<Integer> a(@NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull List<UseCaseConfig<?>> newUseCaseConfigs, @NonNull List<Integer> useCasesPriorityOrder) {
        Iterator iterator;
        Range<Integer> range = null;
        Iterator<AttachedSurfaceInfo> iterator2 = attachedSurfaces.iterator();
        while (iterator2.hasNext()) {
            range = this.b((Range<Integer>)iterator2.next().getTargetFrameRate(), range);
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            range = this.b((Range<Integer>)((UseCaseConfig)var2_2.get((Integer)iterator.next())).getTargetFrameRate(null), range);
        }
        return range;
    }

    public final int b(@NonNull List<AttachedSurfaceInfo> attachedSurfaces) {
        int n2 = Integer.MAX_VALUE;
        Iterator<AttachedSurfaceInfo> iterator = attachedSurfaces.iterator();
        while (iterator.hasNext()) {
            int n3 = n2;
            AttachedSurfaceInfo attachedSurfaceInfo = iterator.next();
            n2 = attachedSurfaceInfo.getImageFormat();
            Size size = attachedSurfaceInfo.getSize();
            n2 = Math.min(n3, androidx.camera.camera2.internal.a.a(this.i, n2, size));
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Map<UseCaseConfig<?>, List<Size>> a(@NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap, @NonNull SupportedSurfaceCombination.FeatureSettings featureSettings, @Nullable Range<Integer> targetFpsRange) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        for (UseCaseConfig<?> useCaseConfig : newUseCaseConfigsSupportedSizeMap.keySet()) {
            void var1_1;
            HashMap<SurfaceConfig.ConfigSize, Set> hashMap3;
            ArrayList<Size> arrayList;
            ArrayList<Size> arrayList2 = arrayList;
            arrayList = new ArrayList<Size>();
            HashMap<SurfaceConfig.ConfigSize, Set> hashMap4 = hashMap3;
            hashMap3 = new HashMap<SurfaceConfig.ConfigSize, Set>();
            for (Size size : (List)var1_1.get(useCaseConfig)) {
                Set set;
                void var3_3;
                void var2_2;
                int n2 = useCaseConfig.getInputFormat();
                SurfaceConfig.ConfigSize configSize = SurfaceConfig.transformSurfaceConfig((int)var2_2.getCameraMode(), (int)n2, (Size)size, (SurfaceSizeDefinition)this.b(n2)).getConfigSize();
                int n3 = Integer.MAX_VALUE;
                if (var3_3 != null) {
                    n3 = androidx.camera.camera2.internal.a.a(this.i, n2, size);
                }
                if ((set = (Set)hashMap4.get(configSize)) == null) {
                    HashSet hashSet;
                    set = hashSet;
                    hashSet = new HashSet();
                    hashMap4.put(configSize, set);
                }
                if (set.contains(n3)) continue;
                arrayList2.add(size);
                set.add(n3);
            }
            hashMap2.put(useCaseConfig, arrayList2);
        }
        return hashMap2;
    }

    /*
     * WARNING - void declaration
     */
    public final Pair<List<SurfaceConfig>, Integer> a(int cameraMode, List<AttachedSurfaceInfo> attachedSurfaces, List<Size> possibleSizeList, List<UseCaseConfig<?>> newUseCaseConfigs, List<Integer> useCasesPriorityOrder, int currentConfigFramerateCeiling, @Nullable Map<Integer, AttachedSurfaceInfo> surfaceConfigIndexAttachedSurfaceInfoMap, @Nullable Map<Integer, UseCaseConfig<?>> surfaceConfigIndexUseCaseConfigMap) {
        int n2;
        void var3_3;
        ArrayList<SurfaceConfig> arrayList;
        ArrayList<SurfaceConfig> arrayList2 = arrayList;
        arrayList = new ArrayList<SurfaceConfig>();
        for (AttachedSurfaceInfo attachedSurfaceInfo : attachedSurfaces) {
            void var7_7;
            arrayList2.add(attachedSurfaceInfo.getSurfaceConfig());
            if (var7_7 == null) continue;
            var7_7.put(arrayList2.size() - 1, attachedSurfaceInfo);
        }
        for (int i2 = 0; i2 < var3_3.size(); ++i2) {
            void var8_9;
            void var1_1;
            void var5_5;
            void var4_4;
            AttachedSurfaceInfo attachedSurfaceInfo;
            Size size = (Size)var3_3.get(i2);
            attachedSurfaceInfo = (UseCaseConfig)var4_4.get((Integer)var5_5.get(i2));
            int n3 = attachedSurfaceInfo.getInputFormat();
            SurfaceSizeDefinition surfaceSizeDefinition = this.b(n3);
            arrayList2.add(SurfaceConfig.transformSurfaceConfig((int)var1_1, (int)n3, (Size)size, (SurfaceSizeDefinition)surfaceSizeDefinition));
            if (var8_9 != null) {
                var8_9.put(arrayList2.size() - 1, attachedSurfaceInfo);
            }
            void v1 = n2;
            n2 = attachedSurfaceInfo.getInputFormat();
            n2 = Math.min((int)v1, androidx.camera.camera2.internal.a.a(this.i, n2, size));
        }
        return new Pair(arrayList2, (Object)n2);
    }

    public static int a(@NonNull Map<UseCaseConfig<?>, DynamicRange> resolvedDynamicRanges) {
        Iterator<DynamicRange> iterator = resolvedDynamicRanges.values().iterator();
        while (iterator.hasNext()) {
            if (((DynamicRange)iterator.next()).getBitDepth() != 10) continue;
            return 10;
        }
        return 8;
    }

    /*
     * WARNING - void declaration
     */
    public final List<Integer> c(List<UseCaseConfig<?>> newUseCaseConfigs) {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3 = arrayList2;
        arrayList2 = new ArrayList();
        Object object = arrayList;
        arrayList = new ArrayList();
        Iterator<UseCaseConfig<?>> iterator = newUseCaseConfigs.iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next().getSurfaceOccupancyPriority(0);
            if (((ArrayList)object).contains(n2)) continue;
            ((ArrayList)object).add(n2);
        }
        ArrayList arrayList4 = object;
        Collections.sort(arrayList4);
        Collections.reverse(arrayList4);
        object = arrayList4.iterator();
        while (object.hasNext()) {
            void var1_1;
            int n3 = (Integer)object.next();
            for (UseCaseConfig useCaseConfig : var1_1) {
                if (n3 != useCaseConfig.getSurfaceOccupancyPriority(0)) continue;
                arrayList3.add(var1_1.indexOf(useCaseConfig));
            }
        }
        return arrayList3;
    }

    /*
     * WARNING - void declaration
     */
    public final List<List<Size>> a(List<List<Size>> supportedOutputSizesList) {
        int n2 = 1;
        Object object = supportedOutputSizesList.iterator();
        while (object.hasNext()) {
            n2 = object.next().size() * n2;
        }
        if (n2 != 0) {
            void var1_2;
            int n3;
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
            for (n3 = 0; n3 < n2; ++n3) {
                ArrayList arrayList2;
                ArrayList arrayList3 = arrayList2;
                arrayList2 = new ArrayList();
                ((ArrayList)object).add(arrayList3);
            }
            n3 = n2 / ((List)var1_2.get(0)).size();
            int n4 = n2;
            for (int i2 = 0; i2 < var1_2.size(); ++i2) {
                List list = (List)var1_2.get(i2);
                for (int i3 = 0; i3 < n2; ++i3) {
                    ((List)((ArrayList)object).get(i3)).add((Size)list.get(i3 % n4 / n3));
                }
                if (i2 < var1_2.size() - 1) {
                    n4 = n3 / ((List)var1_2.get(i2 + 1)).size();
                } else {
                    int n5 = n4;
                    n4 = n3;
                    n3 = n5;
                }
                int n6 = n3;
                n3 = n4;
                n4 = n6;
            }
            return object;
        }
        throw new IllegalArgumentException("Failed to find supported resolutions.");
    }

    /*
     * WARNING - void declaration
     */
    public final Size a(StreamConfigurationMap map, int imageFormat, boolean highResolutionIncluded) {
        void var2_2;
        Size[] sizeArray;
        Object object = imageFormat == 34 ? sizeArray.getOutputSizes(SurfaceTexture.class) : sizeArray.getOutputSizes((int)var2_2);
        if (object != null && ((Size[])object).length != 0) {
            void var3_3;
            CompareSizesByArea compareSizesByArea;
            CompareSizesByArea compareSizesByArea2 = object;
            object = compareSizesByArea;
            compareSizesByArea = new CompareSizesByArea();
            Size size = (Size)Collections.max(Arrays.asList(compareSizesByArea2), object);
            Size size2 = SizeUtil.RESOLUTION_ZERO;
            if (Build.VERSION.SDK_INT >= 23 && var3_3 != false && (sizeArray = SupportedSurfaceCombination.Api23Impl.getHighResolutionOutputSizes((StreamConfigurationMap)sizeArray, (int)var2_2)) != null && sizeArray.length > 0) {
                size2 = Collections.max(Arrays.asList(sizeArray), object);
            }
            return Collections.max(Arrays.asList(size, size2), object);
        }
        return null;
    }

    public final void e() {
        a a2 = this_;
        a a3 = this_;
        boolean bl = a3.l;
        a2.a.addAll(GuaranteedConfigurationsUtil.generateSupportedCombinationList((int)((a)((Object)this_)).k, (boolean)bl, (boolean)a3.m));
        a a4 = this_;
        String this_ = a4.g;
        a2.a.addAll(((a)((Object)this_)).j.get(this_, a4.k));
    }

    public final void g() {
        this.b.addAll(GuaranteedConfigurationsUtil.getUltraHighResolutionSupportedCombinationList());
    }

    public final void c() {
        this.c.addAll(GuaranteedConfigurationsUtil.getConcurrentSupportedCombinationList());
    }

    public final void b() {
        this.e.addAll(GuaranteedConfigurationsUtil.get10BitSupportedCombinationList());
    }

    public final void d() {
        if (Build.VERSION.SDK_INT >= 33) {
            this.f.addAll(GuaranteedConfigurationsUtil.getStreamUseCaseSupportedCombinationList());
        }
    }

    public final void a() {
    }

    public final void f() {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap hashMap3;
        Size size;
        a a2 = this_;
        a this_ = size;
        size = new Size(1920, 1080);
        Size size2 = a2.i();
        HashMap hashMap4 = hashMap3;
        hashMap3 = new HashMap();
        HashMap hashMap5 = hashMap2;
        hashMap2 = new HashMap();
        HashMap hashMap6 = hashMap;
        hashMap = new HashMap();
        a2.q = SurfaceSizeDefinition.create((Size)SizeUtil.RESOLUTION_VGA, new HashMap(), (Size)this_, hashMap4, (Size)size2, hashMap5, hashMap6);
    }

    /*
     * WARNING - void declaration
     */
    public final void a(@NonNull Map<Integer, Size> sizeMap, @NonNull Size targetSize, int format) {
        void var1_1;
        Size size;
        void var3_3;
        if (!this_.n) {
            return;
        }
        a a2 = this_;
        a this_ = a2.a(a2.i.getStreamConfigurationMapCompat().toStreamConfigurationMap(), (int)var3_3, false);
        Integer n2 = (int)var3_3;
        if (this_ != null) {
            size = Collections.min(Arrays.asList(size, this_), new CompareSizesByArea());
        }
        var1_1.put(n2, size);
    }

    /*
     * WARNING - void declaration
     */
    public final void a(@NonNull Map<Integer, Size> sizeMap, int format) {
        void var2_2;
        a a2 = this_;
        a this_ = a2.a(a2.i.getStreamConfigurationMapCompat().toStreamConfigurationMap(), (int)var2_2, true);
        if (this_ != null) {
            void var1_1;
            var1_1.put((int)var2_2, this_);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void b(@NonNull Map<Integer, Size> sizeMap, int format) {
        if (Build.VERSION.SDK_INT >= 31 && ((a)((Object)n2)).p) {
            void var1_1;
            void var2_2;
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)((a)((Object)n2)).i.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP_MAXIMUM_RESOLUTION);
            if (streamConfigurationMap == null) {
                return;
            }
            a a2 = n2;
            Integer n2 = (int)var2_2;
            var1_1.put(n2, a2.a(streamConfigurationMap, (int)var2_2, true));
            return;
        }
    }

    public final void m() {
        a a2 = this_;
        a2.s.refresh();
        if (a2.q == null) {
            ((a)((Object)this_)).f();
        } else {
            Size size;
            a a3 = this_;
            Size size2 = size;
            size = new Size(1920, 1080);
            Size size3 = size2;
            a a4 = this_;
            Map this_ = a4.q.getS1440pSizeMap();
            size2 = a4.q.getRecordSize();
            Map map = a4.q.getMaximumSizeMap();
            Map map2 = a4.q.getUltraMaximumSizeMap();
            a3.q = SurfaceSizeDefinition.create((Size)a3.q.getAnalysisSize(), (Map)((a)((Object)this_)).q.getS720pSizeMap(), (Size)size3, (Map)this_, (Size)size2, (Map)map, (Map)map2);
        }
    }

    @NonNull
    public final Size i() {
        CamcorderProfile camcorderProfile;
        int n2;
        block3: {
            try {
                a a2 = this;
                n2 = Integer.parseInt(a2.g);
                camcorderProfile = null;
                if (!a2.h.hasProfile(n2, 1)) break block3;
            }
            catch (NumberFormatException numberFormatException) {
                return this.j();
            }
            camcorderProfile = this.h.get(n2, 1);
        }
        if (camcorderProfile != null) {
            CamcorderProfile camcorderProfile2 = camcorderProfile;
            int n3 = camcorderProfile2.videoFrameWidth;
            return new Size(n3, camcorderProfile2.videoFrameHeight);
        }
        return this.a(n2);
    }

    @NonNull
    public final Size j() {
        CompareSizesByArea compareSizesByArea;
        Size[] this_ = this_.i.getStreamConfigurationMapCompat().toStreamConfigurationMap().getOutputSizes(MediaRecorder.class);
        if (this_ == null) {
            return SizeUtil.RESOLUTION_480P;
        }
        CompareSizesByArea compareSizesByArea2 = compareSizesByArea;
        compareSizesByArea = new CompareSizesByArea(true);
        Arrays.sort(this_, compareSizesByArea2);
        for (Size size : this_) {
            Size size2 = SizeUtil.RESOLUTION_1080P;
            if (size.getWidth() > size2.getWidth() || size.getHeight() > size2.getHeight()) continue;
            return size;
        }
        return SizeUtil.RESOLUTION_480P;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Size a(int cameraId) {
        void var1_2;
        Size size = SizeUtil.RESOLUTION_480P;
        CamcorderProfile camcorderProfile = null;
        if (this.h.hasProfile((int)var1_2, 10)) {
            camcorderProfile = this.h.get((int)var1_2, 10);
        } else if (this.h.hasProfile((int)var1_2, 8)) {
            camcorderProfile = this.h.get((int)var1_2, 8);
        } else if (this.h.hasProfile((int)var1_2, 12)) {
            camcorderProfile = this.h.get((int)var1_2, 12);
        } else if (this.h.hasProfile((int)var1_2, 6)) {
            camcorderProfile = this.h.get((int)var1_2, 6);
        } else if (this.h.hasProfile((int)var1_2, 5)) {
            camcorderProfile = this.h.get((int)var1_2, 5);
        } else if (this.h.hasProfile((int)var1_2, 4)) {
            camcorderProfile = this.h.get((int)var1_2, 4);
        }
        if (camcorderProfile != null) {
            Size size2;
            size = size2;
            CamcorderProfile camcorderProfile2 = camcorderProfile;
            int n2 = camcorderProfile2.videoFrameWidth;
            size2 = new Size(n2, camcorderProfile2.videoFrameHeight);
        }
        return size;
    }

    public String h() {
        return this.g;
    }

    public boolean l() {
        return this.l;
    }

    public boolean k() {
        return this.m;
    }

    /*
     * WARNING - void declaration
     */
    public boolean a(@NonNull SupportedSurfaceCombination.FeatureSettings featureSettings, List<SurfaceConfig> surfaceConfigList) {
        void var2_3;
        Iterator<SurfaceCombination> iterator;
        boolean bl = false;
        iterator = this.a((SupportedSurfaceCombination.FeatureSettings)iterator).iterator();
        while (iterator.hasNext() && !(bl = iterator.next().getOrderedSupportedSurfaceConfigList((List)var2_3) != null)) {
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public List<SurfaceConfig> b(@NonNull SupportedSurfaceCombination.FeatureSettings featureSettings, List<SurfaceConfig> surfaceConfigList) {
        if (!StreamUseCaseUtil.shouldUseStreamUseCase((SupportedSurfaceCombination.FeatureSettings)featureSettings)) {
            return null;
        }
        Iterator<SurfaceCombination> iterator = ((a)((Object)iterator)).f.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            List list = ((SurfaceCombination)iterator.next()).getOrderedSupportedSurfaceConfigList((List)var2_2);
            if (list == null) continue;
            return list;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public SurfaceConfig b(int cameraMode, int imageFormat, Size size) {
        void var3_3;
        void var2_2;
        return SurfaceConfig.transformSurfaceConfig((int)cameraMode, (int)var2_2, (Size)var3_3, (SurfaceSizeDefinition)this.b((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Pair<Map<UseCaseConfig<?>, StreamSpec>, Map<AttachedSurfaceInfo, StreamSpec>> a(int cameraMode, @NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap) {
        void var1_1;
        void var2_4;
        Object object;
        ArrayList arrayList;
        this.m();
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList(object.keySet());
        List<Integer> list = this.c(arrayList2);
        Map map = this.v.resolveAndValidateDynamicRanges((List)var2_4, arrayList2, list);
        UseCaseConfig<?> useCaseConfig3 = this.a((int)var1_1, map);
        boolean bl = this.a((SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, (List<AttachedSurfaceInfo>)var2_4, (Map<UseCaseConfig<?>, List<Size>>)object);
        if (bl) {
            HashMap hashMap;
            HashMap hashMap2;
            HashMap hashMap3;
            HashMap hashMap4;
            Object object2;
            ArrayList<List<Size>> arrayList3;
            Range<Integer> range = this.a((List<AttachedSurfaceInfo>)var2_4, arrayList2, list);
            object = this.a((Map<UseCaseConfig<?>, List<Size>>)object, (SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, range);
            Cloneable cloneable = arrayList3;
            arrayList3 = new ArrayList<List<Size>>();
            Object object3 = list.iterator();
            while (object3.hasNext()) {
                UseCaseConfig<?> useCaseConfig2 = arrayList2.get(object3.next());
                object2 = (List)object.get(useCaseConfig2);
                int n2 = useCaseConfig2.getInputFormat();
                cloneable.add(this.a((List<Size>)object2, n2));
            }
            object = this.a((List<List<Size>>)((Object)cloneable));
            cloneable = hashMap4;
            hashMap4 = new HashMap();
            object3 = hashMap3;
            hashMap3 = new HashMap();
            object2 = hashMap2;
            hashMap2 = new HashMap();
            HashMap hashMap5 = hashMap;
            hashMap = new HashMap();
            List list2 = null;
            int n3 = Integer.MAX_VALUE;
            List list3 = null;
            int n4 = Integer.MAX_VALUE;
            boolean bl2 = StreamUseCaseUtil.containsZslUseCase((List)var2_4, arrayList2);
            List<SurfaceConfig> list4 = null;
            int n5 = this.b((List<AttachedSurfaceInfo>)var2_4);
            if (this.o && !bl2) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    list4 = (List<SurfaceConfig>)iterator.next();
                    list4 = (List)this.a((int)var1_1, (List<AttachedSurfaceInfo>)var2_4, (List<Size>)list4, arrayList2, list, (int)n5, (Map<Integer, AttachedSurfaceInfo>)object2, hashMap5).first;
                    if ((list4 = this.b((SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, list4)) != null && !StreamUseCaseUtil.areCaptureTypesEligible((Map)object2, hashMap5, list4)) {
                        list4 = null;
                    }
                    if (list4 != null) {
                        if (StreamUseCaseUtil.areStreamUseCasesAvailableForSurfaceConfigs((CameraCharacteristicsCompat)this.i, list4)) break;
                        list4 = null;
                    }
                    ((HashMap)object2).clear();
                    hashMap5.clear();
                }
                if (list4 == null && !bl) {
                    throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.g + ".  May be attempting to bind too many use cases. Existing surfaces: " + var2_4 + " New configs: " + arrayList2);
                }
            }
            boolean bl3 = false;
            bl = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                List list5 = (List)iterator.next();
                Pair<List<SurfaceConfig>, Integer> pair = this.a((int)var1_1, (List<AttachedSurfaceInfo>)var2_4, list5, arrayList2, list, n5, null, null);
                List list6 = (List)pair.first;
                int n6 = (Integer)pair.second;
                boolean bl4 = true;
                if (range != null && n5 > n6 && n6 < (Integer)range.getLower()) {
                    bl4 = false;
                }
                if (!bl3 && this.a((SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, list6)) {
                    if (n3 == Integer.MAX_VALUE || n3 < n6) {
                        list2 = list5;
                        n3 = n6;
                    }
                    if (bl4) {
                        bl3 = true;
                        if (bl) {
                            n3 = n6;
                            list2 = list5;
                            break;
                        }
                        list2 = list5;
                        n3 = n6;
                    }
                }
                if (list4 == null || bl || this.b((SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, list6) == null) continue;
                if (n4 == Integer.MAX_VALUE || n4 < n6) {
                    list3 = list5;
                    n4 = n6;
                }
                if (!bl4) continue;
                bl = true;
                if (bl3) {
                    list3 = list5;
                    n4 = n6;
                    break;
                }
                list3 = list5;
                n4 = n6;
            }
            if (list2 != null) {
                block23: {
                    Range<Integer> range2 = null;
                    if (range != null) {
                        range2 = this.a(range, n3);
                    }
                    for (UseCaseConfig<?> useCaseConfig3 : arrayList2) {
                        StreamSpec.Builder builder = StreamSpec.builder((Size)((Size)list2.get(list.indexOf(arrayList2.indexOf(useCaseConfig3))))).setDynamicRange((DynamicRange)Preconditions.checkNotNull((Object)((DynamicRange)map.get(useCaseConfig3)))).setImplementationOptions((Config)StreamUseCaseUtil.getStreamSpecImplementationOptions(useCaseConfig3));
                        if (range2 != null) {
                            builder.setExpectedFrameRateRange(range2);
                        }
                        ((HashMap)object3).put(useCaseConfig3, builder.build());
                    }
                    if (list4 != null && n3 == n4 && list2.size() == list3.size()) {
                        for (int i2 = 0; i2 < list2.size(); ++i2) {
                            if (((Size)list2.get(i2)).equals(list3.get(i2))) {
                                continue;
                            }
                            break block23;
                        }
                        if (!StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithInteropOverride((CameraCharacteristicsCompat)this.i, (List)var2_4, (Map)object3, cloneable)) {
                            StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithSupportedSurfaceConfigs((Map)object3, cloneable, (Map)object2, hashMap5, list4);
                        }
                    }
                }
                return new Pair(object3, cloneable);
            }
            throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.g + " and Hardware level: " + this.k + ". May be the specified resolution is too large and not supported. Existing surfaces: " + var2_4 + " New configs: " + arrayList2);
        }
        throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.g + ".  May be attempting to bind too many use cases. Existing surfaces: " + var2_4 + " New configs: " + arrayList2);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NonNull
    public List<Size> a(@NonNull List<Size> sizeList, int imageFormat) {
        void var2_2;
        Object object;
        Object object2;
        a a2 = this;
        String string = a2.g;
        int n2 = this.t.get(string, a2.i);
        string = null;
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                string = null;
                break;
            }
            case 2: {
                Rational rational;
                string = this.b(256).getMaximumSize(256);
                object2 = rational;
                String string2 = string;
                int n3 = string2.getWidth();
                rational = new Rational(n3, string2.getHeight());
                string = object2;
                break;
            }
            case 1: {
                string = AspectRatioUtil.ASPECT_RATIO_16_9;
                break;
            }
            case 0: {
                string = AspectRatioUtil.ASPECT_RATIO_4_3;
            }
        }
        if (string != null) {
            ArrayList arrayList;
            ArrayList arrayList2;
            void v4 = object;
            object = arrayList2;
            arrayList2 = new ArrayList();
            object2 = arrayList;
            arrayList = new ArrayList();
            for (Size size : v4) {
                if (AspectRatioUtil.hasMatchingAspectRatio((Size)size, (Rational)string)) {
                    ((ArrayList)object).add(size);
                    continue;
                }
                ((ArrayList)object2).add(size);
            }
            ((ArrayList)object2).addAll(0, object);
            object = object2;
        }
        return this.u.insertOrPrioritize(SurfaceConfig.getConfigType((int)var2_2), object);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NonNull
    public SurfaceSizeDefinition b(int format) {
        void var1_1;
        if (!this.r.contains((int)var1_1)) {
            a a2 = this;
            a2.a(a2.q.getS720pSizeMap(), SizeUtil.RESOLUTION_720P, (int)var1_1);
            a2.a(a2.q.getS1440pSizeMap(), SizeUtil.RESOLUTION_1440P, (int)var1_1);
            a2.a(a2.q.getMaximumSizeMap(), (int)var1_1);
            a2.b(a2.q.getUltraMaximumSizeMap(), (int)var1_1);
            a2.r.add((int)var1_1);
        }
        return this.q;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface a {
    }
}

