/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.exif;

import com.android.mms.exif.Rational;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class ExifTag {
    public static final short TYPE_UNSIGNED_BYTE = 1;
    public static final short TYPE_ASCII = 2;
    public static final short TYPE_UNSIGNED_SHORT = 3;
    public static final short TYPE_UNSIGNED_LONG = 4;
    public static final short TYPE_UNSIGNED_RATIONAL = 5;
    public static final short TYPE_UNDEFINED = 7;
    public static final short TYPE_LONG = 9;
    public static final short TYPE_RATIONAL = 10;
    private static Charset US_ASCII = Charset.forName("US-ASCII");
    private static final int[] TYPE_TO_SIZE_MAP;
    private static final int UNSIGNED_SHORT_MAX = 65535;
    private static final long UNSIGNED_LONG_MAX = 0xFFFFFFFFL;
    private static final long LONG_MAX = Integer.MAX_VALUE;
    private static final long LONG_MIN = Integer.MIN_VALUE;
    static final int SIZE_UNDEFINED = 0;
    private static final SimpleDateFormat TIME_FORMAT;
    private final short mTagId;
    private final short mDataType;
    private boolean mHasDefinedDefaultComponentCount;
    private int mComponentCountActual;
    private int mIfd;
    private Object mValue;
    private int mOffset;

    public static boolean isValidIfd(int ifdId) {
        int n;
        return ifdId == 0 || n == 1 || n == 2 || n == 3 || n == 4;
        {
        }
    }

    public static boolean isValidType(short type) {
        short s;
        return type == 1 || s == 2 || s == 3 || s == 4 || s == 5 || s == 7 || s == 9 || s == 10;
        {
        }
    }

    /*
     * WARNING - void declaration
     */
    public ExifTag(short tagId, short type, int componentCount, int ifd, boolean hasDefinedComponentCount) {
        void var4_4;
        void var5_5;
        void var3_3;
        void var2_2;
        void var1_1;
        this.mTagId = var1_1;
        this.mDataType = var2_2;
        this.mComponentCountActual = var3_3;
        this.mHasDefinedDefaultComponentCount = var5_5;
        this.mIfd = var4_4;
        this.mValue = null;
    }

    public static int getElementSize(short type) {
        short s;
        return TYPE_TO_SIZE_MAP[s];
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkBadComponentCount(int count) {
        void var1_1;
        return this.mHasDefinedDefaultComponentCount && this.mComponentCountActual != var1_1;
    }

    private static String convertTypeToString(short type) {
        switch (type) {
            default: {
                return "";
            }
            case 10: {
                return "RATIONAL";
            }
            case 9: {
                return "LONG";
            }
            case 7: {
                return "UNDEFINED";
            }
            case 5: {
                return "UNSIGNED_RATIONAL";
            }
            case 4: {
                return "UNSIGNED_LONG";
            }
            case 3: {
                return "UNSIGNED_SHORT";
            }
            case 2: {
                return "ASCII";
            }
            case 1: 
        }
        return "UNSIGNED_BYTE";
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkOverflowForUnsignedShort(int[] value) {
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            void var1_2;
            void var3_4 = var1_2[i];
            if (var3_4 <= 65535 && var3_4 >= 0) {
                continue;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkOverflowForUnsignedLong(long[] value) {
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            void var1_2;
            void var3_4 = var1_2[i];
            if (var3_4 >= 0L && var3_4 <= 0xFFFFFFFFL) {
                continue;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkOverflowForUnsignedLong(int[] value) {
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            void var1_2;
            if (var1_2[i] >= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkOverflowForUnsignedRational(Rational[] value) {
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            void var1_2;
            void var3_4 = var1_2[i];
            if (var3_4.getNumerator() >= 0L && var3_4.getDenominator() >= 0L && var3_4.getNumerator() <= 0xFFFFFFFFL && var3_4.getDenominator() <= 0xFFFFFFFFL) {
                continue;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkOverflowForRational(Rational[] value) {
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            void var1_2;
            void var3_4 = var1_2[i];
            if (var3_4.getNumerator() >= Integer.MIN_VALUE && var3_4.getDenominator() >= Integer.MIN_VALUE && var3_4.getNumerator() <= Integer.MAX_VALUE && var3_4.getDenominator() <= Integer.MAX_VALUE) {
                continue;
            }
            return true;
        }
        return false;
    }

    static {
        int[] nArray = new int[11];
        TYPE_TO_SIZE_MAP = nArray;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 8;
        nArray[7] = 1;
        nArray[9] = 4;
        nArray[10] = 8;
        TIME_FORMAT = new SimpleDateFormat("yyyy:MM:dd kk:mm:ss");
    }

    public int getIfd() {
        return this.mIfd;
    }

    /*
     * WARNING - void declaration
     */
    public void setIfd(int ifdId) {
        void var1_1;
        this.mIfd = var1_1;
    }

    public short getTagId() {
        return this.mTagId;
    }

    public short getDataType() {
        return this.mDataType;
    }

    public int getDataSize() {
        ExifTag exifTag = this;
        int n = exifTag.getComponentCount();
        return ExifTag.getElementSize(exifTag.getDataType()) * n;
    }

    public int getComponentCount() {
        return this.mComponentCountActual;
    }

    /*
     * WARNING - void declaration
     */
    public void forceSetComponentCount(int count) {
        void var1_1;
        this.mComponentCountActual = var1_1;
    }

    public boolean hasValue() {
        return this.mValue != null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setValue(int[] value) {
        void var1_1;
        if (this.checkBadComponentCount(((void)var1_1).length)) {
            return false;
        }
        short s = this.mDataType;
        if (s != 3 && s != 9 && s != 4) {
            return false;
        }
        if (s == 3 && this.checkOverflowForUnsignedShort((int[])var1_1)) {
            return false;
        }
        if (this.mDataType == 4 && this.checkOverflowForUnsignedLong((int[])var1_1)) {
            return false;
        }
        long[] lArray = new long[((void)var1_1).length];
        for (int i = 0; i < ((void)var1_1).length; ++i) {
            lArray[i] = (long)var1_1[i];
        }
        this.mValue = lArray;
        this.mComponentCountActual = ((void)var1_1).length;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setValue(int value) {
        void var1_1;
        return this.setValue(new int[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public boolean setValue(long[] value) {
        void var1_1;
        if (!this.checkBadComponentCount(((void)var1_1).length) && this.mDataType == 4) {
            if (this.checkOverflowForUnsignedLong((long[])var1_1)) {
                return false;
            }
            this.mValue = var1_1;
            this.mComponentCountActual = ((void)var1_1).length;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setValue(long value) {
        void var1_1;
        return this.setValue(new long[]{var1_1});
    }

    public boolean setValue(String value) {
        byte[] byArray;
        int n = this.mDataType;
        if (n != 2 && n != 7) {
            return false;
        }
        if ((byArray = byArray.getBytes(US_ASCII)).length > 0) {
            if (byArray[byArray.length - 1] != 0 && this.mDataType != 7) {
                byArray = Arrays.copyOf(byArray, byArray.length + 1);
            }
        } else if (this.mDataType == 2 && this.mComponentCountActual == 1) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 0;
        }
        if (this.checkBadComponentCount(n = byArray.length)) {
            return false;
        }
        ExifTag exifTag = this;
        exifTag.mComponentCountActual = n;
        exifTag.mValue = byArray;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setValue(Rational[] value) {
        void var1_1;
        if (this.checkBadComponentCount(((void)var1_1).length)) {
            return false;
        }
        short s = this.mDataType;
        if (s != 5 && s != 10) {
            return false;
        }
        if (s == 5 && this.checkOverflowForUnsignedRational((Rational[])var1_1)) {
            return false;
        }
        if (this.mDataType == 10 && this.checkOverflowForRational((Rational[])var1_1)) {
            return false;
        }
        this.mValue = var1_1;
        this.mComponentCountActual = ((void)var1_1).length;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setValue(Rational value) {
        void var1_1;
        return this.setValue(new Rational[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public boolean setValue(byte[] value, int offset, int length) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (((ExifTag)this_).checkBadComponentCount((int)var3_3)) {
            return false;
        }
        short s = ((ExifTag)this_).mDataType;
        if (s != 1 && s != 7) {
            return false;
        }
        ExifTag exifTag = this_;
        ExifTag exifTag2 = this_;
        byte[] byArray = new byte[var3_3];
        Object this_ = byArray;
        exifTag2.mValue = byArray;
        System.arraycopy(var1_1, (int)var2_2, this_, 0, (int)var3_3);
        exifTag.mComponentCountActual = var3_3;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setValue(byte[] value) {
        void var1_1;
        void v0 = var1_1;
        return this.setValue((byte[])v0, 0, ((void)v0).length);
    }

    /*
     * WARNING - void declaration
     */
    public boolean setValue(byte value) {
        void var1_1;
        return this.setValue(new byte[]{var1_1});
    }

    public boolean setValue(Object obj) {
        Number[] numberArray;
        if (obj == null) {
            return false;
        }
        if (numberArray instanceof Short) {
            return this.setValue((int)((Short)numberArray & 0xFFFF));
        }
        if (numberArray instanceof String) {
            return this.setValue((String)numberArray);
        }
        if (numberArray instanceof int[]) {
            return this.setValue((int[])numberArray);
        }
        if (numberArray instanceof long[]) {
            return this.setValue((long[])numberArray);
        }
        if (numberArray instanceof Rational) {
            return this.setValue((Rational)numberArray);
        }
        if (numberArray instanceof Rational[]) {
            return this.setValue((Rational[])numberArray);
        }
        if (numberArray instanceof byte[]) {
            return this.setValue((byte[])numberArray);
        }
        if (numberArray instanceof Integer) {
            return this.setValue((Integer)numberArray);
        }
        if (numberArray instanceof Long) {
            return this.setValue((Long)numberArray);
        }
        if (numberArray instanceof Byte) {
            return this.setValue((Byte)numberArray);
        }
        if (numberArray instanceof Short[]) {
            numberArray = (Short[])numberArray;
            int[] nArray = new int[numberArray.length];
            for (int i = 0; i < numberArray.length; ++i) {
                Number number = numberArray[i];
                int n = number == null ? 0 : (Short)number & 0xFFFF;
                nArray[i] = n;
            }
            return this.setValue(nArray);
        }
        if (numberArray instanceof Integer[]) {
            numberArray = (Integer[])numberArray;
            int[] nArray = new int[numberArray.length];
            for (int i = 0; i < numberArray.length; ++i) {
                Number number = numberArray[i];
                int n = number == null ? 0 : (Integer)number;
                nArray[i] = n;
            }
            return this.setValue(nArray);
        }
        if (numberArray instanceof Long[]) {
            numberArray = (Long[])numberArray;
            long[] lArray = new long[numberArray.length];
            for (int i = 0; i < numberArray.length; ++i) {
                Number number = numberArray[i];
                long l = number == null ? 0L : (Long)number;
                lArray[i] = l;
            }
            return this.setValue(lArray);
        }
        if (numberArray instanceof Byte[]) {
            numberArray = (Byte[])numberArray;
            byte[] byArray = new byte[numberArray.length];
            for (int i = 0; i < numberArray.length; ++i) {
                Number number = numberArray[i];
                byte by = number == null ? (byte)0 : (Byte)number;
                byArray[i] = by;
            }
            return this.setValue(byArray);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean setTimeValue(long time) {
        ExifTag exifTag = this_;
        SimpleDateFormat this_ = TIME_FORMAT;
        synchronized (this_) {
            void var1_1;
            return exifTag.setValue(this_.format(new Date((long)var1_1)));
        }
    }

    public String getValueAsString() {
        Object this_ = ((ExifTag)this_).mValue;
        if (this_ == null) {
            return null;
        }
        if (this_ instanceof String) {
            return (String)this_;
        }
        if (this_ instanceof byte[]) {
            return new String((byte[])this_, US_ASCII);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String getValueAsString(String defaultValue) {
        if ((this = ((ExifTag)this).getValueAsString()) == null) {
            void var1_1;
            return var1_1;
        }
        return this;
    }

    public byte[] getValueAsBytes() {
        Object this_ = ((ExifTag)this_).mValue;
        if (this_ instanceof byte[]) {
            return (byte[])this_;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public byte getValueAsByte(byte defaultValue) {
        void var1_1;
        byte[] byArray = ((ExifTag)this_).getValueAsBytes();
        Object this_ = byArray;
        if (byArray != null && ((Object)this_).length >= 1) {
            return (byte)this_[0];
        }
        return (byte)var1_1;
    }

    public Rational[] getValueAsRationals() {
        Object this_ = ((ExifTag)this_).mValue;
        if (this_ instanceof Rational[]) {
            return (Rational[])this_;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Rational getValueAsRational(Rational defaultValue) {
        void var1_1;
        if ((this = this.getValueAsRationals()) != null && this.length >= 1) {
            return this[0];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Rational getValueAsRational(long defaultValue) {
        void var1_1;
        return this.getValueAsRational(new Rational((long)var1_1, 1L));
    }

    public int[] getValueAsInts() {
        Object this_ = ((ExifTag)this_).mValue;
        if (this_ == null) {
            return null;
        }
        if (this_ instanceof long[]) {
            long[] lArray = (long[])this_;
            this_ = lArray;
            int[] nArray = new int[lArray.length];
            for (int i = 0; i < ((Object)this_).length; ++i) {
                nArray[i] = (int)this_[i];
            }
            return nArray;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public int getValueAsInt(int defaultValue) {
        void var1_1;
        int[] nArray = ((ExifTag)this_).getValueAsInts();
        Object this_ = nArray;
        if (nArray != null && ((Object)this_).length >= 1) {
            return (int)this_[0];
        }
        return (int)var1_1;
    }

    public long[] getValueAsLongs() {
        Object this_ = ((ExifTag)this_).mValue;
        if (this_ instanceof long[]) {
            return (long[])this_;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public long getValueAsLong(long defaultValue) {
        void var1_1;
        long[] lArray = ((ExifTag)this_).getValueAsLongs();
        Object this_ = lArray;
        if (lArray != null && ((Object)this_).length >= 1) {
            return (long)this_[0];
        }
        return (long)var1_1;
    }

    public Object getValue() {
        return this.mValue;
    }

    /*
     * WARNING - void declaration
     */
    public long forceGetValueAsLong(long defaultValue) {
        void var1_1;
        Object[] objectArray = this.getValueAsLongs();
        if (objectArray != null && objectArray.length >= 1) {
            return objectArray[0];
        }
        byte[] byArray = this.getValueAsBytes();
        objectArray = byArray;
        if (byArray != null && objectArray.length >= 1) {
            return objectArray[0];
        }
        if ((this = this.getValueAsRationals()) != null && this.length >= 1 && this[0].getDenominator() != 0L) {
            return (long)this[0].toDouble();
        }
        return (long)var1_1;
    }

    public String forceGetValueAsString() {
        Object object = ((ExifTag)this_).mValue;
        if (object == null) {
            return "";
        }
        if (object instanceof byte[]) {
            if (((ExifTag)this_).mDataType == 2) {
                return new String((byte[])object, US_ASCII);
            }
            return Arrays.toString((byte[])object);
        }
        if (object instanceof long[]) {
            if (((long[])object).length == 1) {
                return String.valueOf(((long[])object)[0]);
            }
            return Arrays.toString((long[])object);
        }
        if (object instanceof Object[]) {
            if (((Object[])object).length == 1) {
                Object this_ = ((Object[])object)[0];
                if (this_ == null) {
                    return "";
                }
                return this_.toString();
            }
            return Arrays.toString((Object[])object);
        }
        return object.toString();
    }

    /*
     * WARNING - void declaration
     */
    public long getValueAt(int index) {
        void var1_1;
        Object object = this.mValue;
        if (object instanceof long[]) {
            return ((long[])object)[var1_1];
        }
        if (object instanceof byte[]) {
            return ((byte[])object)[var1_1];
        }
        throw new IllegalArgumentException("Cannot get integer value from " + ExifTag.convertTypeToString(this.mDataType));
    }

    public String getString() {
        if (this.mDataType == 2) {
            return new String((byte[])this.mValue, US_ASCII);
        }
        throw new IllegalArgumentException("Cannot get ASCII value from " + ExifTag.convertTypeToString(this.mDataType));
    }

    public byte[] getStringByte() {
        return (byte[])this.mValue;
    }

    /*
     * WARNING - void declaration
     */
    public Rational getRational(int index) {
        void var1_1;
        short s = this.mDataType;
        if (s != 10 && s != 5) {
            throw new IllegalArgumentException("Cannot get RATIONAL value from " + ExifTag.convertTypeToString(this.mDataType));
        }
        return ((Rational[])this.mValue)[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public void getBytes(byte[] buf) {
        void var1_2;
        int n = ((void)var1_2).length;
        this.getBytes((byte[])var1_2, 0, n);
    }

    /*
     * WARNING - void declaration
     */
    public void getBytes(byte[] buf, int offset, int length) {
        void var2_2;
        void var1_1;
        int n;
        short s = ((ExifTag)this_).mDataType;
        if (s != 7 && s != 1) {
            throw new IllegalArgumentException("Cannot get BYTE value from " + ExifTag.convertTypeToString(((ExifTag)this_).mDataType));
        }
        ExifTag exifTag = this_;
        Object this_ = exifTag.mValue;
        s = 0;
        int n2 = exifTag.mComponentCountActual;
        if (n > n2) {
            n = n2;
        }
        System.arraycopy(this_, s, var1_1, (int)var2_2, n);
    }

    public int getOffset() {
        return this.mOffset;
    }

    /*
     * WARNING - void declaration
     */
    public void setOffset(int offset) {
        void var1_1;
        this.mOffset = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setHasDefinedCount(boolean d) {
        void var1_1;
        this.mHasDefinedDefaultComponentCount = var1_1;
    }

    public boolean hasDefinedCount() {
        return this.mHasDefinedDefaultComponentCount;
    }

    public boolean equals(Object obj) {
        Object object;
        if (obj == null) {
            return false;
        }
        if (object instanceof ExifTag) {
            object = (ExifTag)object;
            if (((ExifTag)object).mTagId == ((ExifTag)object2).mTagId && ((ExifTag)object).mComponentCountActual == ((ExifTag)object2).mComponentCountActual && ((ExifTag)object).mDataType == ((ExifTag)object2).mDataType) {
                Object object2 = ((ExifTag)object2).mValue;
                if (object2 != null) {
                    object = ((ExifTag)object).mValue;
                    if (object == null) {
                        return false;
                    }
                    if (object2 instanceof long[]) {
                        if (!(object instanceof long[])) {
                            return false;
                        }
                        return Arrays.equals((long[])object2, (long[])object);
                    }
                    if (object2 instanceof Rational[]) {
                        if (!(object instanceof Rational[])) {
                            return false;
                        }
                        return Arrays.equals((Rational[])object2, (Rational[])object);
                    }
                    if (object2 instanceof byte[]) {
                        if (!(object instanceof byte[])) {
                            return false;
                        }
                        return Arrays.equals((byte[])object2, (byte[])object);
                    }
                    return object2.equals(object);
                }
                return ((ExifTag)object).mValue == null;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        Short s = this.mTagId;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = s;
        return String.format("tag id: %04X\n", objectArray2) + "ifd id: " + this.mIfd + "\ntype: " + ExifTag.convertTypeToString(this.mDataType) + "\ncount: " + this.mComponentCountActual + "\noffset: " + this.mOffset + "\nvalue: " + this.forceGetValueAsString() + "\n";
    }
}

