/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.exif;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.SparseIntArray;
import com.android.mms.exif.ExifData;
import com.android.mms.exif.ExifInvalidFormatException;
import com.android.mms.exif.ExifModifier;
import com.android.mms.exif.ExifOutputStream;
import com.android.mms.exif.ExifReader;
import com.android.mms.exif.ExifTag;
import com.android.mms.exif.IfdData;
import com.android.mms.exif.Rational;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class ExifInterface {
    public static final int TAG_NULL = -1;
    public static final int IFD_NULL = -1;
    public static final int DEFINITION_NULL = 0;
    public static final int TAG_IMAGE_WIDTH;
    public static final int TAG_IMAGE_LENGTH;
    public static final int TAG_BITS_PER_SAMPLE;
    public static final int TAG_COMPRESSION;
    public static final int TAG_PHOTOMETRIC_INTERPRETATION;
    public static final int TAG_IMAGE_DESCRIPTION;
    public static final int TAG_MAKE;
    public static final int TAG_MODEL;
    public static final int TAG_STRIP_OFFSETS;
    public static final int TAG_ORIENTATION;
    public static final int TAG_SAMPLES_PER_PIXEL;
    public static final int TAG_ROWS_PER_STRIP;
    public static final int TAG_STRIP_BYTE_COUNTS;
    public static final int TAG_X_RESOLUTION;
    public static final int TAG_Y_RESOLUTION;
    public static final int TAG_PLANAR_CONFIGURATION;
    public static final int TAG_RESOLUTION_UNIT;
    public static final int TAG_TRANSFER_FUNCTION;
    public static final int TAG_SOFTWARE;
    public static final int TAG_DATE_TIME;
    public static final int TAG_ARTIST;
    public static final int TAG_WHITE_POINT;
    public static final int TAG_PRIMARY_CHROMATICITIES;
    public static final int TAG_Y_CB_CR_COEFFICIENTS;
    public static final int TAG_Y_CB_CR_SUB_SAMPLING;
    public static final int TAG_Y_CB_CR_POSITIONING;
    public static final int TAG_REFERENCE_BLACK_WHITE;
    public static final int TAG_COPYRIGHT;
    public static final int TAG_EXIF_IFD;
    public static final int TAG_GPS_IFD;
    public static final int TAG_JPEG_INTERCHANGE_FORMAT;
    public static final int TAG_JPEG_INTERCHANGE_FORMAT_LENGTH;
    public static final int TAG_EXPOSURE_TIME;
    public static final int TAG_F_NUMBER;
    public static final int TAG_EXPOSURE_PROGRAM;
    public static final int TAG_SPECTRAL_SENSITIVITY;
    public static final int TAG_ISO_SPEED_RATINGS;
    public static final int TAG_OECF;
    public static final int TAG_EXIF_VERSION;
    public static final int TAG_DATE_TIME_ORIGINAL;
    public static final int TAG_DATE_TIME_DIGITIZED;
    public static final int TAG_COMPONENTS_CONFIGURATION;
    public static final int TAG_COMPRESSED_BITS_PER_PIXEL;
    public static final int TAG_SHUTTER_SPEED_VALUE;
    public static final int TAG_APERTURE_VALUE;
    public static final int TAG_BRIGHTNESS_VALUE;
    public static final int TAG_EXPOSURE_BIAS_VALUE;
    public static final int TAG_MAX_APERTURE_VALUE;
    public static final int TAG_SUBJECT_DISTANCE;
    public static final int TAG_METERING_MODE;
    public static final int TAG_LIGHT_SOURCE;
    public static final int TAG_FLASH;
    public static final int TAG_FOCAL_LENGTH;
    public static final int TAG_SUBJECT_AREA;
    public static final int TAG_MAKER_NOTE;
    public static final int TAG_USER_COMMENT;
    public static final int TAG_SUB_SEC_TIME;
    public static final int TAG_SUB_SEC_TIME_ORIGINAL;
    public static final int TAG_SUB_SEC_TIME_DIGITIZED;
    public static final int TAG_FLASHPIX_VERSION;
    public static final int TAG_COLOR_SPACE;
    public static final int TAG_PIXEL_X_DIMENSION;
    public static final int TAG_PIXEL_Y_DIMENSION;
    public static final int TAG_RELATED_SOUND_FILE;
    public static final int TAG_INTEROPERABILITY_IFD;
    public static final int TAG_FLASH_ENERGY;
    public static final int TAG_SPATIAL_FREQUENCY_RESPONSE;
    public static final int TAG_FOCAL_PLANE_X_RESOLUTION;
    public static final int TAG_FOCAL_PLANE_Y_RESOLUTION;
    public static final int TAG_FOCAL_PLANE_RESOLUTION_UNIT;
    public static final int TAG_SUBJECT_LOCATION;
    public static final int TAG_EXPOSURE_INDEX;
    public static final int TAG_SENSING_METHOD;
    public static final int TAG_FILE_SOURCE;
    public static final int TAG_SCENE_TYPE;
    public static final int TAG_CFA_PATTERN;
    public static final int TAG_CUSTOM_RENDERED;
    public static final int TAG_EXPOSURE_MODE;
    public static final int TAG_WHITE_BALANCE;
    public static final int TAG_DIGITAL_ZOOM_RATIO;
    public static final int TAG_FOCAL_LENGTH_IN_35_MM_FILE;
    public static final int TAG_SCENE_CAPTURE_TYPE;
    public static final int TAG_GAIN_CONTROL;
    public static final int TAG_CONTRAST;
    public static final int TAG_SATURATION;
    public static final int TAG_SHARPNESS;
    public static final int TAG_DEVICE_SETTING_DESCRIPTION;
    public static final int TAG_SUBJECT_DISTANCE_RANGE;
    public static final int TAG_IMAGE_UNIQUE_ID;
    public static final int TAG_GPS_VERSION_ID;
    public static final int TAG_GPS_LATITUDE_REF;
    public static final int TAG_GPS_LATITUDE;
    public static final int TAG_GPS_LONGITUDE_REF;
    public static final int TAG_GPS_LONGITUDE;
    public static final int TAG_GPS_ALTITUDE_REF;
    public static final int TAG_GPS_ALTITUDE;
    public static final int TAG_GPS_TIME_STAMP;
    public static final int TAG_GPS_SATTELLITES;
    public static final int TAG_GPS_STATUS;
    public static final int TAG_GPS_MEASURE_MODE;
    public static final int TAG_GPS_DOP;
    public static final int TAG_GPS_SPEED_REF;
    public static final int TAG_GPS_SPEED;
    public static final int TAG_GPS_TRACK_REF;
    public static final int TAG_GPS_TRACK;
    public static final int TAG_GPS_IMG_DIRECTION_REF;
    public static final int TAG_GPS_IMG_DIRECTION;
    public static final int TAG_GPS_MAP_DATUM;
    public static final int TAG_GPS_DEST_LATITUDE_REF;
    public static final int TAG_GPS_DEST_LATITUDE;
    public static final int TAG_GPS_DEST_LONGITUDE_REF;
    public static final int TAG_GPS_DEST_LONGITUDE;
    public static final int TAG_GPS_DEST_BEARING_REF;
    public static final int TAG_GPS_DEST_BEARING;
    public static final int TAG_GPS_DEST_DISTANCE_REF;
    public static final int TAG_GPS_DEST_DISTANCE;
    public static final int TAG_GPS_PROCESSING_METHOD;
    public static final int TAG_GPS_AREA_INFORMATION;
    public static final int TAG_GPS_DATE_STAMP;
    public static final int TAG_GPS_DIFFERENTIAL;
    public static final int TAG_INTEROPERABILITY_INDEX;
    private static HashSet<Short> sOffsetTags;
    protected static HashSet<Short> sBannedDefines;
    private static final String NULL_ARGUMENT_STRING = "Argument is null";
    public static final ByteOrder DEFAULT_BYTE_ORDER;
    private static final String GPS_DATE_FORMAT_STR = "yyyy:MM:dd";
    private static final String DATETIME_FORMAT_STR = "yyyy:MM:dd kk:mm:ss";
    private ExifData mData = new ExifData(DEFAULT_BYTE_ORDER);
    private final DateFormat mDateTimeStampFormat = new SimpleDateFormat("yyyy:MM:dd kk:mm:ss");
    private final DateFormat mGPSDateStampFormat;
    private final Calendar mGPSTimeStampCalendar;
    private SparseIntArray mTagInfo;

    public static int defineTag(int ifdId, short tagId) {
        int n;
        return tagId & 0xFFFF | n << 16;
    }

    public static short getTrueTagKey(int tag) {
        return (short)tag;
    }

    public static int getTrueIfd(int tag) {
        return tag >>> 16;
    }

    public ExifInterface() {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        ExifInterface exifInterface = this;
        SimpleDateFormat simpleDateFormat3 = simpleDateFormat2;
        simpleDateFormat3(GPS_DATE_FORMAT_STR);
        exifInterface.mGPSDateStampFormat = simpleDateFormat3;
        exifInterface.mGPSTimeStampCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        exifInterface.mTagInfo = null;
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static boolean isOffsetTag(short tag) {
        short s;
        return sOffsetTags.contains(s);
    }

    public static short getOrientationValueForRotation(int degrees) {
        int n = degrees % 360;
        if (n < 0) {
            n += 360;
        }
        if (n < 90) {
            return 1;
        }
        if (n < 180) {
            return 6;
        }
        if (n < 270) {
            return 3;
        }
        return 8;
    }

    public static int getRotationForOrientationValue(short orientation) {
        if (orientation != 3) {
            short s;
            if (s != 6) {
                if (s != 8) {
                    return 0;
                }
                return 270;
            }
            return 90;
        }
        return 180;
    }

    /*
     * WARNING - void declaration
     */
    public static double convertLatOrLongToDouble(Rational[] coordinate, String reference) {
        block8: {
            double d;
            block7: {
                void var1_1;
                Rational[] rationalArray;
                Rational[] rationalArray2;
                String string;
                try {
                    Rational[] rationalArray3;
                    string = reference;
                    rationalArray2 = rationalArray3;
                    rationalArray = rationalArray3;
                    d = rationalArray3[0].toDouble();
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                double d2 = rationalArray[1].toDouble();
                d = d2 / 60.0 + d;
                d = rationalArray2[2].toDouble() / 3600.0 + d;
                if (string.equals("S")) break block7;
                if (!var1_1.equals("W")) {
                    return d;
                }
                break block8;
            }
            return -d;
        }
        throw new IllegalArgumentException();
    }

    private static Rational[] toExifLatLong(double value) {
        Rational rational;
        Rational rational2;
        Rational rational3;
        double d = Math.abs(value);
        int n = (int)d;
        double d2 = (d - (double)n) * 60.0;
        int n2 = (int)d2;
        int n3 = (int)((d2 - (double)n2) * 6000.0);
        Rational rational4 = rational3;
        rational3 = new Rational(n, 1L);
        Rational rational5 = rational2;
        rational2 = new Rational(n2, 1L);
        Rational rational6 = rational;
        rational = new Rational(n3, 100L);
        return new Rational[]{rational4, rational5, rational6};
    }

    /*
     * WARNING - void declaration
     */
    private void doExifStreamIO(InputStream is, OutputStream os) {
        byte[] byArray = new byte[1024];
        Object object = byArray;
        int n = is.read(byArray, 0, 1024);
        while (n != -1) {
            void var1_1;
            void var2_2;
            var2_2.write((byte[])object, 0, n);
            n = var1_1.read((byte[])object, 0, 1024);
        }
    }

    public static void closeSilently(Closeable c) {
        if (c != null) {
            try {
                Closeable closeable;
                closeable.close();
                return;
            }
            catch (Throwable throwable) {}
        }
    }

    private void initTagInfo() {
        int n = ExifInterface.getFlagsFromAllowedIfds(new int[]{0, 1}) << 24;
        int n2 = TAG_MAKE;
        int n3 = n | 0x20000;
        this.mTagInfo.put(n2, n3);
        int n4 = n;
        int n5 = TAG_IMAGE_WIDTH;
        int n6 = n4 | 0x40000;
        int n7 = n4 | 0x40001;
        this.mTagInfo.put(n5, n7);
        this.mTagInfo.put(TAG_IMAGE_LENGTH, n7);
        n5 = TAG_BITS_PER_SAMPLE;
        this.mTagInfo.put(n5, n | 0x30003);
        n5 = TAG_COMPRESSION;
        int n8 = n | 0x30001;
        this.mTagInfo.put(n5, n8);
        this.mTagInfo.put(TAG_PHOTOMETRIC_INTERPRETATION, n8);
        this.mTagInfo.put(TAG_ORIENTATION, n8);
        this.mTagInfo.put(TAG_SAMPLES_PER_PIXEL, n8);
        this.mTagInfo.put(TAG_PLANAR_CONFIGURATION, n8);
        n5 = TAG_Y_CB_CR_SUB_SAMPLING;
        this.mTagInfo.put(n5, n | 0x30002);
        this.mTagInfo.put(TAG_Y_CB_CR_POSITIONING, n8);
        n5 = TAG_X_RESOLUTION;
        int n9 = n | 0x50001;
        this.mTagInfo.put(n5, n9);
        this.mTagInfo.put(TAG_Y_RESOLUTION, n9);
        this.mTagInfo.put(TAG_RESOLUTION_UNIT, n8);
        this.mTagInfo.put(TAG_STRIP_OFFSETS, n6);
        this.mTagInfo.put(TAG_ROWS_PER_STRIP, n7);
        this.mTagInfo.put(TAG_STRIP_BYTE_COUNTS, n6);
        n5 = TAG_TRANSFER_FUNCTION;
        this.mTagInfo.put(n5, n | 0x30300);
        n5 = TAG_WHITE_POINT;
        this.mTagInfo.put(n5, n | 0x50002);
        n5 = TAG_PRIMARY_CHROMATICITIES;
        n6 = n | 0x50006;
        this.mTagInfo.put(n5, n6);
        n5 = TAG_Y_CB_CR_COEFFICIENTS;
        this.mTagInfo.put(n5, n | 0x50003);
        this.mTagInfo.put(TAG_REFERENCE_BLACK_WHITE, n6);
        int n10 = n;
        n = TAG_DATE_TIME;
        this.mTagInfo.put(n, n10 | 0x20014);
        this.mTagInfo.put(TAG_IMAGE_DESCRIPTION, n3);
        this.mTagInfo.put(n2, n3);
        this.mTagInfo.put(TAG_MODEL, n3);
        this.mTagInfo.put(TAG_SOFTWARE, n3);
        this.mTagInfo.put(TAG_ARTIST, n3);
        this.mTagInfo.put(TAG_COPYRIGHT, n3);
        this.mTagInfo.put(TAG_EXIF_IFD, n7);
        this.mTagInfo.put(TAG_GPS_IFD, n7);
        n = TAG_JPEG_INTERCHANGE_FORMAT;
        n2 = ExifInterface.getFlagsFromAllowedIfds(new int[]{1}) << 24 | 0x40001;
        this.mTagInfo.put(n, n2);
        this.mTagInfo.put(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, n2);
        int n11 = n = ExifInterface.getFlagsFromAllowedIfds(new int[]{2}) << 24;
        n2 = TAG_EXIF_VERSION;
        n3 = n11 | 0x70000;
        n5 = n11 | 0x70004;
        this.mTagInfo.put(n2, n5);
        this.mTagInfo.put(TAG_FLASHPIX_VERSION, n5);
        int n12 = n;
        n2 = TAG_COLOR_SPACE;
        n6 = n12 | 0x30000;
        n7 = n12 | 0x30001;
        this.mTagInfo.put(n2, n7);
        this.mTagInfo.put(TAG_COMPONENTS_CONFIGURATION, n5);
        n2 = TAG_COMPRESSED_BITS_PER_PIXEL;
        n5 = n | 0x50001;
        this.mTagInfo.put(n2, n5);
        n2 = TAG_PIXEL_X_DIMENSION;
        n8 = n | 0x40001;
        this.mTagInfo.put(n2, n8);
        this.mTagInfo.put(TAG_PIXEL_Y_DIMENSION, n8);
        this.mTagInfo.put(TAG_MAKER_NOTE, n3);
        this.mTagInfo.put(TAG_USER_COMMENT, n3);
        int n13 = n;
        n2 = TAG_RELATED_SOUND_FILE;
        n9 = n13 | 0x20000;
        this.mTagInfo.put(n2, n13 | 0x2000D);
        n2 = TAG_DATE_TIME_ORIGINAL;
        int n14 = n | 0x20014;
        this.mTagInfo.put(n2, n14);
        this.mTagInfo.put(TAG_DATE_TIME_DIGITIZED, n14);
        this.mTagInfo.put(TAG_SUB_SEC_TIME, n9);
        this.mTagInfo.put(TAG_SUB_SEC_TIME_ORIGINAL, n9);
        this.mTagInfo.put(TAG_SUB_SEC_TIME_DIGITIZED, n9);
        n2 = TAG_IMAGE_UNIQUE_ID;
        this.mTagInfo.put(n2, n | 0x20021);
        this.mTagInfo.put(TAG_EXPOSURE_TIME, n5);
        this.mTagInfo.put(TAG_F_NUMBER, n5);
        this.mTagInfo.put(TAG_EXPOSURE_PROGRAM, n7);
        this.mTagInfo.put(TAG_SPECTRAL_SENSITIVITY, n9);
        this.mTagInfo.put(TAG_ISO_SPEED_RATINGS, n6);
        this.mTagInfo.put(TAG_OECF, n3);
        n2 = TAG_SHUTTER_SPEED_VALUE;
        n9 = n | 0xA0001;
        this.mTagInfo.put(n2, n9);
        this.mTagInfo.put(TAG_APERTURE_VALUE, n5);
        this.mTagInfo.put(TAG_BRIGHTNESS_VALUE, n9);
        this.mTagInfo.put(TAG_EXPOSURE_BIAS_VALUE, n9);
        this.mTagInfo.put(TAG_MAX_APERTURE_VALUE, n5);
        this.mTagInfo.put(TAG_SUBJECT_DISTANCE, n5);
        this.mTagInfo.put(TAG_METERING_MODE, n7);
        this.mTagInfo.put(TAG_LIGHT_SOURCE, n7);
        this.mTagInfo.put(TAG_FLASH, n7);
        this.mTagInfo.put(TAG_FOCAL_LENGTH, n5);
        this.mTagInfo.put(TAG_SUBJECT_AREA, n6);
        this.mTagInfo.put(TAG_FLASH_ENERGY, n5);
        this.mTagInfo.put(TAG_SPATIAL_FREQUENCY_RESPONSE, n3);
        this.mTagInfo.put(TAG_FOCAL_PLANE_X_RESOLUTION, n5);
        this.mTagInfo.put(TAG_FOCAL_PLANE_Y_RESOLUTION, n5);
        this.mTagInfo.put(TAG_FOCAL_PLANE_RESOLUTION_UNIT, n7);
        n2 = TAG_SUBJECT_LOCATION;
        this.mTagInfo.put(n2, n | 0x30002);
        this.mTagInfo.put(TAG_EXPOSURE_INDEX, n5);
        this.mTagInfo.put(TAG_SENSING_METHOD, n7);
        int n15 = n;
        n = TAG_FILE_SOURCE;
        n2 = n15 | 0x70001;
        this.mTagInfo.put(n, n2);
        this.mTagInfo.put(TAG_SCENE_TYPE, n2);
        this.mTagInfo.put(TAG_CFA_PATTERN, n3);
        this.mTagInfo.put(TAG_CUSTOM_RENDERED, n7);
        this.mTagInfo.put(TAG_EXPOSURE_MODE, n7);
        this.mTagInfo.put(TAG_WHITE_BALANCE, n7);
        this.mTagInfo.put(TAG_DIGITAL_ZOOM_RATIO, n5);
        this.mTagInfo.put(TAG_FOCAL_LENGTH_IN_35_MM_FILE, n7);
        this.mTagInfo.put(TAG_SCENE_CAPTURE_TYPE, n7);
        this.mTagInfo.put(TAG_GAIN_CONTROL, n5);
        this.mTagInfo.put(TAG_CONTRAST, n7);
        this.mTagInfo.put(TAG_SATURATION, n7);
        this.mTagInfo.put(TAG_SHARPNESS, n7);
        this.mTagInfo.put(TAG_DEVICE_SETTING_DESCRIPTION, n3);
        this.mTagInfo.put(TAG_SUBJECT_DISTANCE_RANGE, n7);
        this.mTagInfo.put(TAG_INTEROPERABILITY_IFD, n8);
        n = ExifInterface.getFlagsFromAllowedIfds(new int[]{4}) << 24;
        n2 = TAG_GPS_VERSION_ID;
        this.mTagInfo.put(n2, n | 0x10004);
        int n16 = n;
        n2 = TAG_GPS_LATITUDE_REF;
        n3 = n16 | 0x20000;
        n5 = n16 | 0x20002;
        this.mTagInfo.put(n2, n5);
        this.mTagInfo.put(TAG_GPS_LONGITUDE_REF, n5);
        n2 = TAG_GPS_LATITUDE;
        n6 = n | 0xA0003;
        this.mTagInfo.put(n2, n6);
        this.mTagInfo.put(TAG_GPS_LONGITUDE, n6);
        n2 = TAG_GPS_ALTITUDE_REF;
        this.mTagInfo.put(n2, n | 0x10001);
        n2 = TAG_GPS_ALTITUDE;
        n6 = n | 0x50001;
        this.mTagInfo.put(n2, n6);
        n2 = TAG_GPS_TIME_STAMP;
        this.mTagInfo.put(n2, n | 0x50003);
        this.mTagInfo.put(TAG_GPS_SATTELLITES, n3);
        this.mTagInfo.put(TAG_GPS_STATUS, n5);
        this.mTagInfo.put(TAG_GPS_MEASURE_MODE, n5);
        this.mTagInfo.put(TAG_GPS_DOP, n6);
        this.mTagInfo.put(TAG_GPS_SPEED_REF, n5);
        this.mTagInfo.put(TAG_GPS_SPEED, n6);
        this.mTagInfo.put(TAG_GPS_TRACK_REF, n5);
        this.mTagInfo.put(TAG_GPS_TRACK, n6);
        this.mTagInfo.put(TAG_GPS_IMG_DIRECTION_REF, n5);
        this.mTagInfo.put(TAG_GPS_IMG_DIRECTION, n6);
        this.mTagInfo.put(TAG_GPS_MAP_DATUM, n3);
        this.mTagInfo.put(TAG_GPS_DEST_LATITUDE_REF, n5);
        this.mTagInfo.put(TAG_GPS_DEST_LATITUDE, n6);
        this.mTagInfo.put(TAG_GPS_DEST_BEARING_REF, n5);
        this.mTagInfo.put(TAG_GPS_DEST_BEARING, n6);
        this.mTagInfo.put(TAG_GPS_DEST_DISTANCE_REF, n5);
        this.mTagInfo.put(TAG_GPS_DEST_DISTANCE, n6);
        n2 = TAG_GPS_PROCESSING_METHOD;
        n3 = n | 0x70000;
        this.mTagInfo.put(n2, n3);
        this.mTagInfo.put(TAG_GPS_AREA_INFORMATION, n3);
        n2 = TAG_GPS_DATE_STAMP;
        this.mTagInfo.put(n2, n | 0x2000B);
        int n17 = n;
        n = TAG_GPS_DIFFERENTIAL;
        this.mTagInfo.put(n, n17 | 0x3000B);
        int n18 = TAG_INTEROPERABILITY_INDEX;
        this.mTagInfo.put(n18, ExifInterface.getFlagsFromAllowedIfds(new int[]{3}) << 24 | 0x20000);
    }

    public static int getAllowedIfdFlagsFromInfo(int info) {
        return info >>> 24;
    }

    public static int[] getAllowedIfdsFromInfo(int info) {
        int n;
        ArrayList<Integer> arrayList;
        int n2 = ExifInterface.getAllowedIfdFlagsFromInfo(info);
        int[] nArray = IfdData.getIfds();
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>();
        for (n = 0; n < 5; ++n) {
            if ((n2 >> n & 1) != 1) continue;
            arrayList2.add(nArray[n]);
        }
        if (arrayList2.size() <= 0) {
            return null;
        }
        ArrayList<Integer> arrayList3 = arrayList2;
        int[] nArray2 = new int[arrayList3.size()];
        int n3 = 0;
        int n4 = arrayList3.size();
        for (n = 0; n < n4; ++n) {
            Object e = arrayList2.get(n);
            nArray2[n3++] = (Integer)e;
        }
        return nArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isIfdAllowed(int info, int ifd) {
        int[] nArray = IfdData.getIfds();
        int n = ExifInterface.getAllowedIfdFlagsFromInfo(info);
        for (int i = 0; i < nArray.length; ++i) {
            void var1_2;
            if (var1_2 != nArray[i] || (n >> i & 1) != 1) continue;
            return true;
        }
        return false;
    }

    public static int getFlagsFromAllowedIfds(int[] allowedIfds) {
        int[] nArray;
        if (allowedIfds != null && nArray.length != 0) {
            int n = 0;
            int[] nArray2 = IfdData.getIfds();
            block0: for (int i = 0; i < 5; ++i) {
                for (int n2 : nArray) {
                    if (nArray2[i] != n2) continue;
                    n |= 1 << i;
                    continue block0;
                }
            }
            return n;
        }
        return 0;
    }

    public static short getTypeFromInfo(int info) {
        return (short)(info >> 16 & 0xFF);
    }

    public static int getComponentCountFromInfo(int info) {
        return info & 0xFFFF;
    }

    static {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        TAG_IMAGE_WIDTH = ExifInterface.defineTag(0, (short)256);
        TAG_IMAGE_LENGTH = ExifInterface.defineTag(0, (short)257);
        TAG_BITS_PER_SAMPLE = ExifInterface.defineTag(0, (short)258);
        TAG_COMPRESSION = ExifInterface.defineTag(0, (short)259);
        TAG_PHOTOMETRIC_INTERPRETATION = ExifInterface.defineTag(0, (short)262);
        TAG_IMAGE_DESCRIPTION = ExifInterface.defineTag(0, (short)270);
        TAG_MAKE = ExifInterface.defineTag(0, (short)271);
        TAG_MODEL = ExifInterface.defineTag(0, (short)272);
        TAG_STRIP_OFFSETS = n7 = ExifInterface.defineTag(0, (short)273);
        TAG_ORIENTATION = ExifInterface.defineTag(0, (short)274);
        TAG_SAMPLES_PER_PIXEL = ExifInterface.defineTag(0, (short)277);
        TAG_ROWS_PER_STRIP = ExifInterface.defineTag(0, (short)278);
        TAG_STRIP_BYTE_COUNTS = n6 = ExifInterface.defineTag(0, (short)279);
        TAG_X_RESOLUTION = ExifInterface.defineTag(0, (short)282);
        TAG_Y_RESOLUTION = ExifInterface.defineTag(0, (short)283);
        TAG_PLANAR_CONFIGURATION = ExifInterface.defineTag(0, (short)284);
        TAG_RESOLUTION_UNIT = ExifInterface.defineTag(0, (short)296);
        TAG_TRANSFER_FUNCTION = ExifInterface.defineTag(0, (short)301);
        TAG_SOFTWARE = ExifInterface.defineTag(0, (short)305);
        TAG_DATE_TIME = ExifInterface.defineTag(0, (short)306);
        TAG_ARTIST = ExifInterface.defineTag(0, (short)315);
        TAG_WHITE_POINT = ExifInterface.defineTag(0, (short)318);
        TAG_PRIMARY_CHROMATICITIES = ExifInterface.defineTag(0, (short)319);
        TAG_Y_CB_CR_COEFFICIENTS = ExifInterface.defineTag(0, (short)529);
        TAG_Y_CB_CR_SUB_SAMPLING = ExifInterface.defineTag(0, (short)530);
        TAG_Y_CB_CR_POSITIONING = ExifInterface.defineTag(0, (short)531);
        TAG_REFERENCE_BLACK_WHITE = ExifInterface.defineTag(0, (short)532);
        TAG_COPYRIGHT = ExifInterface.defineTag(0, (short)-32104);
        TAG_EXIF_IFD = n5 = ExifInterface.defineTag(0, (short)-30871);
        TAG_GPS_IFD = n4 = ExifInterface.defineTag(0, (short)-30683);
        TAG_JPEG_INTERCHANGE_FORMAT = n3 = ExifInterface.defineTag(1, (short)513);
        TAG_JPEG_INTERCHANGE_FORMAT_LENGTH = n2 = ExifInterface.defineTag(1, (short)514);
        TAG_EXPOSURE_TIME = ExifInterface.defineTag(2, (short)-32102);
        TAG_F_NUMBER = ExifInterface.defineTag(2, (short)-32099);
        TAG_EXPOSURE_PROGRAM = ExifInterface.defineTag(2, (short)-30686);
        TAG_SPECTRAL_SENSITIVITY = ExifInterface.defineTag(2, (short)-30684);
        TAG_ISO_SPEED_RATINGS = ExifInterface.defineTag(2, (short)-30681);
        TAG_OECF = ExifInterface.defineTag(2, (short)-30680);
        TAG_EXIF_VERSION = ExifInterface.defineTag(2, (short)-28672);
        TAG_DATE_TIME_ORIGINAL = ExifInterface.defineTag(2, (short)-28669);
        TAG_DATE_TIME_DIGITIZED = ExifInterface.defineTag(2, (short)-28668);
        TAG_COMPONENTS_CONFIGURATION = ExifInterface.defineTag(2, (short)-28415);
        TAG_COMPRESSED_BITS_PER_PIXEL = ExifInterface.defineTag(2, (short)-28414);
        TAG_SHUTTER_SPEED_VALUE = ExifInterface.defineTag(2, (short)-28159);
        TAG_APERTURE_VALUE = ExifInterface.defineTag(2, (short)-28158);
        TAG_BRIGHTNESS_VALUE = ExifInterface.defineTag(2, (short)-28157);
        TAG_EXPOSURE_BIAS_VALUE = ExifInterface.defineTag(2, (short)-28156);
        TAG_MAX_APERTURE_VALUE = ExifInterface.defineTag(2, (short)-28155);
        TAG_SUBJECT_DISTANCE = ExifInterface.defineTag(2, (short)-28154);
        TAG_METERING_MODE = ExifInterface.defineTag(2, (short)-28153);
        TAG_LIGHT_SOURCE = ExifInterface.defineTag(2, (short)-28152);
        TAG_FLASH = ExifInterface.defineTag(2, (short)-28151);
        TAG_FOCAL_LENGTH = ExifInterface.defineTag(2, (short)-28150);
        TAG_SUBJECT_AREA = ExifInterface.defineTag(2, (short)-28140);
        TAG_MAKER_NOTE = ExifInterface.defineTag(2, (short)-28036);
        TAG_USER_COMMENT = ExifInterface.defineTag(2, (short)-28026);
        TAG_SUB_SEC_TIME = ExifInterface.defineTag(2, (short)-28016);
        TAG_SUB_SEC_TIME_ORIGINAL = ExifInterface.defineTag(2, (short)-28015);
        TAG_SUB_SEC_TIME_DIGITIZED = ExifInterface.defineTag(2, (short)-28014);
        TAG_FLASHPIX_VERSION = ExifInterface.defineTag(2, (short)-24576);
        TAG_COLOR_SPACE = ExifInterface.defineTag(2, (short)-24575);
        TAG_PIXEL_X_DIMENSION = ExifInterface.defineTag(2, (short)-24574);
        TAG_PIXEL_Y_DIMENSION = ExifInterface.defineTag(2, (short)-24573);
        TAG_RELATED_SOUND_FILE = ExifInterface.defineTag(2, (short)-24572);
        TAG_INTEROPERABILITY_IFD = n = ExifInterface.defineTag(2, (short)-24571);
        TAG_FLASH_ENERGY = ExifInterface.defineTag(2, (short)-24053);
        TAG_SPATIAL_FREQUENCY_RESPONSE = ExifInterface.defineTag(2, (short)-24052);
        TAG_FOCAL_PLANE_X_RESOLUTION = ExifInterface.defineTag(2, (short)-24050);
        TAG_FOCAL_PLANE_Y_RESOLUTION = ExifInterface.defineTag(2, (short)-24049);
        TAG_FOCAL_PLANE_RESOLUTION_UNIT = ExifInterface.defineTag(2, (short)-24048);
        TAG_SUBJECT_LOCATION = ExifInterface.defineTag(2, (short)-24044);
        TAG_EXPOSURE_INDEX = ExifInterface.defineTag(2, (short)-24043);
        TAG_SENSING_METHOD = ExifInterface.defineTag(2, (short)-24041);
        TAG_FILE_SOURCE = ExifInterface.defineTag(2, (short)-23808);
        TAG_SCENE_TYPE = ExifInterface.defineTag(2, (short)-23807);
        TAG_CFA_PATTERN = ExifInterface.defineTag(2, (short)-23806);
        TAG_CUSTOM_RENDERED = ExifInterface.defineTag(2, (short)-23551);
        TAG_EXPOSURE_MODE = ExifInterface.defineTag(2, (short)-23550);
        TAG_WHITE_BALANCE = ExifInterface.defineTag(2, (short)-23549);
        TAG_DIGITAL_ZOOM_RATIO = ExifInterface.defineTag(2, (short)-23548);
        TAG_FOCAL_LENGTH_IN_35_MM_FILE = ExifInterface.defineTag(2, (short)-23547);
        TAG_SCENE_CAPTURE_TYPE = ExifInterface.defineTag(2, (short)-23546);
        TAG_GAIN_CONTROL = ExifInterface.defineTag(2, (short)-23545);
        TAG_CONTRAST = ExifInterface.defineTag(2, (short)-23544);
        TAG_SATURATION = ExifInterface.defineTag(2, (short)-23543);
        TAG_SHARPNESS = ExifInterface.defineTag(2, (short)-23542);
        TAG_DEVICE_SETTING_DESCRIPTION = ExifInterface.defineTag(2, (short)-23541);
        TAG_SUBJECT_DISTANCE_RANGE = ExifInterface.defineTag(2, (short)-23540);
        TAG_IMAGE_UNIQUE_ID = ExifInterface.defineTag(2, (short)-23520);
        TAG_GPS_VERSION_ID = ExifInterface.defineTag(4, (short)0);
        TAG_GPS_LATITUDE_REF = ExifInterface.defineTag(4, (short)1);
        TAG_GPS_LATITUDE = ExifInterface.defineTag(4, (short)2);
        TAG_GPS_LONGITUDE_REF = ExifInterface.defineTag(4, (short)3);
        TAG_GPS_LONGITUDE = ExifInterface.defineTag(4, (short)4);
        TAG_GPS_ALTITUDE_REF = ExifInterface.defineTag(4, (short)5);
        TAG_GPS_ALTITUDE = ExifInterface.defineTag(4, (short)6);
        TAG_GPS_TIME_STAMP = ExifInterface.defineTag(4, (short)7);
        TAG_GPS_SATTELLITES = ExifInterface.defineTag(4, (short)8);
        TAG_GPS_STATUS = ExifInterface.defineTag(4, (short)9);
        TAG_GPS_MEASURE_MODE = ExifInterface.defineTag(4, (short)10);
        TAG_GPS_DOP = ExifInterface.defineTag(4, (short)11);
        TAG_GPS_SPEED_REF = ExifInterface.defineTag(4, (short)12);
        TAG_GPS_SPEED = ExifInterface.defineTag(4, (short)13);
        TAG_GPS_TRACK_REF = ExifInterface.defineTag(4, (short)14);
        TAG_GPS_TRACK = ExifInterface.defineTag(4, (short)15);
        TAG_GPS_IMG_DIRECTION_REF = ExifInterface.defineTag(4, (short)16);
        TAG_GPS_IMG_DIRECTION = ExifInterface.defineTag(4, (short)17);
        TAG_GPS_MAP_DATUM = ExifInterface.defineTag(4, (short)18);
        TAG_GPS_DEST_LATITUDE_REF = ExifInterface.defineTag(4, (short)19);
        TAG_GPS_DEST_LATITUDE = ExifInterface.defineTag(4, (short)20);
        TAG_GPS_DEST_LONGITUDE_REF = ExifInterface.defineTag(4, (short)21);
        TAG_GPS_DEST_LONGITUDE = ExifInterface.defineTag(4, (short)22);
        TAG_GPS_DEST_BEARING_REF = ExifInterface.defineTag(4, (short)23);
        TAG_GPS_DEST_BEARING = ExifInterface.defineTag(4, (short)24);
        TAG_GPS_DEST_DISTANCE_REF = ExifInterface.defineTag(4, (short)25);
        TAG_GPS_DEST_DISTANCE = ExifInterface.defineTag(4, (short)26);
        TAG_GPS_PROCESSING_METHOD = ExifInterface.defineTag(4, (short)27);
        TAG_GPS_AREA_INFORMATION = ExifInterface.defineTag(4, (short)28);
        TAG_GPS_DATE_STAMP = ExifInterface.defineTag(4, (short)29);
        TAG_GPS_DIFFERENTIAL = ExifInterface.defineTag(4, (short)30);
        TAG_INTEROPERABILITY_INDEX = ExifInterface.defineTag(3, (short)1);
        sOffsetTags = new HashSet<Short>();
        sOffsetTags.add(ExifInterface.getTrueTagKey(n4));
        sOffsetTags.add(ExifInterface.getTrueTagKey(n5));
        sOffsetTags.add(ExifInterface.getTrueTagKey(n3));
        sOffsetTags.add(ExifInterface.getTrueTagKey(n));
        sOffsetTags.add(ExifInterface.getTrueTagKey(n7));
        sBannedDefines = new HashSet<Short>(sOffsetTags);
        sBannedDefines.add(ExifInterface.getTrueTagKey(-1));
        sBannedDefines.add(ExifInterface.getTrueTagKey(n2));
        sBannedDefines.add(ExifInterface.getTrueTagKey(n6));
        DEFAULT_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    }

    /*
     * WARNING - void declaration
     */
    public void readExif(byte[] jpeg) {
        void var1_1;
        ByteArrayInputStream byteArrayInputStream;
        ExifInterface exifInterface = this_;
        ByteArrayInputStream this_ = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream((byte[])var1_1);
        exifInterface.readExif(this_);
    }

    /*
     * WARNING - void declaration
     */
    public void readExif(InputStream inStream) {
        if (inStream != null) {
            void var1_2;
            try {
                ExifInterface exifInterface = this;
            }
            catch (ExifInvalidFormatException exifInvalidFormatException) {
                throw new IOException("Invalid exif format : " + exifInvalidFormatException);
            }
            exifInterface.mData = new ExifReader(this).read((InputStream)var1_2);
            return;
        }
        throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readExif(String inFileName) {
        IOException iOException2;
        BufferedInputStream bufferedInputStream;
        block7: {
            FileInputStream fileInputStream;
            BufferedInputStream bufferedInputStream2;
            BufferedInputStream bufferedInputStream3;
            ExifInterface exifInterface;
            BufferedInputStream bufferedInputStream4;
            if (inFileName == null) {
                throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
            }
            bufferedInputStream = null;
            BufferedInputStream bufferedInputStream5 = bufferedInputStream4;
            try {
                exifInterface = fileInputStream2;
                BufferedInputStream bufferedInputStream6 = bufferedInputStream5;
                bufferedInputStream3 = bufferedInputStream6;
                bufferedInputStream2 = bufferedInputStream6;
            }
            catch (IOException iOException2) {
                // empty catch block
                break block7;
            }
            FileInputStream fileInputStream2 = fileInputStream;
            {
                void var1_1;
                fileInputStream = new FileInputStream((String)var1_1);
                bufferedInputStream3(fileInputStream2);
            }
            try {
                exifInterface.readExif(bufferedInputStream2);
            }
            catch (IOException iOException2) {
                bufferedInputStream = bufferedInputStream5;
                break block7;
            }
            ((InputStream)bufferedInputStream4).close();
            return;
        }
        ExifInterface.closeSilently(bufferedInputStream);
        throw iOException2;
    }

    /*
     * WARNING - void declaration
     */
    public void setExif(Collection<ExifTag> tags) {
        void var1_1;
        ExifInterface exifInterface = this;
        exifInterface.clearExif();
        exifInterface.setTags((Collection<ExifTag>)var1_1);
    }

    public void clearExif() {
        this.mData = new ExifData(DEFAULT_BYTE_ORDER);
    }

    /*
     * WARNING - void declaration
     */
    public void writeExif(byte[] jpeg, OutputStream exifOutStream) {
        void var2_3;
        if (jpeg != null && var2_3 != null) {
            void var1_2;
            OutputStream outputStream = this.getExifWriterStream((OutputStream)var2_3);
            int n = ((void)var1_2).length;
            outputStream.write((byte[])var1_2, 0, n);
            outputStream.flush();
            return;
        }
        throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
    }

    /*
     * WARNING - void declaration
     */
    public void writeExif(Bitmap bmap, OutputStream exifOutStream) {
        void var2_2;
        if (bmap != null && var2_2 != null) {
            void var1_1;
            OutputStream outputStream = ((ExifInterface)((Object)outputStream)).getExifWriterStream((OutputStream)var2_2);
            var1_1.compress(Bitmap.CompressFormat.JPEG, 90, outputStream);
            outputStream.flush();
            return;
        }
        throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
    }

    /*
     * WARNING - void declaration
     */
    public void writeExif(InputStream jpegStream, OutputStream exifOutStream) {
        OutputStream outputStream;
        if (jpegStream != null && outputStream != null) {
            void var1_1;
            outputStream = this.getExifWriterStream(outputStream);
            this.doExifStreamIO((InputStream)var1_1, outputStream);
            outputStream.flush();
            return;
        }
        throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
    }

    /*
     * WARNING - void declaration
     */
    public void writeExif(byte[] jpeg, String exifOutFileName) {
        void var2_3;
        if (jpeg != null && var2_3 != null) {
            int n;
            void v1;
            ExifInterface exifInterface = object;
            Object object = null;
            try {
                void var1_1;
                object = exifInterface.getExifWriterStream((String)var2_3);
                v1 = var1_1;
                n = 0;
            }
            catch (IOException iOException) {
                ExifInterface.closeSilently((Closeable)object);
                throw iOException;
            }
            ((OutputStream)object).write((byte[])v1, n, ((void)v1).length);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
            return;
        }
        throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
    }

    /*
     * WARNING - void declaration
     */
    public void writeExif(Bitmap bmap, String exifOutFileName) {
        void var2_2;
        if (bmap != null && var2_2 != null) {
            void var1_1;
            ExifInterface exifInterface = object;
            Object object = null;
            try {
                object = exifInterface.getExifWriterStream((String)var2_2);
            }
            catch (IOException iOException) {
                ExifInterface.closeSilently((Closeable)object);
                throw iOException;
            }
            var1_1.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)object);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
            return;
        }
        throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
    }

    /*
     * WARNING - void declaration
     */
    public void writeExif(InputStream jpegStream, String exifOutFileName) {
        OutputStream outputStream;
        if (jpegStream != null && outputStream != null) {
            void var1_1;
            void v0 = outputStream;
            outputStream = null;
            try {
                outputStream = this.getExifWriterStream((String)v0);
            }
            catch (IOException iOException) {
                ExifInterface.closeSilently(outputStream);
                throw iOException;
            }
            this.doExifStreamIO((InputStream)var1_1, outputStream);
            outputStream.flush();
            outputStream.close();
            return;
        }
        throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeExif(String jpegFileName, String exifOutFileName) {
        void var2_2;
        if (jpegFileName != null && var2_2 != null) {
            IOException iOException2;
            FileInputStream fileInputStream;
            block6: {
                FileInputStream fileInputStream2;
                ExifInterface exifInterface;
                FileInputStream fileInputStream3;
                fileInputStream = null;
                FileInputStream fileInputStream4 = fileInputStream3;
                try {
                    void var1_1;
                    exifInterface = this;
                    FileInputStream fileInputStream5 = fileInputStream4;
                    fileInputStream2 = fileInputStream5;
                    fileInputStream5((String)var1_1);
                }
                catch (IOException iOException2) {
                    // empty catch block
                    break block6;
                }
                try {
                    exifInterface.writeExif((InputStream)fileInputStream2, (String)var2_2);
                }
                catch (IOException iOException2) {
                    fileInputStream = fileInputStream4;
                    break block6;
                }
                ((InputStream)fileInputStream3).close();
                return;
            }
            ExifInterface.closeSilently(fileInputStream);
            throw iOException2;
        }
        throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
    }

    /*
     * WARNING - void declaration
     */
    public OutputStream getExifWriterStream(OutputStream outStream) {
        if (outStream != null) {
            void var1_1;
            ExifOutputStream exifOutputStream = new ExifOutputStream((OutputStream)var1_1, this);
            exifOutputStream.setExifData(this.mData);
            return exifOutputStream;
        }
        throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
    }

    /*
     * WARNING - void declaration
     */
    public OutputStream getExifWriterStream(String exifOutFileName) {
        if (exifOutFileName != null) {
            ExifInterface exifInterface = exifInterface2;
            ExifInterface exifInterface2 = null;
            try {
                void var1_1;
                return exifInterface.getExifWriterStream(new FileOutputStream((String)var1_1));
            }
            catch (FileNotFoundException fileNotFoundException) {
                ExifInterface.closeSilently((Closeable)((Object)exifInterface2));
                throw fileNotFoundException;
            }
        }
        throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
    }

    /*
     * Exception decompiling
     */
    public boolean rewriteExif(String filename, Collection<ExifTag> tags) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 11[TRYBLOCK] [22, 21 : 109->123)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean rewriteExif(ByteBuffer buf, Collection<ExifTag> tags) {
        void var1_2;
        ExifModifier exifModifier;
        Collection<ExifTag> collection;
        try {
            collection = tags;
        }
        catch (ExifInvalidFormatException exifInvalidFormatException) {
            throw new IOException("Invalid exif format : " + exifInvalidFormatException);
        }
        ExifModifier exifModifier2 = exifModifier;
        exifModifier = new ExifModifier((ByteBuffer)var1_2, (ExifInterface)((Object)iterator));
        Iterator<ExifTag> iterator = collection.iterator();
        while (iterator.hasNext()) {
            exifModifier2.modifyTag((ExifTag)iterator.next());
        }
        return exifModifier2.commit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void forceRewriteExif(String filename, Collection<ExifTag> tags) {
        block11: {
            if (this.rewriteExif((String)var1_1, (Collection<ExifTag>)var2_2)) {
                return;
            }
            var3_3 = this.mData;
            this.mData = new ExifData(ExifInterface.DEFAULT_BYTE_ORDER);
            var4_4 = null;
            var5_5 = v0;
            try {
                v1 = this;
                v2 = v1;
                v3 = v1;
                v4 = var2_2;
                v5 = this;
                var5_5((String)var1_1);
            }
            catch (Throwable v6) {
                break block11;
            }
            catch (IOException v7) {
                // empty catch block
                ** GOTO lbl-1000
            }
            var2_2 = v8;
            try {
                v9 = var2_2;
                v9();
                this.doExifStreamIO(var5_5, v9);
                v10 = v8.toByteArray();
            }
            catch (Throwable v6) {
                var4_4 = var5_5;
                break block11;
            }
            catch (IOException v7) {
                var4_4 = var5_5;
                ** GOTO lbl-1000
            }
            var2_2 = v10;
            {
                v5.readExif(v10);
                v2.setTags((Collection<ExifTag>)v4);
                v3.writeExif((byte[])var2_2, (String)var1_1);
            }
            v0.close();
            this.mData = var3_3;
            return;
lbl-1000:
            // 2 sources

            {
                ExifInterface.closeSilently(var4_4);
                throw v7;
            }
        }
        var4_4.close();
        this.mData = var3_3;
        throw v6;
    }

    /*
     * WARNING - void declaration
     */
    public void forceRewriteExif(String filename) {
        void var1_1;
        ExifInterface exifInterface = this;
        exifInterface.forceRewriteExif((String)var1_1, exifInterface.getAllTags());
    }

    public List<ExifTag> getAllTags() {
        return this.mData.getAllTags();
    }

    /*
     * WARNING - void declaration
     */
    public List<ExifTag> getTagsForTagId(short tagId) {
        void var1_1;
        return this.mData.getAllTagsForTagId((short)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public List<ExifTag> getTagsForIfdId(int ifdId) {
        void var1_1;
        return this.mData.getAllTagsForIfd((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ExifTag getTag(int tagId, int ifdId) {
        void var2_2;
        void var1_1;
        if (!ExifTag.isValidIfd(ifdId)) {
            return null;
        }
        return this.mData.getTag(ExifInterface.getTrueTagKey((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ExifTag getTag(int tagId) {
        void var1_1;
        return this.getTag((int)var1_1, this.getDefinedTagDefaultIfd((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Object getTagValue(int tagId, int ifdId) {
        void var2_2;
        void var1_1;
        if ((this = ((ExifInterface)this).getTag((int)var1_1, (int)var2_2)) == null) {
            return null;
        }
        return ((ExifTag)this).getValue();
    }

    /*
     * WARNING - void declaration
     */
    public Object getTagValue(int tagId) {
        void var1_1;
        return this.getTagValue((int)var1_1, this.getDefinedTagDefaultIfd((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String getTagStringValue(int tagId, int ifdId) {
        void var2_2;
        void var1_1;
        if ((this = ((ExifInterface)this).getTag((int)var1_1, (int)var2_2)) == null) {
            return null;
        }
        return ((ExifTag)this).getValueAsString();
    }

    /*
     * WARNING - void declaration
     */
    public String getTagStringValue(int tagId) {
        void var1_1;
        return this.getTagStringValue((int)var1_1, this.getDefinedTagDefaultIfd((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Long getTagLongValue(int tagId, int ifdId) {
        void var2_2;
        void var1_1;
        long[] lArray = ((ExifInterface)this_).getTagLongValues((int)var1_1, (int)var2_2);
        Object this_ = lArray;
        if (lArray != null && ((Object)this_).length > 0) {
            return new Long((long)this_[0]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Long getTagLongValue(int tagId) {
        void var1_1;
        return this.getTagLongValue((int)var1_1, this.getDefinedTagDefaultIfd((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Integer getTagIntValue(int tagId, int ifdId) {
        void var2_2;
        void var1_1;
        int[] nArray = ((ExifInterface)this_).getTagIntValues((int)var1_1, (int)var2_2);
        Object this_ = nArray;
        if (nArray != null && ((Object)this_).length > 0) {
            return new Integer((int)this_[0]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Integer getTagIntValue(int tagId) {
        void var1_1;
        return this.getTagIntValue((int)var1_1, this.getDefinedTagDefaultIfd((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Byte getTagByteValue(int tagId, int ifdId) {
        void var2_2;
        void var1_1;
        byte[] byArray = ((ExifInterface)this_).getTagByteValues((int)var1_1, (int)var2_2);
        Object this_ = byArray;
        if (byArray != null && ((Object)this_).length > 0) {
            return new Byte((byte)this_[0]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Byte getTagByteValue(int tagId) {
        void var1_1;
        return this.getTagByteValue((int)var1_1, this.getDefinedTagDefaultIfd((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Rational getTagRationalValue(int tagId, int ifdId) {
        void var2_2;
        void var1_1;
        if ((this = this.getTagRationalValues((int)var1_1, (int)var2_2)) != null && this.length != 0) {
            return new Rational(this[0]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Rational getTagRationalValue(int tagId) {
        void var1_1;
        return this.getTagRationalValue((int)var1_1, this.getDefinedTagDefaultIfd((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public long[] getTagLongValues(int tagId, int ifdId) {
        void var2_2;
        void var1_1;
        if ((this = ((ExifInterface)this).getTag((int)var1_1, (int)var2_2)) == null) {
            return null;
        }
        return ((ExifTag)this).getValueAsLongs();
    }

    /*
     * WARNING - void declaration
     */
    public long[] getTagLongValues(int tagId) {
        void var1_1;
        return this.getTagLongValues((int)var1_1, this.getDefinedTagDefaultIfd((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public int[] getTagIntValues(int tagId, int ifdId) {
        void var2_2;
        void var1_1;
        if ((this = ((ExifInterface)this).getTag((int)var1_1, (int)var2_2)) == null) {
            return null;
        }
        return ((ExifTag)this).getValueAsInts();
    }

    /*
     * WARNING - void declaration
     */
    public int[] getTagIntValues(int tagId) {
        void var1_1;
        return this.getTagIntValues((int)var1_1, this.getDefinedTagDefaultIfd((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getTagByteValues(int tagId, int ifdId) {
        void var2_2;
        void var1_1;
        if ((this = ((ExifInterface)this).getTag((int)var1_1, (int)var2_2)) == null) {
            return null;
        }
        return ((ExifTag)this).getValueAsBytes();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getTagByteValues(int tagId) {
        void var1_1;
        return this.getTagByteValues((int)var1_1, this.getDefinedTagDefaultIfd((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Rational[] getTagRationalValues(int tagId, int ifdId) {
        void var2_2;
        void var1_1;
        if ((this = ((ExifInterface)this).getTag((int)var1_1, (int)var2_2)) == null) {
            return null;
        }
        return ((ExifTag)this).getValueAsRationals();
    }

    /*
     * WARNING - void declaration
     */
    public Rational[] getTagRationalValues(int tagId) {
        void var1_1;
        return this.getTagRationalValues((int)var1_1, this.getDefinedTagDefaultIfd((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public boolean isTagCountDefined(int tagId) {
        void var1_2;
        int n = this.getTagInfo().get((int)var1_2);
        if (n == 0) {
            return false;
        }
        return ExifInterface.getComponentCountFromInfo(n) != 0;
    }

    /*
     * WARNING - void declaration
     */
    public int getDefinedTagCount(int tagId) {
        void var1_2;
        int n = this.getTagInfo().get((int)var1_2);
        if (n == 0) {
            return 0;
        }
        return ExifInterface.getComponentCountFromInfo(n);
    }

    /*
     * WARNING - void declaration
     */
    public int getActualTagCount(int tagId, int ifdId) {
        void var2_2;
        void var1_1;
        if ((this = ((ExifInterface)this).getTag((int)var1_1, (int)var2_2)) == null) {
            return 0;
        }
        return ((ExifTag)this).getComponentCount();
    }

    /*
     * WARNING - void declaration
     */
    public int getDefinedTagDefaultIfd(int tagId) {
        void var1_1;
        if (this.getTagInfo().get((int)var1_1) == 0) {
            return -1;
        }
        return ExifInterface.getTrueIfd((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public short getDefinedTagType(int tagId) {
        void var1_2;
        int n = this.getTagInfo().get((int)var1_2);
        if (n == 0) {
            return -1;
        }
        return ExifInterface.getTypeFromInfo(n);
    }

    /*
     * WARNING - void declaration
     */
    public ExifTag buildTag(int tagId, int ifdId, Object val) {
        void var3_5;
        void var1_3;
        int n = this.getTagInfo().get((int)var1_3);
        if (n != 0 && var3_5 != null) {
            ExifTag exifTag;
            void var2_4;
            int n2 = n;
            short s = ExifInterface.getTypeFromInfo(n2);
            int n3 = ExifInterface.getComponentCountFromInfo(n2);
            boolean bl = n3 != 0;
            if (!ExifInterface.isIfdAllowed(n, (int)var2_4)) {
                return null;
            }
            ExifTag exifTag2 = exifTag;
            exifTag2(ExifInterface.getTrueTagKey((int)var1_3), s, n3, (int)var2_4, bl);
            if (!exifTag.setValue(var3_5)) {
                return null;
            }
            return exifTag2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ExifTag buildTag(int tagId, Object val) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        return this.buildTag((int)v0, ExifInterface.getTrueIfd((int)v0), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ExifTag buildUninitializedTag(int tagId) {
        void var1_2;
        int n = this.getTagInfo().get((int)var1_2);
        if (n == 0) {
            return null;
        }
        int n2 = n;
        n = ExifInterface.getTypeFromInfo(n2);
        int n3 = ExifInterface.getComponentCountFromInfo(n2);
        boolean bl = n3 != 0;
        int n4 = ExifInterface.getTrueIfd((int)var1_2);
        return new ExifTag(ExifInterface.getTrueTagKey((int)var1_2), (short)n, n3, n4, bl);
    }

    /*
     * WARNING - void declaration
     */
    public boolean setTagValue(int tagId, int ifdId, Object val) {
        void var3_3;
        void var2_2;
        void var1_1;
        if ((this = ((ExifInterface)this).getTag((int)var1_1, (int)var2_2)) == null) {
            return false;
        }
        return ((ExifTag)this).setValue(var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean setTagValue(int tagId, Object val) {
        void var2_2;
        void var1_1;
        return this.setTagValue((int)var1_1, this.getDefinedTagDefaultIfd((int)var1_1), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ExifTag setTag(ExifTag tag) {
        void var1_1;
        return this.mData.addTag((ExifTag)var1_1);
    }

    public void setTags(Collection<ExifTag> tags) {
        Iterator<ExifTag> iterator = tags.iterator();
        while (iterator.hasNext()) {
            this.setTag(iterator.next());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteTag(int tagId, int ifdId) {
        void var2_2;
        void var1_1;
        this.mData.removeTag(ExifInterface.getTrueTagKey((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void deleteTag(int tagId) {
        void var1_1;
        ExifInterface exifInterface = this;
        exifInterface.deleteTag((int)var1_1, exifInterface.getDefinedTagDefaultIfd((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public int setTagDefinition(short tagId, int defaultIfd, short tagType, short defaultComponentCount, int[] allowedIfds) {
        int n;
        void var3_4;
        void var1_1;
        if (sBannedDefines.contains((short)var1_1)) {
            return -1;
        }
        if (ExifTag.isValidType((short)var3_4) && ExifTag.isValidIfd(n)) {
            void var4_5;
            void var5_6;
            int n2 = ExifInterface.defineTag(n, (short)var1_1);
            if (n2 == -1) {
                return -1;
            }
            ExifInterface exifInterface = this;
            int[] nArray = exifInterface.getTagDefinitionsForTagId((short)var1_1);
            SparseIntArray sparseIntArray = exifInterface.getTagInfo();
            int n3 = 0;
            int n4 = ((void)var5_6).length;
            for (int i = 0; i < n4; ++i) {
                void var11_13 = var5_6[i];
                if (n == var11_13) {
                    n3 = 1;
                }
                if (ExifTag.isValidIfd((int)var11_13)) continue;
                return -1;
            }
            if (n3 == 0) {
                return -1;
            }
            n = ExifInterface.getFlagsFromAllowedIfds((int[])var5_6);
            if (nArray != null) {
                int n5 = nArray.length;
                for (n3 = 0; n3 < n5; ++n3) {
                    if ((n & ExifInterface.getAllowedIfdFlagsFromInfo(sparseIntArray.get(nArray[n3]))) == 0) continue;
                    return -1;
                }
            }
            this.getTagInfo().put(n2, n << 24 | var3_4 << 16 | var4_5);
            return n2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int getTagDefinition(short tagId, int defaultIfd) {
        void var1_1;
        void var2_2;
        return this.getTagInfo().get(ExifInterface.defineTag((int)var2_2, (short)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public int[] getTagDefinitionsForTagId(short tagId) {
        int[] nArray = IfdData.getIfds();
        ExifInterface exifInterface = object;
        Object object = new int[nArray.length];
        int n = 0;
        SparseIntArray sparseIntArray = exifInterface.getTagInfo();
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            void var1_1;
            int n3 = ExifInterface.defineTag(nArray[i], (short)var1_1);
            if (sparseIntArray.get(n3) == 0) continue;
            int n4 = n + 1;
            object[n] = n3;
            n = n4;
        }
        if (n == 0) {
            return null;
        }
        return Arrays.copyOfRange((int[])object, 0, n);
    }

    /*
     * WARNING - void declaration
     */
    public int getTagDefinitionForTag(ExifTag tag) {
        void var1_2;
        void v0 = var1_2;
        short s = v0.getDataType();
        int n = v0.getComponentCount();
        int n2 = v0.getIfd();
        return this.getTagDefinitionForTag(v0.getTagId(), s, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public int getTagDefinitionForTag(short tagId, short type, int count, int ifd) {
        void var1_1;
        int[] nArray = this_.getTagDefinitionsForTagId((short)var1_1);
        if (nArray == null) {
            return -1;
        }
        ExifInterface this_ = this_.getTagInfo();
        int n = -1;
        block0: for (int n2 : nArray) {
            int n3 = this_.get(n2);
            short s = ExifInterface.getTypeFromInfo(n3);
            int n4 = ExifInterface.getComponentCountFromInfo(n3);
            int[] nArray2 = ExifInterface.getAllowedIfdsFromInfo(n3);
            int n5 = nArray2.length;
            for (int i = 0; i < n5; ++i) {
                void var3_4;
                void var2_3;
                void var4_5;
                if (nArray2[i] != var4_5) continue;
                if (var2_3 != s || var3_4 != n4 && n4 != 0) continue block0;
                return n2;
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public void removeTagDefinition(int tagId) {
        void var1_1;
        this.getTagInfo().delete((int)var1_1);
    }

    public void resetTagDefinitions() {
        this.mTagInfo = null;
    }

    public Bitmap getThumbnailBitmap() {
        if (this.mData.hasCompressedThumbnail()) {
            byte[] byArray = this.mData.getCompressedThumbnail();
            return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
        }
        this.mData.hasUncompressedStrip();
        return null;
    }

    public byte[] getThumbnailBytes() {
        if (this.mData.hasCompressedThumbnail()) {
            return this.mData.getCompressedThumbnail();
        }
        this.mData.hasUncompressedStrip();
        return null;
    }

    public byte[] getThumbnail() {
        return this.mData.getCompressedThumbnail();
    }

    public boolean isThumbnailCompressed() {
        return this.mData.hasCompressedThumbnail();
    }

    public boolean hasThumbnail() {
        return this.mData.hasCompressedThumbnail();
    }

    /*
     * WARNING - void declaration
     */
    public boolean setCompressedThumbnail(byte[] thumb) {
        void var1_1;
        ExifInterface exifInterface = this;
        exifInterface.mData.clearThumbnailAndStrips();
        exifInterface.mData.setCompressedThumbnail((byte[])var1_1);
        return true;
    }

    public boolean setCompressedThumbnail(Bitmap thumb) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        if (!thumb.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)byteArrayOutputStream2)) {
            return false;
        }
        return this.setCompressedThumbnail(byteArrayOutputStream2.toByteArray());
    }

    public void removeCompressedThumbnail() {
        this.mData.setCompressedThumbnail(null);
    }

    public String getUserComment() {
        return this.mData.getUserComment();
    }

    public double[] getLatLongAsDoubles() {
        Rational[] rationalArray = ((ExifInterface)((Object)this_)).getTagRationalValues(TAG_GPS_LATITUDE);
        ExifInterface exifInterface = this_;
        String this_ = exifInterface.getTagStringValue(TAG_GPS_LATITUDE_REF);
        Rational[] rationalArray2 = exifInterface.getTagRationalValues(TAG_GPS_LONGITUDE);
        String string = exifInterface.getTagStringValue(TAG_GPS_LONGITUDE_REF);
        if (rationalArray != null && rationalArray2 != null && this_ != null && string != null && rationalArray.length >= 3 && rationalArray2.length >= 3) {
            double d = ExifInterface.convertLatOrLongToDouble(rationalArray, this_);
            double d2 = ExifInterface.convertLatOrLongToDouble(rationalArray2, string);
            return new double[]{d, d2};
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addDateTimeStampTag(int tagId, long timestamp, TimeZone timezone) {
        void var2_3;
        void var4_4;
        void var1_1;
        if (tagId != TAG_DATE_TIME && var1_1 != TAG_DATE_TIME_DIGITIZED && var1_1 != TAG_DATE_TIME_ORIGINAL) {
            return false;
        }
        ExifInterface exifInterface = this;
        exifInterface.mDateTimeStampFormat.setTimeZone((TimeZone)var4_4);
        ExifTag exifTag = this.buildTag((int)var1_1, exifInterface.mDateTimeStampFormat.format((long)var2_3));
        if (exifTag == null) {
            return false;
        }
        this.setTag(exifTag);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addGpsTags(double latitude, double longitude) {
        void var3_4;
        void var1_1;
        int n = TAG_GPS_LATITUDE;
        ExifTag exifTag = this.buildTag(n, ExifInterface.toExifLatLong((double)var1_1));
        int n2 = TAG_GPS_LONGITUDE;
        ExifTag exifTag2 = this.buildTag(n2, ExifInterface.toExifLatLong((double)var3_4));
        int n3 = TAG_GPS_LATITUDE_REF;
        String string = latitude >= 0.0 ? "N" : "S";
        ExifTag exifTag3 = this.buildTag(n3, string);
        int n4 = TAG_GPS_LONGITUDE_REF;
        String string2 = var3_4 >= 0.0 ? "E" : "W";
        ExifTag exifTag4 = this.buildTag(n4, string2);
        if (exifTag != null && exifTag2 != null && exifTag3 != null && exifTag4 != null) {
            ExifInterface exifInterface = this;
            exifInterface.setTag(exifTag);
            exifInterface.setTag(exifTag2);
            exifInterface.setTag(exifTag3);
            exifInterface.setTag(exifTag4);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addGpsDateTimeStampTag(long timestamp) {
        Rational rational;
        Rational rational2;
        Rational rational3;
        void var1_1;
        Object object = this.buildTag(TAG_GPS_DATE_STAMP, this.mGPSDateStampFormat.format((long)var1_1));
        if (object == null) {
            return false;
        }
        ExifInterface exifInterface = this;
        exifInterface.setTag((ExifTag)object);
        exifInterface.mGPSTimeStampCalendar.setTimeInMillis((long)var1_1);
        Object object2 = rational3;
        rational3 = new Rational(this.mGPSTimeStampCalendar.get(11), 1L);
        Rational rational4 = rational2;
        rational2 = new Rational(this.mGPSTimeStampCalendar.get(12), 1L);
        object = rational;
        rational = new Rational(this.mGPSTimeStampCalendar.get(13), 1L);
        object2 = exifInterface.buildTag(TAG_GPS_TIME_STAMP, new Rational[]{object2, rational4, object});
        if (object2 == null) {
            return false;
        }
        this.setTag((ExifTag)object2);
        return true;
    }

    public SparseIntArray getTagInfo() {
        if (this.mTagInfo == null) {
            SparseIntArray sparseIntArray;
            SparseIntArray sparseIntArray2 = sparseIntArray;
            sparseIntArray = new SparseIntArray();
            this.mTagInfo = sparseIntArray2;
            this.initTagInfo();
        }
        return this.mTagInfo;
    }

    public static interface Orientation {
        public static final short TOP_LEFT = 1;
        public static final short TOP_RIGHT = 2;
        public static final short BOTTOM_LEFT = 3;
        public static final short BOTTOM_RIGHT = 4;
        public static final short LEFT_TOP = 5;
        public static final short RIGHT_TOP = 6;
        public static final short LEFT_BOTTOM = 7;
        public static final short RIGHT_BOTTOM = 8;
    }

    public static interface GpsLatitudeRef {
        public static final String NORTH = "N";
        public static final String SOUTH = "S";
    }

    public static interface GpsLongitudeRef {
        public static final String EAST = "E";
        public static final String WEST = "W";
    }

    public static interface GpsDifferential {
        public static final short WITHOUT_DIFFERENTIAL_CORRECTION = 0;
        public static final short DIFFERENTIAL_CORRECTION_APPLIED = 1;
    }

    public static interface GpsTrackRef {
        public static final String TRUE_DIRECTION = "T";
        public static final String MAGNETIC_DIRECTION = "M";
    }

    public static interface GpsSpeedRef {
        public static final String KILOMETERS = "K";
        public static final String MILES = "M";
        public static final String KNOTS = "N";
    }

    public static interface GpsMeasureMode {
        public static final String MODE_2_DIMENSIONAL = "2";
        public static final String MODE_3_DIMENSIONAL = "3";
    }

    public static interface GpsStatus {
        public static final String IN_PROGRESS = "A";
        public static final String INTEROPERABILITY = "V";
    }

    public static interface GpsAltitudeRef {
        public static final short SEA_LEVEL = 0;
        public static final short SEA_LEVEL_NEGATIVE = 1;
    }

    public static interface SubjectDistance {
        public static final short UNKNOWN = 0;
        public static final short MACRO = 1;
        public static final short CLOSE_VIEW = 2;
        public static final short DISTANT_VIEW = 3;
    }

    public static interface Sharpness {
        public static final short NORMAL = 0;
        public static final short SOFT = 1;
        public static final short HARD = 2;
    }

    public static interface Saturation {
        public static final short NORMAL = 0;
        public static final short LOW = 1;
        public static final short HIGH = 2;
    }

    public static interface Contrast {
        public static final short NORMAL = 0;
        public static final short SOFT = 1;
        public static final short HARD = 2;
    }

    public static interface GainControl {
        public static final short NONE = 0;
        public static final short LOW_UP = 1;
        public static final short HIGH_UP = 2;
        public static final short LOW_DOWN = 3;
        public static final short HIGH_DOWN = 4;
    }

    public static interface SceneType {
        public static final short DIRECT_PHOTOGRAPHED = 1;
    }

    public static interface FileSource {
        public static final short DSC = 3;
    }

    public static interface SensingMethod {
        public static final short NOT_DEFINED = 1;
        public static final short ONE_CHIP_COLOR = 2;
        public static final short TWO_CHIP_COLOR = 3;
        public static final short THREE_CHIP_COLOR = 4;
        public static final short COLOR_SEQUENTIAL_AREA = 5;
        public static final short TRILINEAR = 7;
        public static final short COLOR_SEQUENTIAL_LINEAR = 8;
    }

    public static interface LightSource {
        public static final short UNKNOWN = 0;
        public static final short DAYLIGHT = 1;
        public static final short FLUORESCENT = 2;
        public static final short TUNGSTEN = 3;
        public static final short FLASH = 4;
        public static final short FINE_WEATHER = 9;
        public static final short CLOUDY_WEATHER = 10;
        public static final short SHADE = 11;
        public static final short DAYLIGHT_FLUORESCENT = 12;
        public static final short DAY_WHITE_FLUORESCENT = 13;
        public static final short COOL_WHITE_FLUORESCENT = 14;
        public static final short WHITE_FLUORESCENT = 15;
        public static final short STANDARD_LIGHT_A = 17;
        public static final short STANDARD_LIGHT_B = 18;
        public static final short STANDARD_LIGHT_C = 19;
        public static final short D55 = 20;
        public static final short D65 = 21;
        public static final short D75 = 22;
        public static final short D50 = 23;
        public static final short ISO_STUDIO_TUNGSTEN = 24;
        public static final short OTHER = 255;
    }

    public static interface ComponentsConfiguration {
        public static final short NOT_EXIST = 0;
        public static final short Y = 1;
        public static final short CB = 2;
        public static final short CR = 3;
        public static final short R = 4;
        public static final short G = 5;
        public static final short B = 6;
    }

    public static interface SceneCapture {
        public static final short STANDARD = 0;
        public static final short LANDSCAPE = 1;
        public static final short PROTRAIT = 2;
        public static final short NIGHT_SCENE = 3;
    }

    public static interface WhiteBalance {
        public static final short AUTO = 0;
        public static final short MANUAL = 1;
    }

    public static interface ExposureMode {
        public static final short AUTO_EXPOSURE = 0;
        public static final short MANUAL_EXPOSURE = 1;
        public static final short AUTO_BRACKET = 2;
    }

    public static interface ColorSpace {
        public static final short SRGB = 1;
        public static final short UNCALIBRATED = -1;
    }

    public static interface Flash {
        public static final short DID_NOT_FIRED = 0;
        public static final short FIRED = 1;
        public static final short RETURN_NO_STROBE_RETURN_DETECTION_FUNCTION = 0;
        public static final short RETURN_STROBE_RETURN_LIGHT_NOT_DETECTED = 4;
        public static final short RETURN_STROBE_RETURN_LIGHT_DETECTED = 6;
        public static final short MODE_UNKNOWN = 0;
        public static final short MODE_COMPULSORY_FLASH_FIRING = 8;
        public static final short MODE_COMPULSORY_FLASH_SUPPRESSION = 16;
        public static final short MODE_AUTO_MODE = 24;
        public static final short FUNCTION_PRESENT = 0;
        public static final short FUNCTION_NO_FUNCTION = 32;
        public static final short RED_EYE_REDUCTION_NO_OR_UNKNOWN = 0;
        public static final short RED_EYE_REDUCTION_SUPPORT = 64;
    }

    public static interface MeteringMode {
        public static final short UNKNOWN = 0;
        public static final short AVERAGE = 1;
        public static final short CENTER_WEIGHTED_AVERAGE = 2;
        public static final short SPOT = 3;
        public static final short MULTISPOT = 4;
        public static final short PATTERN = 5;
        public static final short PARTAIL = 6;
        public static final short OTHER = 255;
    }

    public static interface ExposureProgram {
        public static final short NOT_DEFINED = 0;
        public static final short MANUAL = 1;
        public static final short NORMAL_PROGRAM = 2;
        public static final short APERTURE_PRIORITY = 3;
        public static final short SHUTTER_PRIORITY = 4;
        public static final short CREATIVE_PROGRAM = 5;
        public static final short ACTION_PROGRAM = 6;
        public static final short PROTRAIT_MODE = 7;
        public static final short LANDSCAPE_MODE = 8;
    }

    public static interface PlanarConfiguration {
        public static final short CHUNKY = 1;
        public static final short PLANAR = 2;
    }

    public static interface PhotometricInterpretation {
        public static final short RGB = 2;
        public static final short YCBCR = 6;
    }

    public static interface ResolutionUnit {
        public static final short INCHES = 2;
        public static final short CENTIMETERS = 3;
    }

    public static interface Compression {
        public static final short UNCOMPRESSION = 1;
        public static final short JPEG = 6;
    }

    public static interface YCbCrPositioning {
        public static final short CENTERED = 1;
        public static final short CO_SITED = 2;
    }
}

