/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera.autosnapping;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import io.scanbot.sdk.camera.autosnapping.SignificantMoveListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lio/scanbot/sdk/camera/autosnapping/SignificantMoveCatcher;", "Landroid/hardware/SensorEventListener;", "Landroid/content/Context;", "context", "<init>", "(Landroid/content/Context;)V", "Lio/scanbot/sdk/camera/autosnapping/SignificantMoveListener;", "listener", "", "registerSignificantMoveListener", "(Lio/scanbot/sdk/camera/autosnapping/SignificantMoveListener;)V", "unregisterSignificantMoveListener", "Landroid/hardware/SensorEvent;", "event", "onSensorChanged", "(Landroid/hardware/SensorEvent;)V", "Landroid/hardware/Sensor;", "sensor", "", "accuracy", "onAccuracyChanged", "(Landroid/hardware/Sensor;I)V", "sdk-camera_release"}, xi=48)
public final class SignificantMoveCatcher
implements SensorEventListener {
    public final SensorManager hqi;
    public final Sensor hqu;
    public float hqt;
    public float hqy;
    public float hqa;
    public SignificantMoveListener hqm;

    /*
     * WARNING - void declaration
     */
    public SignificantMoveCatcher(@NotNull Context context) {
        void var1_1;
        SignificantMoveCatcher significantMoveCatcher = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Object object = var1_1.getSystemService("sensor");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.SensorManager");
        this.hqi = (SensorManager)object;
        significantMoveCatcher.hqu = this.hqi.getDefaultSensor(1);
        significantMoveCatcher.hqt = 0.0f;
        significantMoveCatcher.hqy = 9.80665f;
        significantMoveCatcher.hqa = 9.80665f;
    }

    public final void registerSignificantMoveListener(@Nullable SignificantMoveListener listener2) {
        Sensor sensor;
        if (listener2 != null && this.hqm != sensor) {
            SensorManager sensorManager;
            this.hqm = sensor;
            sensor = this.hqu;
            if (sensor != null && (sensorManager = this.hqi) != null) {
                sensorManager.registerListener((SensorEventListener)this, sensor, 2);
                return;
            }
        }
    }

    public final void unregisterSignificantMoveListener(@Nullable SignificantMoveListener listener2) {
        this.hqm = null;
        SensorManager sensorManager = this.hqi;
        if (sensorManager != null) {
            sensorManager.unregisterListener((SensorEventListener)this);
            return;
        }
    }

    public void onSensorChanged(@NotNull SensorEvent event) {
        SensorEvent sensorEvent = event;
        Intrinsics.checkNotNullParameter((Object)sensorEvent, (String)"event");
        if (sensorEvent.sensor.getType() == 1) {
            float[] fArray;
            SignificantMoveCatcher significantMoveCatcher = this;
            fArray = (float[])fArray.values.clone();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = f;
            float f4 = fArray[2];
            this.hqa = this.hqy;
            f = f3 * f3;
            float f5 = f4;
            this.hqy = f4 = (float)Math.sqrt((double)(f2 * f2 + f) + (double)(f5 * f5));
            float f6 = f4 - this.hqa;
            significantMoveCatcher.hqt = f6 = significantMoveCatcher.hqt * 0.9f + f6;
            SignificantMoveListener significantMoveListener = significantMoveCatcher.hqm;
            if (significantMoveListener != null && f6 > significantMoveListener.getMoveThreshold()) {
                significantMoveListener.onSignificantMove();
                return;
            }
        }
    }

    public void onAccuracyChanged(@NotNull Sensor sensor, int accuracy) {
        Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
    }
}

