/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Build;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.DynamicRangeResolver;
import androidx.camera.camera2.internal.GuaranteedConfigurationsUtil;
import androidx.camera.camera2.internal.StreamUseCaseUtil;
import androidx.camera.camera2.internal.SupportedSurfaceCombination;
import androidx.camera.camera2.internal.VideoStabilizationUtil;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.compat.workaround.ExtraSupportedSurfaceCombinationsContainer;
import androidx.camera.camera2.internal.compat.workaround.ResolutionCorrector;
import androidx.camera.camera2.internal.compat.workaround.TargetAspectRatio;
import androidx.camera.camera2.internal.ybt;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraMode;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceCombination;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.AspectRatioUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ybu {
    public final ArrayList ybd;
    public final ArrayList ybt;
    public final ArrayList ybu;
    public final ArrayList ybh;
    public final HashMap ybm;
    public final ArrayList ybz;
    public final ArrayList ybr;
    public final ArrayList ybo;
    public final String ybq;
    public final CamcorderProfileHelper ybl;
    public final CameraCharacteristicsCompat ybx;
    public final ExtraSupportedSurfaceCombinationsContainer yby;
    public final int yba;
    public final boolean ybv;
    public final boolean ybi;
    public final boolean ybn;
    public final boolean ybc;
    public final boolean ybf;
    public SurfaceSizeDefinition ybj;
    public final ArrayList ybs;
    public final DisplayInfoManager ybw;
    public final TargetAspectRatio ybg;
    public final ResolutionCorrector ybk;
    public final DynamicRangeResolver ybp;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ybu(Context object, String object2, CameraManagerCompat object3, CamcorderProfileHelper camcorderProfileHelper) {
        DynamicRangeResolver dynamicRangeResolver;
        int n;
        ExtraSupportedSurfaceCombinationsContainer extraSupportedSurfaceCombinationsContainer;
        ResolutionCorrector resolutionCorrector;
        TargetAspectRatio targetAspectRatio;
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayList arrayList4;
        HashMap hashMap;
        ArrayList arrayList5;
        ArrayList arrayList6;
        ArrayList arrayList7;
        ArrayList arrayList8;
        CameraManagerCompat cameraManagerCompat = object3;
        String string = object2;
        object2 = arrayList8;
        arrayList8 = new ArrayList();
        this.ybd = object2;
        object2 = arrayList7;
        arrayList7 = new ArrayList();
        this.ybt = object2;
        object2 = arrayList6;
        arrayList6 = new ArrayList();
        this.ybu = object2;
        object2 = arrayList5;
        arrayList5 = new ArrayList();
        this.ybh = object2;
        object2 = hashMap;
        hashMap = new HashMap();
        this.ybm = object2;
        object2 = arrayList4;
        arrayList4 = new ArrayList();
        this.ybz = object2;
        object2 = arrayList3;
        arrayList3 = new ArrayList();
        this.ybr = object2;
        object2 = arrayList2;
        arrayList2 = new ArrayList();
        this.ybo = object2;
        this.ybv = false;
        this.ybi = false;
        this.ybn = false;
        this.ybc = false;
        this.ybf = false;
        object2 = arrayList;
        arrayList = new ArrayList();
        this.ybs = object2;
        object2 = targetAspectRatio;
        targetAspectRatio = new TargetAspectRatio();
        this.ybg = object2;
        object2 = resolutionCorrector;
        resolutionCorrector = new ResolutionCorrector();
        this.ybk = object2;
        this.ybq = object2 = (String)Preconditions.checkNotNull((Object)string);
        this.ybl = (CamcorderProfileHelper)Preconditions.checkNotNull((Object)camcorderProfileHelper);
        object3 = extraSupportedSurfaceCombinationsContainer;
        extraSupportedSurfaceCombinationsContainer = new ExtraSupportedSurfaceCombinationsContainer();
        this.yby = object3;
        object3 = DisplayInfoManager.getInstance((Context)object);
        this.ybw = object3;
        try {
            object2 = cameraManagerCompat.getCameraCharacteristicsCompat((String)object2);
        }
        catch (CameraAccessExceptionCompat cameraAccessExceptionCompat) {
            throw CameraUnavailableExceptionHelper.createFrom((CameraAccessExceptionCompat)cameraAccessExceptionCompat);
        }
        {
            this.ybx = object2;
            object3 = (Integer)object2.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            n = object3 != null ? (Integer)object3 : 2;
        }
        this.yba = n;
        int[] nArray = (int[])object2.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        object2 = nArray;
        if (nArray != null) {
            for (Object object4 : object2) {
                if (object4 == 3) {
                    this.ybv = true;
                    continue;
                }
                if (object4 == 6) {
                    this.ybi = true;
                    continue;
                }
                if (Build.VERSION.SDK_INT < 31 || object4 != 16) continue;
                this.ybf = true;
            }
        }
        object2 = dynamicRangeResolver;
        dynamicRangeResolver = new DynamicRangeResolver(this.ybx);
        this.ybp = object2;
        this.ybd.addAll(GuaranteedConfigurationsUtil.generateSupportedCombinationList((int)this.yba, (boolean)this.ybv, (boolean)this.ybi));
        this.ybd.addAll(this.yby.get(this.ybq));
        if (this.ybf) {
            this.ybt.addAll(GuaranteedConfigurationsUtil.getUltraHighResolutionSupportedCombinationList());
        }
        if (this.ybn = object.getPackageManager().hasSystemFeature("android.hardware.camera.concurrent")) {
            this.ybu.addAll(GuaranteedConfigurationsUtil.getConcurrentSupportedCombinationList());
        }
        if (object2.is10BitDynamicRangeSupported()) {
            this.ybz.addAll(GuaranteedConfigurationsUtil.get10BitSupportedCombinationList());
        }
        int[] nArray2 = this.ybx.getStreamConfigurationMapCompat().getOutputFormats();
        object = nArray2;
        if (nArray2 != null) {
            int n2 = ((Context)object).length;
            for (n = 0; n < n2; ++n) {
                if (object[n] != 4101) continue;
                this.ybr.addAll(GuaranteedConfigurationsUtil.getUltraHdrSupportedCombinationList());
                break;
            }
        }
        this.ybc = StreamUseCaseUtil.isStreamUseCaseSupported((CameraCharacteristicsCompat)this.ybx);
        if (this.ybc && Build.VERSION.SDK_INT >= 33) {
            this.ybo.addAll(GuaranteedConfigurationsUtil.getStreamUseCaseSupportedCombinationList());
        }
        if (VideoStabilizationUtil.isPreviewStabilizationSupported((CameraCharacteristicsCompat)this.ybx) && Build.VERSION.SDK_INT >= 33) {
            this.ybh.addAll(GuaranteedConfigurationsUtil.getPreviewStabilizationSupportedCombinationList());
        }
        this.ybd();
    }

    public static int ybd(CameraCharacteristicsCompat cameraCharacteristicsCompat, int n, Size size) {
        int n2 = 0;
        try {
            return (int)(1.0E9 / (double)((StreamConfigurationMap)cameraCharacteristicsCompat.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputMinFrameDuration(n, size));
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public static int ybd(Range range) {
        return (Integer)range.getUpper() - (Integer)range.getLower() + 1;
    }

    public static int ybd(Range range, Range range2) {
        Preconditions.checkState((!range.contains((Comparable)((Integer)range2.getUpper())) && !range.contains((Comparable)((Integer)range2.getLower())) ? 1 : 0) != 0, (String)"Ranges must not intersect");
        if ((Integer)range.getLower() > (Integer)range2.getUpper()) {
            return (Integer)range.getLower() - (Integer)range2.getUpper();
        }
        return (Integer)range2.getLower() - (Integer)range.getUpper();
    }

    public static Size ybd(StreamConfigurationMap sizeArray, int n, boolean bl) {
        Object object = n == 34 ? sizeArray.getOutputSizes(SurfaceTexture.class) : sizeArray.getOutputSizes(n);
        if (object != null && ((Size[])object).length != 0) {
            CompareSizesByArea compareSizesByArea;
            CompareSizesByArea compareSizesByArea2 = object;
            object = compareSizesByArea;
            compareSizesByArea = new CompareSizesByArea();
            Size size = (Size)Collections.max(Arrays.asList(compareSizesByArea2), object);
            Size size2 = SizeUtil.RESOLUTION_ZERO;
            if (Build.VERSION.SDK_INT >= 23 && bl && (sizeArray = androidx.camera.camera2.internal.ybt.ybd((StreamConfigurationMap)sizeArray, n)) != null && sizeArray.length > 0) {
                size2 = Collections.max(Arrays.asList(sizeArray), object);
            }
            return Collections.max(Arrays.asList(size, size2), object);
        }
        return null;
    }

    public final void ybd() {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap hashMap3;
        Size size;
        Size size2;
        int n;
        Size size3;
        ybu ybu2 = hashMap4;
        Size size4 = size3;
        size3 = new Size(1280, 720);
        try {
            n = Integer.parseInt(ybu2.ybq);
            size2 = null;
        }
        catch (NumberFormatException numberFormatException) {
            CompareSizesByArea compareSizesByArea;
            size = ((ybu)((Object)hashMap4)).ybx.getStreamConfigurationMapCompat().toStreamConfigurationMap().getOutputSizes(MediaRecorder.class);
            if (size == null) {
                size = SizeUtil.RESOLUTION_480P;
            }
            Size size5 = size;
            CompareSizesByArea compareSizesByArea2 = compareSizesByArea;
            compareSizesByArea = new CompareSizesByArea(true);
            Arrays.sort(size5, compareSizesByArea2);
            int n2 = ((Size)size5).length;
            for (int i = 0; i < n2; ++i) {
                Size size6 = size[i];
                Size size7 = SizeUtil.RESOLUTION_1080P;
                if (size6.getWidth() > size7.getWidth() || size6.getHeight() > size7.getHeight()) continue;
                size = size6;
            }
            size = SizeUtil.RESOLUTION_480P;
        }
        if (ybu2.ybl.hasProfile(n, 1)) {
            size2 = ((ybu)((Object)hashMap4)).ybl.get(n, 1);
        }
        if (size2 != null) {
            Size size8;
            size = size8;
            Size size9 = size2;
            int n3 = size9.videoFrameWidth;
            size8 = new Size(n3, size9.videoFrameHeight);
        } else {
            size2 = SizeUtil.RESOLUTION_480P;
            CamcorderProfile camcorderProfile = null;
            if (((ybu)((Object)hashMap4)).ybl.hasProfile(n, 10)) {
                camcorderProfile = ((ybu)((Object)hashMap4)).ybl.get(n, 10);
            } else if (((ybu)((Object)hashMap4)).ybl.hasProfile(n, 8)) {
                camcorderProfile = ((ybu)((Object)hashMap4)).ybl.get(n, 8);
            } else if (((ybu)((Object)hashMap4)).ybl.hasProfile(n, 12)) {
                camcorderProfile = ((ybu)((Object)hashMap4)).ybl.get(n, 12);
            } else if (((ybu)((Object)hashMap4)).ybl.hasProfile(n, 6)) {
                camcorderProfile = ((ybu)((Object)hashMap4)).ybl.get(n, 6);
            } else if (((ybu)((Object)hashMap4)).ybl.hasProfile(n, 5)) {
                camcorderProfile = ((ybu)((Object)hashMap4)).ybl.get(n, 5);
            } else if (((ybu)((Object)hashMap4)).ybl.hasProfile(n, 4)) {
                camcorderProfile = ((ybu)((Object)hashMap4)).ybl.get(n, 4);
            }
            if (camcorderProfile != null) {
                Size size10;
                size = size10;
                CamcorderProfile camcorderProfile2 = camcorderProfile;
                int n4 = camcorderProfile2.videoFrameWidth;
                size10 = new Size(n4, camcorderProfile2.videoFrameHeight);
            } else {
                size = size2;
            }
        }
        ybu ybu3 = hashMap4;
        HashMap hashMap4 = hashMap3;
        hashMap3 = new HashMap();
        HashMap hashMap5 = hashMap2;
        hashMap2 = new HashMap();
        HashMap hashMap6 = hashMap;
        hashMap = new HashMap();
        ybu3.ybj = SurfaceSizeDefinition.create((Size)SizeUtil.RESOLUTION_VGA, new HashMap(), (Size)size4, (Map)hashMap4, (Size)size, hashMap5, hashMap6);
    }

    public final boolean ybd(SupportedSurfaceCombination.FeatureSettings featureSettings, List list) {
        Object object;
        boolean bl = false;
        if (((ybu)object).ybm.containsKey(featureSettings)) {
            object = (List)((ybu)object).ybm.get(featureSettings);
        } else {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            if (featureSettings.isUltraHdrOn()) {
                if (featureSettings.getCameraMode() == 0) {
                    arrayList2.addAll(((ybu)object).ybr);
                }
            } else if (featureSettings.getRequiredMaxBitDepth() == 8) {
                int n = featureSettings.getCameraMode();
                if (n != 1) {
                    if (n != 2) {
                        ArrayList arrayList3 = featureSettings.isPreviewStabilizationOn() ? ((ybu)object).ybh : ((ybu)object).ybd;
                        arrayList2.addAll(arrayList3);
                    } else {
                        arrayList2.addAll(((ybu)object).ybt);
                        arrayList2.addAll(((ybu)object).ybd);
                    }
                } else {
                    arrayList2 = ((ybu)object).ybu;
                }
            } else if (featureSettings.getRequiredMaxBitDepth() == 10 && featureSettings.getCameraMode() == 0) {
                arrayList2.addAll(((ybu)object).ybz);
            }
            ((ybu)object).ybm.put(featureSettings, arrayList2);
            object = arrayList2;
        }
        object = object.iterator();
        while (object.hasNext()) {
            boolean bl2;
            bl = ((SurfaceCombination)object.next()).getOrderedSupportedSurfaceConfigList(list) != null ? (bl2 = true) : (bl2 = false);
            if (!bl) continue;
            return bl;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final Pair ybd(int var1_1, List var2_6, Map var3_7, boolean var4_8, boolean var5_11) {
        block93: {
            block94: {
                block95: {
                    block92: {
                        block96: {
                            block87: {
                                block86: {
                                    this.ybw.refresh();
                                    if (this.ybj == null) {
                                        this.ybd();
                                    } else {
                                        var6_12 = v0;
                                        v0 = new Size(1280, 720);
                                        v1 /* !! */  = var6_12;
                                        var6_12 = this.ybj.getS1440pSizeMap();
                                        var7_13 = this.ybj.getMaximumSizeMap();
                                        var8_14 = this.ybj.getUltraMaximumSizeMap();
                                        this.ybj = SurfaceSizeDefinition.create((Size)this.ybj.getAnalysisSize(), (Map)this.ybj.getS720pSizeMap(), (Size)v1 /* !! */ , (Map)var6_12, (Size)this.ybj.getRecordSize(), (Map)var7_13, (Map)var8_14);
                                    }
                                    var6_12 = v2;
                                    var7_13 = v3;
                                    v3 = new ArrayList<E>();
                                    var8_14 = v4;
                                    v4 = new ArrayList<E>();
                                    var10_22 = new ArrayList<K>(var3_7.keySet()).size();
                                    for (var9_15 = 0; var9_15 < var10_22; ++var9_15) {
                                        v5 = var6_12.get(var9_15);
                                        var11_28 = ((UseCaseConfig)v5).getSurfaceOccupancyPriority(0);
                                        if (var8_14.contains(var11_28)) continue;
                                        var8_14.add(var11_28);
                                    }
                                    v6 = var8_14;
                                    Collections.sort(v6);
                                    Collections.reverse(v6);
                                    var9_15 = 0;
                                    var10_22 = v6.size();
                                    while (var9_15 < var10_22) {
                                        v7 = var8_14.get(var9_15);
                                        ++var9_15;
                                        var11_28 = (Integer)v7;
                                        var13_44 = var6_12.size();
                                        for (var12_34 = 0; var12_34 < var13_44; ++var12_34) {
                                            v8 = var6_12.get(var12_34);
                                            var14_50 = (UseCaseConfig)v8;
                                            if (var11_28 != var14_50.getSurfaceOccupancyPriority(0)) continue;
                                            var7_13.add(var6_12.indexOf(var14_50));
                                        }
                                    }
                                    var8_14 = this.ybp.resolveAndValidateDynamicRanges((List)var2_6, (List)var6_12, (List)var7_13);
                                    var9_16 = var2_6.iterator();
                                    while (var9_16.hasNext()) {
                                        if (((AttachedSurfaceInfo)var9_16.next()).getImageFormat() != 4101) continue;
lbl47:
                                        // 2 sources

                                        while (true) {
                                            var9_17 = true;
                                            break block86;
                                            break;
                                        }
                                    }
                                    var9_16 = var3_7.keySet().iterator();
                                    while (var9_16.hasNext()) {
                                        if (((UseCaseConfig)var9_16.next()).getInputFormat() != 4101) continue;
                                        ** continue;
lbl54:
                                        // 1 sources

                                        ** GOTO lbl47
                                    }
                                    var9_17 = false;
                                }
                                var10_23 = var8_14.values().iterator();
                                while (var10_23.hasNext()) {
                                    if (((DynamicRange)var10_23.next()).getBitDepth() != 10) continue;
                                    var10_24 = 10;
                                    break block87;
                                }
                                var10_24 = 8;
                            }
                            if (var1_1 != 0 && var9_17) {
                                this = this.ybq;
                                var1_2 = CameraMode.toLabelString((int)var1_1);
                                v9 = var2_6 = v10;
                                var2_6("Camera device id is ");
                                v9.append((String)this);
                                v9.append(". Ultra HDR is not currently supported in ");
                                v10.append(var1_2);
                                v10.append(" camera mode.");
                                throw new IllegalArgumentException(v10.toString());
                            }
                            if (var1_1 != 0 && var10_24 == 10) {
                                this = this.ybq;
                                var1_3 = CameraMode.toLabelString((int)var1_1);
                                v11 = var2_6 = v12;
                                var2_6("Camera device id is ");
                                v11.append((String)this);
                                v11.append(". 10 bit dynamic range is not currently supported in ");
                                v12.append(var1_3);
                                v12.append(" camera mode.");
                                throw new IllegalArgumentException(v12.toString());
                            }
                            var4_9 = SupportedSurfaceCombination.FeatureSettings.of((int)var1_1, (int)var10_24, (boolean)var4_8, (boolean)var9_17);
                            var9_18 = v13;
                            v13 = new ArrayList<SurfaceConfig>();
                            var10_25 = var2_6.iterator();
                            while (var10_25.hasNext()) {
                                var9_18.add(((AttachedSurfaceInfo)var10_25.next()).getSurfaceConfig());
                            }
                            var10_25 = v14;
                            v14 = new CompareSizesByArea();
                            for (UseCaseConfig var12_36 : var3_7.keySet()) {
                                var13_45 = (List)var3_7.get(var12_36);
                                var14_51 = var13_45 != null && var13_45.isEmpty() == false;
                                v15 = var12_36;
                                Preconditions.checkArgument((boolean)var14_51, (Object)("No available output size is found for " + var12_36 + "."));
                                var12_36 = (Size)Collections.min(var13_45, var10_25);
                                var13_44 = v15.getInputFormat();
                                var9_18.add(SurfaceConfig.transformSurfaceConfig((int)var4_9.getCameraMode(), (int)var13_44, (Size)var12_36, (SurfaceSizeDefinition)this.ybd(var13_44)));
                            }
                            var9_19 = this.ybd((SupportedSurfaceCombination.FeatureSettings)var4_9, var9_18);
                            if (!var9_19) break block93;
                            var10_25 = null;
                            var11_29 = var2_6.iterator();
                            while (var11_29.hasNext()) {
                                var12_37 = ((AttachedSurfaceInfo)var11_29.next()).getTargetFrameRate();
                                if (var10_25 == null) {
                                    var10_25 = var12_37;
                                    continue;
                                }
                                if (var12_37 == null) continue;
                                try {
                                    var10_25 = var10_25.intersect(var12_37);
                                }
                                catch (IllegalArgumentException v16) {}
                            }
                            var11_30 = 0;
                            var12_38 = var7_13.size();
                            while (var11_30 < var12_38) {
                                v17 = var7_13.get(var11_30);
                                ++var11_30;
                                var13_46 = ((UseCaseConfig)var6_12.get((Integer)v17)).getTargetFrameRate(null);
                                if (var10_25 == null) {
                                    var10_25 = var13_46;
                                    continue;
                                }
                                if (var13_46 == null) continue;
                                try {
                                    var10_25 = var10_25.intersect(var13_46);
                                }
                                catch (IllegalArgumentException v18) {}
                            }
                            var11_31 = v19;
                            v19 = new HashMap<UseCaseConfig, ArrayList<E>>();
                            for (UseCaseConfig var13_47 : var3_7.keySet()) {
                                var14_52 = v20;
                                v20 = new ArrayList<Object>();
                                var15_57 = v21;
                                v21 = new HashMap<SurfaceConfig.ConfigSize, Object>();
                                for (Object var17_64 : (List)var3_7.get(var13_47)) {
                                    var18_69 = var13_47.getInputFormat();
                                    var19_71 = SurfaceConfig.transformSurfaceConfig((int)var4_9.getCameraMode(), (int)var18_69, (Size)var17_64, (SurfaceSizeDefinition)this.ybd(var18_69)).getConfigSize();
                                    var20_73 = 0x7FFFFFFF;
                                    if (var10_25 != null) {
                                        var20_73 = androidx.camera.camera2.internal.ybu.ybd(this.ybx, var18_69, (Size)var17_64);
                                    }
                                    if ((var18_68 = (Set)var15_57.get(var19_71)) == null) {
                                        var18_68 = v22;
                                        v22 = new HashSet<E>();
                                        var15_57.put(var19_71, var18_68);
                                    }
                                    if (var18_68.contains(var20_73)) continue;
                                    var14_52.add(var17_64);
                                    var18_68.add(var20_73);
                                }
                                var11_31.put(var13_47, var14_52);
                            }
                            var3_7 = v23;
                            v23 = new ArrayList<E>();
                            var12_40 = 0;
                            var13_48 = var7_13.size();
                            while (var12_40 < var13_48) {
                                v24 = var7_13.get(var12_40);
                                ++var12_40;
                                v25 = (UseCaseConfig)var6_12.get((Integer)v24);
                                var14_53 = (List)var11_31.get(v25);
                                var15_58 = v25.getInputFormat();
                                var16_61 = null;
                                switch (this.ybg.get(this.ybq, this.ybx)) {
                                    default: {
                                        break;
                                    }
                                    case 3: {
                                        var16_61 = null;
                                        break;
                                    }
                                    case 2: {
                                        var16_61 = this.ybd(256).getMaximumSize(256);
                                        var17_64 = v26;
                                        v27 = var16_61;
                                        var16_62 = v27.getWidth();
                                        v26 = new Rational(var16_62, v27.getHeight());
                                        var16_61 = var17_64;
                                        break;
                                    }
                                    case 1: {
                                        var16_61 = AspectRatioUtil.ASPECT_RATIO_16_9;
                                        break;
                                    }
                                    case 0: {
                                        var16_61 = AspectRatioUtil.ASPECT_RATIO_4_3;
                                    }
                                }
                                if (var16_61 != null) {
                                    v28 = var14_53;
                                    var14_53 = v29;
                                    v29 = new ArrayList<E>();
                                    var17_64 = v30;
                                    v30 = new ArrayList<E>();
                                    for (SurfaceConfig.ConfigSize var19_71 : v28) {
                                        if (AspectRatioUtil.hasMatchingAspectRatio((Size)var19_71, (Rational)var16_61)) {
                                            var14_53.add(var19_71);
                                            continue;
                                        }
                                        var17_64.add(var19_71);
                                    }
                                    var17_64.addAll(0, var14_53);
                                    var14_53 = var17_64;
                                }
                                var3_7.add(this.ybk.insertOrPrioritize(SurfaceConfig.getConfigType((int)var15_58), (List)var14_53));
                            }
                            var11_32 = 1;
                            var13_48 = var3_7.size();
                            for (var12_40 = 0; var12_40 < var13_48; ++var12_40) {
                                v31 = var3_7.get(var12_40);
                                var11_32 = ((List)v31).size() * var11_32;
                            }
                            if (var11_32 == 0) break block94;
                            var12_41 = v32;
                            v32 = new ArrayList<ArrayList<E>>();
                            for (var13_48 = 0; var13_48 < var11_32; ++var13_48) {
                                var14_54 = v33;
                                v33 = new ArrayList<E>();
                                var12_41.add(var14_54);
                            }
                            var13_48 = var11_32 / ((List)var3_7.get(0)).size();
                            var15_59 = var11_32;
                            for (var14_55 = 0; var14_55 < var3_7.size(); ++var14_55) {
                                var16_61 = (List)var3_7.get(var14_55);
                                for (var17_65 = 0; var17_65 < var11_32; ++var17_65) {
                                    ((List)var12_41.get(var17_65)).add((Size)var16_61.get(var17_65 % var15_59 / var13_48));
                                }
                                if (var14_55 < var3_7.size() - 1) {
                                    var15_59 = var13_48 / ((List)var3_7.get(var14_55 + 1)).size();
                                } else {
                                    v34 = var15_59;
                                    var15_59 = var13_48;
                                    var13_48 = v34;
                                }
                                v35 = var13_48;
                                var13_48 = var15_59;
                                var15_59 = v35;
                            }
                            v36 = var2_6;
                            var3_7 = v37;
                            v37 = new HashMap<K, V>();
                            var11_33 = v38;
                            v38 = new HashMap<UseCaseConfig, StreamSpec>();
                            var13_49 = v39;
                            v39 = new HashMap<K, V>();
                            var14_56 = v40;
                            v40 = new HashMap<K, V>();
                            var15_60 = null;
                            var16_63 = 0x7FFFFFFF;
                            var17_66 = null;
                            var18_70 = 0x7FFFFFFF;
                            var19_72 = StreamUseCaseUtil.containsZslUseCase((List)v36, (List)var6_12);
                            var20_74 = null;
                            var21_75 = 0x7FFFFFFF;
                            var22_77 = v36.iterator();
                            while (var22_77.hasNext()) {
                                v41 = var21_75;
                                v42 = (AttachedSurfaceInfo)var22_77.next();
                                var21_75 = v42.getImageFormat();
                                var23_82 = v42.getSize();
                                var21_75 = Math.min(v41, androidx.camera.camera2.internal.ybu.ybd(this.ybx, var21_75, (Size)var23_82));
                            }
                            if (this.ybc && var19_72 == 0) {
                                var19_72 = 0;
                                var22_78 = var12_41.size();
                                while (var19_72 < var22_78) {
                                    v43 = var12_41.get(var19_72);
                                    ++var19_72;
                                    var20_74 = (List)v43;
                                    var20_74 = (List)this.ybd((int)var1_1, (List)var2_6, (List)var20_74, (ArrayList)var6_12, (ArrayList)var7_13, (int)var21_75, var13_49, var14_56).first;
                                    if (!StreamUseCaseUtil.shouldUseStreamUseCase((SupportedSurfaceCombination.FeatureSettings)var4_9)) {
                                        while (true) {
                                            var20_74 = null;
                                            break;
                                        }
                                    } else {
                                        var23_82 = this.ybo;
                                        var24_84 = 0;
                                        var25_88 = var23_82.size();
                                        do {
                                            if (var24_84 >= var25_88) ** continue;
                                            v44 = var23_82.get(var24_84);
                                            ++var24_84;
                                        } while ((var26_90 = ((SurfaceCombination)v44).getOrderedSupportedSurfaceConfigList(var20_74)) == null);
                                        var20_74 = var26_90;
                                    }
                                    if (var20_74 != null && !StreamUseCaseUtil.areCaptureTypesEligible(var13_49, var14_56, (List)var20_74)) {
                                        var20_74 = null;
                                    }
                                    if (var20_74 != null) {
                                        if (StreamUseCaseUtil.areStreamUseCasesAvailableForSurfaceConfigs((CameraCharacteristicsCompat)this.ybx, (List)var20_74)) break;
                                        var20_74 = null;
                                    }
                                    var13_49.clear();
                                    var14_56.clear();
                                }
                                if (var20_74 == null && !var9_19) {
                                    throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.ybq + ".  May be attempting to bind too many use cases. Existing surfaces: " + var2_6 + " New configs: " + var6_12);
                                }
                            }
                            var9_19 = false;
                            var19_72 = 0;
                            var22_79 = 0;
                            var23_83 = var12_41.size();
                            while (var22_79 < var23_83) {
                                v45 = var12_41.get(var22_79);
                                ++var22_79;
                                var24_86 = (List)v45;
                                v46 = this.ybd(var1_1, (List)var2_6, var24_86, (ArrayList)var6_12, (ArrayList)var7_13, var21_75, null, null);
                                var25_89 = (List)v46.first;
                                var26_91 = (Integer)v46.second;
                                var27_93 = true;
                                if (var10_25 != null && var21_75 > var26_91 && var26_91 < (Integer)var10_25.getLower()) {
                                    var27_93 = false;
                                }
                                if (!var9_19 && this.ybd((SupportedSurfaceCombination.FeatureSettings)var4_9, var25_89)) {
                                    if (var16_63 == 0x7FFFFFFF || var16_63 < var26_91) {
                                        var15_60 = var24_86;
                                        var16_63 = var26_91;
                                    }
                                    if (var27_93) {
                                        var9_19 = true;
                                        if (var19_72 != 0) {
                                            var16_63 = var26_91;
                                            var15_60 = var24_86;
                                            break;
                                        }
                                        var15_60 = var24_86;
                                        var16_63 = var26_91;
                                    }
                                }
                                if (var20_74 == null || var19_72 != 0) continue;
                                if (!StreamUseCaseUtil.shouldUseStreamUseCase((SupportedSurfaceCombination.FeatureSettings)var4_9)) {
                                    while (true) {
                                        var25_89 = null;
                                        break;
                                    }
                                } else {
                                    var28_94 = this.ybo;
                                    var29_96 = 0;
                                    var30_97 = var28_94.size();
                                    do {
                                        if (var29_96 >= var30_97) ** continue;
                                        v47 = var28_94.get(var29_96);
                                        ++var29_96;
                                    } while ((var31_98 = ((SurfaceCombination)v47).getOrderedSupportedSurfaceConfigList(var25_89)) == null);
                                    var25_89 = var31_98;
                                }
                                if (var25_89 == null) continue;
                                if (var18_70 == 0x7FFFFFFF || var18_70 < var26_91) {
                                    var17_66 = var24_86;
                                    var18_70 = var26_91;
                                }
                                if (!var27_93) continue;
                                var17_67 = 1;
                                if (var9_19) {
                                    var17_66 = var24_86;
                                    var18_70 = var26_91;
                                    break;
                                }
                                var17_66 = var24_86;
                                var18_70 = var26_91;
                                var19_72 = var17_67;
                            }
                            if (var15_60 == null) break block95;
                            var1_4 = null;
                            if (var10_25 == null || var10_25.equals((Object)(var1_4 = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) || (var4_9 = (Range[])this.ybx.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES)) == null) break block96;
                            var9_20 = v48;
                            v48 = new Range((Comparable)Integer.valueOf(Math.min((Integer)var10_25.getLower(), var16_63)), (Comparable)Integer.valueOf(Math.min((Integer)var10_25.getUpper(), var16_63)));
                            var10_26 = 0;
                            for (Range var21_76 : var4_9) {
                                block88: {
                                    block89: {
                                        block90: {
                                            block91: {
                                                block98: {
                                                    block97: {
                                                        if (var16_63 < (Integer)var21_76.getLower()) continue;
                                                        if (var1_4.equals((Object)StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
                                                            var1_4 = var21_76;
                                                        }
                                                        if (var21_76.equals((Object)var9_20)) {
                                                            var1_4 = var21_76;
                                                            break;
                                                        }
                                                        var22_80 = androidx.camera.camera2.internal.ybu.ybd(var21_76.intersect(var9_20));
                                                        if (var10_26 == 0) {
                                                            var10_26 = var22_80;
                                                            break block88;
                                                        }
                                                        if (var22_80 < var10_26) break block89;
                                                        v49 = var21_76;
                                                        v50 = var9_20;
                                                        var22_81 = androidx.camera.camera2.internal.ybu.ybd(var1_4.intersect(var9_20));
                                                        var24_87 = androidx.camera.camera2.internal.ybu.ybd(v49.intersect(v50));
                                                        v51 = var22_81;
                                                        v52 = v51;
                                                        v53 = v51;
                                                        v54 = var1_4;
                                                        var26_92 = var24_87 / (double)androidx.camera.camera2.internal.ybu.ybd(var21_76);
                                                        var28_95 = v52 / (double)androidx.camera.camera2.internal.ybu.ybd(v54);
                                                        if (!(v55 > v53)) break block97;
                                                        if (!(var26_92 >= 0.5) && !(var26_92 >= var28_95)) break block90;
                                                        break block91;
                                                    }
                                                    if (var24_87 != var22_81) break block98;
                                                    if (var26_92 > var28_95) break block91;
                                                    if (var26_92 != var28_95) break block90;
                                                    if ((Integer)var21_76.getLower() <= (Integer)var1_4.getLower()) break block90;
                                                    break block91;
                                                }
                                                if (!(var28_95 < 0.5) || !(var26_92 > var28_95)) break block90;
                                            }
                                            var1_4 = var21_76;
                                        }
                                        try {
                                            var10_26 = androidx.camera.camera2.internal.ybu.ybd(var9_20.intersect(var1_4));
                                        }
                                        catch (IllegalArgumentException v56) {
                                            if (var10_26 != 0 || androidx.camera.camera2.internal.ybu.ybd(var21_76, var9_20) >= androidx.camera.camera2.internal.ybu.ybd(var1_4, var9_20) && (androidx.camera.camera2.internal.ybu.ybd(var21_76, var9_20) != androidx.camera.camera2.internal.ybu.ybd(var1_4, var9_20) || (Integer)var21_76.getLower() <= (Integer)var1_4.getUpper() && androidx.camera.camera2.internal.ybu.ybd(var21_76) >= androidx.camera.camera2.internal.ybu.ybd(var1_4))) continue;
                                        }
                                    }
                                    var21_76 = var1_4;
                                }
                                var1_4 = var21_76;
                            }
                        }
                        var4_10 = 0;
                        var9_21 = var6_12.size();
                        while (var4_10 < var9_21) {
                            v57 = var6_12;
                            v58 = v57.get(var4_10);
                            ++var4_10;
                            var10_27 = (UseCaseConfig)v58;
                            var12_43 = StreamSpec.builder((Size)((Size)var15_60.get(var7_13.indexOf(v57.indexOf(var10_27))))).setDynamicRange((DynamicRange)Preconditions.checkNotNull((Object)((DynamicRange)var8_14.get(var10_27)))).setImplementationOptions((Config)StreamUseCaseUtil.getStreamSpecImplementationOptions((UseCaseConfig)var10_27)).setZslDisabled(var5_11);
                            if (var1_4 != null) {
                                var12_43.setExpectedFrameRateRange(var1_4);
                            }
                            var11_33.put(var10_27, var12_43.build());
                        }
                        if (var20_74 != null && var16_63 == var18_70 && var15_60.size() == var17_66.size()) {
                            for (var1_5 = 0; var1_5 < var15_60.size(); ++var1_5) {
                                if (((Size)var15_60.get(var1_5)).equals(var17_66.get(var1_5))) {
                                    continue;
                                }
                                break block92;
                            }
                            if (!StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithInteropOverride((CameraCharacteristicsCompat)this.ybx, (List)var2_6, var11_33, (Map)var3_7)) {
                                StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithSupportedSurfaceConfigs(var11_33, (Map)var3_7, var13_49, var14_56, (List)var20_74);
                            }
                        }
                    }
                    return new Pair(var11_33, var3_7);
                }
                throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.ybq + " and Hardware level: " + this.yba + ". May be the specified resolution is too large and not supported. Existing surfaces: " + var2_6 + " New configs: " + var6_12);
            }
            throw new IllegalArgumentException("Failed to find supported resolutions.");
        }
        throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.ybq + ".  May be attempting to bind too many use cases. Existing surfaces: " + var2_6 + " New configs: " + var6_12);
    }

    public final SurfaceSizeDefinition ybd(int n) {
        if (!this.ybs.contains(n)) {
            Integer n2;
            Size size;
            ybu ybu2 = this;
            Object object = ybu2.ybj.getS720pSizeMap();
            Size size2 = SizeUtil.RESOLUTION_720P;
            if (ybu2.ybn) {
                size = androidx.camera.camera2.internal.ybu.ybd(this.ybx.getStreamConfigurationMapCompat().toStreamConfigurationMap(), n, false);
                n2 = n;
                if (size != null) {
                    size2 = Collections.min(Arrays.asList(size2, size), new CompareSizesByArea());
                }
                object.put(n2, size2);
            }
            ybu ybu3 = this;
            object = ybu3.ybj.getS1440pSizeMap();
            size2 = SizeUtil.RESOLUTION_1440P;
            if (ybu3.ybn) {
                size = androidx.camera.camera2.internal.ybu.ybd(this.ybx.getStreamConfigurationMapCompat().toStreamConfigurationMap(), n, false);
                n2 = n;
                if (size != null) {
                    size2 = Collections.min(Arrays.asList(size2, size), new CompareSizesByArea());
                }
                object.put(n2, size2);
            }
            ybu ybu4 = this;
            object = ybu4.ybj.getMaximumSizeMap();
            size2 = androidx.camera.camera2.internal.ybu.ybd(ybu4.ybx.getStreamConfigurationMapCompat().toStreamConfigurationMap(), n, true);
            if (size2 != null) {
                object.put(n, size2);
            }
            object = this.ybj.getUltraMaximumSizeMap();
            if (Build.VERSION.SDK_INT >= 31 && this.ybf && (size2 = (StreamConfigurationMap)this.ybx.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP_MAXIMUM_RESOLUTION)) != null) {
                Map map = object;
                object = n;
                map.put(object, androidx.camera.camera2.internal.ybu.ybd((StreamConfigurationMap)size2, n, true));
            }
            this.ybs.add(n);
        }
        return this.ybj;
    }

    public final Pair ybd(int n, List list, List list2, ArrayList arrayList, ArrayList arrayList2, int n2, HashMap hashMap, HashMap hashMap2) {
        ArrayList arrayList3;
        List list3 = list;
        list = arrayList3;
        arrayList3 = new ArrayList();
        for (AttachedSurfaceInfo attachedSurfaceInfo : list3) {
            ((ArrayList)list).add(attachedSurfaceInfo.getSurfaceConfig());
            if (hashMap == null) continue;
            hashMap.put(((ArrayList)list).size() - 1, attachedSurfaceInfo);
        }
        for (int i = 0; i < list2.size(); ++i) {
            AttachedSurfaceInfo attachedSurfaceInfo;
            Size size = (Size)list2.get(i);
            attachedSurfaceInfo = (UseCaseConfig)arrayList.get((Integer)arrayList2.get(i));
            int n3 = attachedSurfaceInfo.getInputFormat();
            SurfaceSizeDefinition surfaceSizeDefinition = this.ybd(n3);
            ((ArrayList)list).add(SurfaceConfig.transformSurfaceConfig((int)n, (int)n3, (Size)size, (SurfaceSizeDefinition)surfaceSizeDefinition));
            if (hashMap2 != null) {
                hashMap2.put(((ArrayList)list).size() - 1, attachedSurfaceInfo);
            }
            int n4 = n2;
            n2 = attachedSurfaceInfo.getInputFormat();
            n2 = Math.min(n4, androidx.camera.camera2.internal.ybu.ybd(this.ybx, n2, size));
        }
        return new Pair((Object)list, (Object)n2);
    }
}

