/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.commonsware.cwac.camera.CameraHost$RecordingHint;
import com.commonsware.cwac.camera.ybav;
import com.commonsware.cwac.camera.ybb;
import com.commonsware.cwac.camera.ybc;
import com.commonsware.cwac.camera.ybd;
import com.commonsware.cwac.camera.ybey;
import com.commonsware.cwac.camera.ybf;
import com.commonsware.cwac.camera.ybg;
import com.commonsware.cwac.camera.ybh;
import com.commonsware.cwac.camera.ybj;
import com.commonsware.cwac.camera.ybjq;
import com.commonsware.cwac.camera.ybl;
import com.commonsware.cwac.camera.ybm;
import com.commonsware.cwac.camera.ybma;
import com.commonsware.cwac.camera.ybml;
import com.commonsware.cwac.camera.ybn;
import com.commonsware.cwac.camera.ybo;
import com.commonsware.cwac.camera.yboa;
import com.commonsware.cwac.camera.ybq;
import com.commonsware.cwac.camera.ybu;
import com.commonsware.cwac.camera.ybux;
import com.commonsware.cwac.camera.ybw;
import com.commonsware.cwac.camera.yby;
import java.io.IOException;

public abstract class ybba
extends ViewGroup
implements Camera.AutoFocusCallback {
    public static final int[] ybc;
    public static final Handler ybf;
    protected yboa previewStrategy;
    public Camera.Size ybd;
    public Camera ybt = null;
    protected boolean inPreview = false;
    public ybd ybu = null;
    public final ybb ybh = null;
    public int ybm = -1;
    public int ybz = -1;
    public int ybr = -1;
    public MediaRecorder ybo = null;
    public Camera.Parameters ybq = null;
    public boolean ybl = false;
    public boolean ybx = false;
    public ybf yby;
    public int yba;
    public WindowManager ybv;
    public boolean ybi = false;
    public boolean ybn = false;

    public ybba(Context context) {
        super(context);
        ybb ybb2;
        ybb ybb3 = ybb2;
        ybb2 = new ybb(this, context);
        this.ybh = ybb3;
    }

    /*
     * WARNING - void declaration
     */
    private void setCameraPictureOrientation(Camera.Parameters params) {
        void var1_1;
        Camera.CameraInfo cameraInfo;
        ybba ybba2 = this;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)ybba2.ybr, (Camera.CameraInfo)cameraInfo2);
        if (ybba2.ybi && !this.ybn) {
            ybba ybba3 = this;
            ybba3.ybz = ybba3.ybd(ybba3.ybv.getDefaultDisplay().getOrientation());
        } else {
            this.ybz = cameraInfo2.facing == 1 ? (360 - this.ybm) % 360 : this.ybm;
        }
        if (this.ybz % 90 != 0) {
            this.ybz = 0;
        }
        var1_1.setRotation(this.ybz);
    }

    static {
        HandlerThread handlerThread;
        ybc = new int[]{0, 90, 180, 270};
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread("CWAC_CAMERA", 10).start();
        ybf = new Handler(handlerThread2.getLooper());
    }

    public ybd getCameraHost() {
        return this.ybu;
    }

    public void setCameraHost(ybd host) {
        ybma ybma2;
        yboa yboa2;
        this.ybu = yboa2;
        if (((ybjq)host.getDeviceProfile()).ybt) {
            ybux ybux2;
            yboa2 = ybux2;
            ybux2 = new ybux(this);
            this.previewStrategy = yboa2;
            return;
        }
        yboa2 = ybma2;
        ybma2 = new ybma(this);
        this.previewStrategy = yboa2;
    }

    public synchronized Camera.Parameters getCameraParameters() {
        Camera camera = this.ybt;
        if (camera != null && this.ybq == null) {
            try {
                this.ybq = camera.getParameters();
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getCameraParameters(). Could not work with camera parameters.");
            }
        }
        return this.ybq;
    }

    /*
     * WARNING - void declaration
     */
    public void setCameraParameters(Camera.Parameters parameters) {
        void var1_1;
        ybf.post((Runnable)new yby(this, (Camera.Parameters)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPreviewSize(Camera.Size newPreviewSize) {
        void var1_1;
        ybf.post((Runnable)new ybn(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPictureSize(Camera.Size newPictureSize) {
        void var1_1;
        ybf.post((Runnable)new ybc(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCameraParametersSync(Camera.Parameters parameters) {
        try {
            void var1_1;
            Camera camera = this.ybt;
            if (camera != null && var1_1 != null) {
                camera.setParameters((Camera.Parameters)var1_1);
            }
            this.ybq = var1_1;
            return;
        }
        catch (RuntimeException runtimeException) {}
        Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraParametersSync(). Could not set camera parameters.");
    }

    /*
     * WARNING - void declaration
     */
    public void onCameraOpen(Camera object) {
        block11: {
            void var2_4;
            try {
                this.previewStrategy.ybd();
                break block11;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getCameraHost().handleException((Exception)var2_4);
        }
        this.ybv = (WindowManager)this.getContext().getSystemService("window");
        if (this.ybi && !this.ybn) {
            this.ybh.enable();
        }
        this.ybd();
        if (Build.VERSION.SDK_INT >= 14 && this.getCameraHost() instanceof Camera.FaceDetectionListener) {
            object.setFaceDetectionListener((Camera.FaceDetectionListener)this.getCameraHost());
        }
        if (this.yby == null) {
            ybf ybf2;
            object = ybf2;
            ybf2 = new ybf(this, this.getContext());
            this.yby = object;
        }
        if (this.yby.canDetectOrientation()) {
            this.yby.enable();
        }
        if (this.ybi) {
            this.ybd();
            if (!this.ybn) {
                this.ybh.enable();
            } else {
                object = this.getCameraParameters();
                if (object != null) {
                    this.setCameraPictureOrientation((Camera.Parameters)object);
                    this.setCameraParametersSync((Camera.Parameters)object);
                }
            }
        }
    }

    public void onResume() {
        this.ybh.ybd = -1;
        ViewGroup viewGroup = (ViewGroup)this.previewStrategy.ybt().getParent();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        ybba ybba2 = this;
        ybba2.addView(ybba2.previewStrategy.ybt());
        ybf.post((Runnable)new ybj(this));
    }

    public void onPause() {
        ybf.post((Runnable)new ybo((ybba)((Object)object)));
        if (object.previewStrategy.ybt() != null) {
            ybba ybba2 = object;
            ybba2.removeView(ybba2.previewStrategy.ybt());
        }
        ybba ybba3 = object;
        ybba3.ybh.disable();
        Object object = ybba3.yby;
        if (object != null) {
            object.disable();
            return;
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        n2 = View.resolveSize((int)this.getSuggestedMinimumWidth(), (int)n2);
        n = View.resolveSize((int)this.getSuggestedMinimumHeight(), (int)n);
        this.setMeasuredDimension(n2, n);
        if (n2 > 0 && n > 0) {
            ybf.post((Runnable)new ybw(this, n2, n));
            return;
        }
    }

    public Camera.Size getPreviewSize() {
        return this.ybd;
    }

    /*
     * WARNING - void declaration
     */
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getChildCount() > 0) {
            int n;
            void var3_11;
            int n2;
            void var2_10;
            void var4_12;
            View view = this.getChildAt(0);
            var2_10 = var4_12 - var2_10;
            var3_11 = n2 - var3_11;
            Camera.Size size = this.ybd;
            if (size != null && size.height > 0 && size.width > 0) {
                if (this.getDisplayOrientation() != 90 && this.getDisplayOrientation() != 270) {
                    Camera.Size size2 = this.ybd;
                    n = size2.width;
                    n2 = size2.height;
                } else {
                    Camera.Size size3 = this.ybd;
                    n = size3.height;
                    n2 = size3.width;
                }
            } else {
                n2 = var3_11;
                n = var2_10;
            }
            if (n != 0 && n2 != 0) {
                void var6_16 = var2_10 * n2;
                void var7_17 = var3_11 * n;
                boolean bl = var6_16 > var7_17;
                boolean n3 = this.getCameraHost().useFullBleedPreview();
                if (bl && !n3 || !bl && n3) {
                    void v2 = var2_10;
                    void var0_2 = var7_17 / n2;
                    void var1_8 = (v2 - var0_2) / 2;
                    void var0_3 = (v2 + var0_2) / 2;
                    view.layout((int)var1_8, 0, (int)var0_3, (int)var3_11);
                    return;
                }
                void v3 = var3_11;
                void var0_4 = var6_16 / n;
                void var1_9 = (v3 - var0_4) / 2;
                void var0_5 = (v3 + var0_4) / 2;
                view.layout(0, (int)var1_9, (int)var2_10, (int)var0_5);
                return;
            }
        }
    }

    public int getDisplayOrientation() {
        return this.ybm;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToLandscape(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(6);
        }
        ybba ybba2 = this;
        ybba2.ybi = true;
        ybba2.ybn = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToPortrait(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(7);
        }
        ybba ybba2 = this;
        ybba2.ybi = true;
        ybba2.ybn = var1_1;
    }

    public void unlockOrientation() {
        this.ybi = false;
        this.ybn = false;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(-1);
        }
        ybba ybba2 = this;
        ybba2.ybh.disable();
        ybba2.post(new ybg(this));
    }

    public void restartPreview() {
        if (!this.inPreview) {
            this.startPreview();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void takePicture(boolean needBitmap, boolean needByteArray) {
        void var2_2;
        void var1_1;
        ybav ybav2;
        ybav ybav3 = ybav2;
        ybav3(this.getCameraHost());
        ybav3.ybt = var1_1;
        ybav2.ybu = var2_2;
        this.takePicture(ybav2);
    }

    public abstract void takePicture(ybav var1);

    public boolean isRecording() {
        return this.ybo != null;
    }

    public void record() {
        if (Build.VERSION.SDK_INT >= 11) {
            MediaRecorder mediaRecorder;
            int n = this.ybm;
            if (n != 0 && n != 180) {
                throw new UnsupportedOperationException("Video recording supported only in landscape");
            }
            Camera.Parameters parameters = this.ybt.getParameters();
            this.setCameraPictureOrientation(parameters);
            this.ybt.setParameters(parameters);
            this.stopPreview();
            this.ybt.unlock();
            parameters = mediaRecorder;
            try {
                this.ybo = parameters;
                new MediaRecorder().setCamera(this.ybt);
                this.getCameraHost().configureRecorderAudio(this.ybr, this.ybo);
                this.ybo.setVideoSource(1);
                this.getCameraHost().configureRecorderProfile(this.ybr, this.ybo);
                this.getCameraHost().configureRecorderOutput(this.ybr, this.ybo);
                this.ybo.setOrientationHint(this.ybz);
                this.previewStrategy.ybd(this.ybo);
                this.ybo.prepare();
                this.ybo.start();
                return;
            }
            catch (IOException iOException) {
                this.ybo.release();
                this.ybo = null;
                throw iOException;
            }
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public void stopRecording() {
        if (Build.VERSION.SDK_INT >= 11) {
            ybba ybba2 = this;
            MediaRecorder mediaRecorder = ybba2.ybo;
            this.ybo = null;
            mediaRecorder.stop();
            mediaRecorder.release();
            ybba2.ybt.reconnect();
            return;
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public boolean isAutoFocusAvailable() {
        return this.inPreview;
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        this.ybx = false;
        if (this.getCameraHost() instanceof Camera.AutoFocusCallback) {
            this.getCameraHost().onAutoFocus(bl, camera);
            return;
        }
    }

    public String getFlashMode() {
        return this.ybq.getFlashMode();
    }

    /*
     * WARNING - void declaration
     */
    public void setFlashMode(String mode) {
        void var1_1;
        ybf.post((Runnable)new ybu(this, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public ybml zoomTo(int level) {
        if (this_.ybt != null) {
            void var1_1;
            Camera.Parameters parameters = this_.getCameraParameters();
            if (var1_1 >= 0 && var1_1 <= parameters.getMaxZoom()) {
                return new ybml(this_.ybt, (int)var1_1);
            }
            Object this_ = (int)var1_1;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this_;
            throw new IllegalArgumentException(String.format("Invalid zoom level: %d", objectArray2));
        }
        throw new IllegalStateException("Yes, we have no camera, we have no camera today");
    }

    @TargetApi(value=14)
    public void startFaceDetection() {
        if (Build.VERSION.SDK_INT >= 14 && this.ybt != null && !this.ybl && this.getCameraParameters().getMaxNumDetectedFaces() > 0) {
            this.ybt.startFaceDetection();
            this.ybl = true;
            return;
        }
    }

    public void stopFaceDetection() {
        Camera camera;
        if (Build.VERSION.SDK_INT >= 14 && (camera = this.ybt) != null && this.ybl) {
            camera.stopFaceDetection();
            this.ybl = false;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallback(Camera.PreviewCallback callback) {
        void var1_1;
        ybf.post((Runnable)new ybh(this, (Camera.PreviewCallback)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBuffer(byte[] buffer) {
        void var1_1;
        ybf.post((Runnable)new ybm(this, (byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallbackSync(Camera.PreviewCallback callback) {
        Camera camera = this.ybt;
        if (camera != null) {
            try {
                void var1_1;
                camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)var1_1);
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setPreviewCallbackWithBuffer(). Could not set preview callback.", (Throwable)runtimeException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBufferSync(byte[] buffer) {
        void var1_1;
        ybba this_ = this_.ybt;
        if (this_ != null && var1_1 != null) {
            this_.addCallbackBuffer((byte[])var1_1);
            return;
        }
    }

    public boolean doesZoomReallyWork() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        ybba ybba2 = ybey2;
        cameraInfo2();
        Camera.getCameraInfo((int)ybba2.getCameraHost().getCameraId(), (Camera.CameraInfo)cameraInfo2);
        ybey ybey2 = ybba2.getCameraHost().getDeviceProfile();
        boolean bl = cameraInfo.facing == 1;
        return ybey2.ybd(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void initPreview(int width, int height) {
        void var2_2;
        void var1_1;
        this.initPreview((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=14)
    public void initPreview(int w, int h, boolean firstRun) {
        void var2_2;
        void var1_1;
        ybf.post((Runnable)new ybq(this, (int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initPreviewSync(int w, int h) {
        block7: {
            ybl ybl2;
            block8: {
                block6: {
                    Camera.Parameters parameters;
                    block5: {
                        if (this.ybt == null) break block7;
                        try {
                            boolean bl;
                            ybba ybba2 = this;
                            parameters = ybba2.getCameraParameters();
                            if (ybba2.ybd == null) {
                                void var2_3;
                                this.ybd = this.getCameraHost().getPreviewSize(this.getDisplayOrientation(), bl ? 1 : 0, (int)var2_3, parameters);
                            }
                            Camera.Size size = this.ybd;
                            bl = size.width;
                            parameters.setPreviewSize(bl ? 1 : 0, size.height);
                            if (Build.VERSION.SDK_INT < 14) break block5;
                            bl = this.getCameraHost().getRecordingHint() != CameraHost$RecordingHint.STILL_ONLY;
                            parameters.setRecordingHint(bl);
                        }
                        catch (Exception exception) {
                            break block6;
                        }
                    }
                    ybba ybba3 = this;
                    ybba3.setCameraParametersSync(ybba3.getCameraHost().adjustPreviewParameters(parameters));
                    break block8;
                }
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"initPreview(). Could not work with camera parameters.");
            }
            ybba ybba4 = this;
            ybl ybl3 = ybl2;
            ybl2 = new ybl(this);
            ybba4.post(ybl3);
            ybba4.startPreviewSync();
        }
    }

    public abstract void startPreview();

    public void startPreviewSync() {
        block3: {
            Camera camera = this.ybt;
            if (camera == null) break block3;
            try {
                camera.startPreview();
                this.inPreview = true;
                this.getCameraHost().autoFocusAvailable();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"startPreviewSync(). Could not start preview.");
            }
        }
    }

    public abstract void stopPreview();

    public final void ybt() {
        block3: {
            if (this.ybt == null) break block3;
            try {
                ybba ybba2 = this;
                ybba2.inPreview = false;
                ybba2.getCameraHost().autoFocusUnavailable();
                ybba2.ybt.setPreviewCallback(null);
                ybba2.ybt.stopPreview();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"stopPreviewSync(). Could not stop preview.");
            }
        }
    }

    public final void ybd() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Display display = this.ybv.getDefaultDisplay();
        int n = display.getRotation();
        int n2 = 0;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Camera.getCameraInfo((int)this.ybr, (Camera.CameraInfo)cameraInfo2);
        display.getMetrics(displayMetrics);
        switch (n) {
            default: {
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        this.ybm = cameraInfo2.facing == 1 ? (360 - (cameraInfo2.orientation + n2) % 360) % 360 : (cameraInfo2.orientation - n2 + 360) % 360;
        if (this.ybt != null) {
            boolean bl = this.inPreview;
            if (bl) {
                this.ybt();
            }
            try {
                this.ybt.setDisplayOrientation(this.ybm);
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraDisplayOrientation(). Could not set camera display orientation.");
            }
            if (bl) {
                this.startPreviewSync();
            }
        }
    }

    public final int ybd(int n) {
        Camera.CameraInfo cameraInfo;
        ybba ybba2 = ybba3;
        ybba ybba3 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)ybba2.ybr, (Camera.CameraInfo)ybba3);
        n = (n + 45) / 90 * 90;
        if (((Camera.CameraInfo)ybba3).facing == 1) {
            return (((Camera.CameraInfo)ybba3).orientation - n + 360) % 360;
        }
        return (((Camera.CameraInfo)ybba3).orientation + n) % 360;
    }
}

