/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.commonsware.cwac.camera.CameraHost$RecordingHint;
import com.commonsware.cwac.camera.hkc;
import com.commonsware.cwac.camera.hkcw;
import com.commonsware.cwac.camera.hkd;
import com.commonsware.cwac.camera.hkdo;
import com.commonsware.cwac.camera.hkh;
import com.commonsware.cwac.camera.hkj;
import com.commonsware.cwac.camera.hkjo;
import com.commonsware.cwac.camera.hkk;
import com.commonsware.cwac.camera.hkl;
import com.commonsware.cwac.camera.hkm;
import com.commonsware.cwac.camera.hkn;
import com.commonsware.cwac.camera.hko;
import com.commonsware.cwac.camera.hkpf;
import com.commonsware.cwac.camera.hkq;
import com.commonsware.cwac.camera.hkqk;
import com.commonsware.cwac.camera.hkr;
import com.commonsware.cwac.camera.hks;
import com.commonsware.cwac.camera.hku;
import com.commonsware.cwac.camera.hkud;
import com.commonsware.cwac.camera.hkw;
import com.commonsware.cwac.camera.hkyh;
import com.commonsware.cwac.camera.hkz;
import java.io.IOException;

public abstract class hkuc
extends ViewGroup
implements Camera.AutoFocusCallback {
    public static final int[] hkl;
    public static final Handler hkq;
    protected hkqk previewStrategy;
    public Camera.Size hkm;
    public Camera hke = null;
    protected boolean inPreview = false;
    public hkm hkw = null;
    public final hkj hks = null;
    public int hkd = -1;
    public int hkg = -1;
    public int hkf = -1;
    public MediaRecorder hku = null;
    public Camera.Parameters hkr = null;
    public boolean hkn = false;
    public boolean hkp = false;
    public hkq hko;
    public int hkv;
    public WindowManager hkb;
    public boolean hky = false;
    public boolean hkh = false;

    public hkuc(Context context) {
        super(context);
        hkj hkj2;
        hkj hkj3 = hkj2;
        hkj2 = new hkj(this, context);
        this.hks = hkj3;
    }

    /*
     * WARNING - void declaration
     */
    private void setCameraPictureOrientation(Camera.Parameters params) {
        void var1_1;
        Camera.CameraInfo cameraInfo;
        hkuc hkuc2 = this;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)hkuc2.hkf, (Camera.CameraInfo)cameraInfo2);
        if (hkuc2.hky && !this.hkh) {
            hkuc hkuc3 = this;
            hkuc3.hkg = hkuc3.hkm(hkuc3.hkb.getDefaultDisplay().getOrientation());
        } else {
            this.hkg = cameraInfo2.facing == 1 ? (360 - this.hkd) % 360 : this.hkd;
        }
        if (this.hkg % 90 != 0) {
            this.hkg = 0;
        }
        var1_1.setRotation(this.hkg);
    }

    static {
        HandlerThread handlerThread;
        hkl = new int[]{0, 90, 180, 270};
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread("CWAC_CAMERA", 10).start();
        hkq = new Handler(handlerThread2.getLooper());
    }

    public hkm getCameraHost() {
        return this.hkw;
    }

    public void setCameraHost(hkm host) {
        hkyh hkyh2;
        hkqk hkqk2;
        this.hkw = hkqk2;
        if (((hkdo)host.getDeviceProfile()).hke) {
            hkcw hkcw2;
            hkqk2 = hkcw2;
            hkcw2 = new hkcw(this);
            this.previewStrategy = hkqk2;
            return;
        }
        hkqk2 = hkyh2;
        hkyh2 = new hkyh(this);
        this.previewStrategy = hkqk2;
    }

    public synchronized Camera.Parameters getCameraParameters() {
        Camera camera = this.hke;
        if (camera != null && this.hkr == null) {
            try {
                this.hkr = camera.getParameters();
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getCameraParameters(). Could not work with camera parameters.");
            }
        }
        return this.hkr;
    }

    /*
     * WARNING - void declaration
     */
    public void setCameraParameters(Camera.Parameters parameters) {
        void var1_1;
        hkq.post((Runnable)new hko(this, (Camera.Parameters)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPreviewSize(Camera.Size newPreviewSize) {
        void var1_1;
        hkq.post((Runnable)new hkh(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPictureSize(Camera.Size newPictureSize) {
        void var1_1;
        hkq.post((Runnable)new hkl(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCameraParametersSync(Camera.Parameters parameters) {
        try {
            void var1_1;
            Camera camera = this.hke;
            if (camera != null && var1_1 != null) {
                camera.setParameters((Camera.Parameters)var1_1);
            }
            this.hkr = var1_1;
            return;
        }
        catch (RuntimeException runtimeException) {}
        Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraParametersSync(). Could not set camera parameters.");
    }

    /*
     * WARNING - void declaration
     */
    public void onCameraOpen(Camera object) {
        block11: {
            void var2_4;
            try {
                this.previewStrategy.hkm();
                break block11;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getCameraHost().handleException((Exception)var2_4);
        }
        this.hkb = (WindowManager)this.getContext().getSystemService("window");
        if (this.hky && !this.hkh) {
            this.hks.enable();
        }
        this.hkm();
        if (Build.VERSION.SDK_INT >= 14 && this.getCameraHost() instanceof Camera.FaceDetectionListener) {
            object.setFaceDetectionListener((Camera.FaceDetectionListener)this.getCameraHost());
        }
        if (this.hko == null) {
            hkq hkq2;
            object = hkq2;
            hkq2 = new hkq(this, this.getContext());
            this.hko = object;
        }
        if (this.hko.canDetectOrientation()) {
            this.hko.enable();
        }
        if (this.hky) {
            this.hkm();
            if (!this.hkh) {
                this.hks.enable();
            } else {
                object = this.getCameraParameters();
                if (object != null) {
                    this.setCameraPictureOrientation((Camera.Parameters)object);
                    this.setCameraParametersSync((Camera.Parameters)object);
                }
            }
        }
    }

    public void onResume() {
        this.hks.hkm = -1;
        ViewGroup viewGroup = (ViewGroup)this.previewStrategy.hke().getParent();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        hkuc hkuc2 = this;
        hkuc2.addView(hkuc2.previewStrategy.hke());
        hkq.post((Runnable)new hkc(this));
    }

    public void onPause() {
        hkq.post((Runnable)new hku((hkuc)((Object)object)));
        if (object.previewStrategy.hke() != null) {
            hkuc hkuc2 = object;
            hkuc2.removeView(hkuc2.previewStrategy.hke());
        }
        hkuc hkuc3 = object;
        hkuc3.hks.disable();
        Object object = hkuc3.hko;
        if (object != null) {
            object.disable();
            return;
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        n2 = View.resolveSize((int)this.getSuggestedMinimumWidth(), (int)n2);
        n = View.resolveSize((int)this.getSuggestedMinimumHeight(), (int)n);
        this.setMeasuredDimension(n2, n);
        if (n2 > 0 && n > 0) {
            hkq.post((Runnable)new hkk(this, n2, n));
            return;
        }
    }

    public Camera.Size getPreviewSize() {
        return this.hkm;
    }

    /*
     * WARNING - void declaration
     */
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getChildCount() > 0) {
            int n;
            void var3_11;
            int n2;
            void var2_10;
            void var4_12;
            View view = this.getChildAt(0);
            var2_10 = var4_12 - var2_10;
            var3_11 = n2 - var3_11;
            Camera.Size size = this.hkm;
            if (size != null && size.height > 0 && size.width > 0) {
                if (this.getDisplayOrientation() != 90 && this.getDisplayOrientation() != 270) {
                    Camera.Size size2 = this.hkm;
                    n = size2.width;
                    n2 = size2.height;
                } else {
                    Camera.Size size3 = this.hkm;
                    n = size3.height;
                    n2 = size3.width;
                }
            } else {
                n2 = var3_11;
                n = var2_10;
            }
            if (n != 0 && n2 != 0) {
                void var6_16 = var2_10 * n2;
                void var7_17 = var3_11 * n;
                boolean bl = var6_16 > var7_17;
                boolean n3 = this.getCameraHost().useFullBleedPreview();
                if (bl && !n3 || !bl && n3) {
                    void v2 = var2_10;
                    void var0_2 = var7_17 / n2;
                    void var1_8 = (v2 - var0_2) / 2;
                    void var0_3 = (v2 + var0_2) / 2;
                    view.layout((int)var1_8, 0, (int)var0_3, (int)var3_11);
                    return;
                }
                void v3 = var3_11;
                void var0_4 = var6_16 / n;
                void var1_9 = (v3 - var0_4) / 2;
                void var0_5 = (v3 + var0_4) / 2;
                view.layout(0, (int)var1_9, (int)var2_10, (int)var0_5);
                return;
            }
        }
    }

    public int getDisplayOrientation() {
        return this.hkd;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToLandscape(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(6);
        }
        hkuc hkuc2 = this;
        hkuc2.hky = true;
        hkuc2.hkh = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToPortrait(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(7);
        }
        hkuc hkuc2 = this;
        hkuc2.hky = true;
        hkuc2.hkh = var1_1;
    }

    public void unlockOrientation() {
        this.hky = false;
        this.hkh = false;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(-1);
        }
        hkuc hkuc2 = this;
        hkuc2.hks.disable();
        hkuc2.post(new hkz(this));
    }

    public void restartPreview() {
        if (!this.inPreview) {
            this.startPreview();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void takePicture(boolean needBitmap, boolean needByteArray) {
        void var2_2;
        void var1_1;
        hkjo hkjo2;
        hkjo hkjo3 = hkjo2;
        hkjo3(this.getCameraHost());
        hkjo3.hke = var1_1;
        hkjo2.hkw = var2_2;
        this.takePicture(hkjo2);
    }

    public abstract void takePicture(hkjo var1);

    public boolean isRecording() {
        return this.hku != null;
    }

    public void record() {
        if (Build.VERSION.SDK_INT >= 11) {
            MediaRecorder mediaRecorder;
            int n = this.hkd;
            if (n != 0 && n != 180) {
                throw new UnsupportedOperationException("Video recording supported only in landscape");
            }
            Camera.Parameters parameters = this.hke.getParameters();
            this.setCameraPictureOrientation(parameters);
            this.hke.setParameters(parameters);
            this.stopPreview();
            this.hke.unlock();
            parameters = mediaRecorder;
            try {
                this.hku = parameters;
                new MediaRecorder().setCamera(this.hke);
                this.getCameraHost().configureRecorderAudio(this.hkf, this.hku);
                this.hku.setVideoSource(1);
                this.getCameraHost().configureRecorderProfile(this.hkf, this.hku);
                this.getCameraHost().configureRecorderOutput(this.hkf, this.hku);
                this.hku.setOrientationHint(this.hkg);
                this.previewStrategy.hkm(this.hku);
                this.hku.prepare();
                this.hku.start();
                return;
            }
            catch (IOException iOException) {
                this.hku.release();
                this.hku = null;
                throw iOException;
            }
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public void stopRecording() {
        if (Build.VERSION.SDK_INT >= 11) {
            hkuc hkuc2 = this;
            MediaRecorder mediaRecorder = hkuc2.hku;
            this.hku = null;
            mediaRecorder.stop();
            mediaRecorder.release();
            hkuc2.hke.reconnect();
            return;
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public boolean isAutoFocusAvailable() {
        return this.inPreview;
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        this.hkp = false;
        if (this.getCameraHost() instanceof Camera.AutoFocusCallback) {
            this.getCameraHost().onAutoFocus(bl, camera);
            return;
        }
    }

    public String getFlashMode() {
        return this.hkr.getFlashMode();
    }

    /*
     * WARNING - void declaration
     */
    public void setFlashMode(String mode) {
        void var1_1;
        hkq.post((Runnable)new hkw(this, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public hkud zoomTo(int level) {
        if (this_.hke != null) {
            void var1_1;
            Camera.Parameters parameters = this_.getCameraParameters();
            if (var1_1 >= 0 && var1_1 <= parameters.getMaxZoom()) {
                return new hkud(this_.hke, (int)var1_1);
            }
            Object this_ = (int)var1_1;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this_;
            throw new IllegalArgumentException(String.format("Invalid zoom level: %d", objectArray2));
        }
        throw new IllegalStateException("Yes, we have no camera, we have no camera today");
    }

    @TargetApi(value=14)
    public void startFaceDetection() {
        if (Build.VERSION.SDK_INT >= 14 && this.hke != null && !this.hkn && this.getCameraParameters().getMaxNumDetectedFaces() > 0) {
            this.hke.startFaceDetection();
            this.hkn = true;
            return;
        }
    }

    public void stopFaceDetection() {
        Camera camera;
        if (Build.VERSION.SDK_INT >= 14 && (camera = this.hke) != null && this.hkn) {
            camera.stopFaceDetection();
            this.hkn = false;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallback(Camera.PreviewCallback callback) {
        void var1_1;
        hkq.post((Runnable)new hks(this, (Camera.PreviewCallback)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBuffer(byte[] buffer) {
        void var1_1;
        hkq.post((Runnable)new hkd(this, (byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallbackSync(Camera.PreviewCallback callback) {
        Camera camera = this.hke;
        if (camera != null) {
            try {
                void var1_1;
                camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)var1_1);
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setPreviewCallbackWithBuffer(). Could not set preview callback.", (Throwable)runtimeException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBufferSync(byte[] buffer) {
        void var1_1;
        hkuc this_ = this_.hke;
        if (this_ != null && var1_1 != null) {
            this_.addCallbackBuffer((byte[])var1_1);
            return;
        }
    }

    public boolean doesZoomReallyWork() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        hkuc hkuc2 = hkpf2;
        cameraInfo2();
        Camera.getCameraInfo((int)hkuc2.getCameraHost().getCameraId(), (Camera.CameraInfo)cameraInfo2);
        hkpf hkpf2 = hkuc2.getCameraHost().getDeviceProfile();
        boolean bl = cameraInfo.facing == 1;
        return hkpf2.hkm(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void initPreview(int width, int height) {
        void var2_2;
        void var1_1;
        this.initPreview((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=14)
    public void initPreview(int w, int h, boolean firstRun) {
        void var2_2;
        void var1_1;
        hkq.post((Runnable)new hkr(this, (int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initPreviewSync(int w, int h) {
        block7: {
            hkn hkn2;
            block8: {
                block6: {
                    Camera.Parameters parameters;
                    block5: {
                        if (this.hke == null) break block7;
                        try {
                            boolean bl;
                            hkuc hkuc2 = this;
                            parameters = hkuc2.getCameraParameters();
                            if (hkuc2.hkm == null) {
                                void var2_3;
                                this.hkm = this.getCameraHost().getPreviewSize(this.getDisplayOrientation(), bl ? 1 : 0, (int)var2_3, parameters);
                            }
                            Camera.Size size = this.hkm;
                            bl = size.width;
                            parameters.setPreviewSize(bl ? 1 : 0, size.height);
                            if (Build.VERSION.SDK_INT < 14) break block5;
                            bl = this.getCameraHost().getRecordingHint() != CameraHost$RecordingHint.STILL_ONLY;
                            parameters.setRecordingHint(bl);
                        }
                        catch (Exception exception) {
                            break block6;
                        }
                    }
                    hkuc hkuc3 = this;
                    hkuc3.setCameraParametersSync(hkuc3.getCameraHost().adjustPreviewParameters(parameters));
                    break block8;
                }
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"initPreview(). Could not work with camera parameters.");
            }
            hkuc hkuc4 = this;
            hkn hkn3 = hkn2;
            hkn2 = new hkn(this);
            hkuc4.post(hkn3);
            hkuc4.startPreviewSync();
        }
    }

    public abstract void startPreview();

    public void startPreviewSync() {
        block3: {
            Camera camera = this.hke;
            if (camera == null) break block3;
            try {
                camera.startPreview();
                this.inPreview = true;
                this.getCameraHost().autoFocusAvailable();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"startPreviewSync(). Could not start preview.");
            }
        }
    }

    public abstract void stopPreview();

    public final void hke() {
        block3: {
            if (this.hke == null) break block3;
            try {
                hkuc hkuc2 = this;
                hkuc2.inPreview = false;
                hkuc2.getCameraHost().autoFocusUnavailable();
                hkuc2.hke.setPreviewCallback(null);
                hkuc2.hke.stopPreview();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"stopPreviewSync(). Could not stop preview.");
            }
        }
    }

    public final void hkm() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Display display = this.hkb.getDefaultDisplay();
        int n = display.getRotation();
        int n2 = 0;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Camera.getCameraInfo((int)this.hkf, (Camera.CameraInfo)cameraInfo2);
        display.getMetrics(displayMetrics);
        switch (n) {
            default: {
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        this.hkd = cameraInfo2.facing == 1 ? (360 - (cameraInfo2.orientation + n2) % 360) % 360 : (cameraInfo2.orientation - n2 + 360) % 360;
        if (this.hke != null) {
            boolean bl = this.inPreview;
            if (bl) {
                this.hke();
            }
            try {
                this.hke.setDisplayOrientation(this.hkd);
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraDisplayOrientation(). Could not set camera display orientation.");
            }
            if (bl) {
                this.startPreviewSync();
            }
        }
    }

    public final int hkm(int n) {
        Camera.CameraInfo cameraInfo;
        hkuc hkuc2 = hkuc3;
        hkuc hkuc3 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)hkuc2.hkf, (Camera.CameraInfo)hkuc3);
        n = (n + 45) / 90 * 90;
        if (((Camera.CameraInfo)hkuc3).facing == 1) {
            return (((Camera.CameraInfo)hkuc3).orientation - n + 360) % 360;
        }
        return (((Camera.CameraInfo)hkuc3).orientation + n) % 360;
    }
}

