/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.vml;
import androidx.camera.camera2.internal.vmo;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SuppressLint(value={"RestrictedApi"})
public final class ScanbotCamera2DeviceSurfaceManager
implements CameraDeviceSurfaceManager {
    private static final String TAG = "Camera2DeviceSurfaceManager";
    private final Map<String, vmo> mCameraSupportedSurfaceCombinationMap;
    private final CamcorderProfileHelper mCamcorderProfileHelper;

    /*
     * WARNING - void declaration
     */
    public ScanbotCamera2DeviceSurfaceManager(@NonNull Context context, @Nullable Object cameraManager, @NonNull Set<String> availableCameraIds) {
        void var3_3;
        void var2_2;
        void var1_1;
        vml vml2;
        ScanbotCamera2DeviceSurfaceManager scanbotCamera2DeviceSurfaceManager = this_;
        vml this_ = vml2;
        vml2 = new vml();
        scanbotCamera2DeviceSurfaceManager((Context)var1_1, this_, var2_2, (Set<String>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public ScanbotCamera2DeviceSurfaceManager(@NonNull Context context, @NonNull CamcorderProfileHelper camcorderProfileHelper, @Nullable Object cameraManager, @NonNull Set<String> availableCameraIds) {
        void var4_4;
        void var1_1;
        void var3_3;
        CameraManagerCompat cameraManagerCompat;
        void v0 = cameraManagerCompat;
        this.mCameraSupportedSurfaceCombinationMap = new HashMap<String, vmo>();
        Preconditions.checkNotNull((Object)v0);
        this.mCamcorderProfileHelper = v0;
        cameraManagerCompat = cameraManager instanceof CameraManagerCompat ? (CameraManagerCompat)var3_3 : CameraManagerCompat.from((Context)var1_1);
        this.init((Context)var1_1, cameraManagerCompat, (Set<String>)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    private void init(@NonNull Context context, @NonNull CameraManagerCompat cameraManager, @NonNull Set<String> availableCameraIds) {
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1);
        for (String string : availableCameraIds) {
            void var2_2;
            vmo vmo2;
            vmo vmo3 = vmo2;
            CamcorderProfileHelper camcorderProfileHelper = this.mCamcorderProfileHelper;
            vmo2 = new vmo((Context)var1_1, string, (CameraManagerCompat)var2_2, camcorderProfileHelper);
            this.mCameraSupportedSurfaceCombinationMap.put(string, vmo3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SurfaceConfig transformSurfaceConfig(int cameraMode, @NonNull String cameraId, int imageFormat, @NonNull Size size) {
        SurfaceConfig surfaceConfig;
        vmo this_ = ((ScanbotCamera2DeviceSurfaceManager)((Object)this_)).mCameraSupportedSurfaceCombinationMap.get(surfaceConfig);
        surfaceConfig = null;
        if (this_ != null) {
            void var4_4;
            void var3_3;
            void var1_1;
            return SurfaceConfig.transformSurfaceConfig((int)var1_1, (int)var3_3, (Size)var4_4, (SurfaceSizeDefinition)this_.vml((int)var3_3));
        }
        return surfaceConfig;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Pair<Map<UseCaseConfig<?>, StreamSpec>, Map<AttachedSurfaceInfo, StreamSpec>> getSuggestedStreamSpecs(int cameraMode, @NonNull String cameraId, @NonNull List<AttachedSurfaceInfo> existingSurfaces, @NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap, boolean isPreviewStabilizationOn, boolean hasVideoCapture) {
        void var2_2;
        void var4_4;
        Preconditions.checkArgument((boolean)(var4_4.isEmpty() ^ true), (Object)"No new use cases to be bound.");
        vmo this_ = ((ScanbotCamera2DeviceSurfaceManager)((Object)this_)).mCameraSupportedSurfaceCombinationMap.get(var2_2);
        if (this_ != null) {
            void var6_6;
            void var5_5;
            void var3_3;
            void var1_1;
            return this_.vml((int)var1_1, (List)var3_3, (Map)var4_4, (boolean)var5_5, (boolean)var6_6);
        }
        throw new IllegalArgumentException("No such camera id in supported combination list: " + (String)var2_2);
    }
}

