/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.LayoutTransition;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import androidx.core.graphics.Insets;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.common.AspectRatio;
import io.scanbot.sdk.document.DocumentDetectionStatus;
import io.scanbot.sdk.document.DocumentScannerFrameHandler;
import io.scanbot.sdk.ui.camera.FinderOverlayView;
import io.scanbot.sdk.util.PolygonHelper;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u0012\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\u0004\b\u001f\u0010 J=\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0014\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0013R\u0017\u0010\u001a\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lio/scanbot/sdk/ui/camera/AdaptiveFinderOverlayView;", "Lio/scanbot/sdk/ui/camera/FinderOverlayView;", "Lio/scanbot/sdk/document/DocumentDetectionStatus;", "detectionStatus", "", "frameWidth", "frameHeight", "frameOrientation", "", "Landroid/graphics/PointF;", "polygon", "", "handleDetectionResult", "(Lio/scanbot/sdk/document/DocumentDetectionStatus;IIILjava/util/List;)V", "Landroidx/core/graphics/Insets;", "insets", "a", "(Landroidx/core/graphics/Insets;)V", "Landroid/animation/AnimatorSet;", "Landroid/animation/AnimatorSet;", "finderAnimation", "Lio/scanbot/sdk/document/DocumentScannerFrameHandler$ResultHandler;", "b", "Lio/scanbot/sdk/document/DocumentScannerFrameHandler$ResultHandler;", "getDocumentScannerFrameHandler", "()Lio/scanbot/sdk/document/DocumentScannerFrameHandler$ResultHandler;", "documentScannerFrameHandler", "Landroid/content/Context;", "context", "Landroid/util/AttributeSet;", "attr", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "sdk-docscanning_release"})
@SourceDebugExtension(value={"SMAP\nAdaptiveFinderOverlayView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdaptiveFinderOverlayView.kt\nio/scanbot/sdk/ui/camera/AdaptiveFinderOverlayView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n2333#2,14:168\n1#3:182\n*S KotlinDebug\n*F\n+ 1 AdaptiveFinderOverlayView.kt\nio/scanbot/sdk/ui/camera/AdaptiveFinderOverlayView\n*L\n96#1:168,14\n*E\n"})
public class AdaptiveFinderOverlayView
extends FinderOverlayView {
    @NotNull
    public AnimatorSet a;
    @NotNull
    public final DocumentScannerFrameHandler.ResultHandler b;

    /*
     * WARNING - void declaration
     */
    public AdaptiveFinderOverlayView(@NotNull Context context, @Nullable AttributeSet attr) {
        void var2_2;
        void var1_1;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"context");
        super((Context)v1, (AttributeSet)var2_2);
        adaptiveFinderOverlayView.a = new AnimatorSet();
        LayoutTransition layoutTransition = new LayoutTransition();
        layoutTransition.enableTransitionType(4);
        adaptiveFinderOverlayView.setLayoutTransition(layoutTransition);
        adaptiveFinderOverlayView.b = arg_0 -> AdaptiveFinderOverlayView.a(adaptiveFinderOverlayView, arg_0);
    }

    public static final boolean a(AdaptiveFinderOverlayView this$0, FrameHandlerResult result) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        FrameHandlerResult frameHandlerResult = result;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)frameHandlerResult, (String)"result");
        if (frameHandlerResult instanceof FrameHandlerResult.Success) {
            AdaptiveFinderOverlayView adaptiveFinderOverlayView2 = adaptiveFinderOverlayView;
            DocumentScannerFrameHandler.DetectedFrame detectedFrame = (DocumentScannerFrameHandler.DetectedFrame)((FrameHandlerResult.Success)var1_1).getValue();
            adaptiveFinderOverlayView = detectedFrame.detectionStatus;
            int n = detectedFrame.frameWidth;
            int n2 = detectedFrame.frameHeight;
            int n3 = detectedFrame.frameOrientation;
            List<PointF> list = detectedFrame.polygon;
            adaptiveFinderOverlayView2.handleDetectionResult((DocumentDetectionStatus)adaptiveFinderOverlayView, n, n2, n3, list);
        } else {
            boolean cfr_ignored_0 = var1_1 instanceof FrameHandlerResult.Failure;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final void a(AdaptiveFinderOverlayView this$0, Insets $calculatedInset) {
        void var1_1;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"$calculatedInset");
        this$0.a((Insets)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final void a(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)v0, (String)"valueAnimator");
        Object object = v0.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        this$0.setOverlayRightPadding((Integer)object);
    }

    /*
     * WARNING - void declaration
     */
    public static final void b(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)v0, (String)"valueAnimator");
        Object object = v0.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        this$0.setOverlayLeftPadding((Integer)object);
    }

    /*
     * WARNING - void declaration
     */
    public static final void c(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)v0, (String)"valueAnimator");
        Object object = v0.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        this$0.setOverlayTopPadding((Integer)object);
    }

    /*
     * WARNING - void declaration
     */
    public static final void d(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        void var1_1;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView2 = this$0;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)v1, (String)"valueAnimator");
        Object object = v1.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        adaptiveFinderOverlayView2.setOverlayBottomPadding((Integer)object);
        adaptiveFinderOverlayView2.initPaintAndRect();
        adaptiveFinderOverlayView2.invalidate();
        adaptiveFinderOverlayView2.resizeContentViews();
    }

    @NotNull
    public final DocumentScannerFrameHandler.ResultHandler getDocumentScannerFrameHandler() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void handleDetectionResult(@NotNull DocumentDetectionStatus detectionStatus, int frameWidth, int frameHeight, int frameOrientation, @NotNull List<? extends PointF> polygon) {
        void var2_11;
        void var4_18;
        void var3_15;
        void var2_4;
        AspectRatio aspectRatio;
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"detectionStatus");
        Intrinsics.checkNotNullParameter((Object)aspectRatio, (String)"polygon");
        if (this.getFixedFinderWidthInPx() > 0 && this.getFixedFinderHeightInPx() > 0) {
            return;
        }
        List list = this.getRequiredAspectRatios();
        if (list == null) return;
        if (list.isEmpty()) return;
        if (this.a.isRunning()) {
            return;
        }
        if (!(aspectRatio.isEmpty() ^ true)) return;
        if (var1_2 != DocumentDetectionStatus.OK && var1_2 != DocumentDetectionStatus.OK_BUT_BAD_ANGLES && var1_2 != DocumentDetectionStatus.OK_BUT_BAD_ASPECT_RATIO && var1_2 != DocumentDetectionStatus.OK_BUT_TOO_SMALL && var1_2 != DocumentDetectionStatus.OK_BUT_ORIENTATION_MISMATCH) {
            if (var1_2 != DocumentDetectionStatus.OK_BUT_OFF_CENTER) return;
        }
        Pair pair = this.calculatePreviewFrameSize();
        int n = ((Number)pair.component1()).intValue();
        int n2 = ((Number)pair.component2()).intValue();
        int n3 = n2;
        int n4 = n;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        n3 = (adaptiveFinderOverlayView.getMeasuredHeight() - n3) / 2;
        n = (adaptiveFinderOverlayView.getMeasuredWidth() - n) / 2;
        Pair pair2 = adaptiveFinderOverlayView.calculateTotalPaddings(n, n3);
        int n5 = ((Number)pair2.component2()).intValue();
        int n6 = n4 - ((Number)pair2.component1()).intValue();
        n5 = n2 - n5;
        double d = (double)n6 / (double)n5;
        float f = PolygonHelper.Companion.approximatePolygonAspectRatio((List)aspectRatio, (int)var2_4, (int)var3_15, (int)var4_18);
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            Object var2_6 = null;
        } else {
            void var4_20;
            Iterator iterator2 = iterator;
            Object t = iterator2.next();
            if (iterator2.hasNext()) {
                AspectRatio aspectRatio2 = (AspectRatio)t;
                double d2 = f;
                double d3 = Math.abs(d2 - aspectRatio2.getWidth() / aspectRatio2.getHeight());
                do {
                    Object t2;
                    double d4;
                    if (Double.compare(d3, d4 = Math.abs(d2 - (aspectRatio = (AspectRatio)(t2 = iterator.next())).getWidth() / aspectRatio.getHeight())) <= 0) continue;
                    Object t3 = t2;
                    d3 = d4;
                } while (iterator.hasNext());
            }
            void var2_7 = var4_20;
        }
        AspectRatio aspectRatio3 = (AspectRatio)var2_11;
        if (aspectRatio3 != null) {
            d = aspectRatio3.getWidth() / aspectRatio3.getHeight();
        }
        AdaptiveFinderOverlayView adaptiveFinderOverlayView2 = this;
        Pair pair3 = adaptiveFinderOverlayView2.calculateTargetSize(d, n5, n6);
        int n7 = ((Number)pair3.component1()).intValue();
        int n8 = ((Number)pair3.component2()).intValue();
        n8 = (n5 - n8) / 2;
        int n10 = adaptiveFinderOverlayView2.getFinderInsets().top + n8;
        n10 = Math.max(adaptiveFinderOverlayView2.getSafeAreaInsets().top, n3) + n10;
        n8 = adaptiveFinderOverlayView2.getFinderInsets().bottom + n8;
        n8 = Math.max(adaptiveFinderOverlayView2.getSafeAreaInsets().bottom, n3) + n8;
        int n11 = (n6 - n7) / 2;
        int n12 = adaptiveFinderOverlayView2.getFinderInsets().left + n11;
        int n13 = Math.max(adaptiveFinderOverlayView2.getSafeAreaInsets().left, n) + n12;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView3 = this;
        int n14 = adaptiveFinderOverlayView3.getFinderInsets().right + n11;
        n14 = Math.max(adaptiveFinderOverlayView3.getSafeAreaInsets().right, n) + n14;
        Insets.of((int)n13, (int)n10, (int)n14, (int)n8);
        Insets insets = Insets.of((int)n13, (int)n10, (int)n14, (int)n8);
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"of(...)");
        adaptiveFinderOverlayView2.post(() -> AdaptiveFinderOverlayView.a(adaptiveFinderOverlayView2, insets));
    }

    /*
     * WARNING - void declaration
     */
    public final void a(Insets insets) {
        void var1_1;
        if (this.getOverlayRightPadding() == var1_1.right && this.getOverlayLeftPadding() == var1_1.left && this.getOverlayTopPadding() == var1_1.top && this.getOverlayBottomPadding() == var1_1.bottom) {
            return;
        }
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        int n = this.getOverlayRightPadding();
        int n2 = var1_1.right;
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{n, n2});
        valueAnimator.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.a(this, arg_0));
        n2 = this.getOverlayLeftPadding();
        int n3 = var1_1.left;
        ValueAnimator valueAnimator2 = ValueAnimator.ofInt((int[])new int[]{n2, n3});
        valueAnimator2.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.b(this, arg_0));
        n3 = this.getOverlayTopPadding();
        int n4 = var1_1.top;
        ValueAnimator valueAnimator3 = ValueAnimator.ofInt((int[])new int[]{n3, n4});
        valueAnimator3.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.c(this, arg_0));
        n4 = this.getOverlayBottomPadding();
        int n5 = var1_1.bottom;
        ValueAnimator valueAnimator4 = ValueAnimator.ofInt((int[])new int[]{n4, n5});
        valueAnimator4.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.d(this, arg_0));
        adaptiveFinderOverlayView.a.end();
        adaptiveFinderOverlayView.a.cancel();
        this.a = new AnimatorSet();
        this.a.playTogether(new Animator[]{valueAnimator, valueAnimator2, valueAnimator3, valueAnimator4});
        this.a.setDuration(200L);
        this.a.start();
    }
}

