/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.graphics.PointF;
import androidx.core.graphics.Insets;
import io.scanbot.sdk.documentscanner.DocumentDetectionStatus;
import io.scanbot.sdk.geometry.AspectRatio;
import io.scanbot.sdk.ui.camera.FinderCoreMath;
import io.scanbot.sdk.util.PolygonHelper;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JV\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\r\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/ui/camera/AdaptiveFinderCoreMath;", "Lio/scanbot/sdk/ui/camera/FinderCoreMath;", "<init>", "()V", "insetsFromDetectionResult", "Landroidx/core/graphics/Insets;", "detectionStatus", "Lio/scanbot/sdk/documentscanner/DocumentDetectionStatus;", "frameWidth", "", "frameHeight", "frameOrientation", "polygon", "", "Landroid/graphics/PointF;", "measuredWidth", "measuredHeight", "aspectRatios", "Lio/scanbot/sdk/geometry/AspectRatio;", "sdk-docscanning_release"})
@SourceDebugExtension(value={"SMAP\nAdaptiveFinderOverlayView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdaptiveFinderOverlayView.kt\nio/scanbot/sdk/ui/camera/AdaptiveFinderCoreMath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n2423#2,14:201\n1#3:215\n*S KotlinDebug\n*F\n+ 1 AdaptiveFinderOverlayView.kt\nio/scanbot/sdk/ui/camera/AdaptiveFinderCoreMath\n*L\n178#1:201,14\n*E\n"})
public final class AdaptiveFinderCoreMath
extends FinderCoreMath {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Insets insetsFromDetectionResult(@NotNull DocumentDetectionStatus detectionStatus, int frameWidth, int frameHeight, int frameOrientation, @NotNull List<? extends PointF> polygon, int measuredWidth, int measuredHeight, @Nullable List<AspectRatio> aspectRatios) {
        void var2_11;
        void var4_18;
        void var3_15;
        void var2_4;
        void var7_26;
        void var6_25;
        void var8_29;
        AspectRatio aspectRatio;
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"detectionStatus");
        Intrinsics.checkNotNullParameter((Object)aspectRatio, (String)"polygon");
        if (this.getFixedFinderWidthInPx() > 0 && this.getFixedFinderHeightInPx() > 0) {
            return null;
        }
        if (var8_29 == null) return null;
        if (var8_29.isEmpty()) {
            return null;
        }
        if (aspectRatio.isEmpty()) return null;
        if (var1_2 != DocumentDetectionStatus.OK && var1_2 != DocumentDetectionStatus.OK_BUT_BAD_ANGLES && var1_2 != DocumentDetectionStatus.OK_BUT_BAD_ASPECT_RATIO && var1_2 != DocumentDetectionStatus.OK_BUT_TOO_SMALL) {
            if (var1_2 != DocumentDetectionStatus.OK_BUT_ORIENTATION_MISMATCH) return null;
        }
        Pair pair = this.calculatePreviewFrameSize((int)var6_25, (int)var7_26);
        int n = ((Number)pair.component1()).intValue();
        int n2 = ((Number)pair.component2()).intValue();
        int n3 = n2;
        int n4 = n;
        int n5 = n;
        n = (var7_26 - n3) / 2;
        var6_25 = (var6_25 - n5) / 2;
        Pair pair2 = this.calculateTotalPaddings((int)var6_25, n);
        int n6 = ((Number)pair2.component2()).intValue();
        n3 = n4 - ((Number)pair2.component1()).intValue();
        n6 = n2 - n6;
        double d = (double)n3 / (double)n6;
        float f = PolygonHelper.Companion.approximatePolygonAspectRatio((List)aspectRatio, (int)var2_4, (int)var3_15, (int)var4_18);
        Iterator iterator = var8_29.iterator();
        if (!iterator.hasNext()) {
            Object var2_6 = null;
        } else {
            void var4_20;
            Iterator iterator2 = iterator;
            Object t = iterator2.next();
            if (iterator2.hasNext()) {
                AspectRatio aspectRatio2 = (AspectRatio)t;
                double d2 = f;
                double d3 = Math.abs(d2 - aspectRatio2.getWidth() / aspectRatio2.getHeight());
                do {
                    Object t2;
                    double d4;
                    if (Double.compare(d3, d4 = Math.abs(d2 - (aspectRatio = (AspectRatio)(t2 = iterator.next())).getWidth() / aspectRatio.getHeight())) <= 0) continue;
                    Object t3 = t2;
                    d3 = d4;
                } while (iterator.hasNext());
            }
            void var2_7 = var4_20;
        }
        AspectRatio aspectRatio3 = (AspectRatio)var2_11;
        if (aspectRatio3 != null) {
            d = aspectRatio3.getWidth() / aspectRatio3.getHeight();
        }
        AdaptiveFinderCoreMath adaptiveFinderCoreMath = this;
        Pair pair3 = adaptiveFinderCoreMath.calculateTargetSize(d, n6, n3);
        int n7 = ((Number)pair3.component1()).intValue();
        int n8 = ((Number)pair3.component2()).intValue();
        n8 = (n6 - n8) / 2;
        int n10 = adaptiveFinderCoreMath.getFinderInsets().top + n8;
        n10 = Math.max(adaptiveFinderCoreMath.getSafeAreaInsets().top, n) + n10;
        n8 = adaptiveFinderCoreMath.getFinderInsets().bottom + n8;
        n = Math.max(adaptiveFinderCoreMath.getSafeAreaInsets().bottom, n) + n8;
        int n11 = (n3 - n7) / 2;
        n8 = adaptiveFinderCoreMath.getFinderInsets().left + n11;
        AdaptiveFinderCoreMath adaptiveFinderCoreMath2 = this;
        int n12 = adaptiveFinderCoreMath2.getFinderInsets().right + n11;
        Insets insets = Insets.of((int)(Math.max(adaptiveFinderCoreMath.getSafeAreaInsets().left, (int)var6_25) + n8), (int)n10, (int)(Math.max(adaptiveFinderCoreMath2.getSafeAreaInsets().right, (int)var6_25) + n12), (int)n);
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"of(...)");
        return insets;
    }
}

