/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.BitmapInput;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.PagesInput;
import io.scanbot.sdk.docprocessing.compose.PdfRendererInput;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.docprocessing.compose.UrisInput;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.exceptions.ocr.OcrBlobException;
import io.scanbot.sdk.ocr.ScanbotOpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0014\u001a\u00020\u0012\u0012\u0006\u0010\u0017\u001a\u00020\u0015\u0012\u0006\u0010\u001a\u001a\u00020\u0018\u0012\u0006\u0010\u001e\u001a\u00020\u001b\u0012\u0006\u0010\"\u001a\u00020\u001f\u00a2\u0006\u0004\b'\u0010(J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J(\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J(\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J(\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001a\u0010\f\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0002R\u0014\u0010\u0014\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0019R\u0014\u0010\u001e\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\"\u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010&\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "Lio/scanbot/sdk/entity/Document;", "document", "Lio/scanbot/sdk/docprocessing/compose/PdfRendererInput;", "input", "", "composeDocument", "", "Lio/scanbot/sdk/entity/Language;", "availableLanguages", "", "a", "c", "b", "detectedText", "", "ocrStartedMillis", "Lio/scanbot/sdk/blob/BlobManager;", "Lio/scanbot/sdk/blob/BlobManager;", "blobManager", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "pdfRenderer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "simpleComposer", "Lio/scanbot/sap/SapManager;", "d", "Lio/scanbot/sap/SapManager;", "sapManager", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "e", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "ocrSettings", "Lio/scanbot/sdk/util/log/Logger;", "f", "Lio/scanbot/sdk/util/log/Logger;", "logger", "<init>", "(Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "sdk-ocr_release"})
public final class OcrComposer
implements Composer {
    @NotNull
    public final BlobManager a;
    @NotNull
    public final OcrPdfRenderer b;
    @NotNull
    public final SimpleComposer c;
    @NotNull
    public final SapManager d;
    @NotNull
    public final OcrSettings e;
    @NotNull
    public final Logger f;

    /*
     * WARNING - void declaration
     */
    public OcrComposer(@NotNull BlobManager blobManager, @NotNull OcrPdfRenderer pdfRenderer, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrSettings ocrSettings) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        OcrComposer ocrComposer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfRenderer");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"ocrSettings");
        this.a = var1_1;
        this.b = var2_2;
        this.c = var3_3;
        this.d = var4_4;
        ocrComposer.e = var5_5;
        ocrComposer.f = LoggerProvider.getLogger();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void composeDocument(@NotNull Document document, @NotNull PdfRendererInput input) throws IOException {
        Set set;
        long l;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"input");
        if (!this.d.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return;
        }
        try {
            l = SystemClock.elapsedRealtime();
            set = this.a.getAllLanguagesWithAvailableOcrBlobs();
        }
        catch (IOException iOException) {
            this.c.composeDocument((Document)var1_1, (PdfRendererInput)var2_2);
            return;
        }
        {
            if (!set.isEmpty()) {
                OcrComposer ocrComposer = this;
                ocrComposer.a((Document)var1_1, ocrComposer.c((Document)var1_1, (PdfRendererInput)var2_2, set));
                ocrComposer.a((Document)var1_1, l);
                return;
            }
            this.f.d("OCR", "OCR languages blobs are not available - abort OCR");
            throw new OcrBlobException("OCR languages blobs are not available");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String a(Document document, PdfRendererInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.c((Document)var1_1, (PdfRendererInput)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final String c(Document document, PdfRendererInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        this.f.d("OCR", "Starting OCR with languages: " + var3_3);
        return this.b((Document)var1_1, (PdfRendererInput)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String b(Document document, PdfRendererInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var3_3;
        OcrPdfRenderer.RenderIterator renderIterator;
        List list;
        ScanbotOpticalCharacterRecognizer.RecognizerInput recognizerInput;
        if (input instanceof PagesInput) {
            ScanbotOpticalCharacterRecognizer.PagesInput pagesInput;
            recognizerInput = pagesInput;
            pagesInput = new ScanbotOpticalCharacterRecognizer.PagesInput(((PagesInput)list).getPages(), null, null, 6, null);
        } else if (list instanceof UrisInput) {
            ScanbotOpticalCharacterRecognizer.UrisInput urisInput;
            recognizerInput = urisInput;
            UrisInput urisInput2 = (UrisInput)list;
            list = urisInput2.getUris();
            urisInput = new ScanbotOpticalCharacterRecognizer.UrisInput(list, urisInput2.getInputEncrypted(), null, null, 12, null);
        } else {
            ScanbotOpticalCharacterRecognizer.BitmapInput bitmapInput;
            if (!(list instanceof BitmapInput)) {
                throw new NoWhenBranchMatchedException();
            }
            recognizerInput = bitmapInput;
            bitmapInput = new ScanbotOpticalCharacterRecognizer.BitmapInput(((BitmapInput)list).getBitmap(), null, null, 6, null);
        }
        renderIterator = this.b.startRender((Document)renderIterator, recognizerInput, (Collection<? extends Language>)var3_3, this.e);
        try {
            while (renderIterator.renderNextPage()) {
                this.f.d("OCR", "Page rendered: " + renderIterator.getDetectedText());
            }
            String string = renderIterator.getDetectedText();
            renderIterator.recycle();
            return string;
        }
        catch (Throwable throwable) {
            renderIterator.recycle();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void a(Document document, String detectedText) {
        void var1_1;
        void var2_2;
        var1_1.ocrStatus = OcrStatus.DONE;
        var1_1.ocrText = var2_2;
        this.a((Document)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void a(Document document, long ocrStartedMillis) {
        StringBuilder stringBuilder;
        void var2_3;
        if (document.language == null) {
            return;
        }
        long l = SystemClock.elapsedRealtime() - var2_3;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2("Ocr total: ");
        this.f.d("OCR", stringBuilder.append((float)l / 1000.0f).append(" sec").toString());
    }

    public final void a(Document document) {
        if (document.language != null) {
            StringBuilder stringBuilder;
            String string;
            void v0 = string;
            OcrComposer ocrComposer = ocrComposer.f;
            string = "OCR";
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder("Document language assigned: ");
            Object object = v0.language;
            object = object != null ? object.getOcrBlobLanguageTag() : null;
            ocrComposer.d(string, stringBuilder2.append((String)object).toString());
        }
    }
}

