/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.BitmapInput;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.DocumentInput;
import io.scanbot.sdk.docprocessing.compose.PagesInput;
import io.scanbot.sdk.docprocessing.compose.PdfGeneratorInput;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.docprocessing.compose.UrisInput;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.exceptions.ocr.OcrBlobException;
import io.scanbot.sdk.ocr.ScanbotOcrEngine;
import io.scanbot.sdk.ocr.intelligence.OcrPdfGenerator;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "Lio/scanbot/sdk/blob/BlobManager;", "blobManager", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfGenerator;", "pdfGenerator", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "simpleComposer", "Lio/scanbot/sap/SapManager;", "sapManager", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "ocrSettings", "<init>", "(Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfGenerator;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "Lio/scanbot/sdk/entity/Document;", "document", "Lio/scanbot/sdk/docprocessing/compose/PdfGeneratorInput;", "input", "", "composeDocument", "(Lio/scanbot/sdk/entity/Document;Lio/scanbot/sdk/docprocessing/compose/PdfGeneratorInput;)V", "sdk-ocr_release"}, xi=48)
public final class OcrComposer
implements Composer {
    public final BlobManager a;
    public final OcrPdfGenerator b;
    public final SimpleComposer c;
    public final SapManager d;
    public final OcrSettings e;
    public final Logger f;

    /*
     * WARNING - void declaration
     */
    public OcrComposer(@NotNull BlobManager blobManager, @NotNull OcrPdfGenerator pdfGenerator, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrSettings ocrSettings) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        OcrComposer ocrComposer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfGenerator");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"ocrSettings");
        this.a = var1_1;
        this.b = var2_2;
        this.c = var3_3;
        this.d = var4_4;
        ocrComposer.e = var5_5;
        ocrComposer.f = LoggerProvider.getLogger();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void composeDocument(@NotNull Document document, @NotNull PdfGeneratorInput input) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"input");
        if (!this.d.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return;
        }
        try {
            long l = SystemClock.elapsedRealtime();
            Object object = this.a.getAllLanguagesWithAvailableOcrBlobs();
            if (!object.isEmpty()) {
                object = this.b((Document)var1_1, (PdfGeneratorInput)var2_2, (Set)object);
                var1_1.ocrStatus = OcrStatus.DONE;
                var1_1.ocrText = object;
                this.a((Document)var1_1);
                this.a((Document)var1_1, l);
                return;
            }
            this.f.d("OCR", "OCR languages blobs are not available - abort OCR");
            throw new OcrBlobException("OCR languages blobs are not available");
        }
        catch (IOException iOException) {}
        this.c.composeDocument((Document)var1_1, (PdfGeneratorInput)var2_2);
    }

    public final String b(Document document, PdfGeneratorInput pdfGeneratorInput, Set set) {
        this.f.d("OCR", "Starting OCR with languages: " + set);
        return this.a(document, pdfGeneratorInput, set);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String a(Document object, PdfGeneratorInput object2, Set set) {
        Throwable throwable2;
        block10: {
            ScanbotOcrEngine.EngineInput engineInput;
            if (object2 instanceof PagesInput) {
                ScanbotOcrEngine.PagesInput pagesInput;
                engineInput = pagesInput;
                pagesInput = new ScanbotOcrEngine.PagesInput(((PagesInput)object2).getPages(), null, null, null, null, 30, null);
            } else if (object2 instanceof UrisInput) {
                ScanbotOcrEngine.UrisInput urisInput;
                engineInput = urisInput;
                UrisInput urisInput2 = (UrisInput)object2;
                object2 = urisInput2.getUris();
                urisInput = new ScanbotOcrEngine.UrisInput((List)object2, urisInput2.getInputEncrypted(), null, null, null, null, 60, null);
            } else if (object2 instanceof BitmapInput) {
                ScanbotOcrEngine.BitmapInput bitmapInput;
                engineInput = bitmapInput;
                bitmapInput = new ScanbotOcrEngine.BitmapInput(((BitmapInput)object2).getBitmap(), null, null, null, null, 30, null);
            } else {
                ScanbotOcrEngine.DocumentInput documentInput;
                if (!(object2 instanceof DocumentInput)) {
                    throw new NoWhenBranchMatchedException();
                }
                engineInput = documentInput;
                documentInput = new ScanbotOcrEngine.DocumentInput(((DocumentInput)object2).getDocument(), null, null, null, null, 30, null);
            }
            object = this.b.startGeneration((Document)object, engineInput, set, this.e);
            try {
                while (object.generateNextPage()) {
                    this.f.d("OCR", "Page generated: " + object.getDetectedText());
                }
            }
            catch (Throwable throwable2) {
                break block10;
            }
            String string = object.getDetectedText();
            object.recycle();
            return string;
        }
        object.recycle();
        throw throwable2;
    }

    public final void a(Document document, long l) {
        if (document.language == null) {
            return;
        }
        long l2 = SystemClock.elapsedRealtime() - l;
        this.f.d("OCR", "Ocr total: " + (float)l2 / 1000.0f + " sec");
    }

    public final void a(Document document) {
        document = document.language;
        if (document != null) {
            this.f.d("OCR", "Document language assigned: " + document.getOcrBlobLanguageTag());
        }
    }
}

