/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.docprocessing.compose;

import android.os.SystemClock;
import io.scanbot.common.Result;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.BitmapInput;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerCache;
import io.scanbot.sdk.docprocessing.compose.DocumentInput;
import io.scanbot.sdk.docprocessing.compose.ImageRefsInput;
import io.scanbot.sdk.docprocessing.compose.PagesInput;
import io.scanbot.sdk.docprocessing.compose.PdfGeneratorInput;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.docprocessing.compose.UrisInput;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.exceptions.ocr.OcrBlobException;
import io.scanbot.sdk.licensing.Feature;
import io.scanbot.sdk.ocr.OcrEngineManager;
import io.scanbot.sdk.ocr.ScanbotOcrEngineManager;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.pdf.BitmapBinarizer;
import io.scanbot.sdk.ocr.pdf.GenerationIterator;
import io.scanbot.sdk.ocr.pdf.TesseractGenerationIteratorImpl;
import io.scanbot.sdk.ocr.pdf.TldrGenerationIteratorImpl;
import io.scanbot.sdk.persistence.document.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.page.legacy.PageFileStorage;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J(\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J(\u0010%\u001a\u0004\u0018\u00010 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u001a\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010'\u001a\u0004\u0018\u00010 H\u0002J\u0018\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/scanbot/sdk/ocr/docprocessing/compose/OcrComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;", "pageFileStorage", "Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;", "bitmapBinarizer", "Lio/scanbot/sdk/ocr/pdf/BitmapBinarizer;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "composerCache", "Lio/scanbot/sdk/docprocessing/compose/ComposerCache;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "sapManager", "Lio/scanbot/sap/SapManager;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "<init>", "(Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;Lio/scanbot/sdk/ocr/pdf/BitmapBinarizer;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/docprocessing/compose/ComposerCache;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "composeDocument", "Lio/scanbot/common/Result;", "", "document", "Lio/scanbot/sdk/entity/Document;", "input", "Lio/scanbot/sdk/docprocessing/compose/PdfGeneratorInput;", "createPDF", "", "availableLanguages", "", "Lio/scanbot/sdk/entity/Language;", "performOCR", "ocrWithDefaultLanguage", "saveMetaData", "detectedText", "trackDuration", "ocrStartedMillis", "", "trackDocument", "sdk-ocr_release"})
public final class OcrComposer
implements Composer {
    @NotNull
    private final FileIOProcessor fileIOProcessor;
    @NotNull
    private final DocumentStoreStrategy documentStoreStrategy;
    @NotNull
    private final PageFileStorage pageFileStorage;
    @NotNull
    private final BitmapBinarizer bitmapBinarizer;
    @NotNull
    private final BlobManager blobManager;
    @NotNull
    private final ComposerCache composerCache;
    @NotNull
    private final SimpleComposer simpleComposer;
    @NotNull
    private final SapManager sapManager;
    @NotNull
    private final OcrSettings ocrSettings;
    @NotNull
    private final Logger logger;

    /*
     * WARNING - void declaration
     */
    public OcrComposer(@NotNull FileIOProcessor fileIOProcessor, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull PageFileStorage pageFileStorage, @NotNull BitmapBinarizer bitmapBinarizer, @NotNull BlobManager blobManager, @NotNull ComposerCache composerCache, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrSettings ocrSettings) {
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        OcrComposer ocrComposer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"bitmapBinarizer");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"composerCache");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var8_8, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var9_9, (String)"ocrSettings");
        this.fileIOProcessor = var1_1;
        this.documentStoreStrategy = var2_2;
        this.pageFileStorage = var3_3;
        this.bitmapBinarizer = var4_4;
        this.blobManager = var5_5;
        this.composerCache = var6_6;
        this.simpleComposer = var7_7;
        this.sapManager = var8_8;
        ocrComposer.ocrSettings = var9_9;
        ocrComposer.logger = LoggerProvider.getLogger();
    }

    /*
     * WARNING - void declaration
     */
    private final String createPDF(Document document, PdfGeneratorInput input, Set<? extends Language> availableLanguages) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.performOCR((Document)var1_1, (PdfGeneratorInput)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final String performOCR(Document document, PdfGeneratorInput input, Set<? extends Language> availableLanguages) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.logger.d("OCR", "Starting OCR with languages: " + (Set)var3_3);
        return this.ocrWithDefaultLanguage((Document)var1_1, (PdfGeneratorInput)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String ocrWithDefaultLanguage(Document document, PdfGeneratorInput input, Set<? extends Language> availableLanguages) {
        Throwable throwable2;
        GenerationIterator generationIterator;
        block15: {
            List list;
            ScanbotOcrEngineManager.EngineInput engineInput;
            if (input instanceof PagesInput) {
                ScanbotOcrEngineManager.PagesInput pagesInput;
                engineInput = pagesInput;
                pagesInput = new ScanbotOcrEngineManager.PagesInput(((PagesInput)list).getPages(), null, null, null, null, 30, null);
            } else if (list instanceof UrisInput) {
                ScanbotOcrEngineManager.UrisInput urisInput;
                engineInput = urisInput;
                UrisInput urisInput2 = (UrisInput)list;
                list = urisInput2.getUris();
                urisInput = new ScanbotOcrEngineManager.UrisInput(list, urisInput2.getInputEncrypted(), null, null, null, null, 60, null);
            } else if (list instanceof BitmapInput) {
                ScanbotOcrEngineManager.BitmapInput bitmapInput;
                engineInput = bitmapInput;
                bitmapInput = new ScanbotOcrEngineManager.BitmapInput(((BitmapInput)list).getBitmap(), null, null, null, null, 30, null);
            } else if (list instanceof DocumentInput) {
                ScanbotOcrEngineManager.DocumentInput documentInput;
                engineInput = documentInput;
                documentInput = new ScanbotOcrEngineManager.DocumentInput(((DocumentInput)list).getDocument(), null, null, null, null, 30, null);
            } else {
                ScanbotOcrEngineManager.ImageRefsInput imageRefsInput;
                if (!(list instanceof ImageRefsInput)) {
                    throw new NoWhenBranchMatchedException();
                }
                engineInput = imageRefsInput;
                imageRefsInput = new ScanbotOcrEngineManager.ImageRefsInput(((ImageRefsInput)list).getImages(), null, null, null, null, 30, null);
            }
            int n = WhenMappings.$EnumSwitchMapping$0[((ScanbotOcrEngineManager.EngineInput)engineInput).getEngineMode().ordinal()];
            if (n != 1) {
                TldrGenerationIteratorImpl tldrGenerationIteratorImpl;
                if (n != 2) {
                    throw new NoWhenBranchMatchedException();
                }
                generationIterator = tldrGenerationIteratorImpl;
                OcrComposer ocrComposer = this;
                var3_5 = ocrComposer.documentStoreStrategy;
                var5_7 = ocrComposer.pageFileStorage;
                var6_8 = ocrComposer.fileIOProcessor;
                tldrGenerationIteratorImpl = new TldrGenerationIteratorImpl(var3_5, (PageFileStorage)var5_7, (FileIOProcessor)var6_8, (Document)var1_1, engineInput);
            } else {
                TesseractGenerationIteratorImpl tesseractGenerationIteratorImpl;
                generationIterator = tesseractGenerationIteratorImpl;
                OcrComposer ocrComposer = this;
                var5_7 = ocrComposer.documentStoreStrategy;
                var6_8 = ocrComposer.pageFileStorage;
                FileIOProcessor fileIOProcessor = ocrComposer.fileIOProcessor;
                BlobManager blobManager = ocrComposer.blobManager;
                ComposerCache composerCache = ocrComposer.composerCache;
                BitmapBinarizer bitmapBinarizer = ocrComposer.bitmapBinarizer;
                OcrSettings ocrSettings = ocrComposer.ocrSettings;
                tesseractGenerationIteratorImpl = new TesseractGenerationIteratorImpl(var5_7, var6_8, fileIOProcessor, blobManager, composerCache, bitmapBinarizer, (Document)var1_1, engineInput, (Collection<? extends Language>)var3_5, ocrSettings);
            }
            try {
                while (generationIterator.generateNextPage()) {
                    this.logger.d("OCR", "Page generated: " + generationIterator.getDetectedText());
                }
            }
            catch (Throwable throwable2) {
                break block15;
            }
            String string = generationIterator.getDetectedText();
            generationIterator.recycle();
            return string;
        }
        generationIterator.recycle();
        throw throwable2;
    }

    /*
     * WARNING - void declaration
     */
    private final void saveMetaData(Document document, String detectedText) {
        void var1_1;
        void var2_2;
        var1_1.ocrStatus = OcrStatus.DONE;
        var1_1.ocrText = var2_2;
        this.trackDocument((Document)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void trackDuration(Document document, long ocrStartedMillis) {
        void var2_3;
        if (document.language == null) {
            return;
        }
        long l = SystemClock.elapsedRealtime() - var2_3;
        this.logger.d("OCR", "Ocr total: " + (float)l / 1000.0f + " sec");
    }

    private final void trackDocument(Document document) {
        Object object = document.language;
        if (object != null) {
            OcrComposer ocrComposer = ocrComposer.logger;
            String string = "OCR";
            object = "Document language assigned: " + (object != null ? object.getOcrBlobLanguageTag() : null);
            ocrComposer.d(string, (String)object);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Result<Unit> composeDocument(@NotNull Document document, @NotNull PdfGeneratorInput input) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"input");
        if (!this.sapManager.checkLicenseStatus(Feature.OCR)) {
            return new Result.ComponentUnavailableError("OCR feature is not available due to license restrictions");
        }
        try {
            long l = SystemClock.elapsedRealtime();
            Set set = this.blobManager.getAllLanguagesWithAvailableOcrBlobs();
            if (!set.isEmpty()) {
                this.saveMetaData((Document)var1_1, this.createPDF((Document)var1_1, (PdfGeneratorInput)var2_2, set));
                this.trackDuration((Document)var1_1, l);
                return new Result.Success((Object)Unit.INSTANCE);
            }
            this.logger.d("OCR", "OCR languages blobs are not available - abort OCR");
            throw new OcrBlobException("OCR languages blobs are not available");
        }
        catch (IOException iOException) {
            return this.simpleComposer.composeDocument((Document)var1_1, (PdfGeneratorInput)var2_2);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OcrEngineManager.EngineMode.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[OcrEngineManager.EngineMode.TESSERACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[OcrEngineManager.EngineMode.SCANBOT_OCR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

