/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.common.Result;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.exceptions.ocr.LanguageNotFoundException;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.ocr.OcrEngineManager;
import io.scanbot.sdk.ocr.OcrResult;
import io.scanbot.sdk.ocr.Page;
import io.scanbot.sdk.ocr.intelligence.OcrPerformer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.intelligence.TesseractOcrPerformer;
import io.scanbot.sdk.ocr.intelligence.TldrOcrPerformer;
import io.scanbot.sdk.ocr.pdf.BitmapBinarizer;
import io.scanbot.sdk.pdfgeneration.PdfConfiguration;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.page.legacy.PageFileStorage;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 >2\u00020\u0001:\u0007>?@ABCDBK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\u0010\n\u001a\u00060\u000bj\u0002`\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J$\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0!2\u0006\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0010\u0010)\u001a\f\u0012\b\u0012\u00060*j\u0002`+0!H\u0017J\b\u0010,\u001a\u00020-H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\u0010\u00101\u001a\u0002022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u00103\u001a\u000202H\u0002J\u001e\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u0002000/H\u0002J\u0018\u00109\u001a\u0002022\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager;", "Lio/scanbot/sdk/ocr/OcrEngineManager;", "context", "Landroid/content/Context;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "sapManager", "Lio/scanbot/sap/SapManager;", "blobStoreStrategy", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "pageFileStorage", "Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;", "Lio/scanbot/sdk/ocr/LegacyPageFileStorage;", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "bitmapBinarizer", "Lio/scanbot/sdk/ocr/pdf/BitmapBinarizer;", "<init>", "(Landroid/content/Context;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/persistence/BlobStoreStrategy;Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;Lio/scanbot/sdk/ocr/pdf/BitmapBinarizer;)V", "ocrConfig", "Lio/scanbot/sdk/ocr/OcrEngineManager$OcrConfig;", "recognizeFromBitmap", "Lio/scanbot/common/Result;", "Lio/scanbot/sdk/ocr/OcrResult;", "bitmap", "Landroid/graphics/Bitmap;", "recognizeFromDocument", "document", "Lio/scanbot/sdk/docprocessing/Document;", "recognizeFromImageRefs", "images", "", "Lio/scanbot/sdk/image/ImageRef;", "recognizeFromUris", "imageFileUris", "Landroid/net/Uri;", "sourceFilesEncrypted", "", "recognizeFromPages", "pages", "Lio/scanbot/sdk/persistence/page/legacy/Page;", "Lio/scanbot/sdk/ocr/LegacyPage;", "getLanguageDataPath", "Ljava/io/File;", "getInstalledLanguages", "", "Lio/scanbot/sdk/entity/Language;", "setOcrConfig", "", "checkMissingLangs", "createOcrPerformer", "Lio/scanbot/sdk/ocr/intelligence/OcrPerformer;", "engineInput", "Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$EngineInput;", "languages", "saveStreamToFile", "fileOutputStream", "Ljava/io/OutputStream;", "inputSteam", "Ljava/io/InputStream;", "Companion", "EngineInput", "PagesInput", "BitmapInput", "UrisInput", "DocumentInput", "ImageRefsInput", "sdk-ocr_release"})
@SourceDebugExtension(value={"SMAP\nScanbotOcrEngineManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanbotOcrEngineManager.kt\nio/scanbot/sdk/ocr/ScanbotOcrEngineManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Uri.kt\nandroidx/core/net/UriKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ResultExtentions.kt\nio/scanbot/sdk/common/ResultExtentionsKt\n*L\n1#1,232:1\n774#2:233\n865#2,2:234\n1617#2,9:236\n1869#2:245\n1870#2:248\n1626#2:249\n774#2:250\n865#2,2:251\n1617#2,9:253\n1869#2:262\n1870#2:264\n1626#2:265\n1563#2:266\n1634#2,3:267\n29#3:246\n1#4:247\n1#4:263\n1#4:283\n32#5,13:270\n*S KotlinDebug\n*F\n+ 1 ScanbotOcrEngineManager.kt\nio/scanbot/sdk/ocr/ScanbotOcrEngineManager\n*L\n81#1:233\n81#1:234,2\n81#1:236,9\n81#1:245\n81#1:248\n81#1:249\n90#1:250\n90#1:251,2\n91#1:253,9\n91#1:262\n91#1:264\n91#1:265\n92#1:266\n92#1:267,3\n82#1:246\n81#1:247\n91#1:263\n95#1:283\n95#1:270,13\n*E\n"})
public final class ScanbotOcrEngineManager
implements OcrEngineManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CACHE_DIR = "scanbotOcrEngine";
    @NotNull
    private final Context context;
    @NotNull
    private final BlobManager blobManager;
    @NotNull
    private final SapManager sapManager;
    @NotNull
    private final BlobStoreStrategy blobStoreStrategy;
    @NotNull
    private final PageFileStorage pageFileStorage;
    @NotNull
    private final FileIOProcessor fileIOProcessor;
    @NotNull
    private final OcrSettings ocrSettings;
    @NotNull
    private final BitmapBinarizer bitmapBinarizer;
    @NotNull
    private OcrEngineManager.OcrConfig ocrConfig;

    /*
     * WARNING - void declaration
     */
    public ScanbotOcrEngineManager(@NotNull Context context, @NotNull BlobManager blobManager, @NotNull SapManager sapManager, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor, @NotNull OcrSettings ocrSettings, @NotNull BitmapBinarizer bitmapBinarizer) {
        OcrEngineManager.OcrConfig ocrConfig;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"ocrSettings");
        Intrinsics.checkNotNullParameter((Object)var8_8, (String)"bitmapBinarizer");
        ((ScanbotOcrEngineManager)((Object)this_)).context = var1_1;
        ((ScanbotOcrEngineManager)((Object)this_)).blobManager = var2_2;
        ((ScanbotOcrEngineManager)((Object)this_)).sapManager = var3_3;
        ((ScanbotOcrEngineManager)((Object)this_)).blobStoreStrategy = var4_4;
        ((ScanbotOcrEngineManager)((Object)this_)).pageFileStorage = var5_5;
        ((ScanbotOcrEngineManager)((Object)this_)).fileIOProcessor = var6_6;
        ((ScanbotOcrEngineManager)((Object)this_)).ocrSettings = var7_7;
        ((ScanbotOcrEngineManager)((Object)this_)).bitmapBinarizer = var8_8;
        OcrEngineManager.OcrConfig this_ = ocrConfig;
        ocrConfig = new OcrEngineManager.OcrConfig(null, null, 3, null);
        v1.ocrConfig = this_;
    }

    private final void checkMissingLangs() {
        if (((ScanbotOcrEngineManager)this).ocrConfig.getEngineMode() == OcrEngineManager.EngineMode.SCANBOT_OCR || (this = SetsKt.minus(((ScanbotOcrEngineManager)this).ocrConfig.getLanguages(), ((ScanbotOcrEngineManager)this).getInstalledLanguages())).isEmpty()) {
            return;
        }
        throw new LanguageNotFoundException((Set)this + " Provided set of languages was not presented on device");
    }

    /*
     * WARNING - void declaration
     */
    private final OcrPerformer createOcrPerformer(EngineInput engineInput, Set<? extends Language> languages) {
        void var1_1;
        PageFileStorage pageFileStorage;
        ScanbotOcrEngineManager this_;
        int n = WhenMappings.$EnumSwitchMapping$0[this_.ocrConfig.getEngineMode().ordinal()];
        if (n != 1) {
            if (n == 2) {
                ScanbotOcrEngineManager scanbotOcrEngineManager = this_;
                this_ = scanbotOcrEngineManager.sapManager;
                pageFileStorage = scanbotOcrEngineManager.pageFileStorage;
                FileIOProcessor fileIOProcessor = scanbotOcrEngineManager.fileIOProcessor;
                OcrSettings ocrSettings = scanbotOcrEngineManager.ocrSettings;
                BitmapBinarizer bitmapBinarizer = scanbotOcrEngineManager.bitmapBinarizer;
                return new TldrOcrPerformer((SapManager)this_, pageFileStorage, fileIOProcessor, ocrSettings, bitmapBinarizer, (EngineInput)var1_1);
            }
            throw new NoWhenBranchMatchedException();
        }
        ScanbotOcrEngineManager scanbotOcrEngineManager = this_;
        this_ = scanbotOcrEngineManager.sapManager;
        BlobStoreStrategy blobStoreStrategy = scanbotOcrEngineManager.blobStoreStrategy;
        PageFileStorage pageFileStorage2 = scanbotOcrEngineManager.pageFileStorage;
        FileIOProcessor fileIOProcessor = scanbotOcrEngineManager.fileIOProcessor;
        OcrSettings ocrSettings = scanbotOcrEngineManager.ocrSettings;
        BitmapBinarizer bitmapBinarizer = scanbotOcrEngineManager.bitmapBinarizer;
        return new TesseractOcrPerformer((SapManager)this_, (Set<? extends Language>)pageFileStorage, blobStoreStrategy, pageFileStorage2, fileIOProcessor, ocrSettings, bitmapBinarizer, (EngineInput)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void saveStreamToFile(OutputStream fileOutputStream, InputStream inputSteam) {
        ScanbotOcrEngineManager scanbotOcrEngineManager;
        OutputStream outputStream = fileOutputStream;
        ScanbotOcrEngineManager scanbotOcrEngineManager2 = null;
        try {
            void var2_3;
            outputStream.write(ByteStreamsKt.readBytes((InputStream)var2_3));
            scanbotOcrEngineManager = scanbotOcrEngineManager2;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var1_2;
                CloseableKt.closeFinally((Closeable)var1_2, (Throwable)throwable);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally((Closeable)outputStream, (Throwable)((Object)scanbotOcrEngineManager));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result<OcrResult> recognizeFromBitmap(@NotNull Bitmap bitmap) {
        void var1_1;
        ScanbotOcrEngineManager scanbotOcrEngineManager = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
        scanbotOcrEngineManager.checkMissingLangs();
        return scanbotOcrEngineManager.createOcrPerformer(new BitmapInput((Bitmap)var1_1, null, null, null, null, 30, null), this.ocrConfig.getLanguages()).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result<OcrResult> recognizeFromDocument(@NotNull Document document) {
        void var1_1;
        ScanbotOcrEngineManager scanbotOcrEngineManager = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"document");
        scanbotOcrEngineManager.checkMissingLangs();
        return scanbotOcrEngineManager.createOcrPerformer(new DocumentInput((Document)var1_1, null, null, null, null, 30, null), this.ocrConfig.getLanguages()).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result<OcrResult> recognizeFromImageRefs(@NotNull List<ImageRef> images) {
        void var1_1;
        ScanbotOcrEngineManager scanbotOcrEngineManager = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"images");
        scanbotOcrEngineManager.checkMissingLangs();
        return scanbotOcrEngineManager.createOcrPerformer(new ImageRefsInput((List)var1_1, null, null, null, null, 30, null), this.ocrConfig.getLanguages()).recognize();
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public Result<OcrResult> recognizeFromUris(@NotNull List<? extends Uri> imageFileUris, boolean sourceFilesEncrypted) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 12[TRYBLOCK] [12 : 148->152)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated(message="Use generateFromDocument() instead")
    @NotNull
    public Result<OcrResult> recognizeFromPages(@NotNull List<io.scanbot.sdk.persistence.page.legacy.Page> pages) {
        void var1_1;
        ScanbotOcrEngineManager scanbotOcrEngineManager = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        scanbotOcrEngineManager.checkMissingLangs();
        return scanbotOcrEngineManager.createOcrPerformer(new PagesInput((List)var1_1, null, null, null, null, 30, null), this.ocrConfig.getLanguages()).recognize();
    }

    @Override
    @NotNull
    public File getLanguageDataPath() {
        return this.blobManager.getOcrBlobsDirectory();
    }

    @Override
    @NotNull
    public Set<Language> getInstalledLanguages() {
        return this.blobManager.getAllLanguagesWithAvailableOcrBlobs();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setOcrConfig(@NotNull OcrEngineManager.OcrConfig ocrConfig) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"ocrConfig");
        this.ocrConfig = var1_1;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JE\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u001aH\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$BitmapInput;", "Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$EngineInput;", "bitmap", "Landroid/graphics/Bitmap;", "engineMode", "Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;", "pdfConfig", "Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;", "outputFile", "Ljava/io/File;", "sourceOcrPages", "", "Lio/scanbot/sdk/ocr/Page;", "<init>", "(Landroid/graphics/Bitmap;Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;Ljava/io/File;Ljava/util/List;)V", "getBitmap", "()Landroid/graphics/Bitmap;", "getEngineMode", "()Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;", "getPdfConfig", "()Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;", "getOutputFile", "()Ljava/io/File;", "getSourceOcrPages", "()Ljava/util/List;", "size", "", "getSize", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "", "sdk-ocr_release"})
    public static final class BitmapInput
    extends EngineInput {
        @NotNull
        private final Bitmap bitmap;
        @NotNull
        private final OcrEngineManager.EngineMode engineMode;
        @Nullable
        private final PdfConfiguration pdfConfig;
        @Nullable
        private final File outputFile;
        @NotNull
        private final List<Page> sourceOcrPages;
        private final int size;

        /*
         * WARNING - void declaration
         */
        public BitmapInput(@NotNull Bitmap bitmap, @NotNull OcrEngineManager.EngineMode engineMode, @Nullable PdfConfiguration pdfConfig, @Nullable File outputFile, @NotNull List<Page> sourceOcrPages) {
            void var4_4;
            void var3_3;
            void var5_5;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"engineMode");
            Intrinsics.checkNotNullParameter((Object)var5_5, (String)"sourceOcrPages");
            super(null);
            this.bitmap = var1_1;
            this.engineMode = var2_2;
            this.pdfConfig = var3_3;
            this.outputFile = var4_4;
            this.sourceOcrPages = var5_5;
            this.size = 1;
        }

        public /* synthetic */ BitmapInput(Bitmap bitmap, OcrEngineManager.EngineMode engineMode, PdfConfiguration pdfConfiguration, File file, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                engineMode = OcrEngineManager.EngineMode.SCANBOT_OCR;
            }
            if ((n & 4) != 0) {
                pdfConfiguration = null;
            }
            if ((n & 8) != 0) {
                file = null;
            }
            if ((n & 0x10) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(bitmap, engineMode, pdfConfiguration, file, list);
        }

        public static /* synthetic */ BitmapInput copy$default(BitmapInput bitmapInput, Bitmap bitmap, OcrEngineManager.EngineMode engineMode, PdfConfiguration pdfConfiguration, File file, List list, int n, Object object) {
            if ((n & 1) != 0) {
                bitmap = bitmapInput.bitmap;
            }
            if ((n & 2) != 0) {
                engineMode = bitmapInput.engineMode;
            }
            if ((n & 4) != 0) {
                pdfConfiguration = bitmapInput.pdfConfig;
            }
            if ((n & 8) != 0) {
                file = bitmapInput.outputFile;
            }
            if ((n & 0x10) != 0) {
                list = bitmapInput.sourceOcrPages;
            }
            return bitmapInput.copy(bitmap, engineMode, pdfConfiguration, file, list);
        }

        @NotNull
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        @Override
        @NotNull
        public OcrEngineManager.EngineMode getEngineMode() {
            return this.engineMode;
        }

        @Override
        @Nullable
        public PdfConfiguration getPdfConfig() {
            return this.pdfConfig;
        }

        @Override
        @Nullable
        public File getOutputFile() {
            return this.outputFile;
        }

        @Override
        @NotNull
        public List<Page> getSourceOcrPages() {
            return this.sourceOcrPages;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @NotNull
        public final Bitmap component1() {
            return this.bitmap;
        }

        @NotNull
        public final OcrEngineManager.EngineMode component2() {
            return this.engineMode;
        }

        @Nullable
        public final PdfConfiguration component3() {
            return this.pdfConfig;
        }

        @Nullable
        public final File component4() {
            return this.outputFile;
        }

        @NotNull
        public final List<Page> component5() {
            return this.sourceOcrPages;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BitmapInput copy(@NotNull Bitmap bitmap, @NotNull OcrEngineManager.EngineMode engineMode, @Nullable PdfConfiguration pdfConfig, @Nullable File outputFile, @NotNull List<Page> sourceOcrPages) {
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"engineMode");
            Intrinsics.checkNotNullParameter(sourceOcrPages, (String)"sourceOcrPages");
            return new BitmapInput((Bitmap)var1_1, (OcrEngineManager.EngineMode)var2_2, (PdfConfiguration)var3_3, (File)var4_4, (List<Page>)var5_5);
        }

        @NotNull
        public String toString() {
            BitmapInput bitmapInput = this_;
            Object this_ = bitmapInput.engineMode;
            PdfConfiguration pdfConfiguration = bitmapInput.pdfConfig;
            File file = bitmapInput.outputFile;
            List<Page> list = bitmapInput.sourceOcrPages;
            return "BitmapInput(bitmap=" + this_.bitmap + ", engineMode=" + (OcrEngineManager.EngineMode)((Object)this_) + ", pdfConfig=" + pdfConfiguration + ", outputFile=" + file + ", sourceOcrPages=" + list + ")";
        }

        public int hashCode() {
            BitmapInput bitmapInput = this;
            int n = bitmapInput.bitmap.hashCode() * 31;
            n = (((Object)((Object)bitmapInput.engineMode)).hashCode() + n) * 31;
            PdfConfiguration pdfConfiguration = bitmapInput.pdfConfig;
            int n2 = pdfConfiguration == null ? 0 : pdfConfiguration.hashCode();
            n = (n + n2) * 31;
            File file = this.outputFile;
            int n3 = file == null ? 0 : file.hashCode();
            int n4 = (n + n3) * 31;
            return ((Object)this.sourceOcrPages).hashCode() + n4;
        }

        public boolean equals(@Nullable Object other) {
            BitmapInput bitmapInput;
            if (this == bitmapInput) {
                return true;
            }
            if (!(bitmapInput instanceof BitmapInput)) {
                return false;
            }
            bitmapInput = bitmapInput;
            if (!Intrinsics.areEqual((Object)this.bitmap, (Object)bitmapInput.bitmap)) {
                return false;
            }
            if (this.engineMode != bitmapInput.engineMode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pdfConfig, (Object)bitmapInput.pdfConfig)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outputFile, (Object)bitmapInput.outputFile)) {
                return false;
            }
            return Intrinsics.areEqual(this.sourceOcrPages, bitmapInput.sourceOcrPages);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$Companion;", "", "<init>", "()V", "CACHE_DIR", "", "sdk-ocr_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JE\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u001aH\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$DocumentInput;", "Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$EngineInput;", "document", "Lio/scanbot/sdk/docprocessing/Document;", "engineMode", "Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;", "pdfConfig", "Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;", "outputFile", "Ljava/io/File;", "sourceOcrPages", "", "Lio/scanbot/sdk/ocr/Page;", "<init>", "(Lio/scanbot/sdk/docprocessing/Document;Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;Ljava/io/File;Ljava/util/List;)V", "getDocument", "()Lio/scanbot/sdk/docprocessing/Document;", "getEngineMode", "()Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;", "getPdfConfig", "()Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;", "getOutputFile", "()Ljava/io/File;", "getSourceOcrPages", "()Ljava/util/List;", "size", "", "getSize", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "", "sdk-ocr_release"})
    public static final class DocumentInput
    extends EngineInput {
        @NotNull
        private final Document document;
        @NotNull
        private final OcrEngineManager.EngineMode engineMode;
        @Nullable
        private final PdfConfiguration pdfConfig;
        @Nullable
        private final File outputFile;
        @NotNull
        private final List<Page> sourceOcrPages;

        /*
         * WARNING - void declaration
         */
        public DocumentInput(@NotNull Document document, @NotNull OcrEngineManager.EngineMode engineMode, @Nullable PdfConfiguration pdfConfig, @Nullable File outputFile, @NotNull List<Page> sourceOcrPages) {
            void var4_4;
            void var3_3;
            void var5_5;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"document");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"engineMode");
            Intrinsics.checkNotNullParameter((Object)var5_5, (String)"sourceOcrPages");
            super(null);
            this.document = var1_1;
            this.engineMode = var2_2;
            this.pdfConfig = var3_3;
            this.outputFile = var4_4;
            this.sourceOcrPages = var5_5;
        }

        public /* synthetic */ DocumentInput(Document document, OcrEngineManager.EngineMode engineMode, PdfConfiguration pdfConfiguration, File file, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                engineMode = OcrEngineManager.EngineMode.SCANBOT_OCR;
            }
            if ((n & 4) != 0) {
                pdfConfiguration = null;
            }
            if ((n & 8) != 0) {
                file = null;
            }
            if ((n & 0x10) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(document, engineMode, pdfConfiguration, file, list);
        }

        public static /* synthetic */ DocumentInput copy$default(DocumentInput documentInput, Document document, OcrEngineManager.EngineMode engineMode, PdfConfiguration pdfConfiguration, File file, List list, int n, Object object) {
            if ((n & 1) != 0) {
                document = documentInput.document;
            }
            if ((n & 2) != 0) {
                engineMode = documentInput.engineMode;
            }
            if ((n & 4) != 0) {
                pdfConfiguration = documentInput.pdfConfig;
            }
            if ((n & 8) != 0) {
                file = documentInput.outputFile;
            }
            if ((n & 0x10) != 0) {
                list = documentInput.sourceOcrPages;
            }
            return documentInput.copy(document, engineMode, pdfConfiguration, file, list);
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @Override
        @NotNull
        public OcrEngineManager.EngineMode getEngineMode() {
            return this.engineMode;
        }

        @Override
        @Nullable
        public PdfConfiguration getPdfConfig() {
            return this.pdfConfig;
        }

        @Override
        @Nullable
        public File getOutputFile() {
            return this.outputFile;
        }

        @Override
        @NotNull
        public List<Page> getSourceOcrPages() {
            return this.sourceOcrPages;
        }

        @Override
        public int getSize() {
            return this.document.getPageCount();
        }

        @NotNull
        public final Document component1() {
            return this.document;
        }

        @NotNull
        public final OcrEngineManager.EngineMode component2() {
            return this.engineMode;
        }

        @Nullable
        public final PdfConfiguration component3() {
            return this.pdfConfig;
        }

        @Nullable
        public final File component4() {
            return this.outputFile;
        }

        @NotNull
        public final List<Page> component5() {
            return this.sourceOcrPages;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DocumentInput copy(@NotNull Document document, @NotNull OcrEngineManager.EngineMode engineMode, @Nullable PdfConfiguration pdfConfig, @Nullable File outputFile, @NotNull List<Page> sourceOcrPages) {
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"document");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"engineMode");
            Intrinsics.checkNotNullParameter(sourceOcrPages, (String)"sourceOcrPages");
            return new DocumentInput((Document)var1_1, (OcrEngineManager.EngineMode)var2_2, (PdfConfiguration)var3_3, (File)var4_4, (List<Page>)var5_5);
        }

        @NotNull
        public String toString() {
            DocumentInput documentInput = this_;
            Object this_ = documentInput.engineMode;
            PdfConfiguration pdfConfiguration = documentInput.pdfConfig;
            File file = documentInput.outputFile;
            List<Page> list = documentInput.sourceOcrPages;
            return "DocumentInput(document=" + this_.document + ", engineMode=" + (OcrEngineManager.EngineMode)((Object)this_) + ", pdfConfig=" + pdfConfiguration + ", outputFile=" + file + ", sourceOcrPages=" + list + ")";
        }

        public int hashCode() {
            DocumentInput documentInput = this;
            int n = documentInput.document.hashCode() * 31;
            n = (((Object)((Object)documentInput.engineMode)).hashCode() + n) * 31;
            PdfConfiguration pdfConfiguration = documentInput.pdfConfig;
            int n2 = pdfConfiguration == null ? 0 : pdfConfiguration.hashCode();
            n = (n + n2) * 31;
            File file = this.outputFile;
            int n3 = file == null ? 0 : file.hashCode();
            int n4 = (n + n3) * 31;
            return ((Object)this.sourceOcrPages).hashCode() + n4;
        }

        public boolean equals(@Nullable Object other) {
            DocumentInput documentInput;
            if (this == documentInput) {
                return true;
            }
            if (!(documentInput instanceof DocumentInput)) {
                return false;
            }
            documentInput = documentInput;
            if (!Intrinsics.areEqual((Object)this.document, (Object)documentInput.document)) {
                return false;
            }
            if (this.engineMode != documentInput.engineMode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pdfConfig, (Object)documentInput.pdfConfig)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outputFile, (Object)documentInput.outputFile)) {
                return false;
            }
            return Intrinsics.areEqual(this.sourceOcrPages, documentInput.sourceOcrPages);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u0082\u0001\u0005\u0019\u001a\u001b\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$EngineInput;", "", "<init>", "()V", "size", "", "getSize", "()I", "engineMode", "Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;", "getEngineMode", "()Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;", "pdfConfig", "Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;", "getPdfConfig", "()Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;", "outputFile", "Ljava/io/File;", "getOutputFile", "()Ljava/io/File;", "sourceOcrPages", "", "Lio/scanbot/sdk/ocr/Page;", "getSourceOcrPages", "()Ljava/util/List;", "Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$BitmapInput;", "Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$DocumentInput;", "Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$ImageRefsInput;", "Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$PagesInput;", "Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$UrisInput;", "sdk-ocr_release"})
    public static abstract class EngineInput {
        private EngineInput() {
        }

        public /* synthetic */ EngineInput(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public abstract int getSize();

        @NotNull
        public abstract OcrEngineManager.EngineMode getEngineMode();

        @Nullable
        public abstract PdfConfiguration getPdfConfig();

        @Nullable
        public abstract File getOutputFile();

        @NotNull
        public abstract List<Page> getSourceOcrPages();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u00c6\u0003JK\u0010!\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020\u0019H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$ImageRefsInput;", "Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$EngineInput;", "images", "", "Lio/scanbot/sdk/image/ImageRef;", "engineMode", "Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;", "pdfConfig", "Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;", "outputFile", "Ljava/io/File;", "sourceOcrPages", "Lio/scanbot/sdk/ocr/Page;", "<init>", "(Ljava/util/List;Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;Ljava/io/File;Ljava/util/List;)V", "getImages", "()Ljava/util/List;", "getEngineMode", "()Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;", "getPdfConfig", "()Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;", "getOutputFile", "()Ljava/io/File;", "getSourceOcrPages", "size", "", "getSize", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "", "sdk-ocr_release"})
    public static final class ImageRefsInput
    extends EngineInput {
        @NotNull
        private final List<ImageRef> images;
        @NotNull
        private final OcrEngineManager.EngineMode engineMode;
        @Nullable
        private final PdfConfiguration pdfConfig;
        @Nullable
        private final File outputFile;
        @NotNull
        private final List<Page> sourceOcrPages;

        /*
         * WARNING - void declaration
         */
        public ImageRefsInput(@NotNull List<ImageRef> images, @NotNull OcrEngineManager.EngineMode engineMode, @Nullable PdfConfiguration pdfConfig, @Nullable File outputFile, @NotNull List<Page> sourceOcrPages) {
            void var4_4;
            void var3_3;
            void var5_5;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"images");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"engineMode");
            Intrinsics.checkNotNullParameter((Object)var5_5, (String)"sourceOcrPages");
            super(null);
            this.images = var1_1;
            this.engineMode = var2_2;
            this.pdfConfig = var3_3;
            this.outputFile = var4_4;
            this.sourceOcrPages = var5_5;
        }

        public /* synthetic */ ImageRefsInput(List list, OcrEngineManager.EngineMode engineMode, PdfConfiguration pdfConfiguration, File file, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                engineMode = OcrEngineManager.EngineMode.SCANBOT_OCR;
            }
            if ((n & 4) != 0) {
                pdfConfiguration = null;
            }
            if ((n & 8) != 0) {
                file = null;
            }
            if ((n & 0x10) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(list, engineMode, pdfConfiguration, file, list2);
        }

        public static /* synthetic */ ImageRefsInput copy$default(ImageRefsInput imageRefsInput, List list, OcrEngineManager.EngineMode engineMode, PdfConfiguration pdfConfiguration, File file, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = imageRefsInput.images;
            }
            if ((n & 2) != 0) {
                engineMode = imageRefsInput.engineMode;
            }
            if ((n & 4) != 0) {
                pdfConfiguration = imageRefsInput.pdfConfig;
            }
            if ((n & 8) != 0) {
                file = imageRefsInput.outputFile;
            }
            if ((n & 0x10) != 0) {
                list2 = imageRefsInput.sourceOcrPages;
            }
            return imageRefsInput.copy(list, engineMode, pdfConfiguration, file, list2);
        }

        @NotNull
        public final List<ImageRef> getImages() {
            return this.images;
        }

        @Override
        @NotNull
        public OcrEngineManager.EngineMode getEngineMode() {
            return this.engineMode;
        }

        @Override
        @Nullable
        public PdfConfiguration getPdfConfig() {
            return this.pdfConfig;
        }

        @Override
        @Nullable
        public File getOutputFile() {
            return this.outputFile;
        }

        @Override
        @NotNull
        public List<Page> getSourceOcrPages() {
            return this.sourceOcrPages;
        }

        @Override
        public int getSize() {
            return this.images.size();
        }

        @NotNull
        public final List<ImageRef> component1() {
            return this.images;
        }

        @NotNull
        public final OcrEngineManager.EngineMode component2() {
            return this.engineMode;
        }

        @Nullable
        public final PdfConfiguration component3() {
            return this.pdfConfig;
        }

        @Nullable
        public final File component4() {
            return this.outputFile;
        }

        @NotNull
        public final List<Page> component5() {
            return this.sourceOcrPages;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ImageRefsInput copy(@NotNull List<ImageRef> images, @NotNull OcrEngineManager.EngineMode engineMode, @Nullable PdfConfiguration pdfConfig, @Nullable File outputFile, @NotNull List<Page> sourceOcrPages) {
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"images");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"engineMode");
            Intrinsics.checkNotNullParameter(sourceOcrPages, (String)"sourceOcrPages");
            return new ImageRefsInput((List<ImageRef>)var1_1, (OcrEngineManager.EngineMode)var2_2, (PdfConfiguration)var3_3, (File)var4_4, (List<Page>)var5_5);
        }

        @NotNull
        public String toString() {
            ImageRefsInput imageRefsInput = this_;
            Object this_ = imageRefsInput.engineMode;
            PdfConfiguration pdfConfiguration = imageRefsInput.pdfConfig;
            File file = imageRefsInput.outputFile;
            List<Page> list = imageRefsInput.sourceOcrPages;
            return "ImageRefsInput(images=" + this_.images + ", engineMode=" + (OcrEngineManager.EngineMode)((Object)this_) + ", pdfConfig=" + pdfConfiguration + ", outputFile=" + file + ", sourceOcrPages=" + list + ")";
        }

        public int hashCode() {
            ImageRefsInput imageRefsInput = this;
            int n = ((Object)imageRefsInput.images).hashCode() * 31;
            n = (((Object)((Object)imageRefsInput.engineMode)).hashCode() + n) * 31;
            PdfConfiguration pdfConfiguration = imageRefsInput.pdfConfig;
            int n2 = pdfConfiguration == null ? 0 : pdfConfiguration.hashCode();
            n = (n + n2) * 31;
            File file = this.outputFile;
            int n3 = file == null ? 0 : file.hashCode();
            int n4 = (n + n3) * 31;
            return ((Object)this.sourceOcrPages).hashCode() + n4;
        }

        public boolean equals(@Nullable Object other) {
            ImageRefsInput imageRefsInput;
            if (this == imageRefsInput) {
                return true;
            }
            if (!(imageRefsInput instanceof ImageRefsInput)) {
                return false;
            }
            imageRefsInput = imageRefsInput;
            if (!Intrinsics.areEqual(this.images, imageRefsInput.images)) {
                return false;
            }
            if (this.engineMode != imageRefsInput.engineMode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pdfConfig, (Object)imageRefsInput.pdfConfig)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outputFile, (Object)imageRefsInput.outputFile)) {
                return false;
            }
            return Intrinsics.areEqual(this.sourceOcrPages, imageRefsInput.sourceOcrPages);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u001d\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u0003H\u00c6\u0003JO\u0010\"\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u001aH\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$PagesInput;", "Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$EngineInput;", "pages", "", "Lio/scanbot/sdk/persistence/page/legacy/Page;", "Lio/scanbot/sdk/ocr/LegacyPage;", "engineMode", "Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;", "pdfConfig", "Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;", "outputFile", "Ljava/io/File;", "sourceOcrPages", "Lio/scanbot/sdk/ocr/Page;", "<init>", "(Ljava/util/List;Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;Ljava/io/File;Ljava/util/List;)V", "getPages", "()Ljava/util/List;", "getEngineMode", "()Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;", "getPdfConfig", "()Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;", "getOutputFile", "()Ljava/io/File;", "getSourceOcrPages", "size", "", "getSize", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "", "sdk-ocr_release"})
    public static final class PagesInput
    extends EngineInput {
        @NotNull
        private final List<io.scanbot.sdk.persistence.page.legacy.Page> pages;
        @NotNull
        private final OcrEngineManager.EngineMode engineMode;
        @Nullable
        private final PdfConfiguration pdfConfig;
        @Nullable
        private final File outputFile;
        @NotNull
        private final List<Page> sourceOcrPages;

        /*
         * WARNING - void declaration
         */
        public PagesInput(@NotNull List<io.scanbot.sdk.persistence.page.legacy.Page> pages, @NotNull OcrEngineManager.EngineMode engineMode, @Nullable PdfConfiguration pdfConfig, @Nullable File outputFile, @NotNull List<Page> sourceOcrPages) {
            void var4_4;
            void var3_3;
            void var5_5;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"engineMode");
            Intrinsics.checkNotNullParameter((Object)var5_5, (String)"sourceOcrPages");
            super(null);
            this.pages = var1_1;
            this.engineMode = var2_2;
            this.pdfConfig = var3_3;
            this.outputFile = var4_4;
            this.sourceOcrPages = var5_5;
        }

        public /* synthetic */ PagesInput(List list, OcrEngineManager.EngineMode engineMode, PdfConfiguration pdfConfiguration, File file, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                engineMode = OcrEngineManager.EngineMode.SCANBOT_OCR;
            }
            if ((n & 4) != 0) {
                pdfConfiguration = null;
            }
            if ((n & 8) != 0) {
                file = null;
            }
            if ((n & 0x10) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(list, engineMode, pdfConfiguration, file, list2);
        }

        public static /* synthetic */ PagesInput copy$default(PagesInput pagesInput, List list, OcrEngineManager.EngineMode engineMode, PdfConfiguration pdfConfiguration, File file, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = pagesInput.pages;
            }
            if ((n & 2) != 0) {
                engineMode = pagesInput.engineMode;
            }
            if ((n & 4) != 0) {
                pdfConfiguration = pagesInput.pdfConfig;
            }
            if ((n & 8) != 0) {
                file = pagesInput.outputFile;
            }
            if ((n & 0x10) != 0) {
                list2 = pagesInput.sourceOcrPages;
            }
            return pagesInput.copy(list, engineMode, pdfConfiguration, file, list2);
        }

        @NotNull
        public final List<io.scanbot.sdk.persistence.page.legacy.Page> getPages() {
            return this.pages;
        }

        @Override
        @NotNull
        public OcrEngineManager.EngineMode getEngineMode() {
            return this.engineMode;
        }

        @Override
        @Nullable
        public PdfConfiguration getPdfConfig() {
            return this.pdfConfig;
        }

        @Override
        @Nullable
        public File getOutputFile() {
            return this.outputFile;
        }

        @Override
        @NotNull
        public List<Page> getSourceOcrPages() {
            return this.sourceOcrPages;
        }

        @Override
        public int getSize() {
            return this.pages.size();
        }

        @NotNull
        public final List<io.scanbot.sdk.persistence.page.legacy.Page> component1() {
            return this.pages;
        }

        @NotNull
        public final OcrEngineManager.EngineMode component2() {
            return this.engineMode;
        }

        @Nullable
        public final PdfConfiguration component3() {
            return this.pdfConfig;
        }

        @Nullable
        public final File component4() {
            return this.outputFile;
        }

        @NotNull
        public final List<Page> component5() {
            return this.sourceOcrPages;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PagesInput copy(@NotNull List<io.scanbot.sdk.persistence.page.legacy.Page> pages, @NotNull OcrEngineManager.EngineMode engineMode, @Nullable PdfConfiguration pdfConfig, @Nullable File outputFile, @NotNull List<Page> sourceOcrPages) {
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"engineMode");
            Intrinsics.checkNotNullParameter(sourceOcrPages, (String)"sourceOcrPages");
            return new PagesInput((List<io.scanbot.sdk.persistence.page.legacy.Page>)var1_1, (OcrEngineManager.EngineMode)var2_2, (PdfConfiguration)var3_3, (File)var4_4, (List<Page>)var5_5);
        }

        @NotNull
        public String toString() {
            PagesInput pagesInput = this_;
            Object this_ = pagesInput.engineMode;
            PdfConfiguration pdfConfiguration = pagesInput.pdfConfig;
            File file = pagesInput.outputFile;
            List<Page> list = pagesInput.sourceOcrPages;
            return "PagesInput(pages=" + this_.pages + ", engineMode=" + (OcrEngineManager.EngineMode)((Object)this_) + ", pdfConfig=" + pdfConfiguration + ", outputFile=" + file + ", sourceOcrPages=" + list + ")";
        }

        public int hashCode() {
            PagesInput pagesInput = this;
            int n = ((Object)pagesInput.pages).hashCode() * 31;
            n = (((Object)((Object)pagesInput.engineMode)).hashCode() + n) * 31;
            PdfConfiguration pdfConfiguration = pagesInput.pdfConfig;
            int n2 = pdfConfiguration == null ? 0 : pdfConfiguration.hashCode();
            n = (n + n2) * 31;
            File file = this.outputFile;
            int n3 = file == null ? 0 : file.hashCode();
            int n4 = (n + n3) * 31;
            return ((Object)this.sourceOcrPages).hashCode() + n4;
        }

        public boolean equals(@Nullable Object other) {
            PagesInput pagesInput;
            if (this == pagesInput) {
                return true;
            }
            if (!(pagesInput instanceof PagesInput)) {
                return false;
            }
            pagesInput = pagesInput;
            if (!Intrinsics.areEqual(this.pages, pagesInput.pages)) {
                return false;
            }
            if (this.engineMode != pagesInput.engineMode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pdfConfig, (Object)pagesInput.pdfConfig)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outputFile, (Object)pagesInput.outputFile)) {
                return false;
            }
            return Intrinsics.areEqual(this.sourceOcrPages, pagesInput.sourceOcrPages);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BQ\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u00c6\u0003JU\u0010&\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u00c6\u0001J\u0013\u0010'\u001a\u00020\u00062\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020\u001dH\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$UrisInput;", "Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$EngineInput;", "uris", "", "Landroid/net/Uri;", "encryptedInput", "", "engineMode", "Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;", "pdfConfig", "Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;", "outputFile", "Ljava/io/File;", "sourceOcrPages", "Lio/scanbot/sdk/ocr/Page;", "<init>", "(Ljava/util/List;ZLio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;Ljava/io/File;Ljava/util/List;)V", "getUris", "()Ljava/util/List;", "getEncryptedInput", "()Z", "getEngineMode", "()Lio/scanbot/sdk/ocr/OcrEngineManager$EngineMode;", "getPdfConfig", "()Lio/scanbot/sdk/pdfgeneration/PdfConfiguration;", "getOutputFile", "()Ljava/io/File;", "getSourceOcrPages", "size", "", "getSize", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "toString", "", "sdk-ocr_release"})
    public static final class UrisInput
    extends EngineInput {
        @NotNull
        private final List<Uri> uris;
        private final boolean encryptedInput;
        @NotNull
        private final OcrEngineManager.EngineMode engineMode;
        @Nullable
        private final PdfConfiguration pdfConfig;
        @Nullable
        private final File outputFile;
        @NotNull
        private final List<Page> sourceOcrPages;

        /*
         * WARNING - void declaration
         */
        public UrisInput(@NotNull List<? extends Uri> uris, boolean encryptedInput, @NotNull OcrEngineManager.EngineMode engineMode, @Nullable PdfConfiguration pdfConfig, @Nullable File outputFile, @NotNull List<Page> sourceOcrPages) {
            void var5_5;
            void var4_4;
            void var2_2;
            void var6_6;
            void var3_3;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"uris");
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"engineMode");
            Intrinsics.checkNotNullParameter((Object)var6_6, (String)"sourceOcrPages");
            super(null);
            this.uris = var1_1;
            this.encryptedInput = var2_2;
            this.engineMode = var3_3;
            this.pdfConfig = var4_4;
            this.outputFile = var5_5;
            this.sourceOcrPages = var6_6;
        }

        public /* synthetic */ UrisInput(List list, boolean bl, OcrEngineManager.EngineMode engineMode, PdfConfiguration pdfConfiguration, File file, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                engineMode = OcrEngineManager.EngineMode.SCANBOT_OCR;
            }
            if ((n & 8) != 0) {
                pdfConfiguration = null;
            }
            if ((n & 0x10) != 0) {
                file = null;
            }
            if ((n & 0x20) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(list, bl, engineMode, pdfConfiguration, file, list2);
        }

        public static /* synthetic */ UrisInput copy$default(UrisInput urisInput, List list, boolean bl, OcrEngineManager.EngineMode engineMode, PdfConfiguration pdfConfiguration, File file, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = urisInput.uris;
            }
            if ((n & 2) != 0) {
                bl = urisInput.encryptedInput;
            }
            if ((n & 4) != 0) {
                engineMode = urisInput.engineMode;
            }
            if ((n & 8) != 0) {
                pdfConfiguration = urisInput.pdfConfig;
            }
            if ((n & 0x10) != 0) {
                file = urisInput.outputFile;
            }
            if ((n & 0x20) != 0) {
                list2 = urisInput.sourceOcrPages;
            }
            return urisInput.copy(list, bl, engineMode, pdfConfiguration, file, list2);
        }

        @NotNull
        public final List<Uri> getUris() {
            return this.uris;
        }

        public final boolean getEncryptedInput() {
            return this.encryptedInput;
        }

        @Override
        @NotNull
        public OcrEngineManager.EngineMode getEngineMode() {
            return this.engineMode;
        }

        @Override
        @Nullable
        public PdfConfiguration getPdfConfig() {
            return this.pdfConfig;
        }

        @Override
        @Nullable
        public File getOutputFile() {
            return this.outputFile;
        }

        @Override
        @NotNull
        public List<Page> getSourceOcrPages() {
            return this.sourceOcrPages;
        }

        @Override
        public int getSize() {
            return this.uris.size();
        }

        @NotNull
        public final List<Uri> component1() {
            return this.uris;
        }

        public final boolean component2() {
            return this.encryptedInput;
        }

        @NotNull
        public final OcrEngineManager.EngineMode component3() {
            return this.engineMode;
        }

        @Nullable
        public final PdfConfiguration component4() {
            return this.pdfConfig;
        }

        @Nullable
        public final File component5() {
            return this.outputFile;
        }

        @NotNull
        public final List<Page> component6() {
            return this.sourceOcrPages;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final UrisInput copy(@NotNull List<? extends Uri> uris, boolean encryptedInput, @NotNull OcrEngineManager.EngineMode engineMode, @Nullable PdfConfiguration pdfConfig, @Nullable File outputFile, @NotNull List<Page> sourceOcrPages) {
            void var6_6;
            void var5_5;
            void var4_4;
            void var2_2;
            void var3_3;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"uris");
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"engineMode");
            Intrinsics.checkNotNullParameter(sourceOcrPages, (String)"sourceOcrPages");
            return new UrisInput((List<? extends Uri>)var1_1, (boolean)var2_2, (OcrEngineManager.EngineMode)var3_3, (PdfConfiguration)var4_4, (File)var5_5, (List<Page>)var6_6);
        }

        @NotNull
        public String toString() {
            UrisInput urisInput = this;
            boolean bl = urisInput.encryptedInput;
            OcrEngineManager.EngineMode engineMode = urisInput.engineMode;
            PdfConfiguration pdfConfiguration = urisInput.pdfConfig;
            File file = urisInput.outputFile;
            List<Page> list = urisInput.sourceOcrPages;
            return "UrisInput(uris=" + this.uris + ", encryptedInput=" + bl + ", engineMode=" + engineMode + ", pdfConfig=" + pdfConfiguration + ", outputFile=" + file + ", sourceOcrPages=" + list + ")";
        }

        public int hashCode() {
            UrisInput urisInput = this;
            int n = ((Object)urisInput.uris).hashCode() * 31;
            n = (Boolean.hashCode(urisInput.encryptedInput) + n) * 31;
            n = (((Object)((Object)urisInput.engineMode)).hashCode() + n) * 31;
            PdfConfiguration pdfConfiguration = urisInput.pdfConfig;
            int n2 = pdfConfiguration == null ? 0 : pdfConfiguration.hashCode();
            n = (n + n2) * 31;
            File file = this.outputFile;
            int n3 = file == null ? 0 : file.hashCode();
            int n4 = (n + n3) * 31;
            return ((Object)this.sourceOcrPages).hashCode() + n4;
        }

        public boolean equals(@Nullable Object other) {
            UrisInput urisInput;
            if (this == urisInput) {
                return true;
            }
            if (!(urisInput instanceof UrisInput)) {
                return false;
            }
            urisInput = urisInput;
            if (!Intrinsics.areEqual(this.uris, urisInput.uris)) {
                return false;
            }
            if (this.encryptedInput != urisInput.encryptedInput) {
                return false;
            }
            if (this.engineMode != urisInput.engineMode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pdfConfig, (Object)urisInput.pdfConfig)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outputFile, (Object)urisInput.outputFile)) {
                return false;
            }
            return Intrinsics.areEqual(this.sourceOcrPages, urisInput.sourceOcrPages);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OcrEngineManager.EngineMode.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[OcrEngineManager.EngineMode.TESSERACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[OcrEngineManager.EngineMode.SCANBOT_OCR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

