/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.pdf;

import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.common.Result;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.ocr.Page;
import io.scanbot.sdk.ocr.ScanbotOcrEngineManager;
import io.scanbot.sdk.ocr.pdf.GenerationIterator;
import io.scanbot.sdk.pdfgeneration.IOcrPdfGenerator;
import io.scanbot.sdk.pdfgeneration.OcrPdfGenerator;
import io.scanbot.sdk.pdfgeneration.PdfConfiguration;
import io.scanbot.sdk.persistence.document.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.page.PageFileType;
import io.scanbot.sdk.persistence.page.legacy.PageFileStorage;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0002J\u001a\u00101\u001a\u0002002\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0015H\u0002J\u001a\u00101\u001a\u0002002\u0006\u00102\u001a\u0002052\b\u00104\u001a\u0004\u0018\u00010\u0015H\u0002J\u001a\u00106\u001a\u0002002\u0006\u00107\u001a\u0002082\b\u00104\u001a\u0004\u0018\u00010\u0015H\u0002J\u001a\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020;2\b\u00104\u001a\u0004\u0018\u00010\u0015H\u0002J\"\u0010<\u001a\u0002002\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020.2\b\u00104\u001a\u0004\u0018\u00010\u0015H\u0002J\"\u0010@\u001a\u0002002\u0006\u0010A\u001a\u00020 2\u0006\u0010?\u001a\u00020.2\b\u00104\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010I\u001a\u000200H\u0016R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001a\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00150C8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0014\u0010F\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010H\u00a8\u0006J"}, d2={"Lio/scanbot/sdk/ocr/pdf/TldrGenerationIteratorImpl;", "Lio/scanbot/sdk/ocr/pdf/GenerationIterator;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;", "pageFileStorage", "Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;", "Lio/scanbot/sdk/ocr/LegacyPageFileStorage;", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "document", "Lio/scanbot/sdk/entity/Document;", "engineInput", "Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$EngineInput;", "<init>", "(Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;Lio/scanbot/sdk/entity/Document;Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$EngineInput;)V", "getDocument", "()Lio/scanbot/sdk/entity/Document;", "corePdfGenerator", "Lio/scanbot/sdk/pdfgeneration/OcrPdfGenerator;", "ocrPages", "", "Lio/scanbot/sdk/ocr/Page;", "currentPosition", "", "detectedTextBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getDetectedTextBuilder", "()Ljava/lang/StringBuilder;", "setDetectedTextBuilder", "(Ljava/lang/StringBuilder;)V", "documentFile", "Ljava/io/File;", "getDocumentFile", "()Ljava/io/File;", "fileOutputStream", "Ljava/io/OutputStream;", "getFileOutputStream", "()Ljava/io/OutputStream;", "setFileOutputStream", "(Ljava/io/OutputStream;)V", "detectedText", "", "getDetectedText", "()Ljava/lang/String;", "generateNextPage", "", "resetDataHolders", "", "generateFromPage", "page", "Lio/scanbot/sdk/persistence/page/legacy/Page;", "sourceOcrPage", "Lio/scanbot/sdk/docprocessing/Page;", "generateFromBitmap", "bitmap", "Landroid/graphics/Bitmap;", "generateFromImageRef", "image", "Lio/scanbot/sdk/image/ImageRef;", "generateFromFileURI", "fileURI", "Landroid/net/Uri;", "inputEncrypted", "generateFromImageFile", "imageFile", "detectedOcrPages", "", "getDetectedOcrPages", "()Ljava/util/List;", "lastProcessedPosition", "getLastProcessedPosition", "()I", "recycle", "sdk-ocr_release"})
@SourceDebugExtension(value={"SMAP\nTldrGenerationIteratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TldrGenerationIteratorImpl.kt\nio/scanbot/sdk/ocr/pdf/TldrGenerationIteratorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
public final class TldrGenerationIteratorImpl
implements GenerationIterator {
    @NotNull
    private final PageFileStorage pageFileStorage;
    @NotNull
    private final FileIOProcessor fileIOProcessor;
    @NotNull
    private final Document document;
    @NotNull
    private final ScanbotOcrEngineManager.EngineInput engineInput;
    @Nullable
    private final OcrPdfGenerator corePdfGenerator;
    @NotNull
    private List<Page> ocrPages;
    private int currentPosition;
    @NotNull
    private StringBuilder detectedTextBuilder;
    @NotNull
    private final File documentFile;
    @Nullable
    private OutputStream fileOutputStream;

    /*
     * WARNING - void declaration
     */
    public TldrGenerationIteratorImpl(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor, @NotNull Document document, @NotNull ScanbotOcrEngineManager.EngineInput engineInput) {
        void var5_5;
        void var4_4;
        void var3_3;
        File file;
        String string;
        TldrGenerationIteratorImpl tldrGenerationIteratorImpl = this;
        Intrinsics.checkNotNullParameter((Object)string, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)file, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"engineInput");
        this.pageFileStorage = file;
        this.fileIOProcessor = var3_3;
        this.document = var4_4;
        tldrGenerationIteratorImpl.engineInput = var5_5;
        tldrGenerationIteratorImpl.ocrPages = new ArrayList<Page>();
        tldrGenerationIteratorImpl.detectedTextBuilder = new StringBuilder();
        string.getDocumentDir(var4_4.id).mkdirs();
        file = engineInput.getOutputFile();
        if (file == null) {
            void v1 = string;
            void v2 = var4_4;
            string = v2.id;
            file = v1.getDocumentFile(string, v2.name);
        }
        TldrGenerationIteratorImpl tldrGenerationIteratorImpl2 = this;
        tldrGenerationIteratorImpl2.documentFile = file;
        tldrGenerationIteratorImpl2.corePdfGenerator = (OcrPdfGenerator)OcrPdfGenerator.Companion.createOcrPdfGenerator().getOrNull();
    }

    private final void resetDataHolders() {
        ArrayList arrayList;
        StringBuilder stringBuilder;
        TldrGenerationIteratorImpl tldrGenerationIteratorImpl = this_;
        Object this_ = stringBuilder;
        stringBuilder = new StringBuilder();
        tldrGenerationIteratorImpl.detectedTextBuilder = this_;
        this_ = arrayList;
        arrayList = new ArrayList();
        tldrGenerationIteratorImpl.ocrPages = this_;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateFromPage(io.scanbot.sdk.persistence.page.legacy.Page page, Page sourceOcrPage) {
        void var2_2;
        void var1_1;
        File file;
        File file2;
        File file3 = file2;
        File file4 = file;
        file = new File(this.pageFileStorage.getImageURI(var1_1.getPageId(), PageFileType.ORIGINAL).getPath());
        if (!new File(this.pageFileStorage.getImageURI(var1_1.getPageId(), PageFileType.DOCUMENT).getPath()).exists()) {
            file3 = file4;
        }
        this.generateFromImageFile(file3, this.fileIOProcessor.getUseEncryption(), (Page)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateFromPage(io.scanbot.sdk.docprocessing.Page page, Page sourceOcrPage) {
        void var2_2;
        void var1_1;
        File file;
        File file2;
        File file3 = file2;
        File file4 = file;
        file = new File(var1_1.getOriginalFileUri().getPath());
        if (!new File(var1_1.getDocumentFileUri().getPath()).exists()) {
            file3 = file4;
        }
        this.generateFromImageFile(file3, this.fileIOProcessor.getUseEncryption(), (Page)var2_2);
    }

    private final void generateFromBitmap(Bitmap bitmap, Page sourceOcrPage) {
        Result result;
        Throwable throwable;
        Object object;
        StringBuilder stringBuilder;
        block9: {
            block8: {
                OcrPdfGenerator ocrPdfGenerator;
                object = ImageRef.CREATOR.fromBitmap$default((ImageRef.CREATOR)ImageRef.CREATOR, (Bitmap)stringBuilder, null, (int)2, null);
                throwable = null;
                try {
                    ocrPdfGenerator = this.corePdfGenerator;
                    if (ocrPdfGenerator == null) break block8;
                }
                catch (Throwable throwable2) {}
                result = IOcrPdfGenerator.DefaultImpls.addPage$default((IOcrPdfGenerator)ocrPdfGenerator, (ImageRef)object, result, null, (int)4, null);
                if (result == null) break block8;
                try {
                    result = (Page)result.getOrNull();
                }
                finally {
                    break block9;
                }
            }
            result = null;
        }
        AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
        stringBuilder.recycle();
        stringBuilder = this.detectedTextBuilder;
        object = result != null ? result.getText() : null;
        stringBuilder.append((String)object);
        if (result != null) {
            this.ocrPages.add((Page)result);
            return;
        }
    }

    private final void generateFromImageRef(ImageRef image, Page sourceOcrPage) {
        StringBuilder stringBuilder;
        Object object;
        Object object2 = this.corePdfGenerator;
        object = object2 != null && (object = IOcrPdfGenerator.DefaultImpls.addPage$default((IOcrPdfGenerator)object2, (ImageRef)object, (Page)stringBuilder, null, (int)4, null)) != null ? (Page)object.getOrNull() : null;
        stringBuilder = this.detectedTextBuilder;
        object2 = object != null ? object.getText() : null;
        stringBuilder.append((String)object2);
        if (object != null) {
            this.ocrPages.add((Page)object);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateFromFileURI(Uri fileURI, boolean inputEncrypted, Page sourceOcrPage) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.generateFromImageFile(new File(var1_1.getPath()), (boolean)var2_2, (Page)var3_3);
    }

    private final void generateFromImageFile(File imageFile, boolean inputEncrypted, Page sourceOcrPage) {
        if (imageFile.exists()) {
            Result result;
            String string;
            Object object;
            block10: {
                block9: {
                    OcrPdfGenerator ocrPdfGenerator;
                    String string2 = ((File)object).getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                    object = ImageRef.CREATOR.fromPath$default((ImageRef.CREATOR)ImageRef.CREATOR, (String)string2, null, (int)2, null);
                    string = null;
                    try {
                        ocrPdfGenerator = this.corePdfGenerator;
                        if (ocrPdfGenerator == null) break block9;
                    }
                    catch (Throwable throwable) {}
                    result = IOcrPdfGenerator.DefaultImpls.addPage$default((IOcrPdfGenerator)ocrPdfGenerator, (ImageRef)object, result, null, (int)4, null);
                    if (result == null) break block9;
                    try {
                        result = (Page)result.getOrNull();
                    }
                    finally {
                        break block10;
                    }
                }
                result = null;
            }
            AutoCloseableKt.closeFinally((AutoCloseable)object, string);
            object = this.detectedTextBuilder;
            string = result != null ? result.getText() : null;
            ((StringBuilder)object).append(string);
            if (result != null) {
                this.ocrPages.add((Page)result);
                return;
            }
        }
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    @NotNull
    public final StringBuilder getDetectedTextBuilder() {
        return this.detectedTextBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDetectedTextBuilder(@NotNull StringBuilder stringBuilder) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
        this.detectedTextBuilder = var1_1;
    }

    @NotNull
    public final File getDocumentFile() {
        return this.documentFile;
    }

    @Nullable
    public final OutputStream getFileOutputStream() {
        return this.fileOutputStream;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFileOutputStream(@Nullable OutputStream outputStream) {
        void var1_1;
        this.fileOutputStream = var1_1;
    }

    @Override
    @NotNull
    public String getDetectedText() {
        String string = this.detectedTextBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public boolean generateNextPage() {
        block15: {
            block11: {
                Object object;
                block14: {
                    block13: {
                        OcrPdfGenerator ocrPdfGenerator;
                        block12: {
                            block10: {
                                this.resetDataHolders();
                                if (this.currentPosition == 0) {
                                    object = this.fileIOProcessor.openFileOutputStream(this.documentFile);
                                    this.fileOutputStream = object;
                                    if (object != null && (ocrPdfGenerator = this.corePdfGenerator) != null) {
                                        PdfConfiguration pdfConfiguration = this.engineInput.getPdfConfig();
                                        if (pdfConfiguration == null) {
                                            pdfConfiguration = PdfConfiguration.Companion.default();
                                        }
                                        ocrPdfGenerator.beginRender((OutputStream)object, pdfConfiguration);
                                    }
                                }
                                if (this.currentPosition >= this.engineInput.getSize()) {
                                    return false;
                                }
                                object = this.engineInput;
                                if (!(object instanceof ScanbotOcrEngineManager.PagesInput)) break block10;
                                object = (Page)CollectionsKt.getOrNull(((ScanbotOcrEngineManager.PagesInput)this.engineInput).getSourceOcrPages(), (int)this.currentPosition);
                                this.generateFromPage(((ScanbotOcrEngineManager.PagesInput)object).getPages().get(this.currentPosition), (Page)object);
                                break block11;
                            }
                            if (!(object instanceof ScanbotOcrEngineManager.BitmapInput)) break block12;
                            Bitmap bitmap = ((ScanbotOcrEngineManager.BitmapInput)object).getBitmap();
                            object = (Page)CollectionsKt.getOrNull(((ScanbotOcrEngineManager.BitmapInput)this.engineInput).getSourceOcrPages(), (int)this.currentPosition);
                            this.generateFromBitmap(bitmap, (Page)object);
                            break block11;
                        }
                        if (!(object instanceof ScanbotOcrEngineManager.UrisInput)) break block13;
                        boolean bl = ((ScanbotOcrEngineManager.UrisInput)this.engineInput).getEncryptedInput();
                        ocrPdfGenerator = (Page)CollectionsKt.getOrNull(((ScanbotOcrEngineManager.UrisInput)this.engineInput).getSourceOcrPages(), (int)this.currentPosition);
                        this.generateFromFileURI(((ScanbotOcrEngineManager.UrisInput)object).getUris().get(this.currentPosition), bl, (Page)ocrPdfGenerator);
                        break block11;
                    }
                    if (!(object instanceof ScanbotOcrEngineManager.DocumentInput)) break block14;
                    io.scanbot.sdk.docprocessing.Page page = (io.scanbot.sdk.docprocessing.Page)((ScanbotOcrEngineManager.DocumentInput)object).getDocument().getPages().get(this.currentPosition);
                    object = (Page)CollectionsKt.getOrNull(((ScanbotOcrEngineManager.DocumentInput)this.engineInput).getSourceOcrPages(), (int)this.currentPosition);
                    this.generateFromPage(page, (Page)object);
                    break block11;
                }
                if (!(object instanceof ScanbotOcrEngineManager.ImageRefsInput)) break block15;
                object = (Page)CollectionsKt.getOrNull(((ScanbotOcrEngineManager.ImageRefsInput)this.engineInput).getSourceOcrPages(), (int)this.currentPosition);
                this.generateFromImageRef(((ScanbotOcrEngineManager.ImageRefsInput)object).getImages().get(this.currentPosition), (Page)object);
            }
            if (this.currentPosition == this.engineInput.getSize() - 1) {
                Object object = this.corePdfGenerator;
                if (object != null) {
                    object.endRender();
                }
                if ((object = this.fileOutputStream) != null) {
                    ((OutputStream)object).close();
                }
            }
            ++this.currentPosition;
            return true;
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    @NotNull
    public List<Page> getDetectedOcrPages() {
        return this.ocrPages;
    }

    @Override
    public int getLastProcessedPosition() {
        return this.currentPosition - 1;
    }

    @Override
    public void recycle() {
    }
}

