/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.pdf;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.net.Uri;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.leptonica.android.ReadFile;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessBaseAPI;
import com.googlecode.tesseract.android.TessPdfRenderer;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.ComposerCache;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.exceptions.imageprocessing.BitmapAccessException;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.ocr.Block;
import io.scanbot.sdk.ocr.Line;
import io.scanbot.sdk.ocr.OcrElement;
import io.scanbot.sdk.ocr.Page;
import io.scanbot.sdk.ocr.ScanbotOcrEngineManager;
import io.scanbot.sdk.ocr.Word;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.pdf.BitmapBinarizer;
import io.scanbot.sdk.ocr.pdf.GenerationIterator;
import io.scanbot.sdk.ocr.utils.OcrUtils;
import io.scanbot.sdk.persistence.document.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.persistence.page.PageFileType;
import io.scanbot.sdk.persistence.page.legacy.PageFileStorage;
import io.scanbot.sdk.util.FileUtilsKt;
import io.scanbot.sdk.util.PolygonHelper;
import io.scanbot.tools.utils.kotlin.FilesKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\b\u0000\u0018\u0000 _2\u00020\u0001:\u0001_B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0016\u00101\u001a\u00020\u001a2\f\u00102\u001a\b\u0012\u0004\u0012\u00020.03H\u0002J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002072\u0006\u00109\u001a\u00020:H\u0002J\u0010\u00108\u001a\u0002072\u0006\u00109\u001a\u00020;H\u0002J\u0018\u0010<\u001a\u0002072\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u000205H\u0002J \u0010@\u001a\u0002072\u0006\u0010A\u001a\u00020*2\u0006\u0010?\u001a\u0002052\u0006\u0010B\u001a\u00020.H\u0002J\"\u0010C\u001a\u0002072\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010?\u001a\u0002052\u0006\u0010B\u001a\u00020.H\u0002J \u0010F\u001a\u0002072\u0006\u0010G\u001a\u00020H2\u0006\u0010?\u001a\u0002052\u0006\u0010B\u001a\u00020.H\u0002J\b\u0010I\u001a\u000207H\u0002J8\u0010J\u001a\b\u0012\u0004\u0012\u0002HK03\"\b\b\u0000\u0010K*\u00020L2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010M\u001a\u00020!2\u000e\u0010N\u001a\n\u0012\u0006\b\u0001\u0012\u0002HK0OH\u0002JA\u0010P\u001a\u0002HK\"\b\b\u0000\u0010K*\u00020L2\u0006\u0010Q\u001a\u00020R2\u0006\u0010M\u001a\u00020!2\b\u0010S\u001a\u0004\u0018\u00010T2\u000e\u0010N\u001a\n\u0012\u0006\b\u0001\u0012\u0002HK0OH\u0002\u00a2\u0006\u0002\u0010UJ\u0018\u0010V\u001a\u00020*2\u0006\u0010B\u001a\u00020.2\u0006\u0010A\u001a\u00020*H\u0002J\u0018\u0010V\u001a\u00020*2\u0006\u0010B\u001a\u00020.2\u0006\u0010G\u001a\u00020WH\u0002J\b\u0010^\u001a\u000207H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u00060#j\u0002`$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001a\u0010X\u001a\b\u0012\u0004\u0012\u00020\u001f038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010ZR\u0014\u0010[\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]\u00a8\u0006`"}, d2={"Lio/scanbot/sdk/ocr/pdf/TesseractGenerationIteratorImpl;", "Lio/scanbot/sdk/ocr/pdf/GenerationIterator;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;", "pageFileStorage", "Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "composerCache", "Lio/scanbot/sdk/docprocessing/compose/ComposerCache;", "bitmapBinarizer", "Lio/scanbot/sdk/ocr/pdf/BitmapBinarizer;", "document", "Lio/scanbot/sdk/entity/Document;", "engineInput", "Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$EngineInput;", "languages", "", "Lio/scanbot/sdk/entity/Language;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "<init>", "(Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/docprocessing/compose/ComposerCache;Lio/scanbot/sdk/ocr/pdf/BitmapBinarizer;Lio/scanbot/sdk/entity/Document;Lio/scanbot/sdk/ocr/ScanbotOcrEngineManager$EngineInput;Ljava/util/Collection;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "tessBaseAPI", "Lcom/googlecode/tesseract/android/TessBaseAPI;", "tessPdfRenderer", "Lcom/googlecode/tesseract/android/TessPdfRenderer;", "ocrPages", "", "Lio/scanbot/sdk/ocr/Page;", "currentPosition", "", "detectedTextBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getDetectedTextBuilder", "()Ljava/lang/StringBuilder;", "setDetectedTextBuilder", "(Ljava/lang/StringBuilder;)V", "documentFile", "Ljava/io/File;", "getDocumentFile", "()Ljava/io/File;", "detectedText", "", "getDetectedText", "()Ljava/lang/String;", "initTessApi", "languageCodes", "", "generateNextPage", "", "resetDataHolders", "", "generateFromPage", "page", "Lio/scanbot/sdk/persistence/page/legacy/Page;", "Lio/scanbot/sdk/docprocessing/Page;", "generateFromFileURI", "fileURI", "Landroid/net/Uri;", "useFileIOProcessor", "generateFromImageFile", "imageFile", "tempFileName", "generateFromBitmap", "bitmap", "Landroid/graphics/Bitmap;", "generateFromImageRef", "image", "Lio/scanbot/sdk/image/ImageRef;", "prepareOcrPages", "getOcrElements", "T", "Lio/scanbot/sdk/ocr/OcrElement;", "pageIteratorLevel", "ocrElementType", "Lkotlin/reflect/KClass;", "extractBlock", "resultIterator", "Lcom/googlecode/tesseract/android/ResultIterator;", "thresholdedImage", "Lcom/googlecode/leptonica/android/Pix;", "(Lcom/googlecode/tesseract/android/ResultIterator;ILcom/googlecode/leptonica/android/Pix;Lkotlin/reflect/KClass;)Lio/scanbot/sdk/ocr/OcrElement;", "writePDFTempImageFile", "", "detectedOcrPages", "getDetectedOcrPages", "()Ljava/util/List;", "lastProcessedPosition", "getLastProcessedPosition", "()I", "recycle", "Companion", "sdk-ocr_release"})
public final class TesseractGenerationIteratorImpl
implements GenerationIterator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    public static final String PDF_TEMP_IMAGE_FILE_SUFFIX = "_pdf_image";
    @NotNull
    private final PageFileStorage pageFileStorage;
    @NotNull
    private final FileIOProcessor fileIOProcessor;
    @NotNull
    private final BlobManager blobManager;
    @NotNull
    private final ComposerCache composerCache;
    @NotNull
    private final BitmapBinarizer bitmapBinarizer;
    @NotNull
    private final ScanbotOcrEngineManager.EngineInput engineInput;
    @NotNull
    private final OcrSettings ocrSettings;
    @NotNull
    private final TessBaseAPI tessBaseAPI;
    @NotNull
    private final TessPdfRenderer tessPdfRenderer;
    @NotNull
    private List<Page> ocrPages;
    private int currentPosition;
    @NotNull
    private StringBuilder detectedTextBuilder;
    @NotNull
    private final File documentFile;

    /*
     * WARNING - void declaration
     */
    public TesseractGenerationIteratorImpl(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor, @NotNull BlobManager blobManager, @NotNull ComposerCache composerCache, @NotNull BitmapBinarizer bitmapBinarizer, @NotNull Document document, @NotNull ScanbotOcrEngineManager.EngineInput engineInput, @NotNull Collection<? extends Language> languages, @NotNull OcrSettings ocrSettings) {
        void var10_10;
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        TessPdfRenderer tessPdfRenderer;
        File file;
        String string;
        TesseractGenerationIteratorImpl tesseractGenerationIteratorImpl = this;
        Intrinsics.checkNotNullParameter((Object)string, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)file, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)tessPdfRenderer, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"composerCache");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"bitmapBinarizer");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var8_8, (String)"engineInput");
        Intrinsics.checkNotNullParameter((Object)var9_9, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)var10_10, (String)"ocrSettings");
        this.pageFileStorage = file;
        this.fileIOProcessor = tessPdfRenderer;
        this.blobManager = var4_4;
        this.composerCache = var5_5;
        this.bitmapBinarizer = var6_6;
        this.engineInput = var8_8;
        tesseractGenerationIteratorImpl.ocrSettings = var10_10;
        tesseractGenerationIteratorImpl.ocrPages = new ArrayList<Page>();
        tesseractGenerationIteratorImpl.detectedTextBuilder = new StringBuilder();
        string.getDocumentDir(var7_7.id).mkdirs();
        file = engineInput.getOutputFile();
        if (file == null) {
            void v1 = string;
            void v2 = var7_7;
            string = v2.id;
            file = v1.getDocumentFile(string, v2.name);
        }
        this.documentFile = file;
        string = this.initTessApi(Language.Companion.languageCodes((Collection)var9_9));
        this.tessBaseAPI = string;
        if (tessPdfRenderer.getUseEncryption()) {
            TessPdfRenderer tessPdfRenderer2;
            file = tessPdfRenderer2;
            tessPdfRenderer2 = new TessPdfRenderer((TessBaseAPI)string);
        } else {
            TessPdfRenderer tessPdfRenderer3;
            tessPdfRenderer = tessPdfRenderer3;
            tessPdfRenderer3 = new TessPdfRenderer((TessBaseAPI)string, FileUtilsKt.pathWithoutExtension((File)file));
            file = tessPdfRenderer;
        }
        this.tessPdfRenderer = file;
    }

    /*
     * WARNING - void declaration
     */
    private final TessBaseAPI initTessApi(List<String> languageCodes) {
        void var1_1;
        TessBaseAPI tessBaseAPI;
        TessBaseAPI tessBaseAPI2 = tessBaseAPI;
        tessBaseAPI2();
        String string = ((TesseractGenerationIteratorImpl)((Object)string)).blobManager.getOcrBlobsDirectory().toString();
        tessBaseAPI.init(string, CollectionsKt.joinToString$default((Iterable)var1_1, (CharSequence)"+", null, null, (int)0, null, null, (int)62, null));
        tessBaseAPI.setPageSegMode(1);
        return tessBaseAPI;
    }

    private final void resetDataHolders() {
        ArrayList arrayList;
        StringBuilder stringBuilder;
        TesseractGenerationIteratorImpl tesseractGenerationIteratorImpl = this_;
        Object this_ = stringBuilder;
        stringBuilder = new StringBuilder();
        tesseractGenerationIteratorImpl.detectedTextBuilder = this_;
        this_ = arrayList;
        arrayList = new ArrayList();
        tesseractGenerationIteratorImpl.ocrPages = this_;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateFromPage(io.scanbot.sdk.persistence.page.legacy.Page page) {
        void var1_1;
        File file;
        File file2;
        File file3 = file2;
        File file4 = file;
        file = new File(((TesseractGenerationIteratorImpl)((Object)string)).pageFileStorage.getImageURI(var1_1.getPageId(), PageFileType.ORIGINAL).getPath());
        if (!new File(((TesseractGenerationIteratorImpl)((Object)string)).pageFileStorage.getImageURI(var1_1.getPageId(), PageFileType.DOCUMENT).getPath()).exists()) {
            file3 = file4;
        }
        TesseractGenerationIteratorImpl tesseractGenerationIteratorImpl = string;
        String string = var1_1.getPageId();
        tesseractGenerationIteratorImpl.generateFromImageFile(file3, true, string);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateFromPage(io.scanbot.sdk.docprocessing.Page page) {
        void var1_1;
        File file;
        File file2;
        File file3 = file2;
        File file4 = file;
        file = new File(var1_1.getOriginalFileUri().getPath());
        if (!new File(var1_1.getDocumentFileUri().getPath()).exists()) {
            file3 = file4;
        }
        TesseractGenerationIteratorImpl tesseractGenerationIteratorImpl = string;
        String string = var1_1.getUuid();
        tesseractGenerationIteratorImpl.generateFromImageFile(file3, true, string);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateFromFileURI(Uri fileURI, boolean useFileIOProcessor) {
        void var2_2;
        void var1_1;
        TesseractGenerationIteratorImpl tesseractGenerationIteratorImpl = this_;
        File file = new File(var1_1.getPath());
        String this_ = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"toString(...)");
        tesseractGenerationIteratorImpl.generateFromImageFile(file, (boolean)var2_2, this_);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void generateFromImageFile(File imageFile, boolean useFileIOProcessor, String tempFileName) {
        Pix pix;
        Bitmap bitmap;
        Object object;
        void var2_2;
        if (!imageFile.exists()) {
            return;
        }
        if (var2_2 != false) {
            bitmap = ImageFileIOProcessor.DefaultImpls.readImage$default((ImageFileIOProcessor)this.fileIOProcessor, (File)object, null, (int)2, null);
            if (bitmap == null) {
                throw new BitmapAccessException("Cannot decode an image for PDF page.");
            }
        } else {
            bitmap = BitmapFactory.decodeFile((String)((File)object).getPath());
        }
        if (this.ocrSettings.getBinarizeImage()) {
            Bitmap bitmap2 = bitmap;
            Intrinsics.checkNotNull((Object)bitmap2);
            Bitmap bitmap3 = (Bitmap)this.bitmapBinarizer.binarizeBitmap(bitmap2, false).getOrNull();
            pix = ReadFile.readBitmap((Bitmap)bitmap3);
            Intrinsics.checkNotNullExpressionValue((Object)pix, (String)"readBitmap(...)");
            if (bitmap3 != null) {
                bitmap3.recycle();
            }
            if (var2_2 != false && this.fileIOProcessor.getUseEncryption()) {
                object = ReadFile.readBitmap((Bitmap)bitmap);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readBitmap(...)");
                this.tessBaseAPI.addPageToDocument(pix, (Pix)object, this.tessPdfRenderer);
            } else {
                void var3_4;
                TesseractGenerationIteratorImpl tesseractGenerationIteratorImpl = this;
                String string = ((File)(object = tesseractGenerationIteratorImpl.writePDFTempImageFile((String)var3_4, (File)object))).getPath();
                if (!tesseractGenerationIteratorImpl.tessBaseAPI.addPageToDocument(pix, string, this.tessPdfRenderer)) throw new Error("Failed to generation document.");
                ((File)object).delete();
            }
            bitmap.recycle();
        } else {
            Bitmap bitmap4 = bitmap;
            pix = ReadFile.readBitmap((Bitmap)bitmap4);
            Intrinsics.checkNotNullExpressionValue((Object)pix, (String)"readBitmap(...)");
            bitmap4.recycle();
            if (var2_2 != false && this.fileIOProcessor.getUseEncryption()) {
                this.tessBaseAPI.addPageToDocument(pix, "", this.tessPdfRenderer);
            } else {
                object = ((File)object).getPath();
                this.tessBaseAPI.addPageToDocument(pix, (String)object, this.tessPdfRenderer);
            }
        }
        this.prepareOcrPages();
        pix.recycle();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void generateFromBitmap(Bitmap bitmap, boolean useFileIOProcessor, String tempFileName) {
        Pix pix;
        if (bitmap == null) {
            return;
        }
        if (this.ocrSettings.getBinarizeImage()) {
            void var2_2;
            Bitmap bitmap2 = (Bitmap)this.bitmapBinarizer.binarizeBitmap((Bitmap)var1_1, false).getOrNull();
            pix = ReadFile.readBitmap((Bitmap)bitmap2);
            Intrinsics.checkNotNullExpressionValue((Object)pix, (String)"readBitmap(...)");
            if (var2_2 != false && this.fileIOProcessor.getUseEncryption()) {
                Pix pix2 = ReadFile.readBitmap((Bitmap)bitmap2);
                var3_4 = pix2;
                Intrinsics.checkNotNullExpressionValue((Object)pix2, (String)"readBitmap(...)");
                this.tessBaseAPI.addPageToDocument(pix, (Pix)var3_4, this.tessPdfRenderer);
            } else {
                TesseractGenerationIteratorImpl tesseractGenerationIteratorImpl = this;
                void v2 = var3_4;
                var3_4 = pix.getData();
                Intrinsics.checkNotNullExpressionValue((Object)var3_4, (String)"getData(...)");
                var3_4 = tesseractGenerationIteratorImpl.writePDFTempImageFile((String)v2, (byte[])var3_4);
                String string = ((File)var3_4).getPath();
                if (!tesseractGenerationIteratorImpl.tessBaseAPI.addPageToDocument(pix, string, this.tessPdfRenderer)) throw new Error("Failed to generation document.");
                ((File)var3_4).delete();
            }
            if (bitmap2 != null) {
                bitmap2.recycle();
            }
            var1_1.recycle();
        } else {
            void v3 = var1_1;
            pix = ReadFile.readBitmap((Bitmap)v3);
            Intrinsics.checkNotNullExpressionValue((Object)pix, (String)"readBitmap(...)");
            v3.recycle();
            this.tessBaseAPI.addPageToDocument(pix, "", this.tessPdfRenderer);
        }
        this.prepareOcrPages();
        pix.recycle();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateFromImageRef(ImageRef image, boolean useFileIOProcessor, String tempFileName) {
        Pix pix;
        block5: {
            Object object;
            block7: {
                block3: {
                    block2: {
                        block6: {
                            String string;
                            block4: {
                                void var2_2;
                                if (!this.ocrSettings.getBinarizeImage()) break block2;
                                Object object2 = (ImageRef)this.bitmapBinarizer.binarizeImageRef((ImageRef)object).getOrNull();
                                if (object2 == null) break block3;
                                byte[] byArray = (byte[])ImageRef.encodeImage$default((ImageRef)object2, null, (int)1, null).getOrNull();
                                object2 = byArray;
                                if (byArray == null) break block3;
                                pix = ReadFile.readMem((byte[])object2);
                                Intrinsics.checkNotNullExpressionValue((Object)pix, (String)"readMem(...)");
                                if (var2_2 == false || !this.fileIOProcessor.getUseEncryption()) break block4;
                                if ((object = (byte[])ImageRef.encodeImage$default((ImageRef)object, null, (int)1, null).getOrNull()) == null) break block3;
                                object = ReadFile.readMem((byte[])object);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readMem(...)");
                                this.tessBaseAPI.addPageToDocument(pix, (Pix)object, this.tessPdfRenderer);
                                break block5;
                            }
                            TesseractGenerationIteratorImpl tesseractGenerationIteratorImpl = this;
                            object = pix.getData();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
                            object = tesseractGenerationIteratorImpl.writePDFTempImageFile(string, (byte[])object);
                            string = ((File)object).getPath();
                            if (!tesseractGenerationIteratorImpl.tessBaseAPI.addPageToDocument(pix, string, this.tessPdfRenderer)) break block6;
                            ((File)object).delete();
                            break block5;
                        }
                        throw new Error("Failed to generation document.");
                    }
                    if ((object = (byte[])ImageRef.encodeImage$default((ImageRef)object, null, (int)1, null).getOrNull()) != null) break block7;
                }
                return;
            }
            pix = ReadFile.readMem((byte[])object);
            Intrinsics.checkNotNullExpressionValue((Object)pix, (String)"readMem(...)");
            this.tessBaseAPI.addPageToDocument(pix, "", this.tessPdfRenderer);
        }
        this.prepareOcrPages();
        pix.recycle();
    }

    private final void prepareOcrPages() {
        TesseractGenerationIteratorImpl tesseractGenerationIteratorImpl = this_;
        tesseractGenerationIteratorImpl.detectedTextBuilder.append(((TesseractGenerationIteratorImpl)((Object)this_)).tessBaseAPI.getUTF8Text());
        List<Block> list = tesseractGenerationIteratorImpl.getOcrElements(tesseractGenerationIteratorImpl.tessBaseAPI, 0, Reflection.getOrCreateKotlinClass(Block.class));
        List<Line> list2 = tesseractGenerationIteratorImpl.getOcrElements(tesseractGenerationIteratorImpl.tessBaseAPI, 2, Reflection.getOrCreateKotlinClass(Line.class));
        List<Word> list3 = tesseractGenerationIteratorImpl.getOcrElements(tesseractGenerationIteratorImpl.tessBaseAPI, 3, Reflection.getOrCreateKotlinClass(Word.class));
        List<Page> list4 = tesseractGenerationIteratorImpl.ocrPages;
        String string = ((TesseractGenerationIteratorImpl)((Object)this_)).tessBaseAPI.getUTF8Text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUTF8Text(...)");
        ArrayList this_ = PolygonHelper.Companion.getFullPolygon();
        list = OcrUtils.INSTANCE.buildTreeStructure(list, list2, list3);
        list4.add(new Page(string, 0.0, (List)this_, list));
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends OcrElement> List<T> getOcrElements(TessBaseAPI tessBaseAPI, int pageIteratorLevel, KClass<? extends T> ocrElementType) {
        void var3_3;
        void var2_2;
        Pix pix;
        ArrayList<T> arrayList;
        ArrayList<T> arrayList2 = arrayList;
        void v1 = pix;
        arrayList2();
        pix = v1.getThresholdedImage();
        ResultIterator resultIterator = v1.getResultIterator();
        resultIterator.begin();
        Intrinsics.checkNotNull((Object)resultIterator);
        arrayList.add(this.extractBlock(resultIterator, (int)var2_2, pix, (KClass<? extends T>)var3_3));
        while (resultIterator.next((int)var2_2)) {
            arrayList2.add(this.extractBlock(resultIterator, (int)var2_2, pix, (KClass<? extends T>)var3_3));
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends OcrElement> T extractBlock(ResultIterator resultIterator, int pageIteratorLevel, Pix thresholdedImage, KClass<? extends T> ocrElementType) {
        void var4_12;
        void var1_4;
        void var2_5;
        Object object = resultIterator.getUTF8Text((int)var2_5);
        if (object == null) {
            object = "";
        }
        int[] nArray = var1_4.getBoundingBox((int)var2_5);
        new Rect();
        new RectF();
        List list = CollectionsKt.emptyList();
        if (nArray.length == 4) {
            void var3_9;
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            int n4 = nArray[3];
            new Rect(n, n2, n3, n4);
            if (var3_9 != null) {
                PointF pointF;
                PointF pointF2;
                PointF pointF3;
                PointF pointF4;
                RectF rectF;
                list = rectF;
                float f = (float)nArray[0] / (float)var3_9.getWidth();
                float f2 = (float)nArray[1] / (float)var3_9.getHeight();
                float f3 = (float)nArray[2] / (float)var3_9.getWidth();
                float f4 = (float)nArray[3] / (float)var3_9.getHeight();
                rectF = new RectF(f, f2, f3, f4);
                PointF pointF5 = pointF4;
                List list2 = list;
                f = ((RectF)list2).left;
                pointF4 = new PointF(f, ((RectF)list2).top);
                PointF pointF6 = pointF3;
                List list3 = list;
                f2 = ((RectF)list3).right;
                pointF3 = new PointF(f2, ((RectF)list3).top);
                PointF pointF7 = pointF2;
                List list4 = list;
                f3 = ((RectF)list4).right;
                pointF2 = new PointF(f3, ((RectF)list4).bottom);
                PointF pointF8 = pointF;
                List list5 = list;
                float f5 = ((RectF)list5).left;
                pointF = new PointF(f5, ((RectF)list5).bottom);
                list = CollectionsKt.listOf((Object[])new PointF[]{pointF5, pointF6, pointF7, pointF8});
            }
        }
        if (Intrinsics.areEqual((Object)var4_12, (Object)Reflection.getOrCreateKotlinClass(Block.class))) {
            double d = var1_4.confidence((int)var2_5);
            List list6 = CollectionsKt.emptyList();
            return (T)new Block((String)object, d, list, list6);
        }
        if (Intrinsics.areEqual((Object)var4_12, (Object)Reflection.getOrCreateKotlinClass(Line.class))) {
            double d = var1_4.confidence((int)var2_5);
            List list7 = CollectionsKt.emptyList();
            return (T)new Line((String)object, d, list, list7);
        }
        if (Intrinsics.areEqual((Object)var4_12, (Object)Reflection.getOrCreateKotlinClass(Word.class))) {
            double d = var1_4.confidence((int)var2_5);
            List list8 = CollectionsKt.emptyList();
            return (T)new Word((String)object, d, list, list8);
        }
        throw new IllegalArgumentException("Unsupported block type: " + (KClass)var4_12);
    }

    /*
     * WARNING - void declaration
     */
    private final File writePDFTempImageFile(String tempFileName, File imageFile) {
        void var2_2;
        File file = FilesKt.ensureDir((File)((TesseractGenerationIteratorImpl)((Object)file)).composerCache.getCacheDir());
        File file2 = File.createTempFile("scanbot_", tempFileName + PDF_TEMP_IMAGE_FILE_SUFFIX, file);
        Intrinsics.checkNotNull((Object)file2);
        kotlin.io.FilesKt.copyTo$default((File)var2_2, (File)file2, (boolean)true, (int)0, (int)4, null);
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    private final File writePDFTempImageFile(String tempFileName, byte[] image) {
        void var2_2;
        File file = FilesKt.ensureDir((File)((TesseractGenerationIteratorImpl)((Object)file)).composerCache.getCacheDir());
        File file2 = File.createTempFile("scanbot_", tempFileName + PDF_TEMP_IMAGE_FILE_SUFFIX, file);
        Intrinsics.checkNotNull((Object)file2);
        kotlin.io.FilesKt.writeBytes((File)file2, (byte[])var2_2);
        return file2;
    }

    @NotNull
    public final StringBuilder getDetectedTextBuilder() {
        return this.detectedTextBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDetectedTextBuilder(@NotNull StringBuilder stringBuilder) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
        this.detectedTextBuilder = var1_1;
    }

    @NotNull
    public final File getDocumentFile() {
        return this.documentFile;
    }

    @Override
    @NotNull
    public String getDetectedText() {
        String string = this.detectedTextBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public boolean generateNextPage() {
        block12: {
            block8: {
                Object object;
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                this.resetDataHolders();
                                if (this.currentPosition == 0) {
                                    this.tessBaseAPI.beginDocument(this.tessPdfRenderer);
                                }
                                if (this.currentPosition >= this.engineInput.getSize()) {
                                    return false;
                                }
                                object = this.engineInput;
                                if (!(object instanceof ScanbotOcrEngineManager.PagesInput)) break block7;
                                this.generateFromPage(((ScanbotOcrEngineManager.PagesInput)object).getPages().get(this.currentPosition));
                                break block8;
                            }
                            if (!(object instanceof ScanbotOcrEngineManager.BitmapInput)) break block9;
                            Bitmap bitmap = ((ScanbotOcrEngineManager.BitmapInput)object).getBitmap();
                            object = UUID.randomUUID().toString();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toString(...)");
                            this.generateFromBitmap(bitmap, true, (String)object);
                            break block8;
                        }
                        if (!(object instanceof ScanbotOcrEngineManager.UrisInput)) break block10;
                        boolean bl = ((ScanbotOcrEngineManager.UrisInput)this.engineInput).getEncryptedInput();
                        this.generateFromFileURI(((ScanbotOcrEngineManager.UrisInput)object).getUris().get(this.currentPosition), bl);
                        break block8;
                    }
                    if (!(object instanceof ScanbotOcrEngineManager.DocumentInput)) break block11;
                    this.generateFromPage((io.scanbot.sdk.docprocessing.Page)((ScanbotOcrEngineManager.DocumentInput)object).getDocument().getPages().get(this.currentPosition));
                    break block8;
                }
                if (!(object instanceof ScanbotOcrEngineManager.ImageRefsInput)) break block12;
                object = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toString(...)");
                this.generateFromImageRef(((ScanbotOcrEngineManager.ImageRefsInput)object).getImages().get(this.currentPosition), true, (String)object);
            }
            if (this.currentPosition == this.engineInput.getSize() - 1) {
                this.tessBaseAPI.endDocument(this.tessPdfRenderer);
                if (this.fileIOProcessor.getUseEncryption()) {
                    byte[] byArray = this.tessBaseAPI.getOutputBuffer(this.tessPdfRenderer);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getOutputBuffer(...)");
                    this.fileIOProcessor.write(byArray, this.documentFile);
                }
            }
            ++this.currentPosition;
            return true;
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    @NotNull
    public List<Page> getDetectedOcrPages() {
        return this.ocrPages;
    }

    @Override
    public int getLastProcessedPosition() {
        return this.currentPosition - 1;
    }

    @Override
    public void recycle() {
        TesseractGenerationIteratorImpl tesseractGenerationIteratorImpl = this;
        tesseractGenerationIteratorImpl.composerCache.clear();
        tesseractGenerationIteratorImpl.tessBaseAPI.end();
        tesseractGenerationIteratorImpl.tessPdfRenderer.recycle();
    }

    @Metadata(mv={2, 1, 0}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/ocr/pdf/TesseractGenerationIteratorImpl$Companion;", "", "", "PDF_TEMP_IMAGE_FILE_SUFFIX", "Ljava/lang/String;", "sdk-ocr_release"}, xi=48)
    public static final class Companion {
        public Companion(DefaultConstructorMarker $constructor_marker) {
        }
    }
}

