/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import io.scanbot.sdk.AspectRatio;
import io.scanbot.sdk.core.contourdetector.ContourDetector;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.core.contourdetector.DetectionStatus;
import io.scanbot.sdk.persistence.CameraImageFormat;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageImageSource;
import io.scanbot.sdk.persistence.PageStorage;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.process.CropOperation;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.util.PolygonHelper;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001:\u0001CB/\u0012\u0006\u0010)\u001a\u00020'\u0012\u0006\u0010.\u001a\u00020#\u0012\u0006\u00102\u001a\u00020/\u0012\u0006\u00106\u001a\u000203\u0012\u0006\u0010:\u001a\u000207\u00a2\u0006\u0004\bA\u0010BJ\u001f\u0010\t\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\t\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u001f\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u0018\u0010\u001bJ\u0017\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\"\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b \u0010!J'\u0010%\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010)\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010(R\u001a\u0010.\u001a\u00020#8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u0014\u00102\u001a\u00020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0014\u00106\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u0010:\u001a\u0002078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u001a\u0010@\u001a\u00020;8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?\u00a8\u0006D"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor;", "", "", "srcImage", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "configuration", "Lio/scanbot/sdk/persistence/Page;", "createPage$sdk_persistence_release", "([BLio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;)Lio/scanbot/sdk/persistence/Page;", "createPage", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;)Lio/scanbot/sdk/persistence/Page;", "Ljava/io/File;", "file", "bitmap", "", "saveByteArrayTo$sdk_persistence_release", "(Ljava/io/File;[B)V", "saveByteArrayTo", "saveBitmapTo$sdk_persistence_release", "(Ljava/io/File;Landroid/graphics/Bitmap;)V", "saveBitmapTo", "previewFile", "image", "createPreviewTo$sdk_persistence_release", "(Ljava/io/File;[B)Landroid/graphics/Bitmap;", "createPreviewTo", "(Ljava/io/File;Landroid/graphics/Bitmap;)Landroid/graphics/Bitmap;", "page", "erasePageData$sdk_persistence_release", "(Lio/scanbot/sdk/persistence/Page;)V", "erasePageData", "eraseAllPagesData$sdk_persistence_release", "()V", "eraseAllPagesData", "Lio/scanbot/sdk/persistence/PageStorage;", "destinationPageStorage", "a", "(Landroid/graphics/Bitmap;Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;Lio/scanbot/sdk/persistence/PageStorage;)Lio/scanbot/sdk/persistence/Page;", "Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "contourDetector", "b", "Lio/scanbot/sdk/persistence/PageStorage;", "getPageStorage", "()Lio/scanbot/sdk/persistence/PageStorage;", "pageStorage", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "c", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "pageStorageSettings", "Lio/scanbot/sdk/process/ImageProcessor;", "d", "Lio/scanbot/sdk/process/ImageProcessor;", "imageProcessor", "Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;", "e", "Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;", "imageFileIOProcessor", "Lio/scanbot/sdk/util/log/Logger;", "f", "Lio/scanbot/sdk/util/log/Logger;", "getLogger", "()Lio/scanbot/sdk/util/log/Logger;", "logger", "<init>", "(Lio/scanbot/sdk/core/contourdetector/ContourDetector;Lio/scanbot/sdk/persistence/PageStorage;Lio/scanbot/sdk/persistence/PageStorageSettings;Lio/scanbot/sdk/process/ImageProcessor;Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;)V", "Configuration", "sdk-persistence_release"})
public class PageStorageProcessor {
    @NotNull
    public final ContourDetector a;
    @NotNull
    public final PageStorage b;
    @NotNull
    public final PageStorageSettings c;
    @NotNull
    public final ImageProcessor d;
    @NotNull
    public final ImageFileIOProcessor e;
    @NotNull
    public final Logger f;

    /*
     * WARNING - void declaration
     */
    public PageStorageProcessor(@NotNull ContourDetector contourDetector, @NotNull PageStorage pageStorage, @NotNull PageStorageSettings pageStorageSettings, @NotNull ImageProcessor imageProcessor, @NotNull ImageFileIOProcessor imageFileIOProcessor) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        PageStorageProcessor pageStorageProcessor = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"contourDetector");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageStorage");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pageStorageSettings");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"imageProcessor");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"imageFileIOProcessor");
        this.a = var1_1;
        this.b = var2_2;
        this.c = var3_3;
        this.d = var4_4;
        pageStorageProcessor.e = var5_5;
        pageStorageProcessor.f = LoggerProvider.getLogger();
    }

    @NotNull
    public final PageStorage getPageStorage() {
        return this.b;
    }

    @NotNull
    public final Logger getLogger() {
        return this.f;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page createPage$sdk_persistence_release(@NotNull byte[] srcImage, @NotNull Configuration configuration) {
        BitmapFactory.Options options;
        void var2_2;
        PageStorage pageStorage;
        PageStorageProcessor pageStorageProcessor = this_;
        void v1 = pageStorage;
        Intrinsics.checkNotNullParameter((Object)pageStorage, (String)"srcImage");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"configuration");
        PageStorageProcessor this_ = options;
        options = new BitmapFactory.Options();
        this_ = BitmapFactory.decodeByteArray((byte[])v1, (int)0, (int)((void)v1).length, (BitmapFactory.Options)this_);
        Intrinsics.checkNotNull((Object)this_);
        pageStorage = pageStorageProcessor.b;
        Page page = pageStorageProcessor.a((Bitmap)this_, (Configuration)var2_2, pageStorage);
        this_.recycle();
        return page;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page createPage$sdk_persistence_release(@NotNull Bitmap srcImage, @NotNull Configuration configuration) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"srcImage");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"configuration");
        return this.a((Bitmap)var1_1, (Configuration)var2_2, this.b);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveByteArrayTo$sdk_persistence_release(@NotNull File file, @NotNull byte[] bitmap) {
        BitmapFactory.Options options;
        void var1_1;
        void var2_2;
        PageStorageProcessor pageStorageProcessor = this_;
        void v1 = var2_2;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"file");
        Intrinsics.checkNotNullParameter((Object)v1, (String)"bitmap");
        PageStorageProcessor this_ = options;
        options = new BitmapFactory.Options();
        this_ = BitmapFactory.decodeByteArray((byte[])v1, (int)0, (int)((void)v1).length, (BitmapFactory.Options)this_);
        Intrinsics.checkNotNull((Object)this_);
        pageStorageProcessor.saveBitmapTo$sdk_persistence_release((File)var1_1, (Bitmap)this_);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void saveBitmapTo$sdk_persistence_release(@NotNull File file, @NotNull Bitmap bitmap) {
        IOException iOException2;
        block5: {
            Bitmap.CompressFormat compressFormat;
            void var2_3;
            void var1_1;
            block4: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)var1_1, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)var2_3, (String)"bitmap");
                    try {
                        int n = WhenMappings.$EnumSwitchMapping$0[this.c.getImageFormat().ordinal()];
                        if (n == 1) break block3;
                        if (n != 2) throw new NoWhenBranchMatchedException();
                        compressFormat = Bitmap.CompressFormat.PNG;
                        break block4;
                    }
                    catch (IOException iOException2) {
                        break block5;
                    }
                }
                compressFormat = Bitmap.CompressFormat.JPEG;
            }
            Bitmap.CompressFormat compressFormat2 = compressFormat;
            this.e.writeImage((Bitmap)var2_3, compressFormat2, this.c.getImageQuality(), (File)var1_1);
            return;
        }
        this.f.logException((Throwable)iOException2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap createPreviewTo$sdk_persistence_release(@NotNull File previewFile, @NotNull byte[] image) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"previewFile");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
        double d = (double)this.c.getPreviewTargetMax() / (double)Math.max(bitmap.getHeight(), bitmap.getWidth());
        Bitmap bitmap2 = bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)bitmap.getWidth() * d)), (int)((int)((double)bitmap.getHeight() * d)), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createScaledBitmap(...)");
        this.saveBitmapTo$sdk_persistence_release((File)var1_1, bitmap2);
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap createPreviewTo$sdk_persistence_release(@NotNull File previewFile, @NotNull Bitmap bitmap) {
        Bitmap bitmap2;
        void var1_1;
        Bitmap bitmap3 = bitmap;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"previewFile");
        Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"bitmap");
        double d = (double)this.c.getPreviewTargetMax() / (double)Math.max(bitmap2.getHeight(), bitmap2.getWidth());
        Bitmap bitmap4 = bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap3, (int)((int)((double)bitmap3.getWidth() * d)), (int)((int)((double)bitmap2.getHeight() * d)), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"createScaledBitmap(...)");
        this.saveBitmapTo$sdk_persistence_release((File)var1_1, bitmap4);
        return bitmap2;
    }

    public final void erasePageData$sdk_persistence_release(@NotNull Page page) {
        block6: {
            File file;
            Intrinsics.checkNotNullParameter((Object)file, (String)"page");
            file = this.b.getPageDir(((Page)((Object)file)).getPageId());
            if (!file.exists()) break block6;
            if (!file.isDirectory()) break block6;
            if (FilesKt.deleteRecursively((File)file)) break block6;
            try {
                throw new IOException("Couldn't delete");
            }
            catch (IOException iOException) {
                this.f.logException((Throwable)iOException);
            }
        }
    }

    public final void eraseAllPagesData$sdk_persistence_release() {
        block6: {
            File file = this.b.getPagesDirectory();
            if (!file.exists()) break block6;
            if (!file.isDirectory()) break block6;
            if (FilesKt.deleteRecursively((File)file)) break block6;
            try {
                throw new IOException("Couldn't delete");
            }
            catch (IOException iOException) {
                this.f.logException((Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Page a(Bitmap srcImage, Configuration configuration, PageStorage destinationPageStorage) {
        Page.Size size;
        void var3_3;
        Matrix matrix;
        Bitmap bitmap;
        PageImageSource pageImageSource;
        void var2_2;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        File file = destinationPageStorage.getPageDir(string);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Couldn't create dir");
        }
        int n = var2_2.getImageOrientation();
        if (n <= 0 && var2_2.getImageScale() == 1.0f) {
            bitmap = pageImageSource;
        } else {
            Matrix matrix2;
            matrix = matrix2;
            matrix2 = new Matrix();
            if (n > 0) {
                void v1 = pageImageSource;
                float f = (float)v1.getWidth() / 2.0f;
                matrix.setRotate((float)n, f, (float)v1.getHeight() / 2.0f);
            }
            if (var2_2.getImageScale() != 1.0f) {
                void v2 = var2_2;
                float f = v2.getImageScale();
                matrix.postScale(f, v2.getImageScale());
            }
            void v3 = pageImageSource;
            int n2 = v3.getWidth();
            int n3 = v3.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)v3, (int)0, (int)0, (int)n2, (int)n3, (Matrix)matrix, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
        }
        ((PageStorageProcessor)((Object)size2)).saveBitmapTo$sdk_persistence_release(var3_3.getOriginalImage(string), bitmap);
        if (var2_2.getCreatePreview()) {
            void v4 = bitmap;
            double d = (double)((PageStorageProcessor)((Object)size2)).c.getPreviewTargetMax() / (double)Math.max(bitmap.getHeight(), bitmap.getWidth());
            matrix = Bitmap.createScaledBitmap((Bitmap)v4, (int)((int)((double)v4.getWidth() * d)), (int)((int)((double)bitmap.getHeight() * d)), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)matrix, (String)"createScaledBitmap(...)");
            ((PageStorageProcessor)((Object)size2)).saveBitmapTo$sdk_persistence_release(var3_3.getOriginalImagePreview(string), (Bitmap)matrix);
            if (matrix != pageImageSource) {
                matrix.recycle();
            }
        }
        matrix = PolygonHelper.Companion;
        List list = matrix.getFullPolygon();
        Object object = DetectionStatus.ERROR_NOTHING_DETECTED;
        if (var2_2.getCreateDocument()) {
            CropOperation cropOperation;
            DetectionStatus detectionStatus;
            PageStorageProcessor pageStorageProcessor = size2;
            pageStorageProcessor.a.setRequiredAspectRatios(var2_2.getRequiredAspectRatios());
            pageStorageProcessor.a.setRectOfInterest(var2_2.getRectOfInterest());
            DetectionResult detectionResult = pageStorageProcessor.a.detect(bitmap);
            if (detectionResult == null || (detectionStatus = detectionResult.getStatus()) == null) {
                detectionStatus = object;
            }
            if (detectionStatus != object && detectionStatus != DetectionStatus.ERROR_TOO_DARK && detectionStatus != DetectionStatus.ERROR_TOO_NOISY && (detectionResult == null || (list = detectionResult.getPolygonF()) == null)) {
                list = CollectionsKt.emptyList();
            }
            object = cropOperation;
            cropOperation = new CropOperation(list);
            if (list.isEmpty() ^ true && !Intrinsics.areEqual((Object)list, (Object)matrix.getFullPolygon())) {
                matrix = ((PageStorageProcessor)((Object)size2)).d.processBitmap(bitmap, CollectionsKt.listOf((Object)object));
                if (matrix == null) {
                    return new Page(null, null, null, 7, null);
                }
            } else {
                matrix = bitmap;
            }
            object = var2_2.getDocumentImageSizeLimit().getHeight() != Integer.MAX_VALUE && var2_2.getDocumentImageSizeLimit().getWidth() != Integer.MAX_VALUE ? BitmapUtils.scaleIfNeeded((Bitmap)matrix, (int)var2_2.getDocumentImageSizeLimit().getWidth(), (int)var2_2.getDocumentImageSizeLimit().getHeight()) : matrix;
            ((PageStorageProcessor)((Object)size2)).saveBitmapTo$sdk_persistence_release(var3_3.getDocumentImage(string), (Bitmap)object);
            ((PageStorageProcessor)((Object)size2)).saveBitmapTo$sdk_persistence_release(var3_3.getUnfilteredDocumentImage(string), (Bitmap)object);
            if (var2_2.getCreatePreview()) {
                DetectionStatus detectionStatus2 = object;
                double d = (double)((PageStorageProcessor)((Object)size2)).c.getPreviewTargetMax() / (double)Math.max(object.getHeight(), object.getWidth());
                detectionResult = Bitmap.createScaledBitmap((Bitmap)detectionStatus2, (int)((int)((double)detectionStatus2.getWidth() * d)), (int)((int)((double)object.getHeight() * d)), (boolean)false);
                Intrinsics.checkNotNullExpressionValue((Object)detectionResult, (String)"createScaledBitmap(...)");
                ((PageStorageProcessor)((Object)size2)).saveBitmapTo$sdk_persistence_release(var3_3.getDocumentImagePreview(string), (Bitmap)detectionResult);
                ((PageStorageProcessor)((Object)size2)).saveBitmapTo$sdk_persistence_release(var3_3.getUnfilteredDocumentImagePreview(string), (Bitmap)detectionResult);
                if (detectionResult != pageImageSource) {
                    detectionResult.recycle();
                }
            }
            if (object != pageImageSource) {
                object.recycle();
            }
            if (matrix != pageImageSource) {
                matrix.recycle();
            }
            if (bitmap != pageImageSource) {
                bitmap.recycle();
            }
            object = detectionStatus;
        }
        Page.Size size2 = size;
        size = new Page.Size(var2_2.getDocumentImageSizeLimit().getWidth(), var2_2.getDocumentImageSizeLimit().getHeight());
        pageImageSource = var2_2.getPageImageSource();
        return new Page(string, list, (DetectionStatus)object, null, size2, null, 0, pageImageSource, 104, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\"\b\u0086\b\u0018\u0000 C2\u00020\u0001:\u0002CDB]\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u001c\u001a\u00020\t\u0012\b\b\u0002\u0010\u001d\u001a\u00020\f\u0012\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\b\u0002\u0010\u001f\u001a\u00020\u0013\u0012\b\b\u0002\u0010 \u001a\u00020\u0016\u00a2\u0006\u0004\bA\u0010BJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\n\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\fH\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018Jf\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u00022\b\b\u0002\u0010\u001a\u001a\u00020\u00022\b\b\u0002\u0010\u001b\u001a\u00020\u00062\b\b\u0002\u0010\u001c\u001a\u00020\t2\b\b\u0002\u0010\u001d\u001a\u00020\f2\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u001f\u001a\u00020\u00132\b\b\u0002\u0010 \u001a\u00020\u0016H\u00c6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010$\u001a\u00020#H\u00d6\u0001\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010&\u001a\u00020\fH\u00d6\u0001\u00a2\u0006\u0004\b&\u0010\u000eJ\u001a\u0010(\u001a\u00020\u00022\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b(\u0010)R\u0017\u0010\u0019\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010\u0004R\u0017\u0010\u001a\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b-\u0010+\u001a\u0004\b.\u0010\u0004R\u0017\u0010\u001b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u0010\bR\u0017\u0010\u001c\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u0010\u000bR\u0017\u0010\u001d\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u0010\u000eR\u001d\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010\u0012R\u0017\u0010\u001f\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010\u0015R\u0017\u0010 \u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b@\u0010\u0018\u00a8\u0006E"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "", "", "component1", "()Z", "component2", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "component3", "()Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "", "component4", "()F", "", "component5", "()I", "", "Lio/scanbot/sdk/AspectRatio;", "component6", "()Ljava/util/List;", "Landroid/graphics/RectF;", "component7", "()Landroid/graphics/RectF;", "Lio/scanbot/sdk/persistence/PageImageSource;", "component8", "()Lio/scanbot/sdk/persistence/PageImageSource;", "createPreview", "createDocument", "documentImageSizeLimit", "imageScale", "imageOrientation", "requiredAspectRatios", "rectOfInterest", "pageImageSource", "copy", "(ZZLio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;FILjava/util/List;Landroid/graphics/RectF;Lio/scanbot/sdk/persistence/PageImageSource;)Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "", "toString", "()Ljava/lang/String;", "hashCode", "other", "equals", "(Ljava/lang/Object;)Z", "a", "Z", "getCreatePreview", "b", "getCreateDocument", "c", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "getDocumentImageSizeLimit", "d", "F", "getImageScale", "e", "I", "getImageOrientation", "f", "Ljava/util/List;", "getRequiredAspectRatios", "g", "Landroid/graphics/RectF;", "getRectOfInterest", "h", "Lio/scanbot/sdk/persistence/PageImageSource;", "getPageImageSource", "<init>", "(ZZLio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;FILjava/util/List;Landroid/graphics/RectF;Lio/scanbot/sdk/persistence/PageImageSource;)V", "Companion", "Size", "sdk-persistence_release"})
    public static final class Configuration {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public final boolean a;
        public final boolean b;
        @NotNull
        public final Size c;
        public final float d;
        public final int e;
        @NotNull
        public final List<AspectRatio> f;
        @NotNull
        public final RectF g;
        @NotNull
        public final PageImageSource h;

        /*
         * WARNING - void declaration
         */
        public Configuration(boolean createPreview, boolean createDocument, @NotNull Size documentImageSizeLimit, float imageScale, int imageOrientation, @NotNull List<? extends AspectRatio> requiredAspectRatios, @NotNull RectF rectOfInterest, @NotNull PageImageSource pageImageSource) {
            void var5_5;
            void var4_4;
            void var2_2;
            void var1_1;
            void var8_8;
            void var7_7;
            void var6_6;
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"documentImageSizeLimit");
            Intrinsics.checkNotNullParameter((Object)var6_6, (String)"requiredAspectRatios");
            Intrinsics.checkNotNullParameter((Object)var7_7, (String)"rectOfInterest");
            Intrinsics.checkNotNullParameter((Object)var8_8, (String)"pageImageSource");
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
            this.d = var4_4;
            this.e = var5_5;
            this.f = var6_6;
            this.g = var7_7;
            this.h = var8_8;
        }

        public /* synthetic */ Configuration(boolean bl, boolean bl2, Size size, float f, int n, List list, RectF rectF, PageImageSource pageImageSource, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = true;
            }
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            if ((n2 & 4) != 0) {
                Size size2;
                size = size2;
                size2 = new Size(0, 0, 3, null);
            }
            if ((n2 & 8) != 0) {
                f = 1.0f;
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            if ((n2 & 0x20) != 0) {
                ArrayList arrayList;
                list = arrayList;
                arrayList = new ArrayList();
            }
            if ((n2 & 0x40) != 0) {
                RectF rectF2;
                rectF = rectF2;
                rectF2 = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
            }
            if ((n2 & 0x80) != 0) {
                pageImageSource = PageImageSource.UNDEFINED;
            }
            this(bl, bl2, size, f, n, list, rectF, pageImageSource);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, boolean bl, boolean bl2, Size size, float f, int n, List list, RectF rectF, PageImageSource pageImageSource, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = configuration.a;
            }
            if ((n2 & 2) != 0) {
                bl2 = configuration.b;
            }
            if ((n2 & 4) != 0) {
                size = configuration.c;
            }
            if ((n2 & 8) != 0) {
                f = configuration.d;
            }
            if ((n2 & 0x10) != 0) {
                n = configuration.e;
            }
            if ((n2 & 0x20) != 0) {
                list = configuration.f;
            }
            if ((n2 & 0x40) != 0) {
                rectF = configuration.g;
            }
            if ((n2 & 0x80) != 0) {
                pageImageSource = configuration.h;
            }
            return configuration.copy(bl, bl2, size, f, n, list, rectF, pageImageSource);
        }

        public Configuration() {
            this(false, false, null, 0.0f, 0, null, null, null, 255, null);
        }

        @JvmStatic
        @NotNull
        public static final Configuration DEFAULT() {
            return Companion.DEFAULT();
        }

        public final boolean getCreatePreview() {
            return this.a;
        }

        public final boolean getCreateDocument() {
            return this.b;
        }

        @NotNull
        public final Size getDocumentImageSizeLimit() {
            return this.c;
        }

        public final float getImageScale() {
            return this.d;
        }

        public final int getImageOrientation() {
            return this.e;
        }

        @NotNull
        public final List<AspectRatio> getRequiredAspectRatios() {
            return this.f;
        }

        @NotNull
        public final RectF getRectOfInterest() {
            return this.g;
        }

        @NotNull
        public final PageImageSource getPageImageSource() {
            return this.h;
        }

        public final boolean component1() {
            return this.a;
        }

        public final boolean component2() {
            return this.b;
        }

        @NotNull
        public final Size component3() {
            return this.c;
        }

        public final float component4() {
            return this.d;
        }

        public final int component5() {
            return this.e;
        }

        @NotNull
        public final List<AspectRatio> component6() {
            return this.f;
        }

        @NotNull
        public final RectF component7() {
            return this.g;
        }

        @NotNull
        public final PageImageSource component8() {
            return this.h;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Configuration copy(boolean createPreview, boolean createDocument, @NotNull Size documentImageSizeLimit, float imageScale, int imageOrientation, @NotNull List<? extends AspectRatio> requiredAspectRatios, @NotNull RectF rectOfInterest, @NotNull PageImageSource pageImageSource) {
            void var8_8;
            void var5_5;
            void var4_4;
            void var2_2;
            void var1_1;
            void var7_7;
            void var6_6;
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"documentImageSizeLimit");
            Intrinsics.checkNotNullParameter((Object)var6_6, (String)"requiredAspectRatios");
            Intrinsics.checkNotNullParameter((Object)var7_7, (String)"rectOfInterest");
            Intrinsics.checkNotNullParameter((Object)((Object)pageImageSource), (String)"pageImageSource");
            return new Configuration((boolean)var1_1, (boolean)var2_2, (Size)var3_3, (float)var4_4, (int)var5_5, (List<? extends AspectRatio>)var6_6, (RectF)var7_7, (PageImageSource)var8_8);
        }

        @NotNull
        public String toString() {
            Configuration configuration = this;
            boolean bl = configuration.b;
            Size size = configuration.c;
            float f = configuration.d;
            int n = configuration.e;
            List<AspectRatio> list = configuration.f;
            RectF rectF = configuration.g;
            PageImageSource pageImageSource = configuration.h;
            return "Configuration(createPreview=" + this.a + ", createDocument=" + bl + ", documentImageSizeLimit=" + size + ", imageScale=" + f + ", imageOrientation=" + n + ", requiredAspectRatios=" + list + ", rectOfInterest=" + rectF + ", pageImageSource=" + pageImageSource + ")";
        }

        public int hashCode() {
            Configuration configuration = this;
            int n = Boolean.hashCode(configuration.a) * 31;
            n = (Boolean.hashCode(configuration.b) + n) * 31;
            n = (configuration.c.hashCode() + n) * 31;
            n = (Float.hashCode(configuration.d) + n) * 31;
            n = (Integer.hashCode(configuration.e) + n) * 31;
            n = (((Object)configuration.f).hashCode() + n) * 31;
            n = (configuration.g.hashCode() + n) * 31;
            return ((Object)((Object)configuration.h)).hashCode() + n;
        }

        public boolean equals(@Nullable Object other) {
            Configuration configuration;
            if (this == configuration) {
                return true;
            }
            if (!(configuration instanceof Configuration)) {
                return false;
            }
            configuration = configuration;
            if (this.a != configuration.a) {
                return false;
            }
            if (this.b != configuration.b) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.c, (Object)configuration.c)) {
                return false;
            }
            if (Float.compare(this.d, configuration.d) != 0) {
                return false;
            }
            if (this.e != configuration.e) {
                return false;
            }
            if (!Intrinsics.areEqual(this.f, configuration.f)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.g, (Object)configuration.g)) {
                return false;
            }
            return this.h == configuration.h;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Companion;", "", "()V", "DEFAULT", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "sdk-persistence_release"})
        public static final class Companion {
            public Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @JvmStatic
            @NotNull
            public final Configuration DEFAULT() {
                return new Configuration(false, false, null, 0.0f, 0, null, null, null, 255, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J$\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u00020\nH\u00d6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\r\u0010\u0004J\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0004R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0014\u001a\u0004\b\u0017\u0010\u0004\u00a8\u0006\u001a"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "Ljava/io/Serializable;", "", "component1", "()I", "component2", "width", "height", "copy", "(II)Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "", "toString", "()Ljava/lang/String;", "hashCode", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "a", "I", "getWidth", "b", "getHeight", "<init>", "(II)V", "sdk-persistence_release"})
        public static final class Size
        implements Serializable {
            public final int a;
            public final int b;

            /*
             * WARNING - void declaration
             */
            public Size(int width, int height) {
                void var2_2;
                void var1_1;
                this.a = var1_1;
                this.b = var2_2;
            }

            public /* synthetic */ Size(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 1) != 0) {
                    n = Integer.MAX_VALUE;
                }
                if ((n3 & 2) != 0) {
                    n2 = Integer.MAX_VALUE;
                }
                this(n, n2);
            }

            public static /* synthetic */ Size copy$default(Size size, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = size.a;
                }
                if ((n3 & 2) != 0) {
                    n2 = size.b;
                }
                return size.copy(n, n2);
            }

            public Size() {
                this(0, 0, 3, null);
            }

            public final int getWidth() {
                return this.a;
            }

            public final int getHeight() {
                return this.b;
            }

            public final int component1() {
                return this.a;
            }

            public final int component2() {
                return this.b;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Size copy(int width, int height) {
                void var2_2;
                void var1_1;
                return new Size((int)var1_1, (int)var2_2);
            }

            @NotNull
            public String toString() {
                return "Size(width=" + this.a + ", height=" + this.b + ")";
            }

            public int hashCode() {
                Size size = this;
                int n = Integer.hashCode(size.a) * 31;
                return Integer.hashCode(size.b) + n;
            }

            public boolean equals(@Nullable Object other) {
                Size size;
                if (this == size) {
                    return true;
                }
                if (!(size instanceof Size)) {
                    return false;
                }
                size = size;
                if (this.a != size.a) {
                    return false;
                }
                return this.b == size.b;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CameraImageFormat.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[CameraImageFormat.JPG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[CameraImageFormat.PNG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

