/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.document;

import io.scanbot.sdk.persistence.document.DocumentStorage;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\bJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0012\u0010\bJ\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/scanbot/sdk/persistence/document/DocumentStorageBase;", "Lio/scanbot/sdk/persistence/document/DocumentStorage;", "<init>", "()V", "", "documentId", "Ljava/io/File;", "getDocumentDir", "(Ljava/lang/String;)Ljava/io/File;", "", "getStoredDocuments", "()Ljava/util/List;", "getDocumentJsonFile", "", "delete", "(Ljava/lang/String;)Z", "deleteAll", "()Z", "getDocumentPdfFile", "getDocumentTiffFile", "sdk-persistence_release"}, xi=48)
public abstract class DocumentStorageBase
implements DocumentStorage {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public File getDocumentDir(@NotNull String documentId) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentId");
        return FilesKt.resolve((File)this.getDocumentsDirectory(), (String)var1_1);
    }

    @Override
    @NotNull
    public List<String> getStoredDocuments() {
        Object[] objectArray = this.getDocumentsDirectory().list();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"list(...)");
        return ArraysKt.asList((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public File getDocumentJsonFile(@NotNull String documentId) {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"documentId");
        return FilesKt.resolve((File)this.getDocumentDir((String)v0), (String)"document_metadata.json");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean delete(@NotNull String documentId) {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"documentId");
        return FilesKt.deleteRecursively((File)this.getDocumentDir((String)v0));
    }

    @Override
    public boolean deleteAll() {
        return FilesKt.deleteRecursively((File)this.getDocumentsDirectory());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public File getDocumentPdfFile(@NotNull String documentId) {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"documentId");
        File file = this.getDocumentDir((String)v0);
        String string = String.format("%s.pdf", Arrays.copyOf(new Object[]{var1_1}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return FilesKt.resolve((File)file, (String)string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public File getDocumentTiffFile(@NotNull String documentId) {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"documentId");
        File file = this.getDocumentDir((String)v0);
        String string = String.format("%s.tiff", Arrays.copyOf(new Object[]{var1_1}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return FilesKt.resolve((File)file, (String)string);
    }
}

