/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.document;

import android.annotation.SuppressLint;
import android.content.Context;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.util.FileUtils;
import io.scanbot.sdk.util.FileUtilsKt;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000b\u0018\u0000 22\u00020\u0001:\u00012B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u000fJ\u001d\u0010\u0018\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u0012J%\u0010\u001d\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010%\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#H\u0007\u00a2\u0006\u0004\b%\u0010&J%\u0010*\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010\u00042\f\u0010)\u001a\b\u0012\u0004\u0012\u00020#0(\u00a2\u0006\u0004\b*\u0010+R\u0011\u0010.\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020\b0(8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00063"}, d2={"Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;", "", "Landroid/content/Context;", "context", "", "customSdkFilesPath", "<init>", "(Landroid/content/Context;Ljava/lang/String;)V", "Ljava/io/File;", "docDir", "", "ensureDocumentDir", "(Ljava/io/File;)Z", "docId", "getDocumentDir", "(Ljava/lang/String;)Ljava/io/File;", "", "ensureDocumentDirectory", "(Ljava/lang/String;)V", "name", "getDocumentFile", "(Ljava/lang/String;Ljava/lang/String;)Ljava/io/File;", "getThumbnailFile", "docName", "eraseDocument", "(Ljava/lang/String;Ljava/lang/String;)V", "eraseDocumentThumbnail", "oldName", "newName", "renameDocument", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", "getUniqueName", "(Ljava/lang/String;)Ljava/lang/String;", "", "pagePosition", "Lio/scanbot/sdk/entity/Document;", "document", "getPageImagePath", "(ILio/scanbot/sdk/entity/Document;)Ljava/lang/String;", "newPath", "", "documents", "migrateDocuments", "(Ljava/lang/String;Ljava/util/List;)V", "getDocumentsDir", "()Ljava/io/File;", "documentsDir", "getDocumentsFiles", "()Ljava/util/List;", "documentsFiles", "Companion", "sdk-persistence_release"}, xi=48)
public final class DocumentStoreStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public final Context kwl;
    public final String kwj;
    public final Logger kwp;

    /*
     * WARNING - void declaration
     */
    public DocumentStoreStrategy(@NotNull Context context, @Nullable String customSdkFilesPath) {
        void var2_2;
        void var1_1;
        DocumentStoreStrategy documentStoreStrategy = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        this.kwl = var1_1;
        documentStoreStrategy.kwj = var2_2;
        documentStoreStrategy.kwp = LoggerProvider.getLogger();
    }

    public static final boolean kwl(File file, String string) {
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        return StringsKt.endsWith$default((String)string2, (String)".jpg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)string, (String)".pdf", (boolean)false, (int)2, null);
        {
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean ensureDocumentDir(@Nullable File docDir) {
        void var1_1;
        return docDir != null && var1_1.exists() && (this = var1_1.listFiles()) != null && !(this.length == 0);
    }

    @NotNull
    public final File getDocumentsDir() {
        String string = this.kwj;
        if (string != null && string.length() > 0) {
            return FileUtils.getFilesDirOrShowError((String)string, (String)"snapping_documents");
        }
        return FileUtils.getFilesDirOrShowError((String)FileUtils.getAppFilesDirOrShowError((Context)this.kwl, (String)"scanbot-sdk").getPath(), (String)"snapping_documents");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final File getDocumentDir(@Nullable String docId) {
        void var1_1;
        return FileUtils.getFilesDirOrShowError((String)this.getDocumentsDir().getPath(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureDocumentDirectory(@Nullable String docId) {
        void var1_1;
        if (!((File)(this = ((DocumentStoreStrategy)this).getDocumentDir((String)var1_1))).exists() && !((File)this).mkdirs()) {
            throw new IOException("Unable to create document dir");
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final File getDocumentFile(@NotNull String docId, @NotNull String name) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"docId");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"name");
        return FilesKt.resolve((File)this.getDocumentDir((String)var1_1), (String)var2_2);
    }

    @NotNull
    public final List<File> getDocumentsFiles() {
        ArrayList arrayList;
        DocumentStoreStrategy documentStoreStrategy = this_;
        ArrayList this_ = arrayList;
        arrayList = new ArrayList();
        Iterator iterator = ArrayIteratorKt.iterator((Object[])documentStoreStrategy.getDocumentsDir().listFiles());
        while (iterator.hasNext()) {
            File[] fileArray = ((File)iterator.next()).listFiles(DocumentStoreStrategy::kwl);
            List<File> list = Arrays.asList(Arrays.copyOf(fileArray, fileArray.length));
            Intrinsics.checkNotNullExpressionValue(list, (String)"asList(...)");
            this_.addAll(list);
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final File getThumbnailFile(@NotNull String docId) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"docId");
        return FilesKt.resolve((File)FilesKt.resolve((File)this.getDocumentsDir(), (String)var1_1), (String)"thumbnail");
    }

    /*
     * WARNING - void declaration
     */
    public final void eraseDocument(@NotNull String docId, @NotNull String docName) {
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"docId");
        Intrinsics.checkNotNullParameter((Object)var2_3, (String)"docName");
        try {
            this.getDocumentFile((String)var1_1, (String)var2_3).delete();
        }
        catch (IOException iOException) {
            this.kwp.logException((Throwable)iOException);
            return;
        }
        FilesKt.deleteRecursively((File)this.getDocumentDir((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void eraseDocumentThumbnail(@NotNull String docId) {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"docId");
        try {
            this.getThumbnailFile((String)v0).delete();
        }
        catch (IOException iOException) {
            this.kwp.logException((Throwable)iOException);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean renameDocument(@NotNull String docId, @NotNull String oldName, @NotNull String newName) {
        void var2_2;
        void var1_1;
        void var3_3;
        DocumentStoreStrategy documentStoreStrategy = this_;
        void v1 = var3_3;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"docId");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"oldName");
        Intrinsics.checkNotNullParameter((Object)v1, (String)"newName");
        File this_ = ((DocumentStoreStrategy)((Object)this_)).getDocumentFile((String)var1_1, ((DocumentStoreStrategy)((Object)this_)).getUniqueName((String)v1));
        return documentStoreStrategy.getDocumentFile((String)var1_1, (String)var2_2).renameTo(this_);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getUniqueName(@NotNull String newName) {
        Object object;
        block14: {
            IOException iOException2;
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            while (true) {
                int n;
                block13: {
                    File file;
                    String string;
                    void var1_1;
                    File file2;
                    object = file2;
                    Object object2 = FilesKt.getExtension((File)new File((String)var1_1));
                    object2 = object2.length() == 0 ? "" : "." + (String)object2;
                    Object object3 = FilesKt.getNameWithoutExtension((File)object);
                    int n2 = StringsKt.lastIndexOf$default((CharSequence)object3, (String)"(", (int)0, (boolean)false, (int)6, null);
                    n = StringsKt.lastIndexOf$default((CharSequence)object3, (String)")", (int)0, (boolean)false, (int)6, null);
                    int n3 = 0;
                    if (n2 >= 0 && n >= 0 && n > n2) {
                        try {
                            String string2 = ((String)object3).substring(n2 + 1, n);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                            Integer n4 = Integer.valueOf(string2);
                            Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"valueOf(...)");
                            n3 = n4;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        string = StringsKt.take((String)object3, (int)(n2 - 1));
                    }
                    string = object3;
                    n = 0;
                    Iterator<File> iterator = this.getDocumentsFiles().iterator();
                    while (true) {
                        if (!iterator.hasNext()) break block13;
                        if (!Intrinsics.areEqual((Object)FilesKt.getNameWithoutExtension((File)iterator.next()), (Object)object3)) continue;
                        break;
                    }
                    object3 = file;
                    try {
                        file = new File(string + " (" + (n3 + 1) + ")" + (String)object2);
                        n = 1;
                        object = object3;
                    }
                    catch (IOException iOException2) {
                        break;
                    }
                }
                if (n != 0) {
                    continue;
                }
                break block14;
                break;
            }
            this.kwp.logException((Throwable)iOException2);
        }
        String string = ((File)object).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @SuppressLint(value={"DefaultLocale"})
    @NotNull
    public final String getPageImagePath(int pagePosition, @NotNull Document document) {
        Object[] objectArray;
        DocumentStoreStrategy documentStoreStrategy = object;
        void v1 = objectArray;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"document");
        Object object = v1.id;
        object = FileUtilsKt.pathWithoutExtension((File)documentStoreStrategy.getDocumentFile((String)object, v1.name));
        Integer n = pagePosition;
        Object[] objectArray2 = new Object[3];
        objectArray = objectArray2;
        objectArray2[0] = object;
        objectArray2[1] = n;
        objectArray2[2] = ".jpg";
        String string = String.format("%s(%d)%s", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void migrateDocuments(@Nullable String newPath, @NotNull List<Document> documents) {
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"documents");
        var3_3 = newPath == null || var1_1.length() == 0;
        var2_2 = var2_2.iterator();
        while (true) {
            block9: {
                block8: {
                    if (!var2_2.hasNext()) {
                        return;
                    }
                    v0 = (Document)var2_2.next();
                    var4_4 = v0.component1();
                    var5_6 = v0.component2();
                    if (!var3_3) {
                        var6_7 = v1;
                        try {
                            v1 = new File((String)var1_1);
                            break block8;
                        }
                        catch (IOException var4_5) {
                            break block9;
                        }
                    }
                    var6_7 = this.getDocumentDir(var4_4);
                }
                if (!FilesKt.resolve((File)var6_7, (String)var5_6).exists()) ** GOTO lbl-1000
                v2 = new File((String)var5_6);
                var7_8 = FilesKt.getExtension((File)v2);
                var7_8 = FilesKt.getNameWithoutExtension((File)v2) + " (1)." + (String)var7_8;
                this.renameDocument(var4_4, (String)var5_6, (String)var7_8);
                var5_6 = var7_8;
lbl-1000:
                // 2 sources

                {
                    v3 = this;
                    v4 = var4_4;
                    var6_7.mkdirs();
                }
                {
                    v3.getDocumentFile(v4, (String)var5_6).renameTo(FilesKt.resolve((File)var6_7, (String)var5_6));
                }
                continue;
            }
            this.kwp.logException((Throwable)var4_5);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0004R\u0014\u0010\u0007\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0004\u00a8\u0006\b"}, d2={"Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy$Companion;", "", "", "THUMBNAIL_FILE_NAME", "Ljava/lang/String;", "SNAPPING_DOCUMENTS_DIR_NAME", "IMAGE_FILE_NAME_PATTERN", "DEFAULT_DOC_INDEX_SUFFIX", "sdk-persistence_release"}, xi=48)
    public static final class Companion {
        public Companion(DefaultConstructorMarker $constructor_marker) {
        }
    }
}

