/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.document;

import io.scanbot.sdk.persistence.document.DocumentStorage;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\bJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0012\u0010\bJ\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/scanbot/sdk/persistence/document/DocumentStorageBase;", "Lio/scanbot/sdk/persistence/document/DocumentStorage;", "<init>", "()V", "", "documentId", "Ljava/io/File;", "getDocumentDir", "(Ljava/lang/String;)Ljava/io/File;", "", "getStoredDocuments", "()Ljava/util/List;", "getDocumentJsonFile", "", "delete", "(Ljava/lang/String;)Z", "deleteAll", "()Z", "getDocumentPdfFile", "getDocumentTiffFile", "Companion", "sdk-persistence_release"}, xi=48)
public abstract class DocumentStorageBase
implements DocumentStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final Object ouc = new Object();

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public File getDocumentDir(@NotNull String documentId) {
        void var1_1;
        DocumentStorageBase documentStorageBase = this_;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentId");
        Object this_ = ouc;
        synchronized (this_) {
            return FilesKt.resolve((File)documentStorageBase.getDocumentsDirectory(), (String)var1_1);
        }
    }

    @Override
    @NotNull
    public List<String> getStoredDocuments() {
        DocumentStorageBase documentStorageBase = this_;
        Object this_ = ouc;
        synchronized (this_) {
            Object[] objectArray = documentStorageBase.getDocumentsDirectory().list();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"list(...)");
            return ArraysKt.asList((Object[])objectArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public File getDocumentJsonFile(@NotNull String documentId) {
        void var1_1;
        DocumentStorageBase documentStorageBase = this_;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"documentId");
        Object this_ = ouc;
        synchronized (this_) {
            return FilesKt.resolve((File)documentStorageBase.getDocumentDir((String)v1), (String)"document_metadata.json");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean delete(@NotNull String documentId) {
        void var1_1;
        DocumentStorageBase documentStorageBase = this_;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"documentId");
        Object this_ = ouc;
        synchronized (this_) {
            return FilesKt.deleteRecursively((File)documentStorageBase.getDocumentDir((String)v1));
        }
    }

    @Override
    public boolean deleteAll() {
        DocumentStorageBase documentStorageBase = this_;
        Object this_ = ouc;
        synchronized (this_) {
            return FilesKt.deleteRecursively((File)documentStorageBase.getDocumentsDirectory());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public File getDocumentPdfFile(@NotNull String documentId) {
        void var1_1;
        DocumentStorageBase documentStorageBase = this_;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"documentId");
        Object this_ = ouc;
        synchronized (this_) {
            File file = documentStorageBase.getDocumentDir((String)v1);
            String string = "%s.pdf";
            int n = 1;
            Object[] objectArray = new Object[1];
            objectArray[0] = var1_1;
            String string2 = String.format(string, Arrays.copyOf(objectArray, n));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return FilesKt.resolve((File)file, (String)string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public File getDocumentTiffFile(@NotNull String documentId) {
        void var1_1;
        DocumentStorageBase documentStorageBase = this_;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"documentId");
        Object this_ = ouc;
        synchronized (this_) {
            File file = documentStorageBase.getDocumentDir((String)v1);
            String string = "%s.tiff";
            int n = 1;
            Object[] objectArray = new Object[1];
            objectArray[0] = var1_1;
            String string2 = String.format(string, Arrays.copyOf(objectArray, n));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return FilesKt.resolve((File)file, (String)string2);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001R\u0017\u0010\u0002\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/persistence/document/DocumentStorageBase$Companion;", "", "GLOBAL_DOCUMENT_STORAGE_LOCK", "Ljava/lang/Object;", "getGLOBAL_DOCUMENT_STORAGE_LOCK", "()Ljava/lang/Object;", "sdk-persistence_release"}, xi=48)
    public static final class Companion {
        public Companion(DefaultConstructorMarker $constructor_marker) {
        }

        @NotNull
        public final Object getGLOBAL_DOCUMENT_STORAGE_LOCK() {
            return ouc;
        }
    }
}

