/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.barcode.configuration;

import com.google.gson.Gson;
import io.scanbot.sdk.ui.configuration.json.GsonHelper;
import io.scanbot.sdk.ui.configuration.json.JsonBarcodeImageGenerationType;
import io.scanbot.sdk.ui.view.barcode.common.configuration.CommonBarcodeScannerConfiguration;
import io.scanbot.sdk.ui.view.barcode.configuration.BarcodeImageGenerationType;
import io.scanbot.sdk.ui.view.barcode.configuration.BarcodeScannerConfigurationParams;
import io.scanbot.sdk.ui.view.barcode.configuration.json.BarcodeJsonExtensionsKt;
import io.scanbot.sdk.ui.view.barcode.configuration.json.BarcodeScannerJsonConfiguration;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\f\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration;", "Lio/scanbot/sdk/ui/view/barcode/common/configuration/CommonBarcodeScannerConfiguration;", "()V", "modifyFromJsonConfiguration", "", "jsonConfig", "Lio/scanbot/sdk/ui/view/barcode/configuration/json/BarcodeScannerJsonConfiguration;", "setBarcodeImageGenerationType", "imageType", "Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeImageGenerationType;", "setDelayAfterFocusCompleteMs", "delay", "", "setDelayAfterScanMs", "milliseconds", "Companion", "rtu-ui-barcode_release"})
public final class BarcodeScannerConfiguration
extends CommonBarcodeScannerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void setDelayAfterFocusCompleteMs(long delay) {
        Long l = delay;
        this.getScanningConfiguration().put(BarcodeScannerConfigurationParams.DELAY_AFTER_FOCUS_COMPLETE_MS.getKey(), l);
    }

    public final void setDelayAfterScanMs(long milliseconds) {
        Long l = milliseconds;
        this.getScanningConfiguration().put(BarcodeScannerConfigurationParams.DELAY_AFTER_SCAN.getKey(), l);
    }

    public final void setBarcodeImageGenerationType(@NotNull BarcodeImageGenerationType imageType) {
        Intrinsics.checkNotNullParameter((Object)((Object)imageType), (String)"imageType");
        this.getScanningConfiguration().put(BarcodeScannerConfigurationParams.BARCODE_IMAGE_GENERATION_TYPE.getKey(), (Serializable)((Object)imageType));
    }

    @Override
    public void modifyFromJsonConfiguration(@NotNull BarcodeScannerJsonConfiguration jsonConfig) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)jsonConfig, (String)"jsonConfig");
            super.modifyFromJsonConfiguration(jsonConfig);
            JsonBarcodeImageGenerationType jsonBarcodeImageGenerationType = jsonConfig.getBarcodeImageGenerationType();
            if (jsonBarcodeImageGenerationType != null) {
                JsonBarcodeImageGenerationType it = jsonBarcodeImageGenerationType;
                boolean bl = false;
                this.setBarcodeImageGenerationType(BarcodeJsonExtensionsKt.toSdk(it));
            }
            Double d = jsonConfig.getDelayAfterScan();
            if (d == null) break block1;
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            this.setDelayAfterScanMs((long)(it * (double)1000));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration$Companion;", "", "()V", "fromJson", "Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration;", "input", "", "rtu-ui-barcode_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BarcodeScannerConfiguration fromJson(@NotNull String input) {
            BarcodeScannerConfiguration barcodeScannerConfiguration;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Gson gson = GsonHelper.INSTANCE.prepareGson();
            BarcodeScannerJsonConfiguration jsonConfig = (BarcodeScannerJsonConfiguration)gson.fromJson(input, BarcodeScannerJsonConfiguration.class);
            BarcodeScannerConfiguration $this$fromJson_u24lambda_u2d0 = barcodeScannerConfiguration = new BarcodeScannerConfiguration();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)jsonConfig, (String)"jsonConfig");
            $this$fromJson_u24lambda_u2d0.modifyFromJsonConfiguration(jsonConfig);
            return barcodeScannerConfiguration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

