/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.barcode.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import io.scanbot.sdk.barcode.BarcodeItem;
import io.scanbot.sdk.barcode.BarcodeScannerResult;
import io.scanbot.sdk.ui.barcode.R;
import io.scanbot.sdk.ui.view.barcode.dialog.BarcodeConfirmationDialogConfiguration;
import io.scanbot.sdk.ui.view.barcode.dialog.BarcodeConfirmationDialogInterface;
import io.scanbot.sdk.ui.view.barcode.dialog.BarcodeDialogFormat;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/ui/view/barcode/dialog/BarcodeConfirmationDialog;", "Landroidx/fragment/app/DialogFragment;", "<init>", "()V", "confirmed", "", "onCreateDialog", "Landroid/app/Dialog;", "savedInstanceState", "Landroid/os/Bundle;", "addRipple", "", "Landroid/view/View;", "onCancel", "dialog", "Landroid/content/DialogInterface;", "Companion", "rtu-ui-barcode_release"})
@SourceDebugExtension(value={"SMAP\nBarcodeConfirmationDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeConfirmationDialog.kt\nio/scanbot/sdk/ui/view/barcode/dialog/BarcodeConfirmationDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class BarcodeConfirmationDialog
extends DialogFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean confirmed;
    @NotNull
    private static final String CONFIGURATION = "CONFIGURATION";
    @NotNull
    private static final String BARCODE_RESULT = "BARCODE_RESULT";

    @NotNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.scanbot_sdk_dialog_barcode_normal, null, false);
        Bundle bundle = this.getArguments();
        BarcodeScannerResult barcodeScannerResult = bundle != null ? (BarcodeScannerResult)bundle.getParcelable(BARCODE_RESULT) : null;
        Intrinsics.checkNotNull((Object)barcodeScannerResult);
        BarcodeScannerResult scanningResult = barcodeScannerResult;
        Bundle bundle2 = this.getArguments();
        BarcodeConfirmationDialogConfiguration barcodeConfirmationDialogConfiguration = bundle2 != null ? (BarcodeConfirmationDialogConfiguration)bundle2.getParcelable(CONFIGURATION) : null;
        Intrinsics.checkNotNull((Object)barcodeConfirmationDialogConfiguration);
        BarcodeConfirmationDialogConfiguration config = barcodeConfirmationDialogConfiguration;
        String resultText = switch (WhenMappings.$EnumSwitchMapping$0[config.getDialogTextFormat().ordinal()]) {
            case 1 -> CollectionsKt.joinToString$default((Iterable)scanningResult.getBarcodes(), (CharSequence)"\n\n", null, null, (int)0, null, BarcodeConfirmationDialog::onCreateDialog$lambda$0, (int)30, null);
            case 2 -> CollectionsKt.joinToString$default((Iterable)scanningResult.getBarcodes(), (CharSequence)"\n\n", null, null, (int)0, null, BarcodeConfirmationDialog::onCreateDialog$lambda$1, (int)30, null);
            default -> throw new NoWhenBranchMatchedException();
        };
        ((TextView)view.findViewById(R.id.scanbot_sdk_view_barcode_text)).setText((CharSequence)resultText);
        Button retryButton = (Button)view.findViewById(R.id.scanbot_sdk_view_barcode_retry_button);
        retryButton.setText((CharSequence)config.getRetryButtonTitle());
        retryButton.setOnClickListener(arg_0 -> BarcodeConfirmationDialog.onCreateDialog$lambda$2(this, arg_0));
        Button confirmButton = (Button)view.findViewById(R.id.scanbot_sdk_view_barcode_confirm_button);
        confirmButton.setText((CharSequence)config.getConfirmButtonTitle());
        confirmButton.setOnClickListener(arg_0 -> BarcodeConfirmationDialog.onCreateDialog$lambda$3(this, scanningResult, arg_0));
        Integer n = config.getButtonsAccentColor();
        if (n != null) {
            int buttonsAccentColor = ((Number)n).intValue();
            boolean bl = false;
            if (config.isConfirmButtonFilled()) {
                confirmButton.setBackgroundTintList(ColorStateList.valueOf((int)buttonsAccentColor));
                Integer n2 = config.getFilledConfirmButtonTextColor();
                if (n2 != null) {
                    int it = ((Number)n2).intValue();
                    boolean bl2 = false;
                    confirmButton.setTextColor(it);
                }
            } else {
                Intrinsics.checkNotNull((Object)confirmButton);
                this.addRipple((View)confirmButton);
                confirmButton.setTextColor(buttonsAccentColor);
            }
            retryButton.setTextColor(buttonsAccentColor);
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(view.getContext());
        String string2 = config.getTitle();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String string3 = it;
            Object[] objectArray = new Object[]{scanningResult.getBarcodes().size()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            builder.setTitle((CharSequence)string4);
        }
        String string5 = config.getMessage();
        if (string5 != null) {
            String it = string5;
            boolean bl = false;
            builder.setMessage((CharSequence)it);
        }
        AlertDialog alertDialog = builder.setView(view).create();
        Intrinsics.checkNotNullExpressionValue((Object)alertDialog, (String)"create(...)");
        return (Dialog)alertDialog;
    }

    private final void addRipple(View $this$addRipple) {
        TypedValue $this$addRipple_u24lambda_u248 = new TypedValue();
        boolean bl = false;
        $this$addRipple.getContext().getTheme().resolveAttribute(16843534, $this$addRipple_u24lambda_u248, true);
        $this$addRipple.setBackgroundResource($this$addRipple_u24lambda_u248.resourceId);
    }

    public void onCancel(@NotNull DialogInterface dialog) {
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        super.onCancel(dialog);
        if (!this.confirmed) {
            FragmentActivity fragmentActivity = this.getActivity();
            Intrinsics.checkNotNull((Object)fragmentActivity, (String)"null cannot be cast to non-null type io.scanbot.sdk.ui.view.barcode.dialog.BarcodeConfirmationDialogInterface");
            ((BarcodeConfirmationDialogInterface)fragmentActivity).onBarcodeRejected();
        }
    }

    private static final CharSequence onCreateDialog$lambda$0(BarcodeItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    private static final CharSequence onCreateDialog$lambda$1(BarcodeItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFormat().name() + ": " + it.getText();
    }

    private static final void onCreateDialog$lambda$2(BarcodeConfirmationDialog this$0, View it) {
        FragmentActivity fragmentActivity = this$0.getActivity();
        Intrinsics.checkNotNull((Object)fragmentActivity, (String)"null cannot be cast to non-null type io.scanbot.sdk.ui.view.barcode.dialog.BarcodeConfirmationDialogInterface");
        ((BarcodeConfirmationDialogInterface)fragmentActivity).onBarcodeRejected();
        this$0.dismissAllowingStateLoss();
    }

    private static final void onCreateDialog$lambda$3(BarcodeConfirmationDialog this$0, BarcodeScannerResult $scanningResult, View it) {
        this$0.confirmed = true;
        FragmentActivity fragmentActivity = this$0.getActivity();
        Intrinsics.checkNotNull((Object)fragmentActivity, (String)"null cannot be cast to non-null type io.scanbot.sdk.ui.view.barcode.dialog.BarcodeConfirmationDialogInterface");
        ((BarcodeConfirmationDialogInterface)fragmentActivity).onBarcodeConfirmed($scanningResult);
        this$0.dismissAllowingStateLoss();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/scanbot/sdk/ui/view/barcode/dialog/BarcodeConfirmationDialog$Companion;", "", "<init>", "()V", "CONFIGURATION", "", "BARCODE_RESULT", "newInstance", "Lio/scanbot/sdk/ui/view/barcode/dialog/BarcodeConfirmationDialog;", "configuration", "Lio/scanbot/sdk/ui/view/barcode/dialog/BarcodeConfirmationDialogConfiguration;", "result", "Lio/scanbot/sdk/barcode/BarcodeScannerResult;", "newInstance$rtu_ui_barcode_release", "rtu-ui-barcode_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BarcodeConfirmationDialog newInstance$rtu_ui_barcode_release(@NotNull BarcodeConfirmationDialogConfiguration configuration, @NotNull BarcodeScannerResult result) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Bundle args = new Bundle();
            args.putParcelable(BarcodeConfirmationDialog.CONFIGURATION, (Parcelable)configuration);
            args.putParcelable(BarcodeConfirmationDialog.BARCODE_RESULT, (Parcelable)result);
            BarcodeConfirmationDialog fragment = new BarcodeConfirmationDialog();
            fragment.setArguments(args);
            return fragment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BarcodeDialogFormat.values().length];
            try {
                nArray[BarcodeDialogFormat.CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeDialogFormat.TYPE_AND_CODE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

