/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.camera.configuration;

import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import com.google.gson.Gson;
import io.scanbot.sdk.AspectRatio;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.ui.configuration.json.CommonExtensionsKt;
import io.scanbot.sdk.ui.configuration.json.GsonHelper;
import io.scanbot.sdk.ui.configuration.json.JsonAspectRatio;
import io.scanbot.sdk.ui.configuration.json.JsonCameraModule;
import io.scanbot.sdk.ui.configuration.json.JsonCameraPreviewMode;
import io.scanbot.sdk.ui.configuration.json.JsonColor;
import io.scanbot.sdk.ui.configuration.json.JsonImageFilterType;
import io.scanbot.sdk.ui.configuration.json.JsonOrientationLockMode;
import io.scanbot.sdk.ui.configuration.json.JsonSize;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.camera.configuration.DocumentScannerAccessibilityConfiguration;
import io.scanbot.sdk.ui.view.camera.configuration.DocumentScannerConfigurationParams;
import io.scanbot.sdk.ui.view.camera.configuration.json.DocumentJsonExtensionsKt;
import io.scanbot.sdk.ui.view.camera.configuration.json.DocumentScannerJsonConfiguration;
import io.scanbot.sdk.ui.view.camera.configuration.json.ImageFilterTypeExtensionsKt;
import io.scanbot.sdk.ui.view.camera.configuration.json.JsonDocumentScannerAccessibilityConfiguration;
import io.scanbot.sdk.util.JsonConfigUtilsKt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b(\u0018\u0000 \u0095\u00012\u00020\u0001:\u0002\u0095\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\n2\b\b\u0001\u0010#\u001a\u00020\fJ\u0010\u0010$\u001a\u00020\n2\b\b\u0001\u0010%\u001a\u00020\fJ\u0010\u0010&\u001a\u00020\n2\b\b\u0001\u0010'\u001a\u00020\fJ\u000e\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u0005J\u000e\u00100\u001a\u00020\n2\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\fJ\u000e\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\u001aJ\u000e\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020\u0005J\u000e\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u0005J\u000e\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020\u001aJ\u000e\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u0005J\u000e\u0010@\u001a\u00020\n2\u0006\u0010A\u001a\u00020\u001aJ\u000e\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020\u001aJ\u000e\u0010D\u001a\u00020\n2\u0006\u0010C\u001a\u00020\u001aJ\u000e\u0010E\u001a\u00020\n2\u0006\u0010F\u001a\u00020\u001aJ\u000e\u0010G\u001a\u00020\n2\u0006\u0010H\u001a\u00020IJ\u000e\u0010J\u001a\u00020\n2\u0006\u0010K\u001a\u00020!J\u000e\u0010L\u001a\u00020\n2\u0006\u0010M\u001a\u00020\fJ\u000e\u0010N\u001a\u00020\n2\u0006\u0010O\u001a\u00020\u001aJ\u000e\u0010P\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\u0005J\u000e\u0010R\u001a\u00020\n2\u0006\u0010S\u001a\u00020\u001aJ\u000e\u0010T\u001a\u00020\n2\u0006\u0010U\u001a\u00020VJ\u000e\u0010W\u001a\u00020\n2\u0006\u0010X\u001a\u00020\u0005J\u0010\u0010Y\u001a\u00020\n2\b\b\u0001\u0010Z\u001a\u00020\fJ\u000e\u0010[\u001a\u00020\n2\u0006\u0010C\u001a\u00020\u001aJ\u0010\u0010\\\u001a\u00020\n2\b\b\u0001\u0010]\u001a\u00020\fJ\u0010\u0010^\u001a\u00020\n2\b\b\u0001\u0010_\u001a\u00020\fJ\u0010\u0010`\u001a\u00020\n2\b\b\u0001\u0010a\u001a\u00020\fJ\u0010\u0010b\u001a\u00020\n2\b\b\u0001\u0010c\u001a\u00020\fJ\u0010\u0010d\u001a\u00020\n2\b\b\u0001\u0010e\u001a\u00020\fJ\u0010\u0010f\u001a\u00020\n2\b\b\u0001\u0010g\u001a\u00020\fJ\u0010\u0010h\u001a\u00020\n2\b\b\u0001\u0010i\u001a\u00020\fJ\u001e\u0010j\u001a\u00020\n2\u0016\u0010k\u001a\u0012\u0012\u0004\u0012\u00020m0lj\b\u0012\u0004\u0012\u00020m`nJ\u0010\u0010o\u001a\u00020\n2\b\b\u0001\u0010p\u001a\u00020\fJ\u0010\u0010q\u001a\u00020\n2\b\b\u0001\u0010r\u001a\u00020\fJ\u000e\u0010s\u001a\u00020\n2\u0006\u0010t\u001a\u00020\u001aJ\u0010\u0010u\u001a\u00020\n2\b\b\u0001\u0010v\u001a\u00020\fJ\u0010\u0010w\u001a\u00020\n2\b\b\u0001\u0010x\u001a\u00020\fJ\u0010\u0010y\u001a\u00020\n2\u0006\u0010z\u001a\u00020\u001aH\u0007J\u000e\u0010{\u001a\u00020\n2\u0006\u0010|\u001a\u00020\u0005J\u000e\u0010}\u001a\u00020\n2\u0006\u0010~\u001a\u00020\u0005J\u000f\u0010\u007f\u001a\u00020\n2\u0007\u0010\u0080\u0001\u001a\u00020\u0005J\u0010\u0010\u0081\u0001\u001a\u00020\n2\u0007\u0010\u0082\u0001\u001a\u00020\u0005J\u0010\u0010\u0083\u0001\u001a\u00020\n2\u0007\u0010\u0084\u0001\u001a\u00020\u0005J\u0010\u0010\u0085\u0001\u001a\u00020\n2\u0007\u0010\u0086\u0001\u001a\u00020\u0005J\u0010\u0010\u0087\u0001\u001a\u00020\n2\u0007\u0010\u0088\u0001\u001a\u00020\u0005J\u0012\u0010\u0089\u0001\u001a\u00020\n2\t\b\u0001\u0010\u008a\u0001\u001a\u00020\fJ\u0012\u0010\u008b\u0001\u001a\u00020\n2\t\b\u0001\u0010\u008c\u0001\u001a\u00020\fJ\u0012\u0010\u008d\u0001\u001a\u00020\n2\t\b\u0001\u0010\u008e\u0001\u001a\u00020\fJ\u0010\u0010\u008f\u0001\u001a\u00020\n2\u0007\u0010\u0090\u0001\u001a\u00020\u001aJ\u0012\u0010\u0091\u0001\u001a\u00020\n2\t\b\u0001\u0010\u0092\u0001\u001a\u00020\fJ\u0012\u0010\u0093\u0001\u001a\u00020\n2\t\b\u0001\u0010\u0094\u0001\u001a\u00020\fR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0096\u0001"}, d2={"Lio/scanbot/sdk/ui/view/camera/configuration/DocumentScannerConfiguration;", "", "()V", "cameraConfiguration", "", "", "Ljava/io/Serializable;", "getCameraConfiguration", "()Ljava/util/Map;", "enableHardwareSnapButton", "", "key", "", "modifyFromJsonConfiguration", "jsonConfig", "Lio/scanbot/sdk/ui/view/camera/configuration/json/DocumentScannerJsonConfiguration;", "setAcceptedAngleScore", "acceptedAngleScore", "", "setAcceptedSizeScore", "acceptedSizeScore", "setAccessibilityConfiguration", "accessibilityConfiguration", "Lio/scanbot/sdk/ui/view/camera/configuration/DocumentScannerAccessibilityConfiguration;", "setAutoSnappingButtonHidden", "autoSnappingButtonHidden", "", "setAutoSnappingButtonTitle", "autoSnappingButtonTitle", "setAutoSnappingEnabled", "autoSnappingEnabled", "setAutoSnappingSensitivity", "autoSnappingSensitivity", "", "setBottomBarBackgroundColor", "bottomBarBackgroundColor", "setBottomBarButtonsColor", "bottomBarButtonsColor", "setCameraBackgroundColor", "cameraBackgroundColor", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setCancelButtonTitle", "cancelButtonTitle", "setDelayAfterFocusCompleteMs", "delay", "", "setDocumentImageSizeLimit", "documentImageHeightLimit", "documentImageWidthLimit", "setDrawPolygonShadows", "drawPolygonShadows", "setEnableCameraButtonTitle", "enableCameraButtonTitle", "setEnableCameraExplanationText", "enableCameraExplanationText", "setFlashButtonHidden", "flashButtonHidden", "setFlashButtonTitle", "flashButtonTitle", "setFlashEnabled", "flashEnabled", "setForceMaxSnappingSize", "enabled", "setForceUserGuidance", "setIgnoreBadAspectRatio", "ignoreBadAspectRatio", "setImageFilterType", "imageFilterType", "Lio/scanbot/sdk/process/ImageFilterType;", "setImageScale", "imageScale", "setMaxNumberOfPages", "maxNumberOfPages", "setMultiPageButtonHidden", "multiPageButtonHidden", "setMultiPageButtonTitle", "multiPageButtonTitle", "setMultiPageEnabled", "multiPageEnabled", "setOrientationLockMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setPageCounterButtonTitle", "pageCounterButtonTitle", "setPolygonAutoSnapProgressColor", "polygonAutoSnapProgressColor", "setPolygonAutoSnapProgressEnabled", "setPolygonAutoSnapProgressLineWidth", "polygonProgressLineWidth", "setPolygonBackgroundColor", "polygonBackgroundColor", "setPolygonBackgroundColorOK", "polygonBackgroundColorOK", "setPolygonColor", "polygonColor", "setPolygonColorOK", "polygonColorOK", "setPolygonCornerRadius", "polygonCornerRadius", "setPolygonLineWidth", "polygonLineWidth", "setRequiredAspectRatios", "requiredAspectRatios", "Ljava/util/ArrayList;", "Lio/scanbot/sdk/AspectRatio;", "Lkotlin/collections/ArrayList;", "setShutterButtonAutoInnerColor", "shutterButtonAutoInnerColor", "setShutterButtonAutoOuterColor", "shutterButtonAutoOuterColor", "setShutterButtonHidden", "shutterButtonHidden", "setShutterButtonManualInnerColor", "shutterButtonManualInnerColor", "setShutterButtonManualOuterColor", "shutterButtonManualOuterColor", "setShutterSoundEnabled", "shutterSoundEnabled", "setTextHintBadAngles", "textBadAngles", "setTextHintBadAspectRatio", "textHintBadAspectRatio", "setTextHintNothingDetected", "textHintNothingDetected", "setTextHintOK", "textHintDontMove", "setTextHintTooDark", "textHintTooDark", "setTextHintTooNoisy", "textHintTooNoisy", "setTextHintTooSmall", "textHintTooSmall", "setTopBarBackgroundColor", "topBarBackgroundColor", "setTopBarButtonsActiveColor", "topBarButtonsActiveColor", "setTopBarButtonsInactiveColor", "topBarButtonsInactiveColor", "setUseButtonsAllCaps", "allCaps", "setUserGuidanceBackgroundColor", "userGuidanceBackgroundColor", "setUserGuidanceTextColor", "userGuidanceTextColor", "Companion", "rtu-ui-docdetector_release"})
public final class DocumentScannerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Serializable> cameraConfiguration = new HashMap();

    @NotNull
    public final Map<String, Serializable> getCameraConfiguration() {
        return this.cameraConfiguration;
    }

    public final void setImageFilterType(@NotNull ImageFilterType imageFilterType) {
        Intrinsics.checkNotNullParameter((Object)imageFilterType, (String)"imageFilterType");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.IMAGE_FILTER_TYPE.getKey(), (Serializable)imageFilterType);
    }

    public final void setDelayAfterFocusCompleteMs(long delay) {
        Long l = delay;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.DELAY_AFTER_FOCUS_COMPLETE_MS.getKey(), l);
    }

    public final void setAutoSnappingEnabled(boolean autoSnappingEnabled) {
        Boolean bl = autoSnappingEnabled;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_ENABLED.getKey(), bl);
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        Boolean bl = flashEnabled;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FLASH_ENABLED.getKey(), bl);
    }

    public final void setMultiPageEnabled(boolean multiPageEnabled) {
        Boolean bl = multiPageEnabled;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MULTI_PAGE_ENABLED.getKey(), bl);
    }

    public final void setMaxNumberOfPages(int maxNumberOfPages) {
        Integer n = maxNumberOfPages;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MAX_NUMBER_OF_PAGES.getKey(), n);
    }

    public final void setAutoSnappingSensitivity(float autoSnappingSensitivity) {
        Float f = Float.valueOf(autoSnappingSensitivity);
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_SENSITIVITY.getKey(), f);
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CAMERA_PREVIEW_MODE.getKey(), (Serializable)cameraPreviewMode);
    }

    public final void setOrientationLockMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ORIENTATION_LOCK_MODE.getKey(), (Serializable)cameraOrientationMode);
    }

    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CAMERA_MODULE.getKey(), (Serializable)cameraModule);
    }

    public final void enableHardwareSnapButton(int key) {
        Integer n = key;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.HARDWARE_SNAP_BUTTON.getKey(), n);
    }

    public static /* synthetic */ void enableHardwareSnapButton$default(DocumentScannerConfiguration documentScannerConfiguration, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 25;
        }
        documentScannerConfiguration.enableHardwareSnapButton(n);
    }

    public final void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        Boolean bl = ignoreBadAspectRatio;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.IGNORE_BAD_ASPECT_RATIO.getKey(), bl);
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        Double d = acceptedAngleScore;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ACCEPTED_ANGLE_SCORE.getKey(), d);
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        Double d = acceptedSizeScore;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ACCEPTED_SIZE_SCORE.getKey(), d);
    }

    public final void setImageScale(float imageScale) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.IMAGE_SCALE.getKey(), Float.valueOf(Math.min(Math.max(0.0f, imageScale), 1.0f)));
    }

    public final void setDocumentImageSizeLimit(int documentImageHeightLimit, int documentImageWidthLimit) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.DOCUMENT_IMAGE_SIZE_LIMIT.getKey(), (Serializable)new PageStorageProcessor.Configuration.Size(documentImageWidthLimit, documentImageHeightLimit));
    }

    public final void setPolygonColor(@ColorInt int polygonColor) {
        Integer n = polygonColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_COLOR.getKey(), n);
    }

    public final void setPolygonColorOK(@ColorInt int polygonColorOK) {
        Integer n = polygonColorOK;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_COLOR_OK.getKey(), n);
    }

    public final void setPolygonLineWidth(@Px int polygonLineWidth) {
        Integer n = polygonLineWidth;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_LINE_WIDTH.getKey(), n);
    }

    public final void setPolygonAutoSnapProgressColor(@ColorInt int polygonAutoSnapProgressColor) {
        Integer n = polygonAutoSnapProgressColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_PROGRESS_COLOR.getKey(), n);
    }

    public final void setPolygonAutoSnapProgressLineWidth(@Px int polygonProgressLineWidth) {
        Integer n = polygonProgressLineWidth;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_PROGRESS_LINE_WIDTH.getKey(), n);
    }

    public final void setPolygonAutoSnapProgressEnabled(boolean enabled) {
        Boolean bl = enabled;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_PROGRESS_ENABLED.getKey(), bl);
    }

    public final void setPolygonCornerRadius(@Px int polygonCornerRadius) {
        Integer n = polygonCornerRadius;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_CORNER_RADIUS.getKey(), n);
    }

    public final void setPolygonBackgroundColor(@ColorInt int polygonBackgroundColor) {
        Integer n = polygonBackgroundColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setPolygonBackgroundColorOK(@ColorInt int polygonBackgroundColorOK) {
        Integer n = polygonBackgroundColorOK;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_BACKGROUND_COLOR_OK.getKey(), n);
    }

    public final void setDrawPolygonShadows(boolean drawPolygonShadows) {
        Boolean bl = drawPolygonShadows;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_DRAW_SHADOWS.getKey(), bl);
    }

    public final void setShutterButtonAutoOuterColor(@ColorInt int shutterButtonAutoOuterColor) {
        Integer n = shutterButtonAutoOuterColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_AUTO_OUTER_COLOR.getKey(), n);
    }

    public final void setShutterButtonAutoInnerColor(@ColorInt int shutterButtonAutoInnerColor) {
        Integer n = shutterButtonAutoInnerColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_AUTO_INNER_COLOR.getKey(), n);
    }

    public final void setShutterButtonManualOuterColor(@ColorInt int shutterButtonManualOuterColor) {
        Integer n = shutterButtonManualOuterColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_OUTER_COLOR.getKey(), n);
    }

    public final void setShutterButtonManualInnerColor(@ColorInt int shutterButtonManualInnerColor) {
        Integer n = shutterButtonManualInnerColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_INNER_COLOR.getKey(), n);
    }

    @RequiresApi(api=17)
    public final void setShutterSoundEnabled(boolean shutterSoundEnabled) {
        Boolean bl = shutterSoundEnabled;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_SOUND_ENABLED.getKey(), bl);
    }

    public final void setUserGuidanceBackgroundColor(@ColorInt int userGuidanceBackgroundColor) {
        Integer n = userGuidanceBackgroundColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.USER_GUIDANCE_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setUserGuidanceTextColor(@ColorInt int userGuidanceTextColor) {
        Integer n = userGuidanceTextColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.USER_GUIDANCE_TEXT_COLOR.getKey(), n);
    }

    public final void setTopBarBackgroundColor(@ColorInt int topBarBackgroundColor) {
        Integer n = topBarBackgroundColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TOP_BAR_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsActiveColor(@ColorInt int topBarButtonsActiveColor) {
        Integer n = topBarButtonsActiveColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TOP_BAR_BUTTONS_ACTIVE_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsInactiveColor(@ColorInt int topBarButtonsInactiveColor) {
        Integer n = topBarButtonsInactiveColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TOP_BAR_BUTTONS_INACTIVE_COLOR.getKey(), n);
    }

    public final void setBottomBarBackgroundColor(@ColorInt int bottomBarBackgroundColor) {
        Integer n = bottomBarBackgroundColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.BOTTOM_BAR_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setBottomBarButtonsColor(@ColorInt int bottomBarButtonsColor) {
        Integer n = bottomBarButtonsColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.BOTTOM_BAR_BUTTONS_COLOR.getKey(), n);
    }

    public final void setCameraBackgroundColor(@ColorInt int cameraBackgroundColor) {
        Integer n = cameraBackgroundColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CAMERA_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setMultiPageButtonHidden(boolean multiPageButtonHidden) {
        Boolean bl = multiPageButtonHidden;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MULTI_PAGE_BUTTON_HIDDEN.getKey(), bl);
    }

    public final void setFlashButtonHidden(boolean flashButtonHidden) {
        Boolean bl = flashButtonHidden;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FLASH_BUTTON_HIDDEN.getKey(), bl);
    }

    public final void setAutoSnappingButtonHidden(boolean autoSnappingButtonHidden) {
        Boolean bl = autoSnappingButtonHidden;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_BUTTON_HIDDEN.getKey(), bl);
    }

    public final void setShutterButtonHidden(boolean shutterButtonHidden) {
        Boolean bl = shutterButtonHidden;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_HIDDEN.getKey(), bl);
    }

    public final void setCancelButtonTitle(@NotNull String cancelButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)cancelButtonTitle, (String)"cancelButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CANCEL_BUTTON_TITLE.getKey(), (Serializable)((Object)cancelButtonTitle));
    }

    public final void setPageCounterButtonTitle(@NotNull String pageCounterButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)pageCounterButtonTitle, (String)"pageCounterButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.PAGE_COUNTER_BUTTON_TITLE.getKey(), (Serializable)((Object)pageCounterButtonTitle));
    }

    public final void setTextHintOK(@NotNull String textHintDontMove) {
        Intrinsics.checkNotNullParameter((Object)textHintDontMove, (String)"textHintDontMove");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_OK.getKey(), (Serializable)((Object)textHintDontMove));
    }

    public final void setTextHintTooSmall(@NotNull String textHintTooSmall) {
        Intrinsics.checkNotNullParameter((Object)textHintTooSmall, (String)"textHintTooSmall");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_TOO_SMALL.getKey(), (Serializable)((Object)textHintTooSmall));
    }

    public final void setTextHintBadAngles(@NotNull String textBadAngles) {
        Intrinsics.checkNotNullParameter((Object)textBadAngles, (String)"textBadAngles");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_BAD_ANGLES.getKey(), (Serializable)((Object)textBadAngles));
    }

    public final void setTextHintBadAspectRatio(@NotNull String textHintBadAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)textHintBadAspectRatio, (String)"textHintBadAspectRatio");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_BAD_ASPECT_RATIO.getKey(), (Serializable)((Object)textHintBadAspectRatio));
    }

    public final void setTextHintNothingDetected(@NotNull String textHintNothingDetected) {
        Intrinsics.checkNotNullParameter((Object)textHintNothingDetected, (String)"textHintNothingDetected");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_NOTHING_DETECTED.getKey(), (Serializable)((Object)textHintNothingDetected));
    }

    public final void setTextHintTooNoisy(@NotNull String textHintTooNoisy) {
        Intrinsics.checkNotNullParameter((Object)textHintTooNoisy, (String)"textHintTooNoisy");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_TOO_NOISY.getKey(), (Serializable)((Object)textHintTooNoisy));
    }

    public final void setTextHintTooDark(@NotNull String textHintTooDark) {
        Intrinsics.checkNotNullParameter((Object)textHintTooDark, (String)"textHintTooDark");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_TOO_DARK.getKey(), (Serializable)((Object)textHintTooDark));
    }

    public final void setMultiPageButtonTitle(@NotNull String multiPageButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)multiPageButtonTitle, (String)"multiPageButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MULTI_PAGE_BUTTON_TITLE.getKey(), (Serializable)((Object)multiPageButtonTitle));
    }

    public final void setFlashButtonTitle(@NotNull String flashButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)flashButtonTitle, (String)"flashButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FLASH_BUTTON_TITLE.getKey(), (Serializable)((Object)flashButtonTitle));
    }

    public final void setAutoSnappingButtonTitle(@NotNull String autoSnappingButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)autoSnappingButtonTitle, (String)"autoSnappingButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_BUTTON_TITLE.getKey(), (Serializable)((Object)autoSnappingButtonTitle));
    }

    public final void setEnableCameraExplanationText(@NotNull String enableCameraExplanationText) {
        Intrinsics.checkNotNullParameter((Object)enableCameraExplanationText, (String)"enableCameraExplanationText");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ENABLE_CAMERA_EXPLANATION_TEXT.getKey(), (Serializable)((Object)enableCameraExplanationText));
    }

    public final void setEnableCameraButtonTitle(@NotNull String enableCameraButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)enableCameraButtonTitle, (String)"enableCameraButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ENABLE_CAMERA_BUTTON_TITLE.getKey(), (Serializable)((Object)enableCameraButtonTitle));
    }

    public final void setUseButtonsAllCaps(boolean allCaps) {
        Boolean bl = allCaps;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.USE_BUTTONS_ALL_CAPS.getKey(), bl);
    }

    public final void setAccessibilityConfiguration(@NotNull DocumentScannerAccessibilityConfiguration accessibilityConfiguration) {
        Intrinsics.checkNotNullParameter((Object)accessibilityConfiguration, (String)"accessibilityConfiguration");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ACCESSIBILITY_CONFIGURATION.getKey(), accessibilityConfiguration);
    }

    public final void setForceMaxSnappingSize(boolean enabled) {
        Boolean bl = enabled;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FORCE_MAX_SNAPPING_SIZE.getKey(), bl);
    }

    public final void setForceUserGuidance(boolean enabled) {
        Boolean bl = enabled;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FORCE_USER_GUIDANCE.getKey(), bl);
    }

    public final void setRequiredAspectRatios(@NotNull ArrayList<AspectRatio> requiredAspectRatios) {
        Intrinsics.checkNotNullParameter(requiredAspectRatios, (String)"requiredAspectRatios");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.REQUIRED_ASPECT_RATIOS.getKey(), requiredAspectRatios);
    }

    /*
     * WARNING - void declaration
     */
    public final void modifyFromJsonConfiguration(@NotNull DocumentScannerJsonConfiguration jsonConfig) {
        Unit unit;
        Unit unit2;
        Unit unit3;
        Unit unit4;
        Unit unit5;
        Unit unit6;
        Unit unit7;
        Unit unit8;
        Unit unit9;
        Unit unit10;
        Unit unit11;
        Unit unit12;
        Unit unit13;
        Unit unit14;
        Unit unit15;
        Unit unit16;
        Unit unit17;
        Unit unit18;
        Unit unit19;
        Unit unit20;
        Unit unit21;
        Unit unit22;
        Unit unit23;
        Unit unit24;
        Unit unit25;
        Unit unit26;
        Unit unit27;
        Unit unit28;
        Unit unit29;
        Unit unit30;
        Unit unit31;
        Unit unit32;
        Unit unit33;
        Unit unit34;
        Unit unit35;
        Unit unit36;
        Unit unit37;
        Unit unit38;
        Unit unit39;
        Unit unit40;
        Unit unit41;
        Unit unit42;
        Unit unit43;
        Unit unit44;
        Unit unit45;
        Unit unit46;
        Unit unit47;
        Unit unit48;
        Unit unit49;
        Unit unit50;
        Unit unit51;
        Unit unit52;
        Unit unit53;
        Unit unit54;
        Unit unit55;
        Unit unit56;
        Unit unit57;
        double it;
        Intrinsics.checkNotNullParameter((Object)jsonConfig, (String)"jsonConfig");
        Double d = jsonConfig.getAcceptedAngleScore();
        if (d != null) {
            it = ((Number)d).doubleValue();
            boolean bl = false;
            this.setAcceptedAngleScore(it);
            unit57 = Unit.INSTANCE;
        } else {
            unit57 = null;
        }
        Double d2 = jsonConfig.getAcceptedSizeScore();
        if (d2 != null) {
            it = ((Number)d2).doubleValue();
            boolean bl = false;
            this.setAcceptedSizeScore(it);
            unit56 = Unit.INSTANCE;
        } else {
            unit56 = null;
        }
        JsonDocumentScannerAccessibilityConfiguration jsonDocumentScannerAccessibilityConfiguration = jsonConfig.getAccessibilityConfiguration();
        if (jsonDocumentScannerAccessibilityConfiguration != null) {
            JsonDocumentScannerAccessibilityConfiguration it2 = jsonDocumentScannerAccessibilityConfiguration;
            boolean bl = false;
            this.setAccessibilityConfiguration(DocumentJsonExtensionsKt.toSdk(it2));
            unit55 = Unit.INSTANCE;
        } else {
            unit55 = null;
        }
        Boolean bl = jsonConfig.getAutoSnappingButtonHidden();
        if (bl != null) {
            boolean it3 = bl;
            boolean bl2 = false;
            this.setAutoSnappingButtonHidden(it3);
            unit54 = Unit.INSTANCE;
        } else {
            unit54 = null;
        }
        String string = jsonConfig.getAutoSnappingButtonTitle();
        if (string != null) {
            String it4 = string;
            boolean bl3 = false;
            this.setAutoSnappingButtonTitle(it4);
            unit53 = Unit.INSTANCE;
        } else {
            unit53 = null;
        }
        Boolean bl4 = jsonConfig.getAutoSnappingEnabled();
        if (bl4 != null) {
            boolean it5 = bl4;
            boolean bl5 = false;
            this.setAutoSnappingEnabled(it5);
            unit52 = Unit.INSTANCE;
        } else {
            unit52 = null;
        }
        Double d3 = jsonConfig.getAutoSnappingSensitivity();
        if (d3 != null) {
            double it6 = ((Number)d3).doubleValue();
            boolean bl6 = false;
            this.setAutoSnappingSensitivity((float)it6);
            unit51 = Unit.INSTANCE;
        } else {
            unit51 = null;
        }
        JsonColor jsonColor = jsonConfig.getBottomBarBackgroundColor();
        if (jsonColor != null) {
            JsonColor it7 = jsonColor;
            boolean bl7 = false;
            this.setBottomBarBackgroundColor(it7.toSdk());
            unit50 = Unit.INSTANCE;
        } else {
            unit50 = null;
        }
        JsonColor jsonColor2 = jsonConfig.getBottomBarButtonsColor();
        if (jsonColor2 != null) {
            JsonColor it8 = jsonColor2;
            boolean bl8 = false;
            this.setBottomBarButtonsColor(it8.toSdk());
            unit49 = Unit.INSTANCE;
        } else {
            unit49 = null;
        }
        JsonColor jsonColor3 = jsonConfig.getCameraBackgroundColor();
        if (jsonColor3 != null) {
            JsonColor it9 = jsonColor3;
            boolean bl9 = false;
            this.setCameraBackgroundColor(it9.toSdk());
            unit48 = Unit.INSTANCE;
        } else {
            unit48 = null;
        }
        JsonCameraModule jsonCameraModule = jsonConfig.getCameraModule();
        if (jsonCameraModule != null) {
            JsonCameraModule it10 = jsonCameraModule;
            boolean bl10 = false;
            this.setCameraModule(CommonExtensionsKt.toSdk((JsonCameraModule)it10));
            unit47 = Unit.INSTANCE;
        } else {
            unit47 = null;
        }
        JsonCameraPreviewMode jsonCameraPreviewMode = jsonConfig.getCameraPreviewMode();
        if (jsonCameraPreviewMode != null) {
            JsonCameraPreviewMode it11 = jsonCameraPreviewMode;
            boolean bl11 = false;
            this.setCameraPreviewMode(CommonExtensionsKt.toSdk((JsonCameraPreviewMode)it11));
            unit46 = Unit.INSTANCE;
        } else {
            unit46 = null;
        }
        String string2 = jsonConfig.getCancelButtonTitle();
        if (string2 != null) {
            String it12 = string2;
            boolean bl12 = false;
            this.setCancelButtonTitle(it12);
            unit45 = Unit.INSTANCE;
        } else {
            unit45 = null;
        }
        JsonSize jsonSize = jsonConfig.getDocumentImageSizeLimit();
        if (jsonSize != null) {
            JsonSize it13 = jsonSize;
            boolean bl13 = false;
            this.setDocumentImageSizeLimit((int)it13.getWidth(), (int)it13.getHeight());
            unit44 = Unit.INSTANCE;
        } else {
            unit44 = null;
        }
        String string3 = jsonConfig.getEnableCameraButtonTitle();
        if (string3 != null) {
            String it14 = string3;
            boolean bl14 = false;
            this.setEnableCameraButtonTitle(it14);
            unit43 = Unit.INSTANCE;
        } else {
            unit43 = null;
        }
        String string4 = jsonConfig.getEnableCameraExplanationText();
        if (string4 != null) {
            String it15 = string4;
            boolean bl15 = false;
            this.setEnableCameraExplanationText(it15);
            unit42 = Unit.INSTANCE;
        } else {
            unit42 = null;
        }
        Boolean bl16 = jsonConfig.getFlashButtonHidden();
        if (bl16 != null) {
            boolean it16 = bl16;
            boolean bl17 = false;
            this.setFlashButtonHidden(it16);
            unit41 = Unit.INSTANCE;
        } else {
            unit41 = null;
        }
        String string5 = jsonConfig.getFlashButtonTitle();
        if (string5 != null) {
            String it17 = string5;
            boolean bl18 = false;
            this.setFlashButtonTitle(it17);
            unit40 = Unit.INSTANCE;
        } else {
            unit40 = null;
        }
        Boolean bl19 = jsonConfig.getFlashEnabled();
        if (bl19 != null) {
            boolean it18 = bl19;
            boolean bl20 = false;
            this.setFlashEnabled(it18);
            unit39 = Unit.INSTANCE;
        } else {
            unit39 = null;
        }
        Boolean bl21 = jsonConfig.getIgnoreBadAspectRatio();
        if (bl21 != null) {
            boolean it19 = bl21;
            boolean bl22 = false;
            this.setIgnoreBadAspectRatio(it19);
            unit38 = Unit.INSTANCE;
        } else {
            unit38 = null;
        }
        Double d4 = jsonConfig.getImageScale();
        if (d4 != null) {
            double it20 = ((Number)d4).doubleValue();
            boolean bl23 = false;
            this.setImageScale((float)it20);
            unit37 = Unit.INSTANCE;
        } else {
            unit37 = null;
        }
        JsonOrientationLockMode jsonOrientationLockMode = jsonConfig.getOrientationLockMode();
        if (jsonOrientationLockMode != null) {
            JsonOrientationLockMode it21 = jsonOrientationLockMode;
            boolean bl24 = false;
            CameraOrientationMode cameraOrientationMode = CommonExtensionsKt.toSdk((JsonOrientationLockMode)it21);
            if (cameraOrientationMode != null) {
                CameraOrientationMode lockMode = cameraOrientationMode;
                boolean bl25 = false;
                this.setOrientationLockMode(lockMode);
                unit36 = Unit.INSTANCE;
            } else {
                unit36 = null;
            }
        } else {
            unit36 = null;
        }
        Integer n = jsonConfig.getMaxNumberOfPages();
        if (n != null) {
            int it22 = ((Number)n).intValue();
            boolean bl26 = false;
            this.setMaxNumberOfPages(it22);
            unit35 = Unit.INSTANCE;
        } else {
            unit35 = null;
        }
        Boolean bl27 = jsonConfig.getMultiPageButtonHidden();
        if (bl27 != null) {
            boolean it23 = bl27;
            boolean bl28 = false;
            this.setMultiPageButtonHidden(it23);
            unit34 = Unit.INSTANCE;
        } else {
            unit34 = null;
        }
        String string6 = jsonConfig.getMultiPageButtonTitle();
        if (string6 != null) {
            String it24 = string6;
            boolean bl29 = false;
            this.setMultiPageButtonTitle(it24);
            unit33 = Unit.INSTANCE;
        } else {
            unit33 = null;
        }
        Boolean bl30 = jsonConfig.getMultiPageEnabled();
        if (bl30 != null) {
            boolean it25 = bl30;
            boolean bl31 = false;
            this.setMultiPageEnabled(it25);
            unit32 = Unit.INSTANCE;
        } else {
            unit32 = null;
        }
        String string7 = jsonConfig.getPageCounterButtonTitle();
        if (string7 != null) {
            String it26 = string7;
            boolean bl32 = false;
            this.setPageCounterButtonTitle(JsonConfigUtilsKt.toAndroidFormatString((String)it26));
            unit31 = Unit.INSTANCE;
        } else {
            unit31 = null;
        }
        JsonColor jsonColor4 = jsonConfig.getPolygonAutoSnapProgressColor();
        if (jsonColor4 != null) {
            JsonColor it27 = jsonColor4;
            boolean bl33 = false;
            this.setPolygonAutoSnapProgressColor(it27.toSdk());
            unit30 = Unit.INSTANCE;
        } else {
            unit30 = null;
        }
        Boolean bl34 = jsonConfig.getPolygonAutoSnapProgressEnabled();
        if (bl34 != null) {
            boolean it28 = bl34;
            boolean bl35 = false;
            this.setPolygonAutoSnapProgressEnabled(it28);
            unit29 = Unit.INSTANCE;
        } else {
            unit29 = null;
        }
        Double d5 = jsonConfig.getPolygonAutoSnapProgressLineWidth();
        if (d5 != null) {
            double it29 = ((Number)d5).doubleValue();
            boolean bl36 = false;
            this.setPolygonAutoSnapProgressLineWidth((int)it29);
            unit28 = Unit.INSTANCE;
        } else {
            unit28 = null;
        }
        JsonColor jsonColor5 = jsonConfig.getPolygonBackgroundColor();
        if (jsonColor5 != null) {
            JsonColor it30 = jsonColor5;
            boolean bl37 = false;
            this.setPolygonBackgroundColor(it30.toSdk());
            unit27 = Unit.INSTANCE;
        } else {
            unit27 = null;
        }
        JsonColor jsonColor6 = jsonConfig.getPolygonBackgroundColorOK();
        if (jsonColor6 != null) {
            JsonColor it31 = jsonColor6;
            boolean bl38 = false;
            this.setPolygonBackgroundColorOK(it31.toSdk());
            unit26 = Unit.INSTANCE;
        } else {
            unit26 = null;
        }
        JsonColor jsonColor7 = jsonConfig.getPolygonColor();
        if (jsonColor7 != null) {
            JsonColor it32 = jsonColor7;
            boolean bl39 = false;
            this.setPolygonColor(it32.toSdk());
            unit25 = Unit.INSTANCE;
        } else {
            unit25 = null;
        }
        JsonColor jsonColor8 = jsonConfig.getPolygonColorOK();
        if (jsonColor8 != null) {
            JsonColor it33 = jsonColor8;
            boolean bl40 = false;
            this.setPolygonColorOK(it33.toSdk());
            unit24 = Unit.INSTANCE;
        } else {
            unit24 = null;
        }
        Double d6 = jsonConfig.getPolygonCornerRadius();
        if (d6 != null) {
            double it34 = ((Number)d6).doubleValue();
            boolean bl41 = false;
            this.setPolygonCornerRadius((int)it34);
            unit23 = Unit.INSTANCE;
        } else {
            unit23 = null;
        }
        Double d7 = jsonConfig.getPolygonLineWidth();
        if (d7 != null) {
            double it35 = ((Number)d7).doubleValue();
            boolean bl42 = false;
            this.setPolygonLineWidth((int)it35);
            unit22 = Unit.INSTANCE;
        } else {
            unit22 = null;
        }
        JsonColor jsonColor9 = jsonConfig.getShutterButtonAutoInnerColor();
        if (jsonColor9 != null) {
            JsonColor it36 = jsonColor9;
            boolean bl43 = false;
            this.setShutterButtonAutoInnerColor(it36.toSdk());
            unit21 = Unit.INSTANCE;
        } else {
            unit21 = null;
        }
        JsonColor jsonColor10 = jsonConfig.getShutterButtonAutoOuterColor();
        if (jsonColor10 != null) {
            JsonColor it37 = jsonColor10;
            boolean bl44 = false;
            this.setShutterButtonAutoOuterColor(it37.toSdk());
            unit20 = Unit.INSTANCE;
        } else {
            unit20 = null;
        }
        Boolean bl45 = jsonConfig.getShutterButtonHidden();
        if (bl45 != null) {
            boolean it38 = bl45;
            boolean bl46 = false;
            this.setShutterButtonHidden(it38);
            unit19 = Unit.INSTANCE;
        } else {
            unit19 = null;
        }
        JsonColor jsonColor11 = jsonConfig.getShutterButtonManualInnerColor();
        if (jsonColor11 != null) {
            JsonColor it39 = jsonColor11;
            boolean bl47 = false;
            this.setShutterButtonManualInnerColor(it39.toSdk());
            unit18 = Unit.INSTANCE;
        } else {
            unit18 = null;
        }
        JsonColor jsonColor12 = jsonConfig.getShutterButtonManualOuterColor();
        if (jsonColor12 != null) {
            JsonColor it40 = jsonColor12;
            boolean bl48 = false;
            this.setShutterButtonManualOuterColor(it40.toSdk());
            unit17 = Unit.INSTANCE;
        } else {
            unit17 = null;
        }
        String string8 = jsonConfig.getTextHintBadAngles();
        if (string8 != null) {
            String it41 = string8;
            boolean bl49 = false;
            this.setTextHintBadAngles(it41);
            unit16 = Unit.INSTANCE;
        } else {
            unit16 = null;
        }
        String string9 = jsonConfig.getTextHintBadAspectRatio();
        if (string9 != null) {
            String it42 = string9;
            boolean bl50 = false;
            this.setTextHintBadAspectRatio(it42);
            unit15 = Unit.INSTANCE;
        } else {
            unit15 = null;
        }
        String string10 = jsonConfig.getTextHintNothingDetected();
        if (string10 != null) {
            String it43 = string10;
            boolean bl51 = false;
            this.setTextHintNothingDetected(it43);
            unit14 = Unit.INSTANCE;
        } else {
            unit14 = null;
        }
        String string11 = jsonConfig.getTextHintOK();
        if (string11 != null) {
            String it44 = string11;
            boolean bl52 = false;
            this.setTextHintOK(it44);
            unit13 = Unit.INSTANCE;
        } else {
            unit13 = null;
        }
        String string12 = jsonConfig.getTextHintTooDark();
        if (string12 != null) {
            String it45 = string12;
            boolean bl53 = false;
            this.setTextHintTooDark(it45);
            unit12 = Unit.INSTANCE;
        } else {
            unit12 = null;
        }
        String string13 = jsonConfig.getTextHintTooNoisy();
        if (string13 != null) {
            String it46 = string13;
            boolean bl54 = false;
            this.setTextHintTooNoisy(it46);
            unit11 = Unit.INSTANCE;
        } else {
            unit11 = null;
        }
        String string14 = jsonConfig.getTextHintTooSmall();
        if (string14 != null) {
            String it47 = string14;
            boolean bl55 = false;
            this.setTextHintTooSmall(it47);
            unit10 = Unit.INSTANCE;
        } else {
            unit10 = null;
        }
        JsonColor jsonColor13 = jsonConfig.getTopBarBackgroundColor();
        if (jsonColor13 != null) {
            JsonColor it48 = jsonColor13;
            boolean bl56 = false;
            this.setTopBarBackgroundColor(it48.toSdk());
            unit9 = Unit.INSTANCE;
        } else {
            unit9 = null;
        }
        JsonColor jsonColor14 = jsonConfig.getTopBarButtonsActiveColor();
        if (jsonColor14 != null) {
            JsonColor it49 = jsonColor14;
            boolean bl57 = false;
            this.setTopBarButtonsActiveColor(it49.toSdk());
            unit8 = Unit.INSTANCE;
        } else {
            unit8 = null;
        }
        JsonColor jsonColor15 = jsonConfig.getTopBarButtonsInactiveColor();
        if (jsonColor15 != null) {
            JsonColor it50 = jsonColor15;
            boolean bl58 = false;
            this.setTopBarButtonsInactiveColor(it50.toSdk());
            unit7 = Unit.INSTANCE;
        } else {
            unit7 = null;
        }
        Boolean bl59 = jsonConfig.getUseButtonsAllCaps();
        if (bl59 != null) {
            boolean it51 = bl59;
            boolean bl60 = false;
            this.setUseButtonsAllCaps(it51);
            unit6 = Unit.INSTANCE;
        } else {
            unit6 = null;
        }
        JsonColor jsonColor16 = jsonConfig.getUserGuidanceBackgroundColor();
        if (jsonColor16 != null) {
            JsonColor it52 = jsonColor16;
            boolean bl61 = false;
            this.setUserGuidanceBackgroundColor(it52.toSdk());
            unit5 = Unit.INSTANCE;
        } else {
            unit5 = null;
        }
        JsonColor jsonColor17 = jsonConfig.getUserGuidanceTextColor();
        if (jsonColor17 != null) {
            JsonColor it53 = jsonColor17;
            boolean bl62 = false;
            this.setUserGuidanceTextColor(it53.toSdk());
            unit4 = Unit.INSTANCE;
        } else {
            unit4 = null;
        }
        List<JsonAspectRatio> list = jsonConfig.getRequiredAspectRatios();
        if (list != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<JsonAspectRatio> it54 = list;
            boolean bl63 = false;
            Iterable bl42 = it54;
            DocumentScannerConfiguration documentScannerConfiguration = this;
            boolean $i$f$map = false;
            void var8_68 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it55;
                JsonAspectRatio jsonAspectRatio = (JsonAspectRatio)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl64 = false;
                collection.add(CommonExtensionsKt.toSdk((JsonAspectRatio)it55));
            }
            Collection collection = (List)destination$iv$iv;
            documentScannerConfiguration.setRequiredAspectRatios(new ArrayList<AspectRatio>(collection));
            unit3 = Unit.INSTANCE;
        } else {
            unit3 = null;
        }
        Boolean bl65 = jsonConfig.getForceUserGuidance();
        if (bl65 != null) {
            boolean it56 = bl65;
            boolean bl66 = false;
            this.setForceUserGuidance(it56);
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        JsonImageFilterType jsonImageFilterType = jsonConfig.getDefaultPageFilter();
        if (jsonImageFilterType != null) {
            JsonImageFilterType it57 = jsonImageFilterType;
            boolean bl67 = false;
            this.setImageFilterType(ImageFilterTypeExtensionsKt.toSdk(it57));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/camera/configuration/DocumentScannerConfiguration$Companion;", "", "()V", "fromJson", "Lio/scanbot/sdk/ui/view/camera/configuration/DocumentScannerConfiguration;", "input", "", "rtu-ui-docdetector_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DocumentScannerConfiguration fromJson(@NotNull String input) {
            DocumentScannerConfiguration documentScannerConfiguration;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Gson gson = GsonHelper.INSTANCE.prepareGson();
            DocumentScannerJsonConfiguration jsonConfig = (DocumentScannerJsonConfiguration)gson.fromJson(input, DocumentScannerJsonConfiguration.class);
            DocumentScannerConfiguration $this$fromJson_u24lambda_u2d0 = documentScannerConfiguration = new DocumentScannerConfiguration();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)jsonConfig, (String)"jsonConfig");
            $this$fromJson_u24lambda_u2d0.modifyFromJsonConfiguration(jsonConfig);
            return documentScannerConfiguration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

