/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.camera.configuration;

import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import com.google.gson.Gson;
import io.scanbot.sdk.AspectRatio;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.ui.configuration.json.CommonExtensionsKt;
import io.scanbot.sdk.ui.configuration.json.GsonHelper;
import io.scanbot.sdk.ui.configuration.json.JsonAspectRatio;
import io.scanbot.sdk.ui.configuration.json.JsonCameraModule;
import io.scanbot.sdk.ui.configuration.json.JsonCameraPreviewMode;
import io.scanbot.sdk.ui.configuration.json.JsonColor;
import io.scanbot.sdk.ui.configuration.json.JsonImageFilterType;
import io.scanbot.sdk.ui.configuration.json.JsonOrientationLockMode;
import io.scanbot.sdk.ui.configuration.json.JsonSize;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.camera.configuration.FinderDocumentScannerAccessibilityConfiguration;
import io.scanbot.sdk.ui.view.camera.configuration.FinderDocumentScannerConfigurationParams;
import io.scanbot.sdk.ui.view.camera.configuration.json.FinderDocumentJsonExtensionsKt;
import io.scanbot.sdk.ui.view.camera.configuration.json.FinderDocumentScannerJsonConfiguration;
import io.scanbot.sdk.ui.view.camera.configuration.json.ImageFilterTypeExtensionsKt;
import io.scanbot.sdk.ui.view.camera.configuration.json.JsonFinderDocumentScannerAccessibilityConfiguration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b7\u0018\u0000 \u008a\u00012\u00020\u0001:\u0002\u008a\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\n2\b\b\u0001\u0010\u0019\u001a\u00020\fJ\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\n2\b\b\u0001\u0010\u001e\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u001cJ\u000e\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\n2\b\b\u0001\u0010%\u001a\u00020\fJ\u000e\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\n2\b\b\u0001\u0010*\u001a\u00020\fJ\u000e\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u0005J\u000e\u00100\u001a\u00020\n2\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\fJ\u000e\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\u001cJ\u000e\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020\u0005J\u000e\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u0005J\u000e\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010@\u001a\u00020\n2\b\b\u0001\u0010A\u001a\u00020\fJ\u000e\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020\fJ\u000e\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020\u001cJ\u000e\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020\u001cJ\u000e\u0010H\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010I\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010J\u001a\u00020\n2\u0006\u0010K\u001a\u00020\u001cJ\u000e\u0010L\u001a\u00020\n2\u0006\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u00020\n2\u0006\u0010P\u001a\u00020#J\u000e\u0010Q\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010R\u001a\u00020\n2\u0006\u0010S\u001a\u00020TJ\u0010\u0010U\u001a\u00020\n2\b\b\u0001\u0010V\u001a\u00020\fJ\u0010\u0010W\u001a\u00020\n2\b\b\u0001\u0010X\u001a\u00020\fJ\u0010\u0010Y\u001a\u00020\n2\b\b\u0001\u0010Z\u001a\u00020\fJ\u0010\u0010[\u001a\u00020\n2\b\b\u0001\u0010\\\u001a\u00020\fJ\u0010\u0010]\u001a\u00020\n2\b\b\u0001\u0010^\u001a\u00020\fJ\u000e\u0010_\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010`\u001a\u00020\n2\b\b\u0001\u0010a\u001a\u00020\fJ\u0010\u0010b\u001a\u00020\n2\b\b\u0001\u0010c\u001a\u00020\fJ\u0010\u0010d\u001a\u00020\n2\b\b\u0001\u0010e\u001a\u00020\fJ\u000e\u0010f\u001a\u00020\n2\u0006\u0010g\u001a\u00020\u001cJ\u0010\u0010h\u001a\u00020\n2\b\b\u0001\u0010i\u001a\u00020\fJ\u0010\u0010j\u001a\u00020\n2\b\b\u0001\u0010k\u001a\u00020\fJ\u000e\u0010l\u001a\u00020\n2\u0006\u0010m\u001a\u00020\u001cJ\u000e\u0010n\u001a\u00020\n2\u0006\u0010o\u001a\u00020\u0005J\u000e\u0010p\u001a\u00020\n2\u0006\u0010q\u001a\u00020\u0005J\u000e\u0010r\u001a\u00020\n2\u0006\u0010s\u001a\u00020\u0005J\u000e\u0010t\u001a\u00020\n2\u0006\u0010u\u001a\u00020\u0005J\u000e\u0010v\u001a\u00020\n2\u0006\u0010w\u001a\u00020\u0005J\u000e\u0010x\u001a\u00020\n2\u0006\u0010y\u001a\u00020\u0005J\u000e\u0010z\u001a\u00020\n2\u0006\u0010{\u001a\u00020\u0005J\u000e\u0010|\u001a\u00020\n2\u0006\u0010}\u001a\u00020\u0005J\u0010\u0010~\u001a\u00020\n2\b\b\u0001\u0010\u007f\u001a\u00020\fJ\u0012\u0010\u0080\u0001\u001a\u00020\n2\t\b\u0001\u0010\u0081\u0001\u001a\u00020\fJ\u0012\u0010\u0082\u0001\u001a\u00020\n2\t\b\u0001\u0010\u0083\u0001\u001a\u00020\fJ\u0010\u0010\u0084\u0001\u001a\u00020\n2\u0007\u0010\u0085\u0001\u001a\u00020\u001cJ\u0012\u0010\u0086\u0001\u001a\u00020\n2\t\b\u0001\u0010\u0087\u0001\u001a\u00020\fJ\u0012\u0010\u0088\u0001\u001a\u00020\n2\t\b\u0001\u0010\u0089\u0001\u001a\u00020\fR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u008b\u0001"}, d2={"Lio/scanbot/sdk/ui/view/camera/configuration/FinderDocumentScannerConfiguration;", "", "()V", "cameraConfiguration", "", "", "Ljava/io/Serializable;", "getCameraConfiguration", "()Ljava/util/Map;", "enableHardwareSnapButton", "", "key", "", "modifyFromJsonConfiguration", "jsonConfig", "Lio/scanbot/sdk/ui/view/camera/configuration/json/FinderDocumentScannerJsonConfiguration;", "setAcceptedAngleScore", "acceptedAngleScore", "", "setAcceptedSizeScore", "acceptedSizeScore", "setAccessibilityConfiguration", "accessibilityConfiguration", "Lio/scanbot/sdk/ui/view/camera/configuration/FinderDocumentScannerAccessibilityConfiguration;", "setAutoSnapProgressColor", "polygonAutoSnapProgressColor", "setAutoSnapProgressEnabled", "enabled", "", "setAutoSnapProgressLineWidth", "polygonProgressLineWidth", "setAutoSnappingEnabled", "autoSnappingEnabled", "setAutoSnappingSensitivity", "autoSnappingSensitivity", "", "setCameraBackgroundColor", "cameraBackgroundColor", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraOverlayColor", "cameraOverlayColor", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setCancelButtonTitle", "cancelButtonTitle", "setDelayAfterFocusCompleteMs", "delay", "", "setDocumentImageSizeLimit", "documentImageHeightLimit", "documentImageWidthLimit", "setDrawPolygonShadows", "drawPolygonShadows", "setEnableCameraButtonTitle", "enableCameraButtonTitle", "setEnableCameraExplanationText", "enableCameraExplanationText", "setFinderAspectRatio", "finderAspectRatio", "Lio/scanbot/sdk/AspectRatio;", "setFinderEnabled", "setFinderLineColor", "finderLineColor", "setFinderLineWidth", "finderLineWidth", "setFlashButtonHidden", "flashButtonHidden", "setFlashEnabled", "flashEnabled", "setForceMaxSnappingSize", "setForceUserGuidance", "setIgnoreBadAspectRatio", "ignoreBadAspectRatio", "setImageFilterType", "imageFilterType", "Lio/scanbot/sdk/process/ImageFilterType;", "setImageScale", "imageScale", "setLockDocumentAspectRatioToFinder", "setOrientationLockMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setPolygonBackgroundColor", "polygonBackgroundColor", "setPolygonBackgroundColorOK", "polygonBackgroundColorOK", "setPolygonColor", "polygonColor", "setPolygonColorOK", "polygonColorOK", "setPolygonCornerRadius", "polygonCornerRadius", "setPolygonEnabled", "setPolygonLineWidth", "polygonLineWidth", "setShutterButtonAutoInnerColor", "shutterButtonAutoInnerColor", "setShutterButtonAutoOuterColor", "shutterButtonAutoOuterColor", "setShutterButtonHidden", "shutterButtonHidden", "setShutterButtonManualInnerColor", "shutterButtonManualInnerColor", "setShutterButtonManualOuterColor", "shutterButtonManualOuterColor", "setShutterSoundEnabled", "shutterSoundEnabled", "setTextHintBadAngles", "textBadAngles", "setTextHintBadAspectRatio", "textHintBadAspectRatio", "setTextHintNothingDetected", "textHintNothingDetected", "setTextHintOK", "textHintDontMove", "setTextHintOffCenter", "textHintOffCenter", "setTextHintTooDark", "textHintTooDark", "setTextHintTooNoisy", "textHintTooNoisy", "setTextHintTooSmall", "textHintTooSmall", "setTopBarBackgroundColor", "topBarBackgroundColor", "setTopBarButtonsActiveColor", "topBarButtonsActiveColor", "setTopBarButtonsInactiveColor", "topBarButtonsInactiveColor", "setUseButtonsAllCaps", "allCaps", "setUserGuidanceBackgroundColor", "userGuidanceBackgroundColor", "setUserGuidanceTextColor", "userGuidanceTextColor", "Companion", "rtu-ui-docdetector_release"})
public final class FinderDocumentScannerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Serializable> cameraConfiguration = new HashMap();

    @NotNull
    public final Map<String, Serializable> getCameraConfiguration() {
        return this.cameraConfiguration;
    }

    public final void setImageFilterType(@NotNull ImageFilterType imageFilterType) {
        Intrinsics.checkNotNullParameter((Object)imageFilterType, (String)"imageFilterType");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.IMAGE_FILTER_TYPE.getKey(), (Serializable)imageFilterType);
    }

    public final void setDelayAfterFocusCompleteMs(long delay) {
        Long l = delay;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.DELAY_AFTER_FOCUS_COMPLETE_MS.getKey(), l);
    }

    public final void setAutoSnappingEnabled(boolean autoSnappingEnabled) {
        Boolean bl = autoSnappingEnabled;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.AUTO_SNAPPING_ENABLED.getKey(), bl);
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        Boolean bl = flashEnabled;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.FLASH_ENABLED.getKey(), bl);
    }

    public final void setFinderAspectRatio(@NotNull AspectRatio finderAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)finderAspectRatio, (String)"finderAspectRatio");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.FINDER_ASPECT_RATIO.getKey(), (Serializable)finderAspectRatio);
    }

    public final void setFinderLineWidth(int finderLineWidth) {
        Integer n = finderLineWidth;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.FINDER_LINE_WIDTH.getKey(), n);
    }

    public final void setFinderLineColor(@ColorInt int finderLineColor) {
        Integer n = finderLineColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.FINDER_LINE_COLOR.getKey(), n);
    }

    public final void setCameraOverlayColor(@ColorInt int cameraOverlayColor) {
        Integer n = cameraOverlayColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.CAMERA_OVERLAY_COLOR.getKey(), n);
    }

    public final void setAutoSnappingSensitivity(float autoSnappingSensitivity) {
        Float f = Float.valueOf(autoSnappingSensitivity);
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.AUTO_SNAPPING_SENSITIVITY.getKey(), f);
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.CAMERA_PREVIEW_MODE.getKey(), (Serializable)cameraPreviewMode);
    }

    public final void setOrientationLockMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.ORIENTATION_LOCK_MODE.getKey(), (Serializable)cameraOrientationMode);
    }

    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.CAMERA_MODULE.getKey(), (Serializable)cameraModule);
    }

    public final void enableHardwareSnapButton(int key) {
        Integer n = key;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.HARDWARE_SNAP_BUTTON.getKey(), n);
    }

    public static /* synthetic */ void enableHardwareSnapButton$default(FinderDocumentScannerConfiguration finderDocumentScannerConfiguration, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 25;
        }
        finderDocumentScannerConfiguration.enableHardwareSnapButton(n);
    }

    public final void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        Boolean bl = ignoreBadAspectRatio;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.IGNORE_BAD_ASPECT_RATIO.getKey(), bl);
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        Double d = acceptedAngleScore;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.ACCEPTED_ANGLE_SCORE.getKey(), d);
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        Double d = acceptedSizeScore;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.ACCEPTED_SIZE_SCORE.getKey(), d);
    }

    public final void setImageScale(float imageScale) {
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.IMAGE_SCALE.getKey(), Float.valueOf(Math.min(Math.max(0.0f, imageScale), 1.0f)));
    }

    public final void setDocumentImageSizeLimit(int documentImageHeightLimit, int documentImageWidthLimit) {
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.DOCUMENT_IMAGE_SIZE_LIMIT.getKey(), (Serializable)new PageStorageProcessor.Configuration.Size(documentImageWidthLimit, documentImageHeightLimit));
    }

    public final void setPolygonColor(@ColorInt int polygonColor) {
        Integer n = polygonColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.POLYGON_COLOR.getKey(), n);
    }

    public final void setPolygonColorOK(@ColorInt int polygonColorOK) {
        Integer n = polygonColorOK;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.POLYGON_COLOR_OK.getKey(), n);
    }

    public final void setPolygonLineWidth(@Px int polygonLineWidth) {
        Integer n = polygonLineWidth;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.POLYGON_LINE_WIDTH.getKey(), n);
    }

    public final void setAutoSnapProgressColor(@ColorInt int polygonAutoSnapProgressColor) {
        Integer n = polygonAutoSnapProgressColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.PROGRESS_COLOR.getKey(), n);
    }

    public final void setAutoSnapProgressLineWidth(@Px int polygonProgressLineWidth) {
        Integer n = polygonProgressLineWidth;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.PROGRESS_LINE_WIDTH.getKey(), n);
    }

    public final void setAutoSnapProgressEnabled(boolean enabled) {
        Boolean bl = enabled;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.PROGRESS_ENABLED.getKey(), bl);
    }

    public final void setPolygonCornerRadius(@Px int polygonCornerRadius) {
        Integer n = polygonCornerRadius;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.POLYGON_CORNER_RADIUS.getKey(), n);
    }

    public final void setPolygonBackgroundColor(@ColorInt int polygonBackgroundColor) {
        Integer n = polygonBackgroundColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.POLYGON_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setPolygonBackgroundColorOK(@ColorInt int polygonBackgroundColorOK) {
        Integer n = polygonBackgroundColorOK;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.POLYGON_BACKGROUND_COLOR_OK.getKey(), n);
    }

    public final void setDrawPolygonShadows(boolean drawPolygonShadows) {
        Boolean bl = drawPolygonShadows;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.POLYGON_DRAW_SHADOWS.getKey(), bl);
    }

    public final void setShutterButtonAutoOuterColor(@ColorInt int shutterButtonAutoOuterColor) {
        Integer n = shutterButtonAutoOuterColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.SHUTTER_BUTTON_AUTO_OUTER_COLOR.getKey(), n);
    }

    public final void setShutterButtonAutoInnerColor(@ColorInt int shutterButtonAutoInnerColor) {
        Integer n = shutterButtonAutoInnerColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.SHUTTER_BUTTON_AUTO_INNER_COLOR.getKey(), n);
    }

    public final void setShutterButtonManualOuterColor(@ColorInt int shutterButtonManualOuterColor) {
        Integer n = shutterButtonManualOuterColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_OUTER_COLOR.getKey(), n);
    }

    public final void setShutterButtonManualInnerColor(@ColorInt int shutterButtonManualInnerColor) {
        Integer n = shutterButtonManualInnerColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_INNER_COLOR.getKey(), n);
    }

    public final void setShutterSoundEnabled(boolean shutterSoundEnabled) {
        Boolean bl = shutterSoundEnabled;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.SHUTTER_SOUND_ENABLED.getKey(), bl);
    }

    public final void setUserGuidanceBackgroundColor(@ColorInt int userGuidanceBackgroundColor) {
        Integer n = userGuidanceBackgroundColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.USER_GUIDANCE_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setUserGuidanceTextColor(@ColorInt int userGuidanceTextColor) {
        Integer n = userGuidanceTextColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.USER_GUIDANCE_TEXT_COLOR.getKey(), n);
    }

    public final void setTopBarBackgroundColor(@ColorInt int topBarBackgroundColor) {
        Integer n = topBarBackgroundColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.TOP_BAR_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsActiveColor(@ColorInt int topBarButtonsActiveColor) {
        Integer n = topBarButtonsActiveColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.TOP_BAR_BUTTONS_ACTIVE_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsInactiveColor(@ColorInt int topBarButtonsInactiveColor) {
        Integer n = topBarButtonsInactiveColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.TOP_BAR_BUTTONS_INACTIVE_COLOR.getKey(), n);
    }

    public final void setCameraBackgroundColor(@ColorInt int cameraBackgroundColor) {
        Integer n = cameraBackgroundColor;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.CAMERA_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setFlashButtonHidden(boolean flashButtonHidden) {
        Boolean bl = flashButtonHidden;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.FLASH_BUTTON_HIDDEN.getKey(), bl);
    }

    public final void setShutterButtonHidden(boolean shutterButtonHidden) {
        Boolean bl = shutterButtonHidden;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.SHUTTER_BUTTON_HIDDEN.getKey(), bl);
    }

    public final void setCancelButtonTitle(@NotNull String cancelButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)cancelButtonTitle, (String)"cancelButtonTitle");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.CANCEL_BUTTON_TITLE.getKey(), (Serializable)((Object)cancelButtonTitle));
    }

    public final void setTextHintOK(@NotNull String textHintDontMove) {
        Intrinsics.checkNotNullParameter((Object)textHintDontMove, (String)"textHintDontMove");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.TEXT_HINT_OK.getKey(), (Serializable)((Object)textHintDontMove));
    }

    public final void setTextHintTooSmall(@NotNull String textHintTooSmall) {
        Intrinsics.checkNotNullParameter((Object)textHintTooSmall, (String)"textHintTooSmall");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.TEXT_HINT_TOO_SMALL.getKey(), (Serializable)((Object)textHintTooSmall));
    }

    public final void setTextHintBadAngles(@NotNull String textBadAngles) {
        Intrinsics.checkNotNullParameter((Object)textBadAngles, (String)"textBadAngles");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.TEXT_HINT_BAD_ANGLES.getKey(), (Serializable)((Object)textBadAngles));
    }

    public final void setTextHintBadAspectRatio(@NotNull String textHintBadAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)textHintBadAspectRatio, (String)"textHintBadAspectRatio");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.TEXT_HINT_BAD_ASPECT_RATIO.getKey(), (Serializable)((Object)textHintBadAspectRatio));
    }

    public final void setTextHintNothingDetected(@NotNull String textHintNothingDetected) {
        Intrinsics.checkNotNullParameter((Object)textHintNothingDetected, (String)"textHintNothingDetected");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.TEXT_HINT_NOTHING_DETECTED.getKey(), (Serializable)((Object)textHintNothingDetected));
    }

    public final void setTextHintTooNoisy(@NotNull String textHintTooNoisy) {
        Intrinsics.checkNotNullParameter((Object)textHintTooNoisy, (String)"textHintTooNoisy");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.TEXT_HINT_TOO_NOISY.getKey(), (Serializable)((Object)textHintTooNoisy));
    }

    public final void setTextHintOffCenter(@NotNull String textHintOffCenter) {
        Intrinsics.checkNotNullParameter((Object)textHintOffCenter, (String)"textHintOffCenter");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.TEXT_HINT_OFF_CENTER.getKey(), (Serializable)((Object)textHintOffCenter));
    }

    public final void setTextHintTooDark(@NotNull String textHintTooDark) {
        Intrinsics.checkNotNullParameter((Object)textHintTooDark, (String)"textHintTooDark");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.TEXT_HINT_TOO_DARK.getKey(), (Serializable)((Object)textHintTooDark));
    }

    public final void setEnableCameraExplanationText(@NotNull String enableCameraExplanationText) {
        Intrinsics.checkNotNullParameter((Object)enableCameraExplanationText, (String)"enableCameraExplanationText");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.ENABLE_CAMERA_EXPLANATION_TEXT.getKey(), (Serializable)((Object)enableCameraExplanationText));
    }

    public final void setEnableCameraButtonTitle(@NotNull String enableCameraButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)enableCameraButtonTitle, (String)"enableCameraButtonTitle");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.ENABLE_CAMERA_BUTTON_TITLE.getKey(), (Serializable)((Object)enableCameraButtonTitle));
    }

    public final void setUseButtonsAllCaps(boolean allCaps) {
        Boolean bl = allCaps;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.USE_BUTTONS_ALL_CAPS.getKey(), bl);
    }

    public final void setAccessibilityConfiguration(@NotNull FinderDocumentScannerAccessibilityConfiguration accessibilityConfiguration) {
        Intrinsics.checkNotNullParameter((Object)accessibilityConfiguration, (String)"accessibilityConfiguration");
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.ACCESSIBILITY_CONFIGURATION.getKey(), accessibilityConfiguration);
    }

    public final void setForceMaxSnappingSize(boolean enabled) {
        Boolean bl = enabled;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.FORCE_MAX_SNAPPING_SIZE.getKey(), bl);
    }

    public final void setForceUserGuidance(boolean enabled) {
        Boolean bl = enabled;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.FORCE_USER_GUIDANCE.getKey(), bl);
    }

    public final void setPolygonEnabled(boolean enabled) {
        Boolean bl = enabled;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.POLYGON_ENABLED.getKey(), bl);
    }

    public final void setFinderEnabled(boolean enabled) {
        Boolean bl = enabled;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.FINDER_ENABLED.getKey(), bl);
    }

    public final void setLockDocumentAspectRatioToFinder(boolean enabled) {
        Boolean bl = enabled;
        this.cameraConfiguration.put(FinderDocumentScannerConfigurationParams.LOCK_DOCUMENT_ASPECT_RATIO.getKey(), bl);
    }

    public final void modifyFromJsonConfiguration(@NotNull FinderDocumentScannerJsonConfiguration jsonConfig) {
        block55: {
            double it;
            Intrinsics.checkNotNullParameter((Object)jsonConfig, (String)"jsonConfig");
            Double d = jsonConfig.getAcceptedAngleScore();
            if (d != null) {
                it = ((Number)d).doubleValue();
                boolean bl = false;
                this.setAcceptedAngleScore(it);
            }
            Double d2 = jsonConfig.getAcceptedSizeScore();
            if (d2 != null) {
                it = ((Number)d2).doubleValue();
                boolean bl = false;
                this.setAcceptedSizeScore(it);
            }
            JsonFinderDocumentScannerAccessibilityConfiguration jsonFinderDocumentScannerAccessibilityConfiguration = jsonConfig.getAccessibilityConfiguration();
            if (jsonFinderDocumentScannerAccessibilityConfiguration != null) {
                JsonFinderDocumentScannerAccessibilityConfiguration it2 = jsonFinderDocumentScannerAccessibilityConfiguration;
                boolean bl = false;
                this.setAccessibilityConfiguration(FinderDocumentJsonExtensionsKt.toSdk(it2));
            }
            Boolean bl = jsonConfig.getAutoSnappingEnabled();
            if (bl != null) {
                boolean it3 = bl;
                boolean bl2 = false;
                this.setAutoSnappingEnabled(it3);
            }
            Double d3 = jsonConfig.getAutoSnappingSensitivity();
            if (d3 != null) {
                double it4 = ((Number)d3).doubleValue();
                boolean bl3 = false;
                this.setAutoSnappingSensitivity((float)it4);
            }
            JsonColor jsonColor = jsonConfig.getCameraBackgroundColor();
            if (jsonColor != null) {
                JsonColor it5 = jsonColor;
                boolean bl4 = false;
                this.setCameraBackgroundColor(it5.toSdk());
            }
            JsonCameraModule jsonCameraModule = jsonConfig.getCameraModule();
            if (jsonCameraModule != null) {
                JsonCameraModule it6 = jsonCameraModule;
                boolean bl5 = false;
                this.setCameraModule(CommonExtensionsKt.toSdk((JsonCameraModule)it6));
            }
            JsonCameraPreviewMode jsonCameraPreviewMode = jsonConfig.getCameraPreviewMode();
            if (jsonCameraPreviewMode != null) {
                JsonCameraPreviewMode it7 = jsonCameraPreviewMode;
                boolean bl6 = false;
                this.setCameraPreviewMode(CommonExtensionsKt.toSdk((JsonCameraPreviewMode)it7));
            }
            String string = jsonConfig.getCancelButtonTitle();
            if (string != null) {
                String it8 = string;
                boolean bl7 = false;
                this.setCancelButtonTitle(it8);
            }
            JsonSize jsonSize = jsonConfig.getDocumentImageSizeLimit();
            if (jsonSize != null) {
                JsonSize it9 = jsonSize;
                boolean bl8 = false;
                this.setDocumentImageSizeLimit((int)it9.getWidth(), (int)it9.getHeight());
            }
            String string2 = jsonConfig.getEnableCameraButtonTitle();
            if (string2 != null) {
                String it10 = string2;
                boolean bl9 = false;
                this.setEnableCameraButtonTitle(it10);
            }
            String string3 = jsonConfig.getEnableCameraExplanationText();
            if (string3 != null) {
                String it11 = string3;
                boolean bl10 = false;
                this.setEnableCameraExplanationText(it11);
            }
            Boolean bl11 = jsonConfig.getFlashButtonHidden();
            if (bl11 != null) {
                boolean it12 = bl11;
                boolean bl12 = false;
                this.setFlashButtonHidden(it12);
            }
            Boolean bl13 = jsonConfig.getFlashEnabled();
            if (bl13 != null) {
                boolean it13 = bl13;
                boolean bl14 = false;
                this.setFlashEnabled(it13);
            }
            JsonAspectRatio jsonAspectRatio = jsonConfig.getFinderAspectRatio();
            if (jsonAspectRatio != null) {
                JsonAspectRatio it14 = jsonAspectRatio;
                boolean bl15 = false;
                this.setFinderAspectRatio(CommonExtensionsKt.toSdk((JsonAspectRatio)it14));
            }
            JsonColor jsonColor2 = jsonConfig.getFinderLineColor();
            if (jsonColor2 != null) {
                JsonColor it15 = jsonColor2;
                boolean bl16 = false;
                this.setFinderLineColor(it15.toSdk());
            }
            Double d4 = jsonConfig.getFinderLineWidth();
            if (d4 != null) {
                double it16 = ((Number)d4).doubleValue();
                boolean bl17 = false;
                this.setFinderLineWidth((int)it16);
            }
            JsonColor jsonColor3 = jsonConfig.getCameraOverlayColor();
            if (jsonColor3 != null) {
                JsonColor it17 = jsonColor3;
                boolean bl18 = false;
                this.setCameraOverlayColor(it17.toSdk());
            }
            Boolean bl19 = jsonConfig.getIgnoreBadAspectRatio();
            if (bl19 != null) {
                boolean it18 = bl19;
                boolean bl20 = false;
                this.setIgnoreBadAspectRatio(it18);
            }
            Double d5 = jsonConfig.getImageScale();
            if (d5 != null) {
                double it19 = ((Number)d5).doubleValue();
                boolean bl21 = false;
                this.setImageScale((float)it19);
            }
            JsonOrientationLockMode jsonOrientationLockMode = jsonConfig.getOrientationLockMode();
            if (jsonOrientationLockMode != null) {
                JsonOrientationLockMode it20 = jsonOrientationLockMode;
                boolean bl22 = false;
                CameraOrientationMode cameraOrientationMode = CommonExtensionsKt.toSdk((JsonOrientationLockMode)it20);
                if (cameraOrientationMode != null) {
                    CameraOrientationMode lockMode = cameraOrientationMode;
                    boolean bl23 = false;
                    this.setOrientationLockMode(lockMode);
                }
            }
            JsonColor jsonColor4 = jsonConfig.getShutterButtonAutoInnerColor();
            if (jsonColor4 != null) {
                JsonColor it21 = jsonColor4;
                boolean bl24 = false;
                this.setShutterButtonAutoInnerColor(it21.toSdk());
            }
            JsonColor jsonColor5 = jsonConfig.getShutterButtonAutoOuterColor();
            if (jsonColor5 != null) {
                JsonColor it22 = jsonColor5;
                boolean bl25 = false;
                this.setShutterButtonAutoOuterColor(it22.toSdk());
            }
            Boolean bl26 = jsonConfig.getShutterButtonHidden();
            if (bl26 != null) {
                boolean it23 = bl26;
                boolean bl27 = false;
                this.setShutterButtonHidden(it23);
            }
            JsonColor jsonColor6 = jsonConfig.getShutterButtonManualInnerColor();
            if (jsonColor6 != null) {
                JsonColor it24 = jsonColor6;
                boolean bl28 = false;
                this.setShutterButtonManualInnerColor(it24.toSdk());
            }
            JsonColor jsonColor7 = jsonConfig.getShutterButtonManualOuterColor();
            if (jsonColor7 != null) {
                JsonColor it25 = jsonColor7;
                boolean bl29 = false;
                this.setShutterButtonManualOuterColor(it25.toSdk());
            }
            String string4 = jsonConfig.getTextHintBadAngles();
            if (string4 != null) {
                String it26 = string4;
                boolean bl30 = false;
                this.setTextHintBadAngles(it26);
            }
            String string5 = jsonConfig.getTextHintBadAspectRatio();
            if (string5 != null) {
                String it27 = string5;
                boolean bl31 = false;
                this.setTextHintBadAspectRatio(it27);
            }
            String string6 = jsonConfig.getTextHintNothingDetected();
            if (string6 != null) {
                String it28 = string6;
                boolean bl32 = false;
                this.setTextHintNothingDetected(it28);
            }
            String string7 = jsonConfig.getTextHintOK();
            if (string7 != null) {
                String it29 = string7;
                boolean bl33 = false;
                this.setTextHintOK(it29);
            }
            String string8 = jsonConfig.getTextHintTooDark();
            if (string8 != null) {
                String it30 = string8;
                boolean bl34 = false;
                this.setTextHintTooDark(it30);
            }
            String string9 = jsonConfig.getTextHintTooNoisy();
            if (string9 != null) {
                String it31 = string9;
                boolean bl35 = false;
                this.setTextHintTooNoisy(it31);
            }
            String string10 = jsonConfig.getTextHintOffCenter();
            if (string10 != null) {
                String it32 = string10;
                boolean bl36 = false;
                this.setTextHintOffCenter(it32);
            }
            String string11 = jsonConfig.getTextHintTooSmall();
            if (string11 != null) {
                String it33 = string11;
                boolean bl37 = false;
                this.setTextHintTooSmall(it33);
            }
            JsonColor jsonColor8 = jsonConfig.getTopBarBackgroundColor();
            if (jsonColor8 != null) {
                JsonColor it34 = jsonColor8;
                boolean bl38 = false;
                this.setTopBarBackgroundColor(it34.toSdk());
            }
            JsonColor jsonColor9 = jsonConfig.getTopBarButtonsActiveColor();
            if (jsonColor9 != null) {
                JsonColor it35 = jsonColor9;
                boolean bl39 = false;
                this.setTopBarButtonsActiveColor(it35.toSdk());
            }
            JsonColor jsonColor10 = jsonConfig.getTopBarButtonsInactiveColor();
            if (jsonColor10 != null) {
                JsonColor it36 = jsonColor10;
                boolean bl40 = false;
                this.setTopBarButtonsInactiveColor(it36.toSdk());
            }
            Boolean bl41 = jsonConfig.getUseButtonsAllCaps();
            if (bl41 != null) {
                boolean it37 = bl41;
                boolean bl42 = false;
                this.setUseButtonsAllCaps(it37);
            }
            JsonColor jsonColor11 = jsonConfig.getUserGuidanceBackgroundColor();
            if (jsonColor11 != null) {
                JsonColor it38 = jsonColor11;
                boolean bl43 = false;
                this.setUserGuidanceBackgroundColor(it38.toSdk());
            }
            JsonColor jsonColor12 = jsonConfig.getUserGuidanceTextColor();
            if (jsonColor12 != null) {
                JsonColor it39 = jsonColor12;
                boolean bl44 = false;
                this.setUserGuidanceTextColor(it39.toSdk());
            }
            Boolean bl45 = jsonConfig.getForceUserGuidance();
            if (bl45 != null) {
                boolean it40 = bl45;
                boolean bl46 = false;
                this.setForceUserGuidance(it40);
            }
            Boolean bl47 = jsonConfig.getFinderEnabled();
            if (bl47 != null) {
                boolean it41 = bl47;
                boolean bl48 = false;
                this.setFinderEnabled(it41);
            }
            Boolean bl49 = jsonConfig.getPolygonEnabled();
            if (bl49 != null) {
                boolean it42 = bl49;
                boolean bl50 = false;
                this.setPolygonEnabled(it42);
            }
            JsonColor jsonColor13 = jsonConfig.getAutoSnapProgressColor();
            if (jsonColor13 != null) {
                JsonColor it43 = jsonColor13;
                boolean bl51 = false;
                this.setAutoSnapProgressColor(it43.toSdk());
            }
            Boolean bl52 = jsonConfig.getAutoSnapProgressEnabled();
            if (bl52 != null) {
                boolean it44 = bl52;
                boolean bl53 = false;
                this.setAutoSnapProgressEnabled(it44);
            }
            Double d6 = jsonConfig.getAutoSnapProgressLineWidth();
            if (d6 != null) {
                double it45 = ((Number)d6).doubleValue();
                boolean bl54 = false;
                this.setAutoSnapProgressLineWidth((int)it45);
            }
            JsonColor jsonColor14 = jsonConfig.getPolygonBackgroundColor();
            if (jsonColor14 != null) {
                JsonColor it46 = jsonColor14;
                boolean bl55 = false;
                this.setPolygonBackgroundColor(it46.toSdk());
            }
            JsonColor jsonColor15 = jsonConfig.getPolygonBackgroundColorOK();
            if (jsonColor15 != null) {
                JsonColor it47 = jsonColor15;
                boolean bl56 = false;
                this.setPolygonBackgroundColorOK(it47.toSdk());
            }
            JsonColor jsonColor16 = jsonConfig.getPolygonColor();
            if (jsonColor16 != null) {
                JsonColor it48 = jsonColor16;
                boolean bl57 = false;
                this.setPolygonColor(it48.toSdk());
            }
            JsonColor jsonColor17 = jsonConfig.getPolygonColorOK();
            if (jsonColor17 != null) {
                JsonColor it49 = jsonColor17;
                boolean bl58 = false;
                this.setPolygonColorOK(it49.toSdk());
            }
            Double d7 = jsonConfig.getPolygonCornerRadius();
            if (d7 != null) {
                double it50 = ((Number)d7).doubleValue();
                boolean bl59 = false;
                this.setPolygonCornerRadius((int)it50);
            }
            Double d8 = jsonConfig.getPolygonLineWidth();
            if (d8 != null) {
                double it51 = ((Number)d8).doubleValue();
                boolean bl60 = false;
                this.setPolygonLineWidth((int)it51);
            }
            Boolean bl61 = jsonConfig.getLockDocumentAspectRatioToFinder();
            if (bl61 != null) {
                boolean it52 = bl61;
                boolean bl62 = false;
                this.setLockDocumentAspectRatioToFinder(it52);
            }
            Boolean bl63 = jsonConfig.getForceUserGuidance();
            if (bl63 != null) {
                boolean it53 = bl63;
                boolean bl64 = false;
                this.setForceUserGuidance(it53);
            }
            JsonImageFilterType jsonImageFilterType = jsonConfig.getDefaultPageFilter();
            if (jsonImageFilterType == null) break block55;
            JsonImageFilterType it54 = jsonImageFilterType;
            boolean bl65 = false;
            this.setImageFilterType(ImageFilterTypeExtensionsKt.toSdk(it54));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/camera/configuration/FinderDocumentScannerConfiguration$Companion;", "", "()V", "fromJson", "Lio/scanbot/sdk/ui/view/camera/configuration/FinderDocumentScannerConfiguration;", "input", "", "rtu-ui-docdetector_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FinderDocumentScannerConfiguration fromJson(@NotNull String input) {
            FinderDocumentScannerConfiguration finderDocumentScannerConfiguration;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Gson gson = GsonHelper.INSTANCE.prepareGson();
            FinderDocumentScannerJsonConfiguration jsonConfig = (FinderDocumentScannerJsonConfiguration)gson.fromJson(input, FinderDocumentScannerJsonConfiguration.class);
            FinderDocumentScannerConfiguration $this$fromJson_u24lambda_u2d0 = finderDocumentScannerConfiguration = new FinderDocumentScannerConfiguration();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)jsonConfig, (String)"jsonConfig");
            $this$fromJson_u24lambda_u2d0.modifyFromJsonConfiguration(jsonConfig);
            return finderDocumentScannerConfiguration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

