/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.camera.configuration;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import io.scanbot.sdk.AspectRatio;
import io.scanbot.sdk.docdetection.ui.DocumentScannerView;
import io.scanbot.sdk.docdetection.ui.IDocumentFinderViewController;
import io.scanbot.sdk.docdetection.ui.IDocumentScannerPolygonViewController;
import io.scanbot.sdk.docdetection.ui.IDocumentScannerViewCameraConfiguration;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.ui.camera.ShutterButton;
import io.scanbot.sdk.ui.configuration.json.CommonExtensionsKt;
import io.scanbot.sdk.ui.configuration.json.JsonAspectRatio;
import io.scanbot.sdk.ui.configuration.json.JsonCameraModule;
import io.scanbot.sdk.ui.configuration.json.JsonCameraPreviewMode;
import io.scanbot.sdk.ui.configuration.json.JsonCapturePhotoQualityPrioritization;
import io.scanbot.sdk.ui.configuration.json.JsonOrientationLockMode;
import io.scanbot.sdk.ui.configuration.json.JsonSize;
import io.scanbot.sdk.ui.docdetector.R;
import io.scanbot.sdk.ui.docdetector.databinding.ScanbotSdkActivityFinderCameraBinding;
import io.scanbot.sdk.ui.docdetector.databinding.ScanbotSdkFinderViewBinding;
import io.scanbot.sdk.ui.utils.CheckableFrameLayout;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.camera.DocumentScannerCameraViewModel;
import io.scanbot.sdk.ui.view.camera.FinderDocumentScannerCameraView;
import io.scanbot.sdk.ui.view.camera.configuration.json.FinderDocumentScannerJsonConfiguration;
import io.scanbot.sdk.ui.view.camera.configuration.json.FinderDocumentScannerJsonConfigurationKt;
import io.scanbot.sdk.ui.view.camera.configuration.json.FinderDocumentScannerNativeConfiguration;
import io.scanbot.sdk.ui.view.camera.configuration.json.FinderDocumentScannerNativeConfigurationKt;
import io.scanbot.sdk.ui.view.camera.configuration.json.FinderDocumentScannerNativeParameter;
import io.scanbot.sdk.ui.view.camera.configuration.json.FinderDocumentScannerParameter;
import io.scanbot.sdk.ui.view.camera.configuration.json.ImageFilterTypeExtensionsKt;
import io.scanbot.sdk.ui.view.camera.configuration.json.JsonFinderDocumentScannerAccessibilityConfiguration;
import io.scanbot.sdk.ui.view.widget.CancelView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u001a\u0010\u0019\u001a\u00020\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/scanbot/sdk/ui/view/camera/configuration/FinderDocumentScannerConfigurationHelper;", "", "()V", "config", "Lio/scanbot/sdk/ui/view/camera/configuration/json/FinderDocumentScannerJsonConfiguration;", "nativeConfig", "Lio/scanbot/sdk/ui/view/camera/configuration/json/FinderDocumentScannerNativeConfiguration;", "applyConfiguration", "", "activity", "Landroid/app/Activity;", "cameraBinding", "Lio/scanbot/sdk/ui/docdetector/databinding/ScanbotSdkActivityFinderCameraBinding;", "cameraViewModel", "Lio/scanbot/sdk/ui/view/camera/DocumentScannerCameraViewModel;", "applyFinderPolygonProgressParams", "documentScannerView", "Lio/scanbot/sdk/docdetection/ui/DocumentScannerView;", "progressEnabled", "", "polygonEnabled", "prepareAccessibilityDescription", "", "label", "hint", "setConfiguration", "rtu-ui-docdetector_release"})
public final class FinderDocumentScannerConfigurationHelper {
    @Nullable
    private FinderDocumentScannerNativeConfiguration nativeConfig;
    @Nullable
    private FinderDocumentScannerJsonConfiguration config;

    public final void setConfiguration(@Nullable FinderDocumentScannerJsonConfiguration config, @Nullable FinderDocumentScannerNativeConfiguration nativeConfig) {
        this.config = config;
        this.nativeConfig = nativeConfig;
    }

    /*
     * WARNING - void declaration
     */
    public final void applyConfiguration(@NotNull Activity activity, @NotNull ScanbotSdkActivityFinderCameraBinding cameraBinding, @NotNull DocumentScannerCameraViewModel cameraViewModel2) {
        Object object;
        Object jsonParameters;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)cameraBinding, (String)"cameraBinding");
        Intrinsics.checkNotNullParameter((Object)cameraViewModel2, (String)"cameraViewModel");
        ScanbotSdkFinderViewBinding $this$applyConfiguration_u24lambda_u2d4 = cameraBinding.cameraView.getBinding();
        boolean bl = false;
        Object object2 = this.config;
        if (object2 == null || (object2 = FinderDocumentScannerJsonConfigurationKt.getIterator((FinderDocumentScannerJsonConfiguration)object2)) == null) {
            object2 = jsonParameters = CollectionsKt.emptyList();
        }
        if ((object = this.nativeConfig) == null || (object = FinderDocumentScannerNativeConfigurationKt.getIterator((FinderDocumentScannerNativeConfiguration)object)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object nativeParameters = object;
        Iterable $this$forEach$iv = (Iterable)jsonParameters;
        boolean $i$f$forEach = false;
        block65: for (Object element$iv : $this$forEach$iv) {
            FinderDocumentScannerParameter paramType = (FinderDocumentScannerParameter)((Object)element$iv);
            boolean bl2 = false;
            block0 : switch (WhenMappings.$EnumSwitchMapping$1[paramType.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Double d = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getAcceptedAngleScore() : null;
                    Intrinsics.checkNotNull((Object)d);
                    cameraViewModel2.setAcceptedAngleScore(d);
                    break;
                }
                case 4: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Double d = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getAcceptedSizeScore() : null;
                    Intrinsics.checkNotNull((Object)d);
                    cameraViewModel2.setAcceptedSizeScore(d);
                    break;
                }
                case 5: {
                    JsonFinderDocumentScannerAccessibilityConfiguration accessibilityConfiguration;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Intrinsics.checkNotNull((Object)(finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getAccessibilityConfiguration() : null));
                    accessibilityConfiguration = accessibilityConfiguration;
                    $this$applyConfiguration_u24lambda_u2d4.cancel.setContentDescription((CharSequence)this.prepareAccessibilityDescription(accessibilityConfiguration.getCancelButtonAccessibilityLabel(), accessibilityConfiguration.getCancelButtonAccessibilityHint()));
                    $this$applyConfiguration_u24lambda_u2d4.flashBtn.setContentDescription((CharSequence)this.prepareAccessibilityDescription(accessibilityConfiguration.getFlashButtonAccessibilityLabel(), accessibilityConfiguration.getFlashButtonAccessibilityHint()));
                    $this$applyConfiguration_u24lambda_u2d4.shutterBtn.setContentDescription((CharSequence)this.prepareAccessibilityDescription(accessibilityConfiguration.getShutterButtonAccessibilityLabel(), accessibilityConfiguration.getShutterButtonAccessibilityHint()));
                    break;
                }
                case 6: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object3 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getAutoSnapProgressColor() : null;
                    Intrinsics.checkNotNull((Object)object3);
                    int color2 = object3.toSdk();
                    $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getPolygonConfiguration().setPolygonAutoSnappingProgressStrokeColor(color2);
                    $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getFinderViewController().setAutoSnappingProgressStrokeColor(color2);
                    break;
                }
                case 7: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Double d = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getAutoSnapProgressLineWidth() : null;
                    Intrinsics.checkNotNull((Object)d);
                    int width = (int)d.doubleValue();
                    $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getPolygonConfiguration().setPolygonAutoSnappingProgressStrokeWidth(width);
                    $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getFinderViewController().setAutoSnappingProgressStrokeWidth(width);
                    break;
                }
                case 8: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Boolean bl3 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getAutoSnappingEnabled() : null;
                    Intrinsics.checkNotNull((Object)bl3);
                    cameraViewModel2.setAutoSnappingEnabled(bl3);
                    break;
                }
                case 9: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Double d = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getAutoSnappingSensitivity() : null;
                    Intrinsics.checkNotNull((Object)d);
                    cameraViewModel2.setAutosnappingSensitivity((float)d.doubleValue());
                    break;
                }
                case 10: {
                    Unit unit;
                    FinderDocumentScannerJsonConfiguration it;
                    View view;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object4 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getCameraBackgroundColor() : null;
                    Intrinsics.checkNotNull((Object)object4);
                    int color3 = object4.toSdk();
                    View view2 = view = $this$applyConfiguration_u24lambda_u2d4.cameraRootLayout.findViewById(R.id.camera_preview_view);
                    if (view2 != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById<View>(R.id.camera_preview_view)");
                        it = view;
                        boolean bl4 = false;
                        it.setBackgroundColor(color3);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit != null) continue block65;
                    $this$applyConfiguration_u24lambda_u2d4.cameraRootLayout.setBackgroundColor(color3);
                    break;
                }
                case 11: {
                    FinderDocumentScannerCameraView finderDocumentScannerCameraView = cameraBinding.cameraView;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object5 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getCameraModule() : null;
                    Intrinsics.checkNotNull((Object)object5);
                    finderDocumentScannerCameraView.setCameraModule(CommonExtensionsKt.toSdk((JsonCameraModule)object5));
                    break;
                }
                case 12: {
                    IDocumentFinderViewController iDocumentFinderViewController = cameraBinding.cameraView.getBinding().documentScannerView.getFinderViewController();
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object6 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getCameraOverlayColor() : null;
                    Intrinsics.checkNotNull((Object)object6);
                    iDocumentFinderViewController.setOverlayColor(object6.toSdk());
                    break;
                }
                case 13: {
                    FinderDocumentScannerCameraView finderDocumentScannerCameraView = cameraBinding.cameraView;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object7 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getCameraPreviewMode() : null;
                    Intrinsics.checkNotNull((Object)object7);
                    finderDocumentScannerCameraView.setCameraPreviewMode(CommonExtensionsKt.toSdk((JsonCameraPreviewMode)object7));
                    break;
                }
                case 14: {
                    CancelView cancelView = $this$applyConfiguration_u24lambda_u2d4.cancel;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    String string = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getCancelButtonTitle() : null;
                    Intrinsics.checkNotNull((Object)string);
                    cancelView.setText(string);
                    break;
                }
                case 15: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object8 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getDefaultPageFilter() : null;
                    Intrinsics.checkNotNull((Object)object8);
                    cameraViewModel2.setImageFilterType(ImageFilterTypeExtensionsKt.toSdk(object8));
                    break;
                }
                case 16: {
                    JsonSize param;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object9 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getDocumentImageSizeLimit() : null;
                    Intrinsics.checkNotNull((Object)object9);
                    JsonSize jsonSize = param = object9;
                    Intrinsics.checkNotNull((Object)jsonSize);
                    if (!(jsonSize.getWidth() > 0.0) || !(param.getHeight() > 0.0)) break;
                    cameraViewModel2.setDocumentImageSizeLimit(new PageStorageProcessor.Configuration.Size((int)param.getWidth(), (int)param.getHeight()));
                    break;
                }
                case 17: {
                    Button button = cameraBinding.cameraView.getPermissionBinding().enableCameraBtn;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    String string = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getEnableCameraButtonTitle() : null;
                    Intrinsics.checkNotNull((Object)string);
                    button.setText((CharSequence)string);
                    break;
                }
                case 18: {
                    TextView textView = cameraBinding.cameraView.getPermissionBinding().cameraPermissionDescription;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    String string = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getEnableCameraExplanationText() : null;
                    Intrinsics.checkNotNull((Object)string);
                    textView.setText((CharSequence)string);
                    break;
                }
                case 19: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object10 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getFinderAspectRatio() : null;
                    Intrinsics.checkNotNull((Object)object10);
                    AspectRatio aspectRatio = CommonExtensionsKt.toSdk((JsonAspectRatio)object10);
                    cameraViewModel2.setRequiredAspectRatio(CollectionsKt.listOf((Object)aspectRatio));
                    break;
                }
                case 20: {
                    FinderDocumentScannerCameraView finderDocumentScannerCameraView = cameraBinding.cameraView;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Boolean bl5 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getFinderEnabled() : null;
                    Intrinsics.checkNotNull((Object)bl5);
                    finderDocumentScannerCameraView.setFinderViewEnabled(bl5);
                    break;
                }
                case 21: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object11 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getFinderLineColor() : null;
                    Intrinsics.checkNotNull((Object)object11);
                    int color4 = object11.toSdk();
                    cameraBinding.cameraView.getBinding().documentScannerView.getFinderViewController().setStrokeColor(color4);
                    break;
                }
                case 22: {
                    void $this$dpToPx$iv;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Double d = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getFinderLineWidth() : null;
                    Intrinsics.checkNotNull((Object)d);
                    int lineVideoWidth = (int)d.doubleValue();
                    IDocumentFinderViewController iDocumentFinderViewController = cameraBinding.cameraView.getBinding().documentScannerView.getFinderViewController();
                    Intrinsics.checkNotNullExpressionValue((Object)cameraBinding.cameraView.getContext(), (String)"cameraBinding.cameraView.context");
                    int dp$iv = lineVideoWidth;
                    boolean $i$f$dpToPx = false;
                    iDocumentFinderViewController.setStrokeWidth(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)dp$iv, (DisplayMetrics)$this$dpToPx$iv.getResources().getDisplayMetrics())));
                    break;
                }
                case 23: {
                    void value$iv;
                    void $this$isVisible$iv;
                    CheckableFrameLayout checkableFrameLayout = $this$applyConfiguration_u24lambda_u2d4.flashBtn;
                    Intrinsics.checkNotNullExpressionValue((Object)checkableFrameLayout, (String)"flashBtn");
                    View lineVideoWidth = (View)checkableFrameLayout;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Boolean bl6 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getFlashButtonHidden() : null;
                    Intrinsics.checkNotNull((Object)bl6);
                    boolean $this$dpToPx$iv = bl6 == false && $this$applyConfiguration_u24lambda_u2d4.flashBtn.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.flash");
                    boolean $i$f$setVisible = false;
                    $this$isVisible$iv.setVisibility(value$iv != false ? 0 : 8);
                    break;
                }
                case 24: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Boolean bl7 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getFlashEnabled() : null;
                    Intrinsics.checkNotNull((Object)bl7);
                    cameraViewModel2.setFlashEnabled(bl7);
                    break;
                }
                case 25: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Boolean bl8 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getForceUserGuidance() : null;
                    Intrinsics.checkNotNull((Object)bl8);
                    cameraViewModel2.setForceUserGuidance(bl8);
                    break;
                }
                case 26: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Boolean bl9 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getIgnoreBadAspectRatio() : null;
                    Intrinsics.checkNotNull((Object)bl9);
                    cameraViewModel2.setIgnoreBadAspectRatio(bl9);
                    break;
                }
                case 27: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Double d = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getImageScale() : null;
                    Intrinsics.checkNotNull((Object)d);
                    cameraViewModel2.setImageScale((float)d.doubleValue());
                    break;
                }
                case 28: {
                    FinderDocumentScannerCameraView finderDocumentScannerCameraView = cameraBinding.cameraView;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Boolean bl10 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getLockDocumentAspectRatioToFinder() : null;
                    Intrinsics.checkNotNull((Object)bl10);
                    finderDocumentScannerCameraView.setLockDocumentAspectRatioToFinder(bl10);
                    break;
                }
                case 29: {
                    Unit unit;
                    FinderDocumentScannerJsonConfiguration it;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    if (finderDocumentScannerJsonConfiguration != null && (finderDocumentScannerJsonConfiguration = finderDocumentScannerJsonConfiguration.getOrientationLockMode()) != null && (finderDocumentScannerJsonConfiguration = CommonExtensionsKt.toSdk((JsonOrientationLockMode)finderDocumentScannerJsonConfiguration)) != null) {
                        it = finderDocumentScannerJsonConfiguration;
                        boolean bl11 = false;
                        cameraBinding.cameraView.setCameraOrientationMode((CameraOrientationMode)it);
                        unit = Unit.INSTANCE;
                        continue block65;
                    }
                    unit = null;
                    break;
                }
                case 30: {
                    IDocumentScannerPolygonViewController iDocumentScannerPolygonViewController = $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getPolygonConfiguration();
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object12 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getPolygonBackgroundColor() : null;
                    Intrinsics.checkNotNull((Object)object12);
                    iDocumentScannerPolygonViewController.setPolygonFillColor(object12.toSdk());
                    break;
                }
                case 31: {
                    IDocumentScannerPolygonViewController iDocumentScannerPolygonViewController = $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getPolygonConfiguration();
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object13 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getPolygonBackgroundColorOK() : null;
                    Intrinsics.checkNotNull((Object)object13);
                    iDocumentScannerPolygonViewController.setPolygonFillColorOK(object13.toSdk());
                    break;
                }
                case 32: {
                    IDocumentScannerPolygonViewController iDocumentScannerPolygonViewController = $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getPolygonConfiguration();
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object14 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getPolygonColor() : null;
                    Intrinsics.checkNotNull((Object)object14);
                    iDocumentScannerPolygonViewController.setPolygonStrokeColor(object14.toSdk());
                    break;
                }
                case 33: {
                    IDocumentScannerPolygonViewController iDocumentScannerPolygonViewController = $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getPolygonConfiguration();
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object15 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getPolygonColorOK() : null;
                    Intrinsics.checkNotNull((Object)object15);
                    iDocumentScannerPolygonViewController.setPolygonStrokeColorOK(object15.toSdk());
                    break;
                }
                case 34: {
                    IDocumentScannerPolygonViewController iDocumentScannerPolygonViewController = $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getPolygonConfiguration();
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Double d = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getPolygonCornerRadius() : null;
                    Intrinsics.checkNotNull((Object)d);
                    iDocumentScannerPolygonViewController.setPolygonCornerRadius((int)d.doubleValue());
                    break;
                }
                case 35: {
                    break;
                }
                case 36: {
                    FinderDocumentScannerCameraView finderDocumentScannerCameraView = cameraBinding.cameraView;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Boolean bl12 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getPolygonEnabled() : null;
                    Intrinsics.checkNotNull((Object)bl12);
                    finderDocumentScannerCameraView.setPolygonViewEnabled(bl12);
                    break;
                }
                case 37: {
                    void $this$dpToPx$iv;
                    IDocumentScannerPolygonViewController iDocumentScannerPolygonViewController = $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getPolygonConfiguration();
                    Intrinsics.checkNotNullExpressionValue((Object)$this$applyConfiguration_u24lambda_u2d4.documentScannerView.getContext(), (String)"documentScannerView.context");
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Double d = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getPolygonLineWidth() : null;
                    Intrinsics.checkNotNull((Object)d);
                    int dp$iv = (int)d.doubleValue();
                    boolean $i$f$dpToPx = false;
                    iDocumentScannerPolygonViewController.setPolygonStrokeWidth(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)dp$iv, (DisplayMetrics)$this$dpToPx$iv.getResources().getDisplayMetrics())));
                    break;
                }
                case 38: {
                    ShutterButton shutterButton = $this$applyConfiguration_u24lambda_u2d4.shutterBtn;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object16 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getShutterButtonAutoInnerColor() : null;
                    Intrinsics.checkNotNull((Object)object16);
                    shutterButton.setShutterButtonAutoInnerColor(object16.toSdk());
                    break;
                }
                case 39: {
                    ShutterButton shutterButton = $this$applyConfiguration_u24lambda_u2d4.shutterBtn;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object17 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getShutterButtonAutoOuterColor() : null;
                    Intrinsics.checkNotNull((Object)object17);
                    shutterButton.setShutterButtonAutoOuterColor(object17.toSdk());
                    break;
                }
                case 40: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Boolean bl13 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getShutterButtonHidden() : null;
                    Intrinsics.checkNotNull((Object)bl13);
                    boolean hideShutterButton = bl13;
                    if (!hideShutterButton) break;
                    cameraViewModel2.setShutterButtonHidden(true);
                    $this$applyConfiguration_u24lambda_u2d4.shutterBtn.setVisibility(8);
                    cameraViewModel2.setAutoSnappingEnabled(true);
                    break;
                }
                case 41: {
                    ShutterButton shutterButton = $this$applyConfiguration_u24lambda_u2d4.shutterBtn;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object18 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getShutterButtonManualInnerColor() : null;
                    Intrinsics.checkNotNull((Object)object18);
                    shutterButton.setShutterButtonManualInnerColor(object18.toSdk());
                    break;
                }
                case 42: {
                    ShutterButton shutterButton = $this$applyConfiguration_u24lambda_u2d4.shutterBtn;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object19 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getShutterButtonManualOuterColor() : null;
                    Intrinsics.checkNotNull((Object)object19);
                    shutterButton.setShutterButtonManualOuterColor(object19.toSdk());
                    break;
                }
                case 43: {
                    FinderDocumentScannerCameraView finderDocumentScannerCameraView = cameraBinding.cameraView;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    String string = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getTextHintBadAngles() : null;
                    Intrinsics.checkNotNull((Object)string);
                    finderDocumentScannerCameraView.setHintBadAngles(string);
                    break;
                }
                case 44: {
                    FinderDocumentScannerCameraView finderDocumentScannerCameraView = cameraBinding.cameraView;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    String string = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getTextHintBadAspectRatio() : null;
                    Intrinsics.checkNotNull((Object)string);
                    finderDocumentScannerCameraView.setHintBadAspectRatio(string);
                    break;
                }
                case 45: {
                    FinderDocumentScannerCameraView finderDocumentScannerCameraView = cameraBinding.cameraView;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    String string = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getTextHintNothingDetected() : null;
                    Intrinsics.checkNotNull((Object)string);
                    finderDocumentScannerCameraView.setHintNothingDetected(string);
                    break;
                }
                case 46: {
                    FinderDocumentScannerCameraView finderDocumentScannerCameraView = cameraBinding.cameraView;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    String string = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getTextHintOK() : null;
                    Intrinsics.checkNotNull((Object)string);
                    finderDocumentScannerCameraView.setHintDontMove(string);
                    break;
                }
                case 47: {
                    FinderDocumentScannerCameraView finderDocumentScannerCameraView = cameraBinding.cameraView;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    String string = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getTextHintOffCenter() : null;
                    Intrinsics.checkNotNull((Object)string);
                    finderDocumentScannerCameraView.setHintOffCenter(string);
                    break;
                }
                case 48: {
                    FinderDocumentScannerCameraView finderDocumentScannerCameraView = cameraBinding.cameraView;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    String string = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getTextHintTooDark() : null;
                    Intrinsics.checkNotNull((Object)string);
                    finderDocumentScannerCameraView.setHintTooDark(string);
                    break;
                }
                case 49: {
                    FinderDocumentScannerCameraView finderDocumentScannerCameraView = cameraBinding.cameraView;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    String string = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getTextHintTooNoisy() : null;
                    Intrinsics.checkNotNull((Object)string);
                    finderDocumentScannerCameraView.setHintTooNoisy(string);
                    break;
                }
                case 50: {
                    FinderDocumentScannerCameraView finderDocumentScannerCameraView = cameraBinding.cameraView;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    String string = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getTextHintTooSmall() : null;
                    Intrinsics.checkNotNull((Object)string);
                    finderDocumentScannerCameraView.setHintTooSmall(string);
                    break;
                }
                case 51: {
                    Unit unit;
                    Window window;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object20 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getTopBarBackgroundColor() : null;
                    Intrinsics.checkNotNull((Object)object20);
                    int color5 = object20.toSdk();
                    Window window2 = window = activity.getWindow();
                    if (window2 != null) {
                        window2.addFlags(Integer.MIN_VALUE);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Window window3 = window;
                    if (window3 != null) {
                        window3.setStatusBarColor(color5);
                    }
                    if (Build.VERSION.SDK_INT >= 23 && ColorUtils.calculateLuminance((int)color5) > 0.5) {
                        Window window4 = window;
                        Object object21 = window4 != null ? window4.getDecorView() : null;
                        if (object21 != null) {
                            object21.setSystemUiVisibility(8192);
                        }
                    }
                    $this$applyConfiguration_u24lambda_u2d4.cameraTopToolbar.setBackgroundColor(color5);
                    cameraBinding.cameraView.getPermissionBinding().cameraPermissionView.setBackgroundColor(color5);
                    break;
                }
                case 52: 
                case 53: {
                    int n;
                    int activeColor;
                    int n2;
                    if (jsonParameters.contains((Object)FinderDocumentScannerParameter.TopBarButtonsActiveColor)) {
                        FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                        Object object22 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getTopBarButtonsActiveColor() : null;
                        Intrinsics.checkNotNull((Object)object22);
                        n2 = object22.toSdk();
                    } else {
                        n2 = activeColor = ContextCompat.getColor((Context)((Context)activity), (int)R.color.scanbot_sdk_colorAccent);
                    }
                    if (jsonParameters.contains((Object)FinderDocumentScannerParameter.TopBarButtonsInactiveColor)) {
                        FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                        Object object23 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getTopBarButtonsInactiveColor() : null;
                        Intrinsics.checkNotNull((Object)object23);
                        n = object23.toSdk();
                    } else {
                        n = ContextCompat.getColor((Context)((Context)activity), (int)R.color.scanbot_sdk_camera_tool_button_color_inactive);
                    }
                    int inactiveColor = n;
                    Object $i$f$dpToPx = new int[3][];
                    int[] nArray = new int[]{16842919};
                    $i$f$dpToPx[0] = nArray;
                    nArray = new int[]{0x10100A0};
                    $i$f$dpToPx[1] = nArray;
                    nArray = new int[]{-16842912};
                    $i$f$dpToPx[2] = nArray;
                    int[][] nArrayArray = $i$f$dpToPx;
                    $i$f$dpToPx = new int[3];
                    $i$f$dpToPx[0] = (int[])activeColor;
                    $i$f$dpToPx[1] = (int[])activeColor;
                    $i$f$dpToPx[2] = (int[])inactiveColor;
                    ColorStateList colorList = new ColorStateList((int[][])nArrayArray, (int[])$i$f$dpToPx);
                    $this$applyConfiguration_u24lambda_u2d4.flashIcon.setColorFilter(colorList);
                    $this$applyConfiguration_u24lambda_u2d4.cancel.setColorFilter(colorList, activeColor);
                    cameraBinding.cameraView.getPermissionBinding().cameraPermissionDescription.setTextColor(activeColor);
                    cameraBinding.cameraView.getPermissionBinding().enableCameraBtn.setTextColor(activeColor);
                    cameraBinding.cameraView.getPermissionBinding().cameraPermissionIcon.setColorFilter(activeColor);
                    break;
                }
                case 54: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Boolean bl14 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getUseButtonsAllCaps() : null;
                    Intrinsics.checkNotNull((Object)bl14);
                    boolean isAllCaps = bl14;
                    $this$applyConfiguration_u24lambda_u2d4.cancel.setAllCaps(isAllCaps);
                    cameraBinding.cameraView.getPermissionBinding().enableCameraBtn.setAllCaps(isAllCaps);
                    break;
                }
                case 55: {
                    IDocumentScannerViewCameraConfiguration iDocumentScannerViewCameraConfiguration = cameraBinding.cameraView.getBinding().documentScannerView.getCameraConfiguration();
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Boolean bl15 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getTouchToFocusEnabled() : null;
                    Intrinsics.checkNotNull((Object)bl15);
                    iDocumentScannerViewCameraConfiguration.setAutoFocusOnTouch(bl15.booleanValue());
                    break;
                }
                case 56: {
                    Drawable drawable = $this$applyConfiguration_u24lambda_u2d4.hint.getBackground();
                    Intrinsics.checkNotNull((Object)drawable, (String)"null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                    GradientDrawable gradient = (GradientDrawable)drawable;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object24 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getUserGuidanceBackgroundColor() : null;
                    Intrinsics.checkNotNull((Object)object24);
                    int color6 = object24.toSdk();
                    int[] $i$f$dpToPx = new int[]{color6, color6};
                    int[] colors = $i$f$dpToPx;
                    Drawable drawable2 = gradient.mutate();
                    Intrinsics.checkNotNull((Object)drawable2, (String)"null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                    GradientDrawable nGradient = (GradientDrawable)drawable2;
                    nGradient.setColors(colors);
                    break;
                }
                case 57: {
                    TextView textView = $this$applyConfiguration_u24lambda_u2d4.hint;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Double d = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getUserGuidanceFontSize() : null;
                    Intrinsics.checkNotNull((Object)d);
                    textView.setTextSize((float)d.doubleValue());
                    break;
                }
                case 58: {
                    TextView textView = $this$applyConfiguration_u24lambda_u2d4.hint;
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object25 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getUserGuidanceTextColor() : null;
                    Intrinsics.checkNotNull((Object)object25);
                    textView.setTextColor(object25.toSdk());
                    break;
                }
                case 59: {
                    FinderDocumentScannerJsonConfiguration finderDocumentScannerJsonConfiguration = this.config;
                    Object object26 = finderDocumentScannerJsonConfiguration != null ? finderDocumentScannerJsonConfiguration.getPhotoQualityPrioritization() : null;
                    Intrinsics.checkNotNull((Object)object26);
                    switch (WhenMappings.$EnumSwitchMapping$0[object26.ordinal()]) {
                        case 1: {
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                        case 3: {
                            $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getCameraConfiguration().setForceMaxSnappingSize(true);
                            $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getCameraConfiguration().setForceMaxSnappingQuality(true);
                        }
                    }
                }
            }
        }
        $this$forEach$iv = (Iterable)nativeParameters;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FinderDocumentScannerNativeParameter param = (FinderDocumentScannerNativeParameter)element$iv;
            boolean bl16 = false;
            FinderDocumentScannerNativeParameter finderDocumentScannerNativeParameter = param;
            if (finderDocumentScannerNativeParameter instanceof FinderDocumentScannerNativeParameter.DelayAfterFocusCompleteMs) {
                $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getCameraConfiguration().setDelayAfterFocusCompleteMs(((FinderDocumentScannerNativeParameter.DelayAfterFocusCompleteMs)param).getValue());
                continue;
            }
            if (finderDocumentScannerNativeParameter instanceof FinderDocumentScannerNativeParameter.DrawPolygonShadows) {
                $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getPolygonConfiguration().setPolygonDrawShadows(((FinderDocumentScannerNativeParameter.DrawPolygonShadows)param).getValue());
                continue;
            }
            if (finderDocumentScannerNativeParameter instanceof FinderDocumentScannerNativeParameter.ForceMaxSnappingSize) {
                $this$applyConfiguration_u24lambda_u2d4.documentScannerView.getCameraConfiguration().setForceMaxSnappingSize(((FinderDocumentScannerNativeParameter.ForceMaxSnappingSize)param).getValue());
                continue;
            }
            if (finderDocumentScannerNativeParameter instanceof FinderDocumentScannerNativeParameter.HardwareSnapButton) {
                cameraViewModel2.setHardwareButtonKeyCode(((FinderDocumentScannerNativeParameter.HardwareSnapButton)param).getValue());
                continue;
            }
            if (!(finderDocumentScannerNativeParameter instanceof FinderDocumentScannerNativeParameter.ShutterSoundEnabled)) continue;
            cameraViewModel2.setShutterSoundEnabled(((FinderDocumentScannerNativeParameter.ShutterSoundEnabled)param).getValue());
        }
        Object object27 = this.config;
        boolean progressEnabled = object27 != null && (object27 = ((FinderDocumentScannerJsonConfiguration)object27).getAutoSnapProgressEnabled()) != null ? (Boolean)object27 : true;
        Object object28 = this.config;
        boolean polygonEnabled = object28 != null && (object28 = ((FinderDocumentScannerJsonConfiguration)object28).getPolygonEnabled()) != null ? (Boolean)object28 : true;
        DocumentScannerView documentScannerView = $this$applyConfiguration_u24lambda_u2d4.documentScannerView;
        Intrinsics.checkNotNullExpressionValue((Object)documentScannerView, (String)"documentScannerView");
        this.applyFinderPolygonProgressParams(documentScannerView, progressEnabled, polygonEnabled);
    }

    private final void applyFinderPolygonProgressParams(DocumentScannerView documentScannerView, boolean progressEnabled, boolean polygonEnabled) {
        boolean polygonAutoSnapProgressEnabled = progressEnabled && polygonEnabled;
        boolean finderAutoSnapProgressEnabled = progressEnabled && !polygonEnabled;
        documentScannerView.getPolygonConfiguration().setPolygonAutoSnapProgressEnabled(polygonAutoSnapProgressEnabled);
        documentScannerView.getFinderViewController().setAutoSnapProgressEnabled(finderAutoSnapProgressEnabled);
    }

    private final String prepareAccessibilityDescription(String label, String hint) {
        return label + '\n' + hint;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[JsonCapturePhotoQualityPrioritization.values().length];
            nArray[JsonCapturePhotoQualityPrioritization.SPEED.ordinal()] = 1;
            nArray[JsonCapturePhotoQualityPrioritization.BALANCED.ordinal()] = 2;
            nArray[JsonCapturePhotoQualityPrioritization.QUALITY.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FinderDocumentScannerParameter.values().length];
            nArray[FinderDocumentScannerParameter.Version.ordinal()] = 1;
            nArray[FinderDocumentScannerParameter.Screen.ordinal()] = 2;
            nArray[FinderDocumentScannerParameter.AcceptedAngleScore.ordinal()] = 3;
            nArray[FinderDocumentScannerParameter.AcceptedSizeScore.ordinal()] = 4;
            nArray[FinderDocumentScannerParameter.AccessibilityConfiguration.ordinal()] = 5;
            nArray[FinderDocumentScannerParameter.AutoSnapProgressColor.ordinal()] = 6;
            nArray[FinderDocumentScannerParameter.AutoSnapProgressLineWidth.ordinal()] = 7;
            nArray[FinderDocumentScannerParameter.AutoSnappingEnabled.ordinal()] = 8;
            nArray[FinderDocumentScannerParameter.AutoSnappingSensitivity.ordinal()] = 9;
            nArray[FinderDocumentScannerParameter.CameraBackgroundColor.ordinal()] = 10;
            nArray[FinderDocumentScannerParameter.CameraModule.ordinal()] = 11;
            nArray[FinderDocumentScannerParameter.CameraOverlayColor.ordinal()] = 12;
            nArray[FinderDocumentScannerParameter.CameraPreviewMode.ordinal()] = 13;
            nArray[FinderDocumentScannerParameter.CancelButtonTitle.ordinal()] = 14;
            nArray[FinderDocumentScannerParameter.DefaultPageFilter.ordinal()] = 15;
            nArray[FinderDocumentScannerParameter.DocumentImageSizeLimit.ordinal()] = 16;
            nArray[FinderDocumentScannerParameter.EnableCameraButtonTitle.ordinal()] = 17;
            nArray[FinderDocumentScannerParameter.EnableCameraExplanationText.ordinal()] = 18;
            nArray[FinderDocumentScannerParameter.FinderAspectRatio.ordinal()] = 19;
            nArray[FinderDocumentScannerParameter.FinderEnabled.ordinal()] = 20;
            nArray[FinderDocumentScannerParameter.FinderLineColor.ordinal()] = 21;
            nArray[FinderDocumentScannerParameter.FinderLineWidth.ordinal()] = 22;
            nArray[FinderDocumentScannerParameter.FlashButtonHidden.ordinal()] = 23;
            nArray[FinderDocumentScannerParameter.FlashEnabled.ordinal()] = 24;
            nArray[FinderDocumentScannerParameter.ForceUserGuidance.ordinal()] = 25;
            nArray[FinderDocumentScannerParameter.IgnoreBadAspectRatio.ordinal()] = 26;
            nArray[FinderDocumentScannerParameter.ImageScale.ordinal()] = 27;
            nArray[FinderDocumentScannerParameter.LockDocumentAspectRatioToFinder.ordinal()] = 28;
            nArray[FinderDocumentScannerParameter.OrientationLockMode.ordinal()] = 29;
            nArray[FinderDocumentScannerParameter.PolygonBackgroundColor.ordinal()] = 30;
            nArray[FinderDocumentScannerParameter.PolygonBackgroundColorOK.ordinal()] = 31;
            nArray[FinderDocumentScannerParameter.PolygonColor.ordinal()] = 32;
            nArray[FinderDocumentScannerParameter.PolygonColorOK.ordinal()] = 33;
            nArray[FinderDocumentScannerParameter.PolygonCornerRadius.ordinal()] = 34;
            nArray[FinderDocumentScannerParameter.AutoSnapProgressEnabled.ordinal()] = 35;
            nArray[FinderDocumentScannerParameter.PolygonEnabled.ordinal()] = 36;
            nArray[FinderDocumentScannerParameter.PolygonLineWidth.ordinal()] = 37;
            nArray[FinderDocumentScannerParameter.ShutterButtonAutoInnerColor.ordinal()] = 38;
            nArray[FinderDocumentScannerParameter.ShutterButtonAutoOuterColor.ordinal()] = 39;
            nArray[FinderDocumentScannerParameter.ShutterButtonHidden.ordinal()] = 40;
            nArray[FinderDocumentScannerParameter.ShutterButtonManualInnerColor.ordinal()] = 41;
            nArray[FinderDocumentScannerParameter.ShutterButtonManualOuterColor.ordinal()] = 42;
            nArray[FinderDocumentScannerParameter.TextHintBadAngles.ordinal()] = 43;
            nArray[FinderDocumentScannerParameter.TextHintBadAspectRatio.ordinal()] = 44;
            nArray[FinderDocumentScannerParameter.TextHintNothingDetected.ordinal()] = 45;
            nArray[FinderDocumentScannerParameter.TextHintOK.ordinal()] = 46;
            nArray[FinderDocumentScannerParameter.TextHintOffCenter.ordinal()] = 47;
            nArray[FinderDocumentScannerParameter.TextHintTooDark.ordinal()] = 48;
            nArray[FinderDocumentScannerParameter.TextHintTooNoisy.ordinal()] = 49;
            nArray[FinderDocumentScannerParameter.TextHintTooSmall.ordinal()] = 50;
            nArray[FinderDocumentScannerParameter.TopBarBackgroundColor.ordinal()] = 51;
            nArray[FinderDocumentScannerParameter.TopBarButtonsInactiveColor.ordinal()] = 52;
            nArray[FinderDocumentScannerParameter.TopBarButtonsActiveColor.ordinal()] = 53;
            nArray[FinderDocumentScannerParameter.UseButtonsAllCaps.ordinal()] = 54;
            nArray[FinderDocumentScannerParameter.TouchToFocusEnabled.ordinal()] = 55;
            nArray[FinderDocumentScannerParameter.UserGuidanceBackgroundColor.ordinal()] = 56;
            nArray[FinderDocumentScannerParameter.UserGuidanceFontSize.ordinal()] = 57;
            nArray[FinderDocumentScannerParameter.UserGuidanceTextColor.ordinal()] = 58;
            nArray[FinderDocumentScannerParameter.PhotoQualityPrioritization.ordinal()] = 59;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

